/*.......................................................................
 * Clears the window and pixmap.
 *
 * Input:
 *  xw    XWdev *  The MFPLOT /xw device descriptor.
 * Output:
 *  return  int    0 - OK.
 *                 1 - Error.
 */
static int xw_clear ( XWdev *xw ) {
  int ci; /* color index */
  unsigned long fg;     /* Saved foreground color */
  /*
   * Device error?
   */
  if ( xw->bad_device ) return 1;
  /*
   * We are about to change the current foreground color, so save the
   * current value to be re-instated shortly.
   */
  fg = xw->gcv.foreground;

  /* Select the background color */
  ci = 0; /* 0 is always the background color, whatever the mode used
             (i.e. white-on-black or black-on-white) */
  xw->gcv.foreground = xw->color.pixel[ci];
  XSetForeground ( xw->display, xw->gc2, xw->gcv.foreground );

  /*
   * Clears the main pixmap by drawing an opaque rectangle over it
   * in the background color.
   * Uses the 2nd GC, which never have a ClipMask.
   */
  if ( xw->pixmap != None ) {
    XFillRectangle ( xw->display, xw->pixmap, xw->gc2, 0, 0,
                     xw->geom.width, xw->geom.height );
    if ( xw->bad_device ) return 1;
  };
  /*
   * Re-instates the foreground color.
   */
  xw->gcv.foreground = fg;
  XSetForeground ( xw->display, xw->gc2, xw->gcv.foreground );
  if ( xw->bad_device ) return 1;
  /*
   * Marks the pixmap as unmodified.
   */
  xw->update.modified = 0;
  /*
   * Clears the window itself.
   */
  XClearWindow ( xw->display, xw->window );
  XFlush ( xw->display );
  if ( xw->bad_device ) return 1;
  return 0;
}

