/*.......................................................................
 * Checks that an auxiliary pixmap exists and has the same size as that
 * of xw->pixmap (width or height NULL) or as a given size.
 * On the contrary, deallocates it and reallocate a new one.
 *-----------------------------------------------------------------------
 *
 * Input:
 *  xw      XWdev *   The MFPLOT /xw device descriptor.
 *  aux_ID  int       The number of the aux pixmap (1 or 2)
 *
 */

static void xw_checks_pixmap_aux ( XWdev *xw, Pixmap *pixmap,
                                   unsigned int width, unsigned int height,
                                   int aux_ID ) {

  Window root;
  int x, y;
  unsigned int width_0, height_0, border, depth;
  unsigned int width_aux, height_aux;

  /*
   * Device error?
   */
  if ( xw->bad_device ) return;

  if ( xw->pixmap == None ) {
    printf("X11 driver: xw_checks_pixmap_aux: internal ERROR\n");
    printf("            -> main pixmap should exist!\n");
#if defined _GNU_GFC
#ifndef _OPTIM
    printf( "  Traceback:\n ");
    _gfortran_backtrace();
#endif
#endif
  }

  /* Gets width and height of the main pixmap (and also root) */
  XGetGeometry ( xw->display, xw->pixmap, &root, &x, &y,
                 &width_0, &height_0, &border, &depth );

  if ( width != 0 && height != 0 ) {
    width_0  = width;
    height_0 = height;
  }

  if ( *pixmap == None ) {
    *pixmap = XCreatePixmap ( xw->display, root, width_0, height_0,
                              (unsigned) xw->color.vi->depth );
  } else {
    XGetGeometry ( xw->display, *pixmap, &root, &x, &y,
                   &width_aux, &height_aux, &border, &depth );
    if ( width_0 != width_aux || height_0 != height_aux ) {
      XFreePixmap( xw->display, *pixmap );
      *pixmap = XCreatePixmap ( xw->display, root, width_0, height_0,
                               (unsigned) xw->color.vi->depth );
      /* If an XftDraw surface was attached to this aux pixmap, update it */
      if( aux_ID == 1 ) {
        if( xw->xftdraw_pixmap_aux_1 ) {
          XftDrawChange ( xw->xftdraw_pixmap_aux_1, xw->pixmap_aux_1 );
        }
      } else { /* aux_ID == 2 */
        if( xw->xftdraw_pixmap_aux_2 ) {
          XftDrawChange ( xw->xftdraw_pixmap_aux_2, xw->pixmap_aux_2 );
        }
      }
    }
  }

}

