/*.......................................................................
 * Front end to XCheckWindowEvent() to check and return for the next event
 * that matches the given event_mask, without blocking if no matching event
 * is there and while also checking for DestroyNotify events on said window.
 *
 * Input:
 *  xw        XWdev *  The MFPLOT /xw device descriptor.
 *  window   Window    The window on which to watch for events.
 *  event_mask long    The bit mask of event types wanted.
 * Input/Output:
 *  event    XEvent *  The event structure for the returned event.
 * Output:
 *  return      int    0 - No matching event.
 *                     1 - Got an event that matches the mask.
 */
static int xw_check_window_event (XWdev *xw, Window window, long event_mask,
                                  XEvent *event ) {
  int want_structure = 0;  /* True if the caller selects StructureNotifyMask */
  /*
   * Checks that we still have a window.
   */
  if(xw->bad_device) return 1;
  /*
   * Did the user also want StructureNotifyMask events?
   */
  want_structure = event_mask & StructureNotifyMask;
  /*
   * We also want DestroyNotify events.
   */
  event_mask |= StructureNotifyMask;
  /*
   * Waits for the next event.
   */
  while(XCheckWindowEvent(xw->display, window, event_mask, event)==True) {
    switch(event->type) {
    case DestroyNotify:
      if(window == xw->window) {  /* Have we lost the plot window? */
        xw_bad_device(xw);
        return want_structure;
      } else if(want_structure) {
        return 1;
      };
      break;
    case CirculateNotify:
    case ConfigureNotify:
      if(want_structure)  /* Ignores unselected StructureNotifyMask events */
        return 1;
      break;
    default:
      return 1;  /* One of the requested events was found */
    };
  };
  return 0;
}

