/*.......................................................................
 * Trims a coordinate to lie within the current pixmap and window area.
 * This prevents the cursor being displayed or returned for a position
 * outside the currently visible window and pixmap areas.
 *
 * Input:
 *  xp    XPoint *   The point to be limited.
 * Output:
 *  return   int     0 - OK.
 *                   1 - Error.
 */
static int xw_bound_cursor ( XWdev *xw, XPoint *xp ) {
  XWindowAttributes attr;  /* Current window attributes */
  int xmax, ymax;          /* Max usable X and Y coordinates */
  /*
   * Device error?
   */
  if(xw->bad_device) return 1;
  /*
   * Gets the current window dimensions.
   */
  XGetWindowAttributes(xw->display, xw->window, &attr);
  if(xw->bad_device) return 1;
  /*
   * With NorthWest pixmap gravity, coordinates 0,0 are always visible at the
   * top left corner of the plot.
   */
  if(xp->x < 0) xp->x = 0;
  if(xp->y < 0) xp->y = 0;
  /*
   * Determines the max X and Y coordinates that fall both within the pixmap
   * and the window.
   */
  xmax = ((xw->geom.width < attr.width) ? xw->geom.width : attr.width) - 1;
  ymax = ((xw->geom.height < attr.height) ? xw->geom.height : attr.height) - 1;
  /*
   * Limits the coordinates to the above range.
   */
  if(xp->x > xmax) xp->x = xmax;
  if(xp->y > ymax) xp->y = ymax;
  return 0;
}

