/*.......................................................................
 * Private function of xw_move_rect_in_pixmap().
 *-----------------------------------------------------------------------
 */

static Pixmap xw_bitmap_from_pixmap ( XWdev *xw, Pixmap pixmap ) {

  Window root;
  int x, y;
  unsigned width, height, border, depth;

  XImage *image;
  Pixmap bitmap;
  int rowbytes;
  unsigned long white = 0xFFFFFF, black = 0x0, background;

  if ( BLACK_ON_WHITE ) {
    background = white;
  } else {
    background = black;
  }

  /* Gets width and height from pixmap */
  XGetGeometry ( xw->display, pixmap, &root, &x, &y,
                 &width, &height, &border, &depth );

  image = XGetImage ( xw->display, pixmap, 0, 0, width, height,
                      AllPlanes, XYPixmap );
  rowbytes = (image->width + 7)/8;
  void *p = calloc ( rowbytes, image->height );
  char *data = (char *)(p);

  for ( y = 0; y<image->height; ++y ) {
    for ( x = 0; x<image->width; ++x ) {
      int ib = x & 7;
      unsigned long pixel = XGetPixel ( image, x, y );
      if ( pixel != background ) {
        data [y*rowbytes + x/8] |= 1 << ib;
      }
    }
  }
  bitmap = XCreateBitmapFromData ( xw->display, root, data,
                                   image->width, image->height );
  free ( data );
  XDestroyImage ( image );
  return bitmap;
}

