/*.......................................................................
 * Finds the bounding box of a pixmap, i.e., the values (xmin, ymin,
 * xmax, ymax) outside of which we only find the background color.
 * If the pixmap is totally filled with the background color, the
 * BBox is left undefined, and 'empty' is set to 1.
 *-----------------------------------------------------------------------
 *
 */

static void xw_bbox_of_pixmap ( XWdev *xw, Pixmap pixmap,
                               int *xmin, int *ymin, int *xmax, int *ymax,
                               int *empty )
{

  Window root;
  int x, y;
  unsigned width, height, border, depth;
  int found;

  XImage *image;
  unsigned long white = 0xFFFFFF, black = 0x0, background, pixel;

  if ( BLACK_ON_WHITE ) {
    background = white;
  } else {
    background = black;
  }

  /* Gets width and height from pixmap */
  XGetGeometry ( xw->display, pixmap, &root, &x, &y,
                 &width, &height, &border, &depth );

  image = XGetImage ( xw->display, pixmap, 0, 0, width, height,
                      AllPlanes, XYPixmap );

  *empty = 1;

  found = 0;
  for ( x = 0; x<image->width; x++ ) {
    for ( y = 0; y<image->height; y++ ) {
      pixel = XGetPixel ( image, x, y );
      if ( pixel != background ) {
        *xmin = x;
        *empty = 0;
        found = 1;
        break;
      }
    }
    if ( found ) break;
  }

  found = 0;
  for ( y = 0; y<image->height; y++ ) {
    for ( x = 0; x<image->width; x++ ) {
      pixel = XGetPixel ( image, x, y );
      if ( pixel != background ) {
        *ymin = y;
        *empty = 0;
        found = 1;
        break;
      }
    }
    if ( found ) break;
  }

  found = 0;
  for ( x = image->width-1; x>=0; x-- ) {
    for ( y = 0; y<image->height; y++ ) {
      pixel = XGetPixel ( image, x, y );
      if ( pixel != background ) {
        *xmax = x;
        *empty = 0;
        found = 1;
        break;
      }
    }
    if ( found ) break;
  }

  found = 0;
  for ( y = image->height-1; y>=0; y-- ) {
    for ( x = 0; x<image->width; x++ ) {
      pixel = XGetPixel ( image, x, y );
      if ( pixel != background ) {
        *ymax = y;
        *empty = 0;
        found = 1;
        break;
      }
    }
    if ( found ) break;
  }

  XDestroyImage (image);
}

