/*.......................................................................
 * After a fatal error has occured, this function should be called to
 * mark the specified device as unusable. It emits an error message
 * and sets xw->bad_device=1.
 *
 * Input:
 *  xw      XWdev *  The descriptor of the device on which the error
 *                   occurred.
 * Output:
 *  xw->bad_device   This flag is set to 1.
 *  return    int    Always 1 (intended as a boolean to say that the device
 *                   is unusable). This can be used as the return value for
 *                   functions that use 1 to denote an error return. E.g.:
 *                         if(error_occurred)
 *                            return xw_bad_device(xw);
 */

static int xw_bad_device ( XWdev *xw ) {
  /*
   * Only reports an error if this is the first time that this function
   * has been called on this device.
   */
  if(xw && !xw->bad_device) {
    fprintf( stderr, "%s: Lost MFPLOT window %d.\n", XW_IDENT, xw->number );
    xw->bad_device = 1;
#if defined _GNU_GFC
#ifndef _OPTIM
    printf( "  Traceback requested from MFPLOT (xw_bad_device):\n ");
    _gfortran_backtrace();
#endif
#endif
  };
  return 1;
}

