/*.......................................................................
 * Animated dashed lines for a number of predefined hotspots
 * (must be called in a thread)
 */

void * xw_animate_dashed_multispot ( void *data ) {

  struct my_struct_arg *arg = data;
  XWdev *xw = arg->xw;

  struct timespec ts = {0, 200000000L }; /* 0.2 sec */
  int dash_offset = 0;
  static char dash_list[] = { 5, 5 };
  int list_length = 2;
  GC gc;

  int i;
  int ispot[3], jspot[3], radius = 8, two_pi = 23040;

  ADC_finished = 0;

  /* Position of the three spots (base-middle-end) */
  /* Arrow base */
  ispot[0] = ARROW_START.x;
  jspot[0] = ARROW_START.y;
  /* Arrow head */
  ispot[2] = ARROW_END.x;
  jspot[2] = ARROW_END.y;
  /* Arrow middle */
  ispot[1] = (ispot[0]+ispot[2])/2;
  jspot[1] = (jspot[0]+jspot[2])/2;

  gc = XCreateGC ( xw->display, xw->window, 0, NULL ); /* 0 -> use defaults */
  if ( BLACK_ON_WHITE ) {
    XSetForeground ( xw->display, gc, 0xFFFFFF ); /* white */
  } else {
    XSetForeground ( xw->display, gc, 0x000000 ); /* black */
  }

  /* draw continuous circles */
  for ( i = 0; i<3; i++ ) {
    XDrawArc ( xw->display, xw->window, gc, ispot[i]-radius, jspot[i]-radius,
               2*radius, 2*radius, 0, two_pi );
  }

  XSetForeground ( xw->display, gc, 0xB0B0B0 ); /* medium grey */
  XSetLineAttributes ( xw->display, gc, 1, LineOnOffDash, CapRound, JoinRound );
  XSetDashes ( xw->display, gc, dash_offset, dash_list, list_length );

  /* draw again circles but using dashed line */
  for ( i = 0; i<3; i++ ) {
    XDrawArc ( xw->display, xw->window, gc, ispot[i]-radius, jspot[i]-radius,
               2*radius, 2*radius, 0, two_pi );
  }

  XFlush ( xw->display );

  dash_offset = 0;
  while (1) {

    if ( ADC_finished ) {
      break;
    }

    /* Update position of the three spots (base-middle-end) */
    /* Arrow base */
    ispot[0] = ARROW_START.x;
    jspot[0] = ARROW_START.y;
    /* Arrow head */
    ispot[2] = ARROW_END.x;
    jspot[2] = ARROW_END.y;
    /* Arrow middle */
    ispot[1] = (ispot[0]+ispot[2])/2;
    jspot[1] = (jspot[0]+jspot[2])/2;

    if ( BLACK_ON_WHITE ) {
      XSetForeground ( xw->display, gc, 0xFFFFFF );
    } else {
      XSetForeground ( xw->display, gc, 0x000000 );
    }

    for ( i = 0; i<3; i++ ) {
      XDrawArc ( xw->display, xw->window, gc, ispot[i]-radius, jspot[i]-radius,
                 2*radius, 2*radius, 0, two_pi );
    }

    XSetForeground ( xw->display, gc, 0xB0B0B0 );
    dash_offset += 2;
    if ( dash_offset >= 2*5 ) dash_offset = 0;
    XSetDashes ( xw->display, gc, dash_offset, dash_list, list_length );

    for ( i = 0; i<3; i++ ) {
      XDrawArc ( xw->display, xw->window, gc, ispot[i]-radius, jspot[i]-radius,
                 2*radius, 2*radius, 0, two_pi );
    }

    XFlush ( xw->display );
    nanosleep ( &ts, NULL );

  }

  XFreeGC( xw->display, gc );

  free(arg);

  return NULL;

}

