/*.......................................................................
 * Animated dashed lines for contouring an Graphic Object
 * (must be called in a thread)
 */

void * xw_animate_dashed_contour ( void *data ) {

  struct my_struct_arg *arg = data;
  XWdev *xw = arg->xw;

  struct timespec ts = {0, 200000000L }; /* 0.2 sec */
  int dash_offset = 0;
  static char dash_list[] = { 5, 5 };
  int list_length = 2;
  GC gc;

  ADC_finished = 0;

  gc = XCreateGC ( xw->display, xw->window, 0, NULL ); /* 0 -> use defaults */
  if ( BLACK_ON_WHITE ) {
    XSetForeground ( xw->display, gc, 0xFFFFFF ); /* white */
  } else {
    XSetForeground ( xw->display, gc, 0x000000 ); /* black */
  }
  XDrawRectangle ( xw->display, xw->window, gc,
                   ADC_xmin, ADC_ymin, ADC_width, ADC_height );
  XSetForeground ( xw->display, gc, 0xB0B0B0 ); /* medium grey */
  XSetLineAttributes ( xw->display, gc, 1, LineOnOffDash, CapRound, JoinRound );
  XSetDashes ( xw->display, gc, dash_offset, dash_list, list_length );
  XDrawRectangle ( xw->display, xw->window, gc,
                   ADC_xmin, ADC_ymin, ADC_width, ADC_height );
  XFlush ( xw->display );

  dash_offset = 0;
  while (1) {

    if ( ADC_finished ) {
      break;
    }

    if ( BLACK_ON_WHITE ) {
      XSetForeground ( xw->display, gc, 0xFFFFFF );
    } else {
      XSetForeground ( xw->display, gc, 0x000000 );
    }
    XDrawRectangle ( xw->display, xw->window, gc,
                     ADC_xmin, ADC_ymin, ADC_width, ADC_height );
    XSetForeground ( xw->display, gc, 0xB0B0B0 );
    dash_offset += 2;
    if ( dash_offset >= 2*5 ) dash_offset = 0;
    XSetDashes ( xw->display, gc, dash_offset, dash_list, list_length );
    XDrawRectangle ( xw->display, xw->window, gc,
                     ADC_xmin, ADC_ymin, ADC_width, ADC_height );
    XFlush ( xw->display );
    nanosleep ( &ts, NULL );

  }

  XFreeGC( xw->display, gc );

  free(arg);

  return NULL;

}

