/*.......................................................................
 * Adds to the set of events to be caught.
 *
 * Input:
 *  xw    XWdev *  The MFPLOT /xw device descriptor.
 *  events long    The bit mask of events to be added to those already
 *                 being selected.
 * Output:
 *  return  int    0 - OK.
 *                 1 - Error.
 */
static int xw_add_events ( XWdev *xw, long events ) {
  /*
   * Device error?
   */
  if(xw->bad_device) return 1;
  /*
   * Gets the union of the new events with the current event mask.
   */
  xw->event.mask |= events;
  /*
   * Registers the modified selection with the server.
   */
  XSync(xw->display, False);
  if(xw->bad_device) return 1;
  xw->last_error = 0;
  XSelectInput(xw->display, xw->window, xw->event.mask);
  if(xw->bad_device) return 1;
  /*
   * Forces the new selections through to the server and check for access
   * errors that indicate that ButtonPress's are currently selected by
   * another client.
   */
  XSync(xw->display, False);
  if(xw->bad_device) return 1;
  if(xw->last_error == BadAccess) {
    /*
     * Only one client can select ButtonPress events. If another client
     * already has them selected, then the above XSelectInputs() will have
     * generated an error and the event mask will not have been installed.
     */
    if(xw->event.mask & ButtonPressMask) {
      if(!xw->event.no_buttons) {
        fprintf( stderr,
                 "%s: Failed to acquire pointer buttons - use keys A,D,X.\n",
                 XW_IDENT );
      };
      xw->event.no_buttons = 1;
    };
    /*
     * Retries, but with the events that could have caused the BadAccess
     * removed.
     */
    xw->event.mask &= ~(SubstructureRedirectMask | ResizeRedirectMask |
                        ButtonPressMask);
    XSelectInput(xw->display, xw->window, xw->event.mask);
    if(xw->bad_device) return 1;
    XSync(xw->display, False);
    if(xw->bad_device) return 1;
  };
  /*
   * Have we successfully acquired ButtonPress events?
   */
  if(xw->event.mask & ButtonPressMask)
    xw->event.no_buttons = 0;
  return 0;
}

