/*.......................................................................
 * Converts from window pixel coordinates to MFPLOT coordinates, in a
 * form that can be returned to MFPLOT via ibuf[].
 *
 * Input:
 *  xw      XWdev *   The MFPLOT /xw device descriptor.
 *  xp     XPoint *   The window pixel-coordinates to be converted.
 * Output:
 *  xy        int [2] Output array of two integers in which to place the
 *                    MFPLOT coordinates, arranged as x followed by y.
 */
static void xw_XPoint_to_xy ( XWdev *xw, XPoint *xp, int *xy ) {
  xy[0] = xp->x - xw->geom.xmin;
  xy[1] = xw->geom.ymax - xp->y;
}

