/*
 * Allow x11_driver to be callable by FORTRAN using the two commonest calling
 * conventions. Both conventions append length arguments for each FORTRAN
 * string at the end of the argument list, and convert the name to
 * lower-case, but one post-pends an underscore to the function name
 * (UNDERSCORE) while the other doesn't. For other calling conventions,
 * you must change this, or write a C wrapper routine to call x11_driver() or
 * x11_driver_().
 */
#ifdef UNDERSCORE
#define X11_DRIVER x11_driver_
#define CALL_MF_PGTBOX_FROM_X11_DRIVER call_mf_pgtbox_from_x11_driver_
#define CALL_MF_PGSCH_FROM_X11_DRIVER call_mf_pgsch_from_x11_driver_
#else
#define X11_DRIVER x11_driver
#define CALL_MF_PGTBOX_FROM_X11_DRIVER call_mf_pgtbox_from_x11_driver
#define CALL_MF_PGSCH_FROM_X11_DRIVER call_mf_pgsch_from_x11_driver
#endif

#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <math.h>

#include <fcntl.h>
#include <unistd.h>
#include <stdbool.h>

/* X-Window include files */

#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <X11/keysym.h>
#include <X11/Xatom.h>

#include "cursors/closedhand.xbm"
#include "cursors/closedhand_mask.xbm"
#include "cursors/openhand.xbm"
#include "cursors/openhand_mask.xbm"
#include "cursors/resize.xbm"
#include "cursors/resize_mask.xbm"
#include "cursors/watch.xbm"
#include "cursors/watch_mask.xbm"
#include "cursors/zoom.xbm"
#include "cursors/zoom_mask.xbm"
#include "cursors/transparent.xbm"
#include "cursors/transparent_mask.xbm"

/* Xft_EC comes from libXft: a useful library to use antialiased fonts in X11;
 * it uses FreeType for the rendering (and FontConfig) */
#include "Xft.h"

/* Animated Dashed Contour uses threads */
#include <time.h>
#include <pthread.h>

#define XW_MAX_COLORS 4176    /* must have the same value in mfxwin_server */

/* Number of pre-defined MFPLOT colors : 16 old PGPLOT colors +
 * 7 colors from Matlab old + 7 colors from Matlab new (default) +
 * 12 colors from Breeze colortable of LibreOffice Draw */
#define NCOLORS 42

#define XW_IMAGE_LEN 4096     /* Length of the line-of-pixels buffer */
#define COLORMULT 65535       /* Normalized color intensity multiplier
                               * (value defined by the X11 standard */

//int usleep();    already defined in unistd.h
//int setenv();    already defined in stdlib.h

/* global symbols */

/* code for black_on_white */
/*   default value is black on white */
static int BLACK_ON_WHITE = 1;

/* Figure number added in the window title */
static int FIGURE_NUM_IN_TITLE = 1;

/* name of the executable */
/*   set by opcode: 59 */
static char EXECUTABLE_NAME[128] = "";

/* title of the figure */
/*   set by opcode: 59 */
static char TITLE_DESCRIPTION[128] = "";

/* multi-purpose strings */
static char FILENAME_TMP[256] = "";
static char COLORNAME_TMP[32] = "";

/* MUESLI (not X11) window ID */
static int MF_WIN_ID = 0;

static Window MF_TERMINAL_X11_ID = 0; /* X11 window ID of the terminal */

/* Ximage for reading pixels on screen */
/*   it is allocated in 'xw_get_image_line_RGB' */
static XImage *EC_ximage;

/* TODO: make these numbers automatically computed! */
/* Height of the window title (Ubuntu)
 * (depends on resolution and on the Window Manager) */
static unsigned int XW_WM_TITLE_HEIGHT = 28;

static int CTRL_KEY_DOWN = 0; /* memorise the CTRL key state */
static int CTRL_KEY_DOWN_OLD;
static double X_OUT_WLD_COORD = 0, Y_OUT_WLD_COORD = 0;
static int READ_CURSOR_VALID;

/* flag */
static int rect_inside;

static double xft_angle;
static char xft_fontname[80];
static int xft_clipping, xft_string_utf8;
static int last_color_index = -1; /* foreground text color */

/* Keep a float value instead an integer one, because we have to use
 * this value in arithmetic operations (sqrt). This value is set at
 * opcode 22 */
static double current_linewidth = 0.;

/* Dash patterns definition: the following values must conform to those
 * in the EPS and PDF driver, but they are not equal, due to a different
 * scaling. */
static double dash_length_1 = 10,
              dash_length_2 = 6,
              dash_length_3 = 1;
/* Useful only for dashed line, to know the period of the pattern, in pixels */
static int dash_pattern_period = 0;

static int fontconfig_path_init = 0;

static char MFPLOT_DIR[256] = ""; /* Muesli installation path */

/* Identification of a pixmap. It doesn't need to be allocated */
static Pixmap pixmap_ID = 0;
static Pixmap pixmap_ID_save = 0;

static int FLUSH_ENABLED = 1; /* By default, xw_flush is enabled */
static int FORCE_FLUSH = 0; /* Can be set to 1 only in some circumstances */

/* clipping at viewport */
static int CLIPPING = 0; /* By default, no clipping */
static int CLIP_VP_CORR = 1; /* 1 (default): smaller viewport;
                              * 0: strict viewport (see opcode 85) */
/* viewport X11 coordinates */
static XPoint VP_TLC, VP_BRC;
static int viewport_defined = 0; /* 0: not yet defined; 1: defined */
/* user-defined clipping */
static XPoint TLC, BRC; /* Top Left and Bottom Right corners */
static int CLIPPED_OBJ = 1; /* usually, moving grobj are clipped */

static int AXIS_LABEL_HEIGHT = 0; /* Defined in opcode 135 */

/* Boolean which indicates if the drawing must be done in the main pixmap
 * (xw->pixmap, actually) or in the auxiliary pixmap */
static int DRAW_IN_AUX = 0;

static XPoint ARROW_START, ARROW_END;
static int    ARROW_CI;
static double ARROW_LW, ARROW_DH;

/* Static Pixmaps for use with magnetic grid (in this case, the true
 * cursor will be fully transparent). */
static Pixmap PIX_USER1_CURSOR, PIX_USER1_CURSOR_MASK,
              PIX_USER2_CURSOR, PIX_USER2_CURSOR_MASK;
static XColor PIX_USER1_COLOR, PIX_USER2_COLOR;
/* Current value */
static Pixmap PIX_USER_CURSOR, PIX_USER_CURSOR_MASK;
static XColor PIX_USER_COLOR;

static pthread_t ADC_thread; /* Animated Dashed Contour */
static int InitThreadsCalled = 0;
static int ADC_finished;
static int ADC_xmin, ADC_ymin, ADC_width, ADC_height;

/* the following function is more useful than a direct call to 'backtrace'
 * and 'backtrace_symbol' */
#if defined _GNU_GFC
#ifndef _OPTIM
void _gfortran_backtrace();
#endif
#endif

/*---------------------*/

#define XW_IDENT "MUESLI MFPLOT /xw" /* Name to prefix messages to user */
#define XW_DEF_ASPECT (3.0/4.0)      /* Default aspect (height/width) of window */
#define XW_DEF_WIDTH 800             /* Default width (pixels) */
#define XW_DEF_HEIGHT ((int) XW_DEF_WIDTH * XW_DEF_ASPECT)
                                     /* Default height (pixels) */
#define XW_MIN_WIDTH  200            /* Minimum width (pixels) */
#define XW_MIN_HEIGHT 150            /* Minimum height (pixels) */
#define XW_BORDER ((unsigned int)4)  /* Window border width (pixels) */

/*
 * Enumerate the cursor shapes.
 */
#define XW_LEFT_ARROW_CURSOR  0
#define XW_CROSSHAIR_CURSOR   1
#define XW_RESIZE_CURSOR      2
#define XW_WATCH_CURSOR       3
#define XW_OPENED_HAND_CURSOR 4
#define XW_CLOSED_HAND_CURSOR 5
#define XW_ZOOM_CURSOR        6
#define XW_TRANSPARENT_CURSOR 7
#define XW_USER1_CURSOR       8
#define XW_USER2_CURSOR       9

/*
 * Set the degree to which holding down the shift-key speeds up cursor
 * motion when an arrow key is held down.
 */
#define ARROW_KEY_VELOCITY 10

#define MIN(X, Y) (((X) < (Y)) ? (X) : (Y))
#define MAX(X, Y) (((X) > (Y)) ? (X) : (Y))

/*
 * A container used to record the geometry of the X-window
 */
typedef struct {
  unsigned int width;  /* Width of window (pixels) */
  unsigned int height; /* Height of window (pixels) */
  int xpix_per_inch;   /* Number of pixels per inch along X */
  int ypix_per_inch;   /* Number of pixels per inch along Y */
  int xmargin;         /* X-axis 1/4" margin in pixels */
  int ymargin;         /* Y-axis 1/4" margin in pixels */
  int xmin,xmax;       /* Min/max X-axis pixels excluding 1/4" margins */
  int ymin,ymax;       /* Min/max X-axis pixels excluding 1/4" margins */
  int title_height;    /* Height of the title bar, set by the Window manager*/
} XWgeom;

/*
 * Declare a colormap descriptor.
 */
typedef struct {
  XVisualInfo *vi;   /* The visual info descriptor for the colormap */
  Colormap cmap;     /* Colormap ID */
  int ncol;          /* The number of colors available. ci = [0...ncol-1] */
  int monochrome;    /* True we have to use a monochrome screen */
  unsigned long *pixel; /* 'ncol' colormap pixel indexes. */
  XColor *xcolor;    /* 'ncol' colormap color representations */
  int initialized;   /* True after the first call to xw_init_colors() */
  int nbuff;         /* The number of buffered color representation updates */
  int sbuff;         /* The index of the first buffered color representation */
} XWcolor;

/*
 * Declare a polygon descriptor.
 */
typedef struct {
  XPoint *points;  /* Temporary array of polygon vertices */
  int npoint;      /* Number of points in polygon */
  int ndone;       /* The number of points received so far */
} XWpoly;

/*
 * Declare a container used to record the extent of the rectangular
 * pixmap area that has been modified since the last xw_flush().
 */
typedef struct {
  int modified;    /* True if 'pixmap' has been modified since last update */
  int xmin, xmax;  /* X-axis extent of modified region (pixels) */
  int ymin, ymax;  /* Y-axis extent of modified region (pixels) */
} XWupdate;

/*
 * Declare a container to encapsulate the buffers needed to
 * draw a line of pixels.
 */
typedef struct {
  XImage *xi;          /* Line of pixels (Xlib image object) */
} XWimage;

/*
 * Declare a container used to hold event state information.
 */
typedef struct {
  long mask;       /* Current event mask */
  int no_buttons;  /* True after failure to acquire ButtonPressMask */
} XWevent;

/*
 * Declare a function type, instances of which are to be called to flush
 * buffered opcodes, and return 0 if OK, or 1 on error.
 */
struct XWdev;
typedef int (*Flush_Opcode_fn) (struct XWdev *xw);

/*
 * The following container is used to retain state information for /xw
 * connections.
 */
typedef struct XWdev {
  Display *display;    /* Display descriptor */
  Window parent;       /* The ID of the parent window */
  Window window;       /* Window ID */
  int number;          /* MFPLOT window number */
  int screen;          /* The screen in which the window is displayed */
  int bad_device;      /* Set to 1 by xw_bad_device() after fatal errors. */
  int last_error;      /* The last error code trapped by xw_error() */

  XftDraw *xftdraw_no_pixmap; /* for direct writing in the window */
  XftDraw *xftdraw_pixmap; /* for writing in the window pixmap */
  XftDraw *xftdraw_pixmap_aux_1; /* for writing in the 1st aux pixmap */
  XftDraw *xftdraw_pixmap_aux_2; /* for writing in the 2nd aux pixmap */

  Pixmap pixmap;       /* Main pixmap ID */
  Pixmap pixmap_aux_1; /* 1st aux pixmap ID (used to move part of pixmap) */
  Pixmap pixmap_aux_2; /* 2nd aux pixmap ID (used to move part of pixmap) */

  XftFont *font;       /* Current font */
  double xft_angle;    /* Current font angle */
  char xft_fontname[80]; /* Current font name */

  XWupdate update;     /* Descriptor of un-drawn area of pixmap */

  Cursor norm_cursor;  /* ID of 'left arrow' cursor */
  Cursor live_cursor;  /* ID of 'crosshair' cursor */
  int crosshair;       /* Show intersecting line cursor if true */
  Cursor resize_cursor; /* ID of 'resize' cursor */
  Cursor watch_cursor; /* ID of 'watch' cursor */
  Cursor hand1_cursor; /* ID of 'opened hand' cursor */
  Cursor hand2_cursor; /* ID of 'closed hand' cursor */
  Cursor zoom_cursor;  /* ID of 'zoom' cursor */
  Cursor transparent_cursor; /* ID of 'transparent' cursor */

  Cursor user1_cursor; /* ID of the 1st user-defined cursor */
  Cursor user2_cursor; /* ID of the 2nd user-defined cursor */

  XWpoly poly;         /* Polygon- or Polyline-fill accumulation descriptor */
  XWcolor color;       /* Colormap descriptor */
  XWgeom geom;         /* The size and position of the window */
  XWevent event;       /* Event state container */
  XWimage image;       /* Line of pixels container */
  XGCValues gcv;       /* Publicly visible contents of 'gc' */
  GC gc;               /* Graphical context descriptor (may have a ClipMask) */
  GC gc2;              /* Graphical context descriptor (never have a ClipMask) */
  int last_opcode;     /* Index of last opcode */
  Flush_Opcode_fn flush_opcode_fn; /* Function to flush a buffered opcode */
  struct XWdev *next;/* Pointer to next /xw device in list */
} XWdev;

/* Create an alias for the standard X error handling function type */

typedef int (*Xerrorfn) (Display *, XErrorEvent *);

/* used in pthread_create */
struct my_struct_arg {
    XWdev *xw;
};

/* Private method functions that operate on XWdev descriptors */

static XWdev *xw_new_XWdev (int i, int x, int y, int width, int height);
static XWdev *xw_del_XWdev (XWdev *xw, int partial);
static int xw_bad_device (XWdev *xw);

static int xw_ok (XWdev *xw);
static int xw_set_rgb (XWdev *xw, int ci, double red, double green, double blue);
static int xw_get_visual (XWdev *xw);
static int xw_init_colors (XWdev *xw);
static Window xw_get_window (XWdev *xw, int x, int y, unsigned int width, unsigned int height);
static Pixmap xw_get_pixmap (XWdev *xw);
static int xw_get_image (XWdev *xw, int npix);
static int xw_set_cursor (XWdev *xw, int shape);
static int xw_clear (XWdev *xw);
static int xw_set_ci (XWdev *xw, int ci);
static void xw_mark_modified (XWdev *xw, int x, int y, int diameter);
static int xw_flush (XWdev *xw);
static void xw_XPoint_to_xy (XWdev *xw, XPoint *xp, int *xy);
static void xw_xy_to_XPoint (XWdev *xw, int *xy, XPoint *xp);
static double xw_xcolor_to_rgb (unsigned short urgb);
static int xw_rgb_to_xcolor (double rgb);
static int xw_new_cursors (XWdev *xw);
static int xw_sync_error (XWdev *xw);
static int xw_handle_error(Display *display, XErrorEvent *event);

static int xw_next_page (XWdev *xw, unsigned int width, unsigned int height);
static int xw_image_line (XWdev *xw, XPoint *start, int *cells, int ncell);
static int xw_read_cursor (XWdev *xw, int mode, int posn, int shape, XPoint *ref,
              XPoint *pos, char *key,
              int write_pos,
              double pgxorg, double pgyorg, double pgxscl, double pgyscl,
              int axis_scale_x, int axis_scale_y);
static int xw_read_cursor_no_wait ( XWdev *xw, char *key );

static int xw_current_pos (XWdev *xw, XPoint *loc);
static int xw_get_click (XWdev *xw);
static int xw_win_resize (XWdev *xw, int flag, int width, int height);
static int xw_raise_win (XWdev *xw);
static int xw_set_focus_win (XWdev *xw, int focus);
static int xw_get_image_line_RGB (XWdev *xw, XPoint *start, int *cells, int ncell);
static int xw_image_line_RGB (XWdev *xw, XPoint *start, int *cells, int ncell);
static int xw_read_cursor_dyn (XWdev *xw, int imin, int imax, int jmin, int jmax,
              int not_imin, int not_imax, int not_jmin, int not_jmax,
              int exclude, int shape, XPoint *pos, char *key,
              int write_pos, double pgxorg, double pgyorg, double pgxscl, double pgyscl,
              int axis_scale_x, int axis_scale_y);
static int xw_read_cursor_dyn_multispot (XWdev *xw,
                 int *ispot, int *jspot, int nbspot, int shape,
                 int *selectedSpot, XPoint *pos, char *key);
static int xw_read_cursor_dyn_quad (XWdev *xw, int xbox[], int ybox[],
                                    int shape, XPoint *pos, char *key);
static int xw_is_inside_quad (int xb[], int yb[], int *xt, int *yt);

static int xw_shift_cursor (XWdev *xw, KeySym keysym, unsigned int modifiers);
static int xw_expose (XWdev *xw, XEvent *event);
static int xw_new_geom (XWdev *xw, int x, int y, unsigned int width, unsigned int height);
static int xw_error (Display *display, XErrorEvent *event);
static int xw_locate_cursor (XWdev *xw, XPoint *pos, int warp, XPoint *loc);
static int xw_next_event (XWdev *xw, XEvent *event);
static int xw_check_window_event (XWdev *xw, Window window,
                                  long event_mask, XEvent *event);
static XVisualInfo *xw_visual_info (Display *display, int screen, Visual *visual);
static void xw_limit_pcoords (XWdev *xw, XPoint *coord);
static void xw_scroll_rect (XWdev *xw, int Dx, int Dy,
                            int VP_width, int VP_height,
                            int *pos_xy, int *ret_dx, int *ret_dy,
                            int xmin2, int ymin2, int width2, int height2,
                            int axis_on);
static Pixmap xw_bitmap_from_pixmap (XWdev *xw, Pixmap pixmap);
static void xw_move_rect_in_pixmap (XWdev *xw, XPoint *TL, XPoint *TL2);
void * xw_animate_dashed_contour (void *xw);
void * xw_animate_dashed_multispot (void *xw);
static int xw_show_pixmap (XWdev *xw, Pixmap pixmap, char *name);
static void xw_checks_pixmap_aux (XWdev *xw, Pixmap *pixmap,
                                  unsigned int width, unsigned int height,
                                  int aux_ID);
static void xw_clear_pixmap_aux (XWdev *xw, Pixmap pixmap);
static void xw_bbox_of_pixmap (XWdev *xw, Pixmap pixmap,
                               int *xmin, int *ymin, int *xmax, int *ymax,
                               int *empty );
static void xw_clip_at_viewport (XWdev *xw);
static void xw_draw_string (XWdev *xw, char *chr, XPoint *xy);
static void xw_draw_marker (XWdev *xw, char *chr, XPoint *xy);
static void xw_move_grobj (XWdev *xw, int *ret_x, int *ret_y);
static void xw_get_string_bbox (XWdev *xw, char *chr,
                                int *ex, int *ey, int *ew, int *eh);
static void xw_erase_labelling_area (XWdev *xw, int x_axis_time, int y_axis_time);
static void xw_erase_output_area (XWdev *xw);
static void xw_draw_arrow ( XWdev *xw );
static void xw_move_arrow ( XWdev *xw );
static void xw_move_arrow_in_pixmap ( XWdev *xw, Pixmap pixmap_save );
static void xw_set_fontconfig_path ( );
extern void XftClean();

extern void CALL_MF_PGTBOX_FROM_X11_DRIVER ( int *dx_pix, int *dy_pix, int *axis_on);
extern void CALL_MF_PGSCH_FROM_X11_DRIVER ();

#ifdef _GNU_GFC
  extern void __mod_pgplot_MOD_magnetic_grid_rule_pgplot(
#else
#if defined _INTEL_IFC
  extern void mod_pgplot_mp_magnetic_grid_rule_pgplot_(
#else
      "UNKNOWN compiler."
#endif
#endif
              int *ictrl_key, int *ix_in, int *iy_in, int *ix_out,
              int *iy_out, double *X_OUT_WLD_COORD, double *Y_OUT_WLD_COORD,
              int *ivalid );

/* defined in stdlib.h, but not read... why? */
int setenv(const char *name, const char *value, int overwrite);

/* Container for rubber-band cursor resources and status */
typedef struct {
  int line_width;             /* Rubber-band line width */
  int mode;                   /* Cursor mode 1=line, 2=rectangle, ... */
  GC gc;

  XPoint ref;                 /* Reference vertex of cursor */
  XPoint end;                 /* End point of cursor */
  /* added by E.C. for a rectangle centered on the pointer */
  unsigned int width, height; /* fixed size of rectangle */
  int xmin, xmax, ymin, ymax, inside; /* axes values and flag */
} Band;

static Band *xw_new_Band (XWdev *xw, int mode, XPoint *ref);
static int xw_draw_cursor (XWdev *xw, Band *bc, XPoint *end);
static int xw_erase_cursor (XWdev *xw, Band *bc);
static int xw_end_cursor (XWdev *xw, Band *bc, int status);
static Band *xw_del_Band (XWdev *xw, Band *bc);
static int xw_bound_cursor (XWdev *xw, XPoint *xp);
static int xw_cursor_line (XWdev *xw, int xa, int ya, int xb, int yb);
static int xw_add_events (XWdev *xw, long events);
static int xw_rem_events (XWdev *xw, long events);

/* Functions used to flush buffered opcodes */

static int xw_update_colors (XWdev *xw);

/*
 * Declare the head of the list of open XW device descriptors.
 * This has to have file scope to allow the X error handler to get at it.
 */

static XWdev *device_list = NULL;

static XWdev *xw_insert_device (XWdev *xw);
static XWdev *xw_select_device (int number);
static XWdev *xw_remove_device (XWdev *xw);
static char *xw_find_exe (char *path, char *program);
static int xw_nint (double f);

/* list of opcodes, named by character strings */
#define GET_DEV_NAME                  1 /* Return device name */
#define GET_COL_IND_RANGE             2 /* Return range of color indexes */
#define GET_DEV_RESOL                 3 /* Return device resolution */
#define GET_MISC_INFO                 4 /* Return misc device info */
#define GET_DEF_FILENAME              5 /* Return default file name */
#define GET_DEF_SIZE                  6 /* Return default physical size of plot */
#define GET_CHAR_SIZE                 7 /* Return character size */
#define SELECT_PLOT                   8 /* Select plot */
#define OPEN_DEV                      9 /* Open device */
#define CLOSE_DEV                    10 /* Close device */
#define BEGIN_PICT                   11 /* Begin picture */
#define DRAW_LINE_SEGM               12 /* Draw one straight segment */
#define DRAW_POLYLINE                13 /* Draw polyline (multiple straight segments) */
#define END_PICT                     14 /* End picture */
#define SELECT_COL_IND               15 /* Select color index */
#define FLUSH_BUF                    16 /* Flush buffer */
#define READ_CURSOR                  17 /* Read cursor */
#define SET_X11_WIN_ID               18 /* Set X11 window ID of the terminal */
#define SET_LINE_STYLE               19 /* Set line style */
#define POLYGON_FILL                 20 /* Polygon fill */
#define SET_COL_REPRES               21 /* Set color representation */
#define SET_LINE_WIDTH               22 /* Set line width */
#define ESCAPE                       23 /* Escape */
#define RECT_FILL                    24 /* Rectangle Fill */
#define SET_LINE_CAP_JOIN_STYLE      25 /* Set line Cap and Join Style */
#define PUT_LINE_PIX_CI              26 /* Put Line of pixels (via color index) */
#define GET_LINE_PIX_RGB             27 /* Get Line of pixels (via RGB val.) */
#define PUT_LINE_PIX_RGB             28 /* Put Line of pixels (via RGB val.) */
#define GET_COL_REPRES               29 /* Query color representation */
#define SET_ANG_CLIP_XFT             31 /* Set Angle and Clipping for Xft */
#define SET_FONT_XFT                 32 /* Set Xft Font */
#define DRAW_CHAR_STRING             33 /* Draw Character String */
#define SET_MUESLI_PATH              34 /* Set the Muesli installation path */
#define GET_XFT_STRING_BBOX          36 /* Get the bbox of a string via Xft */
#define DRAW_MARKER                  38 /* Draw Marker */
#define RECT_DRAW                    49 /* Draw Rectangle */
#define GET_CURSOR_POS               50 /* Get cu#define rsor position (without event) */
#define GET_CLICK_IN_WIN             51 /* Get a click in the window */
#define RAISE_WIN                    53 /* Raise window */
#define WIN_RESIZE                   56 /* Window Resize */
#define SELECT_BACK_FOREGROUND       57 /* Select Back- & Foreground colors */
#define GET_COL_DEPTH                58 /* Get the color depth */
#define SET_EXE_NAME                 59 /* Set the executable name */
#define GET_COLOR_CORR               60 /* Get a color correction */
#define FINISH_READ_CURSOR           61 /* Finish a Read cursor */
#define SET_CURSOR_SHAPE             62 /* Change the cursor shape */
#define READ_CURSOR_DYN              63 /* Read cursor with dynamic change of the cursor */
#define GET_WIN_SIZE_PIX             64 /* Return window size in pixels */
#define READ_CURSOR_DYN_EXCL_BOX     65 /* Read cursor with dynamic chge (with an exclusion box) */
#define READ_CURSOR_DYN_MULTISPOT    66 /* Read cursor with dynamic chge (with a multispot zone) */
#define READ_CURSOR_DYN_QUADR_POLYG  67 /* Read cursor with dynamic chge (for a quadr. polygon) */
#define GET_DASH_PERIOD              70 /* Get the Dash Pattern Period */
#define CLEAN_FONTCONFIG             72 /* Cleaning of FontConfig */
#define SELECT_AUX_PIXMAP            80 /* Select and Set Auxiliary Pixmap */
#define MOVE_GROBJ_PIXMAP            82 /* Move Grobj from an Auxiliary Pixmap */
#define REDUCE_2ND_AUX_PIXMAP        83 /* Reduction of the 2nd auxiliary pixmap */
#define SET_CLIPPING                 84 /* Set Clipping */
#define SET_1_PIX_CORR               85 /* Set a 1-pixel correction for the viewport */
#define SCROLL_IN_PIXMAP             88 /* Scroll in pixmap */
#define PREP_ARROW_MOVE             102 /* Prepare arrow moving */
#define MOVE_ARROW                  103 /* Move arrow */
#define X11_FLUSH_POLICY            105 /* X11 flush policy */
#define FORCE_FLUSH_BUFFER          106 /* Force flush buffer */
#define FORCE_UPDATE_FROM_PIXMAP    107 /* Force a full update from the pixmap */
#define SET_INPUT_FOCUS             110 /* Set Input Focus */
#define SET_VIEWPORT                120 /* Set Viewport */
#define UPDATE_MAIN_PIXMAP          132 /* Update the main pixmap from the auxiliary one */
#define GET_LABEL_AREA_AROUND       135 /* Get the labelling area around the viewport */
#define ERASE_LABEL_AREA_AROUND     140 /* Erase the labelling area around the viewport */
#define GET_CLIPPING                150 /* Get the CLIPPING status */
#define SAVE_PIXMAP_ID              160 /* Save the pixmap ID */
#define COPY_PIXMAP_FROM_ID         161 /* Copy a saved pixmap ID in the current window */
#define REM_FIG_NUM_IN_WIN_TITLE    162 /* Suppress the figure number in the window title */
#define GET_CURRENT_WIN_GEOM        163 /* Return the current window geometry */
#define READ_CURSOR_WITHOUT_WAITING 164 /* Read Cursor without Waiting */
#define DEF_CUSTOM_CURSOR_SHAPE     165 /* Register user-defined cursor */
#define GET_MODIFIED_CURS_POS       166 /* Read Modified Cursor Position */
