! MUESLI-MFPLOT PDF driver
!
! Keep this file as ISO-8859-15 encoded because accented vowels are present
! in the PDF using this encoding.
!
! Be aware that, for a non-binary PDF file (this the case for the current
! driver), the maximum number of column is equal to 255.
!
subroutine PDF_DRIVER( ifunc, rbuf, ibuf, chr, lchr )

   use mod_mfarray, only: mf_muesli_version, MF_DOUBLE
   use mod_mfaux, only: find_unit

   use mod_pgplot

   implicit none

   integer          :: ifunc, ibuf(*), lchr
   double precision :: rbuf(*)
   character(len=*) :: chr
   !------ API end ------

   !---------------------------------------------------------------------------
   ! MFPLOT driver for Portable Document Format.
   !
   ! douard CANOT version :
   ! (see also 'pdfdriv.info')
   !
   ! 26.06.2018 - Creation from 'psdriv.F90'.
   ! 13.07.2018 - Better management of objects (numbering and order).
   ! 15.07.2018 - Support of bitmap images.
   ! 18.07.2018 - Support of coloured shading, using the sh feature of the
   !              PDF language, instead of a pixel-oriented writing, like
   !              for the initial version of this driver.
   ! 26.07.2018 - Support of TriMesh and QuadMesh, reducing the size of
   !              the PDF, because all cells are grouped inside only one
   !              Shading object, and some vertices are shared.
   ! 30.07.2018 - External fonts (currently, only English157BT) can be
   !              embedded in the PDF, as a subset, after compression
   !              (deflate) and encoding in ASCII85. Therefore, the PDF may
   !              be modified by any text editor.
   ! 01.08.2018 - Metadata added (Title, Author, Creator, Producer, Date)
   ! 05.08.2018 - Added transparency (new IFUNC=40).
   ! 12.08.2018 - Added a boolean (PDF_driver_font_begin) to prevent selecting
   !              many times the same font (see 'grparse_pdf_font').
   ! 13.08.2018 - Remove the 5 bytes %%EOF in the second line of each PDF,
   !              because: (i) this may be confusing with the end of the file;
   !              (ii) a sequence of 4 ASCII bytes (commented by "%") is not
   !              required for ASCII PDF.
   ! 03.09.2018 - Opcode 28 shift to 38, because for implementing markers in
   !              xwdriv, the number 28 is already in use.
   ! 07.09.2018 - Add MutEx (Mutually Exclusive) optional contents, via
   !              radio-button groups (/RBGroups).
   ! 09.09.2018 - Added 7 old colors (from Matlab) to the 16 predefined colors.
   !              Total number of predefined colors is now 23.
   ! 10.09.2018 - Added 7 new colors (from Matlab) to the 23 predefined colors.
   !              Total number of predefined colors is now 30.
   !              Added also 12 new colors (from the Breeze colortable).
   !              Total number of predefined colors is now 42.
   ! 12.09.2018 - Reduce Mediabox dimension, in order to obtain a better
   !              behavior with some PDF viewer (mupdf, pdfeditor, ...)
   !              Global BBOX is divided by 10.
   !              Add % on the second line of the header, to prevent
   !              file transfer protocols to change the line ending
   !              (file view as binary, because it is not fully 7-bit ASCII).
   !              Added a warning at the beginning of the current file.
   ! 14.09.2018 - Enlarge slightly the dash segment in the '.-' pattern for
   !              lines: [75 45 8 45] instead of [60 45 8 45].
   ! 15.09.2018   Added the dash pattern offset, useful for very short lines
   !              (see IFUNC=19).
   ! 20.11.2018   Retreive MFPLOT_DIR via global module variable, not via
   !              'grgenv'.
   ! 21.11.2018   Added the super groups.
   ! 03.12.2018 - Support also Windows line termination (CR+LF).
   ! 16.05.2019 - Choose version 1.6 of PDF Standard (instead of 1.5) in
   !              order to implement "Visibility Expressions".
   ! 29.02.2020 - Use now double precision instead of single one.
   ! 17.03.2020 - Enlarge all segments of all dash patterns, by a factor 2.67
   !              (see IFUNC=19).
   ! 17.03.2020 - Decrease linewidth last factor, in order to have the
   !              same visual aspect as in EPS (see IFUNC=22).
   ! 18.03.2020 - Experimentally, we take all segment lengths of dash patterns
   !              proportional to sqrt(linewidth) (see IFUNC=19).
   ! 28.03.2020 - Fix the dash length references.
   !  2.04.2020 - Some PDF output commands are written more compactly
   !              (rg, RG and cm).
   ! 12.04.2020 - 'nbuf' scalar argument replaced by the 'ibuf' vector.
   ! 24.04.2020 - Splitted the written line containing the objects ref
   !              in /Contents (it may be very long).
   ! 30.05.2020 - Introduced an output buffer (for character strings) in order
   !              to reduce the number of lines of the PDF. Not used for all
   !              write, but only for few opcodes.
   ! 01.06.2020 - When include an XObject from the folder PDFLibXObj, remove
   !              the comment which provide the object name, except if
   !              COMMENTS_IN_PDF is TRUE.
   !              Few more opcodes use now the string buffering before
   !              writing in the PDF file.
   ! 03.06.2020 - When colors are all equal: use 'setgray' command (shortcut=g
   !              or G, according to the aim of drawing: stroke or fill)
   !              instead of 'setrgbcolor' (rg or RG); this reduce the size
   !              of the PDF.
   ! 03.06.2020 - Trailing zeros after the decimal point of reals are removed;
   !              if the decimal point is at the last position, it is removed
   !              as well. This reduce the size of the PDF.
   !              Fixed also a bug concerning the filling of the string buffer
   !              at the end of the main routine: the condition to insert a
   !              space is "lobuf >= 1" and not "lobuf > 1"!
   ! 19.02.2021 - Removed call to flush_buffer in opcode 16. Not necessary.
   ! 23.02.2021 - Changed definition of colors which have indices in [8-15].
   !              These are now only gray shades. Two particular colors:
   !              quasi-white and quasi-black, will have a future usage.
   ! 16.03.2021 - Raise the update level to that of the EPS driver
   !              (clipping, BBox, etc.).
   ! 17.03.2021 - Changed the name of this driver to PDF_DRIVER.
   !              Introduced parameter int_not_defined=huge(1), to be used
   !              during initialization of (lasti,lastj). Previously, -1
   !              was used, but this later value could be a valid position.
   ! 25.03.2021 - Fix the constant BBox.
   ! 29.03.2021 - Update of the BBox in the only case of a legend frame
   !              draw outside the window. Opcod is now 45 instead of 31.
   ! 30.03.2021 - Opcode 83 removed.
   !              Some information fields in the header (Title, Creator,
   !              CreationDate, Author) may be omitted by setting the
   !              environment MFPLOT_PDF_ANONYMOUS variable to 1.
   ! 20.10.2021 - Improved opcode 12 (Draw line) for the case where there
   !              is a continuity between some polylines.
   ! 24.10.2021 - Increase the number of saved comment strings from one
   !              to five ('string_saved').
   ! 25.10.2021 - Fix the evaluation of a boolean value for the continuity
   !              test in opcode 12 (Draw line).
   ! 28.10.2021 - Fix the writing of strings with unescaped parenthesis (new
   !              contained function 'pdf_string').
   !              Added implementation of MutEx optional contents using
   !              VE (Visibility Expressions) when we want that at least
   !              one object in a mutex group is visible.
   ! 29.10.2021 - Added 5 new symbols from the CeMaSP font, design by myself.
   !              Total number of symbols is now 26 instead of 21.
   ! 04.11.2021 - Fixed a bug in the jonction of polylines (opcode=12):
   !              when no points are added, writing of "S" alone is avoided.
   ! 13.11.2021 - Changed slightly the linewidth factor, in order to match
   !              the linewidth on a X11 screen (for the same window size).
   !              See opcode 22.
   ! 15.11.2021 - The initial settings of cap_style and join_style in the
   !              initialization part (opcode 9) have been removed, because
   !              these two items will be changed by appropriate new opcodes.
   !              New opcode 25 to set these line attributes.
   ! 26.11.2021 - Fixed initialization of more OC variables at each device
   !              opening.
   ! 01.12.2021 - Removed completely the dash_offset variable: regularity is
   !              always present when drawing one path at a time.
   ! 04.12.2021 - Added opcode 70, to get the dash pattern period.
   ! 15.12.2021 - Changed all numerical target labels of the select case to
   !              predefined character strings.
   ! 22.03.2023 - Inverted dashes implemented in SET_LINE_STYLE.
   ! 29.01.2024 - MFPLOT_DIR renamed MFPLOT_DIR.
   !---------------------------------------------------------------------------

   character(len=*), parameter :: ctype = "PDF (Portable Document Format)"

   integer, parameter :: STDERR = 0

   ! Document area in milli-inches: (WIDTH, HEIGHT) are the dimensions of
   ! the printable area for an EPS image, BBox can be defined at the end;
   ! Keep a large image; on the contrary, roundoff will destroyed very
   ! small scales... Before writing, the dimensions will be reduced.
   integer, save :: WIDTH, HEIGHT

   integer :: ier, i0, j0, i1, j1, L, L1, L2, lc, lj
   integer, save :: lasti, lastj, unit, unit2
   integer, parameter :: int_not_defined = huge(1)

   character(len=200) :: path_to_PDFLibXObj, path_to_English157BT
   character(len=280) :: XObj_filename ! length must be 200+80

   integer :: i2, j2, i3, j3
   double precision :: x1, x2, y1, y2
   integer :: x11_id

   logical, save :: anonymous_pdf

   integer :: ci, ioerr
   integer, save :: npts, line_style
   integer :: dash_offset
   integer :: n1, n2, n3, n4

   ! Polylines Management
   logical, save :: something_has_been_written
   logical, save :: polyline_start = .false., in_polyline = .false.
   logical :: bool_1, bool_2

   ! Dash patterns definition : the following values must match those
   ! in the EPS driver. They have been designed to match also the dash
   ! lengths of the X11 driver.
   integer, parameter :: dash_length_1 = 80,                            &
                         dash_length_2 = 48,                            &
                         dash_length_3 =  8
   ! Useful only for dashed line, to know the period of the pattern, in pixels
   integer, save :: dash_pattern_period = 0

   double precision, save :: current_linewidth = 0.0d0

   integer, save :: state = 0, nseg

   integer :: nxp, nyp, xorg, yorg, xlen, ylen, n, rgb(3)
   integer :: i, j, k, status
   character(len=8)  :: date
   character(len=10) :: time
   character(len=5)  :: zone

   logical, save :: stdout
   double precision, save :: lw

   integer, save :: bbox(4)

   integer, parameter :: MAX_COLORS = 4176
   double precision, save :: rvalue(0:MAX_COLORS-1),                    &
                             gvalue(0:MAX_COLORS-1),                    &
                             bvalue(0:MAX_COLORS-1)
   integer, save :: COLORMAP_CI_LOW, COLORMAP_CI_HIGH, COLORMAP_LENGTH
   integer, save :: BITS_PER_SAMPLE
   integer :: i_red, i_green, i_blue

   ! 'obuf' is an output buffer, to keep PDF commands before writing
   ! in the file
   integer, parameter :: lobuf_max = 132
   character(len=lobuf_max), save :: obuf
   integer, save :: lobuf
   character(len=lobuf_max) :: instr, instr2

   character(len=160) :: line
   character(len=120) :: msg

   character(len=255), save :: fname
   integer, save :: lfname
   character(len=256), save :: fnameC ! same than fname, but with a NULL
                                      ! char at the end (for passing to C)
   integer, save :: lfnameC

   integer, save :: nb_CONTENTS, nb_IMAGES, nb_CMAP, nb_SHT4, nb_SHT6,  &
                    nb_STD_FONTS, nb_MARKS
   integer, save :: inf_num, cat_num, pgs_num, beg_cont, end_cont,      &
                    beg_imag, end_imag, beg_cmap, end_cmap,             &
                    beg_sht4, end_sht4, beg_sht6, end_sht6,             &
                    beg_stdf, end_stdf, beg_mark, end_mark,             &
                    ext_fs1_num, ext_fs2_num, ext_fs3_num, ext_fs4_num, &
                    pag_num, ocp_num, beg_ocgs, end_ocgs, beg_omut,     &
                    end_omut, nb_obj

   ! MF_PDF_CURR_CONT, MF_PDF_CURR_IMG, MF_PDF_CURR_SHT4, MF_PDF_CURR_SHT6
   ! are global variables (mod_pgplot) used to track numbering.
   ! The following offsets are also global variables:
   ! MF_PDF_OFF_CONT, MF_PDF_OFF_IMG, MF_PDF_OFF_SHT4, MF_PDF_OFF_SHT6

   integer, parameter :: NB_MAX_MARKS = 26
   integer :: nsym
   integer, save :: rad(1:NB_MAX_MARKS)
   data rad / NB_MAX_MARKS * 10 /

   integer, parameter :: MAX_NB_TRANSP = 100
   double precision, save :: transp_table(MAX_NB_TRANSP)
   double precision :: transp_request
   integer, save :: nb_transp
   logical :: found

   double precision, save :: mfac

   integer, parameter :: NCOLORS = 42
   double precision, save :: rinit(0:NCOLORS-1), ginit(0:NCOLORS-1),    &
                             binit(0:NCOLORS-1)
   data rinit /1.00d0, 0.00d0, 1.00d0, 0.00d0, 0.00d0, 0.00d0, 1.00d0, 1.00d0,   &
               0.003922d0, 0.1647d0, 0.3333d0, 0.5d0, 0.6667d0, 0.8314d0, 0.9961d0, 1.0d0, &
               0.00d0, 0.00d0, 1.00d0, 0.00d0, 0.75d0, 0.75d0, 0.25d0,           &
               0.000d0, 0.850d0, 0.929d0, 0.494d0, 0.466d0, 0.301d0, 0.635d0,    &
               0.2392d0, 0.9294d0, 0.9647d0, 0.9922d0, 0.1529d0, 0.7882d0,       &
               0.0667d0, 0.1608d0, 0.6078d0, 0.4980d0, 0.1020d0, 0.7529d0 /
   data ginit /1.00d0, 0.00d0, 0.00d0, 1.00d0, 0.00d0, 1.00d0, 0.00d0, 1.00d0,   &
               0.003922d0, 0.1647d0, 0.3333d0, 0.5d0, 0.6667d0, 0.8314d0, 0.9961d0, 1.0d0, &
               0.00d0, 0.50d0, 0.00d0, 0.75d0, 0.00d0, 0.75d0, 0.25d0,           &
               0.447d0, 0.325d0, 0.694d0, 0.184d0, 0.674d0, 0.745d0, 0.078d0,    &
               0.6824d0, 0.0824d0, 0.4549d0, 0.7373d0, 0.6824d0, 0.8078d0,       &
               0.8196d0, 0.5020d0, 0.3490d0, 0.5490d0, 0.7373d0, 0.2235d0 /
   data binit /1.00d0, 0.00d0, 0.00d0, 0.00d0, 1.00d0, 1.00d0, 1.00d0, 0.00d0,   &
               0.003922d0, 0.1647d0, 0.3333d0, 0.5d0, 0.6667d0, 0.8314d0, 0.9961d0, 1.0d0, &
               1.00d0, 0.00d0, 0.00d0, 0.75d0, 0.75d0, 0.00d0, 0.25d0,           &
               0.741d0, 0.098d0, 0.125d0, 0.556d0, 0.188d0, 0.933d0, 0.184d0,    &
               0.9137d0, 0.0824d0, 0.0000d0, 0.2941d0, 0.3765d0, 0.2314d0,       &
               0.0863d0, 0.7255d0, 0.7137d0, 0.5529d0, 0.6118d0, 0.1686d0 /

   integer :: irec_offset

   ! Deflate support (zlib)

   ! (multiple de 3 car R,G,B)
   integer, parameter :: len_in_max = 30000

   ! CAUTION: 1-byte integer (and not 4-byte as default!)
!### TODO 2: l'criture devrait tre plus standard, avec utilisation de kind
   integer*1, save :: int_in(len_in_max)
   integer, save :: len_in
   character(len=len_in_max) :: string_out
   integer :: len_out, job

   interface
      subroutine deflate_stream_to_hex( in_bin_str, len_in_bin,         &
                                        out_hex_str, len_out_hex,       &
                                        job, ier )
         integer*1        :: in_bin_str(*)
         integer          :: len_in_bin
         character(len=*) :: out_hex_str
         integer          :: len_out_hex, job, ier
      end subroutine
      subroutine deflate_stream_to_a85( filename, len_filename,         &
                                        buffer, len_buffer,             &
                                        job, ier )
         character(len=*) :: filename
         integer          :: len_filename
         integer*1        :: buffer(*)
         integer          :: len_buffer, job, ier
      end subroutine
   end interface

   integer, external :: gr_real_user

   logical, save :: init_ok = .false.

   ! Assume that we will have at most 5 comment strings to save before
   ! initialization (see IFUNC 32 and 11)
   character(len=132), save :: string_saved(5)
   integer, save :: nb_string_saved = 0

   logical, save :: bbox_updated = .false.

   character :: value
   character(len=120) :: fonts_present

   integer :: pdf_color_intent

   integer, save :: X11_grxmxa = -1, X11_grymxa = -1

   ! Optional Contents Managements
   ! .. parameters
   integer, parameter :: MAX_NUMBER_OCGS = 99
   ! .. saved variables (some of them must be reset at each opening)
   integer, save :: nb_OCGS
   integer, save :: OC_num
   character(len=80), save :: OCG_name(MAX_NUMBER_OCGS)
   integer, save :: OCG_value(MAX_NUMBER_OCGS) ! 0="Off", 1="On"
   logical, save :: OCG_mutex(MAX_NUMBER_OCGS)
   logical, save :: OCG_mutex_default(MAX_NUMBER_OCGS)
   character(len=80), save :: OCG_RBGroups_name ! scalar (it is unique)
   logical, save :: OCMD_exist
   logical, save :: OCG_sg(MAX_NUMBER_OCGS)
   character(len=80), save :: OCG_sg_name ! scalar (it is unique)
   ! .. ordinary variables
   logical :: sg_OCGS_exist
   logical :: mutex_OCGS_exist
   integer :: nb_OCG_MUTEX, OCG_OCMD_shift

   double precision :: SQRT_FAC, x_shift, y_shift
   character(len=255) :: tmp1, string
   character(len=1024) :: tmp2

   ! pour faire tenir plusieurs instructions sur une mme ligne
   ! (pas encore mis en oeuvre... pas beaucoup d'intrt  part obtenir
   !  un PDF ayant moins de lignes -- la taille sera la mme !)
   integer, parameter :: advance_no_count_max = 8
   integer, save :: advance_no_count = 0

   character(len=10) :: str1, str2, str3

   !------ end of declarations -- execution starts hereafter  ------

   ! at the end of each select case block, return if no string has been filled

   select case( ifunc )

      !-----------------------------------------------------------------
      case( GET_DEV_NAME ) ! Return device name.

      ! landscape, color
      chr = ctype
      lchr = len(ctype)

      return

      !-----------------------------------------------------------------
      case( GET_COL_IND_RANGE ) ! Return range of color indexes.

      ibuf(1) =  0
      ibuf(2) = MAX_COLORS - 1

      return

      !-----------------------------------------------------------------
      case( GET_DEV_RESOL ) ! Return device resolution.

      ibuf(1) = 1200
      ibuf(2) = 1200
      ibuf(3) = 5    ! device coords per pixel

      return

      !-----------------------------------------------------------------
      case( GET_MISC_INFO ) ! Return misc device info.

      chr( 1: 1) = "H" ! Interactive device (I) or Hardcopy (H)
      chr( 2: 2) = "N" ! Cursor available (C) or not (N)
      chr( 3: 3) = "D" ! Dashed lines available (D) or not (N)
      chr( 4: 4) = "A" ! Area fill available (A) or not (N)
      chr( 5: 5) = "T" ! Thick lines available (T) or not (N)
      chr( 6: 6) = "R" ! Rectangle fill available (R) or not (N)
      chr( 7: 7) = "Q" ! Pixel device (P), Image device (Q) or nothing (N)
      chr( 8: 8) = "N" ! Persistent device (Verbose prompt) or not (N)
      chr( 9: 9) = "Y" ! Can return color representation? (Y) or not (N)
      chr(10:10) = "M" ! Markers available (M) or not (N)

      lchr = 10

      return

      !-----------------------------------------------------------------
      case( GET_DEF_FILENAME ) ! Return default file name.

      return

      !-----------------------------------------------------------------
      case( GET_DEF_SIZE ) ! Return default physical size of plot.

      ibuf(1) = 0
      ibuf(2) = WIDTH
      ibuf(3) = 0
      ibuf(4) = HEIGHT

      return

      !-----------------------------------------------------------------
      case( GET_CHAR_SIZE ) ! Return character size.
                            ! (actually, never called)

      rbuf(1) = 8.0d0

      return

      !-----------------------------------------------------------------
      case( SELECT_PLOT ) ! Select plot.
                          ! No selection: there is only one PDF file opened.

      return

      !-----------------------------------------------------------------
      case( OPEN_DEV ) ! Open device.

      ! Get some numbers of objects. We have to know early these numbers
      ! about the XObjects management.
      nb_IMAGES = MF_NB_BITMAPS
      nb_SHT4 = MF_NB_TRI_GRAD
      nb_SHT6 = MF_NB_QUAD_GRAD

      ! Currently, Muesli support only one colormap per PDF
      if( MF_CMAP_USED ) then
         nb_CMAP = 1
      else
         nb_CMAP = 0
      end if

      nb_CONTENTS = nb_IMAGES + nb_SHT4 + nb_SHT6 + 1

      ! Here, we must check whether the PDF is anonymous or not (default is not).
      anonymous_pdf = .false.
      call grgenv( "PDF_ANONYMOUS", value, L )
      if( L /= 0 ) then
         if( value == "1" ) then
            anonymous_pdf = .true.
         end if
      end if

      ! Other objects management (see pdf_driver.info)
      if( .not. anonymous_pdf ) then
         inf_num = 1
      else
         inf_num = 0
      end if

      pgs_num = inf_num + 1

      MF_PDF_OFF_CONT = pgs_num
      beg_cont = MF_PDF_OFF_CONT + 1
      end_cont = MF_PDF_OFF_CONT + nb_CONTENTS

      MF_PDF_OFF_IMG  = end_cont
      beg_imag = MF_PDF_OFF_IMG + 1
      end_imag = MF_PDF_OFF_IMG + nb_IMAGES

      MF_PDF_OFF_CMAP = end_imag
      beg_cmap = MF_PDF_OFF_CMAP + 1
      end_cmap = MF_PDF_OFF_CMAP + nb_CMAP

      MF_PDF_OFF_SHT4 = end_cmap
      beg_sht4 = MF_PDF_OFF_SHT4 + 1
      end_sht4 = MF_PDF_OFF_SHT4 + nb_SHT4

      MF_PDF_OFF_SHT6 = end_sht4
      beg_sht6 = MF_PDF_OFF_SHT6 + 1
      end_sht6 = MF_PDF_OFF_SHT6 + nb_SHT6

      pag_num  = end_sht6 + 1

      ! For other objects (Fonts, Markers, OCGs), we have to wait the drawing
      ! of all objects. The corresponding variables will be set at IFUNC=10
      ! (i.e. during close device).

      ! Current obj being written
      MF_PDF_CURR_CONT = 0
      MF_PDF_CURR_SHT4 = 0
      MF_PDF_CURR_SHT6 = 0
      MF_PDF_CURR_IMG = 0
      ! Exception: there is only one colormap
      MF_PDF_CURR_CMAP = 1

      nb_transp = 0 ! For ExtGState (see below, and at IFUNC=40)

      ! Check for concurrent access
      if( state == 1 ) then
         call grwarn( "a PDF file is already open" )
         ibuf(1) = 0
         ibuf(2) = 0
         return
      end if

      ! Copy color table
      do ci = 0, NCOLORS-1
         rvalue(ci) = rinit(ci)
         gvalue(ci) = ginit(ci)
         bvalue(ci) = binit(ci)
      end do

      ! Device dimensions

      ! X11 max plotting are
      ! (eventually virtual, case /NULL, but of the same size as if
      !  X11 had been enabled)
      ! => it is a standard X11 of 90 dpi (resolution must be constant,
      !    in order to obtain exactly the same PDF images on different
      !    machines...)
      ! => avoid a difference in PDF files according to X11 active
      !    or no_X11 (i.e. the NULL device = in batch process)

      ! X11_grxmxa, X11_grymxa are get via opcode 35
      ! (X11_XMARGIN, X11_YMARGIN are global variables)
      if( X11_grxmxa < 0 .or. X11_grymxa < 0 ) then
         ! something terribly wrong arose!
         print *, "(Muesli FGL:) PDF Driver: internal error"
         print *, "              negative value for at least one device dimension!"
         pause "only for debugging purpose"
         stop
      end if

      ! First unit here is X11 pixels
      bbox(1:4) = [ -X11_XMARGIN, -X11_YMARGIN,                         &
                     X11_grxmxa+X11_XMARGIN, X11_grymxa+X11_YMARGIN ]
      ! Then unit is PDF dots, so comparison with internal coordinates
      ! may be done
      bbox(1:4) = bbox(1:4) / 0.072d0

      WIDTH  = X11_grxmxa / 0.072d0
      HEIGHT = X11_grymxa / 0.072d0

      stdout = chr(1:lchr) == "-"
      if( stdout ) then
         ! machine-dependent!
         unit = 6
      else
         ! grglun (get logical unit) is defined in 'sys' folder
         call grglun( unit )
      end if
      ibuf(1) = unit
      ! Save in pgplot module (used by deflate_stream_to_a85)
      MF_PDF_UNIT = unit
      if( .not. stdout ) then
         open( unit=unit, file=chr(1:lchr), status='unknown', iostat=ier )
         if( ier /= 0 ) then
            msg = "Cannot open output file for a PDF plot: " // chr(:lchr)
            call grwarn( msg )
            ibuf(2) = 0
            call grflun( unit )
            return
         else
            inquire( unit=unit, name=chr )
            lchr = len_trim(chr)
            ibuf(2) = 1
            fname = chr(:lchr)
            lfname = lchr
         end if
      else
         ibuf(2) = 1
         fname = "-"
         lfname= 1
      end if
      state = 1
      ioerr = 0
      lobuf = 0
      lw = 1
      npts = 0

      ! Misc. OC variables initialization
      nb_OCGS = 0
      OCMD_exist = .false.
      OCG_RBGroups_name = ""
      OCG_sg_name = ""
      OCG_mutex(:) = .false.
      OCG_mutex_default(:) = .false.
      OCG_sg(:) = .false.

      ! See the PDF structure in 'pdf_driver.info'.

      write(unit,"(A)") "%PDF-1.6"
      write(unit,"(A)") "%"
      write(unit,"(A)") ""

      if( .not. anonymous_pdf ) then
         write(unit,"(I0,A)") inf_num, " 0 obj <<"
         if( len_trim(pg_exe_name) == 0  ) then
            if( len_trim(win_title) == 0  ) then
               write(unit,"(A,I0,A)") "  /Title (figure ", fig_number, ")"
            else
               write(unit,"(A,I0,A)") "  /Title (figure ", fig_number,  &
                                      ": " // trim(win_title) // ")"
            end if
         else
            if( len_trim(win_title) == 0  ) then
               write(unit,"(A,I0,A)") "  /Title (" // trim(pg_exe_name) &
                           // " - figure ", fig_number, ")"
            else
               write(unit,"(A,I0,A)") "  /Title (" // trim(pg_exe_name) &
                                      // " - figure ", fig_number,      &
                                      ": " // trim(win_title) // ")"
            end if
         end if
         call gruser( instr, L )
#ifndef _WINDOWS
         status = gr_real_user( instr(1:L)//char(0), instr2, L )
         if( status == 1 ) then
            ! Succeeded: we got the real user name.
            ! The full username may contain some accented character: if the
            ! system is set as UTF-8, we have to convert it to iso-8859-15
            instr = utf8_to_latin_1( instr2(1:L) )
         else
            ! Failed: keep the unix username in 'instr'
         end if
#endif
         if( len_trim(instr) /= 0 ) then
            write(unit,"(A)") "  /Author (" // trim(instr) // ")"
         end if
         instr = mf_muesli_version
         L = index( instr, "_" )
         if( L == 0 ) then
            write(unit,"(A)") "  /Producer (Muesli Library " // trim(instr) &
                              // ")"
         else
            L1 = L + 1
            L2 = len_trim(instr)
            L = L - 1
            ! Balanced parenthesis are permitted in a PDF string (only
            ! unbalanced parenthesis need to be escaped).
            write(unit,"(A)") "  /Producer (Muesli Library " // instr(1:L) &
                              // " (" // instr(L1:L2) // "))"
         end if
         call date_and_time( date=date, time=time, zone=zone )
         instr = zone(1:3) // "'" // zone(4:5) // "'"
         write(unit,"(A)") "  /CreationDate (D:" // date // time(1:6)   &
                           // trim(instr) //  ")"
         write(unit,"(A)") ">>"
         write(unit,"(A)") "endobj"
         write(unit,"(A)") ""
      end if

      write(unit,"(I0,A)") pgs_num, " 0 obj <<"
      write(unit,"(A)") "  /Type /Pages"
      write(unit,"(A,I0,A)") "  /Kids [", pag_num, " 0 R]"
      write(unit,"(A)") "  /Count 1"
      write(unit,"(A)") ">>"
      write(unit,"(A)") "endobj"
      write(unit,"(A)") ""

      ! Opening the first Contents
      ! (there is at least one content; eventually it can contain nothing;
      !  it will be closed later on)
      MF_PDF_CURR_CONT = MF_PDF_CURR_CONT + 1
      write(unit,"(I0,A)") MF_PDF_OFF_CONT + MF_PDF_CURR_CONT, " 0 obj <<"
      write(unit,"(A)") "  /Length 0         "
      write(unit,"(A)") ">>"
      write(unit,"(A)") "stream"
      write(unit,"(A)") "0.1 0 0 0.1 0 0 cm"

      PDF_driver_font_begin = .true.

      return

      !-----------------------------------------------------------------
      case( CLOSE_DEV ) ! Close device.

      call flush_buffer()

      ! check
      if( MF_PDF_CURR_IMG /= nb_IMAGES ) then
         print "(/,A)",    "(Muesli FGL:) PDF driver: bad number of images!"
         print "(A,I0,A)", "              The routine 'count_PDF_objects()' has been predict ", nb_IMAGES, " image(s),"
         print "(A,I0)",   "              but the effective number is ", MF_PDF_CURR_IMG
!!         pause "only for debugging purpose"
nb_IMAGES = MF_PDF_CURR_IMG
      end if

      nb_STD_FONTS = count( PS_Std_Fonts_presence(1:7) )

      beg_stdf = pag_num + 1
      end_stdf = pag_num + nb_STD_FONTS

      if( PS_Std_Fonts_presence(8) ) then
         ext_fs1_num = end_stdf + 1
         ext_fs2_num = ext_fs1_num + 1
         ext_fs3_num = ext_fs2_num + 1
         ext_fs4_num = ext_fs3_num + 1
      else
         ext_fs4_num = end_stdf
      end if

      nb_MARKS = count( MF_MARKERS_USED )

      beg_mark = ext_fs4_num + 1
      end_mark = ext_fs4_num + nb_MARKS

      ! fix nb_OCGS if OCMD exist
      nb_OCG_MUTEX = 0
      if( OCMD_exist ) then
         do i = 1, MAX_NUMBER_OCGS
            if( OCG_mutex(i) .and. .not. OCG_mutex_default(i) ) then
               nb_OCG_MUTEX = nb_OCG_MUTEX + 1
            end if
         end do
      end if

      ! up to here, all objects of type {content, image, shadingtype4 and
      ! shadingtype6) have been written.
      if( nb_OCGS == 0 ) then
         end_omut = end_mark
      else
         ocp_num  = end_mark + 1
         beg_ocgs = ocp_num  + 1
         end_ocgs = ocp_num  + nb_OCGS
         beg_omut = end_ocgs + 1
         end_omut = end_ocgs + nb_OCG_MUTEX
      end if
      cat_num  = end_omut + 1
      nb_obj = cat_num

      ! closing last content
      write(unit,"(A)") "endstream"
      write(unit,"(A)") "endobj"
      write(unit,"(A)") ""

      ! if needed, write the colormap
      if( MF_CMAP_USED ) then

         write(unit,"(I0,A)") MF_PDF_OFF_CMAP + MF_PDF_CURR_CMAP, " 0 obj <<"
         write(unit,"(A)") "  /FunctionType 0"
         ! must adapt the best bits_per_sample value; it depends on the length
         ! of the colormap.
!### Theoretically, BITS_PER_SAMPLE doesn't depend on the colormap length;
!    it is a user choice (but also limited by the hardware) to have a good
!    representation of colors; however, it is reasonable to decrease the
!    value of BITS_PER_SAMPLE when the colormap length is small.
         if( COLORMAP_LENGTH <= 16 ) then
            BITS_PER_SAMPLE = 4  !   'F' codes 0 to 15
         else if( COLORMAP_LENGTH <= 256 ) then
            BITS_PER_SAMPLE = 8  !  'FF' codes 0 to 255
         else if( COLORMAP_LENGTH <= 4096 ) then
            BITS_PER_SAMPLE = 12 ! 'FFF' codes 0 to 4096
         else
            print *, "(Muesli FGL:) The EPS driver supports only colormap length <= 4096."
            pause "only for debugging purpose"
            stop "(caused by the EPS driver)"
         end if
         write(unit,"(A,I0)") "  /BitsPerSample ", BITS_PER_SAMPLE
         write(unit,"(A,I0,A)") "  /Size [ ", COLORMAP_LENGTH, " ]"
         write(unit,"(A)") "  /Domain [ 0 1 ]"
         write(unit,"(A)") "  /Range [ 0 1 0 1 0 1 ]"
         write(unit,"(A)") "  /Filter /ASCIIHexDecode"
         write(unit,"(A)") "  /Length 0         "
         write(unit,"(A)") ">>"
         write(unit,"(A)") "stream"
         call write_colormap()
         write(unit,"(A)") "endstream"
         write(unit,"(A)") "endobj"
         write(unit,"(A)") ""

      end if

      ! the writing of this object has been delayed here, because we had to
      ! know the whole BBOX of the image (we are creating a "PDF image", not
      ! a "PDF page").
      write(unit,"(I0,A)") pag_num, " 0 obj <<"
      write(unit,"(A)") "  /Type /Page"
      write(unit,"(A,I0,A)") "  /Parent ", pgs_num, " 0 R"

      ! writing BBOX

      ! divide par 10 to obtain a reasonable image size (not too big)
      ! -> be aware that, after division, we have to round the result
      !    to the lower integer for the two first elements, but to the
      !    upper integer for the two last elements.
      bbox(1:2) =   floor( bbox(1:2)/10.0d0 )
      bbox(3:4) = ceiling( bbox(3:4)/10.0d0 )
      write(unit,"(A,4(I0,1X),A)") "  /MediaBox [ ", bbox(:), "]"

      ! step=2 because contents alternate with images
      write(unit,"(A)",advance="no") "  /Contents [ "
      ! split the written line which may be very long (the driver
      ! supports up to 5000 objects).
      k = 0
      do i = beg_cont, end_cont
         write(unit,"(I0,A)",advance="no") i, " 0 R "
         k = k + int( log10(real(i)) + 1 ) + 5 ! nb of chars added
         if( k > 120 ) then
            write(unit,"()")
            write(unit,"(A)",advance="no") "              "
            k = 0
         end if
      end do
      write(unit,"(A)") "]"
      write(unit,"(A)") "  /Resources <<"

      ! ------- External Graphic States -------
      if( nb_transp >= 1 ) then
         write(unit,"(A)") "    /ExtGState <<"
         do i = 1, nb_transp
            write(unit,"(A,I0,A)") "      /Transp_", i, " <<"
            write(unit,"(A,F5.3)") "        /CA ", transp_table(i)
            write(unit,"(A,F5.3)") "        /ca ", transp_table(i)
            write(unit,"(A)") "      >>"
         end do
         write(unit,"(A)") "    >>"
      end if

      ! ------- Fonts -------
      if( any(PS_Std_Fonts_presence) ) then
         write(unit,"(A)") "    /Font <<"
         k = 0
         do i = 1, NB_MAX_FONTS
            if( PS_Std_Fonts_presence(i) ) then
               k = k + 1
               select case( i )
                  case( 1 ) ! Helvetica
                     write(unit,"(A,I0,A)") "      /Fn ", pag_num+k, " 0 R "
                  case( 2 ) ! Helvetica-Bold
                     write(unit,"(A,I0,A)") "      /FN ", pag_num+k, " 0 R "
                  case( 3 ) ! Times-Roman
                     write(unit,"(A,I0,A)") "      /Fr ", pag_num+k, " 0 R "
                  case( 4 ) ! Times-Bold
                     write(unit,"(A,I0,A)") "      /FR ", pag_num+k, " 0 R "
                  case( 5 ) ! Times-Italic
                     write(unit,"(A,I0,A)") "      /Fi ", pag_num+k, " 0 R "
                  case( 6 ) ! Times-BoldItalic
                     write(unit,"(A,I0,A)") "      /FI ", pag_num+k, " 0 R "
                  case( 7 ) ! Symbol
                     write(unit,"(A,I0,A)") "      /Fg ", pag_num+k, " 0 R "
                  case( 8 ) ! English157BT-Regular
                     write(unit,"(A,I0,A)") "      /Fs ", pag_num+k, " 0 R "
               end select
            end if
         end do
         write(unit,"(A)") "    >>"
      end if

      if( any(MF_MARKERS_USED) .or. nb_IMAGES >= 1 ) then
         ! ------- Markers -------
         write(unit,"(A)") "    /XObject <<"
         k = 0
         do i = 1, NB_MAX_MARKS
            if( MF_MARKERS_USED(i) ) then
               k = k + 1
               write(unit,"(A,I0,A,I0,A)") "      /M", i, " ", ext_fs4_num+k, " 0 R"
            end if
         end do

         ! ------- Images -------
         do i = 1, nb_IMAGES
            write(unit,"(A,I0,A,I0,A)") "      /Im_", i, " ", end_cont+i, " 0 R"
         end do
         write(unit,"(A)") "    >>"
      end if

      ! ------- Shading patterns -------
      if( nb_SHT4 >= 1 .or. nb_SHT6 >= 1 ) then
         write(unit,"(A)") "    /Shading <<"
         if( nb_SHT4 > 0 ) then
            do i = 1, nb_SHT4
               write(unit,"(A,I0,A,I0,A)") "      /Sht4_", i, " ", end_cmap+i, " 0 R"
            end do
         end if
         if( nb_SHT6 > 0 ) then
            do i = 1, nb_SHT6
               write(unit,"(A,I0,A,I0,A)") "      /Sht6_", i, " ", end_sht4+i, " 0 R"
            end do
         end if
         write(unit,"(A)") "    >>"
      end if

      ! ------- Optional Contents -------
      if( nb_OCGS > 0 ) then
         write(unit,"(A)") "    /Properties <<"
         do i = 1, nb_OCGS
            write(unit,"(A,I0,A,I0,A)") "      /OCG_", i, " ", ocp_num+i, " 0 R"
         end do
         write(unit,"(A)") "    >>"
      end if

      write(unit,"(A)") "  >>"
      write(unit,"(A)") ">>"
      write(unit,"(A)") "endobj"
      write(unit,"(A)") ""

      !######################################
      !###     PostScript Type1 FONTS     ###
      !######################################

      k = 0
      do i = 1, NB_MAX_FONTS-1 ! all except the script font
         if( PS_Std_Fonts_presence(i) ) then
            k = k + 1
            write(unit,"(I0,A)") pag_num+k, " 0 obj <<"
            write(unit,"(A)") "  /Type /Font"
            write(unit,"(A)") "  /Subtype /Type1"
            select case( i )
               case( 1 )
                  write(unit,"(A)") "  /BaseFont /Helvetica"
               case( 2 )
                  write(unit,"(A)") "  /BaseFont /Helvetica-Bold"
               case( 3 )
                  write(unit,"(A)") "  /BaseFont /Times-Roman"
               case( 4 )
                  write(unit,"(A)") "  /BaseFont /Times-Bold"
               case( 5 )
                  write(unit,"(A)") "  /BaseFont /Times-Italic"
               case( 6 )
                  write(unit,"(A)") "  /BaseFont /Times-BoldItalic"
               case( 7 )
                  write(unit,"(A)") "  /BaseFont /Symbol"
            end select
            if( i /= 7 ) then
               write(unit,"(A)") "  /Encoding /WinAnsiEncoding"
            end if
            write(unit,"(A)") ">>"
            write(unit,"(A)") "endobj"
            write(unit,"(A)") ""
         end if
      end do

      ! If used, 'englishBT-reg' is embedded in the PDF.
      if( PS_Std_Fonts_presence(8) ) then
         ! Script font
         write(unit,"(I0,A)") ext_fs1_num, " 0 obj <<"
         write(unit,"(A)") "  /Type /Font"
         write(unit,"(A)") "  /Subtype /Type1" ! Type1C not here, but only below
         write(unit,"(A)") "  /BaseFont /MUESLI+English157BT-Regular"
!########## DEBUT DES MODIFS 2020-06-08 : minimum subset
!### oui, 32, car il y aura toujours le /space
         write(unit,"(A)") "  /FirstChar 32"
!### non, a va dpendre des caractres slectionns parmi les 53
         write(unit,"(A)") "  /LastChar 122"
         write(unit,"(A,I0,A)") "  /Widths ", ext_fs2_num, " 0 R"
         write(unit,"(A,I0,A)") "  /FontDescriptor ", ext_fs3_num, " 0 R"
         write(unit,"(A)") "  /Encoding /WinAnsiEncoding"
         write(unit,"(A)") ">>"
         write(unit,"(A)") "endobj"
         write(unit,"(A)") ""

         ! Widths of characters
         write(unit,"(I0,A)") ext_fs2_num, " 0 obj ["
!### non, a va dpendre des caractres slectionns parmi les 53
         write(unit,"(A)") "202 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 650 831 728"
         write(unit,"(A)") "731 650 633 692 592 569 486 686 618 652 574 662 717 703 770 671 590 731 681 719"
         write(unit,"(A)") "613 738 731 0 0 0 0 0 0 423 354 310 423 318 261 405 406 238 252 385 259 599 406"
         write(unit,"(A)") "366 406 427 289 275 268 423 372 562 428 406 363"
         write(unit,"(A)") "]"
         write(unit,"(A)") "endobj"
         write(unit,"(A)") ""

         ! Font Descriptor
         write(unit,"(I0,A)") ext_fs3_num, " 0 obj <<"
         write(unit,"(A)") "  /Type /FontDescriptor"
         write(unit,"(A)") "  /FontName /MUESLI+English157BT-Regular"
         write(unit,"(A)") "  /Flags 40"
         write(unit,"(A)") "  /FontBBox [-438 -256 959 683]"
         write(unit,"(A)") "  /ItalicAngle -36"
         write(unit,"(A)") "  /Ascent 683"
         write(unit,"(A)") "  /Descent -256"
         write(unit,"(A)") "  /CapHeight 683"
         write(unit,"(A)") "  /StemV 143"
!### non, a va dpendre des caractres slectionns parmi les 53
         write(unit,"(A)") "  /CharSet(/space/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z)"
         write(unit,"(A,I0,A)") "  /FontFile3 ", ext_fs4_num, " 0 R"
         write(unit,"(A)") ">>"
         write(unit,"(A)") "endobj"
         write(unit,"(A)") ""

         ! Embedded Font File
         write(unit,"(I0,A)") ext_fs4_num, " 0 obj <<"
         write(unit,"(A)",advance="no") "  /Subtype /Type1C"
         if( COMMENTS_IN_PDF ) then
            write(unit,"(A)") " % Compact Font Format (CFF)"
         else
            write(unit,"(A)") ""
         end if
         write(unit,"(A)") "  /Filter [ /ASCII85Decode /FlateDecode ]"
         write(unit,"(A)") "  /Length 11231     " ! keep blanks after the number
         write(unit,"(A)") ">>"
         write(unit,"(A)") "stream"

!### non, sera remplacer par du deflate+Ascii85  la vole, en fonction
!    des caractres slectionns parmi les 53
         path_to_English157BT = trim(MFPLOT_DIR) // "/fontconfig/fonts/English157BT-Regular-subset.a85"
         open( 10, file=trim(path_to_English157BT), access="sequential", status="old" )
         k = 0 ! counting the lines
         do
            read( 10, "(A)", end=99 ) line
            k = k + 1
            write( unit, "(A)" ) trim(line)
         end do
 99      continue
         close(10)
         if( k /= 70 ) then
            ! Something is wrong in data. Font file corrupted?
            print *, "(Muesli FGL:) PDF driver: Cannot embed the Script Font!"
            print *, "              Read succeeded, but line number is wrong. Corrupted file?"
            pause "only for debugging purpose"
         end if
         if( line(1:4) /= "+7U#" .or. line(118:121) /= "@/~>" ) then
            ! Something is wrong in data. Font file corrupted?
            print *, "(Muesli FGL:) PDF driver: Cannot embed the Script Font!"
            print *, "              Read succeeded, but last line seems wrong. Corrupted file?"
            pause "only for debugging purpose"
         end if
!########## FIN DES MODIFS 2020-06-08 : minimum subset
         write(unit,"(A)") "endstream"
         write(unit,"(A)") "endobj"
         write(unit,"(A)") ""
      end if

      !######################################
      !###            MARKERS             ###
      !######################################

      ! Markers are load from the installation Muesli directory, as
      ! PDF eXternal Objects. The user may add its own markers, by copying
      ! the PDF definition in the subdirectory PDFLibXObj...
!### TODO: use marker from the user is not yet available

      if( nb_MARKS > 0 ) then
         path_to_PDFLibXObj = trim(MFPLOT_DIR) // "/PDFLibXObj"
         k = 0
         do i = 1, NB_MAX_MARKS
            if( MF_MARKERS_USED(i) ) then
               k = k + 1
               call find_unit(unit2)
               write(XObj_filename,"(I0)") i
               XObj_filename = trim(path_to_PDFLibXObj) // "/M"         &
                              // trim(XObj_filename) // ".xobj"
               open( unit=unit2, file=trim(XObj_filename) )
               read( unit2, "(A)", end=9 ) string
               if( trim(string) /= "0 0 obj <<" ) then
                  print *, "(Muesli FGL:) PDF driver: reading an eXternal Object..."
                  print *, "              Bad first line! (corrupted file?)"
                  print *, '              Found: "', trim(string), '"'
                  print *, '              It should be exactly "0 0 obj <<"'
                  pause "only for debugging purpose"
                  stop
               end if
               write(unit,"(I0,A)") ext_fs4_num+k, " 0 obj <<"
               do
                  read( unit2, "(A)", end=9 ) string
                  ! be careful to the "/Length" line...
                  if( string(1:11) == "  /Length 0" ) then
                     write(unit,"(A)") "  /Length 0         " ! 9 blanks at the end
                  else
                     tmp1 = adjustl(string)
                     if( tmp1(1:1) == "%" ) then
                        ! this is a comment: can be usually removed
                        if( COMMENTS_IN_PDF ) then
                           write(unit,"(A)") trim(string)
                        end if
                     else
                        write(unit,"(A)") trim(string)
                     end if
                  end if
               end do
 9             close( unit2 )
               if( trim(string) /= "endobj" ) then
                  print *, "(Muesli FGL:) PDF driver: reading an eXternal Object..."
                  print *, "              bad last line! (corrupted file?)"
                  print *, '              Found: "', trim(string), '"'
                  print *, '              It should be exactly "endobj"'
                  pause "only for debugging purpose"
                  stop
               end if
               write(unit,"(A)") ""
            end if
         end do
      end if

      !######################################
      !###    OPTIONAL CONTENT GROUPS     ###
      !######################################

      if( nb_OCGS > 0 ) then
         write(unit,"(I0,A)") ocp_num, " 0 obj <<"
         write(unit,"(A)",advance="no") "  /OCGs [ "
         if( OCMD_exist ) then
            ! compute shift for secondary OCG
            OCG_OCMD_shift = nb_OCGS - nb_OCG_MUTEX + 1
         else
            OCG_OCMD_shift = 0
         end if
         do i = 1, nb_OCGS
            if( OCMD_exist .and. OCG_mutex(i) ) then
               if( .not. OCG_mutex_default(i) ) then
                  write(unit,"(I0,A)",advance="no") ocp_num+i+OCG_OCMD_shift, " 0 R "
               end if
            else
               write(unit,"(I0,A)",advance="no") ocp_num+i, " 0 R "
            end if
         end do
         write(unit,"(A)") "]"
         write(unit,"(A)") "  /D <<"
         write(unit,"(A)",advance="no") "    /Order [ "
         ! is there any mutex OCGS?
         mutex_OCGS_exist = any(OCG_mutex(1:nb_OCGS))
         ! is there any super-group?
         sg_OCGS_exist = any(OCG_sg(1:nb_OCGS))
         if( mutex_OCGS_exist ) then
            write(unit,"(A)",advance="no") "[(" //                      &
                    trim(pdf_string(trim(OCG_RBGroups_name))) // ") "
            ! first select mutex concerned only
            do i = 1, nb_OCGS
               if( OCG_mutex(i) ) then
                  if( OCMD_exist ) then
                     if( .not. OCG_mutex_default(i) ) then
                        write(unit,"(I0,A)",advance="no") ocp_num+i+OCG_OCMD_shift, " 0 R "
                     end if
                  else
                        write(unit,"(I0,A)",advance="no") ocp_num+i, " 0 R "
                  end if
               end if
            end do
            write(unit,"(A)",advance="no") "] "
            ! then select non mutex OCGS
            if( sg_OCGS_exist ) then
               write(unit,"(A)",advance="no") "[(" //                   &
                    trim(pdf_string(trim(OCG_sg_name))) // ") "
               ! first select super-group OCGS only
               do i = 1, nb_OCGS
                  if( OCG_sg(i) ) then
                     write(unit,"(I0,A)",advance="no") ocp_num+i, " 0 R "
                  end if
               end do
               write(unit,"(A)",advance="no") "] "
               ! then select others (neither super-group OCGS, neither mutex)
               do i = 1, nb_OCGS
                  if( .not. OCG_sg(i) .and. .not. OCG_mutex(i) ) then
                     write(unit,"(I0,A)",advance="no") ocp_num+i, " 0 R "
                  end if
               end do
            else
               do i = 1, nb_OCGS
                  if( .not. OCG_mutex(i) ) then
                     write(unit,"(I0,A)",advance="no") ocp_num+i, " 0 R "
                  end if
               end do
            end if
         else
            if( sg_OCGS_exist ) then
               write(unit,"(A)",advance="no") "[(" //                   &
                    trim(pdf_string(trim(OCG_sg_name))) // ") "
               ! first select super-group OCGS only
               do i = 1, nb_OCGS
                  if( OCG_sg(i) ) then
                     write(unit,"(I0,A)",advance="no") ocp_num+i, " 0 R "
                  end if
               end do
               write(unit,"(A)",advance="no") "] "
               ! then select non super-group OCGS
               do i = 1, nb_OCGS
                  if( .not. OCG_sg(i) ) then
                     write(unit,"(I0,A)",advance="no") ocp_num+i, " 0 R "
                  end if
               end do
            else
               do i = 1, nb_OCGS
                  write(unit,"(I0,A)",advance="no") ocp_num+i, " 0 R "
               end do
            end if
         end if
         write(unit,"(A)") "]"
         ! add also a RBGroups (Radio-Button Groups) list
         if( mutex_OCGS_exist ) then
            write(unit,"(A)",advance="no") "    /RBGroups [ [ "
            do i = 1, nb_OCGS
               if( OCG_mutex(i) ) then
                  if( OCMD_exist ) then
                     if( .not. OCG_mutex_default(i) ) then
                        write(unit,"(I0,A)",advance="no") ocp_num+i+OCG_OCMD_shift, " 0 R "
                     end if
                  else
                        write(unit,"(I0,A)",advance="no") ocp_num+i, " 0 R "
                  end if
               end if
            end do
            write(unit,"(A)") "] ]"
         end if
         write(unit,"(A)",advance="no") "    /ON [ "
         do i = 1, nb_OCGS
            if( OCG_value(i) == 1 ) then
               if( .not. ( OCMD_exist .and. OCG_mutex(i) ) ) then
                  write(unit,"(I0,A)",advance="no") ocp_num+i, " 0 R "
               end if
            end if
         end do
         write(unit,"(A)") "]"
         write(unit,"(A)",advance="no") "    /OFF [ "
         do i = 1, nb_OCGS
            if( OCMD_exist .and. OCG_mutex(i) ) then
               if( .not. OCG_mutex_default(i) ) then
                  write(unit,"(I0,A)",advance="no") ocp_num+i+OCG_OCMD_shift, " 0 R "
               end if
            else
               if( OCG_value(i) == 0 ) then
                  write(unit,"(I0,A)",advance="no") ocp_num+i, " 0 R "
               end if
            end if
         end do
         write(unit,"(A)") "]"
         write(unit,"(A)") "  >>"
         write(unit,"(A)") ">>"
         write(unit,"(A)") "endobj"
         write(unit,"(A)") ""
      end if

      !######################################
      !### OCGs NAMES and associated OCMD ###
      !######################################

      ! (Names for OCG)
      do i = 1, nb_OCGS
         write(unit,"(I0,A)") ocp_num+i, " 0 obj <<"
         if( OCMD_exist .and. OCG_mutex(i) ) then
            write(unit,"(A)") "  /Type /OCMD"
            if( OCG_mutex_default(i) ) then
               write(unit,"(A)",advance="no") "  /VE [ /And "
               do j = 1, nb_OCGS
                  if( j == i ) cycle
                  if( .not. OCG_mutex(j) ) cycle
                  write(unit,"(A,I0,A)",advance="no") "[ /Not ",        &
                              ocp_num+j+OCG_OCMD_shift, " 0 R ] "
               end do
               write(unit,"(A)") "]"
            else
               write(unit,"(A,I0,A)") "  /VE [ /And ",                  &
                              ocp_num+i+OCG_OCMD_shift, " 0 R ]"
            end if
         else
            write(unit,"(A)") "  /Type /OCG"
            write(unit,"(A)") "  /Name (" //                            &
                              trim(pdf_string(trim(OCG_name(i)))) // ")"
         end if
         write(unit,"(A)") ">>"
         write(unit,"(A)") "endobj"
         write(unit,"(A)") ""
      end do

      ! Secondary OCGs with their name.
      do i = 1, nb_OCGS
         if( OCMD_exist .and. OCG_mutex(i) ) then
            if( .not. OCG_mutex_default(i) ) then
               write(unit,"(I0,A)") ocp_num+i+OCG_OCMD_shift, " 0 obj <<"
               write(unit,"(A)") "  /Type /OCG"
               write(unit,"(A)") "  /Name (" //                         &
                                 trim(pdf_string(trim(OCG_name(i)))) // ")"
               write(unit,"(A)") ">>"
               write(unit,"(A)") "endobj"
               write(unit,"(A)") ""
            end if
         end if
      end do

      !######################################
      !###            CATALOG             ###
      !######################################

      write(unit,"(I0,A)") cat_num, " 0 obj <<"
      write(unit,"(A)") "  /Type /Catalog"
      write(unit,"(A,I0,A)") "  /Pages ", pgs_num, " 0 R"
      if( nb_OCGS > 0 ) then
         write(unit,"(A,I0,A)") "  /OCProperties ", ocp_num, " 0 R"
      end if
      write(unit,"(A)") ">>"
      write(unit,"(A)") "endobj"
      write(unit,"(A)") ""

      !######################################
      !###     CROSS REFERENCE TABLE      ###
      !######################################

      write(unit,"(A)") "xref"
      write(unit,"(A,I0)") "0 ", nb_obj+1
#ifdef _WINDOWS
         write(unit,"(A)") "0000000000 65535 f"
#else
         write(unit,"(A)") "0000000000 65535 f "
#endif
      ! addresses will be computed later on (by post_pdfdriv)
      do i = 1, nb_obj
#ifdef _WINDOWS
         write(unit,"(A)") "0000000000 00000 n"
#else
         write(unit,"(A)") "0000000000 00000 n "
#endif
      end do
      write(unit,"(A)") ""
      write(unit,"(A)") "trailer <<"
      write(unit,"(A,I0)") "  /Size ", nb_obj+1
      write(unit,"(A,I0,A)") "  /Root ", cat_num, " 0 R"
if( .not. anonymous_pdf ) then
      write(unit,"(A,I0,A)") "  /Info ", inf_num, " 0 R"
end if
      write(unit,"(A)") ">>"
      write(unit,"(A)") "startxref"
      write(unit,"(A)") "0         " ! will be computed later on
      write(unit,"(A)") "%%EOF" ! this is the end of the file.

      if( .not. stdout ) then

         close( unit, iostat=ioerr )
         if( ioerr /= 0 ) then
            call grwarn( "Error closing PDF file " // fname(:lfname) )
            state = 0
            return
         end if

         ! computed all xref adresses and stream lengths inside the PDF,
         ! in order to be standard compliant...
         ! (using the same unit, since the file has just been closed)
         call post_pdfdriv( unit, fname, ioerr )
         if( ioerr /= 0 ) then
            call grwarn( "An error occured during the post-processing of" &
                         // " the PDF file. Perhaps it will be not valid..." )
            state = 0
            return
         end if

      end if
      state = 0

      return

      !-----------------------------------------------------------------
      case( BEGIN_PICT ) ! Begin picture.
                         ! (called from grbpic)

      WIDTH  = ibuf(1)
      HEIGHT = ibuf(2)

      mfac = 0.0d0

      if( nb_string_saved > 0 ) then
         call flush_buffer()
         do i = 1, nb_string_saved
            write(unit,"(A)") trim(string_saved(i))
         end do
         nb_string_saved = 0
      end if
      init_ok = .true.

      return

      !-----------------------------------------------------------------
      case( DRAW_POLYLINE ) ! Draw polyline (multiple straight segments).

      if( lchr == 1 ) then

         if( chr == "s" ) then
            polyline_start = .true.
            in_polyline = .true.
            something_has_been_written = .false.
            return
         else if( chr == "e" ) then
            ! Force to locate "S" at the beginning of the line, to make
            ! possible to remove it, in case of continuity with the next
            ! polyline...
            if( lobuf+28 > lobuf_max ) then
               call flush_buffer()
            end if
            ! Perhaps all the points have been removed due to one or many
            ! zero-length segment(s); in such a case, we cannot write "S"
            ! alone (this would cause problem with continuation process
            ! with the next segment).
            polyline_start = .false.
            in_polyline = .false.
            if( something_has_been_written ) then
               instr = "S"
            else
               return
            end if
         end if

      else

         i0 = ibuf(1)
         j0 = ibuf(2)
         i1 = ibuf(3)
         j1 = ibuf(4)

         ! Suppress zero-length continuation segment.
         ! Should NOT be reported in pgline, because here the resolution
         ! of the device is low (w.r.t. double precision) and it can occur
         ! more frequently.
         if( i0 == i1 .and. j0 == j1 ) return

         if( in_polyline ) then

            if( polyline_start ) then
               bool_1 = i0 == lasti .and. j0 == lastj
               if( lobuf > 0 ) then
                  bool_2 = obuf(lobuf:lobuf) == "S"
               else
                  bool_2 = .false.
               end if
               if( bool_1 .and. bool_2 ) then
                  ! Last command was a polyline
                  lobuf = max( 0, lobuf-2 ) ! discard the previous "S" command
                  write( instr, "(2(I0,1X),A)" ) i1, j1, "l"
               else
                  write( instr, "(2(I0,1X),A,1X,2(I0,1X),A)" )          &
                         i0, j0, "m", i1, j1, "l"
               end if
               polyline_start = .false.
            else
               ! Some points may have been removed (presence of NaN),
               ! therefore we must test the continuity...
               if( i0 == lasti .and. j0 == lastj ) then
                  write( instr, "(2(I0,1X),A)" ) i1, j1, "l"
               else
                  write( instr, "(A,1X,2(I0,1X),A,1X,2(I0,1X),A)" )     &
                         "S", i0, j0, "m", i1, j1, "l"
               end if
            end if
            lasti = i1
            lastj = j1
            something_has_been_written = .true.

         else
            ! Standard case (not optimized) -- normally rarely called
            write( instr, "(2(I0,1X),A,1X,2(I0,1X),A)" )                &
               i0, j0, "m", i1, j1, "l S"
         end if

      end if

      !-----------------------------------------------------------------
      case( END_PICT ) ! End picture.

      return

      !-----------------------------------------------------------------
      case( SELECT_COL_IND ) ! Select color index.
                 ! (called from grsci)

      call flush_buffer()

      ci = ibuf(1)

      call rm_trail_zeros_in_flt( rvalue(ci), "(F5.3)", str1 )
      call rm_trail_zeros_in_flt( gvalue(ci), "(F5.3)", str2 )
      call rm_trail_zeros_in_flt( bvalue(ci), "(F5.3)", str3 )
      if( ibuf(3) == 2 ) then
         pdf_color_intent = ibuf(2)
         if( pdf_color_intent == 1 ) then
            ! 'stroke' only
            if( rvalue(ci) == gvalue(ci) .and. rvalue(ci) == bvalue(ci) ) then
               write(instr,"(A)") trim(str1) // " G"
            else
               write(instr,"(A)") trim(str1) // " " // trim(str2) // " " // &
                                  trim(str3) // " RG"
            end if
         else if( pdf_color_intent == 2 ) then
            ! 'fill' only
            if( rvalue(ci) == gvalue(ci) .and. rvalue(ci) == bvalue(ci) ) then
               write(instr,"(A)") trim(str1) // " g"
            else
               write(instr,"(A)") trim(str1) // " " // trim(str2) // " " // &
                                  trim(str3) // " rg"
            end if
         else
            ! 'stroke' and 'fill'
            if( rvalue(ci) == gvalue(ci) .and. rvalue(ci) == bvalue(ci) ) then
               write(instr,"(A)") trim(str1) // " G " // trim(str1) // " g"
            else
               write(instr,"(A)") trim(str1) // " " // trim(str2) // " " // &
                                  trim(str3) // " RG " //                   &
                                  trim(str1) // " " // trim(str2) // " " // &
                                  trim(str3) // " rg"
            end if
         end if
         if( pdf_color_intent < 1 .or. 3 < pdf_color_intent ) then
            call grwarn( "(Muesli FGL:) internal error!" )
            print *, "PDF driver: bad pdf_color_intent."
            print *, "(DBG:) pdf_color_intent = ", pdf_color_intent
            print *, "       expected value: 1, 2 or 3."
            pause "(for debugging purpose)"
         end if
      else ! ibuf(3) == 1
         ! (called perhaps from grbpic)
         ! for 'stroke'
         if( rvalue(ci) == gvalue(ci) .and. rvalue(ci) == bvalue(ci) ) then
            write(instr,"(A)") trim(str1) // " G"
         else
            write(instr,"(A)") trim(str1) // " " // trim(str2) // " " // &
                               trim(str3) // " RG"
         end if
      end if

      !-----------------------------------------------------------------
      case( FLUSH_BUF ) ! Flush buffer.
                        ! (no effect on hardcopy devices.)

      return

      !-----------------------------------------------------------------
      case( SET_LINE_STYLE ) ! Set line style
                             ! (called only from grsls)

      line_style = ibuf(1)
      ! Treat the special case of inverted dashes
      if( line_style == 5 ) then
        line_style = 2
        dash_offset = -1
      else
        dash_offset = 0
      end if

      select case( line_style )
         case( 1 ) ! continuous (default)
            instr = "[] 0 d"
            dash_pattern_period = 0
         case( 2 ) ! dashed
            ! for linewidth=1 (default) pattern = [200 200]
            n1 = dash_length_1*sqrt(current_linewidth)
            if( dash_offset == -1 ) dash_offset = n1
            write( instr, "(A,I0,1X,I0,A,1X,I0,1X,A)" )                 &
                   "[", n1, n1, "]", dash_offset, "d"
            dash_pattern_period = n1 + n1
         case( 3 ) ! dot-dash
            ! for linewidth=1 (default) pattern = [200 120 21 120]
            n1 = dash_length_1*sqrt(current_linewidth)
            n2 = dash_length_2*sqrt(current_linewidth)
            n3 = dash_length_3*sqrt(current_linewidth)
            write( instr, "(A,I0,1X,I0,1X,I0,1X,I0,A,1X,I0,1X,A)" )     &
                   "[", n1, n2, n3, n2, "]", 0, "d"
            dash_pattern_period = n1 + n2 + n3 + n2
         case( 4 ) ! dotted
            ! for linewidth=1 (default) pattern = [21 120]
            n2 = dash_length_2*sqrt(current_linewidth)
            n3 = dash_length_3*sqrt(current_linewidth)
            write( instr, "(A,I0,1X,I0,A,1X,I0,1X,A)" )                 &
                   "[", n3, n2, "]", 0, "d"
            dash_pattern_period = n3 + n2
      end select

      !-----------------------------------------------------------------
      case( POLYGON_FILL ) ! Polygon fill.
                           ! (called from grfa)

      call flush_buffer()

      npts = ibuf(1)

      ! first point
      i0 = ibuf(2)
      j0 = ibuf(3)
      write( instr, "(2(I0,1X),A)" ) i0, j0, "m"
      call fill_buffer()

      ! intermediate points
      do i = 2, npts - 1
         i0 = ibuf(2*i)
         j0 = ibuf(2*i+1)
         write( instr, "(2(I0,1X),A)" ) i0, j0, "l"
         call fill_buffer()
      end do

      ! last point
      i0 = ibuf(2*npts)
      j0 = ibuf(2*npts+1)
      write( instr, "(2(I0,1X),A)" ) i0, j0, "l f" ! "f" = close and fill
      call fill_buffer()

      lasti = int_not_defined
      lastj = int_not_defined

      return

      !-----------------------------------------------------------------
      case( SET_COL_REPRES ) ! Set color representation.

      ci = ibuf(1)
      rvalue(ci) = rbuf(1)
      gvalue(ci) = rbuf(2)
      bvalue(ci) = rbuf(3)

      return

      !-----------------------------------------------------------------
      case( SET_LINE_WIDTH ) ! Set line width.

      lw = rbuf(1)

      current_linewidth = lw ! without the factor below

      ! fix line width to match X11 rendering (same apparent width when
      ! the scaling of the figures are the same)
      lw = lw*6.6667d0

      call rm_trail_zeros_in_flt( lw, "(F8.3)", str1 )
      write( instr, "(A)" ) trim(str1) // " w"

      !-----------------------------------------------------------------
      case( ESCAPE ) ! Escape.

      call flush_buffer()

      write(unit,"(A)") chr ! not trim(chr), because some spaces may be added
                            ! in order to written the length of streams
                            ! (cf. post_pdfdriv.f90)
      return

      !-----------------------------------------------------------------
      case( RECT_FILL ) ! Rectangle fill. (boundary not stroked)
                 ! Called from grrect (via grrec0)

      call flush_buffer()

      i0 = ibuf(1)
      j0 = ibuf(2)
      i1 = ibuf(3)
      j1 = ibuf(4)

      write(unit,"(4(I0,1X),A)") i0, j0, i1-i0, j1-j0, "re F"

      return

      !-----------------------------------------------------------------
      case( RECT_DRAW ) ! Draw Rectangle.
                 ! Called from grrect (via grrec0)

      call flush_buffer()

      i0 = ibuf(1)
      j0 = ibuf(2)
      i1 = ibuf(3)
      j1 = ibuf(4)

      write(unit,"(4(I0,1X),A)") i0, j0, i1-i0, j1-j0, "re S"

      return

      !-----------------------------------------------------------------
      case( SET_LINE_CAP_JOIN_STYLE ) ! Set Line Cap and Join Style.

      lc = ibuf(1)
      lj = ibuf(2)

      write( instr, "(I0,A,I0,A)" ) lc, " j ", lj, " J"

      !-----------------------------------------------------------------
      case( GET_COL_REPRES ) ! Query color representation.

      ci = ibuf(1)
      rbuf(1) = rvalue(ci)
      rbuf(2) = gvalue(ci)
      rbuf(3) = bvalue(ci)
      ibuf(1) = 4

      return

      !-----------------------------------------------------------------
      case( DRAW_BEZIER_SEGM ) ! Draw Bzier segment.

      call flush_buffer()

      ! RBUF(1) to RBUF(8) contain x-y device coords of the four
      ! control-points of one Bzier segment.
      ! They are converted to integer in variables :
      ! (I0,J0), (I1,J1), (I2,J2), (I3,J3)
      ! BoundingBox can be updated because of the convexity property of
      ! the Bzier curve.

      ! Warning: BBox update: no need... there is always a clipping around
      !          the axes.

      i0 = ibuf(1)
      j0 = ibuf(2)
      i1 = ibuf(3)
      j1 = ibuf(4)
      i2 = ibuf(5)
      j2 = ibuf(6)
      i3 = ibuf(7)
      j3 = ibuf(8)

      write( unit, "(2(I0,1X),A)" ) i0, j0, "m"
      write( unit, "(6(I0,1X),A)" ) i1, j1, i2, j2, i3, j3, "c S"

      return

      !-----------------------------------------------------------------
      case( GET_DEF_SIZE_VIRT ) ! Get the user or default size (in pixels)
         ! of a virtual X11 window. This is required to get exactly the same
         ! results when X11 is On or Off.
         ! This is not the X11 window size, but the max plotting area.

      X11_grxmxa  = ibuf(1)
      X11_grymxa  = ibuf(2)

      return

      !-----------------------------------------------------------------
      case( WRITE_COLORMAP_IF ) ! Write the colormap if needed

      ! ibuf(1) not used for PDF (only for EPS)
      COLORMAP_CI_LOW  = ibuf(2)
      COLORMAP_CI_HIGH = ibuf(3)
      COLORMAP_LENGTH = COLORMAP_CI_HIGH - COLORMAP_CI_LOW + 1

      ! actually, the writing of the colormap is delayed up to the closing
      ! of the device...

      return

      !-----------------------------------------------------------------
      case( DRAW_MARKER ) ! Draw Marker.

      call flush_buffer()

      nsym = ibuf(1)
      i1 = ibuf(2)
      j1 = ibuf(3)
      mfac = rbuf(1) ! output scale factor
!### TODO: mfac was designed for EPS, here we have to enlarge it slightly...
!!      mfac = mfac*1.3

      ! Output code for this marker if necessary
      ! Currently markers 1 to 21 are always embedded in the PDF

      write(unit,"(A)") "q"
      ! write compact form of the following PDF command:
      ! mfac 0 0 mfac i1 j1 cm
      call rm_trail_zeros_in_flt( mfac, "(F10.3)", str1 )
      write( instr, "(I0,1X,I0,1X,A)" ) i1, j1, "cm"
      instr = trim(str1) // " 0 0 " // trim(str1) // " " // instr
      write(unit,"(A)") trim(instr)
      ! no space between M and the following number:
      write( instr, "('/M',I0)" ) nsym
      instr = trim(instr) // " Do"
      write(unit,"(A)") trim(instr)
      write(unit,"(A)") "Q" ! = grestore
      LAST_LINEWIDTH_IS_VALID = .false.
      LAST_LINESTYLE_IS_VALID = .false.
      LAST_FONT_ATTRIB_IS_VALID = .false.

      return

      !-----------------------------------------------------------------
      case( PDF_RECORD_OCG )
             ! PDF Optional Content: record the OCG names and value.
             !                                      chr       ibuf(1)

      OCG_sg(OC_num) = ibuf(1) == 1
      if( OCG_sg(OC_num) ) then
         if( OCG_sg_name == "" ) then
            OCG_sg_name = chr
         else ! check for a unique mutex name
            if( trim(chr) /= trim(OCG_sg_name) ) then
               print "(A)", "(MUESLI:) ERROR! The PDF driver has detected that there exist more"
               print "(A)", "          than one unique name for the 'super-group Optional Contents'."
               pause "(for debugging purpose)"
               return
            end if
         end if
      end if

      return

      !-----------------------------------------------------------------
      case( UPDATE_TRANSP_TABLE ) ! Update the table of transparencies

      ! get rbuf(1) as new request of opacity
      transp_request = rbuf(1)
      ! search this transparency in the table and, if not found,
      ! create a new entry
      found = .false.
      do i = 1, nb_transp
         if( transp_request == transp_table(i) ) then
            found = .true.
            ibuf(1) = i
            exit
         end if
      end do
      if( .not. found ) then
         if( nb_transp + 1 > MAX_NB_TRANSP ) then
            print "(A)", "(MUESLI:) PDF driver: max number of transparency values has been reached!"
            print "(A,I0,A)", "          (current max. number is ", MAX_NB_TRANSP, ")"
            pause "(for debugging purpose)"
            return
         end if
         nb_transp = nb_transp + 1
         transp_table(nb_transp) = transp_request
         ibuf(1) = nb_transp
      end if

      return

      !-----------------------------------------------------------------
      case( BITMAP_IMAGE ) ! Bitmap image.

      call flush_buffer()

      n = ibuf(1)
      if( n == 0 ) then
         ! First: setup for image
         nxp = ibuf(2)
         nyp = ibuf(3)
         ! Set clipping region (rbuf(1:4))
         xorg = nint(rbuf(1))
         xlen = nint(rbuf(2) - rbuf(1))
         yorg = nint(rbuf(3))
         ylen = nint(rbuf(4) - rbuf(3))

         ! this is a new bitmap image
         MF_PDF_CURR_IMG = MF_PDF_CURR_IMG + 1

         ! clipping is recommended for bitmap images, especially if the number
         ! of pixels is low (e.g. few dizains); this comes from an old defect
         ! of MFPLOT which center the middle of the BL corner pixel at the
         ! origin of the axes (however, it was good for joining images).
!### TODO: This may be corrected in pgimag.f90 and Image_Core (Image_aux.f90)
         write(unit,"(A)") "q" ! = gsave
         write(unit,"(4(I0,1X,I0,A))") xorg, yorg, " m ",               &
                           xorg+xlen, yorg, " l ",                      &
                           xorg+xlen, yorg+ylen, " l ",                 &
                           xorg, yorg+ylen, " l h W n"

         ! write position in the current PDF object
         ! 'cm' is the matrix transformation, in rbuf(5:10), not used.
         ! the inverted matrix is in in rbuf(11:14), and the determinant
         ! in rbuf(15), from grimg1.
         SQRT_FAC = sqrt(abs(rbuf(15)))
         ! La correction est diffrente suivant l'origine de l'image :
         !      (1) bitmap importe (via 'pgimag')
         !   ou (2) colorbar (via 'pgwedg')
         if( MF_PDF_IN_COLORBAR ) then
            x_shift = 0.
            y_shift = 0.
         else ! comes from pgimag
            x_shift = (nyp-0.5)*SQRT_FAC ! yes 'nyp' because of 90 rotation
            y_shift = -0.5*SQRT_FAC
         end if
!### TODO: Ci-dessous est sans doute un cas particulier avec rotation
!           angle droit... Il semble qu'il faille un signe moins au 4e terme...
if( MF_PDF_IN_COLORBAR .and. COLORBAR_VERT ) then
   ! fix for a strange inversion of colors
   ! when colorbar is displayed in a vertical position...
   write(unit,"(6(I0,1X),A)") -nint(nxp*rbuf(11)), nint(nxp*rbuf(12)),  &
                              -nint(nyp*rbuf(13)),-nint(nyp*rbuf(14)),  &
                               nint(rbuf(1)+x_shift),                   &
                               nint(rbuf(3)+y_shift), "cm"
   write(unit,"(A)") "1 0 0 1 -1 -1 cm"
else
         write(unit,"(6(I0,1X),A)") nint(nxp*rbuf(11)), nint(nxp*rbuf(12)), &
                                   -nint(nyp*rbuf(13)), nint(nyp*rbuf(14)), &
                                    nint(rbuf(1)+x_shift),                  &
                                    nint(rbuf(3)+y_shift), "cm"
end if

         write(unit,"(A,I0,A)") "/Im_", MF_PDF_CURR_IMG, " Do"
         write(unit,"(A)") "Q" ! = grestore
         LAST_LINEWIDTH_IS_VALID = .false.
         LAST_LINESTYLE_IS_VALID = .false.
         LAST_FONT_ATTRIB_IS_VALID = .false.

         ! close the current content
         write(unit,"(A)") "endstream"
         write(unit,"(A)") "endobj"
         write(unit,"(A)") ""

         ! open the new image: write the image itself as an XObject Image
         write(unit,"(I0,A)") MF_PDF_OFF_IMG + MF_PDF_CURR_IMG, " 0 obj <<"
         write(unit,"(A)") "  /Type /XObject"
         write(unit,"(A)") "  /Subtype /Image"
         write(unit,"(A,I0)") "  /Name /Im_", MF_PDF_CURR_IMG
         write(unit,"(A,I0)") "  /Width ", nxp
         write(unit,"(A,I0)") "  /Height ", nyp
         write(unit,"(A)") "  /ColorSpace /DeviceRGB"
         write(unit,"(A)") "  /BitsPerComponent 8"
         if( MF_DEFLATE_TO_A85 ) then
            write(unit,"(A)") "  /Filter [ /ASCII85Decode /FlateDecode ]"
         else
            write(unit,"(A)") "  /Filter [ /ASCIIHexDecode /FlateDecode ]"
         end if
         write(unit,"(A)") "  /Length 0         "
         write(unit,"(A)") ">>"
         write(unit,"(A)") "stream"

         string_out = ""
         len_out = len(string_out)

         ! image 24 bits -> 8 bits/comp. -> 2 car. hexa -> Z2
         !                                  ou 1 octet (integer*1)

         job = 1
         if( MF_DEFLATE_TO_A85 ) then
            fnameC = trim(fname) // char(0)
            lfnameC = lfname + 1
            close( unit ) ! because the following routine writes
                          ! directly in the PDF file.
            call deflate_stream_to_a85( fnameC, lfnameC,                &
                                        int_in, 0, job, ier )
         else
            !  l'initialisation, on a besoin de 'len_in' pour allouer une
            ! fois pour toute le tableau de compression 'compr_str'
            len_in = len_in_max
            call deflate_stream_to_hex( int_in, len_in,                 &
                                        string_out, len_out,            &
                                        job, ier )
         end if
         len_in = 0
      else if( n == -1 ) then
         ! Last: terminate image
         if( len_in /= 0 ) then
            ! on compresse et on crit dans le PDF
            job = 3
            len_out = len(string_out)
            if( MF_DEFLATE_TO_A85 ) then
               call deflate_stream_to_a85( "", 0,                       &
                                           int_in, len_in, job, ier )
               ! reopen the file, close at step 1.
               open( unit, file=trim(fname), position="append" )
            else
               call deflate_stream_to_hex( int_in, len_in,              &
                                           string_out, len_out,         &
                                           job, ier )
            end if
            if( ier /= 0 ) then
               write(STDERR,*) "(MFPLOT:) PDF driver/26 -- writing image"
               write(STDERR,*) "          ERROR while deflating image"
               return
            end if
            if( .not. MF_DEFLATE_TO_A85 ) then
               L = 0
               ! on crit la chane rsultante de ZLIB par ligne de
               ! 132 caractres
               ! (c'est la largeur utilise dans MFPLOT pour les EPS/PDF)
               do
                  if( L >= len_out ) exit
                  if( L+132 >= len_out ) then
                     write(unit,"(A)") string_out(L+1:len_out)
                     exit
                  else
                     write(unit,"(A)") string_out(L+1:L+132)
                     L = L + 132
                  end if
               end do
            end if
         end if
         if( MF_DEFLATE_TO_A85 ) then
            write(unit,"(A)") "~>" ! End-Of-Data for PDF (ASCII85)
         else
            write(unit,"(A)") ">" ! End-Of-Data for PDF (HEXA)
         end if
         write(unit,"(A)") "endstream"
         write(unit,"(A)") "endobj"
         write(unit,"(A)") ""

         ! open a new content
         MF_PDF_CURR_CONT = MF_PDF_CURR_CONT + 1
         write(unit,"(I0,A)") MF_PDF_OFF_CONT + MF_PDF_CURR_CONT, " 0 obj <<"
         write(unit,"(A)") "  /Length 0         "
         write(unit,"(A)") ">>"
         write(unit,"(A)") "stream"
      else
         ! this part may be called many times !
         ! Middle: write N image pixels.
         do i = 1, n
            ci = ibuf(i+1)
            rgb(1) = nint(255.0*rvalue(ci))
            rgb(2) = nint(255.0*gvalue(ci))
            rgb(3) = nint(255.0*bvalue(ci))

            if( len_in+3 > len_in_max ) then
               ! on compresse
               job = 2
               len_out = len(string_out)
               if( MF_DEFLATE_TO_A85 ) then
                  call deflate_stream_to_a85( "", 0,                    &
                                              int_in, len_in, job, ier )
               else
                  call deflate_stream_to_hex( int_in, len_in,           &
                                              string_out, len_out,      &
                                              job, ier )
               end if
               if( ier /= 0 ) then
                  write(STDERR,*) "(MFPLOT:) PDF driver/26 -- writing image"
                  write(STDERR,*) "          ERROR while deflating image"
                  print *
                  print *, " [Return to resume...]"
                  read *
                  return
               end if

               if( .not. MF_DEFLATE_TO_A85 ) then
                  L = 0
                  ! on crit la chane rsultante de ZLIB par ligne de
                  ! 132 caractres
                  ! (c'est la largeur utilise dans MFPLOT pour les PS)
                  do
                     if( L >= len_out ) exit
                     if( L+132 >= len_out ) then
                        write(unit,"(A)") string_out(L+1:len_out)
                        exit
                     else
                        write(unit,"(A)") string_out(L+1:L+132)
                        L = L + 132
                     end if
                  end do
               end if
               len_in = 0
            end if

            ! on remplit un buffer de 32 ko
            len_in = len_in + 1
            int_in(len_in) = rgb(1)
            len_in = len_in + 1
            int_in(len_in) = rgb(2)
            len_in = len_in + 1
            int_in(len_in) = rgb(3)

         end do

      end if

      return

      !-----------------------------------------------------------------
      case( ADD_COMMENT_EPS_PDF ) ! Add a comment in the PDF file.

      call flush_buffer()

      ! if initialization not yet done (cf. IFUNC=11), push the string
      ! in a buffer
      if( .not. init_ok ) then
         nb_string_saved = nb_string_saved + 1
         string_saved(nb_string_saved) = chr
      else
         write(unit,"(A)") trim(chr)
      end if

      return

      !-----------------------------------------------------------------
      case( PDF_BDC_TAG ) ! PDF Optional Content: insert a BDC tag, and
         ! record the integer num of the optional content.
         ! (BDC: Begin Dictionary Content)

      call flush_buffer()

      ! be aware that values of ibuf(1)=PDF_OC_num (sent by mf_win_redraw)
      ! are not sorted.
      OC_num = ibuf(1)
      nb_OCGS = max( OC_num, nb_OCGS )

      if( nb_OCGS >= MAX_NUMBER_OCGS ) then
         print "(A)", "(MUESLI:) PDF driver: max number of OCG has been reached!"
         print "(A,I0,A)", "          (current max. number is ", MAX_NUMBER_OCGS, ")"
         pause "(for debugging purpose)"
         return
      end if
      write(unit,"(A,I0,A)") "/OC /OCG_", OC_num, " BDC"
      OCG_mutex(OC_num) = ibuf(2) == 1
      if( OCG_mutex(OC_num) ) then
         if( OCG_RBGroups_name == "" ) then
            OCG_RBGroups_name = chr
         else ! check for a unique mutex name
            if( trim(chr) /= trim(OCG_RBGroups_name) ) then
               print "(A)", "(MUESLI:) ERROR! The PDF driver has detected that there exist more"
               print "(A)", "          than one unique name for the 'mutex Optional Contents'."
               pause "(for debugging purpose)"
               return
            end if
         end if
      end if
      OCG_mutex_default(OC_num) = ibuf(3) == 1
      if( OCG_mutex_default(OC_num) ) then
         OCMD_exist = .true.
      end if

      return

      !-----------------------------------------------------------------
      case( PDF_EMC_TAG )
         ! PDF Optional Content: record the OCG names and value.
         !                                      chr       ibuf(1)
         ! (EMC: End Marked Content)

      call flush_buffer()

      OCG_name(OC_num) = chr
      OCG_value(OC_num) = ibuf(1)

      write(unit,"(A)") "EMC"

      return

      !-----------------------------------------------------------------
      case( UPDATE_BBOX ) ! Update BBox.

      bbox(1:4) = ibuf(1:4)

      return

      !-----------------------------------------------------------------
      case( GET_DASH_PERIOD ) ! Get the Dash Pattern Period.

      ibuf(1) = dash_pattern_period

      return

      !-----------------------------------------------------------------
      case( SET_CLIPPING ) ! Set Clipping
                 ! Do nothing (but this opcode must be present for
                 ! compatibility reasons with the X11 driver).

      return

      !-----------------------------------------------------------------
      case default ! Error: unimplemented opcode.

      write( msg, "('Unimplemented opcode in PDF device driver: ',I0)" ) ifunc
      call grwarn( msg )
      pause "only for debugging purpose"

      return

   end select

   call fill_buffer()

contains
!_______________________________________________________________________
!
   subroutine fill_buffer()

      instr = adjustl(instr) ! sometimes, space(s) preceed(s) the text
      L = len_trim(instr)

      if( lobuf+L+1 > lobuf_max ) then
         call flush_buffer()
         obuf(1:L) = instr(1:L)
         lobuf = L
      else
         if( lobuf >= 1 ) then
            ! insert a space to separate commands
            lobuf = lobuf + 1
            obuf(lobuf:lobuf) = " "
         end if
         obuf(lobuf+1:lobuf+L) = instr(1:L)
         lobuf = lobuf + L
      end if

   end subroutine fill_buffer
!_______________________________________________________________________
!
   subroutine flush_buffer()

      if( lobuf /= 0 ) then
         write(unit,"(A)") obuf(1:lobuf)
         lobuf = 0
      end if

   end subroutine flush_buffer
!_______________________________________________________________________
!
   subroutine write_colormap()
      integer :: i, k, col(3), v
      character(len=16) :: format
      !----------------
      select case( BITS_PER_SAMPLE )
         case( 4 )
            format = "(3(Z1.1))"
         case( 8 )
            format = "(3(Z2.2))"
         case( 12 )
            format = "(3(Z3.3))"
         case default
            print *, "(Muesli FGL:) internal error in the EPS driver."
            print *, "              Bad value for BITS_PER_SAMPLE (should be 4, 8 or 12)"
            print "(15X,A,I0)", "Current value of BITS_PER_SAMPLE = ", BITS_PER_SAMPLE
            pause "only for debugging purpose"
            stop
      end select
      v = 2**BITS_PER_SAMPLE - 1

      k = 0
!!      write( unit, "(6X)", advance="no" )
      do i = COLORMAP_CI_LOW, COLORMAP_CI_HIGH
         col(:) = [ nint(rvalue(i)*v), nint(gvalue(i)*v), nint(bvalue(i)*v) ]
         write( unit, format, advance="no" ) col(:)
         k = k + 6
         if( k >= 132 ) then
            write( unit, * )
!!            write( unit, "(6X)", advance="no" )
            k = 0
         end if
      end do
      write( unit, * )
   end subroutine write_colormap
!_______________________________________________________________________
!
   function pdf_string( str ) result( str2 )

      character(len=*), intent(in) :: str
      character(len=160) :: str2

      ! Balanced parenthesis are permitted in a PDF string (only
      ! unbalanced parenthesis need to be escaped).
      ! So, check for unbalanced parenthesis only

      integer :: i, j, n, k_paren

      n = len(str)
      k_paren = 0
      do i = 1, n
         if( str(i:i) == "(" ) then
            k_paren = k_paren + 1
         else if( str(i:i) == ")" ) then
            k_paren = k_paren - 1
         end if
      end do

      if( k_paren == 0 ) then
         str2 = str
      else
         str2 = ""
         ! Parenthesis are not balanced: escape all of them...
         j = 0
         do i = 1, n
            if( str(i:i) == "(" ) then
               j = j + 1
               str2(j:j+1) = "\("
               j = j + 1
            else if( str(i:i) == ")" ) then
               j = j + 1
               str2(j:j+1) = "\)"
               j = j + 1
            else
               j = j + 1
               str2(j:j) = str(i:i)
            end if
         end do
      end if

   end function pdf_string
!_______________________________________________________________________
!
end subroutine pdf_driver
