! MUESLI-MFPLOT Null driver
!
subroutine NULL_DRIVER( ifunc, rbuf, ibuf, chr, lchr )

   use mod_grplot

   implicit none

   integer          :: ifunc, ibuf(*), lchr
   double precision :: rbuf(*)
   character(len=*) :: chr
   !------ API end ------

   ! MFPLOT driver for Null device (no graphical output)
   !
   ! 2005 Mar 22 - Changing default behavior if unimplemented function
   !               is called => nothing happens.
   ! 2006 Jan 06 - Max color index is now MAX_COLORS-1 (4175)
   ! 2018 Sep 09 - Extended predefined colors: added 7 new colors.
   !               (old Matlab colors scheme)
   ! 2018 Sep 10 - Extended predefined colors: added 7 new colors.
   !               (new Matlab colors scheme)
   !               Extended predefined colors, added 12 new colors.
   !               (Breeze colortable)
   ! 2019 Oct  1 - Increase MAXDEV to be equal to the GRIMAX value in
   !               mod_grplot.
   ! 2020 Mar  2 - Use now double precision instead of single precision.
   ! 2020 Mar 27 - Remove npic array, never used. Removed also rbuf(5) for
   !               IFUNC=9, because it no longer exists (see gropen_ec).
   !               Added missing opcodes (w.r.t. X11 driver).
   ! 2020 Apr 12 - 'nbuf' scalar argument replaced by the 'ibuf' vector.
   ! 2020 May 29 - 'grfao' calls removed.
   ! 2021 Mar 17 - Changed the name of this driver to NULL_DRIVER.
   ! 2021 Dec 15 - Changed all numerical target labels of the select case to
   !               predefined character strings.
   ! 2021 Dec 17 - Simplified the select case structure by removing all unused
   !               opcodes. From now, no error if an opcode is not found.
   !
   ! Supported device: The ``null'' device can be used to suppress all
   ! graphic output from a program.
   !
   ! Device type code: /NULL.
   !
   ! Default device name: None (the device name, if specified, is ignored).
   !
   ! Default view surface dimensions: Undefined.
   !
   ! Resolution: 96 DPI.
   !
   ! Color capability: Color indexes 0 to (MAX_COLORS-1) are accepted.
   !                   (cf. max nb of colors in x11_driver.c)
   !   It support 256 levels per color component (see opcodes 21 and 29)
   !
   ! Input capability: None.
   !
   ! File format: None.
   !
   ! Obtaining hardcopy: Not possible.
   !-----------------------------------------------------------------------
   ! Notes:
   !  Up to MAXDEV "devices" may be open at once. ACTIVE is the number of
   !  the currently selected device, or 0 if no devices are open.
   !  STATE(i) is 0 if device i is not open, 1 if it is open but with
   !  no current picture, or 2 if it is open with a current picture.
   !-----------------------------------------------------------------------

   character(len=*), parameter :: device = 'NULL (Null device, no output)'

   ! MAXDEV should be the same as GRIMAX in 'mod_grplot.F90'
   integer, parameter :: maxdev = 48, maxd1 = maxdev + 1

   character(len=80) :: msg
   integer :: i

   integer, save :: state(0:maxdev), active = -1
   data state / maxd1*0 /

   integer, parameter :: ncolors = 42
   integer, save :: cdeflt(3,0:ncolors-1)
   data cdeflt /  0,  0,  0, 255,255,255, 255,  0,  0,   0,255,  0,     &
                  0,  0,255,   0,255,255, 255,  0,255, 255,255,  0,     &
                255,128,  0, 128,255,  0,   0,255,128,   0,128,255,     &
                128,  0,255, 255,  0,128,  85, 85, 85, 170,170,170,     &
                  0,  0,255,   0,128,  0, 255,  0,  0,   0,191,191,     &
                191,  0,191, 191,191,  0,  64, 64, 64,                  &
                  0,114,189, 217, 83, 25, 237,177, 32, 126, 47,142,     &
                119,172, 48,  77,190,238, 162, 20, 47,                  &
                 61,174,233, 237, 21, 21, 246,116,  0, 253,188, 75,     &
                 39,174, 96, 201,206, 59,  17,209,220,  41,128,185,     &
                155, 89,182, 127,140,141,  26,188,156, 192, 57, 43 /
    integer, parameter :: max_colors = 4176
    integer, save :: ctable(3,0:max_colors-1)

    double precision, save :: width, height
    ! margin: 1/4"  converted in device resolution
    double precision, parameter :: margin = 0.25d0*96.0d0

   !------ end of declarations -- execution starts hereafter  ------

      if( active == -1 ) then
         active = 0
      end if

      select case( ifunc )

      case( GET_DEV_NAME )
         !--- Return device name ---------------------------------------
         chr = device
         lchr = len(device)

      case( GET_COL_IND_RANGE )
         !--- Return range of color indexes ----------------------------
         ibuf(1) =  0
         ibuf(2) = max_colors - 1

      case( GET_DEV_RESOL )
         !--- Return device resolution ---------------------------------
         ibuf(1) = 96
         ibuf(2) = 96
         ibuf(3) = 1    ! device coords per pixel

      case( GET_MISC_INFO )
         !--- Return misc device info ----------------------------------
         !    (This device is Hardcopy, No cursor, Dashed lines, Area fill,
         !     Thick lines, Rectangle fill, Images, Markers, query color rep)
         ! CHR = 'HNDATRQNYM'
         chr( 1: 1) = "H" ! Interactive device (I) or Hardcopy (H)
         chr( 2: 2) = "N" ! Cursor available (C) or not (N)
         chr( 3: 3) = "D" ! Dashed lines available (D) or not (N)
         chr( 4: 4) = "A" ! Area fill available (A) or not (N)
         chr( 5: 5) = "T" ! Thick lines available (T) or not (N)
         chr( 6: 6) = "R" ! Rectangle fill available (R) or not (N)
         chr( 7: 7) = "Q" ! Pixel device (P), Image device (Q) or nothing (N)
         chr( 8: 8) = "N" ! Persistent device (Verbose prompt) or not (N)
         chr( 9: 9) = "Y" ! Can return color representation? (Y) or not (N)
         chr(10:10) = "M" ! Markers available (M) or not (N)

         lchr = 10

      case( GET_DEF_FILENAME )
         !--- Return default file name ---------------------------------
         chr = 'NULL:'
         lchr = 5

      case( GET_DEF_SIZE )
         !--- Return default physical size of plot ---------------------
         !
         ! As for the X11 driver, this opcode returns the physical size
         ! of the X11 window, or the drawing size (previous area minus
         ! margins), according to the value of rbuf[0]:
         !     rbuf(1) = 0.  ->  the physical size is returned;
         !               1.  ->  the drawing size is returned.
         !               2.  ->  the margins are returned

         if( rbuf(1) == 1. ) then
            ibuf(1) = 0
            ibuf(2) = width - 2 * margin
            ibuf(3) = 0
            ibuf(4) = height - 2 * margin
         else if( rbuf(1) == 0. ) then
            ibuf(1) = 0
            ibuf(2) = width
            ibuf(3) = 0
            ibuf(4) = height
         else if( rbuf(1) == 2. ) then
            ibuf(1) = 0
            ibuf(2) = margin
            ibuf(3) = 0
            ibuf(4) = margin
         else
            call grwarn('internal error: NULL opcode 6: bad value of rbuf(1)')
         end if

      case( SELECT_PLOT )
         !--- Select plot ----------------------------------------------
         i = ibuf(1)
         if( i < 1 .or. maxdev < i ) then
            call grwarn('internal error: NULL opcode 8')
         else if( state(i) > 0 ) then
            active = i
         else
            call grnu00(ifunc,0)
         end if

      case( OPEN_DEV )
         !--- Open device ---------------------------------------------

         ! Find an inactive device, and select it
         do i = 1, maxdev
            if( state(i) == 0 ) then
               active = i
               state(active) = 1
               goto 10
            end if
         end do

         call grwarn('maximum number of devices of type NULL exceeded')
         ibuf(1) = 0
         ibuf(2) = 0
         return

         ! Initialize the new device
 10      continue

         ! position (x,y) in ibuf(1:2) is not used here.

         ! get size of requested X11 window in pixels
         width  = ibuf(3)
         height = ibuf(4)

         ibuf(1) = active
         ibuf(2) = 1
         ! Initialize color table
         do i = 0, 15
            ctable(1,i) = cdeflt(1,i)
            ctable(2,i) = cdeflt(2,i)
            ctable(3,i) = cdeflt(3,i)
         end do

      case( CLOSE_DEV )
         !--- Close device ---------------------------------------------
         if( state(active) /= 1 ) call grnu00(ifunc,state(active))
         state(active) = 0

      case( BEGIN_PICT )
         !--- Begin picture --------------------------------------------
         if( state(active) /= 1 ) call grnu00(ifunc,state(active))
         state(active) = 2

      case( END_PICT )
         !--- End picture ----------------------------------------------
         if( state(active) /= 2 ) call grnu00(ifunc,state(active))
         state(active) = 1

      case( SET_COL_REPRES )
         !--- Set color representation ---------------------------------
         if( state(active) < 1 ) call grnu00(ifunc,state(active))
         i = ibuf(1)
         ctable(1,i) = nint(rbuf(1)*255.0d0)
         ctable(2,i) = nint(rbuf(2)*255.0d0)
         ctable(3,i) = nint(rbuf(3)*255.0d0)

      case( GET_COL_REPRES )
         !--- Query color representation -------------------------------
         if( state(active) < 1 ) call grnu00(ifunc,state(active))
         i = ibuf(1)
         rbuf(1) = ctable(1,i)/255.0d0
         rbuf(2) = ctable(2,i)/255.0d0
         rbuf(3) = ctable(3,i)/255.0d0
         ibuf(1) = 3

      case( GET_COL_DEPTH )
         !--- Get the color depth --------------------------------------
         ibuf(1) = 16

   end select

end subroutine null_driver
!_______________________________________________________________________
!
subroutine grnu00( ifunc, state )

   use mod_grplot

   implicit none

   integer :: ifunc, state

   ! MFPLOT NULL device driver: report error
   !--------------------------------------------------------------------

   character(len=80) :: msg

   print "(/,2X,A,I0,A,I0)", "NULL driver: internal error"
   write(msg,"(15X,A,I0,A,I0)") "driver in state ", state,              &
                                " for opcode ", ifunc
   call grwarn( trim(msg) )

end subroutine grnu00
