!-----------------------------------------------------------------------
! Caution -- The following variables must have the same values:
!
!            MOD_GRPLOT module     MOD_PGPLOT module
!         ...............................................
!                GRXORG                PGXORG
!                GRYORG                PGYORG
!                GRXSCL                PGXSCL
!                GRYSCL                PGYSCL
!
!                GRXMIN                PGXVP
!                GRYMIN                PGYVP
!-----------------------------------------------------------------------

module mod_pgplot

   use mod_grplot

   implicit none

   ! Hide these two functions, because they are also imported elsewhere...
   private :: to_lower, to_upper

   !--------------------------------------------------------------------
   ! Maximum number of concurrent devices
   !--------------------------------------------------------------------
   integer, parameter :: pgmaxd = grimax

   !--------------------------------------------------------------------
   ! Identifier of currently selected device.
   !--------------------------------------------------------------------
   integer, save :: pgid

   !--------------------------------------------------------------------
   ! Device status (indexed by device identifier).
   !--------------------------------------------------------------------
   ! PGDEVS  = 0 if device is not open; 1 if device is open.
   ! PGBLEV  Buffering level: incremented by PGBBUF, decremented by
   !         PGEBUF.

   integer, save :: pgdevs(pgmaxd), pgblev(pgmaxd)

   !--------------------------------------------------------------------
   ! Attributes (indexed by device identification).
   !--------------------------------------------------------------------
   ! PGCLP   clipping enabled/disabled
   ! PGFAS   fill-area style
   ! PGCHSZ  character height
   ! PGAHS   arrow-head fill style
   ! PGAHA   arrow-head angle
   ! PGAHV   arrow-head vent
   ! PGTBCI  text background color index
   ! PGMNCI  lower range of color indices available to PGIMAG
   ! PGMXCI  upper range of color indices available to PGIMAG
   ! PGITF   type of transfer function used by PGIMAG
   ! PGHSA   hatching line angle
   ! PGHSS   hatching line separation
   ! PGHSP   hatching line phase

   ! PG_AXE_FNT_SIZ_FCT     =  win%axis_font_size
   ! PG_AXIS_LIN_WIDTH      =  win%axis_line_width
   ! PG_LAB_FNT_SIZ_FCT     =  win%label_font_size
   ! PG_TIT_FNT_SIZ_FCT     =  win%title_font_size
   ! PG_CHAR_HEIGHT_FACTOR  =  win%char_height_factor

   integer,          save :: pgfas (pgmaxd)
   double precision, save :: pgchsz(pgmaxd)
   integer,          save :: pgahs (pgmaxd)
   double precision, save :: pgaha (pgmaxd)
   double precision, save :: pgahv (pgmaxd)
   integer,          save :: pgtbci(pgmaxd)
   integer,          save :: pgmnci(pgmaxd)
   integer,          save :: pgmxci(pgmaxd)
   integer,          save :: pgitf (pgmaxd)
   double precision, save :: pghsa (pgmaxd)
   double precision, save :: pghss (pgmaxd)
   double precision, save :: pghsp (pgmaxd)

   double precision, save :: pg_axe_fnt_siz_fct(pgmaxd)
   double precision, save :: pg_axis_lin_width(pgmaxd)
   double precision, save :: pg_lab_fnt_siz_fct(pgmaxd)
   double precision, save :: pg_tit_fnt_siz_fct(pgmaxd)
   double precision, save :: pg_char_height_factor(pgmaxd)

   !--------------------------------------------------------------------
   ! Viewport parameters (indexed by device identification);
   ! all are device coordinates:
   !--------------------------------------------------------------------
   ! PGXVP   X coordinate of blc of viewport.
   ! PGYVP   Y coordinate of blc of viewport.
   ! PGXLEN  Width of viewport.
   ! PGYLEN  Height of viewport.

   double precision, save :: pgxvp(pgmaxd),  pgyvp(pgmaxd)
   double precision, save :: pgxlen(pgmaxd), pgylen(pgmaxd)

   !--------------------------------------------------------------------
   ! Scaling parameters (indexed by device identification):
   !--------------------------------------------------------------------
   ! PGXORG  device coordinate value corresponding to world X=0
   ! PGYORG  device coordinate value corresponding to world Y=0
   ! PGXSCL  scale in x (device units per world coordinate unit)
   ! PGYSCL  scale in y (device units per world coordinate unit)
   ! PGXPIN  device x scale in device units/inch
   ! PGYPIN  device y scale in device units/inch
   ! PGXSP   Character X spacing (device units)
   ! PGYSP   Character Y spacing (device units)

   double precision, save :: pgxorg(pgmaxd), pgyorg(pgmaxd)
   double precision, save :: pgxscl(pgmaxd), pgyscl(pgmaxd)
   double precision, save :: pgxpin(pgmaxd), pgypin(pgmaxd)
   double precision, save :: pgxsp(pgmaxd),  pgysp(pgmaxd)

   !--------------------------------------------------------------------
   ! Window parameters (indexed by device identification); all are world
   ! coordinate values:
   !--------------------------------------------------------------------
   ! PGXBLC  world X at bottom left corner of window
   ! PGYBLC  world Y at bottom left corner of window
   ! PGXTRC  world X at top right corner of window
   ! PGYTRC  world Y at top right corner of window

   double precision, save :: pgxblc(pgmaxd), pgyblc(pgmaxd)
   double precision, save :: pgxtrc(pgmaxd), pgytrc(pgmaxd)

   ! Smart extremal values for axis
   double precision, save :: MF_SMART_XTICK(pgmaxd) = 0.0d0,            &
                             MF_SMART_YTICK(pgmaxd) = 0.0d0
   integer, save :: MF_SMART_NXSUB(pgmaxd) = 0,                         &
                    MF_SMART_NYSUB(pgmaxd) = 0

   !--------------------------------------------------------------------
   ! The following parameters and global variables are used in the
   ! contouring routines to pass information to the action routine.
   ! They do not need to be indexed.
   !--------------------------------------------------------------------
   ! block size in PGCN01 (original size was 100, and it has been checked
   !                       as the optimal value -- for greater values,
   !                       cache misses arise)
   integer, parameter :: maxemx = 100, maxemy = 100
   integer,           save :: pgcint, pgcmin
   ! TRANS   Transformation matrix for contour plots; copied
   !         from argument list by PGCONT and used by PGCP.
   double precision,  save :: trans(6)
   ! PGCLAB is used only by 'pgconl()' and 'pgcl()'
   character(len=32), save :: pgclab
   integer,           save :: pgclab_len

   ! added by É. Canot
   integer, save :: id_x11

   integer, save :: FIG_NUMBER
   integer, save :: MF_COLBAR ! 0: no colorbar, 1: at right, 2: at bottom
   character(len=255), save :: EPS_NAME, PDF_NAME
   integer, save :: MF_EPS_UNIT, MF_PDF_UNIT
   integer, save :: MF_PID = 0 ! useful to name tempo files (PDF driver)

   character(len=72), save :: pg_exe_name
   character(len=80), save :: win_title

   double precision, save :: ps_font_size, ps_char_height

   integer, parameter :: CI_HIGH_MAX0 = 4175 ! will be redefined in mod_win_db

   logical, save :: COLORBAR_VERT ! fix for a strange inversion of colors
                      ! when colorbar is displayed in a vertical position...

   ! The default (and the old manner) is to write compressed some data
   ! (commands or bitmap images) in EPS and PDF under the HEXA form.
   ! If the following global variable is TRUE then ASCII85 is used
   ! instead of HEXA (this is more compact: ~ about twice).
   ! It is set during the initialisation of FGL (pgopen), via the presence
   ! of the environment variable MFPLOT_DEFLATE_A85 (1 or 0)
   logical, save :: MF_DEFLATE_TO_A85 = .true.
   integer, save :: MF_NB_BITMAPS, MF_NB_TRI_GRAD, MF_NB_QUAD_GRAD
   logical, save :: MF_CMAP_USED, MF_MARKERS_USED(26)

   ! help to fix the colorbar quality in PDF
   logical, save :: MF_PDF_IN_COLORBAR = .false. ! [default]

   ! current {Content, Image, ShadingType4, ShadingType6} written in the PDF
   integer, save :: MF_PDF_CURR_CONT, MF_PDF_CURR_IMG, MF_PDF_CURR_CMAP, &
                    MF_PDF_CURR_SHT4, MF_PDF_CURR_SHT6
   ! offsets of {Content, Image, ShadingType4, ShadingType6} to determine
   ! the object number in the PDF
   integer, save :: MF_PDF_OFF_CONT, MF_PDF_OFF_IMG, MF_PDF_OFF_CMAP,   &
                    MF_PDF_OFF_SHT4, MF_PDF_OFF_SHT6
   ! internal checking
   integer, save :: nb_intern_images

   logical :: INTEGER_XLABEL(pgmaxd) = .false.,                         &
              INTEGER_YLABEL(pgmaxd) = .false.

   logical :: PGBOX_IN_COLORBAR = .false.

   ! 1/4" margin, in pixel for the Xwindow device. These variables are
   ! defined in PGOPEN_EC.
   integer, save :: X11_XMARGIN = 0, X11_YMARGIN = 0

   character(len=8), save :: XOPT_SAVE, YOPT_SAVE

   logical, save :: MF_QR_in_aux_pixmap = .false.

   double precision, save :: x_left_QR, x_right_QR, y_bottom_QR, y_top_QR

   ! Contour lines storage
   logical, save :: mf_contour_coords_storage = .false.
   double precision, save, allocatable :: XY_cont(:,:)
   integer, save, allocatable :: IJ_cont(:,:), IS_cont(:)
   integer, save :: XY_cont_size, XY_cont_nb_cont
   integer, save :: XY_cont_current_pos, XY_cont_current_beg

   ! used only in TriContourF
   logical, save :: XY_contour_finalized

   ! see cursor indices in the 'mod_win_db' module.
   integer, parameter :: MF_MAX_CURSOR_INDEX = 9

   abstract interface
      subroutine magnetic_grid_rule_intf( icase, x1, y1, x2, y2, valid )
         integer,          intent(in)  :: icase
         double precision, intent(in)  :: x1, y1
         double precision, intent(out) :: x2, y2
         logical,          intent(out) :: valid
      end subroutine
   end interface

   procedure(magnetic_grid_rule_intf), pointer ::                       &
      magnetic_grid_rule_ptr => null()

   ! Get number of ticks for X-axis and linear mode only.
   !   (value -666 means not defined; valid values are positive integers)
   ! Initialized to '-666' at the beginning of 'pgbox'
   !   (perhaps defined later on in the same routine)
   integer, save :: X_ALL_TICKS_IND_START(pgmaxd),                      &
                    X_ALL_TICKS_IND_END(pgmaxd),                        &
                    X_MAJ_TICKS_IND_START(pgmaxd),                      &
                    X_MAJ_TICKS_IND_END(pgmaxd)

   logical, save :: USER_TICKS(pgmaxd) = .false.
   logical, save :: USER_TICKS_ALL(pgmaxd)
   type :: string_array
      character(len=6), allocatable :: labels(:)
      integer,          allocatable :: length(:)
   end type ! string_array
   type(string_array) :: USER_TICKS_LABELS(pgmaxd)

   ! For the RGB database
   logical, save :: RGB_database_ready = .false.
   integer, save :: n_RGB_database = -1 ! actual nb of colors
   integer :: RGB_database_values(1024,3)
   character(len=22) :: RGB_database_names(1024)

contains
!_______________________________________________________________________
!
   ! from 'src/pg'
#include "src/pg/pgarro.f90"
#include "src/pg/pgband.f90"
#include "src/pg/pgbbuf.f90"
#include "src/pg/pgbin.f90"
#include "src/pg/pgbox1.f90"
#include "src/pg/pgbox.f90"
#include "src/pg/pgcirc.f90"
#include "src/pg/pgcl.f90"
#include "src/pg/pgclos.f90"
#include "src/pg/pgcn01.f90"
#include "src/pg/pgcnsc.f90"
#include "src/pg/pgconb.f90"
#include "src/pg/pgconf.f90"
#include "src/pg/pgconl.f90"
#include "src/pg/pgconx.f90"
#include "src/pg/pgctab.f90"
#include "src/pg/pgebuf.f90"
#include "src/pg/pgenv.f90"
#include "src/pg/pgerr1.f90"
#include "src/pg/pgerrb.f90"
#include "src/pg/pgerrx.f90"
#include "src/pg/pgerry.f90"
#include "src/pg/pghtch.f90"
#include "src/pg/pgimag.f90"
#include "src/pg/pginit.f90"
#include "src/pg/pglab.f90"
#include "src/pg/pglen.f90"
#include "src/pg/pgline.f90"
#include "src/pg/pgline2.f90"
#include "src/pg/pgmtxt.f90"
#include "src/pg/pgnpl.f90"
#include "src/pg/pgnumb.f90"
#include "src/pg/pgolin.f90"
#include "src/pg/pgopen.f90"
#include "src/pg/pgpage.f90"
#include "src/pg/pgpoly.f90"
#include "src/pg/pgpt.f90"
#include "src/pg/pgptxt.f90"
#include "src/pg/pgqah.f90"
#include "src/pg/pgqch.f90"
#include "src/pg/pgqcir.f90"
#include "src/pg/pgqcs.f90"
#include "src/pg/pgqfs.f90"
#include "src/pg/pgqhs.f90"
#include "src/pg/pgqinf.f90"
#include "src/pg/pgqitf.f90"
#include "src/pg/pgqtbg.f90"
#include "src/pg/pgqtxt.f90"
#include "src/pg/pgqvp.f90"
#include "src/pg/pgqvsz.f90"
#include "src/pg/pgqwin.f90"
#include "src/pg/pgrnd.f90"
#include "src/pg/pgrnge.f90"
#include "src/pg/pgsah.f90"
#include "src/pg/pgsch.f90"
#include "src/pg/pgscir.f90"
#include "src/pg/pgscrn.f90"
#include "src/pg/pgsfs.f90"
#include "src/pg/pgshls.f90"
#include "src/pg/pgshs.f90"
#include "src/pg/pgsitf.f90"
#include "src/pg/pgslct.f90"
#include "src/pg/pgstbg.f90"
#include "src/pg/pgsvp.f90"
#include "src/pg/pgswin.f90"
#include "src/pg/pgtbox.f90"
#include "src/pg/pgtbx1.f90"
#include "src/pg/pgtbx2.f90"
#include "src/pg/pgtbx3.f90"
#include "src/pg/pgtbx4.f90"
#include "src/pg/pgtbx5.f90"
#include "src/pg/pgtbx6.f90"
#include "src/pg/pgtbx7.f90"
#include "src/pg/pgtikl.f90"
#include "src/pg/pgvect.f90"
#include "src/pg/pgvsiz.f90"
#include "src/pg/pgvw.f90"
#include "src/pg/pgwedg.f90"
#include "src/pg/pgwnad.f90"
!_______________________________________________________________________
!
   ! from 'src/zoom'
#include "src/zoom/click_ec.f90"
#include "src/zoom/cursdev_ec.f90"
!_______________________________________________________________________
!
   ! from 'src/pgaux'
#include "src/pgaux/grtext_xft.f90"

#include "src/pgaux/grtext_ps_font.f90"
#include "src/pgaux/grparse_ps_font.f90"
#include "src/pgaux/grlen_ps_font.f90"
#include "src/pgaux/grlen_xft.f90"

#include "src/pgaux/grtext_pdf_font.f90"
#include "src/pgaux/grparse_pdf_font.f90"

#include "src/pgaux/pgarro_head_only.f90"
#include "src/pgaux/pgband_dyn.f90"
#include "src/pgaux/pgbar_ec.f90"
#include "src/pgaux/pgbar_groups_ec.f90"
#include "src/pgaux/pgbar_stacks_ec.f90"
#include "src/pgaux/pgbezier.f90"
#include "src/pgaux/pgclos_ec.f90"
#include "src/pgaux/pgcont_ec.f90"
#include "src/pgaux/pgcnsc_ec.f90"
#include "src/pgaux/pgcn01_ec.f90"
#include "src/pgaux/pgcontxy_ec.f90"
#include "src/pgaux/pgcnscxy_ec.f90"
#include "src/pgaux/pgcn01xy_ec.f90"
#include "src/pgaux/pggrid_ec.f90"
#include "src/pgaux/pghist_ec.f90"
#include "src/pgaux/pghist_ec_pre.f90"
#include "src/pgaux/pginput.f90"
#include "src/pgaux/pgline_errorbar.f90"
#include "src/pgaux/pgopen_ec.f90"
#include "src/pgaux/pgpt_errorbar.f90"
#include "src/pgaux/pgscir_PS_ec.f90"
#include "src/pgaux/pgslices.f90"
#include "src/pgaux/pg_spline_to_bezier.f90"
#include "src/pgaux/pg_store_contour.F90"
#include "src/pgaux/pgtricons_ec.f90"
#include "src/pgaux/pgtricnsc_ec.f90"
#include "src/pgaux/pre_pgbox_log.f90"
#include "src/pgaux/utf8_to_latin_1.f90"
!_______________________________________________________________________
!
   subroutine X11_clip_on_viewport()

      !------ API end ------

      double precision :: rbuf(1)
      integer :: ibuf(1), lchr
      character(len=1) :: chr

   !------ end of declarations -- execution starts hereafter  ------

      if( .not. CLIPPING_IN_AXES ) then
         ibuf(1) = 1 ! set clipping at viewport
         call grexec( grgtyp, SET_CLIPPING, rbuf, ibuf, chr, lchr )
         CLIPPING_IN_AXES = .true.
      end if

   end subroutine X11_clip_on_viewport
!_______________________________________________________________________
!
   subroutine EPS_clip_on_viewport_beg()

      !------ API end ------

      ! Set rectangular clipping on viewport: begin.
      ! Write directly in the EPS file.

      character(len=80) :: inline
      integer :: xoff, yoff, xlen, ylen

   !------ end of declarations -- execution starts hereafter  ------

      if( COMMENTS_IN_EPS ) then
         call gresc("%-- begin of clipping on viewport")
      end if
      call gresc("q")

      ! viewport dimensions (dev. units)
      xoff = nint( pgxvp(pgid) )
      yoff = nint( pgyvp(pgid) )
      xlen = nint( pgxlen(pgid) )
      ylen = nint( pgylen(pgid) )
      if( COMMENTS_IN_EPS ) then
         write(inline,100) xoff, yoff, xlen, ylen, "RC % viewport dimensions"
      else
         write(inline,100) xoff, yoff, xlen, ylen, "RC"
      end if
 100  format( 4(I0,1X), A )
      call gresc( trim(inline) )

   end subroutine EPS_clip_on_viewport_beg
!_______________________________________________________________________
!
   subroutine EPS_clip_on_viewport_end()

      !------ API end ------

      ! Set rectangular clipping on viewport: end.
      ! Write directly in the EPS file.

   !------ end of declarations -- execution starts hereafter  ------

      if( COMMENTS_IN_EPS ) then
         call gresc('Q % restore also the "no clip" state')
      else
         call gresc("Q")
      end if
      LAST_COLOR_IS_VALID = .false.
      LAST_LINEWIDTH_IS_VALID = .false.
      LAST_LINESTYLE_IS_VALID = .false.
      LAST_FONT_ATTRIB_IS_VALID = .false.

      if( COMMENTS_IN_EPS ) then
         call gresc("%-- end of clipping on viewport")
      end if

   end subroutine EPS_clip_on_viewport_end
!_______________________________________________________________________
!
   subroutine EPS_no_clip_beg()

      !------ API end ------

      ! Set rectangular clipping on full drawing area: begin.
      ! Write directly in the EPS file.

   !------ end of declarations -- execution starts hereafter  ------

      if( COMMENTS_IN_EPS ) then
         call gresc("%-- begin of clipping on full drawing area")
      end if
      ! The only way to enlarge a clipping area is to restore the
      ! initial clipping state (very large, I suppose)
      if( COMMENTS_IN_EPS ) then
         call gresc('cliprestore % restore the "no clip" state')
      else
         call gresc("cliprestore")
      end if

   end subroutine EPS_no_clip_beg
!_______________________________________________________________________
!
   subroutine EPS_no_clip_end()

      !------ API end ------

      ! Set rectangular clipping on full drawing area: end.
      ! Write directly in the EPS file.

      character(len=80) :: inline
      integer :: xoff, yoff, xlen, ylen

   !------ end of declarations -- execution starts hereafter  ------

      ! restore clipping at viewport (dev. units)
      xoff = nint( pgxvp(pgid) )
      yoff = nint( pgyvp(pgid) )
      xlen = nint( pgxlen(pgid) )
      ylen = nint( pgylen(pgid) )
      if( COMMENTS_IN_EPS ) then
         write(inline,100) xoff, yoff, xlen, ylen, "RC % restore clipping at viewport"
      else
         write(inline,100) xoff, yoff, xlen, ylen, "RC"
      end if
 100  format( 4(I0,1X), A )
      call gresc( trim(inline) )

      if( COMMENTS_IN_EPS ) then
         call gresc("%-- end of clipping on full drawing area")
      end if

   end subroutine EPS_no_clip_end
!_______________________________________________________________________
!
   subroutine PDF_clip_on_viewport_beg()

      !------ API end ------

      ! Set rectangular clipping on viewport: begin.
      ! Write directly in the PDF file.

      character(len=80) :: inline
      double precision :: xoff, yoff, xlen, ylen

   !------ end of declarations -- execution starts hereafter  ------

      if( COMMENTS_IN_PDF ) then
         call gresc("%-- begin of clipping on viewport")
      end if
      call gresc("q") ! = gsave

      ! viewport dimensions (dev. units)
      xoff = pgxvp(pgid)
      yoff = pgyvp(pgid)
      xlen = pgxlen(pgid)
      ylen = pgylen(pgid)
      write(inline,100) nint(xoff), nint(yoff),                         &
                        nint(xoff+xlen), nint(yoff),                    &
                        nint(xoff+xlen), nint(yoff+ylen),               &
                        nint(xoff), nint(yoff+ylen)
 100  format(i0, " ", i0, " m ",                                        &
             i0, " ", i0, " l ",                                        &
             i0, " ", i0, " l ",                                        &
             i0, " ", i0, " l")
      call gresc( trim(inline) )
      call gresc("h W n")

   end subroutine PDF_clip_on_viewport_beg
!_______________________________________________________________________
!
   subroutine PDF_clip_on_viewport_end()

      !------ API end ------

      ! Set rectangular clipping on viewport: end.
      ! Write directly in the PDF file.

   !------ end of declarations -- execution starts hereafter  ------

      call gresc("Q") ! = grestore
      LAST_LINEWIDTH_IS_VALID = .false.
      LAST_LINESTYLE_IS_VALID = .false.
      LAST_FONT_ATTRIB_IS_VALID = .false.

      if( COMMENTS_IN_PDF ) then
         call gresc("%-- end of clipping on viewport")
      end if

   end subroutine PDF_clip_on_viewport_end
!_______________________________________________________________________
!
   subroutine PDF_no_clip_beg()

      !------ API end ------

      ! Set rectangular clipping on full drawing area: begin.
      ! Write directly in the PDF file.

   !------ end of declarations -- execution starts hereafter  ------

      ! The only way to enlarge a clipping area is to restore the
      ! initial clipping state (very large, I suppose)
      if( COMMENTS_IN_PDF ) then
         call gresc('Q % restore to have no clipping')
      else
         call gresc("Q") ! = grestore
      end if
      LAST_LINEWIDTH_IS_VALID = .false.
      LAST_LINESTYLE_IS_VALID = .false.
      LAST_FONT_ATTRIB_IS_VALID = .false.

   end subroutine PDF_no_clip_beg
!_______________________________________________________________________
!
   subroutine PDF_no_clip_end()

      !------ API end ------

      ! Set rectangular clipping on full drawing area: end.
      ! Write directly in the PDF file.

      character(len=80) :: inline
      double precision :: xoff, yoff, xlen, ylen

   !------ end of declarations -- execution starts hereafter  ------

      if( COMMENTS_IN_EPS ) then
         call gresc('% clip again at viewport')
      end if
      call gresc("q") ! = gsave

      ! viewport dimensions (dev. units)
      xoff = pgxvp(pgid)
      yoff = pgyvp(pgid)
      xlen = pgxlen(pgid)
      ylen = pgylen(pgid)
      write(inline,100) nint(xoff), nint(yoff),                         &
                        nint(xoff+xlen), nint(yoff),                    &
                        nint(xoff+xlen), nint(yoff+ylen),               &
                        nint(xoff), nint(yoff+ylen)
 100  format(i0, " ", i0, " m ",                                        &
             i0, " ", i0, " l ",                                        &
             i0, " ", i0, " l ",                                        &
             i0, " ", i0, " l")
      call gresc( trim(inline) )
      call gresc("h W n")

   end subroutine PDF_no_clip_end
!_______________________________________________________________________
!
   subroutine rm_trail_zeros_in_flt( x, form, str )

      double precision, intent(in)  :: x
      character(len=*), intent(in)  :: form
      character(len=*), intent(out) :: str
      !------ API end ------

      ! remove trailing zero(s) in a floating-point number written using
      ! a fixed format, for ex. F5.3 (no check !).

      integer :: i, k, n

   !------ end of declarations -- execution starts hereafter  ------

      write( str, form ) x
      str = adjustl(str)

      ! search for the decimal point
      k = index( str, "." )

      if( k == 0 ) then
         print *, "(Muesli FGL) internal error"
         print *, "             rm_trail_zeros_in_flt: decimal point not found!"
         pause "only for debugging purpose"
         return
      end if

      n = len_trim(str)
      do i = n, k, -1
         select case( str(i:i) )
            case( "0", "." )
               str(i:i) = " "
            case default
               return
         end select
      end do

   end subroutine rm_trail_zeros_in_flt
!_______________________________________________________________________
!
   subroutine magnetic_grid_rule_pgplot( icase, i1, j1, i2, j2,         &
                                         x2, y2, ivalid )

      integer :: icase, i1, j1, i2, j2
      double precision :: x2, y2
      integer :: ivalid
      !------ API end ------

      ! This routine is called by the X11 driver (magnetic grid
      ! implementation).
      ! All coordinates in arguments are device coordinates.
      ! If it is not possible to return (x2,y2), valid must be set to 0.

      double precision :: x1, y1
      logical :: valid

   !------ end of declarations -- execution starts hereafter  ------

      ! convert from device to world coords
      x1 = (i1 - pgxorg(pgid))/pgxscl(pgid)
      y1 = (j1 - pgyorg(pgid))/pgyscl(pgid)

      call magnetic_grid_rule_ptr( icase, x1, y1, x2, y2, valid )

      if( valid ) then

         ivalid = 1

         ! convert from world to device coords
         i2 = nint(pgxorg(pgid) + x2*pgxscl(pgid))
         j2 = nint(pgyorg(pgid) + y2*pgyscl(pgid))

      else

         ivalid = 0

      end if

   end subroutine magnetic_grid_rule_pgplot
!_______________________________________________________________________
!
   subroutine read_RGB_database( )

      ! This routine reads the RGB database.

      character(len=256) :: file, line
      logical :: exist, tf1, tf2
      integer :: unit, i, err

   !------ end of declarations -- execution starts hereafter  ------

      if( MFPLOT_DIR == "" ) then
         ! get the installation directory
         call set_muesli_install_dir_fgl()
      end if

      file = trim(MFPLOT_DIR) // "/rgb.txt"
      inquire(file=trim(file),exist=exist)
      if( .not. exist ) then
         print *, "(Muesli FGL) internal error"
         print *, "             read_RGB_database: cannot find the RGB database!"
         pause "for debugging purpose..."
         return
      end if

      do i = 99, 1, -1
         unit = i
         inquire( UNIT=unit, OPENED=tf1, EXIST=tf2, IOSTAT=err )
         if( .not. tf1 .and. tf2 .and. err==0 ) then
           exit
         end if
      end do
      open( unit=unit, file=trim(file), status="old", action="read" )
      i = 0
      do
         read( unit, "(A)", end=99 ) line
         i = i + 1
         read( line(1:11), * ) RGB_database_values(i,:)
         read( line(13:), "(A)" ) RGB_database_names(i)
      end do

 99   continue
      close(unit)

      n_RGB_database = i

      RGB_database_ready = .true.

   end subroutine read_RGB_database
!_______________________________________________________________________
!
   subroutine find_colorname_in_RGB_database( color_name,               &
                                              rgb_values, status )

      character(len=*), intent(in)  :: color_name
      double precision, intent(out) :: rgb_values(3)
      integer,          intent(out) :: status
      !------ API end ------

      ! This routine tries to find the color 'color_name'
      ! in the RGB database.
      ! If the search is successful, then status = 0, else = -1.

      integer :: i

   !------ end of declarations -- execution starts hereafter  ------

      ! Color name is not yet found
      status = -1

      do i = 1, n_RGB_database
         if( RGB_database_names(i) == color_name ) then
            rgb_values(:) = RGB_database_values(i,:)/255.0d0
            status = 0
            return
         end if
      end do

   end subroutine find_colorname_in_RGB_database
!_______________________________________________________________________
!
end module mod_pgplot
