/*
 * Part of MUESLI Numerical Library
 * Copyright É. Canot 2003-2025 -- IPR/CNRS
 */

/*
 * GNU Linux (x86) or AIX (IBM)
 */

/* IEEE rounding modes */
#include <fenv.h>

/* C <-> Fortran interoperability */
#ifdef UNDERSCORE
#define round_towardzero round_towardzero_
#endif

void round_towardzero ()
{
   fesetround( FE_TOWARDZERO );
}

/* C <-> Fortran interoperability */
#ifdef UNDERSCORE
#define round_nearest round_nearest_
#endif

void round_nearest ()
{
   fesetround( FE_TONEAREST );
}

/* C <-> Fortran interoperability */
#ifdef UNDERSCORE
#define round_upward round_upward_
#endif

void round_upward ()
{
   fesetround( FE_UPWARD );
}

/* C <-> Fortran interoperability */
#ifdef UNDERSCORE
#define round_downward round_downward_
#endif

void round_downward ()
{
   fesetround( FE_DOWNWARD );
}

