/*
 * Part of MUESLI Numerical Library
 * Copyright É. Canot 2003-2025 -- IPR/CNRS
 */

#ifndef _WINDOWS

#include <sys/types.h>
#include <sys/ioctl.h>
#include <stdio.h>
#include <stdlib.h>

#endif

/* C <-> Fortran interoperability */
#ifdef UNDERSCORE
#define get_term_col get_term_col_
#endif

int get_term_col()
{
#ifdef _WINDOWS
    return -1;
#else
    struct winsize ws;
    int status;

    status = ioctl(1, TIOCGWINSZ, &ws);
    if( status == 0 ) {
	return ws.ws_col;
    } else {
	return -1;
    }
#endif
}

