program test_progress

   use fml

   use test_aux

   implicit none

   type(mfArray) :: a, b, c
   integer :: i

   ! Msg level = 3 : all messages are printed (verbose mode)
   !             2 : messages of kind 'ERROR' and 'Warning' are
   !                 printed [default]
   !             1 : only messages of kind 'ERROR' are printed
   !             0 : nothing is printed (quiet mode)
   !                 (pause are ignored !)

!!   call msSetMsgLevel(3)

   print "()"

   ! for TRACE_MEM_DEBUG, STDERR must be redirected to STDOUT;
   ! the same thing stands for 'make check'
   call msSetStdIO( stderr=STDOUT )

!!goto 10

   print "()"
   print "(A)", "   *************************************************************************"
   print "(A)", "   *** times have been measured on an Intel Core i7-2620M CPU @ 2.70 GHz ***"
   print "(A)", "   *************************************************************************"
   print "()"

   ! msPrepProgress, msPrintProgress, msPostProgress -------------------
   call print_separation("msPrepProgress, msPrintProgress, msPostProgress")

   print "()"
   print *, "--- method used: GLE, Global Linear Estimator ---"

   ! basic method (GLE), ok only for constant loop cost
   ! loop with increasing index
   a = mfRand(300)
   b = mfRand(300)
   print "()"
   print *, "1000 multiplication of two matrices of size 300 ..."
   print *, "  [loop with increasing index and constant cost]"
   print *, "  (total time is about 20 sec.)"
   call msPrepProgress( 1, 1000 )
   do i = 1, 1000
      c = mfMul(a,b)
      call msPrintProgress( i )
   end do
   call msPostProgress( )

   ! basic method (GLE), ok only for constant loop cost
   ! loop with increasing index
   print "()"
   print *, "750 multiplication (element-wise) of two matrices of size i ..."
   print *, "  [loop with increasing index and cost in i^2]"
   print *, "  (total time is about 22 sec.)"
   call msPrepProgress( 1, 750 )
   do i = 1, 750
      a = mfRand(i)
      b = mfRand(i)
      c = a*b
      call msPrintProgress( i )
   end do
   call msPostProgress( )

   ! basic method (GLE), ok only for constant loop cost
   ! loop with increasing index
   print "()"
   print *, "600 multiplication of two matrices of size i ..."
   print *, "  [loop with increasing index and cost in i^3]"
   print *, "  (total time is about 34 sec.)"
   call msPrepProgress( 1, 600 )
   do i = 1, 600
      a = mfRand(i)
      b = mfRand(i)
      c = mfMul(a,b)
      call msPrintProgress( i )
   end do
   call msPostProgress( )

   ! basic method (GLE), ok only for constant loop cost
   ! loop with decreasing index
   print "()"
   print *, "600 multiplication of two matrices of size i ..."
   print *, "  [loop with decreasing index and cost in i^3]"
   print *, "  (total time is about 34 sec.)"
   call msPrepProgress( 600, 1 )
   do i = 600, 1, -1
      a = mfRand(i)
      b = mfRand(i)
      c = mfMul(a,b)
      call msPrintProgress( i )
   end do
   call msPostProgress( )

   print "()"
   print *, "--- method used: LPE, Local Power Estimator ---"

   ! advanced method (LPE), ok only for constant loop cost
   ! loop with increasing index
   a = mfRand(300)
   b = mfRand(300)
   print "()"
   print *, "1000 multiplication of two matrices of size 300 ..."
   print *, "  [loop with increasing index and constant cost]"
   print *, "  (total time is about 20 sec.)"
   call msPrepProgress( 1, 1000, estimator="LPE" )
   do i = 1, 1000
      c = mfMul(a,b)
      call msPrintProgress( i )
   end do
   call msPostProgress( )

   ! advanced method (LPE), ok only for constant loop cost
   ! loop with increasing index
   print "()"
   print *, "750 multiplication (element-wise) of two matrices of size i ..."
   print *, "  [loop with increasing index and cost in i^2]"
   print *, "  (total time is about 22 sec.)"
   call msPrepProgress( 1, 750, estimator="LPE" )
   do i = 1, 750
      a = mfRand(i)
      b = mfRand(i)
      c = a*b
      call msPrintProgress( i )
   end do
   call msPostProgress( )

   ! advanced method (LPE), ok only for constant loop cost
   ! loop with increasing index
   print "()"
   print *, "600 multiplication of two matrices of size i ..."
   print *, "  [loop with increasing index and cost in i^3]"
   print *, "  (total time is about 34 sec.)"
   call msPrepProgress( 1, 600, estimator="LPE" )
   do i = 1, 600
      a = mfRand(i)
      b = mfRand(i)
      c = mfMul(a,b)
      call msPrintProgress( i )
   end do
   call msPostProgress( )

   ! advanced method (LPE), ok only for constant loop cost
   ! loop with decreasing index
   print "()"
   print *, "600 multiplication of two matrices of size i ..."
   print *, "  [loop with decreasing index and cost in i^3]"
   print *, "  (total time is about 34 sec.)"
   call msPrepProgress( 600, 1, estimator="LPE" )
   do i = 600, 1, -1
      a = mfRand(i)
      b = mfRand(i)
      c = mfMul(a,b)
      call msPrintProgress( i )
   end do
   call msPostProgress( )
   print "()"

   ! End of tests ------------------------------------------------------
   print "(A)", "                         ┏━━━━━━━━━━━━━━━━━━━━━━┓"
   print "(A)", "                         ┃ End of test_progress ┃"
   print "(A)", "                         ┗━━━━━━━━━━━━━━━━━━━━━━┛"

   !--------------------------------------------------------------------
99 continue

   print "()"
   call msSetMsgLevel(2)

   call msRelease( a, b, c )

end program
