program test_mod_specfun

   use fml

   use test_aux
   use lib_aux

   implicit none

   type(mfArray) :: x, y, z
   integer :: MsgLevel_save
   integer :: n

   ! Msg level = 3 : all messages are printed (verbose mode)
   !             2 : messages of kind 'ERROR' and 'Warning' are
   !                 printed [default]
   !             1 : only messages of kind 'ERROR' are printed
   !             0 : nothing is printed (quiet mode)
   !                 (pause are ignored !)

!!   call msSetMsgLevel(3)
!!   call msSetTrbLevel("all")

   print "()"

   ! for TRACE_MEM_DEBUG, STDERR must be redirected to STDOUT;
   ! the same thing stands for 'make check'
   call msSetStdIO( stderr=STDOUT )

!!goto 10

   ! to avoid escape sequences of color setting in the output file
   ! (default in "on")
   call msSetColoredMsg( "off" )

   ! VERSIONs ----------------------------------------------------------
   print "()"
   print *, "MF_MUESLI_VERSION = '", MF_MUESLI_VERSION, "'"
   print "()"
   print *, "MF_COMPILER_VERSION = '", MF_COMPILER_VERSION, "'"
   print "()"
   print *, "MF_COMPILATION_CONFIG = '", MF_COMPILATION_CONFIG(), "'"
   print "()"

   ! mfErf -------------------------------------------------------------
   call print_separation("mfErf")

   print "(/,A)", "*** test number 1 ***"
   x = [ -1.5d0, -1.0d0, -0.5d0, 0.0d0, 0.5d0, 1.0d0, 1.5d0 ]
   call msDisplay(x,"x")
   call msDisplay(mfErf(x),"mfErf(x)")

   print "(/,A)", "*** test number 2 ***"
   call mf_save_and_disable_fpe( )
   x = [ -MF_INF, MF_INF, MF_NAN ]
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   call msDisplay(mfErf(x),"mfErf(x)")

   ! complex values

   ! this is the 1st zero of erf(z) (from Abramowitz & Stegun)
   z = cmplx( 1.45061616d0, 1.88094300d0 )
   print "(/,A)", "*** test number 3 ***"
   call msDisplay(z,"z")
   call msDisplay(mfAbs(mfErf(z)),"|mfErf(z)|")
   if( All( mfAbs(mfErf(z)) < 5.0d-7 ) ) then
      print *, "First zero of Erf(z): test passed"
   else
      print *, "First zero of Erf(z): test failed ***"
   end if

   ! this is the 5th zero of erf(z) (from Abramowitz & Stegun)
   z = cmplx( 3.76900557d0, 4.06069723d0 )
   print "(/,A)", "*** test number 4 ***"
   call msDisplay(z,"z")
   call msDisplay(mfAbs(mfErf(z)),"|mfErf(z)|")
   if( All( mfAbs(mfErf(z)) < 3.0d-6 ) ) then
      print *, "Fifth zero of Erf(z): test passed"
   else
      print *, "Fifth zero of Erf(z): test failed ***"
   end if

   ! this is the 10th zero of erf(z) (from Abramowitz & Stegun)
   z = cmplx( 5.45219220d0, 5.68883744d0 )
   print "(/,A)", "*** test number 5 ***"
   call msDisplay(z,"z")
   call msDisplay(mfAbs(mfErf(z)),"|mfErf(z)|")
   if( All( mfAbs(mfErf(z)) < 5.0d-6 ) ) then
      print *, "Tenth zero of Erf(z): test passed"
   else
      print *, "Tenth zero of Erf(z): test failed ***"
   end if
   print "()"

   ! mfErfInv ----------------------------------------------------------
   call print_separation("mfErfInv")

   print "(/,A)", "*** test number 6 ***"
   x = [ -1.5d0, -1.0d0, -0.5d0, 0.0d0, 0.5d0, 1.0d0, 1.5d0 ]
   call msDisplay(x,"x")
   call msDisplay(mfErfInv(x),"mfErfInv(x)")

   print "(/,A)", "*** test number 7 ***"
   call mf_save_and_disable_fpe( )
   x = [ -MF_INF, MF_INF, MF_NAN ]
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   call msDisplay(mfErfInv(x),"mfErfInv(x)")

   print "(/,A)", "*** test number 8 ***"
   x = [ -1.5d0, -1.0d0, -0.5d0, 0.0d0, 0.5d0, 1.0d0, 1.5d0 ]
   call msDisplay(x,"x")
   y = mfErfInv(mfErf(x))
   if( All( mfAbs(x-y) < 10.0d0*MF_EPS ) ) then
      print *, "Erf and ErfInv as reciprocal functions: test passed"
   else
      print *, "Erf and ErfInv as reciprocal functions: test failed ***"
   end if
   print "()"

   ! mfErfC ------------------------------------------------------------
   call print_separation("mfErfC")

   print "(/,A)", "*** test number 9 ***"
   x = [ -0.5d0, 0.0d0, 0.5d0, 1.0d0, 1.5d0, 2.0d0, 2.5d0 ]
   call msDisplay(x,"x")
   call msDisplay(mfErfC(x),"mfErfC(x)")

   print "(/,A)", "*** test number 10 ***"
   call mf_save_and_disable_fpe( )
   x = [ -MF_INF, MF_INF, MF_NAN ]
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   call msDisplay(mfErfC(x),"mfErfC(x)")

   ! complex values

   ! this is the 1st zero of erf(z) (from Abramowitz & Stegun)
   z = cmplx( 1.45061616d0, 1.88094300d0 )
   print "(/,A)", "*** test number 11 ***"
   call msDisplay(z,"z")
   call msDisplay(mfAbs(1.0d0-mfErfC(z)),"| 1 - mfErfC(z) |")
   if( All( mfAbs(1.0d0-mfErfC(z)) < 5.0d-7 ) ) then
      print *, "First zero of ErfC(z): test passed"
   else
      print *, "First zero of ErfC(z): test failed ***"
   end if
   print "()"

   ! mfErfCInv ---------------------------------------------------------
   call print_separation("mfErfCInv")

   print "(/,A)", "*** test number 12 ***"
   x = [ -0.5d0, 0.0d0, 0.5d0, 1.0d0, 1.5d0, 2.0d0, 2.5d0 ]
   call msDisplay(x,"x")
   call msDisplay(mfErfCInv(x),"mfErfCInv(x)")

   print "(/,A)", "*** test number 13 ***"
   call mf_save_and_disable_fpe( )
   x = [ -MF_INF, MF_INF, MF_NAN ]
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   call msDisplay(mfErfCInv(x),"mfErfCInv(x)")

   print "(/,A)", "*** test number 14 ***"
   x = [ -1.5d0, -1.0d0, -0.5d0, 0.0d0, 0.5d0, 1.0d0, 1.5d0 ]
   call msDisplay(x,"x")
   y = mfErfCInv(mfErfC(x))
   if( All( mfAbs(x-y) < 10.0d0*MF_EPS ) ) then
      print *, "ErfC and ErfCInv as reciprocal functions: test passed"
   else
      print *, "ErfC and ErfCInv as reciprocal functions: test failed ***"
   end if
   print "()"

   ! mfErfCScaled ------------------------------------------------------
   call print_separation("mfErfCScaled")

   print "(/,A)", "*** test number 15 ***"
   x = [ -4.05d0, -1.0d0, -0.25d0, 0.0d0, 0.25d0, 1.0d0, 4.05d0 ]
   x = .t. x
   call msDisplay(x,"x")
   call msFormat("long")
   call msDisplay(mfErfCScaled(x),"mfErfCScaled(x)")
   call msDisplay(mfExp(x**2)*mfErfC(x),"mfExp(x**2)*mfErfC(x)")
   call msFormat("short")

   print "(/,A)", "*** test number 16 ***"
   call mf_save_and_disable_fpe( )
   x = [ -MF_INF, MF_INF, MF_NAN ]
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   call msDisplay(mfErfCScaled(x),"mfErfCScaled(x)")

   ! mfExpInt ----------------------------------------------------------
   call print_separation("mfExpInt")

   MsgLevel_save = mfGetMsgLevel()
   call msSetMsgLevel(1)

   print "(/,A)", "*** test number 17 ***"
   x = [ 0.0d0, 0.1d0, 0.2d0, 0.5d0, 1.0d0,                             &
         2.0d0, 5.0d0, 10.0d0, 20.0d0, 50.0d0 ]
   x = .t. x
   call msDisplay(x,"x")
   call msFormat("long")
   call msDisplay(mfExpInt(x),"mfExpInt(x)")
   call msFormat("short")

   print "(/,A)", "*** test number 18 ***"
   call mf_save_and_disable_fpe( )
   x = [ -MF_INF, MF_INF, MF_NAN ]
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   call msDisplay(mfExpInt(x),"mfExpInt(x)")

   call msSetMsgLevel(MsgLevel_save)

   ! mfGamma -----------------------------------------------------------
   call print_separation("mfGamma")

   print "(/,A)", "*** test number 19 ***"
   x = [ -1.5d0, -1.0d0, -0.5d0, 0.0d0, 0.5d0, 1.0d0, 1.5d0 ]
   call msDisplay(x,"x")
   call msDisplay(mfGamma(x),"mfGamma(x)")

   print "(/,A)", "*** test number 20 ***"
   call mf_save_and_disable_fpe( )
   x = [ -MF_INF, MF_INF, MF_NAN ]
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   call msDisplay(mfGamma(x),"mfGamma(x)")

   ! mfGammaLn ---------------------------------------------------------
   call print_separation("mfGammaLn")

   print "(/,A)", "*** test number 21 ***"
   x = [ -1.5d0, -1.0d0, -0.5d0, 0.0d0, 0.5d0, 1.0d0, 1.5d0 ]
   call msDisplay(x,"x")
   call msDisplay(mfGammaLn(x),"mfGammaLn(x)")

   print "(/,A)", "*** test number 22 ***"
   call mf_save_and_disable_fpe( )
   x = [ -MF_INF, MF_INF, MF_NAN ]
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   call msDisplay(mfGammaLn(x),"mfGammaLn(x)")

   ! mfBesselJ ---------------------------------------------------------
   call print_separation("mfBesselJ")

   ! integer orders (both positive and negative) -- real results
   x = [ -1.5d0, -1.0d0, -0.5d0, 0.0d0, 0.5d0, 1.0d0, 1.5d0 ]
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 23 ***"
   call msDisplay(mfBesselJ(-2.0d0,x),"mfBesselJ(-2.0d0,x)")
   print "(/,A)", "*** test number 24 ***"
   call msDisplay(mfBesselJ(-1.0d0,x),"mfBesselJ(-1.0d0,x)")
   print "(/,A)", "*** test number 25 ***"
   call msDisplay(mfBesselJ( 0.0d0,x),"mfBesselJ( 0.0d0,x)")
   print "(/,A)", "*** test number 26 ***"
   call msDisplay(mfBesselJ( 1.0d0,x),"mfBesselJ( 1.0d0,x)")
   print "(/,A)", "*** test number 27 ***"
   call msDisplay(mfBesselJ( 2.0d0,x),"mfBesselJ( 2.0d0,x)")

   call mf_save_and_disable_fpe( )
   x = [ -MF_INF, MF_INF, MF_NAN ]
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 28 ***"
   y = mfBesselJ(-1.0d0,x)
   call zeroes_small_values( y, 1.0d-8 )
   call msDisplay(y,"mfBesselJ(-1.0d0,x)")
   print "(/,A)", "*** test number 29 ***"
   call msDisplay(mfBesselJ( 0.0d0,x),"mfBesselJ( 0.0d0,x)")
   print "(/,A)", "*** test number 30 ***"
   y = mfBesselJ( 1.0d0,x)
   call zeroes_small_values( y, 1.0d-8 )
   call msDisplay(y,"mfBesselJ( 1.0d0,x)")

   ! positive fractional orders -- real results
   x = mf( [ 0.0d0, 0.5d0, 1.0d0, 1.5d0, MF_INF ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 31 ***"
   call msDisplay(mfBesselJ(0.5d0,x),"mfBesselJ(0.5d0,x)")
   print "(/,A)", "*** test number 32 ***"
   call msDisplay(mfBesselJ(1.5d0,x),"mfBesselJ(1.5d0,x)")

   ! positive fractional orders -- complex results
   x = .t. mf( [ -1.5d0, -1.0d0, -0.5d0, 0.0d0, 0.5d0, 1.0d0, 1.5d0 ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 33 ***"
   call msDisplay(mfBesselJ(0.5d0,x),"mfBesselJ(0.5d0,x)")
   print "(/,A)", "*** test number 34 ***"
   call msDisplay(mfBesselJ(1.5d0,x),"mfBesselJ(1.5d0,x)")

   print "(/,A)", "*** test number 35 ***"
   call mf_save_and_disable_fpe( )
   x = [ -MF_INF, MF_INF, MF_NAN ]
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   call msDisplay(mfBesselJ(0.5d0,x),"mfBesselJ(0.5d0,x)")

   ! negative fractional orders -- real results
   x = mf( [ 0.0d0, 0.5d0, 1.0d0, 1.5d0, MF_INF ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 36 ***"
   call msDisplay(mfBesselJ(-0.5d0,x),"mfBesselJ(-0.5d0,x)")
   print "(/,A)", "*** test number 37 ***"
   call msDisplay(mfBesselJ(-1.5d0,x),"mfBesselJ(-1.5d0,x)")

   ! negative fractional orders -- complex results
   x = .t. mf( [ -1.5d0, -1.0d0, -0.5d0, 0.0d0, 0.5d0, 1.0d0, 1.5d0 ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 38 ***"
   call msDisplay(mfBesselJ(-0.5d0,x),"mfBesselJ(-0.5d0,x)")
   print "(/,A)", "*** test number 39 ***"
   y = mfBesselJ(-1.5d0,x)
   call zeroes_small_values( y, 1.0d-8 )
   call msDisplay(y,"mfBesselJ(-1.5d0,x)")

   print "(/,A)", "*** test number 40 ***"
   call mf_save_and_disable_fpe( )
   x = [ -MF_INF, MF_INF, MF_NAN ]
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   call msDisplay(mfBesselJ(-0.5d0,x),"mfBesselJ(-0.5d0,x)")

   ! mfBesselY ---------------------------------------------------------
   call print_separation("mfBesselY")

   ! integer orders (both positive and negative) -- real results
   x = mf( [ 0.0d0, 0.5d0, 1.0d0, 1.5d0, MF_INF ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 41 ***"
   call msDisplay(mfBesselY(-2.0d0,x),"mfBesselY(-2.0d0,x)")
   print "(/,A)", "*** test number 42 ***"
   y = mfBesselY(-1.0d0,x)
   call zeroes_small_values( y, 1.0d-8 )
   call msDisplay(y,"mfBesselY(-1.0d0,x)")
   print "(/,A)", "*** test number 43 ***"
   call msDisplay(mfBesselY( 0.0d0,x),"mfBesselY( 0.0d0,x)")
   print "(/,A)", "*** test number 44 ***"
   call msDisplay(mfBesselY( 1.0d0,x),"mfBesselY( 1.0d0,x)")
   print "(/,A)", "*** test number 45 ***"
   call msDisplay(mfBesselY( 2.0d0,x),"mfBesselY( 2.0d0,x)")

   ! integer orders (both positive and negative) -- complex results
   x = .t. mf( [ -1.5d0, -1.0d0, -0.5d0, 0.0d0, 0.5d0, 1.0d0, 1.5d0 ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 46 ***"
   call msDisplay(mfBesselY(-2.0d0,x),"mfBesselY(-2.0d0,x)")
   print "(/,A)", "*** test number 47 ***"
   call msDisplay(mfBesselY(-1.0d0,x),"mfBesselY(-1.0d0,x)")
   print "(/,A)", "*** test number 48 ***"
   call msDisplay(mfBesselY( 0.0d0,x),"mfBesselY( 0.0d0,x)")
   print "(/,A)", "*** test number 49 ***"
   call msDisplay(mfBesselY( 1.0d0,x),"mfBesselY( 1.0d0,x)")
   print "(/,A)", "*** test number 50 ***"
   call msDisplay(mfBesselY( 2.0d0,x),"mfBesselY( 2.0d0,x)")

   call mf_save_and_disable_fpe( )
   x = [ -MF_INF, MF_INF, MF_NAN ]
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 51 ***"
   call msDisplay(mfBesselY(-1.0d0,x),"mfBesselY(-1.0d0,x)")
   print "(/,A)", "*** test number 52 ***"
   call msDisplay(mfBesselY( 0.0d0,x),"mfBesselY( 0.0d0,x)")
   print "(/,A)", "*** test number 53 ***"
   call msDisplay(mfBesselY( 1.0d0,x),"mfBesselY( 1.0d0,x)")

   ! positive fractional orders -- real results
   x = mf( [ 0.0d0, 0.5d0, 1.0d0, 1.5d0, MF_INF ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 54 ***"
   call msDisplay(mfBesselY(0.5d0,x),"mfBesselY(0.5d0,x)")
   print "(/,A)", "*** test number 55 ***"
   call msDisplay(mfBesselY(1.5d0,x),"mfBesselY(1.5d0,x)")

   ! positive fractional orders -- complex results
   x = .t. mf( [ -1.5d0, -1.0d0, -0.5d0, 0.0d0, 0.5d0, 1.0d0, 1.5d0 ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 56 ***"
   call msDisplay(mfBesselY(0.5d0,x),"mfBesselY(0.5d0,x)")
   print "(/,A)", "*** test number 57 ***"
   y = mfBesselY(1.5d0,x)
   call zeroes_small_values( y, 1.0d-8 )
   call msDisplay(y,"mfBesselY(1.5d0,x)")

   print "(/,A)", "*** test number 58 ***"
   call mf_save_and_disable_fpe( )
   x = [ -MF_INF, MF_INF, MF_NAN ]
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   call msDisplay(mfBesselY(0.5d0,x),"mfBesselY(0.5d0,x)")

   ! negative fractional orders -- real results
   x = mf( [ 0.0d0, 0.5d0, 1.0d0, 1.5d0, MF_INF ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 59 ***"
   call msDisplay(mfBesselY(-0.5d0,x),"mfBesselY(-0.5d0,x)")
   print "(/,A)", "*** test number 60 ***"
   call msDisplay(mfBesselY(-1.5d0,x),"mfBesselY(-1.5d0,x)")

   ! negative fractional orders -- complex results
   x = .t. mf( [ -1.5d0, -1.0d0, -0.5d0, 0.0d0, 0.5d0, 1.0d0, 1.5d0 ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 61 ***"
   call msDisplay(mfBesselY(-0.5d0,x),"mfBesselY(-0.5d0,x)")
   print "(/,A)", "*** test number 62 ***"
   y = mfBesselY(-1.5d0,x)
   call zeroes_small_values( y, 1.0d-8 )
   call msDisplay(y,"mfBesselY(-1.5d0,x)")

   print "(/,A)", "*** test number 63 ***"
   call mf_save_and_disable_fpe( )
   x = [ -MF_INF, MF_INF, MF_NAN ]
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   call msDisplay(mfBesselY(-0.5d0,x),"mfBesselY(-0.5d0,x)")

   ! mfBesselI ---------------------------------------------------------
   call print_separation("mfBesselI")

   ! integer orders (both positive and negative) -- real results
   x = mf( [ -1.5d0, -1.0d0, -0.5d0, 0.0d0, 0.5d0, 1.0d0, 1.5d0 ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 64 ***"
   call msDisplay(mfBesselI(-2.0d0,x),"mfBesselI(-2.0d0,x)")
   print "(/,A)", "*** test number 65 ***"
   call msDisplay(mfBesselI(-1.0d0,x),"mfBesselI(-1.0d0,x)")
   print "(/,A)", "*** test number 66 ***"
   call msDisplay(mfBesselI( 0.0d0,x),"mfBesselI( 0.0d0,x)")
   print "(/,A)", "*** test number 67 ***"
   call msDisplay(mfBesselI( 1.0d0,x),"mfBesselI( 1.0d0,x)")
   print "(/,A)", "*** test number 68 ***"
   call msDisplay(mfBesselI( 2.0d0,x),"mfBesselI( 2.0d0,x)")

   call mf_save_and_disable_fpe( )
   x = [ -MF_INF, MF_INF, MF_NAN ]
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 69 ***"
   call msDisplay(mfBesselI(-1.0d0,x),"mfBesselI(-1.0d0,x)")
   print "(/,A)", "*** test number 70 ***"
   call msDisplay(mfBesselI( 0.0d0,x),"mfBesselI( 0.0d0,x)")
   print "(/,A)", "*** test number 71 ***"
   call msDisplay(mfBesselI( 1.0d0,x),"mfBesselI( 1.0d0,x)")

   ! positive fractional orders -- real results
   x = mf( [ 0.0d0, 0.5d0, 1.0d0, 1.5d0, MF_INF ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 72 ***"
   call msDisplay(mfBesselI(0.5d0,x),"mfBesselI(0.5d0,x)")
   print "(/,A)", "*** test number 73 ***"
   call msDisplay(mfBesselI(1.5d0,x),"mfBesselI(1.5d0,x)")

   ! positive fractional orders -- complex results
   x = .t. mf( [ -1.5d0, -1.0d0, -0.5d0, 0.0d0, 0.5d0, 1.0d0, 1.5d0 ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 74 ***"
   call msDisplay(mfBesselI(0.5d0,x),"mfBesselI(0.5d0,x)")
   print "(/,A)", "*** test number 75 ***"
   call msDisplay(mfBesselI(1.5d0,x),"mfBesselI(1.5d0,x)")

   call mf_save_and_disable_fpe( )
   x = [ -MF_INF, MF_INF, MF_NAN ]
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 76 ***"
   call msDisplay(mfBesselI(0.5d0,x),"mfBesselI(0.5d0,x)")
   print "(/,A)", "*** test number 77 ***"
   call msDisplay(mfBesselI(1.5d0,x),"mfBesselI(1.5d0,x)")

   ! negative fractional orders -- real results
   x = mf( [ 0.0d0, 0.5d0, 1.0d0, 1.5d0, MF_INF ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 78 ***"
   call msDisplay(mfBesselI(-0.5d0,x),"mfBesselI(-0.5d0,x)")
   print "(/,A)", "*** test number 79 ***"
   call msDisplay(mfBesselI(-1.5d0,x),"mfBesselI(-1.5d0,x)")

   ! negative fractional orders -- complex results
   x = .t. mf( [ -1.5d0, -1.0d0, -0.5d0, 0.0d0, 0.5d0, 1.0d0, 1.5d0 ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 80 ***"
   call msDisplay(mfBesselI(-0.5d0,x),"mfBesselI(-0.5d0,x)")
   print "(/,A)", "*** test number 81 ***"
   call msDisplay(mfBesselI(-1.5d0,x),"mfBesselI(-1.5d0,x)")

   call mf_save_and_disable_fpe( )
   x = [ -MF_INF, MF_INF, MF_NAN ]
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 82 ***"
   call msDisplay(mfBesselI(-0.5d0,x),"mfBesselI(-0.5d0,x)")
   print "(/,A)", "*** test number 83 ***"
   call msDisplay(mfBesselI(-1.5d0,x),"mfBesselI(-1.5d0,x)")

   ! mfBesselK ---------------------------------------------------------
   call print_separation("mfBesselK")

   ! integer orders (both positive and negative) -- real results
   x = mf( [ 0.0d0, 0.5d0, 1.0d0, 1.5d0, MF_INF ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 84 ***"
   call msDisplay(mfBesselK(-2.0d0,x),"mfBesselK(-2.0d0,x)")
   print "(/,A)", "*** test number 85 ***"
   call msDisplay(mfBesselK(-1.0d0,x),"mfBesselK(-1.0d0,x)")
   print "(/,A)", "*** test number 86 ***"
   call msDisplay(mfBesselK( 0.0d0,x),"mfBesselK( 0.0d0,x)")
   print "(/,A)", "*** test number 87 ***"
   call msDisplay(mfBesselK( 1.0d0,x),"mfBesselK( 1.0d0,x)")
   print "(/,A)", "*** test number 88 ***"
   call msDisplay(mfBesselK( 2.0d0,x),"mfBesselK( 2.0d0,x)")

   ! integer orders (both positive and negative) -- complex results
   x = .t. mf( [ -1.5d0, -1.0d0, -0.5d0, 0.0d0, 0.5d0, 1.0d0, 1.5d0 ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 89 ***"
   call msDisplay(mfBesselK(-2.0d0,x),"mfBesselK(-2.0d0,x)")
   print "(/,A)", "*** test number 90 ***"
   call msDisplay(mfBesselK(-1.0d0,x),"mfBesselK(-1.0d0,x)")
   print "(/,A)", "*** test number 91 ***"
   call msDisplay(mfBesselK( 0.0d0,x),"mfBesselK( 0.0d0,x)")
   print "(/,A)", "*** test number 92 ***"
   call msDisplay(mfBesselK( 1.0d0,x),"mfBesselK( 1.0d0,x)")
   print "(/,A)", "*** test number 93 ***"
   call msDisplay(mfBesselK( 2.0d0,x),"mfBesselK( 2.0d0,x)")

   call mf_save_and_disable_fpe( )
   x = [ -MF_INF, MF_INF, MF_NAN ]
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 94 ***"
   call msDisplay(mfBesselK(-1.0d0,x),"mfBesselK(-1.0d0,x)")
   print "(/,A)", "*** test number 95 ***"
   call msDisplay(mfBesselK( 0.0d0,x),"mfBesselK( 0.0d0,x)")
   print "(/,A)", "*** test number 96 ***"
   call msDisplay(mfBesselK( 1.0d0,x),"mfBesselK( 1.0d0,x)")

   ! fractional orders (both positive and negative) -- real results
   x = mf( [ 0.0d0, 0.5d0, 1.0d0, 1.5d0, MF_INF ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 97 ***"
   call msDisplay(mfBesselK(-1.5d0,x),"mfBesselK(-1.5d0,x)")
   print "(/,A)", "*** test number 98 ***"
   call msDisplay(mfBesselK(-0.5d0,x),"mfBesselK(-0.5d0,x)")
   print "(/,A)", "*** test number 99 ***"
   call msDisplay(mfBesselK( 0.5d0,x),"mfBesselK(0.5d0,x)")
   print "(/,A)", "*** test number 100 ***"
   call msDisplay(mfBesselK( 1.5d0,x),"mfBesselK(1.5d0,x)")

   ! fractional orders (both positive and negative) -- complex results
   x = .t. mf( [ -1.5d0, -1.0d0, -0.5d0, 0.0d0, 0.5d0, 1.0d0, 1.5d0 ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 101 ***"
   call msDisplay(mfBesselK(-1.5d0,x),"mfBesselK(-1.5d0,x)")
   print "(/,A)", "*** test number 102 ***"
   call msDisplay(mfBesselK(-0.5d0,x),"mfBesselK(-0.5d0,x)")
   print "(/,A)", "*** test number 103 ***"
   call msDisplay(mfBesselK( 0.5d0,x),"mfBesselK(0.5d0,x)")
   print "(/,A)", "*** test number 104 ***"
   call msDisplay(mfBesselK( 1.5d0,x),"mfBesselK(1.5d0,x)")

   call mf_save_and_disable_fpe( )
   x = [ -MF_INF, MF_INF, MF_NAN ]
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 105 ***"
   call msDisplay(mfBesselK(-1.5d0,x),"mfBesselK(-1.5d0,x)")
   print "(/,A)", "*** test number 106 ***"
   call msDisplay(mfBesselK(-0.5d0,x),"mfBesselK(-0.5d0,x)")
   print "(/,A)", "*** test number 107 ***"
   call msDisplay(mfBesselK( 0.5d0,x),"mfBesselK(0.5d0,x)")
   print "(/,A)", "*** test number 108 ***"
   call msDisplay(mfBesselK( 1.5d0,x),"mfBesselK(1.5d0,x)")

   ! mfAiry ------------------------------------------------------------
   call print_separation("mfAiry")

   print "(/,A)", "*** test number 109 ***"
   x = mf( [ -2.0d0, -1.0d0, 0.0d0, 1.0d0, 2.0d0 ] )
   call msDisplay(x,"x")
   call msDisplay(mfAiry(x),"mfAiry(x)")

   ! msEllipKE ---------------------------------------------------------
   call print_separation("msEllipKE")

   print "(/,A)", "*** test number 110 ***"
   x = mf( [ -0.5d0, 0.0d0, 0.5d0, 1.0d0, 1.5d0 ] )
   call msDisplay(x,"x")
   call msEllipKE( mfOut(y,z), x )
   call msDisplay(y,"C.E.I. of first kind : K(x)")
   call msDisplay(z,"C.E.I. of second kind : E(x)")

   print "(/,A)", "*** test number 111 ***"
   call mf_save_and_disable_fpe( )
   x = [ -MF_INF, MF_INF, MF_NAN ]
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   call msEllipKE( mfOut(y,z), x )
   call msDisplay(y,"C.E.I. of first kind : K(x)")
   call msDisplay(z,"C.E.I. of second kind : E(x)")

   ! mfIsPrime ---------------------------------------------------------
   call print_separation("mfIsPrime")

   x = 7
   call msDisplay( x, "x" )
   print "(/,A)", "*** test number 112 ***"
   call msDisplay( mfIsPrime(x), "mfIsPrime(x)" )

   x = 30
   call msDisplay( x, "x" )
   print "(/,A)", "*** test number 113 ***"
   call msDisplay( mfIsPrime(x), "mfIsPrime(x)" )

   x = 421
   call msDisplay( x, "x" )
   print "(/,A)", "*** test number 114 ***"
   call msDisplay( mfIsPrime(x), "mfIsPrime(x)" )

   x = 2013
   call msDisplay( x, "x" )
   call msDisplay( mfIsPrime(x), "mfIsPrime(x)" )

   x = 9973
   call msDisplay( x, "x" )
   call msDisplay( mfIsPrime(x), "mfIsPrime(x)" )

   x = [ 7, 30, 421, 2013, 9973 ]
   call msDisplay( x, "x" )
   print "(/,A)", "*** test number 115 ***"
   call msDisplay( mfIsPrime(x), "mfIsPrime(x)" )

   x = reshape( [ 2, 3, 6, 9, 13, 15 ], [ 2, 3 ] )
   call msDisplay( x, "x" )
   print "(/,A)", "*** test number 116 ***"
   call msDisplay( mfIsPrime(x), "mfIsPrime(x)" )

   ! mfFactor ----------------------------------------------------------
   call print_separation("mfFactor")

   x = 7
   call msDisplay( x, "x" )
   print "(/,A)", "*** test number 117 ***"
   call msDisplay( mfFactor(x), "mfFactor(x)" )

   x = 2**4 * 3**3 * 5**2 * 7
   call msDisplay( x, "x = 2**4 * 3**3 * 5**2 * 7" )
   print "(/,A)", "*** test number 118 ***"
   call msDisplay( mfFactor(x), "mfFactor(x)" )

   x = 2 * 3 * 5 * 7 * 11 * 13 * 17
   call msDisplay( x, "x = 2 * 3 * 5 * 7 * 11 * 13 * 17" )
   print "(/,A)", "*** test number 119 ***"
   call msDisplay( mfFactor(x), "mfFactor(x)" )

   x = 10847 * 11987
   print *, "x ="
   print "(/,3X,I0,/)", mfInt(x)
   y = mfFactor(x)
   print "(/,A)", "*** test number 120 ***"
   call msDisplay( y, "mfFactor(x)" )

   if( All( mfAbs(mf([10847, 11987])-y) < MF_EPS ) ) then
      print *, "mfFactor: test passed"
   else
      print *, "mfFactor: test failed ***"
   end if
   print "()"

   ! msRat -------------------------------------------------------------
   call print_separation("msRat")

   print "(/,A)", "*** test number 121 ***"
   x = MF_PI
   call msDisplay( x, "x = MF_PI" )
   call msRat( mfOut(y,z), x ) ! default tolerance is 10^-6
   print "(A)", " computing the rational approximation of 'x'" //       &
                " with default tol"
   print "()"
   call msDisplay( y, "numerator", z, "denominator" )

   print "(/,A)", "*** test number 122 ***"
   x = mfHilb(4)
   call msDisplay( x, "x" )
   call msRat( mfOut(y,z), x ) ! default tolerance is 10^-6
   print "(A)", " computing the rational approximation of 'x'" //       &
                " with default tol"
   print "()"
   call msDisplay( y, "numerator", z, "denominator" )

   print "(/,A)", "*** test number 123 ***"
   call mf_save_and_disable_fpe( )
   x = [ MF_PI, MF_E, log(2.0d0), sqrt(2.0d0), MF_INF, MF_NAN ]
   call mf_restore_fpe( )
   call msDisplay( x, "x" )
   call msRat( mfOut(y,z), x ) ! default tolerance is 10^-6
   print "(A)", " computing the rational approximation of 'x'" //       &
                " with default tol (10^-6)"
   print "()"
   call msDisplay( y, "numerator", z, "denominator" )

   print "(/,A)", "*** test number 124 ***"
   call mf_save_and_disable_fpe( )
   x = [ MF_PI, MF_E, log(2.0d0), sqrt(2.0d0), MF_INF, MF_NAN ]
   call mf_restore_fpe( )
   call msDisplay( x, "x" )
   call msRat( mfOut(y,z), x, tol=1.0d-9 )
   print "(A)", " computing the rational approximation of 'x'" //       &
                " with tol = 10^-9"
   print "()"
   call msDisplay( y, "numerator", z, "denominator" )

   print "(/,A)", "*** test number 125 ***"
   x = mfMagic(3)
   call msDisplay( x, "x" )
   x = mfInv(x)
   call msDisplay( x, "mfInv(x)" )
   call msRat( mfOut(y,z), x ) ! default tolerance is 10^-6
   print "(A)", " computing the rational approximation of 'x'" //       &
                " with default tol"
   print "()"
   call msDisplay( y, "numerator", z, "denominator" )

   ! End of tests ------------------------------------------------------
   print "(A)", "                         ┏━━━━━━━━━━━━━━━━━━━━━━━━━┓"
   print "(A)", "                         ┃ End of test_mod_specfun ┃"
   print "(A)", "                         ┗━━━━━━━━━━━━━━━━━━━━━━━━━┛"

   !--------------------------------------------------------------------
99 continue

   print "()"
   call msSetMsgLevel(2)

   call msRelease( x, y, z )
   call msCleanPrimeNumbers()

end program
