program test_mod_sparse_2

   use fml

   use test_aux
   use lib_aux

   implicit none

   type(mfArray) :: A, B, C, v, x, y, d
   type(mfArray) :: L, U, P, Q, R, RANK, w
   type(mfArray) :: vec, A_vec, lambda, ind, jnd, flag, tmp
   type(mfArray) :: R2, Id, E
   type(mfMatFactor) :: factor, Qhouse
   integer, allocatable :: ir(:), jc(:)
   real(kind=MF_DOUBLE), allocatable :: val(:)
   complex(kind=MF_DOUBLE), allocatable :: zval(:)
   logical :: bool
   integer :: i, j, m, n
   real(kind=MF_DOUBLE) :: val_min, val_max
!!   real(kind=MF_DOUBLE) :: check_small_threshold = 1.0d3*MF_EPS
   integer :: MsgLevel_save

   ! Msg level = 3 : all messages are printed (verbose mode)
   !             2 : messages of kind 'ERROR' and 'Warning' are
   !                 printed [default]
   !             1 : only messages of kind 'ERROR' are printed
   !             0 : nothing is printed (quiet mode)
   !                 (pause are ignored !)

!!   call msSetMsgLevel(3)
!!   call msSetTrbLevel("all")

   print "()"

   ! for TRACE_MEM_DEBUG, STDERR must be redirected to STDOUT;
   ! the same thing stands for 'make check'
   call msSetStdIO( stderr=STDOUT )

!!goto 10

   ! to avoid escape sequences of color setting in the output file
   ! (default in "on")
   call msSetColoredMsg( "off" )

   ! VERSIONs ----------------------------------------------------------
   print "()"
   print *, "MF_MUESLI_VERSION = '", MF_MUESLI_VERSION, "'"
   print "()"
   print *, "MF_COMPILER_VERSION = '", MF_COMPILER_VERSION, "'"
   print "()"
   print *, "MF_COMPILATION_CONFIG = '", MF_COMPILATION_CONFIG(), "'"
   print "()"

   ! mfIsRowSorted, msRowSort ------------------------------------------
   call print_separation("mfIsRowSorted, msRowSort")

   !-- real matrix

   !-- square matrix

   allocate( ir(4), jc(4), val(4) )
   ir(:) = [ 1, 1, 3, 3 ]
   jc(:) = [ 1, 2, 2, 3 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 1 ***"
   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true"
   else
      print *, "  --> info: 'A' row sorted : false"
   end if

   allocate( ir(4), jc(4), val(4) )
   ir(:) = [ 1, 3, 1, 3 ]
   jc(:) = [ 1, 2, 2, 3 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 2 ***"
   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true"
   else
      print *, "  --> info: 'A' row sorted : false"
   end if

   print "()"
   print *, "  ... row sorting ..."
   print "()"
   call msRowSort( A )
   call msDisplay(A, "sorted matrix A")

   print "(/,A)", "*** test number 3 ***"
   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true (ok)"
   else
      call msPause("Bug: after calling 'msRowSort', A should be RowSorted!")
   end if

   !-- non square matrix

   allocate( ir(4), jc(4), val(4) )
   ir(:) = [ 1, 1, 2, 2 ]
   jc(:) = [ 1, 2, 2, 4 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 4 ***"
   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true"
   else
      print *, "  --> info: 'A' row sorted : false"
   end if

   allocate( ir(4), jc(4), val(4) )
   ir(:) = [ 1, 2, 1, 2 ]
   jc(:) = [ 1, 2, 2, 4 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 5 ***"
   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true"
   else
      print *, "  --> info: 'A' row sorted : false"
   end if

   print "()"
   print *, "  ... row sorting ..."
   print "()"
   call msRowSort( A )
   call msDisplay(A, "sorted matrix A")

   print "(/,A)", "*** test number 6 ***"
   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true (ok)"
   else
      call msPause("Bug: after calling 'msRowSort', A should be RowSorted!")
   end if

   allocate( ir(4), jc(4), val(4) )
   ir(:) = [ 1, 3, 2, 4 ]
   jc(:) = [ 1, 1, 2, 2 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 7 ***"
   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true"
   else
      print *, "  --> info: 'A' row sorted : false"
   end if

   allocate( ir(4), jc(4), val(4) )
   ir(:) = [ 3, 1, 2, 4 ]
   jc(:) = [ 1, 1, 2, 2 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 8 ***"
   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true"
   else
      print *, "  --> info: 'A' row sorted : false"
   end if

   print "()"
   print *, "  ... row sorting ..."
   print "()"
   call msRowSort( A )
   call msDisplay(A, "sorted matrix A")

   print "(/,A)", "*** test number 9 ***"
   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true (ok)"
   else
      call msPause("Bug: after calling 'msRowSort', A should be RowSorted!")
   end if

   !-- matrix with duplicate entries

   allocate( ir(6), jc(6), val(6) )
   ir(:) = [ 1, 1, 1, 3, 3, 3 ]
   jc(:) = [ 1, 2, 2, 2, 2, 3 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 10 ***"
   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true"
   else
      print *, "  --> info: 'A' row sorted : false"
   end if

   print "()"
   print *, "  ... row sorting ..."
   print "()"
   MsgLevel_save = mfGetMsgLevel()
   call msSetMsgLevel(3) ! verbose mode
   call msRowSort( A )
   call msSetMsgLevel(MsgLevel_save)
   call msDisplay(A, "sorted matrix A")

   print "(/,A)", "*** test number 11 ***"
   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true (ok)"
   else
      call msPause("Bug: after calling 'msRowSort', A should be RowSorted!")
   end if

   !-- complex matrix

   !-- square matrix

   allocate( ir(4), jc(4), zval(4) )
   ir(:) = [ 1, 1, 3, 3 ]
   jc(:) = [ 1, 2, 2, 3 ]
   zval(:) = [ (1.0d0,1.0d0), (2.0d0,1.0d0), (3.0d0,1.0d0), (4.0d0,1.0d0) ]

   A = mfSpImport(ir,jc,zval)
   call msDisplay(A, "A = mfSpImport(ir,jc,zval)")

   deallocate( ir, jc, zval )

   print "(/,A)", "*** test number 12 ***"
   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true"
   else
      print *, "  --> info: 'A' row sorted : false"
   end if

   allocate( ir(4), jc(4), zval(4) )
   ir(:) = [ 1, 3, 1, 3 ]
   jc(:) = [ 1, 2, 2, 3 ]
   zval(:) = [ (1.0d0,1.0d0), (2.0d0,1.0d0), (3.0d0,1.0d0), (4.0d0,1.0d0) ]

   A = mfSpImport(ir,jc,zval)
   call msDisplay(A, "A = mfSpImport(ir,jc,zval)")

   deallocate( ir, jc, zval )

   print "(/,A)", "*** test number 13 ***"
   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true"
   else
      print *, "  --> info: 'A' row sorted : false"
   end if

   print "()"
   print *, "  ... row sorting ..."
   print "()"
   call msRowSort( A )
   call msDisplay(A, "sorted matrix A")

   print "(/,A)", "*** test number 14 ***"
   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true (ok)"
   else
      call msPause("Bug: after calling 'msRowSort', A should be RowSorted!")
   end if

   !-- non square matrix

   allocate( ir(4), jc(4), zval(4) )
   ir(:) = [ 1, 1, 2, 2 ]
   jc(:) = [ 1, 2, 2, 4 ]
   zval(:) = [ (1.0d0,1.0d0), (2.0d0,1.0d0), (3.0d0,1.0d0), (4.0d0,1.0d0) ]

   A = mfSpImport(ir,jc,zval)
   call msDisplay(A, "A = mfSpImport(ir,jc,zval)")

   deallocate( ir, jc, zval )

   print "(/,A)", "*** test number 15 ***"
   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true"
   else
      print *, "  --> info: 'A' row sorted : false"
   end if

   allocate( ir(4), jc(4), zval(4) )
   ir(:) = [ 1, 2, 1, 2 ]
   jc(:) = [ 1, 2, 2, 4 ]
   zval(:) = [ (1.0d0,1.0d0), (2.0d0,1.0d0), (3.0d0,1.0d0), (4.0d0,1.0d0) ]

   A = mfSpImport(ir,jc,zval)
   call msDisplay(A, "A = mfSpImport(ir,jc,zval)")

   deallocate( ir, jc, zval )

   print "(/,A)", "*** test number 16 ***"
   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true"
   else
      print *, "  --> info: 'A' row sorted : false"
   end if

   print "()"
   print *, "  ... row sorting ..."
   print "()"
   call msRowSort( A )
   call msDisplay(A, "sorted matrix A")

   print "(/,A)", "*** test number 17 ***"
   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true (ok)"
   else
      call msPause("Bug: after calling 'msRowSort', A should be RowSorted!")
   end if

   allocate( ir(4), jc(4), zval(4) )
   ir(:) = [ 1, 3, 2, 4 ]
   jc(:) = [ 1, 1, 2, 2 ]
   zval(:) = [ (1.0d0,1.0d0), (2.0d0,1.0d0), (3.0d0,1.0d0), (4.0d0,1.0d0) ]

   A = mfSpImport(ir,jc,zval)
   call msDisplay(A, "A = mfSpImport(ir,jc,zval)")

   deallocate( ir, jc, zval )

   print "(/,A)", "*** test number 18 ***"
   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true"
   else
      print *, "  --> info: 'A' row sorted : false"
   end if

   allocate( ir(4), jc(4), zval(4) )
   ir(:) = [ 3, 1, 2, 4 ]
   jc(:) = [ 1, 1, 2, 2 ]
   zval(:) = [ (1.0d0,1.0d0), (2.0d0,1.0d0), (3.0d0,1.0d0), (4.0d0,1.0d0) ]

   A = mfSpImport(ir,jc,zval)
   call msDisplay(A, "A = mfSpImport(ir,jc,zval)")

   deallocate( ir, jc, zval )

   print "(/,A)", "*** test number 19 ***"
   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true"
   else
      print *, "  --> info: 'A' row sorted : false"
   end if

   print "()"
   print *, "  ... row sorting ..."
   print "()"
   call msRowSort( A )
   call msDisplay(A, "sorted matrix A")

   print "(/,A)", "*** test number 20 ***"
   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true (ok)"
   else
      call msPause("Bug: after calling 'msRowSort', A should be RowSorted!")
   end if

   !-- matrix with duplicate entries

   allocate( ir(6), jc(6), zval(6) )
   ir(:) = [ 1, 1, 1, 3, 3, 3 ]
   jc(:) = [ 1, 2, 2, 2, 2, 3 ]
   zval(:) = [ (1.0d0,1.0d0), (2.0d0,1.0d0), (3.0d0,1.0d0),             &
               (4.0d0,1.0d0), (5.0d0,1.0d0), (6.0d0,1.0d0) ]

   A = mfSpImport(ir,jc,zval)
   call msDisplay(A, "A = mfSpImport(ir,jc,zval)")

   deallocate( ir, jc, zval )

   print "(/,A)", "*** test number 21 ***"
   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true"
   else
      print *, "  --> info: 'A' row sorted : false"
   end if

   print "()"
   print *, "  ... row sorting ..."
   print "()"
   MsgLevel_save = mfGetMsgLevel()
   call msSetMsgLevel(3) ! verbose mode
   call msRowSort( A )
   call msSetMsgLevel(MsgLevel_save)
   call msDisplay(A, "sorted matrix A")

   print "(/,A)", "*** test number 22 ***"
   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true (ok)"
   else
      call msPause("Bug: after calling 'msRowSort', A should be RowSorted!")
   end if
   print "()"

   ! mfGet -------------------------------------------------------------
   call print_separation("mfGet")

   ! get an element (i,j)

   !--- real case, not row-sorted (or unknown)
   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 5, 1, 1, 2, 2, 3, 4, 4, 5 ]
   jc(:) = [ 1, 1, 5, 2, 4, 3, 2, 4, 5 ]
   val(:) = [ 8.0d0, 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0, 7.0d0, 9.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   B = mfFull(A)
   call msDisplay(B, "")

   deallocate( ir, jc, val )

   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true"
   else
      print *, "  --> info: 'A' row sorted : false"
   end if

   print "(/,A)", "*** test number 23 ***"
   call msDisplay( mfGet(A,4,2), "A(4,2)" )

   print "(/,A)", "*** test number 24 ***"
   call msDisplay( mfGet(A,2,3), "A(2,3)" )

   ! row-sorted, now

   call msRowSort( A )
   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true"
   else
      print *, "  --> info: 'A' row sorted : false"
   end if

   print "(/,A)", "*** test number 25 ***"
   call msDisplay( mfGet(A,4,2), "A(4,2)" )

   print "(/,A)", "*** test number 26 ***"
   call msDisplay( mfGet(A,2,3), "A(2,3)" )

   !--- complex case, not row-sorted (or unknown)
   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 5, 1, 1, 2, 2, 3, 4, 4, 5 ]
   jc(:) = [ 1, 1, 5, 2, 4, 3, 2, 4, 5 ]
   val(:) = [ 8.0d0, 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0, 7.0d0, 9.0d0 ]

   A = mfSpImport(ir,jc,val)*MF_I
   call msDisplay(A, "A = mfSpImport(ir,jc,val)*MF_I")

   B = mfFull(A)
   call msDisplay(B, "")

   deallocate( ir, jc, val )

   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true"
   else
      print *, "  --> info: 'A' row sorted : false"
   end if

   print "(/,A)", "*** test number 27 ***"
   call msDisplay( mfGet(A,4,2), "A(4,2)" )

   print "(/,A)", "*** test number 28 ***"
   call msDisplay( mfGet(A,2,3), "A(2,3)" )

   ! row-sorted, now

   call msRowSort( A )
   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true"
   else
      print *, "  --> info: 'A' row sorted : false"
   end if

   print "(/,A)", "*** test number 29 ***"
   call msDisplay( mfGet(A,4,2), "A(4,2)" )

   print "(/,A)", "*** test number 30 ***"
   call msDisplay( mfGet(A,2,3), "A(2,3)" )

   ! get a column or a row (result is a dense vector)

   !--- real case
   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 4, 4, 5, 5 ]
   jc(:) = [ 1, 5, 2, 4, 3, 2, 4, 1, 5 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0, 7.0d0, 8.0d0, 9.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   B = mfFull(A)
   call msDisplay(B, "")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 31 ***"
   call msDisplay( mfGet(A,MF_COLON,2), "A(:,2)" )

   print "(/,A)", "*** test number 32 ***"
   call msDisplay( mfGet(A,2,MF_COLON), "A(2,:)" )

   !--- complex case
   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 4, 4, 5, 5 ]
   jc(:) = [ 1, 5, 2, 4, 3, 2, 4, 1, 5 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0, 7.0d0, 8.0d0, 9.0d0 ]

   A = mfSpImport(ir,jc,val)*MF_I
   call msDisplay(A, "A = mfSpImport(ir,jc,val)*MF_I")

   B = mfFull(A)
   call msDisplay(B, "")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 33 ***"
   call msDisplay( mfGet(A,MF_COLON,2), "A(:,2)" )

   print "(/,A)", "*** test number 34 ***"
   call msDisplay( mfGet(A,2,MF_COLON), "A(2,:)" )

   ! get a contiguous sub-matrix (result is sparse)

   !--- real case
   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 4, 4, 5, 5 ]
   jc(:) = [ 1, 5, 2, 4, 3, 2, 4, 1, 5 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0, 7.0d0, 8.0d0, 9.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   B = mfFull(A)
   call msDisplay(B, "")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 35 ***"
   C = mfGet(A,[(i,i=2,4)],[(i,i=2,4)])

   call msDisplay( C, "C = mfGet(A,[(i,i=2,4)],[(i,i=2,4)])" )

   call msDisplay(mfFull(C), "")

   !--- complex case
   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 4, 4, 5, 5 ]
   jc(:) = [ 1, 5, 2, 4, 3, 2, 4, 1, 5 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0, 7.0d0, 8.0d0, 9.0d0 ]

   A = mfSpImport(ir,jc,val)*MF_I
   call msDisplay(A, "A = mfSpImport(ir,jc,val)*MF_I")

   B = mfFull(A)
   call msDisplay(B, "")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 36 ***"
   C = mfGet(A,[(i,i=2,4)],[(i,i=2,4)])

   call msDisplay( C, "C = mfGet(A,[(i,i=2,4)],[(i,i=2,4)])" )

   call msDisplay(mfFull(C), "")

   ! extract some contiguous rows (result is sparse)

   !--- real case : 5x5 matrix
   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 4, 4, 5, 5 ]
   jc(:) = [ 1, 5, 2, 4, 3, 2, 4, 1, 5 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0, 7.0d0, 8.0d0, 9.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   B = mfFull(A)
   call msDisplay(B, "")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 37 ***"
   C = mfGet(A,[2,3,4],MF_COLON)

   call msDisplay( C,                                                   &
                  "C = mfGet(A,[2,3,4],MF_COLON)" )

   call msDisplay(mfFull(C), "")

   ! permutation of all columns (result is sparse)

   !--- real case : 5x5 matrix
   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 4, 4, 5, 5 ]
   jc(:) = [ 1, 5, 2, 4, 3, 2, 4, 1, 5 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0, 7.0d0, 8.0d0, 9.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   B = mfFull(A)
   call msDisplay(B, "")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 38 ***"
   C = mfGet(A,MF_COLON,[5,1,4,2,3])

   call msDisplay( C, "C = mfGet(A,MF_COLON,[5,1,4,2,3])" )

   call msDisplay(mfFull(C), "")

   print "(/,A)", "*** test number 39 ***"
   C = mfGet(A,MF_COLON,[5,1,3])

   call msDisplay( C, "C = mfGet(A,MF_COLON,[5,1,3])" )

   call msDisplay(mfFull(C), "")

   ! supplements
   !--- real case : 5x5 matrix
   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 4, 4, 5, 5 ]
   jc(:) = [ 1, 5, 2, 4, 3, 2, 4, 1, 5 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0, 7.0d0, 8.0d0, 9.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   B = mfFull(A)
   call msDisplay(B, "")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 40 ***"
   C = mfGet(A,mf([2,3,4]),MF_COLON)

   call msDisplay( C, "C = mfGet(A,mf([2,3,4]),MF_COLON)" )

   call msDisplay(mfFull(C), "")

   print "(/,A)", "*** test number 41 ***"
   C = mfGet(A,mf([2,3,4]),mf([2,3,4]))

   call msDisplay( C, "C = mfGet(A,mf([2,3,4]),mf([2,3,4]))" )

   call msDisplay(mfFull(C), "")

   print "(/,A)", "*** test number 42 ***"
   C = mfGet(A,mf([2,3,4]),2)

   call msDisplay( C, "C = mfGet(A,mf([2,3,4]),2)" )

   print "(/,A)", "*** test number 43 ***"
   C = mfGet(A,2,mf([2,3,4]))

   call msDisplay( C, "C = mfGet(A,2,mf([2,3,4]))" )

   print "(/,A)", "*** test number 44 ***"
   C = mfGet(A,2.to.4,2.to.4)

   call msDisplay( C, "C = mfGet(A,2.to.4,2.to.4)" )

   call msDisplay(mfFull(C), "")

   print "(/,A)", "*** test number 45 ***"
   C = mfGet(A,2,2.to.4)

   call msDisplay( C, "C = mfGet(A,2,2.to.4)" )

   print "(/,A)", "*** test number 46 ***"
   C = mfGet(A,2.to.4,2)

   call msDisplay( C, "C = mfGet(A,2.to.4,2)" )

   print "(/,A)", "*** test number 47 ***"
   C = mfGet(A,mf([2,3,4]),2.to.4)

   call msDisplay( C, "C = mfGet(A,mf([2,3,4]),2.to.4)" )

   call msDisplay(mfFull(C), "")

   print "(/,A)", "*** test number 48 ***"
   C = mfGet(A,2.to.4,mf([2,3,4]))

   call msDisplay( C, "C = mfGet(A,2.to.4,mf([2,3,4]))" )

   call msDisplay(mfFull(C), "")

   ! msSet -------------------------------------------------------------
   call print_separation("msSet")

   !------ data is a dense column

   !--- real case
   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 4, 4, 5, 5 ]
   jc(:) = [ 1, 5, 2, 4, 3, 2, 4, 1, 5 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0, 7.0d0, 8.0d0, 9.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   B = mfFull(A)
   call msDisplay(B, "")

   deallocate( ir, jc, val )

   ! same nb of element in the modified column
   v = .t. mf( [ 0, 13, 0, 16, 0 ] )
   call msDisplay( v, "v" )
   print "(/,A)", "*** test number 49 ***"
   call msSet( v, A, MF_COLON, [2] )
   call msDisplay( mfFull(A), "A is sparse: mfFull(A)" )

   v = .t. mf( [ -1, 0, -2, 0, 0 ] )
   call msDisplay( v, "v" )
   print "(/,A)", "*** test number 50 ***"
   call msSet( v, A, MF_COLON, 2 )
   call msDisplay( mfFull(A), "A is sparse: mfFull(A)" )

   ! increase nb of element in the modified column
   v = .t. mf( [ 0, 4, 5, 6, 0 ] )
   call msDisplay( v, "v" )
   print "(/,A)", "*** test number 51 ***"
   call msSet( v, A, MF_COLON, [2] )
   call msDisplay( mfFull(A), "A is sparse: mfFull(A)" )

   ! decrease nb of element in the modified column
   v = .t. mf( [ 0, 0, 0, 0, -10 ] )
   call msDisplay( v, "v" )
   print "(/,A)", "*** test number 52 ***"
   call msSet( v, A, MF_COLON, 2 )
   call msDisplay( mfFull(A), "A is sparse: mfFull(A)" )

   ! auto switch to complex
   v = .t. mf( [ 0, 13, 0, 16, 0 ] )*MF_I
   call msDisplay( v, "v" )
   print "(/,A)", "*** test number 53 ***"
   call msSet( v, A, MF_COLON, [2] )
   call msDisplay( mfFull(A), "A is sparse: mfFull(A)" )

   !--- complex case
   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 4, 4, 5, 5 ]
   jc(:) = [ 1, 5, 2, 4, 3, 2, 4, 1, 5 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0, 7.0d0, 8.0d0, 9.0d0 ]

   A = mfSpImport(ir,jc,val)*MF_I
   call msDisplay(A, "A = mfSpImport(ir,jc,val)*MF_I")

   B = mfFull(A)
   call msDisplay(B, "")

   deallocate( ir, jc, val )

   ! same nb of element in the modified column
   v = .t. mf( [ 0, 13, 0, 16, 0 ] )*MF_I
   call msDisplay( v, "v" )
   print "(/,A)", "*** test number 54 ***"
   call msSet( v, A, MF_COLON, [2] )
   call msDisplay( mfFull(A), "A is sparse: mfFull(A)" )

   v = .t. mf( [ -1, 0, -2, 0, 0 ] )*MF_I
   call msDisplay( v, "v" )
   print "(/,A)", "*** test number 55 ***"
   call msSet( v, A, MF_COLON, 2 )
   call msDisplay( mfFull(A), "A is sparse: mfFull(A)" )

   ! increase nb of element in the modified column
   v = .t. mf( [ 0, 4, 5, 6, 0 ] )*MF_I
   call msDisplay( v, "v" )
   print "(/,A)", "*** test number 56 ***"
   call msSet( v, A, MF_COLON, [2] )
   call msDisplay( mfFull(A), "A is sparse: mfFull(A)" )

   ! decrease nb of element in the modified column
   v = .t. mf( [ 0, 0, 0, 0, -10 ] )*MF_I
   call msDisplay( v, "v" )
   print "(/,A)", "*** test number 57 ***"
   call msSet( v, A, MF_COLON, [2] )
   call msDisplay( mfFull(A), "A is sparse: mfFull(A)" )

   ! can update from real
   v = .t. mf( [ 0, 13, 0, 16, 0 ] )
   call msDisplay( v, "v" )
   print "(/,A)", "*** test number 58 ***"
   call msSet( v, A, MF_COLON, [2] )
   call msDisplay( mfFull(A), "A is sparse: mfFull(A)" )

   !------ data is a sparse column

   !--- real case
   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 4, 4, 5, 5 ]
   jc(:) = [ 1, 5, 2, 4, 3, 2, 4, 1, 5 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0, 7.0d0, 8.0d0, 9.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   B = mfFull(A)
   call msDisplay(B, "")

   deallocate( ir, jc, val )

   v = mfSparse( .t. mf( [ 0, 13, 0, 16, 0 ] ) )
   call msDisplay( v, "v" )
   print "(/,A)", "*** test number 59 ***"
   call msSet( v, A, MF_COLON, 2 )
   call msDisplay( mfFull(A), "A is sparse: mfFull(A)" )

   !--- complex case
   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 4, 4, 5, 5 ]
   jc(:) = [ 1, 5, 2, 4, 3, 2, 4, 1, 5 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0, 7.0d0, 8.0d0, 9.0d0 ]

   A = mfSpImport(ir,jc,val)*MF_I
   call msDisplay(A, "A = mfSpImport(ir,jc,val)*MF_I")

   B = mfFull(A)
   call msDisplay(B, "")

   deallocate( ir, jc, val )

   v = mfSparse( .t. mf( [ -1, 0, -2, 0, 0 ] )*MF_I )
   call msDisplay( v, "v" )
   print "(/,A)", "*** test number 60 ***"
   call msSet( v, A, MF_COLON, [2] )
   call msDisplay( mfFull(A), "A is sparse: mfFull(A)" )

   !------ changing one element at a time, which must previously exist
   !       in the sparse structure

   !--- real case
   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 4, 4, 5, 5 ]
   jc(:) = [ 1, 5, 2, 4, 3, 2, 4, 1, 5 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0, 7.0d0, 8.0d0, 9.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   B = mfFull(A)
   call msDisplay(B, "")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 61 ***"
   call msSet( -1.0d0, A, 4, 2 )
   call msDisplay( mfFull(A), "A is sparse: mfFull(A)" )

   A = A*MF_I

   print "(/,A)", "*** test number 62 ***"
   call msSet( -1.0d0, A, 4, 2 )             ! in a complex matrix
   call msDisplay( mfFull(A), "A is sparse: mfFull(A)" )

   !--- complex case

   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 4, 4, 5, 5 ]
   jc(:) = [ 1, 5, 2, 4, 3, 2, 4, 1, 5 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0, 7.0d0, 8.0d0, 9.0d0 ]

   A = mfSpImport(ir,jc,val)*MF_I
   call msDisplay(A, "A = mfSpImport(ir,jc,val)*MF_I")

   B = mfFull(A)
   call msDisplay(B, "")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 63 ***"
   call msSet( (-1.0d0,0.0d0), A, 4, 2 )
   call msDisplay( mfFull(A), "A is sparse: mfFull(A)" )

   !------ changing one element at a time, whose entry doesn't exist
   !       in the sparse structure

   !--- real case
   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 4, 4, 5, 5 ]
   jc(:) = [ 1, 5, 2, 4, 3, 2, 4, 1, 5 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0, 7.0d0, 8.0d0, 9.0d0 ]

   A = mfSpImport(ir,jc,val,nzmax=12)
   call msDisplay(A, "A = mfSpImport(ir,jc,val,nzmax=15)")

   B = mfFull(A)
   call msDisplay(B, "")

   deallocate( ir, jc, val )

   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true"
   else
      print *, "  --> info: 'A' row sorted : false"
   end if

   print "(/,A)", "*** test number 64 ***"
   call msSet( -11.0d0, A, 5, 3 )
   call msDisplay( mfFull(A), "A is sparse: mfFull(A)" )

   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true"
   else
      print *, "  --> info: 'A' row sorted : false"
   end if

   print "(/,A)", "*** test number 65 ***"
   call msSet( -22.0d0, A, 1, 3 )
   call msDisplay( mfFull(A), "A is sparse: mfFull(A)" )

   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true"
   else
      print *, "  --> info: 'A' row sorted : false"
   end if

   !--- complex case

   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 4, 4, 5, 5 ]
   jc(:) = [ 1, 5, 2, 4, 3, 2, 4, 1, 5 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0, 7.0d0, 8.0d0, 9.0d0 ]

   A = mfSpImport(ir,jc,val,nzmax=12)*MF_I
   deallocate( ir, jc, val )
   call msDisplay(A, "A = mfSpImport(ir,jc,val,nzmax=12)*MF_I")

   B = mfFull(A)
   call msDisplay(B, "")

   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true"
   else
      print *, "  --> info: 'A' row sorted : false"
   end if

   print "(/,A)", "*** test number 66 ***"
   call msSet( (-11.0d0,0.0d0), A, 5, 3 )
   call msDisplay( mfFull(A), "A is sparse: mfFull(A)" )

   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true"
   else
      print *, "  --> info: 'A' row sorted : false"
   end if

   print "(/,A)", "*** test number 67 ***"
   call msSet( (-11.0d0,0.0d0), A, 1, 3 )
   call msDisplay( mfFull(A), "A is sparse: mfFull(A)" )

   if( mfIsRowSorted( A ) ) then
      print *, "  --> info: 'A' row sorted : true"
   else
      print *, "  --> info: 'A' row sorted : false"
   end if
   print "()"

   ! mfDiag ------------------------------------------------------------
   call print_separation("mfDiag")

   !--- real case
   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 4, 4, 5, 5 ]
   jc(:) = [ 1, 5, 2, 4, 3, 2, 4, 1, 5 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0, 7.0d0, 8.0d0, 9.0d0 ]

   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   B = mfFull(A)
   call msDisplay(B, "")

   print "(/,A)", "*** test number 68 ***"
   call msDisplay( .t.mfDiag(A), "mfDiag(A)" )

   print "(/,A)", "*** test number 69 ***"
   call msDisplay( .t.mfDiag(A,2), "mfDiag(A,2)" )

   print "(/,A)", "*** test number 70 ***"
   call msDisplay( .t.mfDiag(A,-2), "mfDiag(A,-2)" )

   !--- complex case
   A = A*MF_I

   B = mfFull(A)
   call msDisplay(B, "")

   ! deactivating warning for .t. operator applied to complex mfArrays
   MsgLevel_save = mfGetMsgLevel()
   call msSetMsgLevel(1)

   print "(/,A)", "*** test number 71 ***"
   call msDisplay( .t.mfDiag(A), "mfDiag(A)" )

   print "(/,A)", "*** test number 72 ***"
   call msDisplay( .t.mfDiag(A,2), "mfDiag(A,2)" )

   print "(/,A)", "*** test number 73 ***"
   call msDisplay( .t.mfDiag(A,-2), "mfDiag(A,-2)" )

   ! restore message level
   call msSetMsgLevel(MsgLevel_save)

   ! msDiag ------------------------------------------------------------
   call print_separation("msDiag")

   !--- real case
   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 4, 4, 5, 5 ]
   jc(:) = [ 1, 5, 2, 4, 3, 2, 4, 1, 5 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0, 7.0d0, 8.0d0, 9.0d0 ]

   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   print "(/,A)", "*** test number 74 ***"
   v = [ -1, -2, -3 ]
   call msDisplay(v, "v")
   call msDiag( A, v, 2 )
   call msDisplay(A, "A")
   print *, "after 'call msDiag( A, v, 2 )':"
   call msDisplay(mfFull(A), "")

   print "(/,A)", "*** test number 75 ***"
   v = [ -4, -5, -6 ]
   call msDisplay(v, "v")
   call msDiag( A, v, -2 )
   call msDisplay(A, "A")
   print *, "after 'call msDiag( A, v, -2 )':"
   call msDisplay(mfFull(A), "")

   !--- complex case should be ok

   ! mfBlkDiag ---------------------------------------------------------
   call print_separation("mfBlkDiag")

   print "(/,A)", "*** test number 76 ***"
   allocate( ir(10), jc(10), val(10) )
   ir(:) = [ 1, 1, 2, 2, 3, 3, 4, 4, 4, 4 ]
   jc(:) = [ 1, 4, 2, 4, 3, 4, 1, 2, 3, 4 ]
   val(:) = [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 ]

   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   allocate( ir(7), jc(7), val(7) )
   ir(:) = [ 1, 1, 1, 2, 2, 3, 3 ]
   jc(:) = [ 1, 2, 3, 1, 2, 1, 3 ]
   val(:) = [ -1, -2, -3, -4, -5, -6, -7 ]

   B = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   call msDisplay(B, "B = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(B), "")

   C = mfBlkDiag(A,B)
   call msDisplay( C, "blkdiag(A,B)" )
   call msDisplay(mfFull(C), "")

   print "(/,A)", "*** test number 77 ***"
   allocate( ir(10), jc(10), val(10) )
   ir(:) = [ 1, 1, 2, 2, 3, 3, 4, 4, 4, 4 ]
   jc(:) = [ 1, 4, 2, 4, 3, 4, 1, 2, 3, 4 ]
   val(:) = [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 ]

   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   C = mfBlkDiag(A,3)
   call msDisplay( C, "blkdiag(A,3)" )
   call msDisplay(mfFull(C), "")

   ! operator(.hc.) ----------------------------------------------------
   call print_separation("operator(.hc.)")

   ! SP real / SP real
   print "(/,A)", "*** test number 78 ***"
   A = mfSpEye(5,5) .hc. mfSpEye(5,3)*(-1.0d0)

   call msDisplay(A, "A = mfSpEye(5,5) .hc. mfSpEye(5,3)*(-1.0d0)")

   B = mfFull(A)
   call msDisplay(B, "")

   ! SP real / SP complex
   print "(/,A)", "*** test number 79 ***"
   A = mfSpEye(5,5) .hc. mfSpEye(5,3)*MF_I

   call msDisplay(A, "A = mfSpEye(5,5) .hc. mfSpEye(5,3)*MF_I")

   B = mfFull(A)
   call msDisplay(B, "")

   ! SP complex / SP real
   print "(/,A)", "*** test number 80 ***"
   A = mfSpEye(5,5)*MF_I .hc. mfSpEye(5,3)

   call msDisplay(A, "A = mfSpEye(5,5)*MF_I .hc. mfSpEye(5,3)")

   B = mfFull(A)
   call msDisplay(B, "")

   ! SP complex / SP complex
   print "(/,A)", "*** test number 81 ***"
   A = mfSpEye(5,5)*MF_I .hc. mfSpEye(5,3)*MF_I*(-1.0d0)

   call msDisplay(A, "A = mfSpEye(5,5)*MF_I .hc. mfSpEye(5,3)*MF_I*(-1.0d0)")

   B = mfFull(A)
   call msDisplay(B, "")

   ! SP real / dense real
   v = mfZeros(5,1)
   call msSet(-1.0d0,v,3)
   print "(/,A)", "*** test number 82 ***"
   A = mfSpEye(5,5) .hc. v

   call msDisplay(A, "A = mfSpEye(5,5) .hc. v")

   B = mfFull(A)
   call msDisplay(B, "")

   ! SP real / dense complex
   v = mfZeros(5,1)
   call msSet(-1.0d0*MF_I,v,3)
   print "(/,A)", "*** test number 83 ***"
   A = mfSpEye(5,5) .hc. v

   call msDisplay(A, "A = mfSpEye(5,5) .hc. v")

   B = mfFull(A)
   call msDisplay(B, "")

   ! SP complex / dense real
   v = mfZeros(5,1)
   call msSet(-1.0d0,v,3)
   print "(/,A)", "*** test number 84 ***"
   A = mfSpEye(5,5)*MF_I .hc. v

   call msDisplay(A, "A = mfSpEye(5,5)*MF_I .hc. v")

   B = mfFull(A)
   call msDisplay(B, "")

   ! SP complex / dense complex
   v = mfZeros(5,1)
   call msSet(-1.0d0*MF_I,v,3)
   print "(/,A)", "*** test number 85 ***"
   A = mfSpEye(5,5)*MF_I .hc. v

   call msDisplay(A, "A = mfSpEye(5,5)*MF_I .hc. v")

   B = mfFull(A)
   call msDisplay(B, "")

   ! msHorizConcat ----------------------------------------------------
   call print_separation("msHorizConcat")

   ! SP real / SP real
   A = mfSpEye(5,5)
   B = mfSpEye(5,3)*(-1.0d0)

   print "(/,A)", "*** test number 86 ***"
   call msHorizConcat( A, B )
   call msDisplay(A, "A")

   C = mfFull(A)
   call msDisplay(C, "")

   ! concatenating with a dense vector
   A = MF_EMPTY
   b = mfZeros(5,1)
   call msSet( 2.0d0, b, 2 )
   call msSet( 4.0d0, b, 4 )

   print "(/,A)", "*** test number 87 ***"
   call msHorizConcat( A, b )
   call msDisplay(mfFull(A), "A is sparse: mfFull(A)")

   b = mfZeros(5,1)
   call msSet( 1.0d0, b, 1 )
   call msSet( 5.0d0, b, 5 )

   print "(/,A)", "*** test number 88 ***"
   call msHorizConcat( A, b )
   call msDisplay(mfFull(A), "A is sparse: mfFull(A)")

   ! operator(.vc.) ----------------------------------------------------
   call print_separation("operator(.vc.)")

   ! SP real / SP real
   print "(/,A)", "*** test number 89 ***"
   A = mfSpEye(5,5) .vc. mfSpEye(3,5)*(-1.0d0)

   call msDisplay(A, "A = mfSpEye(5,5) .vc. mfSpEye(3,5)*(-1.0d0)")

   B = mfFull(A)
   call msDisplay(B, "")

   ! SP real / SP complex
   print "(/,A)", "*** test number 90 ***"
   A = mfSpEye(5,5) .vc. mfSpEye(3,5)*MF_I

   call msDisplay(A, "A = mfSpEye(5,5) .vc. mfSpEye(3,5)*MF_I")

   B = mfFull(A)
   call msDisplay(B, "")

   ! SP complex / SP real
   print "(/,A)", "*** test number 91 ***"
   A = mfSpEye(5,5)*MF_I .vc. mfSpEye(3,5)

   call msDisplay(A, "A = mfSpEye(5,5)*MF_I .vc. mfSpEye(3,5)")

   B = mfFull(A)
   call msDisplay(B, "")

   ! SP complex / SP complex
   print "(/,A)", "*** test number 92 ***"
   A = mfSpEye(5,5)*MF_I .vc. mfSpEye(3,5)*MF_I*(-1.0d0)

   call msDisplay(A, "A = mfSpEye(5,5)*MF_I .vc. mfSpEye(3,5)*MF_I*(-1.0d0)")

   B = mfFull(A)
   call msDisplay(B, "")

   ! SP real / dense real
   v = mfZeros(1,5)
   call msSet(-1.0d0,v,3)
   print "(/,A)", "*** test number 93 ***"
   A = mfSpEye(5,5) .vc. v

   call msDisplay(A, "A = mfSpEye(5,5) .vc. v")

   B = mfFull(A)
   call msDisplay(B, "")

   ! SP real / dense complex
   v = mfZeros(1,5)
   call msSet(-1.0d0*MF_I,v,3)
   print "(/,A)", "*** test number 94 ***"
   A = mfSpEye(5,5) .vc. v

   call msDisplay(A, "A = mfSpEye(5,5) .vc. v")

   B = mfFull(A)
   call msDisplay(B, "")

   ! SP complex / dense real
   v = mfZeros(1,5)
   call msSet(-1.0d0,v,3)
   print "(/,A)", "*** test number 95 ***"
   A = mfSpEye(5,5)*MF_I .vc. v

   call msDisplay(A, "A = mfSpEye(5,5)*MF_I .vc. v")

   B = mfFull(A)
   call msDisplay(B, "")

   ! SP complex / dense complex
   v = mfZeros(1,5)
   call msSet(-1.0d0*MF_I,v,3)
   print "(/,A)", "*** test number 96 ***"
   A = mfSpEye(5,5)*MF_I .vc. v

   call msDisplay(A, "A = mfSpEye(5,5)*MF_I .vc. v")

   B = mfFull(A)
   call msDisplay(B, "")

   ! mfNorm ------------------------------------------------------------
   call print_separation("mfNorm")

   ! --- very small null matrix (1x1)
   A = mfSpAlloc(1,1)
   print "(/,A)", "*** test number 97 ***"
   call msDisplay(A, "A = mfSpAlloc(1,1)")
   call msDisplay(mfNorm(A), "| A |_2")

   ! --- very small null matrix (2x2)
   A = mfSpAlloc(2,2)
   print "(/,A)", "*** test number 98 ***"
   call msDisplay(A, "A = mfSpAlloc(2,2)")
   call msDisplay(mfNorm(A), "| A |_2")

   ! --- very small null matrix (2x2)
   A = mfSpAlloc(2,2)
   print "(/,A)", "*** test number 99 ***"
   call msDisplay(A, "A = mfSpAlloc(2,2)")
   call msDisplay(mfNorm(A,1), "| A |_1")

   ! --- very small Id matrix (1x1)
   A = mfSpEye(1)
   print "(/,A)", "*** test number 100 ***"
   call msDisplay(A, "A = mfSpEye(1)")
   call msDisplay(mfNorm(A), "| A |_2")

   ! --- very small Id matrix (2x2)
   A = mfSpEye(2)
   print "(/,A)", "*** test number 101 ***"
   call msDisplay(A, "A = mfSpEye(2)")
   call msDisplay(mfNorm(A), "| A |_2")

   ! --- very small Id matrix (2x2)
   A = mfSpEye(2)
   print "(/,A)", "*** test number 102 ***"
   call msDisplay(A, "A = mfSpEye(2)")
   call msDisplay(mfNorm(A,1), "| A |_1")

   ! --- real case
   A = mfSpEye(5,5)
   call msDisplay(A, "A")
   B = mfFull(A)
   call msDisplay(B, "A is sparse: mfFull(A)")
   print "(/,A)", "*** test number 103 ***"
   call msDisplay( mfNorm(A,1), "mfNorm(A,1)" )
   print "(/,A)", "*** test number 104 ***"
   call msDisplay( mfNorm(B,1), "mfNorm(mfFull(A),1)" )
   print "(/,A)", "*** test number 105 ***"
   call msDisplay( mfNorm(A,2), "mfNorm(A,2)" )
   print "(/,A)", "*** test number 106 ***"
   call msDisplay( mfNorm(B,2), "mfNorm(mfFull(A),2)" )
   print "(/,A)", "*** test number 107 ***"
   call msDisplay( mfNorm(A,'inf'), "mfNorm(A,'inf')" )
   print "(/,A)", "*** test number 108 ***"
   call msDisplay( mfNorm(B,'inf'), "mfNorm(mfFull(A),'inf')" )
   print "(/,A)", "*** test number 109 ***"
   call msDisplay( mfNorm(A,'fro'), "mfNorm(A,'fro')" )
   print "(/,A)", "*** test number 110 ***"
   call msDisplay( mfNorm(B,'fro'), "mfNorm(mfFull(A),'fro')" )

   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 4, 4, 5, 5 ]
   jc(:) = [ 1, 5, 2, 4, 3, 2, 4, 1, 5 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0, 7.0d0, 8.0d0, 9.0d0 ]

   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   call msDisplay(A, "A")
   B = mfFull(A)
   call msDisplay(B, "A is sparse: mfFull(A)")
   print "(/,A)", "*** test number 111 ***"
   call msDisplay( mfNorm(A,1), "mfNorm(A,1)" )
   print "(/,A)", "*** test number 112 ***"
   call msDisplay( mfNorm(B,1), "mfNorm(mfFull(A),1)" )
   print "(/,A)", "*** test number 113 ***"
   call msDisplay( mfNorm(A,2), "mfNorm(A,2)" )
   print "(/,A)", "*** test number 114 ***"
   call msDisplay( mfNorm(B,2), "mfNorm(mfFull(A),2)" )
   print "(/,A)", "*** test number 115 ***"
   call msDisplay( mfNorm(A,'inf'), "mfNorm(A,'inf')" )
   print "(/,A)", "*** test number 116 ***"
   call msDisplay( mfNorm(B,'inf'), "mfNorm(mfFull(A),'inf')" )
   print "(/,A)", "*** test number 117 ***"
   call msDisplay( mfNorm(A,'fro'), "mfNorm(A,'fro')" )
   print "(/,A)", "*** test number 118 ***"
   call msDisplay( mfNorm(B,'fro'), "mfNorm(mfFull(A),'fro')" )

   ! --- complex case
   A = mfSpEye(5,5)*MF_I
   call msDisplay(A, "A")
   B = mfFull(A)
   call msDisplay(B, "A is sparse: mfFull(A)")
   print "(/,A)", "*** test number 119 ***"
   call msDisplay( mfNorm(A,1), "mfNorm(A,1)" )
   print "(/,A)", "*** test number 120 ***"
   call msDisplay( mfNorm(B,1), "mfNorm(mfFull(A),1)" )
!!   call msDisplay( mfNorm(A,2), "mfNorm(A,2)" )
!!   call msDisplay( mfNorm(B,2), "mfNorm(mfFull(A),2)" )
   print "(/,A)", "*** test number 121 ***"
   call msDisplay( mfNorm(A,'inf'), "mfNorm(A,'inf')" )
   print "(/,A)", "*** test number 122 ***"
   call msDisplay( mfNorm(B,'inf'), "mfNorm(mfFull(A),'inf')" )
   print "(/,A)", "*** test number 123 ***"
   call msDisplay( mfNorm(A,'fro'), "mfNorm(A,'fro')" )
   print "(/,A)", "*** test number 124 ***"
   call msDisplay( mfNorm(B,'fro'), "mfNorm(mfFull(A),'fro')" )

   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 4, 4, 5, 5 ]
   jc(:) = [ 1, 5, 2, 4, 3, 2, 4, 1, 5 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0, 7.0d0, 8.0d0, 9.0d0 ]

   A = mfSpImport(ir,jc,val) + mfSpEye(5,5)*MF_I
   deallocate( ir, jc, val )
   call msDisplay(A, "A")
   B = mfFull(A)
   call msDisplay(B, "A is sparse: mfFull(A)")
   print "(/,A)", "*** test number 125 ***"
   call msDisplay( mfNorm(A,1), "mfNorm(A,1)" )
   print "(/,A)", "*** test number 126 ***"
   call msDisplay( mfNorm(B,1), "mfNorm(mfFull(A),1)" )
!!   call msDisplay( mfNorm(A,2), "mfNorm(A,2)" )
!!   call msDisplay( mfNorm(B,2), "mfNorm(mfFull(A),2)" )
   print "(/,A)", "*** test number 127 ***"
   call msDisplay( mfNorm(A,'inf'), "mfNorm(A,'inf')" )
   print "(/,A)", "*** test number 128 ***"
   call msDisplay( mfNorm(B,'inf'), "mfNorm(mfFull(A),'inf')" )
   print "(/,A)", "*** test number 129 ***"
   call msDisplay( mfNorm(A,'fro'), "mfNorm(A,'fro')" )
   print "(/,A)", "*** test number 130 ***"
   call msDisplay( mfNorm(B,'fro'), "mfNorm(mfFull(A),'fro')" )

   ! mfTril ------------------------------------------------------------
   call print_separation("mfTril")

   ! real case
   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 3, 3, 4, 4 ]
   jc(:) = [ 1, 7, 2, 6, 4, 2, 6, 1, 3 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0, 7.0d0, 8.0d0, 9.0d0 ]

   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   call msDisplay(A, "A")
   B = mfFull(A)
   call msDisplay(B, "A is sparse: mfFull(A)")

   print "(/,A)", "*** test number 131 ***"
   C = mfTril(A)
   call msDisplay(C,"mfTril(A)")
   call msDisplay(mfFull(C), "")

   print "(/,A)", "*** test number 132 ***"
   C = mfTril(A,1)
   call msDisplay(C,"mfTril(A,1)")
   call msDisplay(mfFull(C), "")

   print "(/,A)", "*** test number 133 ***"
   C = mfTril(A,-1)
   call msDisplay(C,"mfTril(A,-1)")
   call msDisplay(mfFull(C), "")

   print "(/,A)", "*** test number 134 ***"
   C = mfTril(A,6)
   call msDisplay(C,"mfTril(A,6)")
   call msDisplay(mfFull(C), "")

   print "(/,A)", "*** test number 135 ***"
   C = mfTril(A,-4)
   call msDisplay(C,"mfTril(A,-4)")
   call msDisplay(mfFull(C), "")

   ! complex case
   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 3, 3, 4, 4 ]
   jc(:) = [ 1, 7, 2, 6, 4, 2, 6, 1, 3 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0, 7.0d0, 8.0d0, 9.0d0 ]

   A = mfSpImport(ir,jc,val) + mfSpEye(4,7)*MF_I
   deallocate( ir, jc, val )
   call msDisplay(A, "A")
   B = mfFull(A)
   call msDisplay(B, "A is sparse: mfFull(A)")

   print "(/,A)", "*** test number 136 ***"
   C = mfTril(A)
   call msDisplay(C,"mfTril(A)")
   call msDisplay(mfFull(C), "")

   print "(/,A)", "*** test number 137 ***"
   C = mfTril(A,1)
   call msDisplay(C,"mfTril(A,1)")
   call msDisplay(mfFull(C), "")

   print "(/,A)", "*** test number 138 ***"
   C = mfTril(A,-1)
   call msDisplay(C,"mfTril(A,-1)")
   call msDisplay(mfFull(C), "")

   print "(/,A)", "*** test number 139 ***"
   C = mfTril(A,6)
   call msDisplay(C,"mfTril(A,6)")
   call msDisplay(mfFull(C), "")

   print "(/,A)", "*** test number 140 ***"
   C = mfTril(A,-4)
   call msDisplay(C,"mfTril(A,-4)")
   call msDisplay(mfFull(C), "")

   ! mfTriu ------------------------------------------------------------
   call print_separation("mfTriu")

   ! real case
   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 3, 3, 4, 4 ]
   jc(:) = [ 1, 7, 2, 6, 4, 2, 6, 1, 3 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0, 7.0d0, 8.0d0, 9.0d0 ]

   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   call msDisplay(A, "A")
   B = mfFull(A)
   call msDisplay(B, "A is sparse: mfFull(A)")

   print "(/,A)", "*** test number 141 ***"
   C = mfTriu(A)
   call msDisplay(C,"mfTriu(A)")
   call msDisplay(mfFull(C), "")

   print "(/,A)", "*** test number 142 ***"
   C = mfTriu(A,1)
   call msDisplay(C,"mfTriu(A,1)")
   call msDisplay(mfFull(C), "")

   print "(/,A)", "*** test number 143 ***"
   C = mfTriu(A,-1)
   call msDisplay(C,"mfTriu(A,-1)")
   call msDisplay(mfFull(C), "")

   print "(/,A)", "*** test number 144 ***"
   C = mfTriu(A,6)
   call msDisplay(C,"mfTriu(A,6)")
   call msDisplay(mfFull(C), "")

   print "(/,A)", "*** test number 145 ***"
   C = mfTriu(A,-4)
   call msDisplay(C,"mfTriu(A,-4)")
   call msDisplay(mfFull(C), "")

   ! complex case
   allocate( ir(9), jc(9), val(9) )
   ir(:) = [ 1, 1, 2, 2, 3, 3, 3, 4, 4 ]
   jc(:) = [ 1, 7, 2, 6, 4, 2, 6, 1, 3 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0, 7.0d0, 8.0d0, 9.0d0 ]

   A = mfSpImport(ir,jc,val) + mfSpEye(4,7)*MF_I
   deallocate( ir, jc, val )
   call msDisplay(A, "A")
   B = mfFull(A)
   call msDisplay(B, "A is sparse: mfFull(A)")

   print "(/,A)", "*** test number 146 ***"
   C = mfTriu(A)
   call msDisplay(C,"mfTriu(A)")
   call msDisplay(mfFull(C), "")

   print "(/,A)", "*** test number 147 ***"
   C = mfTriu(A,1)
   call msDisplay(C,"mfTriu(A,1)")
   call msDisplay(mfFull(C), "")

   print "(/,A)", "*** test number 148 ***"
   C = mfTriu(A,-1)
   call msDisplay(C,"mfTriu(A,-1)")
   call msDisplay(mfFull(C), "")

   print "(/,A)", "*** test number 149 ***"
   C = mfTriu(A,6)
   call msDisplay(C,"mfTriu(A,6)")
   call msDisplay(mfFull(C), "")

   print "(/,A)", "*** test number 150 ***"
   C = mfTriu(A,-4)
   call msDisplay(C,"mfTriu(A,-4)")
   call msDisplay(mfFull(C), "")

   ! mfFind, msFind ----------------------------------------------------
   call print_separation("mfFind, msFind")

   ! real

   A = mfSpEye(3,4)
   call msDisplay(A, "A")

   print "(/,A)", "*** test number 151 ***"
   B = mfFind(A)
   call msDisplay(B, "mfFind(A)")

   print "(/,A)", "*** test number 152 ***"
   call msFind( mfOut(B,C), A )
   call msDisplay((.t. B).hc.(.t. C), "indexes i, j")

   print "(/,A)", "*** test number 153 ***"
   call msFind( mfOut(b,c,v), A )
   call msDisplay((.t. b).hc.(.t. b).hc.(.t. v), "indexes i, j, val")

   ! complex

   A = mfSpEye(3,4)*MF_I
   call msDisplay(A, "A")

   print "(/,A)", "*** test number 154 ***"
   B = mfFind(A)
   call msDisplay(B, "mfFind(A)")

   print "(/,A)", "*** test number 155 ***"
   call msFind( mfOut(B,C), A )
   call msDisplay((.t. B).hc.(.t. C), "indexes i, j")

   print "(/,A)", "*** test number 156 ***"
   call msFind( mfOut(b,c,v), A )
   call msDisplay(v, "v")
   ! deactivating warning for .t. operator applied to complex mfArrays
   MsgLevel_save = mfGetMsgLevel()
   call msSetMsgLevel(1)
   call msDisplay((.t. b).hc.(.t. b).hc.(.t. v), "indexes i, j, val")
   ! restore message level
   call msSetMsgLevel(MsgLevel_save)

   ! mfNonZeros --------------------------------------------------------
   call print_separation("mfNonZeros")

   x = mf( [ 2, 0, 0 ] ) .vc.                                           &
       mf( [ 0, 0, 1 ] ) .vc.                                           &
       mf( [ 0, 3, 0 ] )

   x = mfSparse( x )

   call msDisplay(x,"x")
   print "(/,A)", "*** test number 157 ***"
   y = mfNonZeros( x )
   call msDisplay(y,"mfNonZeros( x )")

   x = x*MF_I

   call msDisplay(x,"x")
   print "(/,A)", "*** test number 158 ***"
   y = mfNonZeros( x )
   call msDisplay(y,"mfNonZeros( x )")

   ! mfMax -------------------------------------------------------------
   call print_separation("mfMax")

   call msSetAutoRowSorted(.false.)
   allocate( ir(3), jc(3), val(3) )
   ir(:) = [ 1, 2, 3 ]
   jc(:) = [ 1, 3, 2 ]
   val(:) = [ 2.0d0, -1.0d0, 3.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(mfFull(A), "A is sparse: mfFull(A)")
   deallocate( ir, jc, val )

   allocate( ir(5), jc(5), val(5) )
   ir(:) = [ 1, 3, 3, 2, 1 ]
   jc(:) = [ 1, 1, 2, 2, 3 ]
   val(:) = [ -1.0d0, 5.0d0, 3.0d0, 4.0d0, -2.0d0 ]

   B = mfSpImport(ir,jc,val)
   call msDisplay(mfFull(B), "B is sparse: mfFull(B)")
   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 159 ***"
   C = mfMax(A,B)
   call msDisplay(C,"mfMax(A,B)")
   call msDisplay(mfFull(C), "")

   call msSetAutoRowSorted(.true.)
   allocate( ir(3), jc(3), val(3) )
   ir(:) = [ 1, 2, 3 ]
   jc(:) = [ 1, 3, 2 ]
   val(:) = [ 2.0d0, -1.0d0, 3.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(mfFull(A), "A is sparse: mfFull(A)")
   deallocate( ir, jc, val )

   allocate( ir(5), jc(5), val(5) )
   ir(:) = [ 1, 3, 3, 2, 1 ]
   jc(:) = [ 1, 1, 2, 2, 3 ]
   val(:) = [ -1.0d0, 5.0d0, 3.0d0, 4.0d0, -2.0d0 ]

   B = mfSpImport(ir,jc,val)
   call msDisplay(mfFull(B), "B is sparse: mfFull(B)")
   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 160 ***"
   C = mfMax(A,B)
   call msDisplay(C,"mfMax(A,B)")
   call msDisplay(mfFull(C), "")

   allocate( ir(10), jc(10), val(10) )
   ir(:) = [ 1, 2, 3, 1, 2, 3, 2, 3, 1, 2 ]
   jc(:) = [ 1, 1, 1, 3, 3, 3, 4, 4, 5, 5 ]
   val(:) = [ -1.d0, -2.d0, -3.d0, -1.d0, 1.0d0, &
               1.d0, -1.d0, -2.d0,  1.d0,  2.d0 ]
   call mf_save_and_disable_fpe( )
   val(5) = MF_NAN
   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 161 a ***"
   call msDisplay(mfFull(A), "A is sparse: mfFull(A)")
   call msDisplay(mfMax(A), "mfMax(A)")

   print "(/,A)", "*** test number 161 b ***"
   call msDisplay(mfMax(A,dim=1), "mfMax(A,dim=1)")

   print "(/,A)", "*** test number 161 c ***"
   call msDisplay(mfMax(A,dim=2), "mfMax(A,dim=2)")


   print "(/,A)", "*** test number 161 d ***"
   call msMax( mfOut(v,ind), A )
   call msDisplay( v, "max values", ind, "row indexes" )
   call msMax( mfOut(w,jnd), v )
   val_max = w
   j = jnd
   i = mfGet( ind, j )
   print "(1X,A,1PE10.3,A,I0,A,I0,A,/)", &
         "max value of A is: ", val_max, " at (", i, ",", j, ")"

   print "(/,A)", "*** test number 161 e ***"
   call msMax( mfOut(v,ind), A, dim=1 )
   call msDisplay( v, "max values", ind, "row indexes" )

   print "(/,A)", "*** test number 161 f ***"
   call msMax( mfOut(v,jnd), A, dim=2 )
   call msDisplay( v, "max values", jnd, "row indexes" )
   call msMax( mfOut(w,ind), v )
   val_max = w
   i = ind
   j = mfGet( jnd, i )
   print "(1X,A,1PE10.3,A,I0,A,I0,A,/)", &
         "max value of A is: ", val_max, " at (", i, ",", j, ")"

   call mf_restore_fpe( )

   ! mfMin -------------------------------------------------------------
   call print_separation("mfMin")

   call msSetAutoRowSorted(.false.)
   allocate( ir(3), jc(3), val(3) )
   ir(:) = [ 1, 2, 3 ]
   jc(:) = [ 1, 3, 2 ]
   val(:) = [ 2.0d0, -1.0d0, 3.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(mfFull(A), "A is sparse: mfFull(A)")
   deallocate( ir, jc, val )

   allocate( ir(5), jc(5), val(5) )
   ir(:) = [ 1, 3, 3, 2, 1 ]
   jc(:) = [ 1, 1, 2, 2, 3 ]
   val(:) = [ -1.0d0, 5.0d0, 3.0d0, 4.0d0, -2.0d0 ]

   B = mfSpImport(ir,jc,val)
   call msDisplay(mfFull(B), "B is sparse: mfFull(B)")
   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 162 ***"
   C = mfMin(A,B)
   call msDisplay(C,"mfMin(A,B)")
   call msDisplay(mfFull(C), "")

   call msSetAutoRowSorted(.true.)
   allocate( ir(3), jc(3), val(3) )
   ir(:) = [ 1, 2, 3 ]
   jc(:) = [ 1, 3, 2 ]
   val(:) = [ 2.0d0, -1.0d0, 3.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(mfFull(A), "A is sparse: mfFull(A)")
   deallocate( ir, jc, val )

   allocate( ir(5), jc(5), val(5) )
   ir(:) = [ 1, 3, 3, 2, 1 ]
   jc(:) = [ 1, 1, 2, 2, 3 ]
   val(:) = [ -1.0d0, 5.0d0, 3.0d0, 4.0d0, -2.0d0 ]

   B = mfSpImport(ir,jc,val)
   call msDisplay(mfFull(B), "B is sparse: mfFull(B)")
   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 163 ***"
   C = mfMin(A,B)
   call msDisplay(C,"mfMin(A,B)")
   call msDisplay(mfFull(C), "")

   allocate( ir(10), jc(10), val(10) )
   ir(:) = [ 1, 2, 3, 1, 2, 3, 2, 3, 1, 2 ]
   jc(:) = [ 1, 1, 1, 3, 3, 3, 4, 4, 5, 5 ]
   val(:) = [ -1.d0, -2.d0, -3.d0, -1.d0, 1.0d0, &
               1.d0, -1.d0, -2.d0,  1.d0,  2.d0 ]
   call mf_save_and_disable_fpe( )
   val(5) = MF_NAN
   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 164 a ***"
   call msDisplay(mfFull(A), "A is sparse: mfFull(A)")
   call msDisplay(mfMin(A), "mfMin(A)")

   print "(/,A)", "*** test number 164 b ***"
   call msDisplay(mfMin(A,dim=1), "mfMin(A,dim=1)")

   print "(/,A)", "*** test number 164 c ***"
   call msDisplay(mfMin(A,dim=2), "mfMin(A,dim=2)")

   print "(/,A)", "*** test number 164 d ***"
   call msMin( mfOut(v,ind), A )
   call msDisplay( v, "min values", ind, "row indexes" )
   call msMin( mfOut(w,jnd), v )
   val_min = w
   j = jnd
   i = mfGet( ind, j )
   print "(1X,A,1PE10.3,A,I0,A,I0,A,/)", &
         "min value of A is: ", val_min, " at (", i, ",", j, ")"

   print "(/,A)", "*** test number 164 e ***"
   call msMin( mfOut(v,ind), A, dim=1 )
   call msDisplay( v, "max values", ind, "row indexes" )

   print "(/,A)", "*** test number 164 f ***"
   call msMin( mfOut(v,jnd), A, dim=2 )
   call msDisplay( v, "max values", jnd, "row indexes" )
   call msMin( mfOut(w,ind), v )
   val_max = w
   i = ind
   j = mfGet( jnd, i )
   print "(1X,A,1PE10.3,A,I0,A,I0,A,/)", &
         "max value of A is: ", val_min, " at (", i, ",", j, ")"

   call mf_restore_fpe( )

   ! msLU (with mfMatFactor) ---------------------------------------------
   call print_separation("msLU (with mfMatFactor)")

   ! --- real case

   ! square system unsymmetric : UMFPACK

   ! same example as in doc of UMFPack-4
   allocate( ir(12), jc(12), val(12) )
   ir(:) = [ 1, 2, 1, 3, 5, 2, 3, 4, 5, 3, 2, 5 ]
   jc(:) = [ 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 5, 5 ]
   val(:) = [ 2.0d0, 3.0d0, 3.0d0, -1.0d0, 4.0d0, 4.0d0, -3.0d0,        &
              1.0d0, 2.0d0, 2.0d0,  6.0d0, 1.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val) [ex. from doc of UMFPack-4]")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   ! LU factorization without copying data in mfArrays
   call msLU( mfOut(factor), A )

   print "(/,A)", "*** test number 165 ***"
   b = mfMul( A, .t. mf( [ 1, 2, 3, 4, 5 ] ) )
   call msDisplay(b, "b [RHS]")
   x = mfLDiv( factor, b )
   call msDisplay(x, "x [sol.]")

   print "(/,A)", "*** test number 166 ***"
   b = mfMul( A, mfReshape( mf([(i,i=1,10)]), 5, 2 ) )
   call msDisplay(b, "b [RHS]")
   x = mfLDiv( factor, b )
   call msDisplay(x, "x [sol.]")

   print "(/,A)", "*** test number 167 ***"
   b = mfMul( mf( [ 1, 2, 3, 4, 5 ] ), A )
   call msDisplay(b, "b [RHS]")
   x = mfRDiv( b, factor )
   call msDisplay(x, "x [sol.]")

   print "(/,A)", "*** test number 168 ***"
   b = mfMul( .t.mfReshape( mf([(i,i=1,10)]), 5, 2 ), A )
   call msDisplay(b, "b [RHS]")
   x = mfRDiv( b, factor )
   call msDisplay(x, "x [sol.]")

   call msFreeMatFactor( factor )

   ! --- complex/complex case
   A = A*MF_I

   ! LU factorization without copying data in mfArrays
   call msLU( mfOut(factor), A )

   print "(/,A)", "*** test number 169 ***"
   b = mfMul( A, .t. mf( [ 1, 2, 3, 4, 5 ] ) )
   call msDisplay(b, "b [RHS]")
   x = mfLDiv( factor, b )
   call msDisplay(x, "x [sol.]")

   print "(/,A)", "*** test number 170 ***"
   b = mfMul( A, mfReshape( mf([(i,i=1,10)]), 5, 2 ) )
   call msDisplay(b, "b [RHS]")
   x = mfLDiv( factor, b )
   call msDisplay(x, "x [sol.]")

   print "(/,A)", "*** test number 171 ***"
   b = mfMul( mf( [ 1, 2, 3, 4, 5 ] ), A )
   call msDisplay(b, "b [RHS]")
   x = mfRDiv( b, factor )
   call msDisplay(x, "x [sol.]")
   call check_small( mfNormEst(mfMul(x,A)-b), "|x*A-b|", 1.0d2*MF_EPS )

   print "(/,A)", "*** test number 172 ***"
   b = mfMul( .t.mfReshape( mf([(i,i=1,10)]), 5, 2 ), A )
   call msDisplay(b, "b [RHS]")
   x = mfRDiv( b, factor )
   call msDisplay(x, "x [sol.]")
   call check_small( mfNormEst(mfMul(x,A)-b), "|x*A-b|", 1.0d2*MF_EPS )

   ! --- complex/real case

   print "(/,A)", "*** test number 173 ***"
   b = mfReal( mfMul( A, .t. mf( [ 1, 2, 3, 4, 5 ] )*MF_I ) )
   call msDisplay(b, "b [RHS]")
   x = mfLDiv( factor, b )
   call msDisplay(x, "x [sol.]")

   print "(/,A)", "*** test number 174 ***"
   b = mfReal( mfMul( A, mfReshape( mf([(i,i=1,10)]), 5, 2 )*MF_I ) )
   call msDisplay(b, "b [RHS]")
   x = mfLDiv( factor, b )
   call msDisplay(x, "x [sol.]")

   print "(/,A)", "*** test number 175 ***"
   b = mfReal( mfMul( mf( [ 1, 2, 3, 4, 5 ] )*MF_I, A ) )
   call msDisplay(b, "b [RHS]")
   x = mfRDiv( b, factor )
   call msDisplay(x, "x [sol.]")
   call check_small( mfNormEst(mfMul(x,A)-b), "|x*A-b|", 1.0d2*MF_EPS )

   print "(/,A)", "*** test number 176 ***"
   b = mfReal( mfMul( .t.mfReshape( mf([(i,i=1,10)]), 5, 2 )*MF_I, A ) )
   call msDisplay(b, "b [RHS]")
   x = mfRDiv( b, factor )
   call msDisplay(x, "x [sol.]")
   call check_small( mfNormEst(mfMul(x,A)-b), "|x*A-b|", 1.0d2*MF_EPS )

   call msFreeMatFactor( factor )

   ! msLU --------------------------------------------------------------
   call print_separation("msLU")

   ! --- real case

   ! square system (unsymmetric)

   ! same example as in doc of UMFPack-4
   allocate( ir(12), jc(12), val(12) )
   ir(:) = [ 1, 2, 1, 3, 5, 2, 3, 4, 5, 3, 2, 5 ]
   jc(:) = [ 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 5, 5 ]
   val(:) = [ 2.0d0, 3.0d0, 3.0d0, -1.0d0, 4.0d0, 4.0d0, -3.0d0,        &
              1.0d0, 2.0d0, 2.0d0,  6.0d0, 1.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val) [ex. from doc of UMFPack-4]")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 177 ***"
   call msLU( mfOut(L,U), A )
   call msDisplay( L, "L" )
   call msDisplay( U, "U" )

   print "(/,A)", "*** test number 178 ***"
   call msLU( mfOut(L,U,p,q,r), A )
   call msDisplay( L, "L", mfFull(L), "" )
   call msDisplay( U, "U", mfFull(U), "" )
   call msDisplay( p, "p", q, "q", r, "r" )

   x = mfMul(L,U)
   call msDisplay( mfFull(x), "L*U" )
   y = mfRowScale(A,r)
   call msRowPerm(y,p)
   call msColPerm(y,q)
   call msDisplay( mfFull(y), "p*r*A*q" )
   call msDisplay( mfNorm(x-y), "|L*U - p*r*A*q|" )

   ! non-square system : m < n

   allocate( ir(10), jc(10), val(10) )
   ir(:) = [ 1, 2, 4, 1, 2, 3, 4, 2, 1, 4 ]
   jc(:) = [ 1, 2, 2, 3, 3, 3, 3, 4, 5, 5 ]
   val(:) = [ 3.0d0, -1.0d0, 4.0d0, 4.0d0, -3.0d0,                      &
              1.0d0, 2.0d0, 2.0d0,  6.0d0, 1.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 179 ***"
   call msLU( mfOut(L,U), A )

   print "(/,A)", "*** test number 180 ***"
   call msLU( mfOut(L,U,p,q,r), A )
   call msDisplay( L, "L", mfFull(L), "" )
   call msDisplay( U, "U", mfFull(U), "" )
   call msDisplay( p, "p", q, "q" )

   x = mfMul(L,U)
   call msDisplay( mfFull(x), "L*U" )
   y = mfRowScale(A,r)
   call msRowPerm(y,p)
   call msColPerm(y,q)
   call msDisplay( mfFull(y), "p*r*A*q" )
   call msDisplay( mfNorm(x-y,1), "|L*U - p*r*A*q|" )

   ! non-square system : m > n

   allocate( ir(10), jc(10), val(10) )
   ir(:) = [ 1, 2, 1, 3, 5, 2, 3, 4, 5, 3 ]
   jc(:) = [ 1, 1, 2, 2, 2, 3, 3, 3, 3, 4 ]
   val(:) = [ 2.0d0, 3.0d0, 3.0d0, -1.0d0, 4.0d0, 4.0d0, -3.0d0,        &
              1.0d0, 2.0d0, 2.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 181 ***"
   call msLU( mfOut(L,U), A )

   print "(/,A)", "*** test number 182 ***"
   call msLU( mfOut(L,U,p,q,r), A )
   call msDisplay( L, "L", mfFull(L), "" )
   call msDisplay( U, "U", mfFull(U), "" )
   call msDisplay( p, "p", q, "q" )

   x = mfMul(L,U)
   call msDisplay( mfFull(x), "L*U" )
   y = mfRowScale(A,r)
   call msRowPerm(y,p)
   call msColPerm(y,q)
   call msDisplay( mfFull(y), "p*r*A*q" )
   call msDisplay( mfNorm(x-y), "|L*U - p*r*A*q|" )

   !-- complex case

   ! square system (unsymmetric)

   allocate( ir(12), jc(12), val(12) )
   ir(:) = [ 1, 2, 1, 3, 5, 2, 3, 4, 5, 3, 2, 5 ]
   jc(:) = [ 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 5, 5 ]
   val(:) = [ 2.0d0, 3.0d0, 3.0d0, -1.0d0, 4.0d0, 4.0d0, -3.0d0,        &
              1.0d0, 2.0d0, 2.0d0,  6.0d0, 1.0d0 ]

   A = mfSpImport(ir,jc,val)*MF_I + mfSpEye(5,5)
   call msDisplay(A, "A = mfSpImport(ir,jc,val) [ex. from doc of UMFPack-4]")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 183 ***"
   call msLU( mfOut(L,U), A )

   print "(/,A)", "*** test number 184 ***"
   call msLU( mfOut(L,U,p,q,r), A )
   call msDisplay( L, "L", mfFull(L), "" )
   call msDisplay( U, "U", mfFull(U), "" )
   call msDisplay( p, "p", q, "q" )

   x = mfMul(L,U)
   call msDisplay( mfFull(x), "L*U" )
   y = mfRowScale(A,r)
   call msRowPerm(y,p)
   call msColPerm(y,q)
   call msDisplay( mfFull(y), "P*R*A*Q" )
   call check_small( mfNorm(x-y), "|L*U - P*R*A*Q|",                    &
                     1.0d2*MF_EPS )

   ! non-square system : m < n

   allocate( ir(10), jc(10), val(10) )
   ir(:) = [ 1, 2, 4, 1, 2, 3, 4, 2, 1, 4 ]
   jc(:) = [ 1, 2, 2, 3, 3, 3, 3, 4, 5, 5 ]
   val(:) = [ 3.0d0, -1.0d0, 4.0d0, 4.0d0, -3.0d0,                      &
              1.0d0, 2.0d0, 2.0d0,  6.0d0, 1.0d0 ]

   A = mfSpImport(ir,jc,val)*MF_I + mfSpEye(4,5)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 185 ***"
   call msLU( mfOut(L,U), A )

   print "(/,A)", "*** test number 186 ***"
   call msLU( mfOut(L,U,p,q,r), A )
   call msDisplay( L, "L", mfFull(L), "" )
   call msDisplay( U, "U", mfFull(U), "" )
   call msDisplay( p, "p", q, "q" )

   x = mfMul(L,U)
   call msDisplay( mfFull(x), "L*U" )
   y = mfRowScale(A,r)
   call msRowPerm(y,p)
   call msColPerm(y,q)
   call msDisplay( mfFull(y), "p*r*A*q" )
   call check_small( mfNorm(x-y,1), "|L*U - p*r*A*q|",                    &
                     1.0d2*MF_EPS )

   ! non-square system : m > n

   allocate( ir(10), jc(10), val(10) )
   ir(:) = [ 1, 2, 1, 3, 5, 2, 3, 4, 5, 3 ]
   jc(:) = [ 1, 1, 2, 2, 2, 3, 3, 3, 3, 4 ]
   val(:) = [ 2.0d0, 3.0d0, 3.0d0, -1.0d0, 4.0d0, 4.0d0, -3.0d0,        &
              1.0d0, 2.0d0, 2.0d0 ]

   A = mfSpImport(ir,jc,val)*MF_I + mfSpEye(5,4)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 187 ***"
   call msLU( mfOut(L,U), A )

   print "(/,A)", "*** test number 188 ***"
   call msLU( mfOut(L,U,p,q,r), A )
   call msDisplay( L, "L", mfFull(L), "" )
   call msDisplay( U, "U", mfFull(U), "" )
   call msDisplay( p, "p", q, "q" )

   x = mfMul(L,U)
   call msDisplay( mfFull(x), "L*U" )
   y = mfRowScale(A,r)
   call msRowPerm(y,p)
   call msColPerm(y,q)
   call msDisplay( mfFull(y), "p*r*A*q" )
   call check_small( mfNorm(x-y), "|L*U - p*r*A*q|",                    &
                     1.0d2*MF_EPS )

   ! msChol (with mfMatFactor) ------------------------------------------
   call print_separation("msChol (with mfMatFactor)")

   !-- real square (symm. pos. def.)

   allocate( ir(10), jc(10), val(10) )
   ir(:) = [ 1, 2, 3, 4, 1, 2, 1, 3, 1, 4 ]
   jc(:) = [ 1, 1, 1, 1, 2, 2, 3, 3, 4, 4 ]
   val(:) = [ 2.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0, 2.0d0, 1.0d0,          &
              2.0d0, 1.0d0, 2.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   bool = mfIsSymm(A)
   print *, "Is A symmetric? ", bool
   bool = mfIsPosDef(A)
   print *, "Is A positive definite? ", bool
   print "()"

   ! Cholesky factorization without copying data in mfArrays
   call msChol( mfOut(factor), A )

   print "(/,A)", "*** test number 189 ***"
   b = mfMul( A, .t. mf( [ 1, 2, 3, 4 ] ) )
   call msDisplay(b, "b [RHS]")
   x = mfLDiv( factor, b )
   call msDisplay(x, "x [sol.]")

   print "(/,A)", "*** test number 190 ***"
   b = mfMul( A, mfReshape( mf([(i,i=1,8)]), 4, 2 ) )
   call msDisplay(b, "b [RHS]")
   x = mfLDiv( factor, b )
   call msDisplay(x, "x [sol.]")

   print "(/,A)", "*** test number 191 ***"
   b = mfMul( mf( [ 1, 2, 3, 4 ] ), A )
   call msDisplay(b, "b [RHS]")
   x = mfRDiv( b, factor )
   call msDisplay(x, "x [sol.]")

   print "(/,A)", "*** test number 192 ***"
   b = mfMul( .t.mfReshape( mf([(i,i=1,8)]), 4, 2 ), A )
   call msDisplay(b, "b [RHS]")
   x = mfRDiv( b, factor )
   call msDisplay(x, "x [sol.]")

   call msFreeMatFactor( factor )

   ! --- complex/complex case
   allocate( ir(10), jc(10), zval(10) )
   ir(:) = [ 1, 2, 3, 4, 1, 2, 1, 3, 1, 4 ]
   jc(:) = [ 1, 1, 1, 1, 2, 2, 3, 3, 4, 4 ]
   zval(:) = [ (2.0d0,0.0d0), (0.0d0,-1.0d0), (0.0d0,-1.0d0),           &
               (0.0d0,-1.0d0), (0.0d0,1.0d0), (2.0d0,0.0d0),            &
               (0.0d0,1.0d0), (2.0d0,0.0d0), (0.0d0,1.0d0),             &
               (2.0d0,0.0d0) ]

   A = mfSpImport(ir,jc,zval)
   deallocate( ir, jc, zval )

   ! Cholesky factorization without copying data in mfArrays
   call msChol( mfOut(factor), A )

   print "(/,A)", "*** test number 193 ***"
   b = mfMul( A, .t. mf( [ 1, 2, 3, 4 ] ) )
   call msDisplay(b, "b [RHS]")
   x = mfLDiv( factor, b )
   call msDisplay(x, "x [sol.]")

   print "(/,A)", "*** test number 194 ***"
   b = mfMul( A, mfReshape( mf([(i,i=1,8)]), 4, 2 ) )
   call msDisplay(b, "b [RHS]")
   x = mfLDiv( factor, b )
   call msDisplay(x, "x [sol.]")

   print "(/,A)", "*** test number 195 ***"
   b = mfOnes(1,4)
   call msDisplay(b, "b [RHS]")
   x = mfRDiv( b, factor )
   call msDisplay(x, "x [sol.]")
   call check_small( mfNormEst(mfMul(x,A)-b), "|x*A-b|", 1.0d2*MF_EPS )

   print "(/,A)", "*** test number 196 ***"
   b = mfOnes(1,4) .vc. 2*mfOnes(1,4)
   call msDisplay(b, "b [RHS]")
   x = mfRDiv( b, factor )
   call msDisplay(x, "x [sol.]")
   call check_small( mfNormEst(mfMul(x,A)-b), "|x*A-b|", 1.0d2*MF_EPS )

   ! --- complex/real case

   print "(/,A)", "*** test number 197 ***"
   b = mfOnes(4,1)
   call msDisplay(b, "b [RHS]")
   x = mfLDiv( factor, b )
   call msDisplay(x, "x [sol.]")

   print "(/,A)", "*** test number 198 ***"
   b = mfOnes(4,1) .hc. 2*mfOnes(4,1)
   call msDisplay(b, "b [RHS]")
   x = mfLDiv( factor, b )
   call msDisplay(x, "x [sol.]")

   print "(/,A)", "*** test number 199 ***"
   b = mfOnes(1,4)
   call msDisplay(b, "b [RHS]")
   x = mfRDiv( b, factor )
   call msDisplay(x, "x [sol.]")
   call check_small( mfNormEst(mfMul(x,A)-b), "|x*A-b|", 1.0d2*MF_EPS )

   print "(/,A)", "*** test number 200 ***"
   b = mfOnes(1,4) .vc. 2*mfOnes(1,4)
   call msDisplay(b, "b [RHS]")
   x = mfRDiv( b, factor )
   call msDisplay(x, "x [sol.]")
   call check_small( mfNormEst(mfMul(x,A)-b), "|x*A-b|", 1.0d2*MF_EPS )

   !-- real square (symm. pos. def.)

   allocate( ir(10), jc(10), val(10) )
   ir(:) = [ 1, 2, 3, 4, 1, 2, 1, 3, 1, 4 ]
   jc(:) = [ 1, 1, 1, 1, 2, 2, 3, 3, 4, 4 ]
   val(:) = [ 2.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0, 2.0d0, 1.0d0,          &
              2.0d0, 1.0d0, 2.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   bool = mfIsSymm(A)
   print *, "Is A symmetric? ", bool
   bool = mfIsPosDef(A)
   print *, "Is A positive definite? ", bool
   print "()"

   ! Cholesky factorization without copying data in mfArrays
   call msChol( mfOut(factor), A )

   print "(/,A)", "*** test number 201 ***"
   !-- sparse RHS
   allocate( ir(2), jc(2), val(2) )
   ir(:) = [ 1, 4 ]
   jc(:) = [ 1, 1 ]
   val(:) = [ 1.0d0, 2.0d0 ]
   b = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   call msDisplay(b, "b [RHS] = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(b), "")
   x = mfLDiv( factor, b )
   call msDisplay(mfFull(x), "x [sol.]")
   call msDisplay(mfNorm(mfMul(A,x)-b,1), "| A*x - b |")

   b = .t. b

   print "(/,A)", "*** test number 202 ***"
   x = mfRDiv( b, factor )
   call msDisplay(mfFull(x), "x [sol.]")
   call msDisplay(mfNorm(mfMul(x,A)-b,1), "| x*A - b |")

   print "(/,A)", "*** test number 203 ***"
   !-- sparse multiple RHS
   allocate( ir(4), jc(4), val(4) )
   ir(:) = [ 1, 3, 2, 4 ]
   jc(:) = [ 1, 1, 2, 2 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0 ]
   b = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   call msDisplay(b, "b [RHS] = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(b), "")
   x = mfLDiv( factor, b )
   call msDisplay(mfFull(x), "x [sol.]")
   call msDisplay(mfNorm(mfMul(A,x)-b,1), "| A*x - b |")

   b = .t. b

   print "(/,A)", "*** test number 204 ***"
   x = mfRDiv( b, factor )
   call msDisplay(mfFull(x), "x [sol.]")
   call msDisplay(mfNorm(mfMul(x,A)-b,1), "| x*A - b |")

   call msFreeMatFactor( factor )

   !-- complex square (herm. pos. def.)

   allocate( ir(10), jc(10), zval(10) )
   ir(:) = [ 1, 2, 3, 4, 1, 2, 1, 3, 1, 4 ]
   jc(:) = [ 1, 1, 1, 1, 2, 2, 3, 3, 4, 4 ]
   zval(:) = [ (2.0d0,0.0d0), (0.0d0,-1.0d0), (0.0d0,-1.0d0),           &
               (0.0d0,-1.0d0), (0.0d0,1.0d0), (2.0d0,0.0d0),            &
               (0.0d0,1.0d0), (2.0d0,0.0d0), (0.0d0,1.0d0),             &
               (2.0d0,0.0d0) ]

   A = mfSpImport(ir,jc,zval)
   print "(/,A)", "*** test number 205 ***"
   call msDisplay(A, "A = mfSpImport(ir,jc,zval)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, zval )

   bool = mfIsSymm(A)
   print *, "Is A hermitian? ", bool
   bool = mfIsPosDef(A)
   print *, "Is A positive definite? ", bool
   print "()"

   call msChol( mfOut(factor), A )

   b = mfMul( A, .t. mf( [ 1, 2, 3, 4 ] ) )
   call msDisplay(b, "b [RHS]")

   x = mfLDiv( factor, b )
   call msDisplay(x, "x [sol.]")

   !-- multiple RHS
   b = b .hc. mfMul( A, .t. mf( [ 6, 7, 8, 9 ] ) )
   call msDisplay(b, "b [RHS]")

   x = mfLDiv( factor, b )
   call msDisplay(x, "x [sol.]")

   call msFreeMatFactor( factor )

   ! msCholSpSymb, msCholSpNum -----------------------------------------
   call print_separation("msCholSpSymb, msCholSpNum")

   !-- real square (symm. pos. def.)

   allocate( ir(10), jc(10), val(10) )
   ir(:) = [ 1, 2, 3, 4, 1, 2, 1, 3, 1, 4 ]
   jc(:) = [ 1, 1, 1, 1, 2, 2, 3, 3, 4, 4 ]
   val(:) = [ 2.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0, 2.0d0, 1.0d0,          &
              2.0d0, 1.0d0, 2.0d0 ]

   A = mfSpImport(ir,jc,val)
   print "(/,A)", "*** test number 206 ***"
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   bool = mfIsSymm(A)
   print *, "Is A symmetric? ", bool
   bool = mfIsPosDef(A)
   print *, "Is A positive definite? ", bool
   print "()"

   call msCholSpSymb( factor, A )

   call msCholSpNum( factor, A )

   b = mfMul( A, .t. mf( [ 1, 2, 3, 4 ] ) )
   call msDisplay(b, "b [RHS]")

   x = mfLDiv( factor, b )
   call msDisplay(x, "x [sol.]")

   !-- complex square (herm. pos. def.)

   allocate( ir(10), jc(10), zval(10) )
   ir(:) = [ 1, 2, 3, 4, 1, 2, 1, 3, 1, 4 ]
   jc(:) = [ 1, 1, 1, 1, 2, 2, 3, 3, 4, 4 ]
   zval(:) = [ (2.0d0,0.0d0), (0.0d0,-1.0d0), (0.0d0,-1.0d0),           &
               (0.0d0,-1.0d0), (0.0d0,1.0d0), (2.0d0,0.0d0),            &
               (0.0d0,1.0d0), (2.0d0,0.0d0), (0.0d0,1.0d0),             &
               (2.0d0,0.0d0) ]

   A = mfSpImport(ir,jc,zval)
   print "(/,A)", "*** test number 207 ***"
   call msDisplay(A, "A = mfSpImport(ir,jc,zval)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, zval )

   bool = mfIsSymm(A)
   print *, "Is A hermitian? ", bool
   bool = mfIsPosDef(A)
   print *, "Is A positive definite? ", bool
   print "()"

   call msCholSpSymb( factor, A )

   call msCholSpNum( factor, A )

   b = mfMul( A, .t. mf( [ 1, 2, 3, 4 ] ) )
   call msDisplay(b, "b [RHS]")

   x = mfLDiv( factor, b )
   call msDisplay(x, "x [sol.]")

   ! msChol ------------------------------------------------------------
   call print_separation("msChol")

   !-- real square (symm. pos. def.)

   allocate( ir(10), jc(10), val(10) )
   ir(:) = [ 1, 2, 3, 4, 1, 2, 1, 3, 1, 4 ]
   jc(:) = [ 1, 1, 1, 1, 2, 2, 3, 3, 4, 4 ]
   val(:) = [ 2.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0, 2.0d0, 1.0d0,          &
              2.0d0, 1.0d0, 2.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   bool = mfIsSymm(A)
   print *, "Is A symmetric? ", bool
   bool = mfIsPosDef(A)
   print *, "Is A positive definite? ", bool
   print "()"

   print "(/,A)", "*** test number 208 ***"
   call msChol( mfOut(L,p), A )
   print *, "call msChol( mfOut(L,p), A )"
   call msDisplay(L, "L")
   call msDisplay(mfFull(L), "")

   B = mfMul(L,.t.L)
   call msDisplay(mfFull(B), "L*L'")
   C = mfColPerm(A,p)
   call msRowPerm(C,p)
   call msDisplay(mfFull(C), "p'*A*p")
   call check_small( mfNorm(B-C), "| L*L' - p'*A*p |",                  &
                     1.0d2*MF_EPS )

   !-- complex square (herm. pos. def.)

   allocate( ir(10), jc(10), val(10) )
   ir(:) = [ 1, 2, 3, 4, 1, 2, 1, 3, 1, 4 ]
   jc(:) = [ 1, 1, 1, 1, 2, 2, 3, 3, 4, 4 ]
   val(:) = [ 2.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0, 2.0d0, 1.0d0,          &
              2.0d0, 1.0d0, 2.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )
   A = A*( 1.0d0 + MF_I )
   A = mfTriu(A)
   A = A + .h. A
   call msDisplay(mfFull(A), "")

   bool = mfIsSymm(A)
   print *, "Is A hermitian? ", bool
   bool = mfIsPosDef(A)
   print *, "Is A positive definite? ", bool
   print "()"

   print "(/,A)", "*** test number 209 ***"
   call msChol( mfOut(L,P), A )
   print *, "call msChol( mfOut(L,P), A )"
   call msDisplay(L, "L")
   call msDisplay(mfFull(L), "")

   B = mfMul(L,.h.L)
   call msDisplay(mfFull(B), "L*L'")
   C = mfColPerm(A,p)
   call msRowPerm(C,p)
   call msDisplay(mfFull(C), "P*A*P")
   call check_small( mfNorm(B-C), "| L*L' - P'*A*P |",                  &
                     1.0d2*MF_EPS )

   ! mfIsSymm ----------------------------------------------------------
   call print_separation("mfIsSymm")

   !-- real square

   allocate( ir(10), jc(10), val(10) )
   ir(:) = [ 1, 2, 3, 4, 1, 2, 1, 3, 1, 4 ]
   jc(:) = [ 1, 1, 1, 1, 2, 2, 3, 3, 4, 4 ]
   val(:) = [ 2.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0, 2.0d0, 1.0d0,          &
              2.0d0, 1.0d0, 2.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 210 ***"
   bool = mfIsSymm(A)
   print *, "Is A symmetric? ", bool

   allocate( ir(10), jc(10), val(10) )
   ir(:) = [ 1, 2, 3, 4, 1, 2, 1, 3, 1, 4 ]
   jc(:) = [ 1, 1, 1, 1, 2, 2, 3, 3, 4, 4 ]
   val(:) = [ 2.0d0, 1.0d0, 1.0d0, 2.0d0, 1.0d0, 2.0d0, 1.0d0,          &
              2.0d0, 1.0d0, 2.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 211 ***"
   bool = mfIsSymm(A)
   print *, "Is A symmetric? ", bool
   print "(/,A)", "*** test number 212 ***"
   bool = mfIsSymm(A, "pattern" )
   print *, "Has A a symmetric pattern? ", bool
   print "()"

   ! mfIsPosDef --------------------------------------------------------
   call print_separation("mfIsPosDef")

   !-- real square

   allocate( ir(10), jc(10), val(10) )
   ir(:) = [ 1, 2, 3, 4, 1, 2, 1, 3, 1, 4 ]
   jc(:) = [ 1, 1, 1, 1, 2, 2, 3, 3, 4, 4 ]
   val(:) = [ 2.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0, 2.0d0, 1.0d0,          &
              2.0d0, 1.0d0, 2.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 213 ***"
   bool = mfIsPosDef(A)
   print *, "Is A positive definite? ", bool ! TRUE

   allocate( ir(10), jc(10), val(10) )
   ir(:) = [ 1, 2, 3, 4, 1, 2, 1, 3, 1, 4 ]
   jc(:) = [ 1, 1, 1, 1, 2, 2, 3, 3, 4, 4 ]
   val(:) = [ 2.0d0, 1.0d0, 1.0d0, 2.0d0, 1.0d0, 2.0d0, 1.0d0,          &
              2.0d0, 1.0d0, 2.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   print "(/,A)", "*** test number 214 ***"
   bool = mfIsPosDef(A)
   print *, "Is A positive definite? ", bool ! FALSE

   !-- complex square

   allocate( ir(10), jc(10), val(10) )
   ir(:) = [ 1, 2, 3, 4, 1, 2, 1, 3, 1, 4 ]
   jc(:) = [ 1, 1, 1, 1, 2, 2, 3, 3, 4, 4 ]
   val(:) = [ 2.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0, 2.0d0, 1.0d0,          &
              2.0d0, 1.0d0, 2.0d0 ]

   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   A = A + mfSpEye(4,4)*MF_I
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   print "(/,A)", "*** test number 215 ***"
   bool = mfIsPosDef(A)
   print *, "Is A positive definite? ", bool ! TRUE
   print "()"

   ! msLDLT ------------------------------------------------------------
   call print_separation("msLDLT")

   !-- real square

   allocate( ir(10), jc(10), val(10) )
   ir(:) = [ 1, 2, 1, 2, 3, 4, 2, 3, 2, 4 ]
   jc(:) = [ 1, 1, 2, 2, 2, 2, 3, 3, 4, 4 ]
   val(:) = [ 2.0d0, 1.0d0, 1.0d0, 2.0d0, 1.0d0, 2.0d0, 1.0d0,          &
             -5.0d0, 2.0d0, 2.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   bool = mfIsSymm(A)
   print *, "Is A symmetric? ", bool

   bool = mfIsPosDef(A)
   print *, "Is A positive definite? ", bool

   print "(/,A)", "*** test number 216 ***"
   call msLDLT( mfOut(L,D,P), A )
   print *, "call msLDLT( mfOut(L,D,P), A )"
   call msDisplay(L, "L")
   call msDisplay(mfFull(L), "")
   call msDisplay(D, "D")
   call msDisplay(P, "P")
   call msDisplay(mfFull(P), "")

   B = mfMul(mfMul(L,D),.t.L)
   call msDisplay(mfFull(B), "L*D*L'")
   C = mfMul(mfMul(.t.P,A),P)
   call msDisplay(mfFull(C), "P'*A*P")
   call msDisplay(mfNorm(B-C),"| L*D*L' - P'*A*P |")

   ! mfIsDiagDomCol, mfIsStrictDiagDomCol ------------------------------
   call print_separation("mfIsDiagDomCol, mfIsStrictDiagDomCol")

   !-- real square

   allocate( ir(10), jc(10), val(10) )
   ir(:) = [ 1, 2, 3, 4, 1, 2, 1, 3, 1, 4 ]
   jc(:) = [ 1, 1, 1, 1, 2, 2, 3, 3, 4, 4 ]
   val(:) = [ 2.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0, 2.0d0, 1.0d0,          &
              2.0d0, 1.0d0, 2.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   bool = mfIsPosDef(A)
   print *, "Is A positive definite? ", bool ! TRUE
   print "(/,A)", "*** test number 217 ***"
   bool = mfIsDiagDomCol(A)
   print *, "Is A diag. dominant by cols? ", bool ! FALSE
   print "(/,A)", "*** test number 218 ***"
   bool = mfIsStrictDiagDomCol(A)
   print *, "Is A strictly diag. dominant by cols? ", bool ! FALSE

   allocate( ir(10), jc(10), val(10) )
   ir(:) = [ 1, 2, 3, 4, 1, 2, 1, 3, 1, 4 ]
   jc(:) = [ 1, 1, 1, 1, 2, 2, 3, 3, 4, 4 ]
   val(:) = [ 2.0d0, 0.66d0, 0.66d0, 0.66d0, 0.66d0, 2.0d0, 0.66d0,     &
              2.0d0, 0.66d0, 2.0d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   deallocate( ir, jc, val )

   bool = mfIsPosDef(A)
   print *, "Is A positive definite? ", bool ! FALSE
   print "(/,A)", "*** test number 219 ***"
   bool = mfIsDiagDomCol(A)
   print *, "Is A diag. dominant by cols? ", bool ! FALSE
   print "(/,A)", "*** test number 220 ***"
   bool = mfIsStrictDiagDomCol(A)
   print *, "Is A strictly diag. dominant by cols? ", bool ! FALSE
   print "()"

   ! mfAbs -------------------------------------------------------------
   call print_separation("mfAbs")

   !-- real
   allocate( ir(5), jc(5), val(5) )
   ir(:) = [ 1, 2, 3, 4, 2 ]
   jc(:) = [ 1, 4, 1, 1, 2 ]
   val(:) = [ -1.0d0, 2.0d0, -3.0d0, 4.0d0, -5.0d0 ]

   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   print "(/,A)", "*** test number 221 ***"
   call msDisplay(mfAbs(A), "mfAbs(A)")

   !-- complex
   allocate( ir(5), jc(5), zval(5) )
   ir(:) = [ 1, 2, 3, 4, 2 ]
   jc(:) = [ 1, 4, 1, 1, 2 ]
   zval(:) = [ (0.0d0,1.0d0), (1.0d0,0.0d0), (0.0d0,-1.0d0),             &
               (-1.0d0,0.0d0), (1.0d0,1.0d0) ]

   A = mfSpImport(ir,jc,zval)
   deallocate( ir, jc, zval )
   call msDisplay(A, "A = mfSpImport(ir,jc,zval)")
   print "(/,A)", "*** test number 222 ***"
   call msDisplay(mfAbs(A), "mfAbs(A)")

   ! mfAngle -----------------------------------------------------------
   call print_separation("mfAngle")

   !-- real
   allocate( ir(5), jc(5), val(5) )
   ir(:) = [ 1, 2, 3, 4, 2 ]
   jc(:) = [ 1, 4, 1, 1, 2 ]
   val(:) = [ -1.0d0, 2.0d0, -3.0d0, 4.0d0, -5.0d0 ]

   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   print "(/,A)", "*** test number 223 ***"
   call msDisplay(mfAngle(A), "mfAngle(A)")

   !-- complex
   allocate( ir(5), jc(5), zval(5) )
   ir(:) = [ 1, 2, 3, 4, 2 ]
   jc(:) = [ 1, 4, 1, 1, 2 ]
   zval(:) = [ (0.0d0,1.0d0), (1.0d0,0.0d0), (0.0d0,-1.0d0),             &
               (-1.0d0,0.0d0), (1.0d0,1.0d0) ]

   A = mfSpImport(ir,jc,zval)
   deallocate( ir, jc, zval )
   call msDisplay(A, "A = mfSpImport(ir,jc,zval)")
   print "(/,A)", "*** test number 224 ***"
   call msDisplay(mfAngle(A), "mfAngle(A)")

   ! mfComplex ---------------------------------------------------------
   call print_separation("mfComplex")

   !-- one arg (real)
   allocate( ir(5), jc(5), val(5) )
   ir(:) = [ 1, 2, 3, 4, 2 ]
   jc(:) = [ 1, 4, 1, 1, 2 ]
   val(:) = [ -1.0d0, 2.0d0, -3.0d0, 4.0d0, -5.0d0 ]

   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   print "(/,A)", "*** test number 225 ***"
   call msDisplay(mfComplex(A), "mfComplex(A)")

   !-- two args (both real, same sparse structure)
   allocate( ir(5), jc(5), val(5) )
   ir(:) = [ 1, 2, 3, 4, 2 ]
   jc(:) = [ 1, 4, 1, 1, 2 ]
   val(:) = [ -1.0d0, 2.0d0, -3.0d0, 4.0d0, -5.0d0 ]

   A = mfSpImport(ir,jc,val)
   val(:) = [ 1.0d0, 1.0d0, 0.5d0, -1.0d0, -1.0d0 ]

   B = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   call msDisplay(B, "B = mfSpImport(ir,jc,val)")

   print "(/,A)", "*** test number 226 ***"
   call msDisplay(mfComplex(A,B), "mfComplex(A,B)")

   !-- two args (both real, different sparse structure)
   allocate( ir(5), jc(5), val(5) )
   ir(:) = [ 1, 2, 3, 4, 2 ]
   jc(:) = [ 1, 4, 1, 1, 2 ]
   val(:) = [ -1.0d0, 2.0d0, -3.0d0, 4.0d0, -5.0d0 ]

   A = mfSpImport(ir,jc,val)
   val(:) = [ 1.0d0, 0.0d0, 0.0d0, 0.0d0, -1.0d0 ]

   B = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   call msDisplay(B, "B = mfSpImport(ir,jc,val)")

   print "(/,A)", "*** test number 227 ***"
   call msDisplay(mfComplex(A,B), "mfComplex(A,B)")

   ! mfConj ------------------------------------------------------------
   call print_separation("mfConj")

   !-- real
   allocate( ir(5), jc(5), val(5) )
   ir(:) = [ 1, 2, 3, 4, 2 ]
   jc(:) = [ 1, 4, 1, 1, 2 ]
   val(:) = [ -1.0d0, 2.0d0, -3.0d0, 4.0d0, -5.0d0 ]

   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   print "(/,A)", "*** test number 228 ***"
   call msDisplay(mfConj(A), "mfConj(A)")

   !-- complex
   allocate( ir(5), jc(5), zval(5) )
   ir(:) = [ 1, 2, 3, 4, 2 ]
   jc(:) = [ 1, 4, 1, 1, 2 ]
   zval(:) = [ (0.0d0,1.0d0), (1.0d0,0.0d0), (0.0d0,-1.0d0),             &
               (-1.0d0,0.0d0), (1.0d0,1.0d0) ]

   A = mfSpImport(ir,jc,zval)
   deallocate( ir, jc, zval )
   call msDisplay(A, "A = mfSpImport(ir,jc,zval)")
   print "(/,A)", "*** test number 229 ***"
   call msDisplay(mfConj(A), "mfConj(A)")

   ! mfReal ------------------------------------------------------------
   call print_separation("mfReal")

   !-- real
   allocate( ir(5), jc(5), val(5) )
   ir(:) = [ 1, 2, 3, 4, 2 ]
   jc(:) = [ 1, 4, 1, 1, 2 ]
   val(:) = [ -1.0d0, 2.0d0, -3.0d0, 4.0d0, -5.0d0 ]

   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   print "(/,A)", "*** test number 230 ***"
   call msDisplay(mfReal(A), "mfReal(A)")

   !-- complex
   allocate( ir(5), jc(5), zval(5) )
   ir(:) = [ 1, 2, 3, 4, 2 ]
   jc(:) = [ 1, 4, 1, 1, 2 ]
   zval(:) = [ (0.0d0,1.0d0), (1.0d0,0.0d0), (0.0d0,-1.0d0),             &
               (-1.0d0,0.0d0), (1.0d0,1.0d0) ]

   A = mfSpImport(ir,jc,zval)
   deallocate( ir, jc, zval )
   call msDisplay(A, "A = mfSpImport(ir,jc,zval)")
   print "(/,A)", "*** test number 231 ***"
   call msDisplay(mfReal(A), "mfReal(A)")

   ! mfImag ------------------------------------------------------------
   call print_separation("mfImag")

   !-- real
   allocate( ir(5), jc(5), val(5) )
   ir(:) = [ 1, 2, 3, 4, 2 ]
   jc(:) = [ 1, 4, 1, 1, 2 ]
   val(:) = [ -1.0d0, 2.0d0, -3.0d0, 4.0d0, -5.0d0 ]

   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   print "(/,A)", "*** test number 232 ***"
   call msDisplay(mfImag(A), "mfImag(A)")

   !-- complex
   allocate( ir(5), jc(5), zval(5) )
   ir(:) = [ 1, 2, 3, 4, 2 ]
   jc(:) = [ 1, 4, 1, 1, 2 ]
   zval(:) = [ (0.0d0,1.0d0), (1.0d0,0.0d0), (0.0d0,-1.0d0),             &
               (-1.0d0,0.0d0), (1.0d0,1.0d0) ]

   A = mfSpImport(ir,jc,zval)
   deallocate( ir, jc, zval )
   call msDisplay(A, "A = mfSpImport(ir,jc,zval)")
   print "(/,A)", "*** test number 233 ***"
   call msDisplay(mfImag(A), "mfImag(A)")

   ! mfSqrt ------------------------------------------------------------
   call print_separation("mfSqrt")

   !-- real (without negative values)
   allocate( ir(5), jc(5), val(5) )
   ir(:) = [ 1, 2, 3, 4, 2 ]
   jc(:) = [ 1, 4, 1, 1, 2 ]
   val(:) = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0 ]

   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   print "(/,A)", "*** test number 234 ***"
   call msDisplay(mfSqrt(A), "mfSqrt(A)")

   !-- real (with negative values)
   allocate( ir(5), jc(5), val(5) )
   ir(:) = [ 1, 2, 3, 4, 2 ]
   jc(:) = [ 1, 4, 1, 1, 2 ]
   val(:) = [ -1.0d0, 2.0d0, -3.0d0, 4.0d0, -5.0d0 ]

   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   print "(/,A)", "*** test number 235 ***"
   call msDisplay(mfSqrt(A), "mfSqrt(A)")

   !-- complex
   allocate( ir(5), jc(5), zval(5) )
   ir(:) = [ 1, 2, 3, 4, 2 ]
   jc(:) = [ 1, 4, 1, 1, 2 ]
   zval(:) = [ (0.0d0,1.0d0), (1.0d0,0.0d0), (0.0d0,-1.0d0),             &
               (-1.0d0,0.0d0), (1.0d0,1.0d0) ]

   A = mfSpImport(ir,jc,zval)
   deallocate( ir, jc, zval )
   call msDisplay(A, "A = mfSpImport(ir,jc,zval)")
   print "(/,A)", "*** test number 236 ***"
   call msDisplay(mfSqrt(A), "mfSqrt(A)")

   ! mfExpm1 -----------------------------------------------------------
   call print_separation("mfExpm1")

   allocate( ir(5), jc(5), val(5) )
   ir(:) = [ 1, 2, 3, 4, 2 ]
   jc(:) = [ 1, 4, 1, 1, 2 ]
   val(:) = [ -1.0d-2, -1.0d-4, 0.0d0, 1.0d-4, 1.0d-2 ]

   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   print "(/,A)", "*** test number 237 ***"
   call msDisplay(mfExpm1(A), "mfExpm1(A)")

   allocate( ir(5), jc(5), val(5) )
   ir(:) = [ 1, 2, 3, 4, 2 ]
   jc(:) = [ 1, 4, 1, 1, 2 ]
   val(:) = [ -1.0d-5, -1.0d-10, 0.0d0, 1.0d-10, 1.0d-5 ]

   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   call msFormat( "long" )
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   print "(/,A)", "*** test number 238 ***"
   call msDisplay(mfExpm1(A), "mfExpm1(A)")
   call msFormat()

   ! mfTrace -----------------------------------------------------------
   call print_separation("mfTrace")

   !-- real
   A = mfSpEye(5)
   call msDisplay(A, "A")
   print "(/,A)", "*** test number 239 ***"
   call msDisplay(mfTrace(A), "mfTrace(A)")

   !-- complex
   A = mfSpEye(5)*MF_I
   call msDisplay(A, "A")
   print "(/,A)", "*** test number 240 ***"
   call msDisplay(mfTrace(A), "mfTrace(A)")

   ! mfRot90 -----------------------------------------------------------
   call print_separation("mfRot90")

   !-- real
   allocate( ir(5), jc(5), val(5) )
   ir(:) = [ 1, 3, 3, 4, 2 ]
   jc(:) = [ 1, 3, 1, 1, 2 ]
   val(:) = [ 1.0d0, -2.0d0, 3.0d0, 4.0d0, -5.0d0 ]

   print "(/,A)", "*** test number 241 ***"
   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   print *, "A = mfSpImport(ir,jc,val)"
   call msDisplay(mfFull(A), "A is sparse: mfFull(A)")
   call msDisplay(mfFull(mfRot90(A,0)), "mfRot90(A,0) [idem A]")
   print "(/,A)", "*** test number 242 ***"
   call msDisplay(mfFull(mfRot90(A,1)), "mfRot90(A,1) [90 direct]")
   print "(/,A)", "*** test number 243 ***"
   call msDisplay(mfFull(mfRot90(A,2)), "mfRot90(A,2) [180 direct]")
   print "(/,A)", "*** test number 244 ***"
   call msDisplay(mfFull(mfRot90(A,3)), "mfRot90(A,3) [270 direct]")

   !-- complex
   allocate( ir(5), jc(5), zval(5) )
   ir(:) = [ 1, 3, 3, 4, 2 ]
   jc(:) = [ 1, 3, 1, 1, 2 ]
   zval(:) = [ 1.0d0, -2.0d0, 3.0d0, 4.0d0, -5.0d0 ]*MF_I

   print "(/,A)", "*** test number 245 ***"
   A = mfSpImport(ir,jc,zval)
   deallocate( ir, jc, zval )
   print *, "A = mfSpImport(ir,jc,zval)"
   call msDisplay(mfFull(A), "A is sparse: mfFull(A)")
   call msDisplay(mfFull(mfRot90(A,0)), "mfRot90(A,0) [idem A]")
   print "(/,A)", "*** test number 246 ***"
   call msDisplay(mfFull(mfRot90(A,1)), "mfRot90(A,1) [90 direct]")
   print "(/,A)", "*** test number 247 ***"
   call msDisplay(mfFull(mfRot90(A,2)), "mfRot90(A,2) [180 direct]")
   print "(/,A)", "*** test number 248 ***"
   call msDisplay(mfFull(mfRot90(A,3)), "mfRot90(A,3) [270 direct]")

   ! mfSum -------------------------------------------------------------
   call print_separation("mfSum")

   !-- real
   allocate( ir(6), jc(6), val(6) )
   ir(:) = [ 1, 3, 3, 4, 2, 1 ]
   jc(:) = [ 1, 3, 1, 1, 2, 3 ]
   val(:) = [ 1.0d0, -2.0d0, 3.0d0, 4.0d0, -5.0d0, 1.0d0 ]

   print "(/,A)", "*** test number 249 ***"
   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   print *, "A = mfSpImport(ir,jc,val)"
   call msDisplay(mfFull(A), "A is sparse: mfFull(A)")
   call msDisplay(mfSum(A), "mfSum(A)")
   call msDisplay(mfSum(A,dim=1), "mfSum(A,dim=1)")
   call msDisplay(mfSum(A,dim=2), "mfSum(A,dim=2)")

   !-- complex
   allocate( ir(6), jc(6), zval(6) )
   ir(:) = [ 1, 3, 3, 4, 2, 1 ]
   jc(:) = [ 1, 3, 1, 1, 2, 3 ]
   zval(:) = [ 1.0d0,  0.0d0, 3.0d0, 4.0d0,  0.0d0, 2.0d0 ] +           &
             [ 0.0d0, -2.0d0, 1.0d0, 0.0d0, -5.0d0, 1.0d0 ]*MF_I

   print "(/,A)", "*** test number 250 ***"
   A = mfSpImport(ir,jc,zval)
   deallocate( ir, jc, zval )
   print *, "A = mfSpImport(ir,jc,zval)"
   call msDisplay(mfFull(A), "A is sparse: mfFull(A)")
   call msDisplay(mfSum(A), "mfSum(A)")
   call msDisplay(mfSum(A,dim=1), "mfSum(A,dim=1)")
   call msDisplay(mfSum(A,dim=2), "mfSum(A,dim=2)")

   ! mfNormest1 --------------------------------------------------------
   call print_separation("mfNormest1")

   !-- real
   allocate( ir(4), jc(4), val(4) )
   ir(:) = [ 1, 3, 3, 2 ]
   jc(:) = [ 1, 3, 1, 2 ]
   val(:) = [ 1.0d0, -2.0d0, 3.0d0, -5.0d0 ]

   print "(/,A)", "*** test number 251 ***"
   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   print *, "A = mfSpImport(ir,jc,val)"
   call msDisplay(mfFull(A), "A is sparse: mfFull(A)")
   call msDisplay(mfNorm(A,1),"norm(A,1)")
   call msDisplay(mfNormest1(A),"normest1(A)")

   allocate( ir(6), jc(6), val(6) )
   ir(:) = [ 1, 3, 3, 2, 1, 4 ]
   jc(:) = [ 1, 3, 1, 2, 3, 4 ]
   val(:) = [ 1.0d0, -2.0d0, 3.0d0, -5.0d0, 1.0d0, 2.0d0 ]

   print "(/,A)", "*** test number 252 ***"
   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   print *, "A = mfSpImport(ir,jc,val)"
   call msDisplay(mfFull(A), "A is sparse: mfFull(A)")
   call msDisplay(mfNorm(A,1),"norm(A,1)")
   call msDisplay(mfNormest1(A),"normest1(A)")

   print "(/,A)", "*** test number 253 ***"
   A = mfLoadSparse( "data/A.csc", "CSC" )
   call msDisplay(mfShape(A), "shape(A)")
   print "(1X,A,I0)", "nnz(A) = ", mfNnz(A)
   call msDisplay(mfNorm(A,1),"norm(A,1)")
   call msDisplay(mfNormest1(A),"normest1(A)")

   !-- complex
   allocate( ir(4), jc(4), zval(4) )
   ir(:) = [ 1, 3, 3, 2 ]
   jc(:) = [ 1, 3, 1, 2 ]
   zval(:) = [ 1.0d0,  0.0d0, 3.0d0, 4.0d0 ] +                          &
             [ 0.0d0, -2.0d0, 1.0d0, 0.0d0 ]*MF_I

   print "(/,A)", "*** test number 254 ***"
   A = mfSpImport(ir,jc,zval)
   deallocate( ir, jc, zval )
   print *, "A = mfSpImport(ir,jc,zval)"
   call msDisplay(mfFull(A), "A is sparse: mfFull(A)")
   call msDisplay(mfNorm(A,1),"norm(A,1)")
   call msDisplay(mfNormest1(A),"normest1(A)")

   allocate( ir(6), jc(6), zval(6) )
   ir(:) = [ 1, 3, 3, 2, 1, 4 ]
   jc(:) = [ 1, 3, 1, 2, 3, 4 ]
   zval(:) = [ 1.0d0, -2.0d0, 3.0d0, -5.0d0, 1.0d0, 2.0d0 ] +           &
             [ 0.0d0, -2.0d0, 1.0d0,  0.0d0, 7.0d0, 0.0d0 ]*MF_I

   print "(/,A)", "*** test number 255 ***"
   A = mfSpImport(ir,jc,zval)
   deallocate( ir, jc, zval )
   print *, "A = mfSpImport(ir,jc,val)"
   call msDisplay(mfFull(A), "A is sparse: mfFull(A)")
   call msDisplay(mfNorm(A,1),"norm(A,1)")
   call msDisplay(mfNormest1(A),"normest1(A)")

   print "(/,A)", "*** test number 256 ***"
   A = mfLoadSparse( "data/A.csc", "CSC" )
   n = size(A,1)
   A = A + mfSparse( mfRot90(4.0d0*mfEye(n),1)*MF_I )
   call msDisplay(mfShape(A), "shape(A)")
   print "(1X,A,I0)", "nnz(A) = ", mfNnz(A)
   call msDisplay(mfNorm(A,1),"norm(A,1)")
   call msDisplay(mfNormest1(A),"normest1(A)")

   ! mfCondEst ---------------------------------------------------------
   call print_separation("mfCondEst")

   !-- real matrices
   allocate( ir(4), jc(4), val(4) )
   ir(:) = [ 1, 3, 3, 2 ]
   jc(:) = [ 1, 3, 1, 2 ]
   val(:) = [ 1.0d0, -2.0d0, 3.0d0, -5.0d0 ]

   print "(/,A)", "*** test number 257 ***"
   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   print *, "A = mfSpImport(ir,jc,val)"
   call msDisplay(mfFull(A), "A is sparse: mfFull(A)")
   call msDisplay(mfCond(A),"cond(A)")
   ! taking reference as rcond(full(A)), because rcond(sparse(A)) is
   ! a poor approximation in MUESLI
   call msDisplay(1.0d0/mfRCond(mfFull(A)),"1/rcond(full(A))")
   call msDisplay(mfCondEst(A),"condest(A)")

   allocate( ir(6), jc(6), val(6) )
   ir(:) = [ 1, 3, 3, 2, 1, 4 ]
   jc(:) = [ 1, 3, 1, 2, 3, 4 ]
   val(:) = [ 1.0d0, -2.0d0, 3.0d0, -5.0d0, 1.0d0, 2.0d0 ]

   print "(/,A)", "*** test number 258 ***"
   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   print *, "A = mfSpImport(ir,jc,val)"
   call msDisplay(mfFull(A), "A is sparse: mfFull(A)")
   call msDisplay(mfCond(A),"cond(A)")
   ! taking reference as rcond(full(A)), because rcond(sparse(A)) is
   ! a poor approximation in MUESLI
   call msDisplay(1.0d0/mfRCond(mfFull(A)),"1/rcond(full(A))")
   call msDisplay(mfCondEst(A),"condest(A)")

   print "(/,A)", "*** test number 259 ***"
   A = mfLoadSparse( "data/A.csc", "CSC" )
   print *
   print *, 'mfLoadSparse( "data/A.csc", "CSC" )'
   call msDisplay(mfShape(A), "shape(A)")
   print "(1X,A,I0)", "nnz(A) = ", mfNnz(A)
   call msDisplay(mfCond(A),"cond(A)")
   bool = mfIsSymm(A)
   if( bool ) then
      print *, "A is symmetric"
   else
      print *, "A is not symmetric"
   end if
   bool = mfIsPosDef(A)
   if( bool ) then
      print *, "A is positive definite"
   else
      print *, "A is not positive definite"
   end if
   ! taking reference as rcond(full(A)), because rcond(sparse(A)) is
   ! a poor approximation in MUESLI
   call msDisplay(1.0d0/mfRCond(mfFull(A)),"1/rcond(full(A))")
   call msDisplay(mfCondEst(A),"condest(A)")

   !-- complex
   allocate( ir(4), jc(4), zval(4) )
   ir(:) = [ 1, 3, 3, 2 ]
   jc(:) = [ 1, 3, 1, 2 ]
   zval(:) = [ 1.0d0,  0.0d0, 3.0d0, 4.0d0 ] +                          &
             [ 0.0d0, -2.0d0, 1.0d0, 0.0d0 ]*MF_I

   print "(/,A)", "*** test number 260 ***"
   A = mfSpImport(ir,jc,zval)
   deallocate( ir, jc, zval )
   print *, "A = mfSpImport(ir,jc,zval)"
   call msDisplay(mfFull(A), "A is sparse: mfFull(A)")
   call msDisplay(mfCond(A),"cond(A)")
   ! taking reference as rcond(full(A)), because rcond(sparse(A)) is
   ! a poor approximation in MUESLI
   call msDisplay(1.0d0/mfRCond(mfFull(A)),"1/rcond(full(A))")
   call msDisplay(mfCondEst(A),"condest(A)")

   allocate( ir(6), jc(6), zval(6) )
   ir(:) = [ 1, 3, 3, 2, 1, 4 ]
   jc(:) = [ 1, 3, 1, 2, 3, 4 ]
   zval(:) = [ 1.0d0, -2.0d0, 3.0d0, -5.0d0, 1.0d0, 2.0d0 ] +           &
             [ 0.0d0, -2.0d0, 1.0d0,  0.0d0, 7.0d0, 0.0d0 ]*MF_I

   print "(/,A)", "*** test number 261 ***"
   A = mfSpImport(ir,jc,zval)
   deallocate( ir, jc, zval )
   print *, "A = mfSpImport(ir,jc,val)"
   call msDisplay(mfFull(A), "A is sparse: mfFull(A)")
   call msDisplay(mfCond(A),"cond(A)")
   ! taking reference as rcond(full(A)), because rcond(sparse(A)) is
   ! a poor approximation in MUESLI
   call msDisplay(1.0d0/mfRCond(mfFull(A)),"1/rcond(full(A))")
   call msDisplay(mfCondEst(A),"condest(A)")

   print "(/,A)", "*** test number 262 ***"
   A = mfLoadSparse( "data/A.csc", "CSC" )
   n = size(A,1)
   A = A + mfSparse( mfRot90(4.0d0*mfEye(n),1)*MF_I )
   call msDisplay(mfShape(A), "shape(A)")
   print "(1X,A,I0)", "nnz(A) = ", mfNnz(A)
   call msDisplay(mfCond(A),"cond(A)")
   ! taking reference as rcond(full(A)), because rcond(sparse(A)) is
   ! a poor approximation in MUESLI
   call msDisplay(1.0d0/mfRCond(mfFull(A)),"1/rcond(full(A))")
   call msDisplay(mfCondEst(A),"condest(A)")

   ! mfNormEst ---------------------------------------------------------
   call print_separation("mfNormEst")

   !-- real matrices

   allocate( ir(4), jc(4), val(4) )
   ir(:) = [ 1, 3, 3, 2 ]
   jc(:) = [ 1, 3, 1, 2 ]
   val(:) = [ 1.0d0, -2.0d0, 3.0d0, -5.0d0 ]

   print "(/,A)", "*** test number 263 ***"
   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   print *, "A = mfSpImport(ir,jc,val)"
   call msDisplay(mfFull(A), "A is sparse: mfFull(A)")
   call msDisplay(mfNorm(A),"norm(A)")
   call msDisplay(mfNormEst(A),"normest(A)")

   allocate( ir(6), jc(6), val(6) )
   ir(:) = [ 1, 3, 3, 2, 1, 4 ]
   jc(:) = [ 1, 3, 1, 2, 3, 4 ]
   val(:) = [ 1.0d0, -2.0d0, 3.0d0, -5.0d0, 1.0d0, 2.0d0 ]

   print "(/,A)", "*** test number 264 ***"
   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   print *, "A = mfSpImport(ir,jc,val)"
   call msDisplay(mfFull(A), "A is sparse: mfFull(A)")
   call msDisplay(mfNorm(A),"norm(A)")
   call msDisplay(mfNormEst(A),"normest(A)")

   print "(/,A)", "*** test number 265 ***"
   A = mfLoadSparse( "data/A.csc", "CSC" )
   call msDisplay(mfShape(A), "shape(A)")
   print "(1X,A,I0)", "nnz(A) = ", mfNnz(A)
   call msDisplay(mfNorm(A),"norm(A)")
   call msDisplay(mfNormEst(A),"normest(A)")

   ! non-square real matrices

   allocate( ir(4), jc(4), val(4) )
   ir(:) = [ 1, 3, 3, 2 ]
   jc(:) = [ 1, 3, 1, 2 ]
   val(:) = [ 1.0d0, -2.0d0, 3.0d0, -5.0d0 ]

   print "(/,A)", "*** test number 266 ***"
   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )
   A = A .hc. A
   print *, "A = mfSpImport(ir,jc,val)"
   call msDisplay(mfShape(A), "shape(A)")
   print "(1X,A,I0)", "nnz(A) = ", mfNnz(A)
   call msDisplay(mfNorm(A),"norm(A)")
   call msDisplay(mfNormEst(A),"normest(A)")

   !-- complex
   allocate( ir(4), jc(4), zval(4) )
   ir(:) = [ 1, 3, 3, 2 ]
   jc(:) = [ 1, 3, 1, 2 ]
   zval(:) = [ 1.0d0,  0.0d0, 3.0d0, 4.0d0 ] +                          &
             [ 0.0d0, -2.0d0, 1.0d0, 0.0d0 ]*MF_I

   print "(/,A)", "*** test number 267 ***"
   A = mfSpImport(ir,jc,zval)
   deallocate( ir, jc, zval )
   print *, "A = mfSpImport(ir,jc,zval)"
   call msDisplay(mfShape(A), "shape(A)")
   print "(1X,A,I0)", "nnz(A) = ", mfNnz(A)
   call msDisplay(mfNorm(A),"norm(A)")
   call msDisplay(mfNormEst(A),"normest(A)")

   allocate( ir(6), jc(6), zval(6) )
   ir(:) = [ 1, 3, 3, 2, 1, 4 ]
   jc(:) = [ 1, 3, 1, 2, 3, 4 ]
   zval(:) = [ 1.0d0, -2.0d0, 3.0d0, -5.0d0, 1.0d0, 2.0d0 ] +           &
             [ 0.0d0, -2.0d0, 1.0d0,  0.0d0, 7.0d0, 0.0d0 ]*MF_I

   print "(/,A)", "*** test number 268 ***"
   A = mfSpImport(ir,jc,zval)
   deallocate( ir, jc, zval )
   print *, "A = mfSpImport(ir,jc,val)"
   call msDisplay(mfShape(A), "shape(A)")
   print "(1X,A,I0)", "nnz(A) = ", mfNnz(A)
   call msDisplay(mfNorm(A),"norm(A)")
   call msDisplay(mfNormEst(A),"normest(A)")

   print "(/,A)", "*** test number 269 ***"
   A = mfLoadSparse( "data/A.csc", "CSC" )
   n = size(A,1)
   A = A + mfSparse( mfRot90(4.0d0*mfEye(n),1)*MF_I )
   call msDisplay(mfShape(A), "shape(A)")
   print "(1X,A,I0)", "nnz(A) = ", mfNnz(A)
   call msDisplay(mfNorm(A),"norm(A)")
   call msDisplay(mfNormEst(A),"normest(A)")

   allocate( ir(4), jc(4), zval(4) )
   ir(:) = [ 1, 3, 3, 2 ]
   jc(:) = [ 1, 3, 1, 2 ]
   zval(:) = [ 1.0d0,  0.0d0, 3.0d0, 4.0d0 ] +                          &
             [ 0.0d0, -2.0d0, 1.0d0, 0.0d0 ]*MF_I

   print "(/,A)", "*** test number 270 ***"
   A = mfSpImport(ir,jc,zval)
   deallocate( ir, jc, zval )
   A = A .hc. A
   print *, "A = mfSpImport(ir,jc,zval)"
   call msDisplay(mfShape(A), "shape(A)")
   print "(1X,A,I0)", "nnz(A) = ", mfNnz(A)
   call msDisplay(mfNorm(A),"norm(A)")
   call msDisplay(mfNormEst(A),"normest(A)")

   ! mfQR --------------------------------------------------------------
   call print_separation("mfQR")

   ! --- real case
   !     square matrix (full rank)
   allocate( ir(12), jc(12), val(12) )
   ir(:) = [ 1, 2, 1, 3, 5, 2, 3, 4, 5, 3, 2, 5 ]
   jc(:) = [ 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 5, 5 ]
   val(:) = [ 2.0d0, 3.0d0, 3.0d0, -1.0d0, 4.0d0, 4.0d0, -3.0d0,        &
              1.0d0, 2.0d0, 2.0d0,  6.0d0, 1.0d0 ]

   print "(/,A)", "*** test number 271 ***"
   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")
   call msDisplay(mfRank(mfFull(A)), "rank(A)")

   deallocate( ir, jc, val )

   R = mfQR(A)
   call msDisplay(R,"R = mfQR(A)")
   call msDisplay(mfFull(R), "")
   x = mfMul( .t. R, R )
   y = mfMul( .t. A, A )
   call msDisplay( mfNorm(x-y), "|R'*R - A'*A|" )

   ! over-determined system : m > n (full rank)
   allocate( ir(15), jc(15), val(15) )
   ir(:) = [ 1, 2, 4, 6, 5, 2, 7, 1, 5, 3, 6, 2, 3, 1, 3 ]
   jc(:) = [ 2, 3, 3, 3, 5, 1, 5, 1, 2, 4, 4, 5, 2, 3, 3 ]
   val(:) = [ 3.0d0, -3.0d0, 2.0d0, 3.0d0, 1.0d0,  3.0d0, 2.0d0,        &
              2.0d0,  4.0d0, 2.0d0, 3.0d0, 6.0d0, -1.0d0, 4.0d0, 1.0d0 ]

   print "(/,A)", "*** test number 272 ***"
   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")
   call msDisplay(mfRank(mfFull(A)), "rank(A)")

   deallocate( ir, jc, val )

   R = mfQR(A)
   call msDisplay(R,"R = mfQR(A)")
   call msDisplay(mfFull(R), "")
   x = mfMul( .t. R, R )
   y = mfMul( .t. A, A )
   call msDisplay( mfNorm(x-y), "|R'*R - A'*A|" )

   ! other case with m > n  (full rank)
   allocate( ir(14), jc(14), val(14) )
   ir(:) = [ 1, 6, 6, 5, 2, 2, 3, 8, 3, 4, 7, 8, 9, 5 ]
   jc(:) = [ 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 4, 4, 5 ]
   val(:) = [ 2.5d0, -1.9d0,  0.2d0, -0.6d0,  2.5d0,  0.3d0,  2.2d0,    &
             -0.9d0,  2.3d0,  2.2d0, -0.1d0, -1.4d0, -0.7d0,  1.6d0 ]

   print "(/,A)", "*** test number 273 ***"
   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")
   call msDisplay(mfRank(mfFull(A)), "rank(A)")

   deallocate( ir, jc, val )

   R = mfQR(A)
   call msDisplay(R,"R = mfQR(A)")
   call msDisplay(mfFull(R), "")
   x = mfMul( .t. R, R )
   y = mfMul( .t. A, A )
   call msDisplay( mfNorm(x-y), "|R'*R - A'*A|" )

   ! underdetermined system : m < n (full rank)
   allocate( ir(15), jc(15), val(15) )
   ir(:) = [ 1, 2, 4, 6, 5, 2, 7, 1, 5, 3, 6, 2, 3, 1, 3 ]
   jc(:) = [ 2, 3, 3, 3, 5, 1, 5, 1, 2, 4, 4, 5, 2, 3, 3 ]
   val(:) = [ 3.0d0, -3.0d0, 2.0d0, 3.0d0, 1.0d0,  3.0d0, 2.0d0,        &
              2.0d0,  4.0d0, 2.0d0, 3.0d0, 6.0d0, -1.0d0, 4.0d0, 1.0d0 ]

   print "(/,A)", "*** test number 274 ***"
   A = mfSpImport(ir,jc,val)
   A = .t. A
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")
   call msDisplay(mfRank(mfFull(A)), "rank(A)")

   deallocate( ir, jc, val )

   R = mfQR(A)
   call msDisplay(R,"R = mfQR(A)")
   call msDisplay(mfFull(R), "")
   x = mfMul( .t. R, R )
   y = mfMul( .t. A, A )
   call msDisplay( mfNorm(x-y), "|R'*R - A'*A|" )

   ! square (rank deficient)
   allocate( ir(7), jc(7), val(7) )
   ir(:) = [ 2, 4, 2, 1, 4, 3, 5 ]
   jc(:) = [ 1, 2, 3, 4, 4, 5, 5 ]
   val(:) = [ 0.7d0,  0.2d0, -0.7d0,  1.3d0, -0.2d0,  0.4d0,  1.6d0 ]

   print "(/,A)", "*** test number 275 ***"
   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")
   call msDisplay(mfRank(mfFull(A)), "rank(A)")

   deallocate( ir, jc, val )

   R = mfQR(A)
   call msDisplay(R,"R = mfQR(A)")
   call msDisplay(mfFull(R), "")
   x = mfMul( .t. R, R )
   y = mfMul( .t. A, A )
   call msDisplay( mfNorm(x-y), "|R'*R - A'*A|" )

   ! all zero matrix
   A = mfSpAlloc(6,4)
   call msDisplay(A, "A")

   print "(/,A)", "*** test number 276 ***"
   R = mfQR(A)
   call msDisplay(R,"R = mfQR(A)")

   ! msQR, mfQleft, mfQright -------------------------------------------
   call print_separation("msQR, mfQleft, mfQright")

   ! --- real case
   !     square matrix (full rank)
   allocate( ir(12), jc(12), val(12) )
   ir(:) = [ 1, 5, 1, 3, 5, 2, 3, 4, 5, 2, 2, 3 ]
   jc(:) = [ 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 5, 5 ]
   val(:) = [ 2.0d0, 3.0d0, 3.0d0, -1.0d0, 4.0d0, 4.0d0, -3.0d0,        &
              1.0d0, 2.0d0, 2.0d0,  6.0d0, 1.0d0 ]

   print "(/,A)", "*** test number 277 ***"
   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")
   call msDisplay(mfRank(mfFull(A)), "rank(A)")

   deallocate( ir, jc, val )

   call msQR( mfOut(Q,R), A )
   call msDisplay(R,"R")
   call msDisplay(mfFull(R), "")
   call msDisplay(Q,"Q")
   call msDisplay(mfFull(Q), "")
   call msDisplay(mfNorm(mfMul(Q,R)-A),"|Q*R - A|")

   print "(/,A)", "*** test number 278 ***"
   call msQR( mfOut(Q,R,p), A )
   call msDisplay(R,"R")
   call msDisplay(mfFull(R), "")
   call msDisplay(Q,"Q")
   call msDisplay(mfFull(Q), "")
   call msDisplay(p,"permutation p")
   call msDisplay(mfNorm(mfMul(Q,R)-mfColPerm(A,p)),"|Q*R - A(:,p)|")

   print "(/,A)", "*** test number 279 ***"
   call msQR( mfOut(Q,R,p,RANK), A )
   call msDisplay(RANK,"rank(A) via QR")

   A = mfSpEye(5,5)
   call msSet( 1.0d-8, A, 5, 5 )
   call msDisplay(A,"A")
   print "(/,A)", "*** test number 280 ***"
   call msQR( mfOut(Q,R,P,RANK), A )
   call msDisplay(RANK,"rank(A) [with default tolerance]")
   if( mfDble(RANK) /= 5 ) then
      print *, "*** sparse case: RRQR failed ***"
   end if
   print "(/,A)", "*** test number 281 ***"
   call msQR( mfOut(Q,R,P,RANK), A, tol=0.5d-8 )
   call msDisplay(RANK,"rank(A) [with tol=0.5d-8]") ! should be 5
   if( mfDble(RANK) /= 5 ) then
      print *, "*** sparse case: RRQR failed ***"
   end if
   print "(/,A)", "*** test number 282 ***"
   call msQR( mfOut(Q,R,P,RANK), A, tol=0.5d-7 )
   call msDisplay(RANK,"rank(A) [with tol=0.5d-7]") ! should be 4
   if( mfDble(RANK) /= 4 ) then
      print *, "*** sparse case: RRQR failed ***"
   end if

   ! comparison with the dense case (consistency)
   print "(/,A)", "*** test number 283 ***"
   call msQR( mfOut(Q,R,P,RANK), mfFull(A) )
   call msDisplay(RANK,"rank(full(A)) [with default tolerance]")
   if( mfDble(RANK) /= 5 ) then
      print *, "*** dense case: RRQR failed ***"
   end if
   print "(/,A)", "*** test number 284 ***"
   call msQR( mfOut(Q,R,P,RANK), mfFull(A), tol=0.5d-8 )
   call msDisplay(RANK,"rank(full(A)) [with tol=0.5d-8]") ! should be 5
   if( mfDble(RANK) /= 5 ) then
      print *, "*** dense case: RRQR failed ***"
   end if
   print "(/,A)", "*** test number 285 ***"
   call msQR( mfOut(Q,R,P,RANK), mfFull(A), tol=0.5d-7 )
   call msDisplay(RANK,"rank(full(A)) [with tol=0.5d-7]") ! should be 4
   if( mfDble(RANK) /= 4 ) then
      print *, "*** dense case: RRQR failed ***"
   end if

   !     rectangular matrix : m > n (full rank)
   allocate( ir(15), jc(15), val(15) )
   ir(:) = [ 1, 2, 4, 6, 5, 7, 7, 1, 5, 3, 6, 2, 3, 1, 3 ]
   jc(:) = [ 2, 3, 3, 3, 5, 1, 5, 1, 2, 4, 4, 5, 2, 3, 3 ]
   val(:) = [ 3.0d0, -3.0d0, 2.0d0, 3.0d0, 1.0d0,  3.0d0, 2.0d0,        &
              2.0d0,  4.0d0, 2.0d0, 3.0d0, 6.0d0, -1.0d0, 4.0d0, 1.0d0 ]

   print "(/,A)", "*** test number 286 ***"
   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")
   call msDisplay(mfRank(mfFull(A)), "rank(A)")

   deallocate( ir, jc, val )

   call msQR( mfOut(Q,R), A )
   call msDisplay(Q,"Q")
   call msDisplay(mfFull(Q), "")
   call msDisplay(R,"R")
   call msDisplay(mfFull(R), "")
   call msDisplay(mfNorm(mfMul(Q,R)-A),"|Q*R - A|")

   !     rectangular matrix : m < n (full rank)
   allocate( ir(15), jc(15), val(15) )
   ir(:) = [ 1, 2, 4, 6, 5, 7, 7, 1, 5, 3, 6, 2, 3, 1, 3 ]
   jc(:) = [ 2, 3, 3, 3, 5, 1, 5, 1, 2, 4, 4, 5, 2, 3, 3 ]
   val(:) = [ 3.0d0, -3.0d0, 2.0d0, 3.0d0, 1.0d0,  3.0d0, 2.0d0,        &
              2.0d0,  4.0d0, 2.0d0, 3.0d0, 6.0d0, -1.0d0, 4.0d0, 1.0d0 ]

   print "(/,A)", "*** test number 287 ***"
   A = mfSpImport(ir,jc,val)
   A = .t. A
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")
   call msDisplay(mfRank(mfFull(A)), "rank(A)")

   deallocate( ir, jc, val )

   call msQR( mfOut(Q,R), A )
   call msDisplay(Q,"Q")
   call msDisplay(mfFull(Q), "")
   call msDisplay(R,"R")
   call msDisplay(mfFull(R), "")
   call msDisplay(mfNorm(mfMul(Q,R)-A),"|Q*R - A|")

   ! --- real case
   !     square matrix (full rank)
   allocate( ir(12), jc(12), val(12) )
   ir(:) = [ 1, 5, 1, 3, 5, 2, 3, 4, 5, 2, 2, 3 ]
   jc(:) = [ 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 5, 5 ]
   val(:) = [ 2.0d0, 3.0d0, 3.0d0, -1.0d0, 4.0d0, 4.0d0, -3.0d0,        &
              1.0d0, 2.0d0, 2.0d0,  6.0d0, 1.0d0 ]

   print "(/,A)", "*** test number 288 ***"
   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")
   call msDisplay(mfRank(mfFull(A)), "rank(A)")

   deallocate( ir, jc, val )

   call msQR( mfOut(Qhouse,R), A )
   call msDisplay(R,"R")
   call msDisplay(mfFull(R), "")
   m = mfGet( mfShape(A), 1 )
   n = mfGet( mfShape(A), 2 )
   x = mfMul( A, mfOnes(n,1) )
   call msDisplay(x,"x = mfMul( A, mfOnes(n,1) )")
   x = mfQleft( Qhouse, x )
   call msDisplay(x,"x = mfQleft( Qhouse, x )")
   call msDisplay( mfLDiv(R,x), "R\x" )

   Q = mfQright( mfEye(m,m), Qhouse )
   call msDisplay(Q,"Q (via mfQright)")
   call msDisplay( mfNorm(mfMul(Q,R)-mfFull(A)), "(right-dense) |Q*R - A|" )

   Q = .t. mfQleft( Qhouse, mfEye(m,m) )
   call msDisplay(Q,"Q (via mfQleft)")
   call msDisplay( mfNorm(mfMul(Q,R)-mfFull(A)), "(left-dense)  |Q*R - A|" )

   Q = mfQright( mfSpEye(m,m), Qhouse )
   call msDisplay(mfFull(Q),"sparse Q (via mfQright)")
   call msDisplay( mfNorm(mfMul(Q,R)-A), "(right-sparse) |Q*R - A|" )

   Q = .t. mfQleft( Qhouse, mfSpEye(m,m) )
   call msDisplay(mfFull(Q),"sparse Q (via mfQleft)")
   call msDisplay( mfNorm(mfMul(Q,R)-A), "(left-sparse)  |Q*R - A|" )

   !     rectangular matrix : m > n (full rank)
   allocate( ir(15), jc(15), val(15) )
   ir(:) = [ 1, 2, 4, 6, 5, 7, 7, 1, 5, 3, 6, 2, 3, 1, 3 ]
   jc(:) = [ 2, 3, 3, 3, 5, 1, 5, 1, 2, 4, 4, 5, 2, 3, 3 ]
   val(:) = [ 3.0d0, -3.0d0, 2.0d0, 3.0d0, 1.0d0,  3.0d0, 2.0d0,        &
              2.0d0,  4.0d0, 2.0d0, 3.0d0, 6.0d0, -1.0d0, 4.0d0, 1.0d0 ]

   print "(/,A)", "*** test number 289 ***"
   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")
   call msDisplay(mfRank(mfFull(A)), "rank(A)")

   deallocate( ir, jc, val )

   call msQR( mfOut(Qhouse,R), A )
   call msDisplay(mfShape(Qhouse),"shape(Qhouse)")
   call msDisplay(R,"R")
   call msDisplay(mfFull(R), "")
   m = mfGet( mfShape(A), 1 )
   n = mfGet( mfShape(A), 2 )
   x = mfMul( A, mfOnes(n,1) )
   call msDisplay(x,"b = mfMul( A, mfOnes(n,1) )")
   y = mfQleft( Qhouse, x )
   call msDisplay(y,"y = mfQleft( Qhouse, b )")
   ! for triangular matrices, only square systems are supported
   ! by mfLDiv; so, we must modify R and y
   R2 = mfGet( R, 1 .to. n, MF_COLON )
   call msDisplay(mfFull(R2), "R2 = R(1:n,:)")
   y = mfGet( y, 1 .to. n )
   call msDisplay(y,"y = y(1:n)")
   call msDisplay( mfLDiv(R2,y), "x = R2\y" )

   call msDisplay(mfNorm(mfQleft(Qhouse,A)-R),"via Qhouse: | Q'*A - R |")

   x = .t. mfMul( A, mfOnes(n,1) )
   call msDisplay(x,"b = .t. mfMul( A, mfOnes(n,1) )")
   y = .t. mfQright( x, Qhouse )
   call msDisplay(x,"y = .t. mfQright( b, Qhouse )")
   ! for triangular matrices, only square systems are supported
   ! by mfLDiv; so, we must modify y
   y = mfGet( y, 1 .to. n )
   call msDisplay(y,"y = y(1:n)")
   call msDisplay( mfLDiv(R2,y), "x = R2\y" )

   Q = mfQright( mfEye(m,m), Qhouse ) ! I.Q -> Q
   call msDisplay(Q,"Q (via mfQright)")
   call msDisplay( mfNorm(mfMul(Q,R)-mfFull(A)), "(right-dense) |Q*R - A|" )

   Q = .t. mfQleft( Qhouse, mfEye(m,m) ) ! Q'.I -> Q'
   call msDisplay(Q,"Q (via mfQleft)")
   call msDisplay( mfNorm(mfMul(Q,R)-mfFull(A)), "(left-dense)  |Q*R - A|" )

   Q = mfQright( mfSpEye(m,m), Qhouse )
   call msDisplay(mfFull(Q),"sparse Q (via mfQright)")
   call msDisplay( mfNorm(mfMul(Q,R)-A), "(right-sparse) |Q*R - A|" )

   Q = .t. mfQleft( Qhouse, mfSpEye(m,m) )
   call msDisplay(mfFull(Q),"sparse Q (via mfQleft)")
   call msDisplay( mfNorm(mfMul(Q,R)-A), "(left-sparse)  |Q*R - A|" )

   ! square (rank deficient)
   print "(/,A)", "*** test number 290 ***"
   allocate( ir(7), jc(7), val(7) )
   ir(:) = [ 2, 4, 2, 1, 4, 3, 5 ]
   jc(:) = [ 1, 2, 3, 4, 4, 5, 5 ]
   val(:) = [ 0.7d0,  0.2d0, -0.7d0,  1.3d0, -0.2d0,  0.4d0,  1.6d0 ]

   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")
   call msDisplay(mfRank(mfFull(A)), "rank(A)")

   deallocate( ir, jc, val )

   call msQR( mfOut(Qhouse,R), A )
   call msDisplay(R,"R")
   call msDisplay(mfFull(R), "")
   m = mfGet( mfShape(A), 1 )
   n = mfGet( mfShape(A), 2 )
   x = mfMul( A, mfOnes(n,1) )
   call msDisplay(x,"x = mfMul( A, mfOnes(n,1) )")
   x = mfQleft( Qhouse, x )
   call msDisplay(x,"x = mfQleft( Qhouse, x )")

   Q = mfQright( mfEye(m,m), Qhouse )
   call msDisplay(Q,"Q (via mfQright)")
   call msDisplay( mfNorm(mfMul(Q,R)-mfFull(A)), "(right-dense) |Q*R - A|" )

   Q = .t. mfQleft( Qhouse, mfEye(m,m) )
   call msDisplay(Q,"Q (via mfQleft)")
   call msDisplay( mfNorm(mfMul(Q,R)-mfFull(A)), "(left-dense)  |Q*R - A|" )

   Q = mfQright( mfSpEye(m,m), Qhouse )
   call msDisplay(mfFull(Q),"sparse Q (via mfQright)")
   call msDisplay( mfNorm(mfMul(Q,R)-A), "(right-sparse) |Q*R - A|" )

   Q = .t. mfQleft( Qhouse, mfSpEye(m,m) )
   call msDisplay(mfFull(Q),"sparse Q (via mfQleft)")
   call msDisplay( mfNorm(mfMul(Q,R)-A), "(left-sparse)  |Q*R - A|" )

   !    medium square matrix (bcsstk01: 48 x 48 -- full rank)
   print "(/,A)", "*** test number 291 ***"
   A = mfLoad( "data/bcsstk01.mbf" )
   call msDisplay(mfShape(A), "mfShape(A)")
   call msDisplay(mfNnz(A), "mfNnz(A)")

   call msQR( mfOut(Qhouse,R), A )
   call msDisplay(mfShape(R), "mfShape(R)")
   call msDisplay(mfNnz(R), "mfNnz(R)")

   m = mfGet( mfShape(A), 1 )
   Q = .t. mfQleft( Qhouse, mfSpEye(m,m) )
   call msDisplay(mfShape(Q), "mfShape(Q)")
   call msDisplay(mfNnz(Q), "mfNnz(Q)")

   call msDisplay( mfNorm(mfMul(Q,R)-A), "(left-sparse)  |Q*R - A|" )

   Q = mfQright( mfSpEye(m,m), Qhouse )
   call msDisplay( mfNorm(mfMul(Q,R)-A), "(right-sparse)  |Q*R - A|" )

   print "(/,A)", "*** test number 292 ***"
   print *, "(same as previous test, but with col perm. of A)"

   call msQR( mfOut(Qhouse,R,p), A )
   call msDisplay(mfShape(R), "mfShape(R)")
   call msDisplay(mfNnz(R), "mfNnz(R)")
   m = mfGet( mfShape(A), 1 )
   Q = .t. mfQleft( Qhouse, mfSpEye(m,m) )
   call msDisplay(mfShape(Q), "mfShape(Q)")
   call msDisplay(mfNnz(Q), "mfNnz(Q)")

   call msDisplay( mfNorm(mfMul(Q,R)-mfColPerm(A,p)),                   &
                   "(left-sparse)  |Q*R - A(:,P)|" )

   !    medium rectangular matrix (bcsstk01_2b: 96 x 48 -- full rank)
   A = mfLoad( "data/bcsstk01_2b.mbf" )
   print "(/,A)", "*** test number 293 ***"
   call msDisplay(mfShape(A), "mfShape(A)")
   call msDisplay(mfNnz(A), "mfNnz(A)")

   call msQR( mfOut(Qhouse,R), A )
   call msDisplay(mfShape(R), "mfShape(R)")
   call msDisplay(mfNnz(R), "mfNnz(R)")

   m = mfGet( mfShape(A), 1 )
   Q = .t. mfQleft( Qhouse, mfSpEye(m,m) )
   call msDisplay(mfShape(Q), "mfShape(Q)")
   call msDisplay(mfNnz(Q), "mfNnz(Q)")

   call msDisplay( mfNorm(mfMul(Q,R)-A), "(left-sparse)  |Q*R - A|" )

   Q = mfQright( mfSpEye(m,m), Qhouse )
   call msDisplay( mfNorm(mfMul(Q,R)-A), "(right-sparse)  |Q*R - A|" )

   print "(/,A)", "*** test number 294 ***"
   print *, "(same as previous test, but with col perm. of A)"

   call msQR( mfOut(Qhouse,R,P), A )
   call msDisplay(mfShape(R), "mfShape(R)")
   call msDisplay(mfNnz(R), "mfNnz(R)")
   m = mfGet( mfShape(A), 1 )
   Q = .t. mfQleft( Qhouse, mfSpEye(m,m) )
   call msDisplay(mfShape(Q), "mfShape(Q)")
   call msDisplay(mfNnz(Q), "mfNnz(Q)")

   call msDisplay( mfNorm(mfMul(Q,R)-mfColPerm(A,p)),                   &
                   "(left-sparse)  |Q*R - A(:,P)|" )

   !     rectangular matrix : m < n (full rank)
   allocate( ir(15), jc(15), val(15) )
   ir(:) = [ 1, 2, 4, 6, 5, 7, 7, 1, 5, 3, 6, 2, 3, 1, 3 ]
   jc(:) = [ 2, 3, 3, 3, 5, 1, 5, 1, 2, 4, 4, 5, 2, 3, 3 ]
   val(:) = [ 3.0d0, -3.0d0, 2.0d0, 3.0d0, 1.0d0,  3.0d0, 2.0d0,        &
              2.0d0,  4.0d0, 2.0d0, 3.0d0, 6.0d0, -1.0d0, 4.0d0, 1.0d0 ]

   print "(/,A)", "*** test number 295 ***"
   A = mfSpImport(ir,jc,val)
   A = .t. A
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")
   call msDisplay(mfRank(mfFull(A)), "rank(A)")

   deallocate( ir, jc, val )

   call msQR( mfOut(Q,R), A )
   call msDisplay(Q,"Q")
   call msDisplay(mfFull(Q), "")
   call msDisplay(R,"R")
   call msDisplay(mfFull(R), "")
   call msDisplay(mfNorm(mfMul(Q,R)-A),"|Q*R - A|")

   print "(/,A)", "*** test number 296 ***"
   call msQR( mfOut(Qhouse,R), A )
   call msDisplay(mfShape(Qhouse),"shape(Qhouse)")
   call msDisplay(R,"R")
   call msDisplay(mfFull(R), "")
   call msDisplay(mfNorm(mfQleft(Qhouse,A)-R),"via Qhouse: | Q'*A - R |")

   ! all zero matrix
   A = mfSpAlloc(6,4)
   call msDisplay(A, "A")

   print "(/,A)", "*** test number 297 ***"
   call msQR( mfOut(Q,R), A )
   call msDisplay(Q,"Q")
   call msDisplay(mfFull(Q), "")
   call msDisplay(R,"R")

   print "(/,A)", "*** test number 298 ***"
   call msQR( mfOut(Q,R,P,RANK), A )
   call msDisplay(Q,"Q")
   call msDisplay(mfFull(Q), "")
   call msDisplay(R,"R")
   call msDisplay(P,"P")
   call msDisplay(RANK,"RANK")

   ! mfSpCut -----------------------------------------------------------
   call print_separation("mfSpCut")

   ! --- real case
   allocate( ir(10), jc(10), val(10) )
   ir(:) = [ 1, 5, 1, 3, 5, 2, 3, 4, 5, 2 ]
   jc(:) = [ 1, 1, 2, 2, 2, 3, 3, 3, 3, 4 ]
   val(:) = [ 1.0d0, 1.0d-4, 1.0d0, -1.0d-4, 1.0d0,                     &
              1.0d0, 1.0d-6, 1.0d0, -1.0d-6, 1.0d0 ]

   print "(/,A)", "*** test number 299 ***"
   A = mfSpImport(ir,jc,val)
   call msDisplay(A, "A = mfSpImport(ir,jc,val)")

   deallocate( ir, jc, val )

   call msDisplay( mfSpCut(A,1.0d-5), "mfSpCut(A,1.0d-5)" )

   call msDisplay( mfSpCut(A,1.0d-3), "mfSpCut(A,1.0d-3)" )

   ! --- complex case
   allocate( ir(10), jc(10), zval(10) )
   ir(:) = [ 1, 5, 1, 3, 5, 2, 3, 4, 5, 2 ]
   jc(:) = [ 1, 1, 2, 2, 2, 3, 3, 3, 3, 4 ]
   zval(:) = [ (1.0d0,0.0d0), (1.0d-4,0.0d0), (0.0d0,1.0d0),            &
               (0.0d0,-1.0d-4), (1.0d0,0.0d0), (0.0d0,1.0d0),           &
               (1.0d-6,0.0d0), (1.0d0,0.0d0), (0.0d0,-1.0d-6),          &
               (0.0d0,1.0d0) ]

   print "(/,A)", "*** test number 300 ***"
   A = mfSpImport(ir,jc,zval)
   call msDisplay(A, "A = mfSpImport(ir,jc,zval)")

   deallocate( ir, jc, zval )

   call msDisplay( mfSpCut(A,1.0d-5), "mfSpCut(A,1.0d-5)" )

   call msDisplay( mfSpCut(A,1.0d-3), "mfSpCut(A,1.0d-3)" )

   ! mfIsDiag ----------------------------------------------------------
   call print_separation("mfIsDiag")

   print "(/,A)", "*** test number 301 ***"
   A = mfSpEye(4)
   call msDisplay( A, "A = mfSpEye(4)" )

   print *, "mfIsDiag(A) : ", mfIsDiag(A)

   call msSpReAlloc( A, mfNnz(A)+1 )
   call msSet( 2.0d0, A, 1, 4 )
   print *, "mfIsDiag(A) : ", mfIsDiag(A)

   call msSet( 0.0d0, A, 1, 4 )
   print *, "mfIsDiag(A) : ", mfIsDiag(A)
   print "()"

   ! mfIsTril ----------------------------------------------------------
   call print_separation("mfIsTril")

   print "(/,A)", "*** test number 302 ***"
   A = mfSparse(mfTril(mfOnes(4)))
   call msDisplay( A, "A = mfSparse(mfTril(mfOnes(4)))" )

   print *, "mfIsTril(A) : ", mfIsTril(A)

   print "(/,A)", "*** test number 303 ***"
   A = mfSparse(mfTriu(mfOnes(4)))
   call msDisplay( A, "A = mfSparse(mfTriu(mfOnes(4)))" )

   print *, "mfIsTril(A) : ", mfIsTril(A)

   print "(/,A)", "*** test number 304 ***"
   A = mfSparse(mfTril(mfOnes(5,3)))
   call msDisplay( A, "A = mfSparse(mfTril(mfOnes(5,3)))" )

   print *, "mfIsTril(A) : ", mfIsTril(A)

   print "(/,A)", "*** test number 305 ***"
   A = mfSparse(mfTril(mfOnes(3,5)))
   call msDisplay( A, "A = mfSparse(mfTril(mfOnes(3,5)))" )

   print *, "mfIsTril(A) : ", mfIsTril(A)
   print "()"

   ! mfIsTriu ----------------------------------------------------------
   call print_separation("mfIsTriu")

   print "(/,A)", "*** test number 306 ***"
   A = mfSparse(mfTriu(mfOnes(4)))
   call msDisplay( A, "A = mfSparse(mfTriu(mfOnes(4)))" )

   print *, "mfIsTriu(A) : ", mfIsTriu(A)

   print "(/,A)", "*** test number 307 ***"
   A = mfSparse(mfTril(mfOnes(4)))
   call msDisplay( A, "A = mfSparse(mfTril(mfOnes(4)))" )

   print *, "mfIsTriu(A) : ", mfIsTriu(A)

   print "(/,A)", "*** test number 308 ***"
   A = mfSparse(mfTriu(mfOnes(5,3)))
   call msDisplay( A, "A = mfSparse(mfTril(mfOnes(5,3)))" )

   print *, "mfIsTriu(A) : ", mfIsTriu(A)

   print "(/,A)", "*** test number 309 ***"
   A = mfSparse(mfTriu(mfOnes(3,5)))
   call msDisplay( A, "A = mfSparse(mfTril(mfOnes(3,5)))" )

   print *, "mfIsTriu(A) : ", mfIsTriu(A)
   print "()"

   ! mfKron ----------------------------------------------------------
   call print_separation("mfKron")

   print "(/,A)", "*** test number 310 ***"
   n = 3
   Id = mfSpEye(n,n)
   E = mfSpDiags(3,3,mf([1,1]),-1)
   call msDisplay( mfFull(E), "full(E)" )
   D = E + .t.E - 2.0d0*Id
   call msDisplay( mfFull(D), "full(D)" )
   A = mfKron(D,Id) + mfKron(Id,D)
   call msDisplay( mfFull(A), "full(A)" )

   ! mfReshape ----------------------------------------------------------
   call print_separation("mfReshape")

   ! --- real case
   allocate( ir(7), jc(7), val(7) )
   ir(:) = [ 1, 3, 1, 2, 2, 1, 3 ]
   jc(:) = [ 1, 1, 2, 2, 3, 4, 4 ]
   val(:) = [ 1, 2, 3, 4, 5, 6, 7 ]

   print "(/,A)", "*** test number 311 ***"
   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )

   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   B = mfReshape(A,4,3)
   call msDisplay( B, "mfReshape(A,4,3)" )
   call msDisplay( mfFull(B), "" )

   print "(/,A)", "*** test number 312 ***"
   B = mfReshape(A,6,MF_EMPTY)
   call msDisplay( B, "mfReshape(A,6,MF_EMPTY)" )
   call msDisplay( mfFull(B), "" )

   print "(/,A)", "*** test number 313 ***"
   B = mfReshape(A,MF_EMPTY,2)
   call msDisplay( B, "mfReshape(A,MF_EMPTY,2)" )
   call msDisplay( mfFull(B), "" )

   ! --- complex case
   allocate( ir(7), jc(7), val(7) )
   ir(:) = [ 1, 3, 1, 2, 2, 1, 3 ]
   jc(:) = [ 1, 1, 2, 2, 3, 4, 4 ]
   val(:) = [ 1, 2, 3, 4, 5, 6, 7 ]

   print "(/,A)", "*** test number 314 ***"
   A = mfSpImport(ir,jc,val) + mfSpEye(3,4)*MF_I
   deallocate( ir, jc, val )

   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   B = mfReshape(A,4,3)
   call msDisplay( B, "mfReshape(A,4,3)" )
   call msDisplay( mfFull(B), "" )

   print "(/,A)", "*** test number 315 ***"
   B = mfReshape(A,6,MF_EMPTY)
   call msDisplay( B, "mfReshape(A,6,MF_EMPTY)" )
   call msDisplay( mfFull(B), "" )

   print "(/,A)", "*** test number 316 ***"
   B = mfReshape(A,MF_EMPTY,2)
   call msDisplay( B, "mfReshape(A,MF_EMPTY,2)" )
   call msDisplay( mfFull(B), "" )

   ! msReshape ----------------------------------------------------------
   call print_separation("msReshape")

   ! --- real case
   allocate( ir(7), jc(7), val(7) )
   ir(:) = [ 1, 3, 1, 2, 2, 1, 3 ]
   jc(:) = [ 1, 1, 2, 2, 3, 4, 4 ]
   val(:) = [ 1, 2, 3, 4, 5, 6, 7 ]

   print "(/,A)", "*** test number 317 ***"
   A = mfSpImport(ir,jc,val)
   deallocate( ir, jc, val )

   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   call msReshape(A,4,3)
   call msDisplay( A, "msReshape(A,4,3)" )
   call msDisplay( mfFull(A), "" )

   ! --- complex case
   allocate( ir(7), jc(7), val(7) )
   ir(:) = [ 1, 3, 1, 2, 2, 1, 3 ]
   jc(:) = [ 1, 1, 2, 2, 3, 4, 4 ]
   val(:) = [ 1, 2, 3, 4, 5, 6, 7 ]

   print "(/,A)", "*** test number 318 ***"
   A = mfSpImport(ir,jc,val) + mfSpEye(3,4)*MF_I
   deallocate( ir, jc, val )

   call msDisplay(A, "A = mfSpImport(ir,jc,val)")
   call msDisplay(mfFull(A), "")

   call msReshape(A,4,3)
   call msDisplay( A, "msReshape(A,4,3)" )
   call msDisplay( mfFull(A), "" )

   ! End of tests ------------------------------------------------------
   print "(A)", "                         ┏━━━━━━━━━━━━━━━━━━━━━━━━━━┓"
   print "(A)", "                         ┃ End of test_mod_sparse_2 ┃"
   print "(A)", "                         ┗━━━━━━━━━━━━━━━━━━━━━━━━━━┛"

   !--------------------------------------------------------------------
99 continue

   print "()"
   call msSetMsgLevel(2)

   call msRelease( A, B, C, v, x, y, d )
   call msRelease( L, U, P, Q, R, RANK, w )
   call msRelease( vec, A_vec, lambda, ind, jnd, flag, tmp )
   call msRelease( R2, Id, E )
   call msFreeMatFactor( factor )
   call msFreeMatFactor( Qhouse )

   ! non official Muesli routine: introduced here to clean memory
   call RngStream_end()

end program
