program test_mod_ops

   use fml

   use test_aux

   use lib_aux

   implicit none

   type(mfArray) :: x, y, z, a, b, c, d
   type(mfArray) :: p, s, set
   integer :: i
   double precision, pointer :: y_ptr(:,:)

   ! Msg level = 3 : all messages are printed (verbose mode)
   !             2 : messages of kind 'ERROR' and 'Warning' are
   !                 printed [default]
   !             1 : only messages of kind 'ERROR' are printed
   !             0 : nothing is printed (quiet mode)
   !                 (pause are ignored !)

!!   call msSetMsgLevel(3)
!!   call msSetTrbLevel("all")

   print "()"

   ! for TRACE_MEM_DEBUG, STDERR must be redirected to STDOUT;
   ! the same thing stands for 'make check'
   call msSetStdIO( stderr=STDOUT )

!!goto 10

   ! to avoid escape sequences of color setting in the output file
   ! (default in "on")
   call msSetColoredMsg( "off" )

   ! VERSIONs ----------------------------------------------------------
   print "()"
   print *, "MF_MUESLI_VERSION = '", MF_MUESLI_VERSION, "'"
   print "()"
   print *, "MF_COMPILER_VERSION = '", MF_COMPILER_VERSION, "'"
   print "()"
   print *, "MF_COMPILATION_CONFIG = '", MF_COMPILATION_CONFIG(), "'"
   print "()"

   ! operator(+) -------------------------------------------------------
   call print_separation("operator(+)")

   ! unary (+)

   x = mf( 1 )
   call msDisplay(x,"x")

   print "(/,A)", "*** test number 1 ***"
   call msDisplay(+ x,"+ x") ! tempo

   print "(/,A)", "*** test number 2 ***"
   y = + x
   call msDisplay(y,"+ x")

   x = mf( (0.0d0,1.0d0) )
   call msDisplay(x,"x")

   print "(/,A)", "*** test number 3 ***"
   y = + x
   call msDisplay(y,"+ x")

   ! binary (+)

   a = mfOnes(3)
   b = mfOnes(3)
   print "(/,A)", "*** test number 4 ***"
   y = a + b                                  ! '+' : std case
   call msDisplay(y,"y = a + b")

   a = mfOnes(3)
   print "(/,A)", "*** test number 5 ***"
   y = a + mfOnes(3)                          ! '+' : non-tempo + tempo
   call msDisplay(y,"y = a + mfOnes(3)")

   b = mfOnes(3)
   print "(/,A)", "*** test number 6 ***"
   y = mfOnes(3) + b                          ! '+' : tempo + non-tempo
   call msDisplay(y,"y = mfOnes(3) + b")

   print "(/,A)", "*** test number 7 ***"
   y = mfOnes(3) + mfOnes(3)                  ! '+' : tempo + tempo
   call msDisplay(y,"mfOnes(3) + mfOnes(3)")

   print "(/,A)", "*** test number 8 ***"
   y = mfOnes(3) + 0.0d0
   call msDisplay(y,"y")

   print "(/,A)", "*** test number 9 ***"
   y = 0.0d0 + mfOnes(3)
   call msDisplay(y,"y")

   print "(/,A)", "*** test number 10 ***"
   y = mfOnes(3) + mf((0.0d0,1.0d0))
   call msDisplay(y,"y")

   print "(/,A)", "*** test number 11 ***"
   y = mf((0.0d0,1.0d0)) + mfOnes(3)
   call msDisplay(y,"y")

   print "(/,A)", "*** test number 12 ***"
   y = mfOnes(3) + (0.0d0,1.0d0)
   call msDisplay(y,"y")

   print "(/,A)", "*** test number 13 ***"
   y = (0.0d0,1.0d0) + mfOnes(3)
   call msDisplay(y,"y")

   print "(/,A)", "*** test number 14 ***"
   y = mfOnes(3) + 0.0
   call msDisplay(y,"y")

   print "(/,A)", "*** test number 15 ***"
   y = 0.0 + mfOnes(3)
   call msDisplay(y,"y")

   ! operator(-) -------------------------------------------------------
   call print_separation("operator(-)")

   ! unary (-)

   x = mf( 1 )
   call msDisplay(x,"x")

   print "(/,A)", "*** test number 16 ***"
   call msDisplay(- x,"- x")

   print "(/,A)", "*** test number 17 ***"
   y = - x
   call msDisplay(y,"- x")

   x = mf( (0.0d0,1.0d0) )
   call msDisplay(x,"x")

   print "(/,A)", "*** test number 18 ***"
   y = - x
   call msDisplay(y,"- x")

   ! binary (-)

   print "(/,A)", "*** test number 19 ***"
   y = mfOnes(3) - mfOnes(3)
   call msDisplay(y,"y")

   print "(/,A)", "*** test number 20 ***"
   y = mfOnes(3) - 0.0d0
   call msDisplay(y,"y")

   print "(/,A)", "*** test number 21 ***"
   y = 0.0d0 - mfOnes(3)
   call msDisplay(y,"y")

   print "(/,A)", "*** test number 22 ***"
   y = mfOnes(3) - mf((0.0d0,1.0d0))
   call msDisplay(y,"y")

   print "(/,A)", "*** test number 23 ***"
   y = mf((0.0d0,1.0d0)) - mfOnes(3)
   call msDisplay(y,"y")

   print "(/,A)", "*** test number 24 ***"
   y = mfOnes(3) - (0.0d0,1.0d0)
   call msDisplay(y,"y")

   print "(/,A)", "*** test number 25 ***"
   y = (0.0d0,1.0d0) - mfOnes(3)
   call msDisplay(y,"y")

   ! operator(*) -------------------------------------------------------
   call print_separation("operator(*)")

   print "(/,A)", "*** test number 26 ***"
   x = mfOnes(2,3)*2.0d0
   call msDisplay(x,"x")

   print "(/,A)", "*** test number 27 ***"
   call msDisplay(x*2.0d0,"x*2.0d0" ) ! mfMul_mfArray_scalar

   print "(/,A)", "*** test number 28 ***"
   call msDisplay(2.0d0*x,"2.0d0*x" ) ! mfMul_scalar_mfArray

   print "(/,A)", "*** test number 29 ***"
   y = mfOnes(2,3)*3.0d0
   call msDisplay(y,"y")
   print "(/,A)", "*** test number 30 ***"
   call msDisplay(x*y,"x*y" ) ! mfMul_mfArray_mfArray

   ! operator(/) -------------------------------------------------------
   call print_separation("operator(/)")

   print "(/,A)", "*** test number 31 ***"
   x = mfOnes(2,3)*3.0d0
   call msDisplay(x,"x")

   print "(/,A)", "*** test number 32 ***"
   call msDisplay(x/2.0d0,"x/2.0d0" ) ! mfDiv_mfArray_scalar

   print "(/,A)", "*** test number 33 ***"
   call msDisplay(2.0d0/x,"2.0d0/x" ) ! mfDiv_scalar_mfArray

   print "(/,A)", "*** test number 34 ***"
   y = mfOnes(2,3)*3.0d0
   call msDisplay(y,"y")
   print "(/,A)", "*** test number 35 ***"
   call msDisplay(x/y,"x/y" ) ! mfDiv_mfArray_mfArray

   ! operator(**) ------------------------------------------------------
   call print_separation("operator(**)")

   x = mfOnes(2,3)*4.0d0
   print "(/,A)", "*** test number 36 ***"
   call msDisplay(x,"x",x**2,"x**2") ! mfPow_mfArray_int (real)

   x = x*MF_I
   print "(/,A)", "*** test number 37 ***"
   call msDisplay(x,"x",x**2,"x**2") ! mfPow_mfArray_int (cmplx)

   x = mfOnes(2,3)*4.0d0
   print "(/,A)", "*** test number 38 ***"
   call msDisplay(x,"x",x**0.5d0,"x**0.5d0") ! mfPow_mfArray_real8 (real)

   x = mfOnes(2,3)*MF_I
   print "(/,A)", "*** test number 39 ***"
   call msDisplay(x,"x",x**0.5d0,"x**0.5d0") ! mfPow_mfArray_real8 (cmplx)

   x = -mfOnes(2,3)
   print "(/,A)", "*** test number 40 ***"
   call msDisplay(x,"x",x**0.5d0,"x**0.5d0") ! mfPow_mfArray_real8 (cmplx)

   x = [ -2.0d0, -1.5d0, -1.0d0, 0.0d0, 1.0d0, 1.5d0, 2.0d0 ]
   print "(/,A)", "*** test number 41 ***"
   call msDisplay(x,"x",2**x,"2**x") ! mfPow_int_mfArray (real)

   x = [ -2.0d0, -1.5d0, -1.0d0, 0.0d0, 1.0d0, 1.5d0, 2.0d0 ]
   print "(/,A)", "*** test number 42 ***"
   call msDisplay(x,"x",(-2)**x,"(-2)**x") ! mfPow_int_mfArray (cmplx)

   x = [ -2.0d0, -1.5d0, -1.0d0, 0.0d0, 1.0d0, 1.5d0, 2.0d0 ]
   print "(/,A)", "*** test number 43 ***"
   call msDisplay(x,"x",2.0d0**x,"2.0d0**x") ! mfPow_real8_mfArray (real)

   x = [ -2.0d0, -1.5d0, -1.0d0, 0.0d0, 1.0d0, 1.5d0, 2.0d0 ]
   print "(/,A)", "*** test number 44 ***"
   call msDisplay(x,"x",(-2.0d0)**x,"(-2.0d0)**x") ! mfPow_real8_mfArray (cmplx)

   A = [ -2.0d0, -1.5d0, -1.0d0, 0.0d0, 1.0d0, 1.5d0, 2.0d0 ]
   B = [ -2.0d0, -1.5d0, -1.0d0, 0.0d0, 1.0d0, 1.5d0, 2.0d0 ]
   print "(/,A)", "*** test number 45 ***"
   call msDisplay(A,"A",B,"B",A**B,"A**B") ! mfPow_mfArray_mfArray (cmplx)

   ! Horiz. Concatenation (.hc.) ---------------------------------------
   call print_separation("Horiz. Concatenation (.hc.)")

   print "(/,A)", "*** test number 46 ***"
   x = [ 1.0d0, 2.0d0 ] .hc. [ 3.0d0, 4.0d0, 5.0d0 ]
   call msDisplay(x,"[ 1.0d0, 2.0d0 ] .hc. [ 3.0d0, 4.0d0, 5.0d0 ]")

   print "(/,A)", "*** test number 47 ***"
   x = mf([ 1.0d0, 2.0d0 ]) .hc. [ 3.0d0, 4.0d0, 5.0d0 ]
   call msDisplay(x,"mf([ 1.0d0, 2.0d0 ]) .hc. [ 3.0d0, 4.0d0, 5.0d0 ]")

   print "(/,A)", "*** test number 48 ***"
   x = [ 1.0d0, 2.0d0 ] .hc. mf([ 3.0d0, 4.0d0, 5.0d0 ])
   call msDisplay(x,"[ 1.0d0, 2.0d0 ] .hc. mf([ 3.0d0, 4.0d0, 5.0d0 ])")

   x = transpose( reshape( [ (-i, i = 1, 6) ], [ 2, 3 ] ) )
   call msDisplay(x,"x")
   y = reshape( [ (i, i = 1, 15) ], [ 3, 5 ] )
   call msDisplay(y,"y")
   print "(/,A)", "*** test number 49 ***"
   z = x .hc. y
   call msDisplay(z,"x .hc. y")

   print "(/,A)", "*** test number 50 ***"
   z = x .hc. MF_EMPTY
   call msDisplay(z,"x .hc. MF_EMPTY")

   print "(/,A)", "*** test number 51 ***"
   z = MF_EMPTY .hc. y
   call msDisplay(z,"MF_EMPTY .hc. y")

   ! Vert. Concatenation (.vc.) ----------------------------------------
   call print_separation("Vert. Concatenation (.vc.)")

   print "(/,A)", "*** test number 52 ***"
   x = [ 1.0d0, 2.0d0, 3.0d0 ] .vc. [ 4.0d0, 5.0d0, 6.d0 ]
   call msDisplay(x,"[ 1.0d0, 2.0d0, 3.0d0 ] .vc. [ 4.0d0, 5.0d0, 6.d0 ]")

   print "(/,A)", "*** test number 53 ***"
   x = transpose( reshape( [ (i, i = 1, 10) ], [ 5, 2 ] ) )
   call msDisplay(x,"x")
   x = x .vc. [ 11.0d0, 12.0d0, 13.d0, 14.d0, 15.d0 ]
   call msDisplay(x,"x .vc. [ 11.0d0, 12.0d0, 13.d0, 14.d0, 15.d0 ]")

   print "(/,A)", "*** test number 54 ***"
   x = transpose( reshape( [ (i, i = 1, 10) ], [ 5, 2 ] ) )
   call msDisplay(x,"x")
   x = [ -4.0d0, -3.0d0, -2.d0, -1.d0, 0.d0 ] .vc. x
   call msDisplay(x,"[ -4.0d0, -3.0d0, -2.d0, -1.d0, 0.d0 ] .vc. x")

   x = transpose( reshape( [ (-i, i = 1, 10) ], [ 5, 2 ] ) )
   call msDisplay(x,"x")
   y = reshape( [ (i, i = 1, 15) ], [ 3, 5 ] )
   call msDisplay(y,"y")
   print "(/,A)", "*** test number 55 ***"
   z = x .vc. y
   call msDisplay(z,"x .vc. y")

   print "(/,A)", "*** test number 56 ***"
   z = x .vc. MF_EMPTY
   call msDisplay(z,"x .vc. MF_EMPTY")

   print "(/,A)", "*** test number 57 ***"
   z = MF_EMPTY .vc. y
   call msDisplay(z,"MF_EMPTY .vc. y")

   ! mfColon -----------------------------------------------------------
   call print_separation("mfColon")

   print "(/,A)", "*** test number 58 ***"
   call msDisplay(mfColon(1,5),"mfColon(1,5)")

   print "(/,A)", "*** test number 59 ***"
   call msDisplay(mfColon(1,15,3),"mfColon(1,15,3)")

   print "(/,A)", "*** test number 60 ***"
   call msDisplay(mfColon(1.0,5.25,0.5),"mfColon(1.0,5.25,0.5)")

   print "(/,A)", "*** test number 61 ***"
   call msDisplay( mfColon(1.0d0,5.0d0,0.3333d0),                       &
                  "mfColon(1.0d0,5.0d0,0.3333d0)")

   print "(/,A)", "*** test number 62 ***"
   call msDisplay( mfColon(1.0d0,5.0d0,0.3333d0,tol=0.01d0),            &
                  "mfColon(1.0d0,5.0d0,0.3333d0,tol=0.01d0)")

   print "(/,A)", "*** test number 63 ***"
   call msDisplay( mfColon(1.0d0,5.0d0,0.3333d0,tol=0.001d0),           &
                  "mfColon(1.0d0,5.0d0,0.3333d0,tol=0.001d0)")

   ! Transpose (.t.) ---------------------------------------------------
   call print_separation("Transpose (.t.)")

   x = reshape( [ (i, i = 1, 10) ], [ 2, 5 ] )
   call msDisplay(x,"x")
   print "(/,A)", "*** test number 64 ***"
   x = .t. x
   call msDisplay(x,".t. x")

   ! .t. operator can also be applied to an ordinary fortran array,
   ! in which case it tranforms it into an mfArray
   print "(/,A)", "*** test number 65 ***"
   call msDisplay(.t.[ 1, 2, 3 ],".t.[ 1, 2, 3 ]")

   print "(/,A)", "*** test number 66 ***"
   call msDisplay(.t.[ 1.0d0, 2.0d0, 3.0d0 ],".t.[ 1.0d0, 2.0d0, 3.0d0 ]")

   print "(/,A)", "*** test number 67 ***"
   x = .t. reshape( [ (i, i = 1, 10) ], [ 2, 5 ] )
   call msDisplay(x,".t. reshape( [ (i, i = 1, 10) ], [ 2, 5 ] )")

   print "(/,A)", "*** test number 68 ***"
   x = .t. reshape( [ (i*1.0d0, i = 1, 10) ], [ 2, 5 ] )
   call msDisplay(x,".t. reshape( [ (i*1.0d0, i = 1, 10) ], [ 2, 5 ] )")

   ! taking the transpose of a complex mfArray raises a warning
   print "(/,A)", "*** test number 69 ***"
   x = [ (1.0d0,1.0d0), (2.0d0,2.0d0) ] .vc.                            &
       [ (3.0d0,3.0d0), (4.0d0,4.0d0) ]
   call msDisplay(x,"x",.t.x,".t. x")

   ! CTranspose (.h.) ---------------------------------------------------
   call print_separation("CTranspose (.h.)")

   print "(/,A)", "*** test number 70 ***"
   x = reshape( [ (i, i = 1, 10) ], [ 2, 5 ] )
   call msDisplay( x, "x", .h. x, ".h. x" )

   ! .h. operator can also be applied to an ordinary complex fortran array,
   ! in which case it tranforms it into an mfArray
   print "(/,A)", "*** test number 71 ***"
   call msDisplay(.h.[ (1.0d0,1.0d0), (2.0d0,2.0d0), (3.0d0,3.0d0) ],   &
                 ".h.[ (1.0d0,1.0d0), (2.0d0,2.0d0), (3.0d0,3.0d0) ]")

   print "(/,A)", "*** test number 72 ***"
   x = [ (1.0d0,1.0d0), (2.0d0,2.0d0) ] .vc.                            &
       [ (3.0d0,3.0d0), (4.0d0,4.0d0) ]
   call msDisplay( x, "x", .h. x, ".h. x" )

   ! mfIsEqual ---------------------------------------------------------
   call print_separation("mfIsEqual")

   ! real8 type with same values
   x = [ 1, 2, 3 ]
   y = x
   print "(/,A)", "*** test number 73 ***"
   if( mfIsEqual(x,y) ) then
      print *, "mfIsEqual test: success"
   else
      print *, "mfIsEqual test: failed"
   end if

   ! real8 type with different values
   print "(/,A)", "*** test number 74 ***"
   if( .not. mfIsEqual( mf([1]), mf([2]) ) ) then
      print *, "mfIsEqual test: success"
   else
      print *, "mfIsEqual test: failed"
   end if

   ! mixed real8-complex with same values
   x = mfOnes(3)
   y = mfComplex(x)
   print "(/,A)", "*** test number 75 ***"
   if( mfIsEqual(x,y) ) then
      print *, "mfIsEqual test: success"
   else
      print *, "mfIsEqual test: failed"
   end if

   ! mixed real8-complex with different values
   x = mfOnes(3)
   y = x*MF_I
   print "(/,A)", "*** test number 76 ***"
   if( .not. mfIsEqual(x,y) ) then
      print *, "mfIsEqual test: success"
   else
      print *, "mfIsEqual test: failed"
   end if

   ! complex type with same values
   x = mfEye(3)*MF_I
   y = x
   print "(/,A)", "*** test number 77 ***"
   if( mfIsEqual(x,y) ) then
      print *, "mfIsEqual test: success"
   else
      print *, "mfIsEqual test: failed"
   end if

   ! complex type with different values
   x = mfEye(3)*MF_I
   y = x + MF_I
   print "(/,A)", "*** test number 78 ***"
   if( .not. mfIsEqual(x,y) ) then
      print *, "mfIsEqual test: success"
   else
      print *, "mfIsEqual test: failed"
   end if

   ! mixed structures (dense/sparse)
   x = mfEye(3)
   y = mfSpEye(3)
   print "(/,A)", "*** test number 79 ***"
   if( mfIsEqual(x,y) ) then
      print *, "mfIsEqual test: success"
   else
      print *, "mfIsEqual test: failed"
   end if

   ! mixed structures (sparse/dense)
   x = mfSpEye(3)
   y = mfEye(3)
   print "(/,A)", "*** test number 80 ***"
   if( mfIsEqual(x,y) ) then
      print *, "mfIsEqual test: success"
   else
      print *, "mfIsEqual test: failed"
   end if

   print "(/,A)", "*** test number 81 ***"
   if( mfIsEqual(MF_COLON,MF_COLON) ) then
      print *, "mfIsEqual test: success"
   else
      print *, "mfIsEqual test: failed"
   end if

   x = MF_COLON
   print "(/,A)", "*** test number 82 ***"
   if( mfIsEqual(x,MF_COLON) ) then
      print *, "mfIsEqual test: success"
   else
      print *, "mfIsEqual test: failed"
   end if
   print "()"

   ! mfIsNotEqual ------------------------------------------------------
   call print_separation("mfIsNotEqual")

   ! real8 type with same values
   x = [ 1, 2, 3 ]
   y = x
   print "(/,A)", "*** test number 83 ***"
   if( .not. mfIsNotEqual(x,y) ) then
      print *, "mfIsNotEqual test: success"
   else
      print *, "mfIsNotEqual test: failed"
   end if

   ! real8 type with different values
   print "(/,A)", "*** test number 84 ***"
   if( mfIsNotEqual( mf([1]), mf([2]) ) ) then
      print *, "mfIsNotEqual test: success"
   else
      print *, "mfIsNotEqual test: failed"
   end if

   ! mixed real8-complex with same values
   x = mfOnes(3)
   y = mfComplex(x)
   print "(/,A)", "*** test number 85 ***"
   if( .not. mfIsNotEqual(x,y) ) then
      print *, "mfIsNotEqual test: success"
   else
      print *, "mfIsNotEqual test: failed"
   end if

   ! mixed real8-complex with different values
   x = mfOnes(3)
   y = x*MF_I
   print "(/,A)", "*** test number 86 ***"
   if( mfIsNotEqual(x,y) ) then
      print *, "mfIsNotEqual test: success"
   else
      print *, "mfIsNotEqual test: failed"
   end if

   ! complex type with same values
   x = mfEye(3)*MF_I
   y = x
   print "(/,A)", "*** test number 87 ***"
   if( .not. mfIsNotEqual(x,y) ) then
      print *, "mfIsNotEqual test: success"
   else
      print *, "mfIsNotEqual test: failed"
   end if

   ! complex type with different values
   x = mfEye(3)*MF_I
   y = x + MF_I
   print "(/,A)", "*** test number 88 ***"
   if( mfIsNotEqual(x,y) ) then
      print *, "mfIsNotEqual test: success"
   else
      print *, "mfIsNotEqual test: failed"
   end if

   print "(/,A)", "*** test number 89 ***"
   if( mfIsNotEqual(MF_COLON,MF_EMPTY) ) then
      print *, "mfIsEqual test: success"
   else
      print *, "mfIsEqual test: failed"
   end if

   x = MF_COLON
   print "(/,A)", "*** test number 90 ***"
   if( mfIsNotEqual(x,MF_EMPTY) ) then
      print *, "mfIsEqual test: success"
   else
      print *, "mfIsEqual test: failed"
   end if
   print "()"

   ! hereafter, we implicitly test boolean's display

   ! operator(==) ------------------------------------------------------
   call print_separation("operator(==)")

   x = mf([ 1, 2, 3 ])
   y = mf([ 3, 2, 1 ])
   call msDisplay( x, "x", y, "y" )
   print "(/,A)", "*** test number 91 ***"
   call msDisplay( x==y, "'x==y'" )

   ! operator(/=) ------------------------------------------------------
   call print_separation("operator(/=)")

   call msDisplay( x, "x", y, "y" )
   print "(/,A)", "*** test number 92 ***"
   call msDisplay( x/=y, "'x/=y'" )

   ! operator(>=) ------------------------------------------------------
   call print_separation("operator(>=)")

   call msDisplay( x, "x", y, "y" )
   print "(/,A)", "*** test number 93 ***"
   call msDisplay( x>=y, "'x>=y'" )

   ! operator(>) -------------------------------------------------------
   call print_separation("operator(>)")

   call msDisplay( x, "x", y, "y" )
   print "(/,A)", "*** test number 94 ***"
   call msDisplay( x>y, "'x>y'" )

   ! operator(<=) ------------------------------------------------------
   call print_separation("operator(<=)")

   call msDisplay( x, "x", y, "y" )
   print "(/,A)", "*** test number 95 ***"
   call msDisplay( x<=y, "'x<=y'" )

   ! operator(<) -------------------------------------------------------
   call print_separation("operator(<)")

   call msDisplay( x, "x", y, "y" )
   print "(/,A)", "*** test number 96 ***"
   call msDisplay( x<y, "'x<y'" )

   ! operator(.not.) ---------------------------------------------------
   call print_separation("operator(.not.)")

   x = mfEye(3)
   x = x == 1.0d0
   call msDisplay( x, "x" )
   print "(/,A)", "*** test number 97 ***"
   call msDisplay( .not. x, "'.not. x'" )

   ! operator(.and.) ---------------------------------------------------
   call print_separation("operator(.and.)")

   y = mfZeros(3)
   call msPointer(y,y_ptr)
   y_ptr(1,3) = 1
   y_ptr(2,2) = 1
   y_ptr(3,1) = 1
   call msFreePointer(y,y_ptr)
   y = y == 1.0d0
   call msDisplay( x, "x", y, "y" )
   print "(/,A)", "*** test number 98 ***"
   call msDisplay( x .and. y, "'x .and. y'" )

   ! operator(.or.) ----------------------------------------------------
   call print_separation("operator(.or.)")

   call msDisplay( x, "x", y, "y" )
   print "(/,A)", "*** test number 99 ***"
   call msDisplay( x .or. y, "'x .or. y'" )

   ! tests on sparse boolean matrices

   x = mf([ 0, 0, 2, 1, 1, 0 ]) .vc.                                    &
       mf([ 3, 0, 1, 0, 0, 2 ]) .vc.                                    &
       mf([ 0, 3, 0, 0, 4, 1 ]) .vc.                                    &
       mf([ 0, 0, 4, 0, 2, 0 ])
   call msDisplay( x, "x (dense)" )
   x = mfSparse( x )

   call msDisplay( x, "x (sparse)" )
   print "(/,A)", "*** test number 100 ***"
   call msDisplay( x == 2.0d0, "x == 2.0d0" )

   print "(/,A)", "*** test number 101 ***"
   call msDisplay( x > 2.0d0, "x > 2.0d0" )

   print "(/,A)", "*** test number 102 ***"
   call msDisplay( x >= 3.0d0, "x >= 3.0d0" )

   x = -x
   call msDisplay( x, "x (sparse)" )
   print "(/,A)", "*** test number 103 ***"
   call msDisplay( x < -2.0d0, "x < -2.0d0" )

   print "(/,A)", "*** test number 104 ***"
   call msDisplay( x <= -3.0d0, "x <= -3.0d0" )

   ! mfAll -------------------------------------------------------------
   call print_separation("mfAll")

   x = mf( [ 1, 2, 3 ] )
   call msDisplay( x, "x" )
   print "(/,A)", "*** test number 105 ***"
   call msDisplay( mfAll(x>2.0d0), "mfAll(x>2.0d0)" )

   x = .t. mf( [ 1, 2, 3 ] )
   call msDisplay( x, "x" )
   print "(/,A)", "*** test number 106 ***"
   call msDisplay( mfAll(x>2.0d0), "mfAll(x>2.0d0)" )

   x = reshape( [ (i, i = 1, 9) ], [ 3, 3 ] )
   call msDisplay( x, "x" )
   print "(/,A)", "*** test number 107 ***"
   call msDisplay( mfAll(x>5.0d0), "mfAll(x>5.0d0)" )
   print "(/,A)", "*** test number 108 ***"
   call msDisplay( mfAll(x>5.0d0,1), "mfAll(x>5.0d0,1)" )

   ! mfAny -------------------------------------------------------------
   call print_separation("mfAny")

   x = mf( [ 1, 2, 3 ] )
   call msDisplay( x, "x" )
   print "(/,A)", "*** test number 109 ***"
   call msDisplay( mfAny(x>2.0d0), "mfAny(x>2.0d0)" )

   x = .t. mf( [ 1, 2, 3 ] )
   call msDisplay( x, "x" )
   print "(/,A)", "*** test number 110 ***"
   call msDisplay( mfAny(x>2.0d0), "mfAny(x>2.0d0)" )

   x = reshape( [ (i, i = 1, 9) ], [ 3, 3 ] )
   call msDisplay( x, "x" )
   print "(/,A)", "*** test number 111 ***"
   call msDisplay( mfAny(x>5.0d0), "mfAny(x>5.0d0)" )
   print "(/,A)", "*** test number 112 ***"
   call msDisplay( mfAny(x>05.0d0,1), "mfAny(x>5.0d0,1)" )

   ! mfMul -------------------------------------------------------------
   call print_separation("mfMul")

   x = mfEye(4)
   call msDisplay( x, "x" )

   print "(/,A)", "*** test number 113 ***"
   y = mfOnes(4,2)
   call msDisplay( y, "y" )
   call msDisplay( mfMul(x,y), "mfMul(x,y)" )

   print "(/,A)", "*** test number 114 ***"
   x = x*MF_I
   call msDisplay( x, "x" )
   call msDisplay( mfMul(x,y), "mfMul(x,y)" )

   ! A'*B
   A = mfOnes(5,3)
   B = mfHilb(5) ! 5 x 5 matrix
   C = (.t. A) .x. B
   print "(/,A)", "*** test number 115 ***"
   call msDisplay( C, "C = (.t. A) .x. B" )
   D = mfMul( A, B, transp=1 )
   call msDisplay( D, "D = A'*B (via mfMul)" )
   call check_small( mfNorm(C-D), "| C - D |", MF_EPS*10 )

   ! A*B'
   A = mfHilb(5) ! 5 x 5 matrix
   B = mfOnes(3,5)
   C = A .x. (.t. B)
   print "(/,A)", "*** test number 116 ***"
   call msDisplay( C, "C = A .x. (.t. B)" )
   D = mfMul( A, B, transp=2 )
   call msDisplay( D, "D = A*B' (via mfMul)" )
   call check_small( mfNorm(C-D), "| C - D |", MF_EPS*10 )

   ! mfCross -----------------------------------------------------------
   call print_separation("mfCross")

   print "(/,A)", "*** test number 117 ***"
   x = [ 1, 0, 0 ]
   y = [ 0, 1, 0 ]
   call msDisplay( x, "x", y, "y" )
   call msDisplay( mfCross(x,y), "mfCross(x,y)" )

   print "(/,A)", "*** test number 118 ***"
   x = .t. x
   y = .t. y
   call msDisplay( x, "x", y, "y" )
   call msDisplay( mfCross(x,y), "mfCross(x,y)" )

   ! mfIsMember --------------------------------------------------------
   call print_separation("mfIsMember")

   print "(/,A)", "*** test number 119 ***"
   a = MF_EMPTY
   set = [ 0, 12, 8, 6, 2, 10, 4 ]
   call msDisplay( a, "a", set, "set" )
   call msDisplay( mfIsMember(a,set), "mfIsMember(a,set)" )

   print "(/,A)", "*** test number 120 ***"
   a = [ 1, 2, 3, 4, 5 ]
   set = MF_EMPTY
   call msDisplay( a,"a",set,"set")
   call msDisplay( mfIsMember(a,set), "mfIsMember(a,set)" )

   print "(/,A)", "*** test number 121 ***"
   a = [ 1, 2, 3, 4, 5 ]
   set = [ 0, 12, 8, 6, 2, 10, 4 ]
   call msDisplay( a, "a", set, "set" )
   call msDisplay( mfIsMember(a,set), "mfIsMember(a,set)" )

   print "(/,A)", "*** test number 122 ***"
   a = mf([ 1, 2, 3 ]) .vc. mf([ 4, 5, 6 ])
   set = [ 0, 12, 8, 6, 2, 10, 4 ]
   call msDisplay( a, "a", set, "set" )
   call msDisplay( mfIsMember(a,set), "mfIsMember(a,set)" )

   print "(/,A)", "*** test number 123 ***"
   a = [ 1, 2, 3, 4, 5 ]
   set = mf([ 0, 12, 8, 6]) .vc. mf([ 2, 10, 4, 14 ])
   call msDisplay( a, "a", set, "set" )
   call msDisplay( mfIsMember(a,set), "mfIsMember(a,set)" )

   print "(/,A)", "*** test number 124 ***"
   a = mf([ 1, 2, 3 ]) .vc. mf([ 4, 5, 6 ])
   set = mf([ 0, 12, 8, 6]) .vc. mf([ 2, 10, 4, 14 ])
   call msDisplay( a, "a", set, "set" )
   call msDisplay( mfIsMember(a,set), "mfIsMember(a,set)" )

   ! 'set' is tempo
   print "(/,A)", "*** test number 125 ***"
   a = [ 1, 2, 3, 4, 5 ]
   call msDisplay( a, "a" )
   call msDisplay( mfIsMember(a,mf([0,12,8,6,2,10,4])),                 &
                  "mfIsMember(a,mf([0,12,8,6,2,10,4]))" )

   ! mfUnique ----------------------------------------------------------
   call print_separation("mfUnique")

   print "(/,A)", "*** test number 126 ***"
   a = [ 2, 4, 6, 8, 9, 8, 7, 1, 5, 3, 6, 2, 4 ]
   call msDisplay( a, "a" )
   call msDisplay( mfUnique(a),                                         &
                  "mfUnique(a)" )

   print "(/,A)", "*** test number 127 ***"
   call msDisplay( mfUnique(a,order="des"),                             &
                  'mfUnique(a,order="des")' )

   print "(/,A)", "*** test number 128 ***"
   call msDisplay( mfUnique(a,order="no",occurrence="first"),           &
                  'mfUnique(a,order="no",occurrence="first")' )

   print "(/,A)", "*** test number 129 ***"
   call msDisplay( mfUnique(a,order="no",occurrence="last"),            &
                  'mfUnique(a,order="no",occurrence="last")' )

   ! mfIntersect -------------------------------------------------------
   call print_separation("mfIntersect")

   print "(/,A)", "*** test number 130 ***"
   A = [ 9, 7, 20, 4, 1, 5, 9, 7, 21, 1, 5, 4, 25 ]
   B = [ 25, 15, 8, 8, 6, 5, 5, 4, 20, 10 ]
   call msDisplay( A, "A", B, "B" )
   call msDisplay( mfIntersect(A,B),                                    &
                  "mfIntersect(A,B)" )

   print "(/,A)", "*** test number 131 ***"
   A = reshape( [ 9, 7, 20, 4, 1, 5, 9, 7, 21, 1, 5, 25 ], [ 3, 4 ] )
   B = reshape( [ 25, 15, 8, 8, 6, 5, 5, 4, 20, 10 ], [ 5, 2 ] )
   call msDisplay( A, "A", B, "B" )
   call msDisplay( mfIntersect(A,B),                                    &
                  "mfIntersect(A,B)" )

   ! mfUnion -----------------------------------------------------------
   call print_separation("mfUnion")

   print "(/,A)", "*** test number 132 ***"
   A = [ 2, 4, 7, 7, 5, 3, 1 ]
   B = [ 1, 2, 5, 8, 10, 5 ]
   call msDisplay( A, "A", B, "B" )
   call msDisplay( mfUnion(A,B),                                        &
                  "mfUnion(A,B)" )

   print "(/,A)", "*** test number 133 ***"
   A = reshape( [ 9, 7, 20, 4, 1, 5, 9, 7, 21, 1, 5, 25 ], [ 3, 4 ] )
   B = reshape( [ 25, 15, 8, 8, 6, 5, 5, 4, 20, 10 ], [ 5, 2 ] )
   call msDisplay( A, "A", B, "B" )
   call msDisplay( mfUnion(A,B),                                        &
                  "mfUnion(A,B)" )

   ! operator(.x.) -----------------------------------------------------
   call print_separation("operator(.x.)")

   print "(/,A)", "*** test number 134 ***"
   A = mfHilb(4)
   B = mfMagic(4)
   call msDisplay( A, "A = mfHilb(4)", B, "B = mfMagic(4)" )
   call msDisplay( A .x. B, "A .x. B" )

   ! mfColPerm ---------------------------------------------------------
   call print_separation("mfColPerm")

   ! real case
   print "(/,A)", "*** test number 135 ***"
   A = mfDiag( mf([1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0 ]) )
   call msDisplay( A, "A" )

   p = [ 1, 3, 5, 2, 4, 6 ]
   call msDisplay(p, "permutation p")

   B = mfColPerm( A, p )
   call msDisplay(B, "mfColPerm(A,p) = A(:,p)")

   ! msColPerm ---------------------------------------------------------
   call print_separation("msColPerm")

   ! real case
   print "(/,A)", "*** test number 136 ***"
   A = mfDiag( mf([1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0 ]) )
   call msDisplay( A, "A" )

   p = [ 1, 3, 5, 2, 4, 6 ]
   call msDisplay(p, "permutation p")

   call msColPerm( A, p )
   call msDisplay(A, "after 'call msColPerm(A,p)': A")

   ! mfRowPerm ---------------------------------------------------------
   call print_separation("mfRowPerm")

   ! real case
   print "(/,A)", "*** test number 137 ***"
   A = mfDiag( mf([1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0 ]) )
   call msDisplay( A, "A" )

   p = [ 1, 3, 5, 2, 4, 6 ]
   call msDisplay(p, "permutation p")

   B = mfRowPerm( A, p )
   call msDisplay(B, "mfRowPerm(A,p) = A(p,:)")

   ! msRowPerm ---------------------------------------------------------
   call print_separation("msRowPerm")

   ! real case
   print "(/,A)", "*** test number 138 ***"
   A = mfDiag( mf([1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0 ]) )
   call msDisplay( A, "A" )

   p = [ 1, 3, 5, 2, 4, 6 ]
   call msDisplay(p, "permutation p")

   call msRowPerm( A, p )
   call msDisplay(A, "after 'call msRowPerm(A,p)': A")

   ! mfColScale --------------------------------------------------------
   call print_separation("mfColScale")

   ! real case
   print "(/,A)", "*** test number 139 ***"
   A = mfDiag( mf([1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0 ]) )
   call msDisplay( A, "A" )

   s = [ 3.5d0, 3.0d0, 2.5d0, 2.0d0, 1.5d0, 1.0d0 ]
   call msDisplay(s, "scaling s")

   B = mfColScale( A, s )
   call msDisplay(B, "mfColScale(A,s)")

   ! msColScale --------------------------------------------------------
   call print_separation("msColScale")

   ! real case
   print "(/,A)", "*** test number 140 ***"
   A = mfDiag( mf([1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0 ]) )
   call msDisplay( A, "A" )

   s = [ 3.5d0, 3.0d0, 2.5d0, 2.0d0, 1.5d0, 1.0d0 ]
   call msDisplay(s, "scaling s")

   call msColScale( A, s )
   call msDisplay(A, "after 'call msColScale(A,s)': A")

   ! mfRowScale --------------------------------------------------------
   call print_separation("mfRowScale")

   ! real case
   print "(/,A)", "*** test number 141 ***"
   A = mfDiag( mf([1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0 ]) )
   call msDisplay( A, "A" )

   s = [ 3.5d0, 3.0d0, 2.5d0, 2.0d0, 1.5d0, 1.0d0 ]
   call msDisplay(s, "scaling s")

   B = mfRowScale( A, s )
   call msDisplay(B, "mfRowScale(A,s)")

   ! msRowScale --------------------------------------------------------
   call print_separation("msRowScale")

   ! real case
   print "(/,A)", "*** test number 142 ***"
   A = mfDiag( mf([1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0 ]) )
   call msDisplay( A, "A" )

   s = [ 3.5d0, 3.0d0, 2.5d0, 2.0d0, 1.5d0, 1.0d0 ]
   call msDisplay(s, "scaling s")

   call msRowScale( A, s )
   call msDisplay(A, "after 'call msRowScale(A,s)': A")

   ! msColAutoScale ----------------------------------------------------
   call print_separation("msColAutoScale")

   ! real case
   print "(/,A)", "*** test number 143 ***"
   A = mfDiag( mf([1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0 ]) )
   call msSet( 2.0d0, A, 6, 1 )
   call msSet( 12.0d0, A, 1, 6 )
   call msDisplay( A, "A" )

   call msColAutoScale( mfOut(s), A )
   call msDisplay(A, "after 'call msColAutoScale(mfOut(s),A)': A",      &
                  s, "scaling used")

   ! msRowAutoScale ----------------------------------------------------
   call print_separation("msRowAutoScale")

   ! real case
   print "(/,A)", "*** test number 144 ***"
   A = mfDiag( mf([1.0d0, 2.0d0, 3.0d0, 4.0d0, 5.0d0, 6.0d0 ]) )
   call msSet( 2.0d0, A, 6, 1 )
   call msSet( 12.0d0, A, 1, 6 )
   call msDisplay( A, "A" )

   call msRowAutoScale( mfOut(s), A )
   call msDisplay(A, "after 'call msRowAutoScale(mfOut(s),A)': A",      &
                  s, "scaling used")

   ! End of tests ------------------------------------------------------
   print "(A)", "                         ┏━━━━━━━━━━━━━━━━━━━━━┓"
   print "(A)", "                         ┃ End of test_mod_ops ┃"
   print "(A)", "                         ┗━━━━━━━━━━━━━━━━━━━━━┛"

   !--------------------------------------------------------------------
99 continue

   print "()"
   call msSetMsgLevel(2)

   call msRelease( x, y, z, a, b, c, d )
   call msRelease( p, s, set )

end program
