program test_mod_elmat

   use fml

   use test_aux
   use lib_aux

   implicit none

   type(mfArray) :: x, y, A, B, C, Ap, Bp, R, v, mask, p, seed
   real(kind=MF_DOUBLE) :: condA, norm, mean, mean_theo, var, var_theo
   integer :: i, MsgLevel_save, n
   integer, allocatable :: ivec(:)

   ! Msg level = 3 : all messages are printed (verbose mode)
   !             2 : messages of kind 'ERROR' and 'Warning' are
   !                 printed [default]
   !             1 : only messages of kind 'ERROR' are printed
   !             0 : nothing is printed (quiet mode)
   !                 (pause are ignored !)

!!   call msSetMsgLevel(3)
!!   call msSetTrbLevel("all")

   print "()"

   ! for TRACE_MEM_DEBUG, STDERR must be redirected to STDOUT;
   ! the same thing stands for 'make check'
   call msSetStdIO( stderr=STDOUT )

!!goto 10

   ! to avoid escape sequences of color setting in the output file
   ! (default in "on")
   call msSetColoredMsg( "off" )

   ! VERSIONs ----------------------------------------------------------
   print "()"
   print *, "MF_MUESLI_VERSION = '", MF_MUESLI_VERSION, "'"
   print "()"
   print *, "MF_COMPILER_VERSION = '", MF_COMPILER_VERSION, "'"
   print "()"
   print *, "MF_COMPILATION_CONFIG = '", MF_COMPILATION_CONFIG(), "'"
   print "()"

   ! mfEye -------------------------------------------------------------
   call print_separation("mfEye")

   print "(/,A)", "*** test number 1 ***"
   call msDisplay(mfEye(3),"mfEye(3)")

   print "(/,A)", "*** test number 2 ***"
   call msDisplay(mfEye(3,3),"mfEye(3,3)")

   print "(/,A)", "*** test number 3 ***"
   call msDisplay(mfEye(3,4),"mfEye(3,4)")

   print "(/,A)", "*** test number 4 ***"
   call msDisplay(mfEye(4,3),"mfEye(4,3)")

   ! mfLinspace --------------------------------------------------------
   call print_separation("mfLinspace")

   print "(/,A)", "*** test number 5 ***"
   call msDisplay( mfLinspace(-MF_PI, MF_PI, 5),                        &
                  "mfLinspace(-MF_PI, MF_PI, 5)")

   print "(/,A)", "*** test number 6 ***"
   call msDisplay( mfLinSpace(end=1.0, nval=5, step=0.1),               &
                  "mfLinSpace(end=1.0, nval=5, step=0.1)" )

   print "(/,A)", "*** test number 7 ***"
   call msDisplay( mfLinSpace(end=1.0d0, nval=5, step=0.1d0),           &
                  "mfLinSpace(end=1.0d0, nval=5, step=0.1d0)" )

   ! mfLogspace --------------------------------------------------------
   call print_separation("mfLogspace")

   print "(/,A)", "*** test number 8 ***"
   call msDisplay(mfLogspace(0.0d0, 5.0d0, 6),"mfLogspace(0.0d0, 5.0d0, 6)")

   print "(/,A)", "*** test number 9 ***"
   call msDisplay( mfLogSpace(start=0.0, nval=6, step=0.5),             &
                  "mfLogSpace(start=0.0, nval=6, step=0.5)" )

   print "(/,A)", "*** test number 10 ***"
   call msDisplay( mfLogSpace(start=0.0d0, nval=6, step=0.5d0),         &
                  "mfLogSpace(start=0.0d0, nval=6, step=0.5d0)" )

   ! mfOnes ------------------------------------------------------------
   call print_separation("mfOnes")

   print "(/,A)", "*** test number 11 ***"
   call msDisplay(mfOnes(3),"mfOnes(3)")

   print "(/,A)", "*** test number 12 ***"
   call msDisplay(mfOnes(4,2),"mfOnes(4,2)")

   ! mfRand, msRand ----------------------------------------------------
   call print_separation("mfRand, msRand")

   print "(/,A)", "*** test number 13 ***"
   v = mfRand(3)
   call msDisplay(v,"v = mfRand(3)")

   print "(/,A)", "*** test number 14 ***"
   x = mfRand(4,3)
   call msDisplay(x,"mfRand(4,3)")

   ! get the seed
   print "(/,A)", "*** test number 15 ***"
   seed = mfRand( "seed" )
   call msDisplay(seed,"seed = mfRand('seed')")

   ! set the seed with values from internal clock
   call msRand()
   x = mfRand(3) ! no output

   ! reset the seed with values from previous seed
   call msRand(seed)
   x = mfRand(3)
   call msDisplay( x, "x = mfRand(3)" )

   print "(/,A)", "*** test number 16 ***"
   print *, "  x (from test number 9) and v (from test number 11) should have "
   print *, "  the same elements ..."
   if( mfDble(mfNorm(x-v)) > 1.0d-13 ) then
      print *, "     *** test failed ***"
   else
      print *, "     Ok"
   end if
   print "()"

   ! set the seed with values from internal clock
   call msRand()

   ! check the uniform distribution
   print "(/,A)", "*** test number 17 ***"
   mean_theo = 0.5d0
   print "(A,F5.3)", "  Mean of the uniform distribution should be equal to ", &
                     mean_theo
   n = 100000
   x = mfRand(n,1)
   mean = mfMean(x)
   if( abs(mean-mean_theo) > 5.0d-3*mean ) then
      print *, "     *** test failed ***"
      print "(A,F5.3,A)", "      (mean = ", mean, ")"
   else
      print *, "     Ok"
   end if
   print "()"

   print "(/,A)", "*** test number 18 ***"
   var_theo = 1.0d0/12.0d0
   print "(A,F7.5)", "  Variance of the uniform distribution should be equal to ", &
                     var_theo
   var = mfMean(x**2) - mean**2
   if( abs(var-var_theo) > 1.0d-2*var ) then
      print *, "     *** test failed ***"
      print "(A,F7.5,A)", "      (variance = ", var, ")"
   else
      print *, "     Ok"
   end if
   print "()"

   ! reset the seed with values from previous seed
   call msRand(seed)

   ! mfRandN -----------------------------------------------------------
   call print_separation("mfRandN")

   print "(/,A)", "*** test number 19 ***"
   x = mfRandN(3)
   call msDisplay(x,"mfRandN(3)")

   print "(/,A)", "*** test number 20 ***"
   x = mfRandN(3,5)
   call msDisplay(x,"mfRandN(3,5)")

   ! save the seed
   seed = mfRand( "seed" )

   ! set the seed with values from internal clock
   call msRand()

   ! check the uniform distribution
   print "(/,A)", "*** test number 21 ***"
   mean_theo = 0.0d0
   print "(A,F5.3)", "  Mean of the gaussian distribution should be equal to ", &
                     mean_theo
   n = 100000
   x = mfRandN(n,1)
   mean = mfMean(x)
   if( abs(mean-mean_theo) > 1.0d-2 ) then
      print *, "     *** test failed ***"
      print "(A,F5.3,A)", "      (mean = ", mean, ")"
   else
      print *, "     Ok"
   end if
   print "()"

   print "(/,A)", "*** test number 22 ***"
   var_theo = 1.0d0
   print "(A,F7.5)", "  Variance of the gaussian distribution should be equal to ", &
                     var_theo
   var = mfMean(x**2) - mean**2
   if( abs(var-var_theo) > 2.0d-2*var ) then
      print *, "     *** test failed ***"
      print "(A,F7.5,A)", "      (variance = ", var, ")"
   else
      print *, "     Ok"
   end if
   print "()"

   ! reset the seed with values from previous seed
   call msRand(seed)

   ! mfRandPoiss -------------------------------------------------------
   call print_separation("mfRandPoiss")

   ! small value for mean (threshold is 12.)
   print "(/,A)", "*** test number 23 ***"
   x = mfRandPoiss(10.0d0, 3)
   call msDisplay(x,"mfRandPoiss(10.0d0, 3)")

   print "(/,A)", "*** test number 24 ***"
   x = mfRandPoiss(10.0d0, 3,5)
   call msDisplay(x,"mfRandPoiss(10.0d0, 3,5)")

   ! large value for mean
   print "(/,A)", "*** test number 25 ***"
   x = mfRandPoiss(1.0d4, 3)
   call msDisplay(x,"mfRandPoiss(1.0d4, 3)")

   print "(/,A)", "*** test number 26 ***"
   x = mfRandPoiss(1.0d4, 3,5)
   call msDisplay(x,"mfRandPoiss(1.0d4, 3,5)")

   ! save the seed
   seed = mfRand( "seed" )

   ! set the seed with values from internal clock
   call msRand()

   ! check the uniform distribution
   print "(/,A)", "*** test number 27 ***"
   mean_theo = 5.0d0
   print "(A,F5.3)", "  Mean of the Poisson distribution should be equal to ", &
                     mean_theo
   n = 100000
   x = mfRandPoiss(mean_theo,n,1)
   mean = mfMean(x)
   if( abs(mean-mean_theo) > 5.0d-2 ) then
      print *, "     *** test failed ***"
      print "(A,F5.3,A)", "      (mean = ", mean, ")"
   else
      print *, "     Ok"
   end if
   print "()"

   print "(/,A)", "*** test number 28 ***"
   var_theo = mean_theo
   print "(A,F5.3)", "  Variance of the Poisson distribution should be equal to ", &
                     var_theo
   var = mfMean(x**2) - mean**2
   if( abs(var-var_theo) > 5.0d-2*var ) then
      print *, "     *** test failed ***"
      print "(A,F5.3,A)", "      (variance = ", var, ")"
   else
      print *, "     Ok"
   end if
   print "()"

   ! reset the seed with values from previous seed
   call msRand(seed)

   ! mfZeros -----------------------------------------------------------
   call print_separation("mfZeros")

   print "(/,A)", "*** test number 29 ***"
   call msDisplay(mfZeros(3),"mfZeros(3)")

   print "(/,A)", "*** test number 30 ***"
   call msDisplay(mfZeros(3,4),"mfZeros(3,4)")

   ! mfHilb ------------------------------------------------------------
   call print_separation("mfHilb")

   print "(/,A)", "*** test number 31 ***"
   A = mfHilb(5)
   call msDisplay(A,"A = mfHilb(5)")
   condA = mfDble( mfCond(A) )
   call msDisplay(condA,"cond(A)")

   ! mfInvHilb ---------------------------------------------------------
   call print_separation("mfInvHilb")

   print "(/,A)", "*** test number 32 ***"
   B = mfInvHilb(5)
   call msDisplay(B,"B = mfInvHilb(5)")

   norm = mfDble( mfNorm(mfEye(5) - mfMul(A,B)) )
   if( norm < MF_EPS*condA ) then
      print *, "ok    : | mfEye(5) - mfMul(A,B) | < MF_EPS*cond(A)"
   else
      print *, "wrong : | mfEye(5) - mfMul(A,B) | > MF_EPS*cond(A)"
   end if
   print "()"

   ! mfVander ----------------------------------------------------------
   call print_separation("mfVander")

   print "(/,A)", "*** test number 33 ***"
   ! real case
   x = [ 1, 2, 3, 4, 5 ]
   call msDisplay(x,"x")
   A = mfVander(x)
   call msDisplay(A,"A = mfVander(x)")
   print "(/,A)", "*** test number 34 ***"
   A = mfVander(x,3)
   call msDisplay(A,"A = mfVander(x,3)")

   print "(/,A)", "*** test number 35 ***"
   x = .t. x
   call msDisplay(x,"x")
   A = mfVander(x)
   call msDisplay(A,"A = mfVander(x)")
   print "(/,A)", "*** test number 36 ***"
   A = mfVander(x,3)
   call msDisplay(A,"A = mfVander(x,3)")

   print "(/,A)", "*** test number 37 ***"
   ! complex case
   MsgLevel_save = mfGetMsgLevel()
   call msSetMsgLevel(1)
   x = .t. mf( [ (1.,0.), (0.,1.), (-1.,0.), (0.,-1.) ] )
   call msSetMsgLevel(MsgLevel_save)
   call msDisplay(x,"x")
   A = mfVander(x)
   call msDisplay(A,"A = mfVander(x)")
   print "(/,A)", "*** test number 38 ***"
   A = mfVander(x,3)
   call msDisplay(A,"A = mfVander(x,3)")

   ! mfDiag ------------------------------------------------------------
   call print_separation("mfDiag")

   ! construct a matrix from a vector
   !   real case
   print "(/,A)", "*** test number 39 ***"
   a = [ 1, 2, 3 ]
   call msDisplay(a,"a",mfDiag(a),"mfDiag(a)")

   print "(/,A)", "*** test number 40 ***"
   call msDisplay(mfDiag(a,2),"mfDiag(a,2)")

   print "(/,A)", "*** test number 41 ***"
   call msDisplay(mfDiag(a,-2),"mfDiag(a,-2)")

   print "(/,A)", "*** test number 42 ***"
   a = .t. mf( [ 1, 2, 3 ] )
   call msDisplay(a,"a",mfDiag(a),"mfDiag(a)")

   print "(/,A)", "*** test number 43 ***"
   call msDisplay(mfDiag(a,2),"mfDiag(a,2)")

   print "(/,A)", "*** test number 44 ***"
   call msDisplay(mfDiag(a,-2),"mfDiag(a,-2)")

   !   complex case
   print "(/,A)", "*** test number 45 ***"
   a = [ 1, 2, 3 ]*MF_I
   call msDisplay(a,"a",mfDiag(a),"mfDiag(a)")

   print "(/,A)", "*** test number 46 ***"
   call msDisplay(mfDiag(a,2),"mfDiag(a,2)")

   print "(/,A)", "*** test number 47 ***"
   call msDisplay(mfDiag(a,-2),"mfDiag(a,-2)")

   print "(/,A)", "*** test number 48 ***"
   a = .t. mf( [ 1, 2, 3 ] )*MF_I
   call msDisplay(a,"a",mfDiag(a),"mfDiag(a)")

   print "(/,A)", "*** test number 49 ***"
   call msDisplay(mfDiag(a,2),"mfDiag(a,2)")

   print "(/,A)", "*** test number 50 ***"
   call msDisplay(mfDiag(a,-2),"mfDiag(a,-2)")

   ! extract a vector from a matrix
   !   real case
   print "(/,A)", "*** test number 51 ***"
   a = reshape( [ (i, i = 1, 20) ], [ 4, 5 ] )
   call msDisplay(a,"a",mfDiag(a),"mfDiag(a)")

   print "(/,A)", "*** test number 52 ***"
   call msDisplay(mfDiag(a,2),"mfDiag(a,2)")

   print "(/,A)", "*** test number 53 ***"
   call msDisplay(mfDiag(a,-2),"mfDiag(a,-2)")

   print "(/,A)", "*** test number 54 ***"
   a = reshape( [ (i, i = 1, 20) ], [ 5, 4 ] )
   call msDisplay(a,"a",mfDiag(a),"mfDiag(a)")

   print "(/,A)", "*** test number 55 ***"
   call msDisplay(mfDiag(a,2),"mfDiag(a,2)")

   print "(/,A)", "*** test number 56 ***"
   call msDisplay(mfDiag(a,-2),"mfDiag(a,-2)")

   !   complex case
   print "(/,A)", "*** test number 57 ***"
   a = reshape( [ (i*MF_I, i = 1, 20) ], [ 4, 5 ] )
   call msDisplay(a,"a",mfDiag(a),"mfDiag(a)")

   print "(/,A)", "*** test number 58 ***"
   call msDisplay(mfDiag(a,2),"mfDiag(a,2)")

   print "(/,A)", "*** test number 59 ***"
   call msDisplay(mfDiag(a,-2),"mfDiag(a,-2)")

   print "(/,A)", "*** test number 60 ***"
   a = reshape( [ (i*MF_I, i = 1, 20) ], [ 5, 4 ] )
   call msDisplay(a,"a",mfDiag(a),"mfDiag(a)")

   print "(/,A)", "*** test number 61 ***"
   call msDisplay(mfDiag(a,2),"mfDiag(a,2)")

   print "(/,A)", "*** test number 62 ***"
   call msDisplay(mfDiag(a,-2),"mfDiag(a,-2)")

   ! msDiag ------------------------------------------------------------
   call print_separation("msDiag")

   ! real/real case
   print "(/,A)", "*** test number 63 ***"
   A = mfZeros(4,5)
   call msDisplay(A,"A")

   print "(/,A)", "*** test number 64 ***"
   v = [ 1, 2, 3, 4 ]
   call msDisplay(v,"v")
   call msDiag( A, v ) ! d=0
   call msDisplay(A,"A")

   print "(/,A)", "*** test number 65 ***"
   v = [ 5, 6, 7, 8 ]
   call msDisplay(v,"v")
   call msDiag( A, v, d=1 )
   call msDisplay(A,"A")

   print "(/,A)", "*** test number 66 ***"
   v = [ 9, 10, 11 ]
   call msDisplay(v,"v")
   call msDiag( A, v, d=2 )
   call msDisplay(A,"A")

   print "(/,A)", "*** test number 67 ***"
   v = [ 14 ]
   call msDisplay(v,"v")
   call msDiag( A, v, d=4 )
   call msDisplay(A,"A")

   print "(/,A)", "*** test number 68 ***"
   v = - [ 5, 6, 7 ]
   call msDisplay(v,"v")
   call msDiag( A, v, d=-1 )
   call msDisplay(A,"A")

   print "(/,A)", "*** test number 69 ***"
   v = - [ 10 ]
   call msDisplay(v,"v")
   call msDiag( A, v, d=-3 )
   call msDisplay(A,"A")

   print "(/,A)", "*** test number 70 ***"
   v = [ 12, 13 ]
   v = .t. v
   call msDisplay(v,"v")
   call msDiag( A, v, d=3 )
   call msDisplay(A,"A")

   print "(/,A)", "*** test number 71 ***"
   v = - [ 8, 9 ]
   v = .t. v
   call msDisplay(v,"v")
   call msDiag( A, v, d=-2 )
   call msDisplay(A,"A")

   print "(/,A)", "*** test number 72 ***"
   A = mfZeros(5,4)
   call msDisplay(A,"A")

   v = - [ 1, 2, 3, 4 ]
   call msDisplay(v,"v")
   call msDiag( A, v )
   call msDisplay(A,"A")

   print "(/,A)", "*** test number 73 ***"
   v = - [ 5, 6, 7, 8 ]
   v = .t. v
   call msDisplay(v,"v")

   call msDiag( A, v )
   call msDisplay(A,"A")

   ! real/complex case
   print "(/,A)", "*** test number 74 ***"
   A = mfOnes(4,5)
   call msDisplay(A,"A")
   v = [ 1, 2, 3, 4 ]
   v = MF_I*v
   call msDisplay(v,"v")

   call msDiag( A, v )
   call msDisplay(A,"A")

   print "(/,A)", "*** test number 75 ***"
   A = mfOnes(4,5)
   v = [ 5, 6, 7, 8 ]
   v = MF_I*(.t. v)
   call msDisplay(v,"v")

   call msDiag( A, v )
   call msDisplay(A,"A")

   print "(/,A)", "*** test number 76 ***"
   A = mfOnes(5,4)
   call msDisplay(A,"A")
   v = [ 1, 2, 3, 4 ]
   v = MF_I*v
   call msDisplay(v,"v")

   call msDiag( A, v )
   call msDisplay(A,"A")

   print "(/,A)", "*** test number 77 ***"
   A = mfOnes(5,4)
   v = [ 5, 6, 7, 8 ]
   v = MF_I*(.t. v)
   call msDisplay(v,"v")

   call msDiag( A, v )
   call msDisplay(A,"A")

   ! complex/real case
   print "(/,A)", "*** test number 78 ***"
   A = mfOnes(4,5)*MF_I
   call msDisplay(A,"A")
   v = [ 1, 2, 3, 4 ]
   call msDisplay(v,"v")

   call msDiag( A, v )
   call msDisplay(A,"A")

   print "(/,A)", "*** test number 79 ***"
   v = [ 5, 6, 7, 8 ]
   v = .t. v
   call msDisplay(v,"v")

   call msDiag( A, v )
   call msDisplay(A,"A")

   print "(/,A)", "*** test number 80 ***"
   A = mfOnes(5,4)*MF_I
   call msDisplay(A,"A")
   v = [ 1, 2, 3, 4 ]
   call msDisplay(v,"v")

   call msDiag( A, v )
   call msDisplay(A,"A")

   print "(/,A)", "*** test number 81 ***"
   v = [ 5, 6, 7, 8 ]
   v = .t. v
   call msDisplay(v,"v")

   call msDiag( A, v )
   call msDisplay(A,"A")

   ! complex/complex case
   print "(/,A)", "*** test number 82 ***"
   A = mfOnes(4,5)*MF_I
   call msDisplay(A,"A")
   v = [ 1, 2, 3, 4 ]
   v = MF_I*v
   call msDisplay(v,"v")

   call msDiag( A, v )
   call msDisplay(A,"A")

   print "(/,A)", "*** test number 83 ***"
   v = [ 5, 6, 7, 8 ]
   v = MF_I*(.t. v)
   call msDisplay(v,"v")

   call msDiag( A, v )
   call msDisplay(A,"A")

   print "(/,A)", "*** test number 84 ***"
   A = mfOnes(5,4)*MF_I
   call msDisplay(A,"A")
   v = [ 1, 2, 3, 4 ]
   v = MF_I*v
   call msDisplay(v,"v")

   call msDiag( A, v )
   call msDisplay(A,"A")

   print "(/,A)", "*** test number 85 ***"
   v = [ 5, 6, 7, 8 ]
   v = MF_I*(.t. v)
   call msDisplay(v,"v")

   call msDiag( A, v )
   call msDisplay(A,"A")

   ! mfBlkDiag ---------------------------------------------------------
   call print_separation("mfBlkDiag")

   ! special cases where A or B is empty (temporary or not)
   print "(/,A)", "*** test number 86 ***"
   A = mfEye(2,2)
   call msDisplay(A,"A")
   B = MF_EMPTY

   C = mfBlkDiag(A,B)
   call msDisplay(C,"blkdiag(A,B)")

   print "(/,A)", "*** test number 87 ***"
   B = MF_EMPTY

   C = mfBlkDiag(mfEye(2,2),B)
   call msDisplay(C,"blkdiag(A,B)")

   ! real/real case only (other types are handled by .hc. and .vc.)
   print "(/,A)", "*** test number 88 ***"
   A = reshape( [ (i, i = 1, 9) ], [ 3, 3 ] )
   call msDisplay(A,"A")
   B = mfEye(2,2)
   call msDisplay(B,"B")

   C = mfBlkDiag(A,B)
   call msDisplay(C,"blkdiag(A,B)")

   print "(/,A)", "*** test number 89 ***"
   A = mfRot90(mfEye(3,3))
   call msDisplay(A,"A")

   call msDisplay( mfBlkDiag(A,3), "blkdiag(A,3)" )

   ! mfReshape ---------------------------------------------------------
   call print_separation("mfReshape")

   !-- real case
   print "(/,A)", "*** test number 90 ***"
   x = reshape( [ (i, i = 1, 12) ], [ 4, 3 ] )
   call msDisplay(x,"x")
   call msDisplay(mfReshape(x, 2, 6 ),"mfReshape(x, 2, 6 )")

   print "(/,A)", "*** test number 91 ***"
   call msDisplay(mfReshape(x, MF_EMPTY, 6 ),"mfReshape(x, [], 6 )")

   print "(/,A)", "*** test number 92 ***"
   call msDisplay(mfReshape(x, 2, MF_EMPTY ),"mfReshape(x, 2, [] )")

   !-- complex case
   print "(/,A)", "*** test number 93 ***"
   x = reshape( [ (i, i = 1, 12) ], [ 4, 3 ] )
   x = x + MF_I*mfEye(4,3)
   call msDisplay(x,"x")
   call msDisplay(mfReshape(x, 6, 2 ),"mfReshape(x, 6, 2 )")

   print "(/,A)", "*** test number 94 ***"
   call msDisplay(mfReshape(x, MF_EMPTY, 2 ),"mfReshape(x, [], 2 )")

   print "(/,A)", "*** test number 95 ***"
   call msDisplay(mfReshape(x, 6, MF_EMPTY ),"mfReshape(x, 6, [] )")

   ! msReshape ---------------------------------------------------------
   call print_separation("msReshape")

   print "(/,A)", "*** test number 96 ***"
   x = reshape( [ (i, i = 1, 12) ], [ 4, 3 ] )
   call msDisplay(x,"x")
   call msReshape(x, 2, 6)
   call msDisplay(x,"call msReshape(%, 2, 6 )")

   ! mfMagic -----------------------------------------------------------
   call print_separation("mfMagic")

   print *, "(see also properties in 'test_mod_datafun')"

   print "(/,A)", "*** test number 97 ***"
   call msDisplay(mfMagic(3),"mfMagic(3)")

   print "(/,A)", "*** test number 98 ***"
   call msDisplay(mfMagic(4),"mfMagic(4)")

   print "(/,A)", "*** test number 99 ***"
   call msDisplay(mfMagic(5),"mfMagic(5)")

   print "(/,A)", "*** test number 100 ***"
   call msDisplay(mfMagic(6),"mfMagic(6)")

   ! mfRepmat ----------------------------------------------------------
   call print_separation("mfRepmat")

   print "(/,A)", "*** test number 101 ***"
   x = mf( [ (i, i = 1, 6) ] )
   call msDisplay(x,"x",mfRepmat(x,4,1),"mfRepmat(x,4,1)")

   print "(/,A)", "*** test number 102 ***"
   x = reshape( [ (i, i = 1, 6) ], [ 2, 3 ] )
   call msDisplay(x,"x",mfRepmat(x,3,2),"mfRepmat(x,3,2)")

   ! msMeshGrid --------------------------------------------------------
   call print_separation("msMeshGrid")

   print "(/,A)", "*** test number 103 ***"
   a =     mfLinspace( -1.0d0, 1.0d0, 5 )
   b = .t. mfLinspace( -1.5d0, 1.5d0, 7 )
   call msMeshGrid( mfOut(x,y), a, b )
   call msDisplay( x, "x", y, "y" )

   ! mfTril ------------------------------------------------------------
   call print_separation("mfTril")

   print "(/,A)", "*** test number 104 ***"
   A = mfTril(mfOnes(3,3))
   call msDisplay( A, "mfTril(mfOnes(3,3))" )
   print *, "mfIsTril(A) : ", mfIsTril(A)
   print *, "mfIsTriu(A) : ", mfIsTriu(A)

   print "(/,A)", "*** test number 105 ***"
   x = mf( reshape( [ (i,i=1,16) ], [ 4, 4 ] ) )
   call msDisplay(x,"x")
   call msDisplay(mfTril(x),"mfTril(x)")
   print "(/,A)", "*** test number 106 ***"
   call msDisplay(mfTril(x,1),"mfTril(x,1)")
   print "(/,A)", "*** test number 107 ***"
   call msDisplay(mfTril(x,3),"mfTril(x,3)")
   print "(/,A)", "*** test number 108 ***"
   call msDisplay(mfTril(x,-3),"mfTril(x,-3)")
   print "(/,A)", "*** test number 109 ***"
   call msDisplay(mfTril(x,-4),"mfTril(x,-4)")

   print "(/,A)", "*** test number 110 ***"
   x = mf( reshape( [ (i,i=1,15) ], [ 5, 3 ] ) )
   call msDisplay(x,"x")
   call msDisplay(mfTril(x),"mfTril(x)")
   print "(/,A)", "*** test number 111 ***"
   call msDisplay(mfTril(x,1),"mfTril(x,1)")
   print "(/,A)", "*** test number 112 ***"
   call msDisplay(mfTril(x,2),"mfTril(x,2)")
   print "(/,A)", "*** test number 113 ***"
   call msDisplay(mfTril(x,-4),"mfTril(x,-4)")
   print "(/,A)", "*** test number 114 ***"
   call msDisplay(mfTril(x,-5),"mfTril(x,-5)")

   print "(/,A)", "*** test number 115 ***"
   x = mf( reshape( [ (i,i=1,15) ], [ 3, 5 ] ) )
   call msDisplay(x,"x")
   call msDisplay(mfTril(x),"mfTril(x)")
   print "(/,A)", "*** test number 116 ***"
   call msDisplay(mfTril(x,1),"mfTril(x,1)")
   print "(/,A)", "*** test number 117 ***"
   call msDisplay(mfTril(x,4),"mfTril(x,4)")
   print "(/,A)", "*** test number 118 ***"
   call msDisplay(mfTril(x,-2),"mfTril(x,-2)")
   print "(/,A)", "*** test number 119 ***"
   call msDisplay(mfTril(x,-3),"mfTril(x,-3)")

   ! mfTriu ------------------------------------------------------------
   call print_separation("mfTriu")

   print "(/,A)", "*** test number 120 ***"
   A = mfTriu(mfOnes(3,3))
   call msDisplay( A, "mfTriu(mfOnes(3,3))" )
   print *, "mfIsTril(A) : ", mfIsTril(A)
   print *, "mfIsTriu(A) : ", mfIsTriu(A)

   print "(/,A)", "*** test number 121 ***"
   x = mf( reshape( [ (i,i=1,16) ], [ 4, 4 ] ) )
   call msDisplay(x,"x")
   call msDisplay(mfTriu(x),"mfTriu(x)")
   print "(/,A)", "*** test number 122 ***"
   call msDisplay(mfTriu(x,1),"mfTriu(x,1)")
   print "(/,A)", "*** test number 123 ***"
   call msDisplay(mfTriu(x,3),"mfTriu(x,3)")
   print "(/,A)", "*** test number 124 ***"
   call msDisplay(mfTriu(x,4),"mfTriu(x,4)")
   print "(/,A)", "*** test number 125 ***"
   call msDisplay(mfTriu(x,-3),"mfTriu(x,-3)")

   print "(/,A)", "*** test number 126 ***"
   x = mf( reshape( [ (i,i=1,15) ], [ 5, 3 ] ) )
   call msDisplay(x,"x")
   call msDisplay(mfTriu(x),"mfTriu(x)")
   print "(/,A)", "*** test number 127 ***"
   call msDisplay(mfTriu(x,2),"mfTriu(x,2)")
   print "(/,A)", "*** test number 128 ***"
   call msDisplay(mfTriu(x,3),"mfTriu(x,3)")
   print "(/,A)", "*** test number 129 ***"
   call msDisplay(mfTriu(x,-3),"mfTriu(x,-3)")
   print "(/,A)", "*** test number 130 ***"
   call msDisplay(mfTriu(x,-4),"mfTriu(x,-4)")

   print "(/,A)", "*** test number 131 ***"
   x = mf( reshape( [ (i,i=1,15) ], [ 3, 5 ] ) )
   call msDisplay(x,"x")
   call msDisplay(mfTriu(x),"mfTriu(x)")
   print "(/,A)", "*** test number 132 ***"
   call msDisplay(mfTriu(x,4),"mfTriu(x,4)")
   print "(/,A)", "*** test number 133 ***"
   call msDisplay(mfTriu(x,5),"mfTriu(x,5)")
   print "(/,A)", "*** test number 134 ***"
   call msDisplay(mfTriu(x,-1),"mfTriu(x,-1)")
   print "(/,A)", "*** test number 135 ***"
   call msDisplay(mfTriu(x,-2),"mfTriu(x,-2)")

   ! mfFind, msFind ----------------------------------------------------
   call print_separation("mfFind, msFind")

   ! real

   print "(/,A)", "*** test number 136 ***"
   x = mf( [ 2, 0, 0 ] ) .vc.                                           &
       mf( [ 0, 0, 1 ] ) .vc.                                           &
       mf( [ 0, 3, 0 ] )

   call msDisplay(x,"x")
   y = mfFind( x>1.0d0 )
   call msDisplay(y,"(long column indexes) mfFind( x>1.0d0 )")

   print "(/,A)", "*** test number 137 ***"
   call msDisplay(x,"x")
   y = mfFind( x>2.0d0 )
   call msDisplay(y,"(long column indexes) mfFind( x>2.0d0 )")

   print "(/,A)", "*** test number 138 ***"
   call msDisplay(x,"x")
   call msFind( mfOut(a,b), x )
   call msDisplay(a,"row indexes",b,"col indexes")

   print "(/,A)", "*** test number 139 ***"
   call msDisplay(x,"x")
   call msFind( mfOut(a,b,y), x )
   call msDisplay(a,"row indexes",b,"col indexes",y,"values")

   ! complex

   print "(/,A)", "*** test number 140 ***"
   x = mf( [ 2, 0, 0 ] ) .vc.                                           &
       mf( [ 0, 0, 1 ] ) .vc.                                           &
       mf( [ 0, 3, 0 ] )
   x = x*MF_I

   call msDisplay(x,"x")
   y = mfFind( x )
   call msDisplay(y,"(long column indexes) mfFind( x )")

   print "(/,A)", "*** test number 141 ***"
   call msDisplay(x,"x")
   call msFind( mfOut(a,b), x )
   call msDisplay(a,"row indexes",b,"col indexes")

   print "(/,A)", "*** test number 142 ***"
   call msDisplay(x,"x")
   call msFind( mfOut(a,b,y), x )
   call msDisplay(a,"row indexes",b,"col indexes",y,"values")

   ! mfNonZeros --------------------------------------------------------
   call print_separation("mfNonZeros")

   print "(/,A)", "*** test number 143 ***"
   x = mf( [ 2, 0, 0 ] ) .vc.                                           &
       mf( [ 0, 0, 1 ] ) .vc.                                           &
       mf( [ 0, 3, 0 ] )

   call msDisplay(x,"x")
   y = mfNonZeros( x )
   call msDisplay(y,"mfNonZeros( x )")

   print "(/,A)", "*** test number 144 ***"
   x = x*MF_I

   call msDisplay(x,"x")
   y = mfNonZeros( x )
   call msDisplay(y,"mfNonZeros( x )")

   ! mfIsNaN -----------------------------------------------------------
   call print_separation("mfIsNaN")

   ! real case
   print "(/,A)", "*** test number 145 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [  2.0d0, -MF_INF, MF_NAN ] ) .vc.                           &
       mf( [ MF_INF,   0.0d0,  1.0d0 ] )
   call mf_restore_fpe( )

   call msDisplay(x,"x")
   call msDisplay( mfIsNaN(x), "mfIsNaN(x)" )

   ! complex case
   print "(/,A)", "*** test number 146 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ (1.0d0,0.0d0), cmplx(0.0d0,MF_NAN,kind=MF_DOUBLE), (1.0d0,0.0d0) ] ) .vc. &
       mf( [ (0.0d0,1.0d0), cmplx(0.0d0,MF_INF,kind=MF_DOUBLE), (0.0d0,1.0d0) ] )
   call mf_restore_fpe( )

   call msDisplay(x,"x")
   call msDisplay( mfIsNaN(x), "mfIsNaN(x)" )

   ! mfIsFinite --------------------------------------------------------
   call print_separation("mfIsFinite")

   ! real case
   print "(/,A)", "*** test number 147 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [  2.0d0, -MF_INF, MF_NAN ] ) .vc.                           &
       mf( [ MF_INF,   0.0d0,  1.0d0 ] )
   call mf_restore_fpe( )

   call msDisplay(x,"x")
   call msDisplay( mfIsFinite(x), "mfIsFinite(x)" )

   ! complex case
   print "(/,A)", "*** test number 148 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ (1.0d0,0.0d0), cmplx(0.0d0,MF_NAN,kind=MF_DOUBLE), (1.0d0,0.0d0) ] ) .vc. &
       mf( [ (0.0d0,1.0d0), cmplx(0.0d0,MF_INF,kind=MF_DOUBLE), (0.0d0,1.0d0) ] )
   call mf_restore_fpe( )

   call msDisplay(x,"x")
   call msDisplay( mfIsFinite(x), "mfIsFinite(x)" )

   ! mfIsINF -----------------------------------------------------------
   call print_separation("mfIsINF")

   ! real case
   print "(/,A)", "*** test number 149 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [  2.0d0, -MF_INF ] ) .vc.                                   &
       mf( [ MF_INF,  MF_NAN ] ) .vc.                                   &
       mf( [ MF_INF,   1.0d0 ] )
   call mf_restore_fpe( )

   call msDisplay(x,"x")
   call msDisplay( mfIsINF(x), "mfIsINF(x)" )

   ! complex case
   print "(/,A)", "*** test number 150 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ (-1.0d0, 0.0d0),                    ( 0.0d0, 1.0d0) ] ) .vc. &
       mf( [ cmplx(0.0d0,MF_INF,kind=MF_DOUBLE), (0.0d0, -1.0d0) ] ) .vc. &
       mf( [ ( 1.0d0, 0.0d0),                     cmplx(0.0d0,MF_NAN,kind=MF_DOUBLE) ] )
   call mf_restore_fpe( )

   call msDisplay(x,"x")
   call msDisplay( mfIsINF(x), "mfIsINF(x)" )

   ! mfFlipLR ----------------------------------------------------------
   call print_separation("mfFlipLR")

   print "(/,A)", "*** test number 151 ***"
   A = reshape( [ (i,i=1,15) ], [3,5] )
   call msDisplay(A,"A")
   call msDisplay(mfFlipLR(A),"mfFlipLR(A)")

   ! mfFlipUD ----------------------------------------------------------
   call print_separation("mfFlipUD")

   print "(/,A)", "*** test number 152 ***"
   A = reshape( [ (i,i=1,15) ], [3,5] )
   call msDisplay(A,"A")
   call msDisplay(mfFlipUD(A),"mfFlipUD(A)")

   ! mfRot90 -----------------------------------------------------------
   call print_separation("mfRot90")

   print "(/,A)", "*** test number 153 ***"
   A = reshape( [ (i,i=1,6) ], [3,2] )
   call msDisplay(A,"A")
   call msDisplay(mfRot90(A,0),"mfRotate(A,0) [idem A]")
   print "(/,A)", "*** test number 154 ***"
   call msDisplay(mfRot90(A,1),"mfRotate(A,1) [90 direct]")
   print "(/,A)", "*** test number 155 ***"
   call msDisplay(mfRot90(A,2),"mfRotate(A,2) [180 direct]")
   print "(/,A)", "*** test number 156 ***"
   call msDisplay(mfRot90(A,3),"mfRotate(A,3) [270 direct]")
   print "(/,A)", "*** test number 157 ***"
   call msDisplay(mfRot90(A,4),"mfRotate(A,4) [idem A]")

   print "(/,A)", "*** test number 158 ***"
   A = .t. reshape( [ (i,i=1,6) ], [3,2] )
   call msDisplay(A,"A")
   call msDisplay(mfRot90(A,1),"mfRotate(A,1) [90 direct]")
   print "(/,A)", "*** test number 159 ***"
   call msDisplay(mfRot90(A,2),"mfRotate(A,2) [180 direct]")
   print "(/,A)", "*** test number 160 ***"
   call msDisplay(mfRot90(A,3),"mfRotate(A,3) [270 direct]")
   print "(/,A)", "*** test number 161 ***"
   call msDisplay(mfRot90(A,4),"mfRotate(A,4) [idem A]")

   print "(/,A)", "*** test number 162 ***"
   A = MF_I*reshape( [ (i,i=1,6) ], [3,2] )
   call msDisplay(A,"A")
   call msDisplay(mfRot90(A,0),"mfRotate(A,0) [idem A]")
   print "(/,A)", "*** test number 163 ***"
   call msDisplay(mfRot90(A,1),"mfRotate(A,1) [90 direct]")
   print "(/,A)", "*** test number 164 ***"
   call msDisplay(mfRot90(A,2),"mfRotate(A,2) [180 direct]")
   print "(/,A)", "*** test number 165 ***"
   call msDisplay(mfRot90(A,3),"mfRotate(A,3) [270 direct]")

   ! mfCompan ----------------------------------------------------------
   call print_separation("mfCompan")

   print "(/,A)", "*** test number 166 ***"
   v = [ 1.0d0, 0.0d0, -7.0d0, 6.0d0 ]
   call msDisplay(v,"v")

   A = mfCompan(v)
   call msDisplay(A,"A = mfCompan(v)")

   ! mfHankel ----------------------------------------------------------
   call print_separation("mfHankel")

   print "(/,A)", "*** test number 167 ***"
   C = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0 ]
   call msDisplay(C,"C")

   A = mfHankel(C)
   call msDisplay(A,"A = mfHankel(C)")

   print "(/,A)", "*** test number 168 ***"
   C = .t. C
   call msDisplay(C,"C")

   A = mfHankel(C)
   call msDisplay(A,"A = mfHankel(C)")

   print "(/,A)", "*** test number 169 ***"
   C = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0 ]
   R = [ 888.0d0, 5.0d0, 6.0d0 ]
   call msDisplay(C,"C",R,"R")
   print *, "[one expected warning]"

   A = mfHankel(C,R)
   call msDisplay(A,"A = mfHankel(C,R)")

   print "(/,A)", "*** test number 170 ***"
   R = .t. mf( [ 4.0d0, 5.0d0, 6.0d0, 7.0d0, 8.0d0 ] )
   call msDisplay(C,"C",R,"R")

   A = mfHankel(C,R)
   call msDisplay(A,"A = mfHankel(C,R)")

   ! mfToeplitz --------------------------------------------------------
   call print_separation("mfToeplitz")

   print "(/,A)", "*** test number 171 ***"
   C = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0 ]
   call msDisplay(C,"C")

   A = mfToeplitz(C)
   call msDisplay(A,"A = mfToeplitz(C)")

   print "(/,A)", "*** test number 172 ***"
   C = .t. C
   call msDisplay(C,"C")

   A = mfToeplitz(C)
   call msDisplay(A,"A = mfToeplitz(C)")

   print "(/,A)", "*** test number 173 ***"
   C = [ 888.0d0, 2.0d0, 3.0d0, 4.0d0 ]
   R = [ 1.0d0, 5.0d0, 6.0d0 ]
   call msDisplay(C,"C",R,"R")
   print *, "[one expected warning]"

   A = mfToeplitz(C,R)
   call msDisplay(A,"A = mfToeplitz(C,R)")

   print "(/,A)", "*** test number 174 ***"
   R = .t. mf( [ 1.0d0, 5.0d0, 6.0d0, 7.0d0, 8.0d0 ] )
   call msDisplay(C,"C",R,"R")

   A = mfToeplitz(C,R)
   call msDisplay(A,"A = mfToeplitz(C,R)")

   !-- complex values

   print "(/,A)", "*** test number 175 ***"
   C = [ (1.0d0,0.0d0), (0.0d0,2.0d0), (3.0d0,0.0d0), (0.0d0,4.0d0) ]
   call msDisplay(C,"C")

   A = mfToeplitz(C)
   call msDisplay(A,"A = mfToeplitz(C)")

   print "(/,A)", "*** test number 176 ***"
   C = .t. C
   call msDisplay(C,"C")

   A = mfToeplitz(C)
   call msDisplay(A,"A = mfToeplitz(C)")

   print "(/,A)", "*** test number 177 ***"
   C = [ (0.0d0,1.0d0), (2.0d0,0.0d0), (0.0d0,3.0d0), (4.0d0,0.0d0) ]
   call msDisplay(C,"C")

   A = mfToeplitz(C)
   call msDisplay(A,"A = mfToeplitz(C)")

   print "(/,A)", "*** test number 178 ***"
   C = [ (888.0d0,0.0d0), (0.0d0,2.0d0), (3.0d0,0.0d0), (0.0d0,4.0d0) ]
   R = [ (1.0d0,0.0d0), (0.0d0,5.0d0), (6.0d0,0.0d0) ]
   call msDisplay(C,"C",R,"R")
   print *, "[one expected warning]"

   A = mfToeplitz(C,R)
   call msDisplay(A,"A = mfToeplitz(C,R)")

   print "(/,A)", "*** test number 179 ***"
   C = [ (1.0d0,0.0d0), (0.0d0,2.0d0), (3.0d0,0.0d0), (0.0d0,4.0d0) ]
   R = [ 1.0d0, 5.0d0, 6.0d0 ]
   call msDisplay(C,"C",R,"R")

   A = mfToeplitz(C,R)
   call msDisplay(A,"A = mfToeplitz(C,R)")

   print "(/,A)", "*** test number 180 ***"
   C = [ 1.0d0, 2.0d0, 3.0d0, 4.0d0 ]
   R = [ (1.0d0,0.0d0), (0.0d0,5.0d0), (6.0d0,0.0d0) ]
   call msDisplay(C,"C",R,"R")

   A = mfToeplitz(C,R)
   call msDisplay(A,"A = mfToeplitz(C,R)")

   ! mfMerge -----------------------------------------------------------
   call print_separation("mfMerge")

   print "(/,A)", "*** test number 181 ***"
   A =  3.0d0*mfOnes(3,2)
   B = -1.0d0*mfOnes(3,2)
   mask = mfEye(3,2) > 0.5d0
   call msDisplay( A,"A", B,"B", mask,"mask" )
   call msDisplay( mfMerge(A,B,mask), "mfMerge(A,B,mask)" )

   print "(/,A)", "*** test number 182 ***"
   A =  3.0d0*mfOnes(3,2)*MF_I
   B = -1.0d0*mfOnes(3,2)*MF_I
   mask = mfEye(3,2) < 0.5d0
   call msDisplay( A,"A", B,"B", mask,"mask" )
   call msDisplay( mfMerge(A,B,mask), "mfMerge(A,B,mask)" )

   ! mfPack ------------------------------------------------------------
   call print_separation("mfPack")

   print "(/,A)", "*** test number 183 ***"
   A = mfMagic(3)
   mask = A >= 5.0d0
   call msDisplay( A,"A", mask,"mask" )
   Ap = mfPack(A,mask)
   call msDisplay( Ap, "A packed" )

   print "(/,A)", "*** test number 184 ***"
   B = mfMagic(3)*MF_I
   call msDisplay( B,"B", mask,"mask" )
   Bp = mfPack(B,mask)
   call msDisplay( Bp, "B packed" )

   ! mfUnpack ----------------------------------------------------------
   call print_separation("mfUnpack")

   print "(/,A)", "*** test number 185 ***"
   call mf_save_and_disable_fpe( )
   R = mfOnes(3)*MF_NAN
   call mf_restore_fpe( )
   call msDisplay( mfUnpack(Ap,mask,field=R), "A unpacked" )

   print "(/,A)", "*** test number 186 ***"
   R = (-mfOnes(3))*MF_I
   call msDisplay( mfUnpack(Bp,mask,field=R), "B unpacked" )

   ! mfCshift ----------------------------------------------------------
   call print_separation("mfCshift")

   ! real

   print "(/,A)", "*** test number 187 ***"
   A = [ 1, 2, 3, 4, 5, 6 ]
   call msDisplay( A, "A" )
   call msDisplay( mfCshift(A,shift=1),"mfCshift(A,shift=1)" )
   call msDisplay( mfCshift(A,shift=-2),"mfCshift(A,shift=-2)" )

   print "(/,A)", "*** test number 188 ***"
   A = .t. [ 1, 2, 3, 4, 5, 6 ]
   call msDisplay( A, "A" )
   call msDisplay( mfCshift(A,shift=1),"mfCshift(A,shift=1)" )
   call msDisplay( mfCshift(A,shift=-2),"mfCshift(A,shift=-2)" )

   ! complex

   print "(/,A)", "*** test number 189 ***"
   A = [ 1, 2, 3, 4, 5, 6 ]*MF_I
   call msDisplay( A, "A" )
   call msDisplay( mfCshift(A,shift=1),"mfCshift(A,shift=1)" )
   call msDisplay( mfCshift(A,shift=-2),"mfCshift(A,shift=-2)" )

   print "(/,A)", "*** test number 190 ***"
   A = .t. [ 1, 2, 3, 4, 5, 6 ]*MF_I
   call msDisplay( A, "A" )
   call msDisplay( mfCshift(A,shift=1),"mfCshift(A,shift=1)" )
   call msDisplay( mfCshift(A,shift=-2),"mfCshift(A,shift=-2)" )

   ! mfEoshift ---------------------------------------------------------
   call print_separation("mfEoshift")

   ! real

   print "(/,A)", "*** test number 191 ***"
   A = [ 1, 2, 3, 4, 5, 6 ]
   call msDisplay( A, "A" )
   call msDisplay( mfEoshift(A,shift=1),"mfEoshift(A,shift=1)" )
   call msDisplay( mfEoshift(A,shift=-2),"mfEoshift(A,shift=-2)" )
   b = 99
   call msDisplay( mfEoshift(A,shift=1,boundary=b),                     &
                  "mfEoshift(A,shift=1,boundary=b)" )

   print "(/,A)", "*** test number 192 ***"
   A = .t. [ 1, 2, 3, 4, 5, 6 ]
   call msDisplay( A, "A" )
   call msDisplay( mfEoshift(A,shift=1),"mfEoshift(A,shift=1)" )
   call msDisplay( mfEoshift(A,shift=-2),"mfEoshift(A,shift=-2)" )
   call msDisplay( mfEoshift(A,shift=1,boundary=b),                     &
                  "mfEoshift(A,shift=1,boundary=b)" )

   ! complex

   print "(/,A)", "*** test number 193 ***"
   A = [ 1, 2, 3, 4, 5, 6 ]*MF_I
   call msDisplay( A, "A" )
   call msDisplay( mfEoshift(A,shift=1),"mfEoshift(A,shift=1)" )
   call msDisplay( mfEoshift(A,shift=-2),"mfEoshift(A,shift=-2)" )
   b = 99*MF_I
   call msDisplay( mfEoshift(A,shift=1,boundary=b),                     &
                  "mfEoshift(A,shift=1,boundary=b)" )

   print "(/,A)", "*** test number 194 ***"
   A = .t. [ 1, 2, 3, 4, 5, 6 ]*MF_I
   call msDisplay( A, "A" )
   call msDisplay( mfEoshift(A,shift=1),"mfEoshift(A,shift=1)" )
   call msDisplay( mfEoshift(A,shift=-2),"mfEoshift(A,shift=-2)" )
   call msDisplay( mfEoshift(A,shift=1,boundary=b),                     &
                  "mfEoshift(A,shift=1,boundary=b)" )

   ! mfKron
   call print_separation("mfKron")

   print "(/,A)", "*** test number 195 ***"
   A = reshape( [0.5d0,1.0d0,1.5d0,2.0d0,2.5d0,3.0d0], [2,3] )
   call msDisplay( A, "A" )
   B = reshape( [2.0d0,2.5d0,3.0d0,3.5d0], [2,2] )
   call msDisplay( B, "B" )
   call msDisplay( mfKron(A,B),"mfKron(A,B)" )

   ! mfPerm ------------------------------------------------------------
   call print_separation("mfPerm")

   ! we group here tests about many features concerning MF_DT_PERM_VEC

   print "(/,A)", "*** test number 196 ***"
   p = mfPerm( [ 1, 2, 3, 4, 5 ] )
   call msDisplay( p, "mfPerm([ 1, 2, 3, 4, 5 ])" )

   print "(/,A)", "*** test number 197 ***"
   p = mfPerm( mf([ 1, 2, 3, 4, 5 ]) )
   call msDisplay( p, "mfPerm(mf([ 1, 2, 3, 4, 5 ]))" )

   print "(/,A)", "*** test number 198 ***"
   v = [ 1, 2, 3, 4, 5 ]
   call msDisplay( v, "v" )
   p = mfPerm( v )
   call msDisplay( p, "mfPerm(v)" )

   print "(/,A)", "*** test number 199 ***"
   v = [ 1, 2, 3, 4, 5 ]
   call msAssign( p, mfPerm(v) )
   print *, "call msAssign( p, mfPerm(v) )"
   call msDisplay( p, "p" )

   print "(/,A)", "*** test number 200 ***"
   v = [ 1, 2, 3, 4, 5 ]
   p = mfPerm( v )
   call msDisplay( p, "mfPerm(v)" )
   allocate( ivec(5) )
   ivec(:) = p
   print *, "ivec(:) = p"
   print *, "ivec(:) = ", ivec(:)
   deallocate( ivec )
   print "()"

   ! mfRandPerm ------------------------------------------------------------
   call print_separation("mfRandPerm")

   print "(/,A)", "*** test number 201 ***"
   p = mfRandPerm(7)
   call msDisplay( p, "mfRandPerm(7)" )

   print "(/,A)", "*** test number 202 ***"
   p = mfRandPerm(100)
   print *, "After generation of a random permutation of length 100:"
   print *, "Is 'p' a valid permutation ? mfCheckPerm(p) = ", mfCheckPerm(p)
   print "()"

   print "(/,A)", "*** test number 203 ***"
   p = mfRandPerm(7,7)
   call msDisplay( p, "mfRandPerm(7,7)" )

   print "(/,A)", "*** test number 204 ***"
   p = mfRandPerm(7,4)
   call msDisplay( p, "mfRandPerm(7,4)" )

   print "(/,A)", "*** test number 205 ***"
   p = mfRandPerm(7,1)
   call msDisplay( p, "mfRandPerm(7,1)" )

   ! mfCheckPerm -------------------------------------------------------
   call print_separation("mfCheckPerm")

   print "(/,A)", "*** test number 206 ***"
   p = mfPerm( [ 1, 2, 3, 4, 5 ] ) ! ok
   call msDisplay( p, "mfPerm([ 1, 2, 3, 4, 5 ])" )

   print *, "Is 'p' a valid permutation ? mfCheckPerm(p) = ", mfCheckPerm(p)

   print "(/,A)", "*** test number 207 ***"
   p = mfPerm( [ 0, 1, 2, 3, 4 ] ) ! contains a negative or null index
   call msDisplay( p, "mfPerm([ 0, 1, 2, 3, 4 ])" )

   print *, "Is 'p' a valid permutation ? mfCheckPerm(p) = ", mfCheckPerm(p)

   print "(/,A)", "*** test number 208 ***"
   p = mfPerm( [ 1, 2, 3, 2, 1 ] ) ! contains twice the indexes 2 and 3
   call msDisplay( p, "mfPerm([ 1, 2, 3, 2, 1 ])" )

   print *, "Is 'p' a valid permutation ? mfCheckPerm(p) = ", mfCheckPerm(p)

   print "()"

   ! End of tests ------------------------------------------------------
   print "(A)", "                         ┏━━━━━━━━━━━━━━━━━━━━━━━┓"
   print "(A)", "                         ┃ End of test_mod_elmat ┃"
   print "(A)", "                         ┗━━━━━━━━━━━━━━━━━━━━━━━┛"

   !--------------------------------------------------------------------
99 continue

   print "()"
   call msSetMsgLevel(2)

   call msRelease( x, y, A, B, C, R, v )
   call msRelease( mask, Ap, Bp, p, seed )

   ! non official Muesli routine: introduced here to clean memory
   call RngStream_end()

end program
