module elfun_aux

   use fml

   implicit none

contains

   function fun_user_1_real( x ) result( res )
      real(kind=MF_DOUBLE), intent(in) :: x
      real(kind=MF_DOUBLE) :: res
      res = x**2 - 1.0d0
   end function fun_user_1_real

   function fun_user_1_cmplx( z ) result( res )
      complex(kind=MF_DOUBLE), intent(in) :: z
      complex(kind=MF_DOUBLE) :: res
      res = z**2 - 1.0d0
   end function fun_user_1_cmplx

   function fun_user_2_real( x1, x2 ) result( res )
      real(kind=MF_DOUBLE), intent(in) :: x1, x2
      real(kind=MF_DOUBLE) :: res
      res = x1**2 - x2**2 + 1.0d0
   end function fun_user_2_real

   function fun_user_2_cmplx( z1, z2 ) result( res )
      complex(kind=MF_DOUBLE), intent(in) :: z1, z2
      complex(kind=MF_DOUBLE) :: res
      res = z1**2 - z2**2 + (0.0d0,1.0d0)
   end function fun_user_2_cmplx

end module elfun_aux
!_______________________________________________________________________
!
program test_mod_elfun

   use fml

   use test_aux
   use lib_aux

   use elfun_aux

   implicit none

   type(mfArray) :: x, y, m, e, z, z2, mat_X, mat_Y

   ! Msg level = 3 : all messages are printed (verbose mode)
   !             2 : messages of kind 'ERROR' and 'Warning' are
   !                 printed [default]
   !             1 : only messages of kind 'ERROR' are printed
   !             0 : nothing is printed (quiet mode)
   !                 (pause are ignored !)

   real(kind=MF_DOUBLE) :: check_small_threshold = 10.0d0*MF_EPS

!!   call msSetMsgLevel(3)
!!   call msSetTrbLevel("all")

   print "()"

   ! for TRACE_MEM_DEBUG, STDERR must be redirected to STDOUT;
   ! the same thing stands for 'make check'
   call msSetStdIO( stderr=STDOUT )

!!goto 10

   ! to avoid escape sequences of color setting in the output file
   ! (default in "on")
   call msSetColoredMsg( "off" )

   ! VERSIONs ----------------------------------------------------------
   print "()"
   print *, "MF_MUESLI_VERSION = '", MF_MUESLI_VERSION, "'"
   print "()"
   print *, "MF_COMPILER_VERSION = '", MF_COMPILER_VERSION, "'"
   print "()"
   print *, "MF_COMPILATION_CONFIG = '", MF_COMPILATION_CONFIG(), "'"
   print "()"

   ! mfACos ------------------------------------------------------------
   call print_separation("mfACos")

   print "(/,A)", "*** test number 1 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ -2.0d0, -1.0d0,  0.0d0, 1.0d0,  2.0d0 ] ) .vc.             &
       mf( [ -MF_INF,  0.0d0, MF_NAN, 0.0d0, MF_INF ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfACos(x)
   call msDisplay(y,"y = mfACos(x)")
   call msDisplay(mfCos(y),"mfCos(y)")

   print "(/,A)", "*** test number 2 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ cmplx(0.0,-MF_INF,kind=MF_DOUBLE), (0.0d0,-2.0d0), (0.0d0,-1.0d0) ] ) .vc. &
       mf( [ cmplx(0.0, MF_INF,kind=MF_DOUBLE), (0.0d0, 2.0d0), (0.0d0, 1.0d0) ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfACos(x)
   call msDisplay(y,"y = mfACos(x)")
   call msDisplay(mfCos(y),"mfCos(y)")

   print "(/,A)", "*** test number 3 ***"
   y = mfACos( mf( [ -1.0d0, 0.0d0, 1.0d0 ] ) )
   call msDisplay(y,"y = mfACos( mf( [ -1.0d0, 0.0d0, 1.0d0 ] ) )")

   ! mfASin ------------------------------------------------------------
   call print_separation("mfASin")

   print "(/,A)", "*** test number 4 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ -2.0d0, -1.0d0,  0.0d0, 1.0d0,  2.0d0 ] ) .vc.             &
       mf( [ -MF_INF,  0.0d0, MF_NAN, 0.0d0, MF_INF ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfASin(x)
   call msDisplay(y,"y = mfASin(x)")
   call msDisplay(mfSin(y),"mfSin(y)")

   call mf_save_and_disable_fpe( )
   print "(/,A)", "*** test number 5 ***"
   x = mf( [ cmplx(0.0,-MF_INF,kind=MF_DOUBLE), (0.0d0,-2.0d0), (0.0d0,-1.0d0) ] ) .vc. &
       mf( [ cmplx(0.0, MF_INF,kind=MF_DOUBLE), (0.0d0, 2.0d0), (0.0d0, 1.0d0) ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfASin(x)
   call msDisplay(y,"y = mfASin(x)")
   call msDisplay(mfSin(y),"mfSin(y)")

   print "(/,A)", "*** test number 6 ***"
   y = mfASin( mf( [ -1.0d0, 0.0d0, 1.0d0 ] ) )
   call msDisplay(y,"y = mfASin( mf( [ -1.0d0, 0.0d0, 1.0d0 ] ) )")

   ! mfATan ------------------------------------------------------------
   call print_separation("mfATan")

   print "(/,A)", "*** test number 7 ***"
   x = [ -2.0d0, -1.0d0,  0.0d0, 1.0d0,  2.0d0 ]
   call msDisplay(x,"x")
   y = mfATan(x)
   call msDisplay(y,"y = mfATan(x)")
   call msDisplay(mfTan(y),"mfTan(y)")
   call msDisplay( mfNorm(x-mfTan(y)) < 20.0d0*MF_EPS,                  &
                  "| x-mfTan(y) | < 20.*MF_EPS")

   print "(/,A)", "*** test number 8 ***"
   call mf_save_and_disable_fpe( )
   x = [ -MF_INF,  MF_INF ]
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfATan(x)
   call msDisplay(y,"y = mfATan(x)")
   call msDisplay( mfAbs(mfTan(y)) > 1.0d0/(20.0d0*MF_EPS),             &
                  "mfAbs(mfTan(y)) > 1.0d0/(20.0d0*MF_EPS)")

   print "(/,A)", "*** test number 9 ***"
   x = [ -MF_I,  MF_I ]
   call msDisplay(x,"x")
   y = mfATan(x)
   call msDisplay(y,"y = mfATan(x)")

   print "(/,A)", "*** test number 10 ***"
   x = [ (0.0d0,-2.0d0), (0.0d0,-1.0d0),                                &
          (0.0d0, 1.0d0), (0.0d0, 2.0d0) ]
   call msDisplay(x,"x")
   y = mfATan(x)
   call msDisplay(y,"y = mfATan(x)")
   call msDisplay(mfTan(y),"mfTan(y)")

   print "(/,A)", "*** test number 11 ***"
   call mf_save_and_disable_fpe( )
   x = [ cmplx(0.0,-MF_INF,kind=MF_DOUBLE),                             &
          cmplx(0.0, MF_INF,kind=MF_DOUBLE) ]
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfATan(x)
   call msDisplay(y,"y = mfATan(x)")
   call msDisplay(mfTan(y),"mfTan(y)")

   print "(/,A)", "*** test number 12 ***"
   y = mfATan( mf( [ -MF_INF, 0.0d0, MF_INF ] ) )
   call msDisplay(y,"y = mfATan( mf( [ -MF_INF, 0.0d0, MF_INF ] ) )")

   ! mfATan2 -----------------------------------------------------------
   call print_separation("mfATan2")

   print "(/,A)", "*** test number 13 ***"
   x = mfOnes(3)
   call msDisplay(x,"mfOnes(3)")
   call msDisplay(mfATan2(x,x),"mfATan2(%,%)")

   y = mfATan2( mf( [  0.0d0, 1.0d0, 0.0d0 ] ),                         &
                mf( [ -1.0d0, 0.0d0, 1.0d0 ] ) )
   call msDisplay(y,"y = mfATan2( mf([  0.0d0, 1.0d0, 0.0d0 ]), mf([ -1.0d0, 0.0d0, 1.0d0 ]) )")

   ! mfCos -------------------------------------------------------------
   call print_separation("mfCos")

   print "(/,A)", "*** test number 14 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ -2.0d0, -1.0d0,  0.0d0, 1.0d0,  2.0d0 ] ) .vc.             &
       mf( [ -MF_INF,  0.0d0, MF_NAN, 0.0d0, MF_INF ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfCos(x)
   call msDisplay(y,"y = mfCos(x)")
   call msDisplay(mfACos(y),"mfACos(y)")

   print "(/,A)", "*** test number 15 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ cmplx(0.0,-MF_INF,kind=MF_DOUBLE), (0.0d0,-2.0d0), (0.0d0,-1.0d0) ] ) .vc. &
       mf( [ cmplx(0.0, MF_INF,kind=MF_DOUBLE), (0.0d0, 2.0d0), (0.0d0, 1.0d0) ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfCos(x)
   call msDisplay(y,"y = mfCos(x)")
   call msDisplay(mfACos(y),"mfACos(y)")

   print "(/,A)", "*** test number 16 ***"
   y = mfCos( mf( [ -MF_PI, 0.0d0, MF_PI ] ) )
   call msDisplay(y,"y = mfCos( mf( [ -MF_PI, 0.0d0, MF_PI ] ) )")

   ! mfCosh ------------------------------------------------------------
   call print_separation("mfCosh")

   print "(/,A)", "*** test number 17 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ -2.0d0, -1.0d0,  0.0d0, 1.0d0,  2.0d0 ] ) .vc.             &
       mf( [ -MF_INF,  0.0d0, MF_NAN, 0.0d0, MF_INF ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfCosh(x)
   call msDisplay(y,"y = mfCosh(x)")
   call msDisplay(mfACosh(y),"mfACosh(y)")

   print "(/,A)", "*** test number 18 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ cmplx(0.0,-MF_INF,kind=MF_DOUBLE), (0.0d0,-2.0d0), (0.0d0,-1.0d0) ] ) .vc. &
       mf( [ cmplx(0.0, MF_INF,kind=MF_DOUBLE), (0.0d0, 2.0d0), (0.0d0, 1.0d0) ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfCosh(x)
   call msDisplay(y,"y = mfCosh(x)")
   call msDisplay(mfACosh(y),"mfACosh(y)")

   print "(/,A)", "*** test number 19 ***"
   y = mfCosh( mf( [ -MF_PI, 0.0d0, MF_PI ] ) )
   call msDisplay(y,"y = mfCosh( mf( [ -MF_PI, 0.0d0, MF_PI ] ) )")

   ! mfSin -------------------------------------------------------------
   call print_separation("mfSin")

   print "(/,A)", "*** test number 20 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ -2.0d0, -1.0d0,  0.0d0, 1.0d0,  2.0d0 ] ) .vc.             &
       mf( [ -MF_INF,  0.0d0, MF_NAN, 0.0d0, MF_INF ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfSin(x)
   call msDisplay(y,"y = mfSin(x)")
   call msDisplay(mfASin(y),"mfASin(y)")

   print "(/,A)", "*** test number 21 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ cmplx(0.0,-MF_INF,kind=MF_DOUBLE), (0.0d0,-2.0d0), (0.0d0,-1.0d0) ] ) .vc. &
       mf( [ cmplx(0.0, MF_INF,kind=MF_DOUBLE), (0.0d0, 2.0d0), (0.0d0, 1.0d0) ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfSin(x)
   call msDisplay(y,"y = mfSin(x)")
   call msDisplay(mfASin(y),"mfASin(y)")

   print "(/,A)", "*** test number 22 ***"
   y = mfSin( mf( [ -MF_PI, 0.0d0, MF_PI ] ) )
   call msDisplay(y,"y = mfSin( mf( [ -MF_PI, 0.0d0, MF_PI ] ) )")

   ! mfSinh ------------------------------------------------------------
   call print_separation("mfSinh")

   print "(/,A)", "*** test number 23 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ -2.0d0, -1.0d0,  0.0d0, 1.0d0,  2.0d0 ] ) .vc.             &
       mf( [ -MF_INF,  0.0d0, MF_NAN, 0.0d0, MF_INF ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfSinh(x)
   call msDisplay(y,"y = mfSinh(x)")
   call msDisplay(mfASinh(y),"mfASinh(y)")

   print "(/,A)", "*** test number 24 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ cmplx(0.0,-MF_INF,kind=MF_DOUBLE), (0.0d0,-2.0d0), (0.0d0,-1.0d0) ] ) .vc. &
       mf( [ cmplx(0.0, MF_INF,kind=MF_DOUBLE), (0.0d0, 2.0d0), (0.0d0, 1.0d0) ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfSinh(x)
   call msDisplay(y,"y = mfSinh(x)")
   call msDisplay(mfASinh(y),"mfASinh(y)")

   print "(/,A)", "*** test number 25 ***"
   y = mfSinh( mf( [ -MF_PI, 0.0d0, MF_PI ] ) )
   call msDisplay(y,"y = mfSinh( mf( [ -MF_PI, 0.0d0, MF_PI ] ) )")

   ! mfTan -------------------------------------------------------------
   call print_separation("mfTan")

   print "(/,A)", "*** test number 26 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ -2.0d0, -1.0d0,  0.0d0, 1.0d0,  2.0d0 ] ) .vc.             &
       mf( [ -MF_INF,  0.0d0, MF_NAN, 0.0d0, MF_INF ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfTan(x)
   call msDisplay(y,"y = mfTan(x)")
   call msDisplay(mfATan(y),"mfATan(y)")

   print "(/,A)", "*** test number 27 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ cmplx(0.0,-MF_INF,kind=MF_DOUBLE), (0.0d0,-2.0d0), (0.0d0,-1.0d0) ] ) .vc. &
       mf( [ cmplx(0.0, MF_INF,kind=MF_DOUBLE), (0.0d0, 2.0d0), (0.0d0, 1.0d0) ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfTan(x)
   call msDisplay(y,"y = mfTan(x)")
   call msDisplay(mfATan(y),"mfATan(y)")

   print "(/,A)", "*** test number 28 ***"
   y = mfTan( mf( [ -MF_PI, 0.0d0, MF_PI ] ) )
   call msDisplay(y,"y = mfTan( mf( [ -MF_PI, 0.0d0, MF_PI ] ) )")

   ! mfTanh ------------------------------------------------------------
   call print_separation("mfTanh")

   print "(/,A)", "*** test number 29 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ -2.0d0, -1.0d0,  0.0d0, 1.0d0,  2.0d0 ] ) .vc.             &
       mf( [ -MF_INF,  0.0d0, MF_NAN, 0.0d0, MF_INF ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfTanh(x)
   call msDisplay(y,"y = mfTanh(x)")
   call msDisplay(mfATanh(y),"mfATanh(y)")

   call mf_save_and_disable_fpe( )
   print "(/,A)", "*** test number 30 ***"
   x = mf( [ cmplx(0.0,-MF_INF,kind=MF_DOUBLE), (0.0d0,-2.0d0), (0.0d0,-1.0d0) ] ) .vc. &
       mf( [ cmplx(0.0, MF_INF,kind=MF_DOUBLE), (0.0d0, 2.0d0), (0.0d0, 1.0d0) ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfTanh(x)
   call msDisplay(y,"y = mfTanh(x)")
   call msDisplay(mfATanh(y),"mfATanh(y)")

   print "(/,A)", "*** test number 31 ***"
   y = mfTanh( mf( [ -MF_PI, 0.0d0, MF_PI ] ) )
   call msDisplay(y,"y = mfTanh( mf( [ -MF_PI, 0.0d0, MF_PI ] ) )")

   ! mfExp -------------------------------------------------------------
   call print_separation("mfExp")

   print "(/,A)", "*** test number 32 ***"
   x = mfZeros(3)
   call msDisplay(x,"mfZeros(3)")
   call msDisplay(mfExp(x),"mfExp(%)")

   print "(/,A)", "*** test number 33 ***"
   x = mfOnes(3)*MF_I
   call msDisplay(x,"mfOnes(3)*MF_I")
   call msDisplay(mfExp(x),"mfExp(%)")

   print "(/,A)", "*** test number 34 ***"
   y = mfExp( mf( [ 0.0d0, 1.0d0 ] ) )
   call msDisplay(y,"y = mfExp( mf( [ 0.0d0, 1.0d0 ] ) )")

   ! mfExpm1 -----------------------------------------------------------
   call print_separation("mfExpm1")

   print "(/,A)", "*** test number 35 ***"
   x = mfZeros(3)
   call msDisplay(x,"mfZeros(3)")
   call msDisplay(mfExpm1(x),"mfExpm1(%)")

   print "(/,A)", "*** test number 36 ***"
   x = -1.0d-3*mfOnes(3)
   call msDisplay(x,"-1.0d-3*mfOnes(3)")
   call msDisplay(mfExpm1(x),"mfExpm1(%)")

   print "(/,A)", "*** test number 37 ***"
   x = 1.0d-3*mfOnes(3)
   call msDisplay(x,"1.0d-3*mfOnes(3)")
   call msDisplay(mfExpm1(x),"mfExpm1(%)")

   print "(/,A)", "*** test number 38 ***"
   x = -1.0d-10*mfOnes(3)
   call msFormat( "long" )
   call msDisplay(x,"-1.0d-10*mfOnes(3)")
   call msDisplay(mfExpm1(x),"mfExpm1(%)")

   print "(/,A)", "*** test number 39 ***"
   x = 1.0d-10*mfOnes(3)
   call msDisplay(x,"1.0d-10*mfOnes(3)")
   call msDisplay(mfExpm1(x),"mfExpm1(%)")
   call msFormat()

   ! mfLog -------------------------------------------------------------
   call print_separation("mfLog")

   print "(/,A)", "*** test number 40 ***"
   x = mfOnes(3)
   call msDisplay(x,"mfOnes(3)")
   call msDisplay(mfLog(x),"mfLog(%)")

   print "(/,A)", "*** test number 41 ***"
   x = mfOnes(3)*MF_E
   call msDisplay(x,"mfOnes(3)*MF_E")
   call msDisplay(mfLog(x),"mfLog(%)")

   print "(/,A)", "*** test number 42 ***"
   x = mfOnes(3)*MF_I
   call msDisplay(x,"mfOnes(3)*MF_I")
   call msDisplay(mfLog(x),"mfLog(%)")

   print "(/,A)", "*** test number 43 ***"
   y = mfLog( mf( [ 1.0d0, MF_E ] ) )
   call msDisplay(y,"y = mfLog( mf( [ 1.0d0, MF_E ] ) )")

   ! mfLog1p -----------------------------------------------------------
   call print_separation("mfLog1p")

   print "(/,A)", "*** test number 44 ***"
   x = mfZeros(3)
   call msDisplay(x,"mfZeros(3)")
   call msDisplay(mfLog1p(x),"mfLog1p(%)")

   print "(/,A)", "*** test number 45 ***"
   x = 1.0d-3*mfOnes(3)
   call msDisplay(x,"1.0d-3*mfOnes(3)")
   call msDisplay(mfLog1p(x),"mfLog1p(%)")

   print "(/,A)", "*** test number 46 ***"
   x = 1.0d-10*mfOnes(3)
   call msDisplay(x,"1.0d-10*mfOnes(3)")
   call msFormat( "long" )
   call msDisplay(mfLog1p(x),"mfLog1p(%)")
   call msFormat()

   print "(/,A)", "*** test number 47 ***"
   x = -0.999d0*mfOnes(3)
   call msDisplay(x,"-0.999d0*mfOnes(3)")
   call msDisplay(mfLog1p(x),"mfLog1p(%)")

   print "(/,A)", "*** test number 48 ***"
   x = -1.001d0*mfOnes(3)
   call msDisplay(x,"-1.001d0*mfOnes(3)")
   call msDisplay(mfLog1p(x),"mfLog1p(%)")

   ! mfLog10 -----------------------------------------------------------
   call print_separation("mfLog10")

   print "(/,A)", "*** test number 49 ***"
   x = mfOnes(3)
   call msDisplay(x,"mfOnes(3)")
   call msDisplay(mfLog10(x),"mfLog10(%)")

   print "(/,A)", "*** test number 50 ***"
   x = mfOnes(3)*10.0d0
   call msDisplay(x,"mfOnes(3)*10.0d0")
   call msDisplay(mfLog10(x),"mfLog10(%)")

   print "(/,A)", "*** test number 51 ***"
   x = mfOnes(3)*MF_I
   call msDisplay(x,"mfOnes(3)*MF_I")
   call msDisplay(mfLog10(x),"mfLog10(%)")

   print "(/,A)", "*** test number 52 ***"
   y = mfLog10( mf( [ 1.0d0, 10.0d0 ] ) )
   call msDisplay(y,"y = mfLog10( mf( [ 1.0d0, 10.0d0 ] ) )")

   ! mfLog2 ------------------------------------------------------------
   call print_separation("mfLog2")

   print "(/,A)", "*** test number 53 ***"
   x = mfOnes(3)
   call msDisplay(x,"mfOnes(3)")
   call msDisplay(mfLog2(x),"mfLog2(%)")

   print "(/,A)", "*** test number 54 ***"
   x = mfOnes(3)*2.0d0
   call msDisplay(x,"mfOnes(3)*2.0d0")
   call msDisplay(mfLog2(x),"mfLog2(%)")

   print "(/,A)", "*** test number 55 ***"
   x = mfOnes(3)*4.0d0
   call msDisplay(x,"mfOnes(3)*4.0d0")
   call msDisplay(mfLog2(x),"mfLog2(%)")

   print "(/,A)", "*** test number 56 ***"
   x = mfOnes(3)*6.0d0
   call msDisplay(x,"mfOnes(3)*6.0d0")
   call msDisplay(mfLog2(x),"mfLog2(%)")

   print "(/,A)", "*** test number 57 ***"
   x = mfOnes(3)*MF_I
   call msDisplay(x,"mfOnes(3)*MF_I")
   call msDisplay(mfLog2(x),"mfLog2(%)")

   ! msLog2 ------------------------------------------------------------
   call print_separation("msLog2")

   print "(/,A)", "*** test number 58 ***"
   x = mfZeros(3)
   call msDisplay(x,"mfOnes(3)")
   call msLog2(mfOut(m,e),x)
   call msDisplay(m,"mantissa",e,"exponent")

   print "(/,A)", "*** test number 59 ***"
   x = MF_EMPTY
   call msDisplay(x,"MF_EMPTY")
   call msLog2(mfOut(m,e),x)
   call msDisplay(m,"mantissa",e,"exponent")

   print "(/,A)", "*** test number 60 ***"
   x = mfOnes(3)
   call msDisplay(x,"mfOnes(3)")
   call msLog2(mfOut(m,e),x)
   call msDisplay(m,"mantissa",e,"exponent")

   print "(/,A)", "*** test number 61 ***"
   x = mfOnes(3)*2.0d0
   call msDisplay(x,"mfOnes(3)*2.0d0")
   call msLog2(mfOut(m,e),x)
   call msDisplay(m,"mantissa",e,"exponent")

   ! mfPow10 -----------------------------------------------------------
   call print_separation("mfPow10")

   print "(/,A)", "*** test number 62 ***"
   x = mfColon(-2.0d0, +2.0d0)
   call msDisplay(x,"mfColon(-2.0d0, +2.0d0)")
   call msDisplay(mfPow10(x),"mfPow10(%)")

   print "(/,A)", "*** test number 63 ***"
   y = mfPow10( mf( [ 0.0d0, 1.0d0 ] ) )
   call msDisplay(y,"y = mfPow10( mf( [ 0.0d0, 1.0d0 ] ) )")

   ! mfPow2 ------------------------------------------------------------
   call print_separation("mfPow2")

   print "(/,A)", "*** test number 64 ***"
   x = mfZeros(3)
   call msDisplay(x,"mfZeros(3)")
   call msDisplay(mfPow2(x),"mfPow2(%)")

   print "(/,A)", "*** test number 65 ***"
   x = mfOnes(3)
   call msDisplay(x,"mfOnes(3)")
   call msDisplay(mfPow2(x),"mfPow2(%)")

   print "(/,A)", "*** test number 66 ***"
   x = mfOnes(3)*2.0d0
   call msDisplay(x,"mfOnes(3)*2.0d0")
   call msDisplay(mfPow2(x),"mfPow2(%)")

   print "(/,A)", "*** test number 67 ***"
   y = mfPow2( mf( [ 0.0d0, 1.0d0 ] ) )
   call msDisplay(y,"y = mfPow2( mf( [ 0.0d0, 1.0d0 ] ) )")

   call msFormat("long")

   print "(/,A)", "*** test number 68 ***"
   x = MF_PI
   call msDisplay(x,"MF_PI")
   call msLog2(mfOut(m,e),x)
   call msDisplay(m,"mantissa",e,"exponent")

   call msDisplay(mfPow2(m,e),"mfPow2(m,e)")

   call msFormat("short")

   ! mfSqrt ------------------------------------------------------------
   call print_separation("mfSqrt")

   print "(/,A)", "*** test number 69 ***"
   x = mfOnes(3)*9.0d0
   call msDisplay(x,"mfOnes(3)*9.0d0")
   call msDisplay(mfSqrt(x),"mfSqrt(%)")

   print "(/,A)", "*** test number 70 ***"
   x = -mfOnes(3)
   call msDisplay(x,"-mfOnes(3)")
   call msDisplay(mfSqrt(x),"mfSqrt(%)")

   print "(/,A)", "*** test number 71 ***"
   y = mfSqrt( mf( [ 0.0d0, 1.0d0, 4.0d0 ] ) )
   call msDisplay(y,"y = mfSqrt( mf( [ 0.0d0, 1.0d0, 4.0d0 ] ) )")

   ! mfAbs -------------------------------------------------------------
   call print_separation("mfAbs")

   print "(/,A)", "*** test number 72 ***"
   x = -mfOnes(3)
   call msDisplay(x,"-mfOnes(3)")
   call msDisplay(mfAbs(x),"mfAbs(%)")

   print "(/,A)", "*** test number 73 ***"
   x = mfOnes(3) + mfOnes(3)*MF_I
   call msDisplay(x,"mfOnes(3) + mfOnes(3)*MF_I")
   call msDisplay(mfAbs(x),"mfAbs(%)")

   print "(/,A)", "*** test number 74 ***"
   y = mfAbs( mf( [ -1.0d0, 0.0d0, 1.0d0 ] ) )
   call msDisplay(y,"y = mfAbs( mf( [ -1.0d0, 0.0d0, 1.0d0 ] ) )")

   ! mfAngle -----------------------------------------------------------
   call print_separation("mfAngle")

   print "(/,A)", "*** test number 75 ***"
   x = [ -MF_INF, -1.0d0, 0.0d0, 1.0d0, MF_INF ]
   call msDisplay(x,"x")
   call msDisplay(mfAngle(x),"mfAngle(%)")

   print "(/,A)", "*** test number 76 ***"
   x = [ (1.0d0,0.0d0), (0.0d0,1.0d0), (0.0d0,0.0d0) ]
   call msDisplay(x,"x")
   call msDisplay(mfAngle(x),"mfAngle(%)")

   print "(/,A)", "*** test number 77 ***"
   y = mfAngle( mf( [ (1.0d0,0.0d0), (0.0d0,1.0d0), (-1.0d0,0.0d0) ] ) )
   call msDisplay(y,"y = mfAngle( mf( [ (1.0d0,0.0d0), (0.0d0,1.0d0), (-1.0d0,0.0d0) ] ) )")

   ! mfComplex ---------------------------------------------------------
   call print_separation("mfComplex")

   print "(/,A)", "*** test number 78 ***"
   call mf_save_and_disable_fpe( )
   x = [ -MF_INF, -1.0d0, 0.0d0, 1.0d0, MF_INF, MF_NAN ]
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   call msDisplay(mfComplex(x),"mfComplex(x)")

   print "(/,A)", "*** test number 79 ***"
   y = [ 1.0d0, 1.0d0, 1.0d0, -1.0d0, -1.0d0, -1.0d0 ]
   call msDisplay(y,"y")
   call msDisplay(mfComplex(x,y),"mfComplex(x,y)")

   print "(/,A)", "*** test number 80 ***"
   y = mfComplex( mf( [ 0.0d0, 1.0d0 ] ) )
   call msDisplay(y,"y = mfComplex( mf( [ 0.0d0, 1.0d0 ] ) )")

   ! mfConj ------------------------------------------------------------
   call print_separation("mfConj")

   print "(/,A)", "*** test number 81 ***"
   x = [ -MF_INF, -1.0d0, 0.0d0, 1.0d0, MF_INF ]
   call msDisplay(x,"x")
   call msDisplay(mfConj(x),"mfConj(%)")

   print "(/,A)", "*** test number 82 ***"
   x = [ (1.0d0,0.0d0), (0.0d0,1.0d0), (0.0d0,-1.0d0) ]
   call msDisplay(x,"x")
   call msDisplay(mfConj(x),"mfConj(%)")

   print "(/,A)", "*** test number 83 ***"
   y = mfConj( mf( [ (1.0d0,0.0d0), (0.0d0,1.0d0), (-1.0d0,0.0d0) ] ) )
   call msDisplay(y,"y = mfConj( mf( [ (1.0d0,0.0d0), (0.0d0,1.0d0), (-1.0d0,0.0d0) ] ) )")

   ! mfReal ------------------------------------------------------------
   call print_separation("mfReal")

   print "(/,A)", "*** test number 84 ***"
   x = [ -MF_INF, -1.0d0, 0.0d0, 1.0d0, MF_INF ]
   call msDisplay(x,"x")
   call msDisplay(mfReal(x),"mfReal(%)")

   print "(/,A)", "*** test number 85 ***"
   x = [ (1.0d0,0.0d0), (0.0d0,1.0d0), (0.0d0,-1.0d0) ]
   call msDisplay(x,"x")
   call msDisplay(mfReal(x),"mfReal(%)")

   print "(/,A)", "*** test number 86 ***"
   y = mfReal( mf( [ (1.0d0,0.0d0), (0.0d0,1.0d0) ] ) )
   call msDisplay(y,"y = mfReal( mf( [ (1.0d0,0.0d0), (0.0d0,1.0d0) ] ) )")

   ! mfImag ------------------------------------------------------------
   call print_separation("mfImag")

   print "(/,A)", "*** test number 87 ***"
   x = [ -MF_INF, -1.0d0, 0.0d0, 1.0d0, MF_INF ]
   call msDisplay(x,"x")
   call msDisplay(mfImag(x),"mfImag(%)")

   print "(/,A)", "*** test number 88 ***"
   x = [ (1.0d0,0.0d0), (0.0d0,1.0d0), (0.0d0,-1.0d0) ]
   call msDisplay(x,"x")
   call msDisplay(mfImag(x),"mfImag(%)")

   print "(/,A)", "*** test number 89 ***"
   y = mfImag( mf( [ (1.0d0,0.0d0), (0.0d0,1.0d0) ] ) )
   call msDisplay(y,"y = mfImag( mf( [ (1.0d0,0.0d0), (0.0d0,1.0d0) ] ) )")

   ! mfRound -----------------------------------------------------------
   call print_separation("mfRound")

   print "(/,A)", "*** test number 90 ***"
   x = [ -1.75, -1.0, -0.5, -0.0, 0.0, 0.5, 1.0, 1.75 ]
   call msDisplay(x,"x")
   call msDisplay(mfRound(x),"mfRound(%)")

   print "(/,A)", "*** test number 91 ***"
   y = mfRound( mf( [ 1.0, 1.25, 1.5, 1.75, 2.0 ] ) )
   call msDisplay(y,"y = mfRound( mf( [ 1.0, 1.25, 1.5, 1.75, 2.0 ] ) )")

   ! mfCeil ------------------------------------------------------------
   call print_separation("mfCeil")

   print "(/,A)", "*** test number 92 ***"
   x = [ -1.75, -1.0, -0.5, -0.0, 0.0, 0.5, 1.0, 1.75 ]
   call msDisplay(x,"x")
   call msDisplay(mfCeil(x),"mfCeil(%)")

   print "(/,A)", "*** test number 93 ***"
   y = mfCeil( mf( [ 1.0, 1.25, 1.5, 1.75, 2.0 ] ) )
   call msDisplay(y,"y = mfCeil( mf( [ 1.0, 1.25, 1.5, 1.75, 2.0 ] ) )")

   ! mfFix -------------------------------------------------------------
   call print_separation("mfFix")

   print "(/,A)", "*** test number 94 ***"
   x = [ -1.75, -1.0, -0.5, -0.0, 0.0, 0.5, 1.0, 1.75 ]
   call msDisplay(x,"x")
   call msDisplay(mfFix(x),"mfFix(%)")

   print "(/,A)", "*** test number 95 ***"
   y = mfFix( mf( [ 1.0, 1.25, 1.5, 1.75, 2.0 ] ) )
   call msDisplay(y,"y = mfFix( mf( [ 1.0, 1.25, 1.5, 1.75, 2.0 ] ) )")

   ! mfFloor -----------------------------------------------------------
   call print_separation("mfFloor")

   print "(/,A)", "*** test number 96 ***"
   x = [ -1.75, -1.0, -0.5, -0.0, 0.0, 0.5, 1.0, 1.75 ]
   call msDisplay(x,"x")
   call msDisplay(mfFloor(x),"mfFloor(%)")

   print "(/,A)", "*** test number 97 ***"
   y = mfFloor( mf( [ 1.0, 1.25, 1.5, 1.75, 2.0 ] ) )
   call msDisplay(y,"y = mfFloor( mf( [ 1.0, 1.25, 1.5, 1.75, 2.0 ] ) )")

   ! mfMod -------------------------------------------------------------
   call print_separation("mfMod")

   print "(/,A)", "*** test number 98 ***"
   x = [ -5,  7, -15 ]
   y = [  2, -3,  -4 ]
   call msDisplay(x,"x",y,"y")
   call msDisplay(mfMod(x,y),"mfMod(x,y)")

   print "(/,A)", "*** test number 99 ***"
   y = mfMod( mf( [ -5,  7, -15 ] ), mf( [  2, -3,  -4 ] ) )
   call msDisplay(y,"y = mfMod( mf( [ -5,  7, -15 ] ), mf( [  2, -3,  -4 ] ) )")

   ! mfRem -------------------------------------------------------------
   call print_separation("mfRem")

   print "(/,A)", "*** test number 100 ***"
   x = [ -5,  7, -15 ]
   y = [  2, -3,  -4 ]
   call msDisplay(x,"x",y,"y")
   call msDisplay(mfRem(x,y),"mfRem(x,y)")

   print "(/,A)", "*** test number 101 ***"
   y = mfRem( mf( [ -5,  7, -15 ] ), mf( [  2, -3,  -4 ] ) )
   call msDisplay(y,"y = mfRem( mf( [ -5,  7, -15 ] ), mf( [  2, -3,  -4 ] ) )")

   ! mfSign ------------------------------------------------------------
   call print_separation("mfSign")

   print "(/,A)", "*** test number 102 ***"
   call mf_save_and_disable_fpe( )
   x = [ -MF_INF, -2.0d0, -1.0d0/MF_INF, 0.0d0, 2.0d0, MF_INF, MF_NAN ]
   call msDisplay(x,"x")
   call msDisplay(mfSign(x),"mfSign(%)")

   print "(/,A)", "*** test number 103 ***"
   x = [ -MF_INF, -2.0d0, 0.0d0, 2.0d0, MF_INF, MF_NAN ] +              &
       [   0.0d0,  1.0d0, 1.0d0, 1.0d0, 1.0d0, 1.0d0 ]*MF_I
   call msDisplay(x,"x")
   call msDisplay(mfSign(x),"mfSign(%)")
   call mf_restore_fpe( )

   ! mfCSign -----------------------------------------------------------
   call print_separation("mfCSign")

   print "(/,A)", "*** test number 104 ***"
   x = [ -1.0d0, -1.0d0, -0.5d0, -0.5d0, 0.0d0, 0.0d0,  0.0d0, 0.5d0, 1.0d0, 1.0d0 ] +  &
       [  0.0d0,  1.0d0,  0.0d0,  1.0d0, 0.0d0, 1.0d0, -1.0d0, 1.0d0, 0.0d0, 1.0d0 ]*MF_I
   call msDisplay(x,"x")
   call msDisplay(mfCSign(x),"mfCSign(%)")

   ! mfCot -------------------------------------------------------------
   call print_separation("mfCot")

   print "(/,A)", "*** test number 105 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ -2.0d0, -1.0d0,  0.0d0, 1.0d0,  2.0d0 ] ) .vc.             &
       mf( [ -MF_INF,  0.0d0, MF_NAN, 0.0d0, MF_INF ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfCot(x)
   call msDisplay(y,"y = mfCot(x)")
   call msDisplay(mfAcot(y),"mfAcot(y)")

   print "(/,A)", "*** test number 106 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ cmplx(0.0,-MF_INF,kind=MF_DOUBLE), (0.0d0,-2.0d0), (0.0d0,-1.0d0) ] ) .vc. &
       mf( [ cmplx(0.0, MF_INF,kind=MF_DOUBLE), (0.0d0, 2.0d0), (0.0d0, 1.0d0) ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfCot(x)
   call zeroes_small_values( y, 1.0d-6 )
   call msDisplay(y,"y = mfCot(x)")
   call msDisplay(mfAcot(y),"mfAcot(y)")

   print "(/,A)", "*** test number 107 ***"
   y = mfCot( mf( [ -1.0d0,  0.0d0, 1.0d0 ] ) )
   call msDisplay(y,"y = mfCot( mf( [ -1.0d0,  0.0d0, 1.0d0 ] ) )")

   ! mfACot ------------------------------------------------------------
   call print_separation("mfACot")

   print "(/,A)", "*** test number 108 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ -2.0d0, -1.0d0,  0.0d0, 1.0d0,  2.0d0 ] ) .vc.             &
       mf( [ -MF_INF,  0.0d0, MF_NAN, 0.0d0, MF_INF ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfACot(x)
   call msDisplay(y,"y = mfACot(x)")
   call msDisplay(mfCot(y),"mfCot(y)")

   call mf_save_and_disable_fpe( )
   print "(/,A)", "*** test number 109 ***"
   x = mf( [ cmplx(0.0,-MF_INF,kind=MF_DOUBLE), (0.0d0,-2.0d0), (0.0d0,-1.0d0) ] ) .vc. &
       mf( [ cmplx(0.0, MF_INF,kind=MF_DOUBLE), (0.0d0, 2.0d0), (0.0d0, 1.0d0) ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfACot(x)
   call msDisplay(y,"y = mfACot(x)")
   call msDisplay(mfCot(y),"mfCot(y)")

   print "(/,A)", "*** test number 110 ***"
   y = mfACot( mf( [ -1.0d0,  0.0d0, 1.0d0 ] ) )
   call msDisplay(y,"y = mfACot( mf( [ -1.0d0,  0.0d0, 1.0d0 ] ) )")

   ! mfSec -------------------------------------------------------------
   call print_separation("mfSec")

   print "(/,A)", "*** test number 111 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ -2.0d0, -1.0d0,  0.0d0, 1.0d0,  2.0d0 ] ) .vc.             &
       mf( [ -MF_INF,  0.0d0, MF_NAN, 0.0d0, MF_INF ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfSec(x)
   call msDisplay(y,"y = mfSec(x)")
   call msDisplay(mfASec(y),"mfASec(y)")

   call mf_save_and_disable_fpe( )
   print "(/,A)", "*** test number 112 ***"
   x = mf( [ cmplx(0.0,-MF_INF,kind=MF_DOUBLE), (0.0d0,-2.0d0), (0.0d0,-1.0d0) ] ) .vc. &
       mf( [ cmplx(0.0, MF_INF,kind=MF_DOUBLE), (0.0d0, 2.0d0), (0.0d0, 1.0d0) ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfSec(x)
   call msDisplay(y,"y = mfSec(x)")
   call msDisplay(mfASec(y),"mfASec(y)")

   print "(/,A)", "*** test number 113 ***"
   y = mfSec( mf( [ -1.0d0,  0.0d0, 1.0d0 ] ) )
   call msDisplay(y,"y = mfSec( mf( [ -1.0d0,  0.0d0, 1.0d0 ] ) )")

   ! mfASec ------------------------------------------------------------
   call print_separation("mfASec")

   print "(/,A)", "*** test number 114 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ -2.0d0, -1.0d0,  0.0d0, 1.0d0,  2.0d0 ] ) .vc.             &
       mf( [ -MF_INF,  0.0d0, MF_NAN, 0.0d0, MF_INF ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfASec(x)
   call msDisplay(y,"y = mfASec(x)")
   call msDisplay(mfSec(y),"mfSec(y)")

   call mf_save_and_disable_fpe( )
   print "(/,A)", "*** test number 115 ***"
   x = mf( [ cmplx(0.0,-MF_INF,kind=MF_DOUBLE), (0.0d0,-2.0d0), (0.0d0,-1.0d0) ] ) .vc. &
       mf( [ cmplx(0.0, MF_INF,kind=MF_DOUBLE), (0.0d0, 2.0d0), (0.0d0, 1.0d0) ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfASec(x)
   call msDisplay(y,"y = mfASec(x)")
   call msDisplay(mfSec(y),"mfSec(y)")

   print "(/,A)", "*** test number 116 ***"
   y = mfASec( mf( [ -1.0d0,  0.0d0, 1.0d0 ] ) )
   call msDisplay(y,"y = mfASec( mf( [ -1.0d0,  0.0d0, 1.0d0 ] ) )")

   ! mfCsc -------------------------------------------------------------
   call print_separation("mfCsc")

   print "(/,A)", "*** test number 117 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ -2.0d0, -1.0d0,  0.0d0, 1.0d0,  2.0d0 ] ) .vc.             &
       mf( [ -MF_INF,  0.0d0, MF_NAN, 0.0d0, MF_INF ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfCsc(x)
   call msDisplay(y,"y = mfCsc(x)")
   call msDisplay(mfACsc(y),"mfACsc(y)")

   print "(/,A)", "*** test number 118 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ cmplx(0.0,-MF_INF,kind=MF_DOUBLE), (0.0d0,-2.0d0), (0.0d0,-1.0d0) ] ) .vc. &
       mf( [ cmplx(0.0, MF_INF,kind=MF_DOUBLE), (0.0d0, 2.0d0), (0.0d0, 1.0d0) ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfCsc(x)
   call zeroes_small_values( y, 1.0d-6 )
   call msDisplay(y,"y = mfCsc(x)")
   call msDisplay(mfACsc(y),"mfACsc(y)")

   print "(/,A)", "*** test number 119 ***"
   y = mfCsc( mf( [ -1.0d0,  0.0d0, 1.0d0 ] ) )
   call msDisplay(y,"y = mfCsc( mf( [ -1.0d0,  0.0d0, 1.0d0 ] ) )")

   ! mfACsc ------------------------------------------------------------
   call print_separation("mfACsc")

   print "(/,A)", "*** test number 120 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ -2.0d0, -1.0d0,  0.0d0, 1.0d0,  2.0d0 ] ) .vc.             &
       mf( [ -MF_INF,  0.0d0, MF_NAN, 0.0d0, MF_INF ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfACsc(x)
   call msDisplay(y,"y = mfACsc(x)")
   call msDisplay(mfCsc(y),"mfCsc(y)")

   call mf_save_and_disable_fpe( )
   print "(/,A)", "*** test number 121 ***"
   x = mf( [ cmplx(0.0,-MF_INF,kind=MF_DOUBLE), (0.0d0,-2.0d0), (0.0d0,-1.0d0) ] ) .vc. &
       mf( [ cmplx(0.0, MF_INF,kind=MF_DOUBLE), (0.0d0, 2.0d0), (0.0d0, 1.0d0) ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfACsc(x)
   call zeroes_small_values( y, 1.0d-6 )
   call msDisplay(y,"y = mfACsc(x)")
   z = mfCsc(y)
   call zeroes_small_values( z, 1.0d-6 )
   call msDisplay(z,"mfCsc(y)")

   print "(/,A)", "*** test number 122 ***"
   y = mfACsc( mf( [ -1.0d0,  0.0d0, 1.0d0 ] ) )
   call msDisplay(y,"y = mfACsc( mf( [ -1.0d0,  0.0d0, 1.0d0 ] ) )")

   ! mfCoth ------------------------------------------------------------
   call print_separation("mfCoth")

   print "(/,A)", "*** test number 123 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ -2.0d0, -1.0d0,  0.0d0, 1.0d0,  2.0d0 ] ) .vc.             &
       mf( [ -MF_INF,  0.0d0, MF_NAN, 0.0d0, MF_INF ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfCoth(x)
   call msDisplay(y,"y = mfCoth(x)")
   call msDisplay(mfACoth(y),"mfACoth(y)")

   call mf_save_and_disable_fpe( )
   print "(/,A)", "*** test number 124 ***"
   x = mf( [ cmplx(0.0,-MF_INF,kind=MF_DOUBLE), (0.0d0,-2.0d0), (0.0d0,-1.0d0) ] ) .vc. &
       mf( [ cmplx(0.0, MF_INF,kind=MF_DOUBLE), (0.0d0, 2.0d0), (0.0d0, 1.0d0) ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfCoth(x)
   call zeroes_small_values( y, 1.0d-6 )
   call msDisplay(y,"y = mfCoth(x)")
   z = mfACoth(y)
   call zeroes_small_values( z, 1.0d-6 )
   call msDisplay(z,"mfACoth(y)")

   print "(/,A)", "*** test number 125 ***"
   y = mfCoth( mf( [ -1.0d0,  0.0d0, 1.0d0 ] ) )
   call msDisplay(y,"y = mfCoth( mf( [ -1.0d0,  0.0d0, 1.0d0 ] ) )")

   ! mfACoth -----------------------------------------------------------
   call print_separation("mfACoth")

   print "(/,A)", "*** test number 126 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ -2.0d0, -1.0d0,  0.0d0, 1.0d0,  2.0d0 ] ) .vc.             &
       mf( [ -MF_INF,  0.0d0, MF_NAN, 0.0d0, MF_INF ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfACoth(x)
   call msDisplay(y,"y = mfACoth(x)")
   z = mfCoth(y)
   call zeroes_small_values( z, 1.0d-6 )
   call msDisplay(z,"mfCoth(y)")

   call mf_save_and_disable_fpe( )
   print "(/,A)", "*** test number 127 ***"
   x = mf( [ cmplx(0.0,-MF_INF,kind=MF_DOUBLE), (0.0d0,-2.0d0), (0.0d0,-1.0d0) ] ) .vc. &
       mf( [ cmplx(0.0, MF_INF,kind=MF_DOUBLE), (0.0d0, 2.0d0), (0.0d0, 1.0d0) ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfACoth(x)
   call msDisplay(y,"y = mfACoth(x)")
   z = mfCoth(y)
   call zeroes_small_values( z, 1.0d-6 )
   call msDisplay(z,"mfCoth(y)")

   print "(/,A)", "*** test number 128 ***"
   y = mfACoth( mf( [ -1.0d0,  0.0d0, 1.0d0 ] ) )
   call msDisplay(y,"y = mfACoth( mf( [ -1.0d0,  0.0d0, 1.0d0 ] ) )")

   ! mfSech ------------------------------------------------------------
   call print_separation("mfSech")

   print "(/,A)", "*** test number 129 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ -2.0d0, -1.0d0,  0.0d0, 1.0d0,  2.0d0 ] ) .vc.             &
       mf( [ -MF_INF,  0.0d0, MF_NAN, 0.0d0, MF_INF ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfSech(x)
   call msDisplay(y,"y = mfSech(x)")
   call msDisplay(mfASech(y),"mfASech(y)")

   call mf_save_and_disable_fpe( )
   print "(/,A)", "*** test number 130 ***"
   x = mf( [ cmplx(0.0,-MF_INF,kind=MF_DOUBLE), (0.0d0,-2.0d0), (0.0d0,-1.0d0) ] ) .vc. &
       mf( [ cmplx(0.0, MF_INF,kind=MF_DOUBLE), (0.0d0, 2.0d0), (0.0d0, 1.0d0) ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfSech(x)
   call msDisplay(y,"y = mfSech(x)")
   call msDisplay(mfASech(y),"mfASech(y)")

   print "(/,A)", "*** test number 131 ***"
   y = mfSech( mf( [ -1.0d0,  0.0d0, 1.0d0 ] ) )
   call msDisplay(y,"y = mfSech( mf( [ -1.0d0,  0.0d0, 1.0d0 ] ) )")

   ! mfASech -----------------------------------------------------------
   call print_separation("mfASech")

   print "(/,A)", "*** test number 132 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ -2.0d0, -1.0d0,  0.0d0, 1.0d0,  2.0d0 ] ) .vc.             &
       mf( [ -MF_INF,  0.0d0, MF_NAN, 0.0d0, MF_INF ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfASech(x)
   call msDisplay(y,"y = mfASech(x)")
   call msDisplay(mfSech(y),"mfSech(y)")

   call mf_save_and_disable_fpe( )
   print "(/,A)", "*** test number 133 ***"
   x = mf( [ cmplx(0.0,-MF_INF,kind=MF_DOUBLE), (0.0d0,-2.0d0), (0.0d0,-1.0d0) ] ) .vc. &
       mf( [ cmplx(0.0, MF_INF,kind=MF_DOUBLE), (0.0d0, 2.0d0), (0.0d0, 1.0d0) ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfASech(x)
   call msDisplay(y,"y = mfASech(x)")
   call msDisplay(mfSech(y),"mfSech(y)")

   print "(/,A)", "*** test number 134 ***"
   y = mfASech( mf( [ -1.0d0,  0.0d0, 1.0d0 ] ) )
   call msDisplay(y,"y = mfASech( mf( [ -1.0d0,  0.0d0, 1.0d0 ] ) )")

   ! mfCsch ------------------------------------------------------------
   call print_separation("mfCsch")

   print "(/,A)", "*** test number 135 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ -2.0d0, -1.0d0,  0.0d0, 1.0d0,  2.0d0 ] ) .vc.             &
       mf( [ -MF_INF,  0.0d0, MF_NAN, 0.0d0, MF_INF ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfCsch(x)
   call msDisplay(y,"y = mfCsch(x)")
   call msDisplay(mfACsch(y),"mfACsch(y)")

   call mf_save_and_disable_fpe( )
   print "(/,A)", "*** test number 136 ***"
   x = mf( [ cmplx(0.0,-MF_INF,kind=MF_DOUBLE), (0.0d0,-2.0d0), (0.0d0,-1.0d0) ] ) .vc. &
       mf( [ cmplx(0.0, MF_INF,kind=MF_DOUBLE), (0.0d0, 2.0d0), (0.0d0, 1.0d0) ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfCsch(x)
   call zeroes_small_values( y, 1.0d-6 )
   call msDisplay(y,"y = mfCsch(x)")
   call msDisplay(mfACsch(y),"mfACsch(y)")

   print "(/,A)", "*** test number 137 ***"
   y = mfCsch( mf( [ -1.0d0,  0.0d0, 1.0d0 ] ) )
   call msDisplay(y,"y = mfCsch( mf( [ -1.0d0,  0.0d0, 1.0d0 ] ) )")

   ! mfACsch -----------------------------------------------------------
   call print_separation("mfACsch")

   print "(/,A)", "*** test number 138 ***"
   call mf_save_and_disable_fpe( )
   x = mf( [ -2.0d0, -1.0d0,  0.0d0, 1.0d0,  2.0d0 ] ) .vc.             &
       mf( [ -MF_INF,  0.0d0, MF_NAN, 0.0d0, MF_INF ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfACsch(x)
   call msDisplay(y,"y = mfACsch(x)")
   call msDisplay(mfCsch(y),"mfCsch(y)")

   call mf_save_and_disable_fpe( )
   print "(/,A)", "*** test number 139 ***"
   x = mf( [ cmplx(0.0,-MF_INF,kind=MF_DOUBLE), (0.0d0,-2.0d0), (0.0d0,-1.0d0) ] ) .vc. &
       mf( [ cmplx(0.0, MF_INF,kind=MF_DOUBLE), (0.0d0, 2.0d0), (0.0d0, 1.0d0) ] )
   call mf_restore_fpe( )
   call msDisplay(x,"x")
   y = mfACsch(x)
   call zeroes_small_values( y, 1.0d-6 )
   call msDisplay(y,"y = mfACsch(x)")
   z = mfCsch(y)
   call zeroes_small_values( z, 1.0d-6 )
   call msDisplay(z,"mfCsch(y)")

   print "(/,A)", "*** test number 140 ***"
   y = mfACsch( mf( [ -1.0d0,  0.0d0, 1.0d0 ] ) )
   call msDisplay(y,"y = mfACsch( mf( [ -1.0d0,  0.0d0, 1.0d0 ] ) )")

   ! mfHypot -----------------------------------------------------------
   call print_separation("mfHypot")

   print "(/,A)", "*** test number 141 ***"
   x = 3.0d0 * [ 1.0d300, 1.0d-300 ]
   y = 4.0d0 * [ 1.0d300, 1.0d-300 ]
   call msDisplay(x,"x",y,"y")
   call msDisplay(mfHypot(x,y),"mfHypot(x,y)")

   ! mfFun -------------------------------------------------------------
   call print_separation("mfFun")

   print "(/,A)", "*** test number 142 ***"
   x = mfMagic(3) - 5.0d0
   call msDisplay(x,"x")
   call msDisplay( mfFun(x,fun_user_1_real), "mfFun(x,fun_user_1_real)" )

   print "(/,A)", "*** test number 143 ***"
   x = mfMagic(3) - 5.0d0*MF_I
   call msDisplay(x,"x")
   call msDisplay( mfFun(x,fun_user_1_cmplx), "mfFun(x,fun_user_1_cmplx)" )

   ! mfFun2 ------------------------------------------------------------
   call print_separation("mfFun2")

   print "(/,A)", "*** test number 144 ***"
   x = mfMagic(3) - 5.0d0
   call msDisplay(x,"x")
   y = mfRot90(x)
   call msDisplay(y,"y")
   call msDisplay( mfFun2(x,y,fun_user_2_real), "mfFun(x,y,fun_user_2_real)" )

   print "(/,A)", "*** test number 145 ***"
   x = mfMagic(3) - 5.0d0*MF_I
   call msDisplay(x,"x")
   y = mfRot90(x)
   call msDisplay(y,"y")
   call msDisplay( mfFun2(x,y,fun_user_2_cmplx), "mfFun(x,y,fun_user_2_cmplx)" )

   ! mfGridFun ---------------------------------------------------------
   call print_separation("mfGridFun")

   print "(/,A)", "*** test number 146 ***"
   x =     mfLinSpace( 0.0d0, 1.0d0, 6 )
   y = .t. mfLinSpace( 1.0d0, 0.0d0, 6 )
   z = mfGridFun( x, y, "cmplx" )
   call msDisplay(z,"z = cmplx(x,y)")

   print "(/,A)", "*** test number 147 ***"
   x =     mfLinSpace( 0.0d0, 1.0d0, 6 )
   y = .t. mfLinSpace( 1.0d0, 0.0d0, 6 )
   z = mfGridFun( x, y, "hypot" )
   call msDisplay(z,"r = hypot(x,y) = sqrt(x**2 + y**2)")

   print "(/,A)", "*** test number 148 ***"
   x =     mfLinSpace( 0.0d0, 1.0d0, 6 )
   y = .t. mfLinSpace( 1.0d0, 0.0d0, 6 )
   z = mfGridFun( x, y, "atan2" )
   call msSet( MF_NAN, z, 6, 1 )
   call msDisplay(z,"theta = arg(x,y) = atan2(y,x)")

   print "(/,A)", "*** test number 149 ***"
   x =     mfLinSpace( 0.0d0, 1.0d0, 6 )
   y = .t. mfLinSpace( 1.0d0, 0.0d0, 6 )
   z = mfGridFun( x, y, fun_user_2_real )
   call msDisplay(z,"fun_user_2_real(x,y)")

   ! other way to compute the last z
   call msMeshGrid( mfOut(mat_X,mat_Y), x, y )
   z2 = mfFun2( mat_X, mat_Y, fun_user_2_real )
   call msDisplay(z,"fun_user_2_real(x,y) [other way]")

   ! check the difference
   e = mfAbs( z - z2 )
   call msDisplay(e,"difference between the two way of computation")
   call check_small( e, "the difference", check_small_threshold )


   ! End of tests ------------------------------------------------------
   print "(A)", "                         ┏━━━━━━━━━━━━━━━━━━━━━━━┓"
   print "(A)", "                         ┃ End of test_mod_elfun ┃"
   print "(A)", "                         ┗━━━━━━━━━━━━━━━━━━━━━━━┛"

   !--------------------------------------------------------------------
99 continue

   print "()"
   call msSetMsgLevel(2)

   call msRelease( x, y, m, e )
   call msRelease( z, z2, mat_X, mat_Y )

end program
