module test_aux

   use fml, only : mfGetTermWidth

   implicit none

contains
!_______________________________________________________________________
!
   subroutine print_separation( name )

      character(len=*), intent(in) :: name

      integer :: i, length, index, n_shell_col

      character(len=512) :: line

      n_shell_col = mfGetTermWidth()

      line = ""
      do i = 1, n_shell_col-1
         line(i:i) = "-"
      end do

      length = len_trim( adjustr(name) )
      if( length == 0 ) then
         print "(a)", trim(line)
         return
      end if

      length = length + 2
      index = (n_shell_col-1)/2 - length/2
      if( index < 1 ) then
         print "(a)", trim( adjustr(name) )
      else
         line(index:index+length-1) = " " // trim( adjustr(name) ) // " "
         print "(a)", trim(line)
      end if

   end subroutine print_separation
!_______________________________________________________________________
!
end module test_aux
