program TriQuiver_test

   use fml
   use fgl

   use test_aux

   implicit none

   type(mfArray) :: x, y, u, v
   type(mfArray) :: tri

!_______________________________________________________________________
!

   call run_options()

   !---------------

   call msFigure(1)

   call msAxis( "equal" )
   call msAxis( [ -0.2d0, 1.3d0, -0.1d0, 1.4d0 ] )

   x = [ 0.05d0,  1.05d0, 1.0d0, -0.15d0, 0.65d0, 0.4d0, 1.2d0, 0.2d0, 0.4d0 ]
   y = [ 0.00d0, -0.05d0, 1.0d0,  0.95d0, 0.50d0, 1.3d0, 0.3d0, 0.4d0, 0.9d0 ]
   call msDisplay( .t.(x .vc. y), "nodes (x, y)" )

   u = mfRand( size(x,1), size(x,2) )
   v = mfRand( size(x,1), size(x,2) )

   call msTriQuiver( x, y, u, v )
   call msXLabel( "x" )
   call msYLabel( "y" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "TriQuiver_1.eps" )
   call msPrint( "TriQuiver_1.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   !---------------

   call msFigure(2)

   call msAxis( "equal" )
   call msAxis( [ -0.2d0, 1.3d0, -0.1d0, 1.4d0 ] )

   x = [ 0.05d0,  1.05d0, 1.0d0, -0.15d0, 0.65d0, 0.4d0, 1.2d0, 0.2d0, 0.4d0 ]
   y = [ 0.00d0, -0.05d0, 1.0d0,  0.95d0, 0.50d0, 1.3d0, 0.3d0, 0.4d0, 0.9d0 ]
   call msDisplay( .t.(x .vc. y), "nodes (x, y)" )

   u = mfRand( size(x,1), size(x,2) )
   v = mfRand( size(x,1), size(x,2) )

   tri = mfDelaunay( x, y )
   call msDisplay( tri, "triangles" )

   call msColorMap( "grey" )
   call msTriMesh( x, y, tri ) ! default color is black
   call msHold( "on" )

   call msTriQuiver( x, y, u, v, color="r" )
   call msXLabel( "x" )
   call msYLabel( "y" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "TriQuiver_2.eps" )
   call msPrint( "TriQuiver_2.pdf" )
   write(STDOUT,"(A,/)") " done ***"

!_______________________________________________________________________
!
99 continue

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y, u, v )
   call msRelease( tri )

end program
