! this file must be kept in UTF-8 encoding

program Text_layout_UTF8_test

   use fml
   use fgl

   use test_aux

   implicit none

   character(len=1) :: ans
   logical :: interactive

   ! For X11 test: don't print accented letters using a font other than
   ! normal: the glyphs for the 3 other fonts (roman, italic, script) are
   ! not yet designed!
   ! (but it should be ok for EPS printing)

!_______________________________________________________________________
!

   call run_options()

   write(*,"(A)",advance="no") " --------> skip interactive session ? [Y]/N "
   read "(A)", ans
   interactive = mfToUpper(ans) == "N"

   call msSetCharEncoding( "UTF-8" )

   !---------------------------------
   !--- For both X11, EPS and PDF ---
   !---------------------------------

   call msFigure( 1, position=[50,50], size=[900,500] )

   call msCharInPixels( "off" )

   call msAxis( "off" )
   call msAxis( [ 0.0d0, 2.2d0, -0.25d0, 1.1d0 ] )

   call msText( -0.1d0, 1.2d0, "a \x b\.c - m\2 m\3",                   &
                height=3.0d0, clipping=.false. )
   call msText( 0.60d0, 1.2d0, "", height=3.0d0 )
   call msText( 0.80d0, 1.2d0, "- 8\s10", height=3.0d0 )
   call msText( 1.15d0, 1.2d0, "- 8\s20", height=3.0d0 )
   call msText( 1.50d0, 1.2d0, "- 8\s30", height=3.0d0 )
   call msText( 1.82d0, 1.2d0, "- 80", height=3.0d0 )
   call msText( -0.1d0, 1.0d0, "\oe \OE æ Æ   trait-d'union   mode math:" &
                // " a \- b   a\-b   \fNa\-b",                          &
                height=3.0d0, clipping=.false. )
   call msText( -0.1d0, 0.8d0,                                          &
                "\(Gamma) \(Delta) \(Theta) \(Lambda) \(Pi) \(Sigma) \(Upsilon)" &
                // " \(Omega) - \gy \gh \gf \gj \gq \gw \gv",           &
                height=3.0d0, clipping=.false. )
   call msText( -0.1d0, 0.6d0,                                          &
                "\fiy = e\ux\u2\d\d \-  \fsL\fi\d\(alpha)\dh\u\u 2\u2\u2\d\d 3\d3\d3\u\u \A \fn \A", &
                height=3.0d0, angle=0.0d0, clipping=.false. )
   call msText( -0.1d0, 0.4d0, "C\dp\b\u\un",                           &
                height=3.0d0, angle=0.0d0, clipping=.false. )
   call msText( 0.4d0, 0.4d0, "c\d\(psi)\b\u\u\(psi)", height=3.0d0 )
   call msText( 0.9d0, 0.4d0, "c\d\ga,\s3\gb\b\b\b\b\u\u\gd,\s3\ge",    &
                height=3.0d0 )
   call msText( 1.4d0, 0.4d0, "a\dlow\b\b\b\u\usup", height=3.0d0 )
   call msText( 1.8d0, 0.4d0, "A\dlower\b\b\b\b\b\u\uup",               &
                height=3.0d0, angle=30.d0 )
   call msText( -0.1d0, 0.2d0, "\frabcqE",                              &
                height=3.0d0, clipping=.false. )
   call msText( 0.6d0, 0.2d0, "\ga,\s3\gb \gd,\s3\ge", height=3.0d0 )
   call msText( -0.1d0, 0.0d0, "éq\b\béq",                              &
                height=3.0d0, clipping=.false. )
   call msText( 0.1d0, 0.0d0, "\oe\b\oe", height=3.0d0 )
   call msText( 0.5d0, 0.0d0, "q", height=3.0d0 )
   call msText( 0.7d0, 0.0d0, "É", height=3.0d0 )
   call msText( 0.9d0, 0.0d0, "Ç", height=3.0d0 )
   call msText( 1.1d0, 0.0d0, "b", height=3.0d0 )
   call msText( 1.3d0, 0.0d0, "3", height=3.0d0 )
   call msText( 1.5d0, 0.0d0, "e", height=1.0d0 )
   call msText( 1.7d0, 0.0d0, "é", height=6.0d0 )

#ifndef _NO_X11
   if( mfGetX11Device() == "on" .and. interactive ) then
      call msResizeWindow()
   end if
#endif

   call msPrint("Text_layout_UTF8_X11.eps")
   print *, "   *************************************************************************"
   print *, "   *** Warning: Under linux, some versions of 'okular' (PDF reader)      ***"
   print *, "   ***          are not able to display the small 2 et 3 numbers         ***"
   print *, "   ***          when they are superscript (Muesli codes: \2 and \3).     ***"
   print *, "   ***          If it is the case, try another reader (e.g. 'evince')... ***"
   print *, "   *************************************************************************"
   call msPrint("Text_layout_UTF8_X11.pdf")
   call msPause()

   !----------------------------
   !--- Only for EPS and PDF ---
   !----------------------------

   call msFigure( 2, position=[100,100], size=[900,500] )

   call msCharInPixels( "off" )

   call msAxis( "off" )
   call msAxis( [ 0.0d0, 2.2d0, -0.25d0, 1.1d0 ] )

   call msText( -0.1d0, 1.2d0, "\fia \x b\.c - m\2 m\3",                &
                height=3.0d0, clipping=.false. )
   call msText(  1.3d0, 0.8d0, "\fs A B F L i j k l m", height=3.0d0 )

   call msPrint("Text_layout_UTF8_no_X11.eps")
   print *, "   *************************************************************************"
   print *, "   *** Warning: Under linux, some versions of 'okular' (PDF reader)      ***"
   print *, "   ***          are not able to display the small 2 et 3 numbers         ***"
   print *, "   ***          when they are superscript (Muesli codes: \2 and \3).     ***"
   print *, "   ***          If it is the case, try another reader (e.g. 'evince')... ***"
   print *, "   *************************************************************************"
   call msPrint("Text_layout_UTF8_no_X11.pdf")

!_______________________________________________________________________
!

99 continue
   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

end program
