program PlotVoronoi_test

   use fml
   use fgl

   use test_aux

   implicit none

   type(mfArray) :: x, y
   type(mfVoronoiStruct) :: voronoi
   character(len=1) :: ans
   logical :: interactive

!_______________________________________________________________________
!

   call run_options()

   write(*,"(a)",advance="no") "  --------> skip interactive session ? [Y]/N "
   read "(a)", ans
   interactive = mfToUpper(ans) == "N"

   call msAxis( [ -0.05d0, 1.8d0, -0.05d0, 2.05d0 ] )
   call msAxis( "equal" )

   x = [ 0., 0.5,  1., 1.25, 1.5, 1.625, 1.750 ]
   y = [ 0., 0.5,  0., 1.,   0.,  2.,    0. ]

   voronoi = mfVoronoi( x, y, what="vertices" )
   call msPlotVoronoi( voronoi )

#ifndef _NO_X11
   if( mfGetX11Device() == "on" .and. interactive ) then
      call msPanAndZoom( )
   end if
#endif

   call msPrint( "PlotVoronoi.eps" )
   call msPrint( "PlotVoronoi.pdf" )

!_______________________________________________________________________
!
99 continue

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y )

end program
