program PlotCubicSpline_test

   use fml
   use fgl

   use test_aux

   implicit none

   type(mfArray) :: abs_curv, x, y, wx, wy, y_smooth, weights,          &
                    x1, x2, y1, y2, w1, w2

   character(len=1) :: ans
   logical :: interactive

!_______________________________________________________________________
!

   call run_options()

   write(*,"(a)",advance="no") "  --------> skip interactive session ? [Y]/N "
   read "(a)", ans
   interactive = mfToUpper(ans) == "N"

   abs_curv = [ 0., 1., 2., 3., 4., 5., 6. ]
   x = [ 0., 0.3333, 0.3333, 0.6667, 0.6667, 1., 1. ]
   y = [ 0., 0., 1., 1., 0., 0., 1. ]

   wx = mfSpline( abs_curv, x )
   wy = mfSpline( abs_curv, y )

   call msFigure(1)
   call msPlotCubicSpline( abs_curv, x, y, wx, wy, linewidth=1.5d0 )
   call msHold( "on" )
   call msPlot( x, y, "ro" )

#ifndef _NO_X11
   if( mfGetX11Device() == "on" .and. interactive ) then
      call msZoom( )
   end if
#endif

   call msPrint( "PlotCubicSpline_1.eps" )
   call msPrint( "PlotCubicSpline_1.pdf" )

   !-------------------------------------------------------

   x = mfColon( 1.0d0, 20.0d0 )
   y = mfReal( (-1.0d0)**x )
   weights = 1.0d2
   call msSpline( mfOut(y_smooth,wy), x, y, weights )

   call msFigure(2)
   call msPlot( x, y, "ro" )
   call msAxis( [ 0.0d0, 21.0d0, -1.2d0,1.2d0] )

   wx = x * 0.0d0 ! vector of zero of same length as x
   call msHold( "on" )
   call msPlot( x, y_smooth, "b+" )
   call msPlotCubicSpline( x, x, y_smooth, wx, wy, linewidth=1.5d0 )

   call msPrint( "PlotCubicSpline_2.eps" )
   call msPrint( "PlotCubicSpline_2.pdf" )

   !-------------------------------------------------------

   ! This last example illustrates that the weights can be scaled to
   ! h^3 if you want the same smoothing behavior when the data points
   ! are not equally spaced.
   ! (when changing the level of smoothing, expect a strange behavior in
   !  the middle is typical when using a jump between two series of
   !  intervals)

   x1 = mfColon( 1.0d0, 20.0d0 )
   y1 = mfReal( (-1.0d0)**x1 )
   x2 = mfLinSpace( 20.5d0, 30.0d0, 20 )
   y2 = mfReal( (-1.0d0)**(2.0d0*x2) )
   x = x1 .hc. x2
   y = y1 .hc. y2
   w1 = 1.0d2 + 0*x1
   w2 = 1.0d2/(0.5d0)**3 + 0*x2
   weights = w1 .hc. w2
!!   call msDisplay( weights, "weights" )
   call msSpline( mfOut(y_smooth,wy), x, y, weights )

   call msFigure(3)
   call msPlot( x, y, "ro" )
   call msAxis( [ 0.0d0, 31.0d0, -1.2d0,1.2d0] )

   wx = x * 0 ! vector of zero of same length as x
   call msHold( "on" )
   call msPlot( x, y_smooth, "b+" )
   call msPlotCubicSpline( x, x, y_smooth, wx, wy, linewidth=1.5d0 )

   call msPrint( "PlotCubicSpline_3.eps" )
   call msPrint( "PlotCubicSpline_3.pdf" )

!_______________________________________________________________________
!
99 continue

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( abs_curv, x, y, wx, wy )

end program
