program PlotCubicBezier_test

   use fml
   use fgl

   use test_aux

   implicit none

   type(mfArray) :: x, y
   integer :: i, n_seg, ioff
   integer, allocatable :: h(:)
   character(len=1) :: ans
   logical :: interactive

!_______________________________________________________________________
!

   call run_options()

   write(*,"(a)",advance="no") "  --------> skip interactive session ? [Y]/N "
   read "(a)", ans
   interactive = mfToUpper(ans) == "N"

   call msAxis( [ -0.1d0, 1.1d0, -0.1d0, 1.1d0 ] )
   call msAxis( "equal" )

   x = [ 0., 0.3333, 0.3333, 0.6667, 0.6667, 1., 1. ]
   y = [ 0., 0., 1., 1., 0., 0., 1. ]

   call msPlotCubicBezier( x, y, linewidth=1.0d0 )

   n_seg = (Size(x)-1)/3
   allocate( h(2*n_seg+1) )

   ! position des points de contrôle (cas général à conserver)
   ! nb of segment
   call msHold( "on" )
   h(1) = mfPlot( x, y, "r+" )
   do i = 1, n_seg
      ioff = 3*(i-1)
      h(2*i) = mfPlot( mfGet(x,ioff+1 .to. ioff+2),                     &
                   mfGet(y,ioff+1 .to. ioff+2), "r--", linewidth=0.5d0 )
      h(2*i+1) = mfPlot( mfGet(x,ioff+3 .to. ioff+4),                   &
                   mfGet(y,ioff+3 .to. ioff+4), "r--", linewidth=0.5d0 )
   end do

#ifndef _NO_X11
   if( mfGetX11Device() == "on" .and. interactive ) then
      call msPan( )
   end if
#endif

   call msPrint( "PlotCubicBezier.eps" )
   call msPrint( "PlotCubicBezier.pdf" )
   ! les pointillés rouges sont composés de plusieurs segments (ici 2*n_seg),
   ! -> on fusionne les handles pour en faire un seul OCG
   call msSetPdfOC( h(:), merge=.true., name="trapezoidal constructor" )
   call msPrint( "PlotCubicBezier_OC.pdf" )

!_______________________________________________________________________
!
99 continue

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y )

end program
