! this program test needs that X11 device is not disabled.

program PlotAnim_test

   ! How to make a smooth animation.

   use fml
   use fgl

   use test_aux

   implicit none

   integer, parameter :: n = 50

   type(mfArray) :: x, y1, y2
   real(kind=MF_DOUBLE) :: phase, dx
   integer :: i, k
   character(len=1) :: ans
   logical :: skip

!_______________________________________________________________________
!

   call run_options()

   if( X11_OFF ) then
      print *, "This test requires X11."
      stop
   end if

#ifdef _NO_X11

   print *, "This test requires X11."

#else

   call msSetMsgLevel( 1 ) ! only errors are displayed, not warnings nor infos

   !=====================================
   call msFigure(1)
   call msAxis( [ 0.0d0, 1.0d0, -1.0d0, 1.0d0 ] )
   call msGrid( "on" )
   call msXLabel( "X" )
   call msYLabel( "Y" )
   call msTitle( "One animated curve" )

   ! animate 1 curve ----------------------
   x = mfLinSpace( 0.0d0, 1.0d0, n )
   y1 = mfSin( 2.0d0*MF_PI*x )
   call msPlot( x, y1, "bo-" )
   call msText( 0.43d0, 0.52d0, "Sine curve", color="b" )
   print *, "moving curve:"
   write(*,"(a)",advance="no") "  --------> skip animation ? [Y]/N "
   read "(a)", ans
   if( ans == "n" .or. ans == "N" ) then
      skip = .false.
   else
      skip = .true.
   end if

   call msAnimation( "on" )
   k = 200
   do i = 1, k
      if( skip ) exit

      phase = i*2.0d0*MF_PI/k
      y1 = mfSin( 2.0d0*MF_PI*x - phase )

      call msCla
      call msDrawGrid
      call msPlot( x, y1, "bo-" )
      if( i < 0.54d0*k ) then
         dx = dble(i)/k
         call msText( 0.43d0+dx, 0.52d0, "Sine curve", color="b" )
      else
         dx = dble(i)/k - 1.0d0
         call msText( 0.43d0+dx, 0.52d0, "Sine curve", color="b" )
      end if
      call msDrawbox
      call msShowNow
      call msPause( duration=0.015d0 )
   end do
   call msAnimation( "off" )

   call msClf()

   ! here, we are out-of the animation... we should be able to redraw the
   ! figure and print it...
   call msDrawGrid
   call msPlot( x, y1, "bo-" )
   call msText( 0.43d0, 0.52d0, "Sine curve", color="b" )
   call msPrint("Plot_Anim_1.eps")
   if( .not. skip ) then
      call msPause
   end if

   ! animate 2 curves ----------------------
   call msTitle( "Two animated curves" )
   x = mfLinSpace( 0.0d0, 1.0d0, n )
   y1 = mfSin( 2.0d0*MF_PI*x )
   call msPlot( x, y1, "bo-" )
   call msText( 0.43d0, 0.52d0, "Sine curve", color="b" )
   call msHold( "on" )
   y2 = mfSin( 2.0d0*MF_PI*x - MF_PI )
   call msPlot( x, y2, "ro-" )
   call msText( 0.29d0, -0.48d0, "Another curve", color="r" )
   print *, "moving curves:"
   write(*,"(a)",advance="no") "  --------> skip animation ? [Y]/N "
   read "(a)", ans
   if( ans == "n" .or. ans == "N" ) then
      skip = .false.
   else
      skip = .true.
   end if

   call msAnimation( "on" )
   k = 200
   do i = 1, k
      if( skip ) exit

      phase = i*2.0d0*MF_PI/k
      y1 = mfSin( 2.0d0*MF_PI*x - phase )

      call msCla
      call msDrawGrid
      call msPlot( x, y1, "bo-" )
      if( i < 0.54d0*k ) then
         dx = dble(i)/k
         call msText( 0.43d0+dx, 0.52d0, "Sine curve", color="b" )
      else
         dx = dble(i)/k - 1.0d0
         call msText( 0.43d0+dx, 0.52d0, "Sine curve", color="b" )
      end if
      y2 = mfSin( 2.0d0*MF_PI*x - MF_PI + phase )
      call msPlot( x, y2, "ro-" )
      if( i < 0.34d0*k ) then
         dx = dble(i)/k
         call msText( 0.29d0-dx, -0.48d0, "Another curve", color="r" )
      else
         dx = dble(i)/k - 1.0d0
         call msText( 0.29d0-dx, -0.48d0, "Another curve", color="r" )
      end if
      call msDrawbox
      call msShowNow
      call msPause( duration=0.015d0 )
   end do
   call msAnimation( "off" )

   call msClf()

   ! here, we are out-of the animation... we should be able to redraw the
   ! figure and print it...
   call msDrawGrid
   call msPlot( x, y1, "bo-" )
   call msText( 0.43d0, 0.52d0, "Sine curve", color="b" )
   call msHold( "on" )
   call msPlot( x, y2, "ro-" )
   call msText( 0.29d0, -0.48d0, "Another curve", color="r" )
   call msPrint("Plot_Anim_2.eps")

!_______________________________________________________________________
!
99 continue

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y1, y2 )

#endif

end program
