program Patch_test

   use fml
   use fgl

   use test_aux

   implicit none

   type(mfArray) :: x, y, c

!_______________________________________________________________________
!

   call run_options()

   call msFigure(1)

   call msCAxis( [ 0.0d0, 1.0d0 ] )

   call msColormapSize( 256 )
   print *, " Colormap size = ", mfColormapSize()

   call msColormap( "rainbow" )

   call msDisplay(mfCAxis(),"Color Axis")

   ! remarks about the following tests:
   !  (i) The special 'Flag' colormap may be used (with a moderate number
   !      of colors) to check the linearity of colors (or good gradients)
   !      for some cases using not flat shading.
   !                call msColormapSize( 64 )
   !                call msColormap( "flag" )
   ! (ii) Using Pan_and_Zoom from time to time for all tests is a good way
   !      to find errors and bugs.
   !                call msPanAndZoom()
   !-------------------------------------------------------------------------

   ! ------ flat, rectangular case ------
   print *, " test 1"

   call msAxis( [0.05d0, 0.95d0, 0.05d0, 0.95d0] )
   call msAxis( "equal" )
   ! using temporary arrays
   call msPatch( mf([ 0., 1., 1., 0. ]), mf([ 0., 0., 1., 1. ]),        &
                 mf([ 1., 0., 1., 0. ]) )
   ! call msPanAndZoom()

   call msPrint("Patch_rect_flat.eps")
   call msPrint("Patch_rect_flat.pdf")

   call msPause()

   call msClf()

   ! ------ flat, not rectangular case ------
   print *, " test 2"

   x = [ 0.5, 1.0, 0.5, 0.0 ]
   y = [ 0.0, 0.5, 1.0, 0.5 ]
   c = [ 1.0, 0.6, 0.4, 0.2 ]

   call msAxis( [0.1d0, 1.0d0, 0.0d0, 1.0d0] )
   call msPatch( x, y, c )
   ! call msPanAndZoom()

   call msPrint("Patch_not_rect_flat.eps")
   call msPrint("Patch_not_rect_flat.pdf")

   call msPause()

   call msClf()

   ! ------ not flat, not rectangular case ------
   print *, " test 3"

   call msShading( "interp" )

   x = [ 0.5, 1.0, 0.5, 0.0 ]
   y = [ 0.0, 0.5, 1.0, 0.5 ]
   c = [ 1.0, 0.6, 0.4, 0.2 ]

   call msAxis( [0.0d0, 1.0d0, 0.0d0, 1.0d0] )
   call msPatch( x, y, c )
   ! call msPanAndZoom()

   call msPrint("Patch_not_rect_not_flat.eps")
   call msPrint("Patch_not_rect_not_flat.pdf")

   call msPause()

   call msClf()

   ! ------ not flat, rectangular case ------
   print *, " test 4"

   x = [ 0.1, 0.9, 0.9, 0.1 ]
   y = [ 0.1, 0.1, 0.9, 0.9 ]
   c = [ 1., 0., 0., 0. ]

   call msAxis( "equal" )
   call msPatch( x, y, c )
   ! call msPanAndZoom()

   call msPrint("Patch_rect_not_flat.eps")
   call msPrint("Patch_rect_not_flat.pdf")

   call msPause()

   call msClf()

   ! ------ rectangular case ------
   print *, " test 5"

   x = [ 0.2, 0.9, 0.9, 0.2 ]
   y = [ 0.3, 0.3, 0.6, 0.6 ]
   c = [ 1., 1., 0., 0. ]

   call msAxis( "unequal" )
   call msPatch( x, y, c, opacity=1.0d0 )
   call msHold( "on" )
   call msPatch( x*0.7d0, y*0.7d0, color="w", grid=.true. )
   ! call msPanAndZoom()

   call msPrint("Patch_rect_no_transp.eps")
   call msPrint("Patch_rect_no_transp.pdf")

   call msPause()

   x = [ 0.4, 1.1, 1.1, 0.4 ]
   y = [ 0.2, 0.2, 0.8, 0.8 ]
   c = [ 0.4,  1.,  1.,  0.4 ]
   call msPatch( x, y, c, opacity=0.5d0 )
   ! call msPanAndZoom()

   if( mfGetX11Device() == "on" ) then
      call msPrint("Patch_rect_transp.eps")
   end if
   call msPrint("Patch_rect_transp.pdf")

   call msPause()

   call msClf()

   ! ------ triangular case ------
   print *, " test 6"

   x = [ 0., 1., 0. ]
   y = [ 0., 0., 1. ]
   c = [ 0., 1., 0. ]

   call msPatch( x, y, c, opacity=1.0d0 )
   call msPause()

   call msHold( "on" )

   x = [ 1.1, 1.1, 0.0 ]
   y = [ 0.0, 1.1, 1.1 ]
   c = [ 0.5, 0.5, 0.5 ]

   call msPatch( x, y, c, opacity=1.0d0 )
   ! call msPanAndZoom()

   call msPrint("Patch_tri_no_transp.eps")
   call msPrint("Patch_tri_no_transp.pdf")

   call msPause()

   x = [ -0.1,  1.1,  1.1 ]
   y = [ -0.1, -0.1,  1.1 ]
   c = [  1., 0., 1. ]
   call msPatch( x, y, c, opacity=0.65d0 )
   ! call msPanAndZoom()

   if( mfGetX11Device() == "on" ) then
      call msPrint("Patch_tri_transp.eps")
   end if
   call msPrint("Patch_tri_transp.pdf")

   call msPause()

   ! ------ simple use with flat color ------
   print *, " test 7"

   call msFigure(2)

   call msAxis( [-0.1d0, 1.1d0, -0.1d0, 1.1d0] )
   call msAxis( "equal" )

   x = [ 0., 1., 0. ]
   y = [ 0., 0., 1. ]

   call msPatch( x, y, color="r" ) ! "red"
   call msPause()

   call msClf()

   x = [ 0., 1., 0. ]
   y = [ 1., 1., 0. ]

   call msPatch( x, y, color=[0.0d0,0.0d0,1.0d0] ) ! "blue"
   call msPause()

   x = [ 0., 1., 1. ]
   y = [ 1., 1., 0. ]

   call msPatch( x, y, color="dark olive green" )
   call msPause()

   ! ------ simpler test of transparency  ------
   ! when using a white background, subtractive colors
   print *, " test 8"

   call msFigure(3)

   call msAxis( [0.0d0, 1.0d0, 0.0d0, 1.0d0] )
   call msAxis( "equal" )

   x = [ 0.000, 0.667, 0.667, 0.000 ]
   y = [ 0.000, 0.000, 0.667, 0.667 ]

   call msPatch( x, y, color=[1.0d0,1.0d0,0.0d0], opacity=0.5d0 )

   call msHold( "on" )

   x = x + 0.1667
   y = y + 0.1667

   call msPatch( x, y, color=[0.0d0,1.0d0,1.0d0], opacity=0.5d0 )

   x = [ 0.333, 1.000, 1.000, 0.333 ]
   y = [ 0.333, 0.333, 1.000, 1.000 ]

   call msPatch( x, y, color=[1.0d0,0.0d0,1.0d0], opacity=0.5d0 )

   if( mfGetX11Device() == "on" ) then
      call msPrint("Patch_subtractive_colors.eps")
   end if
   call msPrint("Patch_subtractive_colors.pdf")

!_______________________________________________________________________
!
99 continue

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y, c )

end program
