! this program test needs that X11 device is not disabled.

program MoveGrObj_test

   use fml
   use fgl

   implicit none

   type(mfArray) :: x, y
   integer :: h,                                                        &
              h_polygon, h_polygon_not_clipped,                         &
              h_arrow, h_arrow_not_clipped,                             &
              h_text, h_text_not_clipped
   character(len=1) :: ans

!_______________________________________________________________________
!

#ifdef _NO_X11

   print *, "This test requires X11."

#else

   call msSetMsgLevel( 2 ) ! Errors and Warnings are displayed, not infos.

   write(*,"(a)",advance="no") "  --------> skip interactive session ? [Y]/N "
   read "(a)", ans
   print *

   if( mfGetX11Device() == "off" .or. mfToUpper(ans) /= "N" ) then
      stop
   end if

   !--------------------------------------------------------------------

   call msSetCharEncoding( "UTF-8" )

   call msFigure(1)

   call msAxis( "equal" )
   call msAxis( [ -0.1d0, 1.1d0, -0.1d0, 1.1d0] )
   call msHold( "on" )

   ! line
   x = [  0.0d0, 0.3333d0, 0.3333d0, 0.6667d0, 0.6667d0, 1.0d0 ]
   y = [  0.0d0, 0.0d0,    0.6d0,    0.6d0,    0.1d0,    0.1d0 ]
   call msPlot( x, y, ":" )

   ! line
   x = [  0.0d0, 0.25d0, 0.25d0, 0.5d0, 0.5d0,  1.0d0 ]
   y = [  0.5d0, 0.5d0,  0.1d0,  0.1d0, 0.25d0, 0.25d0 ]
   call msPlot( x, y, "r--" )

   ! line + markers
   x = [  0.0d0, 0.15d0, 0.15d0, 0.75d0, 0.75d0, 1.0d0 ]
   y = [  0.3d0, 0.3d0,  0.2d0,  0.2d0,  0.4d0,  0.4d0 ]
   h = mfPlot( x, y, "mo-" )

   ! markers
   x = mfLinSpace( 0.0d0, 1.0d0, 25 )
   y = 0.333d0 + 0.333d0*mfSin( 2*MF_PI*x )
   call msPlot( x, y, "k+" )

   ! cubic bezier
   x = [ 0.0d0, 0.3333d0, 0.3333d0, 0.6667d0, 0.6667d0, 1.0d0, 1.0d0 ]
   y = [ 0.1d0, 0.0d0, 1.0d0, 1.0d0, 0.0d0, 0.0d0, 1.0d0 ]
   call msPlotCubicBezier( x, y,                                        &
                           linespec="-.", color=[0.d0,0.85d0,0.d0] )

   x = [ 0.6d0, 0.9d0, 0.75d0 ]
   y = [ 0.6d0, 0.45d0, 0.9d0 ]
   x = x + 0.35d0
   h_polygon = mfPatch( x, y, color="LightBlue" )

   h_arrow = mfArrow( 0.9d0, 0.4d0, 0.6d0, 1.0d0 )

   h_arrow_not_clipped = mfArrow( 0.0d0, 0.0d0, -0.3d0, 0.5d0, clipping=.false. )

   x = [ 0.7d0, 1.0d0, 1.0d0, 0.7d0 ]
   y = [ 0.5d0, 0.5d0, 0.8d0, 0.8d0 ]
   call msPatch( x, y, color="MistyRose" )

   x = x + 0.2d0
   y = y - 0.7d0
   h_polygon_not_clipped = mfPatch( x, y, color="Navy", clipping=.false. )

   h_text = mfText( 0.2d0, 0.8d0, "String (clipped)",                   &
                    height=1.25d0, angle=-20.0d0, clipping=.true. )

   h_text_not_clipped = mfText( -0.2d0, 0.9d0, "Another string (not clipped)", &
                                height=1.25d0,  clipping=.false. )

   call msLegend( "line+point", h )

   call msXLabel( "X" )
   call msYLabel( "Y" )
   call msTitle( "this is the title" )

   call msMoveGrObj( h_polygon )

   call msMoveGrObj( h_polygon_not_clipped )

   call msMoveGrObj( h_text )

   call msMoveGrObj( h_text_not_clipped )

   call msMoveGrObj( h_arrow )

   call msMoveGrObj( h_arrow_not_clipped )

   call msPrint( "MoveGrObj.eps" )
   call msPrint( "MoveGrObj.pdf" )

!_______________________________________________________________________
!

99 continue

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y )

#endif

end program
