program Loglog_test

   use fml
   use fgl

   use test_aux

   implicit none

   type(mfArray) :: x, y
   character(len=1) :: ans
   logical :: interactive

!_______________________________________________________________________
!

   call run_options()

   !--------------------------------------------------------------------

   call msFigure(1)

   x = mfLogspace(0.0d0, 3.0d0, 6 )
   y = x**2

   call msAxis( [ 1.0d0, 1000.0d0, 1.0d0, 1.0d6] )
   call msAxis( "loglog" )

   call msPlot( x, y, "o-" )

   write(*,"(a)",advance="no") "  --------> skip interactive session ? [Y]/N "
   read "(a)", ans
   interactive = mfToUpper(ans) == "N"

#ifndef _NO_X11
   if( mfGetX11Device() == "on" .and. interactive ) then
      call msZoom( )
      call msPause()
   end if
#endif

   call msAxis( [ 3.0d0, 20.0d0, 9.0d0, 400.0d0] )
   call msPause()

   ! test Inf or NaN

   ! With "auto" axis and "log-log" mode, we could see 1.e+30 as max
   ! value for axis (because INF is internally changed to 1.e30)
   call msAxis( [ 1.0d0, 1000.0d0, 1.0d0, 1.0d6] )
   call msPause()

   call msHold( "off" )

   y = x**2
   call msSet(MF_INF,y,3)
   call msPlot( x, y )
   call msHold( "on" )
   call msPlot( x, y, "or" )
   call msPause()

   call msHold( "off" )

   y = x**2
   call msPlot( x, y )
   call msHold( "on" )
   call msPlot( x, y, "or" )
   call msPause()

   call msHold( "off" )

   y = x**2
   call msSet(MF_NAN,y,3)
   call msPlot( x, y )
   call msHold( "on" )
   call msPlot( x, y, "or" )
   call msPause()

   print *, "printing ..."
   call msPrint( "Log_1.eps" )
   call msPrint( "Log_1.pdf" )

   !----------------------------
   call msFigure(2)

   call msAxis( [ 0.0d0, 10.0d0, 1.0d0, 1.0d3] )
   call msAxis( "linlog" )

   call msPlot( mf([2, 5, 10, 20, 50, 100, 200, 500]), linespec="o-" )
   call msPause()

   print *, "printing ..."
   call msPrint( "Log_2.eps" )
   call msPrint( "Log_2.pdf" )

   !----------------------------
   call msFigure(3)

   call msPlot( mf([1, 2, 5, 10, 15, 17, 20]) )
   call msAxis( "loglin" )

   call msPause()

   print *, "printing ..."
   call msPrint( "Log_3.eps" )
   call msPrint( "Log_3.pdf" )

!_______________________________________________________________________
!

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y )

end program
