program Legend_test

   use fml
   use fgl

   use test_aux

   implicit none

   type(mfArray) :: x, y
   integer :: i, h(4), h_hidden
   character(len=6) :: linespec
   character(len=80) :: legend_array(20)
   character(len=3) :: i_str
   character(len=1) :: ans
   logical :: interactive

!_______________________________________________________________________
!

   call run_options()

   call msSetCharEncoding( "UTF-8" )

   write(*,"(a)",advance="no") "  --------> skip interactive session ? [Y]/N "
   read "(a)", ans
   interactive = mfToUpper(ans) == "N"

   !--------------------------------------------------------------------

   call msFigure(1)
   call msAxis( [ -0.1d0, 1.1d0, -0.1d0, 1.1d0] )
   call msHold( "on" )
   call msAxis( "equal" )

   ! line
   x = [  0., 0.333, 0.333, 0.666, 0.666, 1. ]
   y = [  0., 0.,    0.6,    0.6,    0.1,    0.1 ]
   call msPlot( x, y )

   ! line
   x = [  0., 0.25, 0.25, 0.5, 0.5, 1. ]
   y = [  0.5, 0.5,  0.1,  0.1,   0.25,   0.25 ]
   call msPlot( x, y, "r--" )

   ! line + markers
   x = [  0., 0.15, 0.15, 0.75, 0.75, 1. ]
   y = [  0.3, 0.3,  0.2,  0.2,   0.4,   0.4 ]
   call msPlot( x, y, "mo-" )

   ! markers
   x = mfLinSpace( 0.0d0, 1.0d0, 25 )
   y = 0.333d0 + 0.333d0*mfSin( 2*MF_PI*x )
   call msPlot( x, y, "k+", markersize=1.5d0 )

   ! cubic bezier
   x = [ 0., 0.3333, 0.3333, 0.6667, 0.6667, 1., 1. ]
   y = [ 0.1, 0., 1., 1., 0., 0., 1. ]
   call msPlotCubicBezier( x, y,                                        &
                           linespec="-.", color=[0.d0,0.85d0,0.d0] )

   call msText( 0.05d0, 0.05d0, "Hello", height=2.0d0 )
   call msXLabel( "X" )
   call msYLabel( "Y" )
   call msTitle( "this is the title" )

   call msLegend( "blue polyline", "red dashed line",                   &
                  "magenta marked line", "black crossed sine",          &
                  "Bézier curve", position=mf([0.2,0.7]) )

   print *
   print *, "testing now the adjustment of the legend frame..."

#ifndef _NO_X11
   if( mfGetX11Device() == "on" .and. interactive ) then
      call msMoveLegend( )

      ! the following commands should give good behavior (test ok)
      !!call msZoom()
      !!call msPanAndZoom()
      !!call msPan()
   end if
#endif

   call msPrint( "Legend_axis_equal.eps" )
   call msPrint( "Legend_axis_equal.pdf" )

!--------------------------------------------------------------------

   call msFigure(2)
   call msAxis( [ -0.1d0, 1.1d0, -1.0d0, 11.0d0] )
   call msHold( "on" )

   ! line
   x = [  0., 0.333, 0.333, 0.666, 0.666, 1. ]
   y = [  0., 0.,    0.6,    0.6,    0.1,    0.1 ]
   y = 10.0d0*y
   call msPlot( x, y )

   ! line
   x = [  0., 0.25, 0.25, 0.5, 0.5, 1. ]
   y = [  0.5, 0.5,  0.1,  0.1,   0.25,   0.25 ]
   y = 10.0d0*y
   call msPlot( x, y, "r--" )

   ! line + markers
   x = [  0., 0.15, 0.15, 0.75, 0.75, 1. ]
   y = [  0.3, 0.3,  0.2,  0.2,   0.4,   0.4 ]
   y = 10.0d0*y
   call msPlot( x, y, "mo-" )

   ! markers
   x = mfLinSpace( 0.0d0, 1.0d0, 25 )
   y = 0.333d0 + 0.333d0*mfSin( 2*MF_PI*x )
   y = 10.0d0*y
   call msPlot( x, y, "k+" )

   ! cubic bezier
   x = [ 0., 0.3333, 0.3333, 0.6667, 0.6667, 1., 1. ]
   y = [ 0.1, 0., 1., 1., 0., 0., 1. ]
   y = 10.0d0*y
   call msPlotCubicBezier( x, y,                                        &
                           linespec="-.", color=[0.d0,0.85d0,0.d0] )

   call msText( 0.05d0, 0.5d0, "Hello", height=2.0d0 )

   call msLegend( "blue polyline", "red dashed line",                   &
                  "magenta marked line", "black crossed sine",          &
                  "Bézier curve", location="TR" )

   print *
   print *, "testing now the adjustment of the legend frame..."

#ifndef _NO_X11
   if( mfGetX11Device() == "on" .and. interactive ) then
      call msMoveLegend( )

      ! the following commands should give good behavior (test ok)
      !!call msZoom()
      !!call msPanAndZoom()
      !!call msPan()
   end if
#endif

   call msPrint( "Legend.eps" )
   call msPrint( "Legend.pdf" )

   !--------------------------------------------------------------------

   call msFigure(3)

   call msAxis( [ 0.9d0, 11.0d0, 0.9d0, 18.5d0] )
   call msAxis( "loglog" )

   ! line
   x = [  1.0, 2.0, 5.0, 10. ]
   y = x**1.25d0
   call msPlot( x, y, 'bo-' )
   call msHold( "on" )

   ! line + markers
   x = [  1.0, 2.0, 5.0, 10. ]
   y = x**0.75d0
   call msPlot( x, y, "mo-" )

   call msText( 1.0d0, 1.8d0, "Horizontal display", height=2.0d0 )

   call msText( 1.5d0, 9.0d0, "Inclined text", height=1.5d0,            &
                angle=45.0d0 )

   call msLegend( "blue polyline", "magenta marked line", location="TR" )

   print *
   print *, "testing now the adjustment of the legend frame..."

#ifndef _NO_X11
   if( mfGetX11Device() == "on" .and. interactive ) then
      call msMoveLegend( )

      ! the following commands should give good behavior (test ok)
      !!call msZoom()
      !!call msPanAndZoom()
      !!call msPan()
   end if
#endif

   call msPrint( "Legend_log_log.eps" )
   call msPrint( "Legend_log_log.pdf" )

   !--------------------------------------------------------------------

   call msFigure(4)
   call msAxis( [ 0.0d0, 1.0d0, -1.0d0, 1.0d0] )

   ! few curves (three visible, the fourth one will be hidden but will appear
   ! as optional content in the PDF only)
   x = mfLinspace( 0.0d0, 1.0d0, 500 )
   y = mfSin( 2.0d0*MF_PI*x )
   h(1) = mfPlot( x, y, 'r', linewidth=2.0d0 )
   call msHold( "on" )
   y = mfSin( 2.0d0*MF_PI*x + 0.2d0 )
   h(2) = mfPlot( x, y, 'g', linewidth=2.0d0 )
   y = mfSin( 2.0d0*MF_PI*x + 0.4d0 )
   h(3) = mfPlot( x, y, 'b', linewidth=2.0d0 )

   y = mfSin( 2.0d0*MF_PI*x + 0.6d0 )
   h(4) = mfPlot( x, y, 'm', linewidth=2.0d0 )
   call msSetGrObj( h(4), "visible", "off" )
   call msRedrawFigure() ! required to see the changes applied by msSetGrObj

   ! this black dashed line should never appear, neither on the X11 screen,
   ! nor in the EPS or PDF files...
   y = mfSin( 2.0d0*MF_PI*x + 0.8d0 )
   h_hidden = mfPlot( x, y, 'k--', linewidth=2.0d0 )
   call msSetGrObj( h_hidden, "visible", "off" )
   call msRedrawFigure() ! required to see the changes applied by msSetGrObj

   call msLegend( "first", "second" ) ! legend for only few curves

   call msPrint( "Legend_partial.eps" )
   call msPrint( "Legend_partial.pdf" )

   ! if possible, get the OC name from the legend
   call msSetPdfOC( h(:), super_group="Curves" )
   ! as the legend describes only the first two curves, we can do:
   call msSetPdfOC( h(3), name="third", super_group="Curves" )
   ! (and only curve number 4 will be named in the PDF OCG by its handle)
   call msPrint( "Legend_partial+OC.pdf" )

   !--------------------------------------------------------------------

   call msFigure(5)
   call msAxis( [ 0.0d0, 1.0d0, -1.0d0, 1.0d0] )

   ! many curves
   x = mfLinspace( 0.0d0, 1.0d0, 200 )
   y = mfSin( 2.0d0*MF_PI*x )

   call msPlot( x, y, linewidth=2.0d0 )
   legend_array(1) = "curve 1"

   call msHold( "on" )

   do i = 2, 20
      y = mfSin( 2.0d0*MF_PI*(x-(i-1)*0.05d0) )
      if( 5 <= i .and. i <= 8 ) then
         linespec="--"
      else if( 9 <= i .and. i <= 12 ) then
         linespec=":"
      else
         linespec = ""
      end if
      call msPlot( x, y, linespec, linewidth=2.0d0 )
      write( i_str, "(I0)" ) i
      legend_array(i) = "curve " // trim(i_str)
   end do

   ! legend array
   !call msLegend( legend_array(1:12), position=mf([1.015,1.]) )
   ! or
   call msLegend( legend_array(1:12), location="outside" )

   call msPrint( "Legend_outside.eps" )
   call msPrint( "Legend_outside.pdf" )

   !--------------------------------------------------------------------

   call msFigure(6)
   call msAxis( [ 0.0d0, 1.0d0, -1.0d0, 1.0d0] )

   ! many curves
   x = mfLinspace( 0.0d0, 1.0d0, 200 )
   y = mfSin( 2.0d0*MF_PI*x )

   call msPlot( x, y, linewidth=2.0d0 )
   legend_array(1) = "curve 1"

   call msHold( "on" )

   do i = 2, 3
      y = mfSin( 2.0d0*MF_PI*(x-(i-1)*0.05d0) )
      call msPlot( x, y, linewidth=2.0d0 )
      write( i_str, "(I0)" ) i
      legend_array(i) = "curve " // trim(i_str)
   end do

   ! legend array
   ! (it may appear strange to create two different legends! Actually, it is the
   !  only way to implement optional content for PDF -- see 'Title_and_Labels')
   h(1) = mfLegend( legend_array(1:3), location="TR" )
   h(2) = mfLegend( legend_array(1:3), location="BL" )

   if( mfGetX11Device() == "on" .and. interactive ) then
      call msPause( "Ready to move the Top-Right legend frame to the center of the figure?" )

      ! move the first legend in the middle of the figure...
      call msSetGrObj( h(1), "relat_coords", [0.5d0,0.5d0] )
      call msRedrawFigure() ! required to see the changes applied by msSetGrObj
   end if

#ifndef _NO_X11
   if( mfGetX11Device() == "on" .and. interactive ) then
      call msMoveLegend( h(2) )
   end if
#endif

   call msPrint( "Legend_hdle.eps" )
   call msPrint( "Legend_hdle.pdf" )

!_______________________________________________________________________
!

99 continue

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y )

end program
