program Labels_and_Languages_test

   use fml
   use fgl

   use test_aux

   implicit none

   type(mfArray) :: r
   integer :: h_en(5), h_fr(5), h_de(5), hdle(3), hdle_2(2)

!_______________________________________________________________________
!

   call run_options()

   !----------------------------------

   call msFigure(1)

   call msAxis( "on" )

   call msTitle( "The title" )

   call msXLabel( "X-axis" )

   call msYLabel( "Y-axis" )

   call msPause()

   call msLabelFontSize( 1.5d0 )
   call msPause()

   call msLabelFontSize( 1.25d0 )

   call msPrint( "Labels_and_Languages.eps" )
   call msPrint( "Labels_and_Languages.pdf" )

   !----------------------------------

   call msFigure(2)
   call msLabelFontSize( 1.5d0 )

   call msAxis( "on" )

   call msTitle( "The title, with \fNa bold substring\fn." //           &
                 " \fiAnd another \fIbold italic substring\fn." )

   call msXLabel( "\fix\fn (\fRm\fn)" )

   call msYLabel( "\fRv\fi\dw\u\fn (\fRm\fn/\fRs\fn)" )

   call msPause("printing...")
   call msPrint( "Labels_and_Languages_2.eps" )
   call msPrint( "Labels_and_Languages_2.pdf" )

   !----------------------------------

   call msFigure(3)
   call msLabelFontSize( 1.5d0 )

   call msSetCharEncoding( "UTF-8" )

   call msAxis( "on" )
   call msAxis( [ -0.1d0, 1.1d0, -0.1d0, 1.1d0] )
   call msHold( "on" )

   hdle(1) = mfArrow( 0.7d0, 0.7d0, 0.55d0, 0.55d0 )
   h_en(1) = mfText( 0.72d0, 0.72d0, "This is a circle" )
   call msPlot( mf(0.5d0), mf(0.5d0), "\M06", markersize=2.5d0 )
   hdle(2) = mfArrow( 0.2d0, 0.2d0, 0.45d0, 0.45d0, color="m" )
   hdle(3) = mfArrow( 0.7d0, 0.1d0, 0.55d0, 0.4d0, color="dark green" )

   hdle_2(1) = mfPlot( mf([0.0d0,0.2d0,0.4d0]), mf([0.0d0,0.8d0,1.0d0]), &
                       linewidth=2.0d0 )
   hdle_2(2) = mfPlot( mf([0.0d0,0.1d0,0.3d0]), mf([1.0d0,0.3d0,0.5d0]), &
                       linewidth=2.0d0 )

   h_en(2) = mfLegend( "blue symbol", "red curve", "orange curve", location="TR" )
   ! Languages support (note the use of the new mfXLabel, mfYLabel and
   ! mfTitle functions)
   h_en(3) = mfTitle( "English title" )
   h_en(4) = mfXLabel( "English label for X axis" )
   h_en(5) = mfYLabel( "English label for Y axis" )

   !-----------------------------------------------------
   call msPause( "other labels in a second language..." )

   call msSetGrObj( h_en(1:5), "visible", "off" )
   call msRedrawFigure() ! Required to see the changes applied by msSetGrObj
   h_fr(1) = mfText( 0.72d0, 0.72d0, "Ceci est un cercle" )
   h_fr(2) = mfLegend( "symbole bleu", "courbe rouge", "courbe orange", location="TR" )
   h_fr(3) = mfTitle( "Titre français" )
   h_fr(4) = mfXLabel( "Commentaire français de l'axe des X" )
   h_fr(5) = mfYLabel( "Commentaire français de l'axe des Y" )

   !-----------------------------------------------------
   call msPause( "other labels in a third language..." )

   call msSetGrObj( h_fr(1:5), "visible", "off" )
   call msRedrawFigure() ! Required to see the changes applied by msSetGrObj
   h_de(1) = mfText( 0.72d0, 0.72d0, "Dies ist ein Kreis" )
   h_de(2) = mfLegend( "blaues Symbol", "rote Kurve", "orange Kurve", location="TR" )
   h_de(3) = mfTitle( "Deutscher Titel" )
   h_de(4) = mfXLabel( "Deutsches Label für X-Achse" )
   h_de(5) = mfYLabel( "Deutsches Label für Y-Achse" )

   !-----------------------------------------------------
   ! No needs to reset visibility of each grobj associated to OC: this will
   ! be done automatically by the library when using the 'persistent' option.

   call msSetPdfOC( h_en(1:5), persistent=.true.,                       &
                               mutex="Other language (default: English)" )
   ! The order of other languages below will be used in the PDF viewer menu...
   call msSetPdfOC( h_de(1:5), name="Deutsch",                          &
                               mutex="Other language (default: English)" )
   call msSetPdfOC( h_fr(1:5), name="Français",                         &
                               mutex="Other language (default: English)" )

   call msSetGrObj( hdle(2:3), "visible", "off" )
   call msSetPdfOC( hdle(1), name="Black", super_group="Arrows" )
   call msSetPdfOC( hdle(2), name="Magenta", super_group="Arrows" )
   call msSetPdfOC( hdle(3), name="Dark green", super_group="Arrows" )

   call msSetPdfOC( hdle_2, merge=.true., name="Colored lines" )

   call msPause("printing...")
   call msPrint( "Labels_and_Languages_3_OC.pdf" )

   !-----------------------------------------------------
   ! Here we reset the visibility for the EPS only
   call msSetGrObj( h_fr(1:5), "visible", "off" )
   call msSetGrObj( h_de(1:5), "visible", "off" )
   call msSetGrObj( h_en(1:5), "visible", "on" )

   call msPrint( "Labels_and_Languages_3.eps" )

!_______________________________________________________________________
!

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( r )

end program
