! this program test needs that X11 device is not disabled.

program GinputRect_test

   use fml
   use fgl

   implicit none

   type(mfArray) :: r
   character(len=1) :: ans

!_______________________________________________________________________
!

#ifdef _NO_X11

   print *, "This test requires X11."

#else

   call msSetMsgLevel( 2 ) ! Errors and Warnings are displayed, not infos.

   write(*,"(a)",advance="no") "  --------> skip interactive session ? [Y]/N "
   read "(a)", ans

   if( mfGetX11Device() == "off" .or. mfToUpper(ans) /= "N" ) then
      print *
      stop
   end if

   call msFigure(1)

   call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )

   do
      r = mfGinputRect()
      if( mfIsEqual(r,MF_EMPTY) ) then
         exit
      end if
      call msDisplay( r, "selected area" )
   end do

   !------------------------------

   call msAxis( [ 1.0d0, 10.0d0, 1.0d0, 10.0d0 ] )
   call msAxis( "loglog" )

   do
      r = mfGinputRect()
      if( mfIsEqual(r,MF_EMPTY) ) then
         exit
      end if
      call msDisplay( r, "selected area" )
   end do

!_______________________________________________________________________
!

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( r )

#endif

end program
