! this program test needs that X11 device is not disabled.

program GetX11Pixmap_test

   use fml
   use fgl

   use test_aux

   implicit none

   type(mfArray) :: red, green, blue

   character(len=1) :: ans
   logical :: interactive

!_______________________________________________________________________
!

   call run_options()

   if( X11_OFF ) then
      print *, "This test requires X11."
      stop
   end if

#ifdef _NO_X11

   print *, "This test requires X11."

#else

   write(*,"(A)",advance="no") " --------> skip interactive session ? [Y]/N "
   read "(A)", ans
   interactive = mfToUpper(ans) == "N"

   call msSetMsgLevel( 2 ) ! Errors and Warnings are displayed, not infos.

   if( mfGetX11Device() == "off" ) stop

   ! for using 'msGetX11Pixmap', background color must be black
!### TODO: must be modified for white also.
   call msSetBackgroundColor( "black" )

   !----------------------------------
   call msFigure(1)

   call msCharInPixels("on")

   call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )

   call msText( 0.25d0, 0.6d0, "ABCDE", height=2.0d0, color="r" )
   call msText( 0.25d0, 0.4d0, "FGHIJ", height=2.0d0, color="g" )
   call msText( 0.25d0, 0.2d0, "KLMNO", height=2.0d0, color="b" )
!!   call msText( 0.25d0, 0.6d0, "ABCDE", height=2.0d0, color="c" )
!!   call msText( 0.25d0, 0.4d0, "FGHIJ", height=2.0d0, color="m" )
!!   call msText( 0.25d0, 0.2d0, "KLMNO", height=2.0d0, color="y" )
   ! in the latter case, we get the 'cyan' color plane in 'red'
   ! and so on...

   if( interactive ) then
      call msResizeWindow()
   end if

   call msGetX11Pixmap( red=red )
   print *, 'got X11 pixmap : size(red)   = ', shape(red)

   if( interactive ) then
      call msResizeWindow()
   end if

   call msGetX11Pixmap( red, green, blue )
   print *, 'got X11 pixmap : size(red)   = ', shape(red)
   print *, 'got X11 pixmap : size(green) = ', shape(green)
   print *, 'got X11 pixmap : size(blue)  = ', shape(blue)

   call msFigure(2)
   call msSpy( mfSparse(red), "r." )

   call msFigure(3)
   call msSpy( mfSparse(green), "g." )

   call msFigure(4)
   call msSpy( mfSparse(blue), "b." )

   call msPause()

   call msClose(2)
   call msClose(3)
   call msClose(4)

   call msFigure(1)

   if( interactive ) then
      call msResizeWindow()
   end if

   call msGetX11Pixmap( red=red )
   print *, 'got X11 pixmap : size(red)   = ', shape(red)

!_______________________________________________________________________
!

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( red, green, blue )

#endif

end program
