program ErrorBar_test

   use fml
   use fgl

   use test_aux

   implicit none

   type(mfArray) :: x, y, x_err, y_err

!_______________________________________________________________________
!

   call run_options()

   print *

!--------------------------

   call msFigure(1)

   y = [  2.0d0,  1.5d0,  3.0d0,  2.5d0 ]
   y_err = [  0.10d0,  0.15d0,  0.20d0,  0.25d0 ]
   call msAxis( [0.5d0, 4.5d0, 1.0d0, 3.5d0] )
   call msErrorBar( y=y, y_err=y_err )
   ! call msErrorBar( y, y_err ) -> compilation error
   ! call msErrorBar( y, y_err=y_err ) -> run-time error

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msPrint( "Errorbar_1.eps" )
   call msPrint( "Errorbar_1.pdf" )
   write(STDOUT,"(A,/)") " done ***"

!--------------------------

   call msFigure(2)

   y = [  2.0d0,  1.5d0,  3.0d0,  2.5d0 ]
   y_err = [  0.10d0,  0.15d0,  0.20d0,  0.25d0 ]
   call msAxis( [0.5d0, 4.5d0, 1.0d0, 3.5d0] )
   call msErrorBar( y=y, y_err=y_err, linespec="ro" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msPrint( "Errorbar_2.eps" )
   call msPrint( "Errorbar_2.pdf" )
   write(STDOUT,"(A,/)") " done ***"

!--------------------------

   call msFigure(3)

   y = [  2.0d0,  1.5d0,  3.0d0,  2.5d0 ]
   y_err = [  0.10d0,  0.15d0,  0.20d0,  0.25d0 ]
   call msAxis( [0.5d0, 4.5d0, 1.0d0, 3.5d0] )
   call msErrorBar( y=y, y_err=y_err, linespec="mo-" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msPrint( "Errorbar_3.eps" )
   call msPrint( "Errorbar_3.pdf" )
   write(STDOUT,"(A,/)") " done ***"

!--------------------------

   call msFigure(4)

   x = [  0.5d0,  1.0d0,  1.5d0,  2.0d0 ]
   y = [  2.0d0,  1.5d0,  3.0d0,  2.5d0 ]
   x_err = [  0.10d0,  0.15d0,  0.20d0,  0.25d0 ]
   call msAxis( [0.0d0, 2.5d0, 1.0d0, 3.5d0] )
   call msErrorBar( x=x, y=y, x_err=x_err )
   ! call msErrorBar( x, y, x_err ) -> is ok

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msPrint( "Errorbar_4.eps" )
   call msPrint( "Errorbar_4.pdf" )
   write(STDOUT,"(A,/)") " done ***"

!--------------------------

   call msFigure(5)

   x = [  0.5d0,  1.0d0,  1.5d0,  2.0d0 ]
   y = [  2.0d0,  1.5d0,  3.0d0,  2.5d0 ]
   y_err = [  0.10d0,  0.15d0,  0.20d0,  0.25d0 ]
   call msAxis( [0.0d0, 2.5d0, 1.0d0, 3.5d0] )
   call msErrorBar( x=x, y=y, x_err=x_err, linespec="r*" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msPrint( "Errorbar_5.eps" )
   call msPrint( "Errorbar_5.pdf" )
   write(STDOUT,"(A,/)") " done ***"

!--------------------------

   call msFigure(6)

   x = [  0.5d0,  1.0d0,  1.5d0,  2.0d0 ]
   y = [  2.0d0,  1.5d0,  3.0d0,  2.5d0 ]
   y_err = [  0.10d0,  0.15d0,  0.20d0,  0.25d0 ]
   call msAxis( [0.0d0, 2.5d0, 1.0d0, 3.5d0] )
   call msErrorBar( x=x, y=y, x_err=x_err, linespec="m*-" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msPrint( "Errorbar_6.eps" )
   call msPrint( "Errorbar_6.pdf" )
   write(STDOUT,"(A,/)") " done ***"

!--------------------------

   call msFigure(7)

   x = [  0.5d0,  1.0d0,  1.5d0,  2.0d0 ]
   y = [  2.0d0,  1.5d0,  3.0d0,  2.5d0 ]
   x_err = [  0.10d0,  0.15d0,  0.20d0,  0.25d0 ]
   y_err = x_err
   call msAxis( [0.0d0, 2.5d0, 1.0d0, 3.5d0] )
   call msErrorBar( x=x, y=y, x_err=x_err, y_err=y_err )
   ! call msErrorBar( x, y, x_err, y_err ) -> is ok

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msPrint( "Errorbar_7.eps" )
   call msPrint( "Errorbar_7.pdf" )
   write(STDOUT,"(A,/)") " done ***"

!--------------------------

   call msFigure(8)

   x = [  0.5d0,  1.0d0,  1.5d0,  2.0d0 ]
   y = [  2.0d0,  1.5d0,  3.0d0,  2.5d0 ]
   x_err = [  0.10d0,  0.15d0,  0.20d0,  0.25d0 ]
   y_err = x_err
   call msAxis( [0.0d0, 2.5d0, 1.0d0, 3.5d0] )
   call msErrorBar( x=x, y=y, x_err=x_err, y_err=y_err,                 &
                    linespec="r\SquareFilled" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msPrint( "Errorbar_8.eps" )
   call msPrint( "Errorbar_8.pdf" )
   write(STDOUT,"(A,/)") " done ***"

!--------------------------

   call msFigure(9)

   x = [  0.5d0,  1.0d0,  1.5d0,  2.0d0 ]
   y = [  2.0d0,  1.5d0,  3.0d0,  2.5d0 ]
   x_err = [  0.10d0,  0.15d0,  0.20d0,  0.25d0 ]
   y_err = x_err
   call msAxis( [0.0d0, 2.5d0, 1.0d0, 3.5d0] )
   call msErrorBar( x=x, y=y, x_err=x_err, y_err=y_err,                 &
                    linespec="m-\SquareFilled" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msPrint( "Errorbar_9.eps" )
   call msPrint( "Errorbar_9.pdf" )
   write(STDOUT,"(A,/)") " done ***"

!_______________________________________________________________________
!
99 continue ! tempo for tests with valgrind

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y, x_err, y_err )

end program
