program Contour_test

   use fml
   use fgl

   use test_aux

   implicit none

   type(mfArray) :: x, y, r, z, theta, c, line
   type(mfArray) :: tri
   type(mfTriConnect) :: tri_connect
   integer :: color_depth
   integer :: m, n, j, j_max, nb_line, npt
   real(kind=MF_DOUBLE), pointer :: f90_ptr(:,:)
   real(kind=MF_DOUBLE) :: level
   character(len=80) :: string

!_______________________________________________________________________
!

   call run_options()

   call msFigure( 1 )

   color_depth = mfGetX11ColorDepth()
   write(STDOUT,"(A,I0)") " Color Depth = ", color_depth

   call msColormapSize( 256 )
   print *, " Colormap size = ", mfColormapSize()
   call msColormap( "rainbow" )
   call msAxis( "equal" )

!------

   print *, " test 1"

   z = mfEye(7,9)
   call msSet( 1.0d0, z, 7, 9 )
   call msSet( 1.0d0, z, 6, 8 )
   call msSet( 1.0d0, z, 5, 7 )

   call msContour( z, labels=.false. )

   call msXLabel( "column indexes" )
   call msYLabel( "row indexes" )
   call msColorbar( "on" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Contour_1.eps" )
   call msPrint( "Contour_1.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 2"

   call msMeshGrid( mfOut(x,y), mfLinspace(0.0d0, 1.0d0, 5),            &
                            .t. mfLinspace(0.0d0, 2.0d0, 10) )

   call msCAxis( [ 0.0d0, 1.5d0 ] )
   call msDisplay(mfCAxis(),"Color Axis")

   z = 3.0d0 -( x + y )
   call msDisplay(z,"z")

!!   call msAxis( [ -0.01d0, 1.01d0, 0.0d0, 2.0d0 ] ) ! not a good idea !
   call msContour( z, labels=.false. )

   call msXLabel( "column indexes" )
   call msYLabel( "row indexes" )
   call msColorbar( "on" )

   call msPause()

   print *, " test 2a"

   call msCAxis( mfMin(mfMin(z)).hc.mfMax(mfMax(z)) )
   call msDisplay(mfCAxis(),"Color Axis")

   call msContour( z, labels=.false. )

   call msXLabel( "column indexes" )
   call msYLabel( "row indexes" )
   call msColorbar( "on" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Contour_2a.eps" )
   call msPrint( "Contour_2a.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

   print *, " test 2b"

   ! testing new optional args
   call msContour( z, nb_levels=40, labels=.false. )

   call msXLabel( "column indexes" )
   call msYLabel( "row indexes" )
   call msColorbar( "on" )
   call msPause()

   ! negative values to see the layout of the numerical strings
   call msCAxis( mfMin(mfMin(-z)).hc.mfMax(mfMax(-z)) )
   call msContour( -mfRot90(z,2), levels=mf(-[1.11,1.44,1.77]) ) ! <=== labels

   call msXLabel( "column indexes" )
   call msYLabel( "row indexes" )
   call msColorbar( "on" )
   call msPause()

   ! coloring labels in a color differing from the foreground one
   call msContour( -mfRot90(z,2), levels=mf(-[1.11,1.44,1.77]),         &
                   labelscolor="r" )                      ! <=== colored labels

   call msXLabel( "column indexes" )
   call msYLabel( "row indexes" )
   call msColorbar( "on" )
   call msPause()

   ! testing small character size labels
   call msContour( -mfRot90(z,2), levels=mf(-[1.11,1.44,1.77]),         &
                   labelsize=0.75d0 )                     ! <=== resized labels

   call msXLabel( "column indexes" )
   call msYLabel( "row indexes" )
   call msColorbar( "on" )
   call msPause()

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Contour_2b.eps" )
   call msPrint( "Contour_2b.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 3"

   call msMeshGrid( mfOut(x,y), mfLinspace(0.0d0, 1.0d0, 5),            &
                            .t. mfLinspace(0.0d0, 2.0d0, 10) )

   call msCAxis( [ 0.0d0, 1.0d0 ] )
   call msDisplay(mfCAxis(),"Color Axis")

   call msContour( mfGet(x,1,MF_ALL), mfGet(y,MF_ALL,1), x, labels=.false. )

   call msXLabel( "x" )
   call msYLabel( "y" )
   call msTitle( "use of actual (vector) coordinates for data" )
   call msColorbar( "on" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Contour_3.eps" )
   call msPrint( "Contour_3.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 4"

   m = 3
   n = 4
   call msMeshGrid( mfOut(x,y), mfLinspace(0.0d0, 1.0d0, m),            &
                            .t. mfLinspace(0.0d0, 2.0d0, n) )

   call msCAxis( [ 0.0d0, 1.0d0 ] )
   call msDisplay(mfCAxis(),"Color Axis")

   call msShading( "interp" )
   call msColormap( "bluered" )
   call msPColor( mfGet(x,1,MF_ALL), mfGet(y,MF_ALL,1), x )
   call msHold( "on" )

   call msContour( mfGet(x,1,MF_ALL), mfGet(y,MF_ALL,1), x,             &
                   linespec="w--", linewidth=2.0d0, labels=.false. )

   call msXLabel( "x" )
   call msYLabel( "y" )
   call msTitle( "use of actual (vector) coordinates for data" )
   call msColorbar( "on" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Contour_4.eps" )
   call msPrint( "Contour_4.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()
   call msHold( "off" )

!------

   print *, " test 5"
   call msColormap( "rainbow" )

   call msMeshGrid( mfOut(x,y), mfLinspace(0.0d0,  5.0d0, 20),          &
                            .t. mfLinspace(0.0d0, 10.0d0, 40) )
   r = mfSqrt(x**2 + y**2)
   z = mfSin( r ) / r
   call msSet( 1.0d0, z, 1, 1 ) ! avoid NaN value : sin(0)/0 = 1

   call msCAxis( [ -0.3d0, +1.0d0 ] )
   call msDisplay(mfCAxis(),"Color Axis")

   call msContour( mfGet(x,1,MF_ALL), mfGet(y,MF_ALL,1), z,             &
                   labels=.false. )

   call msXLabel( "x" )
   call msYLabel( "y" )
   call msTitle( "use of actual (vector) coordinates for data" )
   call msColorbar( "on" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Contour_5.eps" )
   call msPrint( "Contour_5.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 6"

   call msMeshGrid( mfOut(x,y), mfLinspace(0.0d0, 10*MF_PI, 30),        &
                            .t. mfLinspace(0.0d0, 1.0d0, 2) )
   x = x**0.25d0
   z = mfCos( x**4 )

   call msAxis( "auto" )
   call msAxis( "equal" )
   call msCAxis( [ -1.0d0, +1.0d0 ] )
   call msDisplay(mfCAxis(),"Color Axis")

   call msShading( "interp" )
   call msPcolor( mfGet(x,1,MF_ALL), mfGet(y,MF_ALL,1), z )
   call msHold( "on" )

   call msContour( mfGet(x,1,MF_ALL), mfGet(y,MF_ALL,1), z,             &
                   levels=mf([0.0]), linespec="w--", linewidth=2.0d0 )

   call msXLabel( "x" )
   call msYLabel( "y" )
   call msTitle( "use of non-linear (vector) coordinates for data" )
   call msColorbar( "on" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Contour_6.eps" )
   call msPrint( "Contour_6.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()
   call msHold( "off" )

!------

   print *, " test 6b"

   call msMeshGrid( mfOut(x,y), mfLinspace(0.0d0, 1.0d0, 2),            &
                            .t. mfLinspace(0.0d0, 10*MF_PI, 30) )
   y = y**0.25d0
   z = mfCos( y**4 )

   call msAxis( "auto" )
   call msAxis( "equal" )
   call msCAxis( [ -1.0d0, +1.0d0 ] )
   call msDisplay(mfCAxis(),"Color Axis")

   call msShading( "interp" )
   call msPcolor( mfGet(x,1,MF_ALL), mfGet(y,MF_ALL,1), z )
   call msHold( "on" )

   call msContour( mfGet(x,1,MF_ALL), mfGet(y,MF_ALL,1), z,             &
                   levels=mf([0.0]), linespec="w--", linewidth=2.0d0 )

   call msXLabel( "x" )
   call msYLabel( "y" )
   call msTitle( "use of non-linear (vector) coordinates for data" )
   call msColorbar( "on" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Contour_6b.eps" )
   call msPrint( "Contour_6b.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()
   call msHold( "off" )

!------

   print *, " test 7"

   call msMeshGrid( mfOut(x,y), mfLinspace(0.0d0,  5.0d0, 20),          &
                            .t. mfLinspace(0.0d0, 10.0d0, 40) )
   r = mfSqrt(x**2 + y**2)
   z = mfSin( r ) / r
   call msSet( 1.0d0, z, 1, 1 ) ! avoid NaN value : sin(0)/0 = 1

   call msCAxis( [ -0.3d0, +1.0d0 ] )
   call msDisplay(mfCAxis(),"Color Axis")

   call msContour( x, y, z, labels=.false. )

   call msXLabel( "x" )
   call msYLabel( "y" )
   call msTitle( "use of actual (matrix) coordinates for data" )
   call msColorbar( "on" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Contour_7.eps" )
   call msPrint( "Contour_7.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 8"

   ! we can apply any linear transformation on (x,y) coordinates
   r = x
   x = x - y
   y = r + y

   call msCAxis( [ -0.3d0, +1.0d0 ] )
   call msDisplay(mfCAxis(),"Color Axis")

   call msContour( x, y, z, labels=.false. )

   call msHold( "on" )
   call msPlot( mfGet(x,1,MF_ALL),      mfGet(y,1,MF_ALL),      "k" )
   call msPlot( mfGet(x,MF_END,MF_ALL), mfGet(y,MF_END,MF_ALL), "k" )
   call msPlot( mfGet(x,MF_ALL,1),      mfGet(y,MF_ALL,1),      "k" )
   call msPlot( mfGet(x,MF_ALL,MF_END), mfGet(y,MF_ALL,MF_END), "k" )

   call msXLabel( "x" )
   call msYLabel( "y" )
   call msTitle( "use of a linear transformation of coordinates" )
   call msColorbar( "on" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Contour_8.eps" )
   call msPrint( "Contour_8.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

   call msHold( "off" )

!------

   print *, " test 9"

   call msMeshGrid( mfOut(r,theta), mfLinspace(1.0d0,  4.0d0, 10),      &
                                .t. mfLinspace(0.0d0, MF_PI, 40) )
   z = mfSin( r ) / r

   call msAxis( "auto" )
   call msAxis( "equal" )
   call msCAxis( [ -0.7d0, +1.2d0 ] )
   call msColormap( "parula" )

   ! the function is globally non-linear, but locally linear in each quadrangle
   x = r * mfCos(theta)
   y = r * mfSin(theta)
   z = z + y/8. + x/8.

   call msPcolor( x, y, z )
   call msHold( "on" )

   call msContour( mfOut(c), x, y, z, labels=.false.,                   &
                   linespec="w", linewidth=2.0d0 )

   call msPlot( mfGet(x,1,MF_ALL),      mfGet(y,1,MF_ALL),      "k" )
   call msPlot( mfGet(x,MF_END,MF_ALL), mfGet(y,MF_END,MF_ALL), "k" )
   call msPlot( mfGet(x,MF_ALL,1),      mfGet(y,MF_ALL,1),      "k" )
   call msPlot( mfGet(x,MF_ALL,MF_END), mfGet(y,MF_ALL,MF_END), "k" )

   call msAxis( [ -4.1d0, 4.1d0, -0.1d0, 4.1d0 ] )
   call msXLabel( "x" )
   call msYLabel( "y" )
   call msTitle( "use of a nonlinear transformation of coordinates" )
   call msColorbar( "on" )

   ! Print the contours coordinates on the terminal
   if( .not. mfIsEmpty(C) ) then
      ! Set F90 pointers to easily manipulate the mfArray data
      call msPointer( C, f90_ptr )
      j_max = size(f90_ptr,2) ! nb of columns
      j = 1
      nb_line = 0
      do
         if( j > j_max ) exit
         nb_line = nb_line + 1
         level = f90_ptr(1,j)
         write(string,"(A,I0,A,G0.4)") "line ", nb_line, " of level ", level
         npt = f90_ptr(2,j)
         line = f90_ptr(:,j+1:j+npt)
         if( npt <= 6 ) then
            call msDisplay( .t.line, trim(string) )
         else
            call msDisplay( .t.line, trim(string), head=3, tail=3 )
         end if
         j = j + npt + 1
      end do
      print "(A,I0,A,/)", " got ", nb_line, " line(s)"
      call msFreePointer( C, f90_ptr )
   end if

!!   call msZoom() ! <-----------------

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Contour_9.eps" )
   call msPrint( "Contour_9.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

   call msHold( "off" )
   call msClf()

!------

   print *, " test 10a"

   call msAxis( "auto" )
   call msAxis( "equal" )
   call msCAxis( [ -1.0d0, +1.0d0 ] )

   z = -mfOnes(3,3)
   call msSet( 1.0d0, z, 1, 1 )
   call msSet( 1.0d0, z, 1, 3 )
   call msSet( 1.0d0, z, 2, 2 )
   call msSet( 1.0d0, z, 3, 1 )
   call msSet( 1.0d0, z, 3, 3 )

   call msShading( "interp" )
   call msPColor( z )
   call msHold( "on" )

   call msContour( z, order=2, labels=.false.,                          &
                   linespec="w", linewidth=1.5d0 )

   call msXLabel( "column indexes" )
   call msYLabel( "row indexes" )
   call msTitle( "using order 2" )
   call msColorbar( "on" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Contour_10a.eps" )
   call msPrint( "Contour_10a.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

   call msHold( "off" )

   print *, " test 10b"

   call msMeshGrid( mfOut(x,y), mfLinspace(0.0d0, 1.0d0, 3),            &
                            .t. mfLinspace(0.0d0, 1.0d0, 3) )

   call msShading( "interp" )
   call msPColor( x, y, z )
   call msHold( "on" )

   call msContour( x, y, z, order=2, labels=.false.,                    &
                   linespec="w", linewidth=1.5d0 )

   call msXLabel( "X" )
   call msYLabel( "Y" )
   call msTitle( "using order 2" )
   call msColorbar( "on" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Contour_10b.eps" )
   call msPrint( "Contour_10b.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()
   call msClf()

!------

   print *, " test 11"

   x = [ 0.05d0, 1.05d0, 1.00d0, -0.05d0, 0.50d0 ]
   y = [ 0.0d0, -0.03d0, 0.98d0,  0.95d0, 0.60d0 ]
   z = x + y
   call msDisplay( .t.(x .vc. y .vc. z), "nodes (x, y, value)" )

   tri = mfDelaunay( x, y )
   call msDisplay( tri, "triangles" )

   call msCAxis( [ 0.0d0, 2.0d0 ] )
   call msColormap( "parula" )

   call msTriMesh( x, y, tri, color=[0.75d0,0.75d0,0.75d0] )
   call msAxis( [ -0.1d0, 1.1d0, -0.1d0, 1.1d0 ] )
   call msHold( "on" )

   call msTriContour( x, y, z, tri, linewidth=2.0d0 )

   call msXLabel( "x" )
   call msYLabel( "y" )
   call msColorbar( "on" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Contour_11.eps" )
   call msPrint( "Contour_11.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()
   call msClf()

!------

   print *, " test 12"

   x = [ 0.05d0, 1.05d0, 1.0d0, -0.05d0, 0.5d0 ]
   y = [ 0.0d0, -0.05d0, 1.0d0,  0.95d0, 0.5d0 ]
   z = x + y
   call msDisplay( .t.(x .vc. y .vc. z), "nodes (x, y, value)" )

   tri = mfDelaunay( x, y )
   call msDisplay( tri, "triangles" )

   call msAxis( [ -0.1d0, 1.1d0, -0.1d0, 1.1d0 ] )
   call msCAxis( [ 0.0d0, 2.0d0 ] )

   call msTriMesh( x, y, tri, color=[0.75d0,0.75d0,0.75d0] )
   call msHold( "on" )

   call msTriContour( x, y, z, tri, nb_levels=24 )

   call msXLabel( "x" )
   call msYLabel( "y" )
   call msColorbar( "on" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Contour_12.eps" )
   call msPrint( "Contour_12.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()
   call msClf()

!------

   print *, " test 13"

   x = [ 0.5d0, 10.5d0, 10.0d0, -0.5d0, 5.0d0 ]
   y = [ 0.0d0, -0.5d0, 10.0d0,  9.5d0, 5.0d0 ]
   z = x + y
   call msDisplay( .t.(x .vc. y .vc. z), "nodes (x, y, value)" )

   tri = mfDelaunay( x, y )
   call msDisplay( tri, "triangles" )

   call msAxis( [ -1.0d0, 11.0d0, -1.0d0, 11.0d0 ] )
   call msCAxis( [ 0.0d0, 20.0d0 ] )

   call msTriMesh( x, y, tri, color=[0.75d0,0.75d0,0.75d0] )
   call msHold( "on" )

   call msTriContour( x, y, z, tri, levels=mf([7.5,12.5]),             &
                      linespec="b--", linewidth=2.0d0 )

   call msXLabel( "x" )
   call msYLabel( "y" )
   call msColorbar( "on" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Contour_13.eps" )
   call msPrint( "Contour_13.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()
   call msClf()

!------

   print *, " test 14"

   N = 50
   call msMeshGrid( mfOut(x,y), mfLinspace(-2.0d0,8.5d0,N),             &
                            .t. mfLinspace(6.7d0,-3.5d0,N) )

   z = mfSin(x) + mfCos(y)

   call msAxis( "auto" )
   call msAxis( "equal" )
   call msCAxis( [ -2.0d0, 2.0d0 ] )

   call msContour( x, y, z, labels=.false., linewidth=2.0d0 )

   call msColorbar( "on", position="vert" )
   call msXLabel( "\fix" )
   call msYLabel( "\fiy" )
   call msTitle( "\fisin(x) \fn\x \ficos(y) \fn(rectangular grid)" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Contour_14a.eps" )
   call msPrint( "Contour_14a.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()
   call msHold( "off" )

   ! reshape x, y and z to vectors
   x = mfReshape( x, 1, MF_NO_ARG )
   y = mfReshape( y, 1, MF_NO_ARG )
   z = mfReshape( z, 1, MF_NO_ARG )
   tri = mfDelaunay( x, y )

   call msTriContour( x, y, z, tri, linewidth=2.0d0, labelsize=0.8d0 )

   call msColorbar( "on", position="vert" )
   call msXLabel( "\fix" )
   call msYLabel( "\fiy" )
   call msTitle( "\fisin(x) \fn\x \ficos(y) \fn(triangular grid)" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Contour_14b.eps" )
   call msPrint( "Contour_14b.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 15"

   N = 50
   call msMeshGrid( mfOut(x,y), mfLinspace(-2.0d0,8.5d0,N),             &
                            .t. mfLinspace(6.7d0,-3.5d0,N) )

   z = mfSin(x) + mfCos(y)

   call msAxis( "equal" )
   call msCAxis( [ -2.0d0, 2.0d0 ] )

   ! reshape x, y and z to vectors
   x = mfReshape( x, 1, MF_NO_ARG )
   y = mfReshape( y, 1, MF_NO_ARG )
   z = mfReshape( z, 1, MF_NO_ARG )
   tri = mfDelaunay( x, y )

   call msTriContour( mfOut(C), x, y, z, tri, linewidth=2.0d0,          &
                      levels=mf([-0.5d0,+0.5d0]) )

   call msColorbar( "on", position="vert" )
   call msXLabel( "\fix" )
   call msYLabel( "\fiy" )
   call msTitle( "\fisin(x) \fn\x \ficos(y) \fn(triangular grid)" )

   ! Print the contours coordinates on the terminal
   if( .not. mfIsEmpty(C) ) then
      ! Set F90 pointers to easily manipulate the mfArray data
      call msPointer( C, f90_ptr )
      j_max = size(f90_ptr,2) ! nb of columns
      j = 1
      nb_line = 0
      do
         if( j > j_max ) exit
         nb_line = nb_line + 1
         level = f90_ptr(1,j)
         write(string,"(A,I0,A,G0.4)") "line ", nb_line, " of level ", level
         npt   = f90_ptr(2,j)
         line = f90_ptr(:,j+1:j+npt)
         if( npt <= 6 ) then
            call msDisplay( .t.line, trim(string) )
         else
            call msDisplay( .t.line, trim(string), head=3, tail=3 )
         end if
         j = j + npt + 1
      end do
      print "(A,I0,A,/)", " got ", nb_line, " line(s)"
      call msFreePointer( C, f90_ptr )
   end if

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Contour_15.eps" )
   call msPrint( "Contour_15.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 16"

   N = 50
   call msMeshGrid( mfOut(x,y), mfLinspace(-2.0d0,8.5d0,N),             &
                            .t. mfLinspace(6.7d0,-3.5d0,N) )

   z = mfSin(x) + mfCos(y)

   call msAxis( "equal" )
   call msCAxis( [ -2.0d0, 2.0d0 ] )

   ! reshape x, y and z to vectors
   x = mfReshape( x, 1, MF_NO_ARG )
   y = mfReshape( y, 1, MF_NO_ARG )
   z = mfReshape( z, 1, MF_NO_ARG )
   tri = mfDelaunay( x, y )
   call msBuildTriConnect( x, y, tri, tri_connect )
   call msPrintTriConnect( tri_connect, short_info=.true. )

   call msTriContour( z, tri_connect, linewidth=2.0d0, labelsize=0.8d0 )

   call msColorbar( "on", position="vert" )
   call msXLabel( "\fix" )
   call msYLabel( "\fiy" )
   call msTitle( "\fisin(x) \fn\x \ficos(y) \fn(triangular grid)" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Contour_16.eps" )
   call msPrint( "Contour_16.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

!------

   print *, " test 17"

   N = 50
   call msMeshGrid( mfOut(x,y), mfLinspace(-2.0d0,8.5d0,N),             &
                            .t. mfLinspace(6.7d0,-3.5d0,N) )

   z = mfSin(x) + mfCos(y)

   call msAxis( "equal" )
   call msCAxis( [ -2.0d0, 2.0d0 ] )

   ! reshape x, y and z to vectors
   x = mfReshape( x, 1, MF_NO_ARG )
   y = mfReshape( y, 1, MF_NO_ARG )
   z = mfReshape( z, 1, MF_NO_ARG )
   tri = mfDelaunay( x, y )
   call msBuildTriConnect( x, y, tri, tri_connect )
   call msPrintTriConnect( tri_connect, short_info=.true. )

   call msTriContour( mfOut(C), z, tri_connect, linewidth=2.0d0,        &
                      levels=mf([-0.5d0,+0.5d0]) )

   call msColorbar( "on", position="vert" )
   call msXLabel( "\fix" )
   call msYLabel( "\fiy" )
   call msTitle( "\fisin(x) \fn\x \ficos(y) \fn(triangular grid)" )

   ! Print the contours coordinates on the terminal
   if( .not. mfIsEmpty(C) ) then
      ! Set F90 pointers to easily manipulate the mfArray data
      call msPointer( C, f90_ptr )
      j_max = size(f90_ptr,2) ! nb of columns
      j = 1
      nb_line = 0
      do
         if( j > j_max ) exit
         nb_line = nb_line + 1
         level = f90_ptr(1,j)
         write(string,"(A,I0,A,G0.4)") "line ", nb_line, " of level ", level
         npt   = f90_ptr(2,j)
         line = f90_ptr(:,j+1:j+npt)
         if( npt <= 6 ) then
            call msDisplay( .t.line, trim(string) )
         else
            call msDisplay( .t.line, trim(string), head=3, tail=3 )
         end if
         j = j + npt + 1
      end do
      print "(A,I0,A,/)", " got ", nb_line, " line(s)"
      call msFreePointer( C, f90_ptr )
   end if

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Contour_17.eps" )
   call msPrint( "Contour_17.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

   call msClf()

!------

   print *, " test 18"

   N = 10
   call msMeshGrid( mfOut(x,y), mfLinspace(-1.0d0,1.0d0,N),             &
                            .t. mfLinspace(-1.0d0,1.0d0,N) )

   z = x**2 - y**2
   call msSet( MF_NAN, z, 3, 3 )
   call msSet( MF_INF, z, 7, 7 )

   call msAxis( "equal" )
   call msCAxis( [ -2.0d0, 2.0d0 ] )

   ! reshape x, y and z to vectors
   x = mfReshape( x, 1, MF_NO_ARG )
   y = mfReshape( y, 1, MF_NO_ARG )
   z = mfReshape( z, 1, MF_NO_ARG )
   tri = mfDelaunay( x, y )

   call msTriContour( x, y, z, tri, linewidth=2.0d0,                    &
                      levels=mf([-0.5d0,-0.25d0,-0.1d0,+0.1d0,+0.25d0,+0.5d0]),       &
                      labels=.false. )

   call msColorbar( "on", position="vert" )
   call msXLabel( "\fix" )
   call msYLabel( "\fiy" )
   call msTitle( "\fix\u2\d - \fiy\u2\d \fn(triangular grid); z have non-finite values" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Contour_18.eps" )
   call msPrint( "Contour_18.pdf" )
   write(STDOUT,"(A,/)") " done ***"

   call msPause()

   call msClf()

!------

   print *, " test 19"

   N = 10
   call msMeshGrid( mfOut(x,y), mfLinspace(-1.0d0,1.0d0,N),             &
                            .t. mfLinspace(-1.0d0,1.0d0,N) )

   z = x**2 - y**2
   call msSet( MF_NAN, z, 3, 3 )
   call msSet( MF_INF, z, 7, 7 )

   call msAxis( "equal" )
   call msCAxis( [ -2.0d0, 2.0d0 ] )

   ! reshape x, y and z to vectors
   x = mfReshape( x, 1, MF_NO_ARG )
   y = mfReshape( y, 1, MF_NO_ARG )
   z = mfReshape( z, 1, MF_NO_ARG )
   tri = mfDelaunay( x, y )
   call msBuildTriConnect( x, y, tri, tri_connect )

   call msTriContour( z, tri_connect, linewidth=2.0d0,                  &
                      levels=mf([-0.5d0,-0.25d0,-0.1d0,+0.1d0,+0.25d0,+0.5d0]),       &
                      labels=.false. )

   call msColorbar( "on", position="vert" )
   call msXLabel( "\fix" )
   call msYLabel( "\fiy" )
   call msTitle( "idem previous test; but using mesh connectivity" )

   write(STDOUT,"(A)",advance="no") "  *** printing..."
   call msFlush(STDOUT)
   call msPrint( "Contour_19.eps" )
   call msPrint( "Contour_19.pdf" )
   write(STDOUT,"(A,/)") " done ***"

!_______________________________________________________________________
!
99 continue

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y, r, z, theta, c, line )
   call msRelease( tri )
   call msRelease( tri_connect )

end program
