program ColorBar_test

   use fml
   use fgl

   use test_aux

   implicit none

   real(kind=MF_DOUBLE) :: x, y

   real(kind=MF_DOUBLE) :: char_height_factor

   character(len=1) :: ans
   logical :: interactive

!_______________________________________________________________________
!

   call run_options()

   write(*,"(A)",advance="no") " --------> skip interactive session ? [Y]/N "
   read "(A)", ans
   interactive = mfToUpper(ans) == "N"

   !-------------------------------------------------------------

   call msFigure(1)

   call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
   call msXLabel("X axis")
   call msYLabel("Y axis")
   call msTitle("Title")

#ifndef _NO_X11
   if( mfGetX11Device() == "on" .and. interactive ) then
      call msResizeWindow()
   end if
#endif

   call msColorMap( "grey" )
   ! putting a color bar (default : horizontal, for standard window dimension)
   call msColorbar( "on", label="grey colormap" )

   call msPrint("ColorBar_1-1.eps")
   call msPrint("ColorBar_1-1.pdf")

   call msPause()

   ! deleting previous color bar
   call msColorbar( "off" )
   call msColorMap( "rainbow" )
   call msColorbar( "on", label="rainbow colormap" )

   call msPrint("ColorBar_1-2.eps")
   call msPrint("ColorBar_1-2.pdf")

   call msPause()

   call msColorbar( "off" )
   ! and put another one in vertical position
   call msColorbar( "on", "vert", label="rainbow colormap" )

   call msPrint("ColorBar_1-3.eps")
   call msPrint("ColorBar_1-3.pdf")

   call msPause()

   ! come back to a horizontal colorbar
   call msColorbar( "off" )
   call msColorMap( "hot" )
   call msColorbar( "on", label="hot colormap" )

   call msPrint("ColorBar_1-4.eps")
   call msPrint("ColorBar_1-4.pdf")

   ! same with 'ij' axis mode -- without X Label
   call msAxis( "ij" )
   call msPause()

   call msPrint("ColorBar_1-5.eps")
   call msPrint("ColorBar_1-5.pdf")

   call msColorbar( "on", "vert", label="hot colormap" )
   call msPause()

   !-------------------------------------------------------------

   call msFigure(2) ! axis equal, with large aspect ratio

   x = 1.0d0
   y = 0.2d0
   call msAxis( [ 0.0d0, x, 0.0d0, y ] )
   call msAxis( "equal" )
   call msXLabel("X axis")
   call msYLabel("Y axis")
   call msTitle("Title")

#ifndef _NO_X11
   if( mfGetX11Device() == "on" .and. interactive ) then
      call msResizeWindow()
   end if
#endif

   call msColorMap( "rainbow" )
   call msColorbar( "on", label="rainbow colormap" )

   call msPrint("ColorBar_2-1.eps")
   call msPrint("ColorBar_2-1.pdf")

   call msPause()

   call msColorbar( "off" )

   x = 0.2d0
   y = 1.0d0
   call msAxis( [ 0.0d0, x, 0.0d0, y ] )
   call msColorbar( "on", label="rainbow colormap" )

   call msPrint("ColorBar_2-2.eps")
   call msPrint("ColorBar_2-2.pdf")

   call msPause()

   ! same with 'ij' axis mode -- without X Label
   call msAxis( "ij" )
   call msPause()

   !-------------------------------------------------------------

   call msFigure(3) ! axis equal, with large aspect ratio,
                    ! and bigger character size for labels
                    ! (CharInPixels: "off")
   char_height_factor = 1.35d0
   call msAxisFontSize( char_height_factor )
   call msLabelFontSize( char_height_factor )

   x = 0.8d0
   y = 0.2d0
   call msAxis( [ 0.0d0, x, 0.0d0, y ] )
   call msAxis( "equal" )
   call msXLabel("X axis")
   call msYLabel("Y axis")
   call msTitle("Title")

   call msColorMap( "rainbow" )
   call msColorbar( "on", label="rainbow colormap" )

   call msPrint("ColorBar_3-1.eps")
   call msPrint("ColorBar_3-1.pdf")

   call msPause()

   call msColorbar( "off" )

   x = 0.2d0
   y = 0.8d0
   call msAxis( [ 0.0d0, x, 0.0d0, y ] )
   call msColorbar( "on", label="rainbow colormap" )

   call msPrint("ColorBar_3-2.eps")
   call msPrint("ColorBar_3-2.pdf")

   call msPause()

   ! same with 'ij' axis mode -- without X Label
   call msAxis( "ij" )
   call msPause()

   !-------------------------------------------------------------

   call msFigure(4) ! axis equal, with large aspect ratio,
                    ! and bigger character size for labels
                    ! (CharInPixels: "on")
   char_height_factor = 1.35d0
   call msCharInPixels( "on" )
   call msAxisFontSize( char_height_factor )
   call msLabelFontSize( char_height_factor )

   x = 1.0d0
   y = 0.2d0
   call msAxis( [ 0.0d0, x, 0.0d0, y ] )
   call msAxis( "equal" )
   call msXLabel("X axis")
   call msYLabel("Y axis")
   call msTitle("Title")

   call msColorMap( "rainbow" )
   call msColorbar( "on", label="rainbow colormap" )

   call msPrint("ColorBar_4-1.eps")
   call msPrint("ColorBar_4-1.pdf")

   call msPause()

   call msColorbar( "off" )

   x = 0.2d0
   y = 1.0d0
   call msAxis( [ 0.0d0, x, 0.0d0, y ] )
   call msColorbar( "on", label="rainbow colormap" )

   call msPrint("ColorBar_4-2.eps")
   call msPrint("ColorBar_4-2.pdf")

!_______________________________________________________________________
!

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

end program
