program CharInPixels_test

   use fml
   use fgl

   use test_aux

   implicit none

   character(len=1) :: ans
   logical :: interactive

!_______________________________________________________________________
!

   call run_options()

   write(*,"(A)",advance="no") " --------> skip interactive session ? [Y]/N "
   read "(A)", ans
   interactive = mfToUpper(ans) == "N"

   !----------------------------------

   call msFigure(1)

   call msCharInPixels( "off" )

   call msTitle( "The title" )
   call msXLabel( "X-axis" )
   call msYLabel( "Y-axis" )

#ifndef _NO_X11
   if( mfGetX11Device() == "on" .and. interactive ) then
      call msResizeWindow()
   end if
#endif

   call msPrint("CharInPixels_1.eps")
   call msPrint("CharInPixels_1.pdf")

   !----------------------------------

   call msFigure(2)

   call msCharInPixels( "on" )

   call msTitle( "The title" )
   call msXLabel( "X-axis" )
   call msYLabel( "Y-axis" )

#ifndef _NO_X11
   if( mfGetX11Device() == "on" .and. interactive ) then
      call msResizeWindow()
   end if
#endif

   call msPrint("CharInPixels_2.eps")
   call msPrint("CharInPixels_2.pdf")

   call msAxisFontSize( 0.75d0 )
   call msLabelFontSize( 2.0d0 )
   call msPause()

   call msPrint("CharInPixels_2_b.eps")
   call msPrint("CharInPixels_2_b.pdf")

   !----------------------------------

   call msFigure(3)

   call msCharInPixels( "off" )

   call msAxis( "off" )
   call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )

   call msText(0.d0,0.800d0,"\fn4.000 : abcde, ABCDE, 01234",           &
               height=4.000d0 )

   call msText(0.d0,0.567d0,"\fr2.828 : abcde, ABCDE, 01234",           &
               height=2.828d0 )

   call msText(0.d0,0.400d0,"\fi2.000 : abcde, ABCDE, 01234",           &
               height=2.000d0 )

   call msText(0.d0,0.283d0,"\fn1.414 :  \fsabcde\fn,  \fsABCDE\fn, 01234", &
               height=1.414d0 )

   call msText(0.d0,0.200d0,"\fn1.000 : abcde, ABCDE, 01234",           &
               height=1.000d0 )

   call msText(0.d0,0.141d0,"\fr0.707 : abcde, ABCDE, 01234",           &
               height=0.707d0 )

   call msText(0.d0,0.100d0,"\fi0.500 : abcde, ABCDE, 01234",           &
               height=0.500d0 )

   call msText(0.d0,0.070d0,"\fn0.353 :  \fsabcde\fn,  \fsABCDE\fn, 01234", &
               height=0.353d0 )

#ifndef _NO_X11
   if( mfGetX11Device() == "on" .and. interactive ) then
      call msResizeWindow()
   end if
#endif

   call msPrint("CharInPixels_3.eps")
   call msPrint("CharInPixels_3.pdf")

   !----------------------------------

   call msFigure( 4, size=[755, 450] )

   call msCharInPixels( "on" )

   call msAxis( "off" )
   call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )

   call msText(0.d0,0.800d0,"\fn4.000 : abcde, ABCDE, 01234",           &
               height=4.000d0 )

   call msText(0.d0,0.567d0,"\fr2.828 : abcde, ABCDE, 01234",           &
               height=2.828d0 )

   call msText(0.d0,0.400d0,"\fi2.000 : abcde, ABCDE, 01234",           &
               height=2.000d0 )

   call msText(0.d0,0.283d0,"\fn1.414 :  \fsabcde\fn,  \fsABCDE\fn, 01234", &
               height=1.414d0 )

   call msText(0.d0,0.200d0,"\fn1.000 : abcde, ABCDE, 01234",           &
               height=1.000d0 )

   call msText(0.d0,0.141d0,"\fr0.707 : abcde, ABCDE, 01234",           &
               height=0.707d0 )

   call msText(0.d0,0.100d0,"\fi0.500 : abcde, ABCDE, 01234",           &
               height=0.500d0 )

   call msText(0.d0,0.070d0,"\fn0.353 :  \fsabcde\fn,  \fsABCDE\fn, 01234", &
               height=0.353d0 )

#ifndef _NO_X11
   if( mfGetX11Device() == "on" .and. interactive ) then
      call msResizeWindow()
   end if
#endif

   call msPrint("CharInPixels_4.eps")
   call msPrint("CharInPixels_4.pdf")

!_______________________________________________________________________
!

99 continue
   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

end program
