! this file must be kept in UTF-8 encoding

program CharEncoding_UTF8_test

   use fml
   use fgl

   use test_aux

   implicit none

   type(mfArray) :: x, y
   character(len=120) :: string

!_______________________________________________________________________
!

   call run_options()

   !----------------------------------
   call msFigure(1)

   ! unit square increased to 10%
   ! (this imply switching to 'manual' mode)
   call msAxis( [ -1.05d0, 1.05d0, -1.05d0, 1.05d0] )

   ! some french words with accentuated characters

   !----------------------------------
   ! UTF-8 encoding
   call msSetCharEncoding( "UTF-8" )
   string = "from a UTF-8 character string:"
   call msText( -1.04d0,  0.0d0, trim(string) )

   string = "à moi, pâle, été, après, forêt, aiguë, gît, maïs, " // &
            "ô, où, dû, capharnaüm, ça, æ, °C"
   call msText( -1.0d0, -0.2d0, trim(string) )

   string = "À MOI, PÂLE, ÉTÉ, APRÈS, FORÊT, AIGUË, GÎT, MAÏS, " // &
            "Ô, OÙ, DÛ, CAPHARNAÜM, ÇA, Æ"
   call msText( -1.0d0, -0.4d0, trim(string) )

   call msYLabel( "I (ampères) [UTF-8]" )

   !----------------------------------
   ! Math writing ("\-" means a long hyphen, i.e. minus in math mode)
   string = "\fi y = e\ux\u2\d\d \-  \fsL\fi\d\(alpha)\dh\u\u \-  2\u2\u2\d\d 3\d3\d3\u\u"
   call msText( 0.0d0, -0.8d0, trim(string), just=0.0d0, height=2.0d0 )

   !----------------------------------
   print *
   call msPause("Ready to print?")

   call msPrint("CharEncoding_UTF8.eps")
   call msPrint("CharEncoding_UTF8.pdf")

!_______________________________________________________________________
!
99 continue

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y )

end program
