! this file must be kept in ISO-8859-1 (Latin-1) encoding

program CharEncoding_ISO_test

   use fml
   use fgl

   use test_aux

   implicit none

   type(mfArray) :: x, y
   character(len=120) :: string
   integer :: h

!_______________________________________________________________________
!

   call run_options()

   !----------------------------------
   call msFigure(1)

   ! unit square increased to 10%
   ! (this imply switching to 'manual' mode)
   call msAxis( [ -1.05d0, 1.05d0, -1.05d0, 1.05d0] )

   ! some french words with accentuated characters

   !----------------------------------
   ! ISO-8859-1 (Latin-1) encoding
   call msSetCharEncoding( "Latin" )
   string = "from a Latin-1 character string:"
   call msText( -1.04d0, 0.8d0, trim(string) )

   string = " moi, ple, t, aprs, fort, aigu, gt, mas, " //     &
            ", o, d, capharnam, a, , C"
   call msText( -1.0d0, 0.6d0, trim(string) )

   string = " MOI, PLE, T, APRS, FORT, AIGU, GT, MAS, " //     &
            ", O, D, CAPHARNAM, A, "
   call msText( -1.0d0, 0.4d0, trim(string) )

   call msXLabel( "L (mtres) [Latin-1]" )
   call msTitle( "Intensit du courant en fonction de la longueur de cble [Latin-1]" )

   !----------------------------------
   ! Math writing ("\-" means a long hyphen, i.e. minus in math mode)
   string = "\fi y = e\ux\u2\d\d \-  \fsL\fi\d\(alpha)\dh\u\u \-  2\u2\u2\d\d 3\d3\d3\u\u"
   h = mfText( 0.0d0, -0.8d0, trim(string), just=0.0d0, height=2.0d0 )

   !----------------------------------
   print *
   call msPause("Ready to print?")

   call msPrint("CharEncoding_ISO.eps")
   call msPrint("CharEncoding_ISO.pdf")

!_______________________________________________________________________
!
99 continue

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y )

end program
