program Axis_test

   use fml
   use fgl

   use test_aux

   implicit none

   type(mfArray) :: x, y
   integer :: i
   character(len=80) :: title

!_______________________________________________________________________
!

   call run_options()

   call msFigure(1)

   ! blank figure: current axis should be [0, 0, 0, 0]
   call msDisplay( mfAxis(), "current axis" )
   call msPause()

   ! msAxis_mode

   print *, " test 1"
   call msAxis( "off" )
   call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
   call msDisplay( mfAxis(), "current axis" )
   call msPause()

   call msAxis( "on" )

   print *, " test 2"
   call msAxis( "auto" )
   x = mfRandN(5,1)
   y = mfRandN(5,1)
   call msPlot( x, y, "o" )
   call msTitle( "5 markers" )
   call msPause()

   ! switch to 'manual'

   print *, " test 3"
   call msAxis( "manual" )
   x = mfRandN(500,1)
   y = mfRandN(500,1)
   call msPlot( x, y, "o" )
   call msTitle( "500 markers, but same axis range" )
   call msPause()

   ! switch to 'auto'

   print *, " test 4"
   call msAxis( "auto" )
   call msAxis( "equal" )
   call msTitle( "500 markers, using 'auto' mode and 'equal' scaling" )
   call msPause()

   print *, " test 5"
   do i = 1, 2
      x = mfRandN(500,1)
      y = mfRandN(500,1)
      call msPlot( x, y, "o" )
      write( title, "(I0)" ) i
      title = "Plot using other random data (" // trim(title) // "/2)"
      call msTitle( title )
      call msPause()
   end do

   ! redraw many times
   print *, " test 6"
   do i = 1, 2
      call msRedrawFigure()
      write( title, "(I0)" ) i
      title = "Redrawing... " // trim(title) // "/2"
      print *, trim(title)
      call msPause()
   end do

   ! switch to 'tight'
   print *, " test 7"
   call msAxis( "tight" )
   call msTitle( "'tight' mode (keeping 'equal' scaling)" )
   call msPause()

   call msClf()

   ! msAxis_real_range
   print *, " test 8"
   call msAxis( [ 1.0d0, 2.0d0, 3.0d0, 4.0d0 ] )
   call msDisplay( mfAxis(), "current axis" )
   call msDisplay( mfAxis( axis="x"), "current X-axis" )
   call msDisplay( mfAxis( axis="y"), "current Y-axis" )
   call msPause()

   ! other examples with large aspect ratio
   print *, " test 9"
   call msAxis( [ 0.0d0, 1.0d0, -2.5d0, 2.5d0 ] )
   call msAxis( "equal" )
   call msPause()

   print *, " test 10"
   call msAxis( [ -4.0d0, 4.0d0, 0.0d0, 1.0d0 ] )
   call msPause()

   ! only one axis can be specified, instead of both
   print *, " test 11"
   call msAxis( [ -3.0d0, 3.0d0 ], axis="x" )
   call msPause()

   print *, " test 12"
   call msAxis( [ -0.5d0, 1.5d0 ], axis="y" )
   call msPause()

   ! msAxis_mf_range

   ! We can invert axes in this way...
   print *, " test 13"
   call msAxis( [ 1.05d0, -0.05d0, 1.05d0, -0.05d0 ] )
   call msDisplay( mfAxis(), "current axis" )
   call msPause()

   ! ...or in this other way
   print *, " test 14"
   call msAxis( "inverted", "x")
   call msPause()

   print *, " test 15"
   call msAxis( "inverted", "y")
   call msPause()

   print *, " test 16"
   call msAxis( "auto" )
   call msPause()

   print *, " test 17"
   call msAxisFontSize( 1.35d0 )
   call msLabelFontSize( 1.35d0 )
   call msPlot( mf([0,1]), mf([0,1]), linewidth=3.0d0 )
   call msText( 0.6d0, 0.5d0, "Blue line", height=2.5d0 )
   call msXLabel( "X" )
   call msYLabel( "Y" )
   call msTitle( "Title" )
   call msPause()

   print *, " test 18"
   call msAxis( "off" )
   print *, "axis, X-, Y-labels and title should be removed..."

   !----------------------------
   call msFigure(2)

   call msAxisLabelFormat( x_axis_mode="time" )

   print *, " test 19"
   call msAxis( [ 0.0d0, 60.0d0, 0.0d0, 1.0d0 ] )
   call msXLabel( "time (min and sec)" )

   call msPrint( "Axis_time_1.eps" )
   call msPrint( "Axis_time_1.pdf" )
   call msPause()

   print *, " test 20"
   call msAxis( [ 0.0d0, 3600.0d0, 0.0d0, 1.0d0 ] )
   call msXLabel( "time (hr and min)" )

   call msPrint( "Axis_time_2.eps" )
   call msPrint( "Axis_time_2.pdf" )
   call msPause()

   print *, " test 21"
   call msAxis( [ 0.0d0, 24*3600.0d0, 0.0d0, 1.0d0 ] )
   call msXLabel( "time (day and hr)" )

   call msPrint( "Axis_time_3.eps" )
   call msPrint( "Axis_time_3.pdf" )
   call msPause()

   print *, " test 22"
   call msAxis( [ 0.0d0, 10*24*3600.0d0, 0.0d0, 1.0d0 ] )
   call msXLabel( "time (days)" )

   call msPrint( "Axis_time_4.eps" )
   call msPrint( "Axis_time_4.pdf" )

!_______________________________________________________________________
!

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

end program
