program AxisLineWidth_test

   use fml
   use fgl

   use test_aux

   implicit none

   type(mfArray) :: x, y
   real(kind=MF_DOUBLE), parameter :: c  = 0.05d0, w0 = 1.00d0,         &
                                      fc = 1.6d0,  fw = sqrt(2.0d0)
   real(kind=MF_DOUBLE) :: w
   integer :: i

   character(len=1) :: ans
   logical :: interactive

!_______________________________________________________________________
!

   call run_options()

   write(*,"(A)",advance="no") " --------> skip interactive session ? [Y]/N "
   read "(A)", ans
   interactive = mfToUpper(ans) == "N"

   !----------------------------------

   call msFigure(4)

   call msAxis( [ -1.0d0, 1.0d0, -1.0d0, 1.0d0 ] )

   x = [ -c,  c,  c, -c, -c ]
   y = [ -c, -c,  c,  c, -c ]
   w = w0

   print *
   print "(2X,A,G0.4,A,I0,A)", "plotting a colored line of width = ", w, &
                               " (", nint(w/w0), " pix.)"
   call msPlot( x, y, linewidth=w )
   call msHold( "on" )
   do i = 1, 6
      x = x*fc
      y = y*fc
      w = w*fw
      print "(2X,A,G0.4,A,I0,A)", "plotting a colored line of width = ", w, &
                                  " (", nint(w/w0), " pix.)"
      call msPlot( x, y, linewidth=w )
   end do
   print *

   call msAxisLineWidth( 2.0d0 )

   call msTitle( "The title" )
   call msXLabel( "X-axis" )
   call msYLabel( "Y-axis" )

#ifndef _NO_X11
   if( mfGetX11Device() == "on" .and. interactive ) then
      call msResizeWindow()
   end if
#endif

   call msPause("Going to resize the window to 555 x 777 ...")
   call msResizeWindow( 555, 777 )

   call msPrint("AxisLineWidth_1.eps")
   call msPrint("AxisLineWidth_1.pdf")

!_______________________________________________________________________
!

   ! Waits for a user answer (avoids that all graphic windows disappear)
   ! then, cleans internal memory
   call msExitFgl()

   call msRelease( x, y )

end program
