! f90 include file
!
! list of Fortran 90 interfaces for some of the UMFPACK wrapper
! routines, stored in the file: 'umf4_f90wrapper.c'.
!
! Copyright É. Canot 2003-2025 -- IPR/CNRS

interface
!-----------------------------------------------------------------------
!                      R E A L     V A L U E S
!-----------------------------------------------------------------------

!_______________________________________________________________________
!
subroutine umf4def_d( Control )
   ! misc parameters for UmfPack
   double precision, intent(in) :: Control(20)
end subroutine
!_______________________________________________________________________
!
! pre-ordering and symbolic factorization
subroutine umf4sym_d( m, n, Ap, Ai, Ax, symbolic, control, infos )
   import :: MF_ADDRESS, MF_DOUBLE
   ! shape of the square matrix A (sparse)
   integer, intent(in) :: m, n
   ! indexes of A (CSC storage with C indexes, i.e. 0-based)
   integer, intent(in) :: Ap(*), Ai(*)
   ! numerical entries of A (CSC)
   real(kind=MF_DOUBLE), intent(in) :: Ax(*)
   ! address of a specific structure storing information
   integer(kind=MF_ADDRESS), intent(out) :: symbolic
   ! misc parameters for UmfPack
   double precision, intent(in) :: Control(20)
   ! returned status
   double precision, intent(out) :: infos(90)
end subroutine
!_______________________________________________________________________
!
! symbolic factorization with given ordering
subroutine umf4qsym_d( m, n, Ap, Ai, Ax, Qinit, symbolic, control, infos )
   import :: MF_ADDRESS, MF_DOUBLE
   ! shape of the square matrix A (sparse)
   integer, intent(in) :: m, n
   ! indexes of A (CSC storage with C indexes, i.e. 0-based)
   integer, intent(in) :: Ap(*), Ai(*), Qinit(*)
   ! numerical entries of A (CSC)
   real(kind=MF_DOUBLE), intent(in) :: Ax(*)
   ! address of a specific structure storing information
   integer(kind=MF_ADDRESS), intent(out) :: symbolic
   ! misc parameters for UmfPack
   double precision, intent(in) :: Control(20)
   ! returned status
   double precision, intent(out) :: infos(90)
end subroutine
!_______________________________________________________________________
!
! numeric factorization
subroutine umf4num_d( n, Ap, Ai, Ax, symbolic, numeric, control, infos )
   import :: MF_ADDRESS, MF_DOUBLE
   ! nb of col of the square matrix A (sparse)
   integer, intent(in) :: n
   ! indexes of A (CSC storage with C indexes, i.e. 0-based)
   integer, intent(in) :: Ap(*), Ai(*)
   ! numerical entries of A (CSC)
   real(kind=MF_DOUBLE), intent(in) :: Ax(*)
   ! address of a specific structure storing information
   integer(kind=MF_ADDRESS), intent(in) :: symbolic
   ! address of a specific structure storing the factors
   integer(kind=MF_ADDRESS), intent(out) :: numeric
   ! misc parameters for UmfPack
   double precision, intent(in) :: Control(20)
   ! returned status
   double precision, intent(out) :: infos(90)
end subroutine
!_______________________________________________________________________
!
! solve a linear system without iterative refinement
!   many variants with first arg: cf. umfpack.h
subroutine umf4sol_d( sys, x, b, numeric, control, infos )
   import :: MF_ADDRESS, MF_DOUBLE
   ! option defining what to solve
   integer, intent(in) :: sys
   ! vector solution
   real(kind=MF_DOUBLE), intent(out) :: x(*)
   ! RHS of the equation
   real(kind=MF_DOUBLE), intent(in) :: b(*)
   ! address of a specific structure storing the factors
   integer(kind=MF_ADDRESS), intent(in) :: numeric
   ! misc parameters for UmfPack
   double precision, intent(in) :: Control(20)
   ! returned status
   double precision, intent(out) :: infos(90)
end subroutine
!_______________________________________________________________________
!
! solve a linear system without iterative refinement
!   workspace must be allocated before, and so allow to multiple solve
!   many variants with first arg: cf. umfpack.h
subroutine umf4wsol_d( sys, x, b, numeric, control, infos, Wi, W )
   import :: MF_ADDRESS, MF_UF_LONG, MF_DOUBLE
   ! option defining what to solve
   integer, intent(in) :: sys
   ! vector solution
   real(kind=MF_DOUBLE), intent(out) :: x(*)
   ! RHS of the equation
   real(kind=MF_DOUBLE), intent(in) :: b(*)
   ! address of a specific structure storing the factors
   integer(kind=MF_ADDRESS), intent(in) :: numeric
   ! misc parameters for UmfPack
   double precision, intent(in) :: Control(20)
   ! returned status
   double precision, intent(out) :: infos(90)
   ! integer workspace
   integer(kind=MF_UF_LONG), intent(in) :: Wi(*)
   ! real workspace
   real(kind=MF_DOUBLE), intent(in) :: W(*)
end subroutine
!_______________________________________________________________________
!
! solve a linear system with iterative refinement
!   many variants with first arg: cf. umfpack.h
subroutine umf4solr_d( sys, Ap, Ai, Ax, x, b, numeric, control, infos )
   import :: MF_ADDRESS, MF_DOUBLE
   ! option defining what to solve
   integer, intent(in) :: sys
   ! indexes of A (CSC storage with C indexes, i.e. 0-based)
   integer, intent(in) :: Ap(*), Ai(*)
   ! numerical entries of A (CSC)
   real(kind=MF_DOUBLE), intent(in) :: Ax(*)
   ! vector solution
   real(kind=MF_DOUBLE), intent(out) :: x(*)
   ! RHS of the equation
   real(kind=MF_DOUBLE), intent(in) :: b(*)
   ! address of a specific structure storing the factors
   integer(kind=MF_ADDRESS), intent(in) :: numeric
   ! misc parameters for UmfPack
   double precision, intent(in) :: Control(20)
   ! returned status
   double precision, intent(out) :: infos(90)
end subroutine
!_______________________________________________________________________
!
! get the NNZ of U_diag
subroutine umf4nzudiag_d( nz_udiag, numeric, status )
   import :: MF_ADDRESS
   ! returned NNZ
   integer, intent(out) :: nz_udiag
   ! address of a specific structure storing information
   integer(kind=MF_ADDRESS), intent(in) :: numeric
   ! returned status
   integer, intent(out) :: status
end subroutine
!_______________________________________________________________________
!
! get the diagonal of U
subroutine umf4getudiag_d( udiag, numeric, status )
   import :: MF_ADDRESS, MF_DOUBLE
   ! returned diag
   real(kind=MF_DOUBLE), intent(out) :: udiag(*)
   ! address of a specific structure storing information
   integer(kind=MF_ADDRESS), intent(in) :: numeric
   ! returned status
   integer, intent(out) :: status
end subroutine
!_______________________________________________________________________
!
! get the NNZ of L and U factors
subroutine umf4nzlu_d( Lnz, Unz, numeric, status )
   import :: MF_ADDRESS
   ! returned NNZ values
   integer, intent(out) :: Lnz, Unz
   ! address of a specific structure storing information
   integer(kind=MF_ADDRESS), intent(in) :: numeric
   ! returned status
   integer, intent(out) :: status
end subroutine
!_______________________________________________________________________
!
! get the L, U factors
subroutine umf4getlu_d( m, n, lnz, unz,                                 &
                        Lp, Lj, Lx, Up, Ui, Ux,                         &
                        numeric, status )
   import :: MF_ADDRESS, MF_DOUBLE
   ! shape of the square matrix A (sparse)
   integer, intent(in) :: m, n
   ! NNZ of L and U factors
   integer, intent(in) :: lnz, unz
   ! indexes of L (CSR storage with C indexes, i.e. 0-based)
   integer, intent(out) :: Lp(*), Lj(*)
   ! numerical entries of L (CSR)
   real(kind=MF_DOUBLE), intent(out) :: Lx(*)
   ! indexes of U (CSC storage with C indexes, i.e. 0-based)
   integer, intent(out) :: Up(*), Ui(*)
   ! numerical entries of U (CSC)
   real(kind=MF_DOUBLE), intent(out) :: Ux(*)
   ! address of a specific structure storing information
   integer(kind=MF_ADDRESS), intent(in) :: numeric
   ! returned status
   integer, intent(out) :: status
end subroutine
!_______________________________________________________________________
!
! get the L, U, P, Q, R factors
subroutine umf4getlupqr_d( m, n, lnz, unz,                              &
                           Lp, Li, Lx, Up, Ui, Ux, P, Q, Rs,            &
                           numeric, status )
   import :: MF_ADDRESS, MF_DOUBLE
   ! shape of the square matrix A (sparse)
   integer, intent(in) :: m, n
   ! NNZ of L and U factors
   integer, intent(in) :: lnz, unz
   ! indexes of L (CSR storage with C indexes, i.e. 0-based)
   integer, intent(out) :: Lp(*), Li(*)
   ! numerical entries of L (CSR)
   real(kind=MF_DOUBLE), intent(out) :: Lx(*)
   ! indexes of U (CSC storage with C indexes, i.e. 0-based)
   integer, intent(out) :: Up(*), Ui(*)
   ! numerical entries of U (CSC)
   real(kind=MF_DOUBLE), intent(out) :: Ux(*)
   ! permutation P and Q
   integer, intent(out) :: P(*), Q(*)
   ! scaling factor Rs
   real(kind=MF_DOUBLE), intent(out) :: Rs(*)
   ! address of a specific structure storing information
   integer(kind=MF_ADDRESS), intent(in) :: numeric
   ! returned status
   integer, intent(out) :: status
end subroutine
!_______________________________________________________________________
!
! free the Symbolic object
subroutine umf4fsym_d( symbolic )
   import :: MF_ADDRESS
   ! address of a specific structure storing information
   integer(kind=MF_ADDRESS), intent(in) :: symbolic
end subroutine
!_______________________________________________________________________
!
! free the Numeric object
subroutine umf4fnum_d( numeric )
   import :: MF_ADDRESS
   ! address of a specific structure storing the factors
   integer(kind=MF_ADDRESS), intent(in) :: numeric
end subroutine

!-----------------------------------------------------------------------
!                      C O M P L E X     V A L U E S
!-----------------------------------------------------------------------

!_______________________________________________________________________
!
subroutine umf4def_z( Control )
   ! misc parameters for UmfPack
   double precision, intent(in) :: Control(20)
end subroutine
!_______________________________________________________________________
!
! pre-ordering and symbolic factorization (cmplx)
subroutine umf4sym_z( m, n, Ap, Ai, Ax, Az, symbolic, control, infos )
   import :: MF_ADDRESS, MF_DOUBLE
   ! shape of the square matrix A (sparse)
   integer, intent(in) :: m, n
   ! indexes of A (CSC storage with C indexes, i.e. 0-based)
   integer, intent(in) :: Ap(*), Ai(*)
   ! numerical entries of A (CSC)
   real(kind=MF_DOUBLE), intent(in) :: Ax(*), Az(*)
   ! address of a specific structure storing information
   integer(kind=MF_ADDRESS), intent(out) :: symbolic
   ! misc parameters for UmfPack
   double precision, intent(in) :: Control(20)
   ! returned status
   double precision, intent(out) :: infos(90)
end subroutine
!_______________________________________________________________________
!
! numeric factorization (cmplx)
subroutine umf4num_z( n, Ap, Ai, Ax, Az, symbolic, numeric, control, infos )
   import :: MF_ADDRESS, MF_DOUBLE
   ! nb of col of the square matrix A (sparse)
   integer, intent(in) :: n
   ! indexes of A (CSC storage with C indexes, i.e. 0-based)
   integer, intent(in) :: Ap(*), Ai(*)
   ! numerical entries of A (CSC)
   real(kind=MF_DOUBLE), intent(in) :: Ax(*), Az(*)
   ! address of a specific structure storing information
   integer(kind=MF_ADDRESS), intent(in) :: symbolic
   ! address of a specific structure storing the factors
   integer(kind=MF_ADDRESS), intent(out) :: numeric
   ! misc parameters for UmfPack
   double precision, intent(in) :: Control(20)
   ! returned status
   double precision, intent(out) :: infos(90)
end subroutine
!_______________________________________________________________________
!
! solve a linear system without iterative refinement (cmplx)
!   many variants with first arg: cf. umfpack.h
subroutine umf4sol_z( sys, Xx, Xz, Bx, Bz, numeric, control, infos )
   import :: MF_ADDRESS, MF_DOUBLE
   ! option defining what to solve
   integer, intent(in) :: sys
   ! vector solution
   real(kind=MF_DOUBLE), intent(out) :: Xx(*), Xz(*)
   ! RHS of the equation
   real(kind=MF_DOUBLE), intent(in) :: Bx(*), Bz(*)
   ! address of a specific structure storing the factors
   integer(kind=MF_ADDRESS), intent(in) :: numeric
   ! misc parameters for UmfPack
   double precision, intent(in) :: Control(20)
   ! returned status
   double precision, intent(out) :: infos(90)
end subroutine
!_______________________________________________________________________
!
! solve a linear system without iterative refinement (cmplx)
!   workspace must be allocated before, and so allow to multiple solve
!   many variants with first arg: cf. umfpack.h
subroutine umf4wsol_z( sys, Xx, Xz, Bx, Bz, numeric, control, infos, Wi, W )
   import :: MF_ADDRESS, MF_UF_LONG, MF_DOUBLE
   ! option defining what to solve
   integer, intent(in) :: sys
   ! vector solution
   real(kind=MF_DOUBLE), intent(out) :: Xx(*), Xz(*)
   ! RHS of the equation
   real(kind=MF_DOUBLE), intent(in) :: Bx(*), Bz(*)
   ! address of a specific structure storing the factors
   integer(kind=MF_ADDRESS), intent(in) :: numeric
   ! misc parameters for UmfPack
   double precision, intent(in) :: Control(20)
   ! returned status
   double precision, intent(out) :: infos(90)
   ! integer workspace
   integer(kind=MF_UF_LONG), intent(in) :: Wi(*)
   ! real workspace
   real(kind=MF_DOUBLE), intent(in) :: W(*)
end subroutine
!_______________________________________________________________________
!
! get the NNZ of U_diag (cmplx)
subroutine umf4nzudiag_z( nz_udiag, numeric, status )
   import :: MF_ADDRESS
   ! returned NNZ
   integer, intent(out) :: nz_udiag
   ! address of a specific structure storing information
   integer(kind=MF_ADDRESS), intent(in) :: numeric
   ! returned status
   integer, intent(out) :: status
end subroutine
!_______________________________________________________________________
!
! get the diagonal of U (cmplx)
subroutine umf4getudiag_z( udiagr, udiagi, numeric, status )
   import :: MF_ADDRESS, MF_DOUBLE
   ! returned diag
   real(kind=MF_DOUBLE), intent(out) :: udiagr(*), udiagi(*)
   ! address of a specific structure storing information
   integer(kind=MF_ADDRESS), intent(in) :: numeric
   ! returned status
   integer, intent(out) :: status
end subroutine
!_______________________________________________________________________
!
! get the NNZ of L and U factors (cmplx)
subroutine umf4nzlu_z( Lnz, Unz, numeric, status )
   import :: MF_ADDRESS
   ! returned NNZ values
   integer, intent(out) :: Lnz, Unz
   ! address of a specific structure storing information
   integer(kind=MF_ADDRESS), intent(in) :: numeric
   ! returned status
   integer, intent(out) :: status
end subroutine
!_______________________________________________________________________
!
! get the L, U factors (cmplx)
subroutine umf4getlu_z( m, n, lnz, unz,                                 &
                        Lp, Li, Lr, Lz, Up, Ui, Ur, Uz,                 &
                        numeric, status )
   import :: MF_ADDRESS, MF_DOUBLE
   ! shape of the square matrix A (sparse)
   integer, intent(in) :: m, n
   ! NNZ of L and U factors
   integer, intent(in) :: lnz, unz
   ! indexes of L (CSR storage with C indexes, i.e. 0-based)
   integer, intent(out) :: Lp(*), Li(*)
   ! numerical entries of L (CSR)
   real(kind=MF_DOUBLE), intent(out) :: Lr(*), Lz(*)
   ! indexes of U (CSC storage with C indexes, i.e. 0-based)
   integer, intent(out) :: Up(*), Ui(*)
   ! numerical entries of U (CSC)
   real(kind=MF_DOUBLE), intent(out) :: Ur(*), Uz(*)
   ! address of a specific structure storing information
   integer(kind=MF_ADDRESS), intent(in) :: numeric
   ! returned status
   integer, intent(out) :: status
end subroutine
!_______________________________________________________________________
!
! get the L, U, P, Q, R factors (cmplx)
subroutine umf4getlupqr_z( m, n, lnz, unz,                              &
                           Lp, Li, Lr, Lz, Up, Ui, Ur, Uz, P, Q, Rs,    &
                           numeric, status )
   import :: MF_ADDRESS, MF_DOUBLE
   ! shape of the square matrix A (sparse)
   integer, intent(in) :: m, n
   ! NNZ of L and U factors
   integer, intent(in) :: lnz, unz
   ! indexes of L (CSR storage with C indexes, i.e. 0-based)
   integer, intent(out) :: Lp(*), Li(*)
   ! numerical entries of L (CSR)
   real(kind=MF_DOUBLE), intent(out) :: Lr(*), Lz(*)
   ! indexes of U (CSC storage with C indexes, i.e. 0-based)
   integer, intent(out) :: Up(*), Ui(*)
   ! numerical entries of U (CSC)
   real(kind=MF_DOUBLE), intent(out) :: Ur(*), Uz(*)
   ! permutation P and Q
   integer, intent(out) :: P(*), Q(*)
   ! scaling factor Rs
   real(kind=MF_DOUBLE), intent(out) :: Rs(*)
   ! address of a specific structure storing information
   integer(kind=MF_ADDRESS), intent(in) :: numeric
   ! returned status
   integer, intent(out) :: status
end subroutine
!_______________________________________________________________________
!
! free the Symbolic object (cmplx)
subroutine umf4fsym_z( symbolic )
   import :: MF_ADDRESS
   ! address of a specific structure storing information
   integer(kind=MF_ADDRESS), intent(in) :: symbolic
end subroutine
!_______________________________________________________________________
!
! free the Numeric object (cmplx)
subroutine umf4fnum_z( numeric )
   import :: MF_ADDRESS
   ! address of a specific structure storing the factors
   integer(kind=MF_ADDRESS), intent(in) :: numeric
end subroutine
!_______________________________________________________________________
!
! get the full version numbers
subroutine get_suitesparse_version( version )
   integer :: version(3)
end subroutine
!_______________________________________________________________________
!
end interface
