#include "meditor.h"

#include <qapplication.h>
#include <q3header.h>
#include <stdlib.h>
#include <stdio.h>

int max_i = 200, max_j = 200;

int ni = 0, nj = 0;

Table::Table()
    : Q3Table( max_i, max_j, 0, "table" )
{
    initMatrix();

    // if the user edited something we might need to update the matrix
    connect( this, SIGNAL( valueChanged( int, int ) ),
             this, SLOT( updateMatrix( int, int ) ) );

    // we need to trap "quit()"
    connect( qApp, SIGNAL( aboutToQuit() ),
             this, SLOT( saveMatrix() ) );
}

void Table::initMatrix()
{
    int dim1 = 0, dim2 = 0;
    scanf( "%d %d", &dim1, &dim2 );
    if( dim1 == 0 && dim2 == 0 ) {
//printf( "initMatrix : empty matrix\n" );
    } else {
//printf( "initMatrix : matrix of size = %d x %d\n", dim1, dim2 );
        if( dim1 > max_i || dim2 > max_j ) {
            printf("*** too big matrix : abort ***\n");
            exit(1);
        } else {
            ni = dim1;
            nj = dim2;
            double d;
            for( int i = 0; i < ni; i++ ) {
                for( int j = 0; j < nj; j++ ) {
                    scanf( "%lf", &d );
                    TableItem *ti = new TableItem( this, Q3TableItem::OnTyping,
                                                   QString::number( d ) );
                    setItem( i, j, ti );
                }
            }
        }
    }
}

void Table::saveMatrix()
{
//printf("saving...\n");
    for( int i = 0; i < ni; i++ ) {
        printf( "%lE", text(i,0).toDouble() );
        for( int j = 1; j < nj; j++ ) {
            printf( "\t%lE", text(i,j).toDouble() );
        }
        printf("\n");
    }
}

void Table::updateMatrix( int row, int col )
{

    if( text(row,col).isEmpty() ) return;

    bool ok;
    text(row,col).toDouble( &ok );

    if( ok ) {
//printf( "new val is Double\n" );
        if( row > ni-1 || col > nj-1 ) {
            if( row > ni-1 ) ni = row+1;
            if( col > nj-1 ) nj = col+1;
//printf( "new matrix size = %i x %i\n\n", ni, nj );
//printf( "zeroing empty cells... " );
            for( int i = 0; i < ni; i++ ) {
                for( int j = 0; j < nj; j++ ) {
                    if( text(i,j).isEmpty() ) {
                        TableItem *ti = new TableItem( this, Q3TableItem::OnTyping,
                                                       QString::number( 0 ) );
                        setItem( i, j, ti );
                    }
                }
            }
//printf( "done\n" );
        }
    } else {
//printf( "erasing !\n" );
        if( row <= ni-1 && col <= nj-1 ) {
            TableItem *ti = new TableItem( this, Q3TableItem::OnTyping,
                                           "NaN" );
            setItem( row, col, ti );
        } else {
            TableItem *ti = new TableItem( this, Q3TableItem::OnTyping,
                                           "" );
            setItem( row, col, ti );
        }
    }

}
