! f90 include file

! in this file, it is not required to protect (via 'msInitArgs')
! the mfArray 'x', because this last object should not be temporary.

!_______________________________________________________________________
!
   subroutine msSet_element_real8( data, x, i1, i2 )

      real(kind=MF_DOUBLE), intent(in) :: data
      type(mfArray) :: x
      integer, intent(in) :: i1, i2
      !------ API end ------

#ifdef _DEVLP
      integer :: n1, n2
      integer :: ncol
      integer :: status

      integer :: row_sorted ! because x%row_sorted is: integer(kind=kind_1)

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         return
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         return
      end if

      if( i1 < 1 .or. i2 < 1 ) then
         call PrintMessage( "msSet", "E",                               &
                            "bad value for indexes i1 or i2" )
         return
      end if

      if( i1 > x%shape(1) .or. i2 > x%shape(2) ) then
         if( x%status_restricted ) then
            call PrintMessage( "msSet", "E",                            &
                               "cannot reshape a restricted array" )
            return
         else
            n1 = max(i1,x%shape(1))
            n2 = max(i2,x%shape(2))
            x%shape = [ n1, n2 ]
            if( x%data_type == MF_DT_EMPTY ) then
               x%data_type = MF_DT_DBLE
               call realloc_array( x%double, n1, n2,                    &
                                   fill=mf_out_of_range_filling )
               x%double(i1,i2) = data
            else if( x%data_type == MF_DT_DBLE ) then
               call realloc_array( x%double, n1, n2,                    &
                                   fill=mf_out_of_range_filling )
               x%double(i1,i2) = data
            else if( x%data_type == MF_DT_CMPLX ) then
               call realloc_array( x%cmplx, n1, n2,                     &
                                   fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
               x%cmplx(i1,i2) = data
            else
               call PrintMessage( "msSet", "E",                         &
                                  "cannot setting one element in a sparse mfArray", &
                                  "when its indexes are out-of-range." )
               return
            end if
         end if
      else ! matrix A keep the same shape
         if( x%data_type == MF_DT_EMPTY ) then
            ! this case should have been detected previously;
            ! here: x%data_type == MF_DT_EMPTY, but with 'shape' /= (0,0)
            write(STDERR,*) "(MUESLI msSet:) internal ERROR: x%data_type = 0"
            mf_message_displayed = .true.
            call muesli_trace( pause="yes" )
            stop
         else if( x%data_type == MF_DT_DBLE ) then
            x%double(i1,i2) = data
         else if( x%data_type == MF_DT_CMPLX ) then
            x%cmplx(i1,i2) = data
         else if( x%data_type == MF_DT_SP_DBLE ) then
            ncol = x%shape(2)
            row_sorted = x%row_sorted
            call setelm( data, i1, i2, ncol, x%a, x%i, x%j,             &
                         row_sorted, status )
            if( status == 1 ) then
               call PrintMessage( "msSet", "I",                         &
                                  "adding a new entry for a(i,j) in a sparse matrix", &
                                  "is very inefficient!",               &
                                  "(try to modify a whole column at once)" )
               x%row_sorted = UNKNOWN
            else if( status == -1 ) then
               call PrintMessage( "msSet", "E",                         &
                                  "adding a new entry for a(i,j) in a sparse matrix:", &
                                  "not enough place!",                  &
                                  "(please increase nzmax)" )
            end if
         else if( x%data_type == MF_DT_SP_CMPLX ) then
            ncol = x%shape(2)
            row_sorted = x%row_sorted
            call setelm_cmplx( cmplx(data,kind=MF_DOUBLE), i1, i2,      &
                               ncol, x%z, x%i, x%j,                     &
                               row_sorted, status )
            if( status == 1 ) then
               call PrintMessage( "msSet", "I",                         &
                                  "adding a new entry for a(i,j) in a sparse matrix", &
                                  "is very inefficient!",               &
                                  "(try to modify a whole column at once)" )
               x%row_sorted = UNKNOWN
            else if( status == -1 ) then
               call PrintMessage( "msSet", "E",                         &
                                  "adding a new entry for a(i,j) in a sparse matrix:", &
                                  "not enough place!",                  &
                                  "(please increase nzmax)" )
            end if
         end if
      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            return
         end if
      end if

#endif
   end subroutine msSet_element_real8
!_______________________________________________________________________
!
   subroutine msSet_element_cmplx( data, x, i1, i2 )

      complex(kind=MF_DOUBLE), intent(in) :: data
      type(mfArray) :: x
      integer, intent(in) :: i1, i2
      !------ API end ------

#ifdef _DEVLP
      integer :: n1, n2
      integer :: ncol
      integer :: status

      integer :: row_sorted ! because x%row_sorted is: integer(kind=kind_1)

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         return
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         return
      end if

      if( i1 < 1 .or. i2 < 1 ) then
         call PrintMessage( "msSet", "E",                               &
                            "bad value for indexes i1 or i2" )
         return
      end if

      if( i1 > x%shape(1) .or. i2 > x%shape(2) ) then
         if( x%status_restricted ) then
            call PrintMessage( "msSet", "E",                            &
                               "cannot reshape a restricted array" )
            return
         else
            n1 = max(i1,x%shape(1))
            n2 = max(i2,x%shape(2))
            x%shape = [ n1, n2 ]
            if( x%data_type == MF_DT_EMPTY ) then
               call realloc_array( x%double, x%cmplx, n1, n2,           &
                                   fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
            else if( x%data_type == MF_DT_DBLE ) then
               call realloc_array( x%double, x%cmplx, n1, n2,           &
                                   fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
            else if( x%data_type == MF_DT_CMPLX ) then
               call realloc_array( x%cmplx, n1, n2,                     &
                                   fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
            else
               call PrintMessage( "msSet", "E",                         &
                                  "cannot setting one element in a sparse mfArray", &
                                  "when its indexes are out-of-range." )
               return
            end if
            x%data_type = MF_DT_CMPLX
            x%cmplx(i1,i2) = data
         end if
      else ! matrix A keep the same shape
         if( x%data_type == MF_DT_EMPTY ) then
            ! this case should have been detected previously;
            ! here: x%data_type == MF_DT_EMPTY, but with 'shape' /= (0,0)
            write(STDERR,*) "(MUESLI msSet:) internal ERROR: x%data_type = 0"
            mf_message_displayed = .true.
            call muesli_trace( pause="yes" )
            stop
         else if( x%data_type == MF_DT_DBLE ) then
            x%data_type = MF_DT_CMPLX
            allocate( x%cmplx(x%shape(1),x%shape(2)) )

            x%cmplx(:,:) = x%double(:,:)
            x%cmplx(i1,i2) = data
            deallocate( x%double )

            x%double => null()
         else if( x%data_type == MF_DT_CMPLX ) then
            x%cmplx(i1,i2) = data
         else if( x%data_type == MF_DT_SP_DBLE ) then
            call PrintMessage( "msSet", "E",                            &
                               "trying to modify a real sparse matrix", &
                               "with a complex new value!",             &
                               "(not yet available)" )
            return
         else if( x%data_type == MF_DT_SP_CMPLX ) then
            ncol = x%shape(2)
            row_sorted = x%row_sorted
            call setelm_cmplx( data, i1, i2, ncol, x%z, x%i, x%j,       &
                               row_sorted, status )
            if( status == 1 ) then
               call PrintMessage( "msSet", "I",                         &
                                  "adding a new entry for a(i,j) in a sparse matrix", &
                                  "is very inefficient!",               &
                                  "(try to modify a whole column at once)" )
               x%row_sorted = UNKNOWN
            else if( status == -1 ) then
               call PrintMessage( "msSet", "E",                         &
                                  "adding a new entry for a(i,j) in a sparse matrix:", &
                                  "not enough place!",                  &
                                  "(please increase nzmax)" )
            end if
         end if
      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            return
         end if
      end if

#endif
   end subroutine msSet_element_cmplx
!_______________________________________________________________________
!
   subroutine msSet_array_element( data, x, i1, i2 )

      type(mfArray) :: data
      type(mfArray) :: x
      integer, intent(in) :: i1, i2
      !------ API end ------

#ifdef _DEVLP
      integer :: n1, n2
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      call msInitArgs( data )

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         go to 99
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be sparse!" )
         go to 99
      end if

      if( mfIsSparse(data) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'data' cannot be sparse!" )
         go to 99
      end if

      if( mfIsEmpty(data) ) then
         call PrintMessage( "msSet", "E",                               &
                            "to suppress data, use MF_COLON!" )
         go to 99
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( data%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting logical item in an mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( data%shape(1) /= 1 .or. data%shape(2) /= 1 ) then
         call PrintMessage( "msSet", "E",                               &
                            "bad dim. for mfArray data (should be 1,1)" )
         go to 99
      end if

      if( i1 < 1 .or. i2 < 1 ) then
         call PrintMessage( "msSet", "E",                               &
                            "bad value for indexes i1 or i2" )
         go to 99
      end if

      if( i1 > x%shape(1) .or. i2 > x%shape(2) ) then
         if( x%status_restricted ) then
            call PrintMessage( "msSet", "E",                            &
                               "cannot reshape a restricted array" )
            go to 99
         else
            n1 = max(i1,x%shape(1))
            n2 = max(i2,x%shape(2))
            x%shape = [ n1, n2 ]
            if( x%data_type == MF_DT_EMPTY ) then
               if( data%data_type == MF_DT_DBLE ) then
                  call realloc_array( x%double, n1, n2,                 &
                                      fill=mf_out_of_range_filling )
                  x%data_type = MF_DT_DBLE
                  x%double(i1,i2) = data%double(1,1)
               else if( data%data_type == MF_DT_CMPLX ) then
                  call realloc_array( x%cmplx, n1, n2,                  &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                  x%data_type = MF_DT_CMPLX
                  x%cmplx(i1,i2) = data%cmplx(1,1)
               end if
            else if( x%data_type == MF_DT_DBLE ) then
               if( data%data_type == MF_DT_DBLE ) then
                  call realloc_array( x%double, n1, n2,                 &
                                      fill=mf_out_of_range_filling )
                  x%data_type = MF_DT_DBLE
                  x%double(i1,i2) = data%double(1,1)
               else if( data%data_type == MF_DT_CMPLX ) then
                  call realloc_array( x%double, x%cmplx, n1, n2,        &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                  x%data_type = MF_DT_CMPLX
                  x%cmplx(i1,i2) = data%cmplx(1,1)
               end if
            else if( x%data_type == MF_DT_CMPLX ) then
               call realloc_array( x%cmplx, n1, n2,                     &
                                   fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
               x%data_type = MF_DT_CMPLX
               if( data%data_type == MF_DT_DBLE ) then
                  x%cmplx(i1,i2) = data%double(1,1)
               else if( data%data_type == MF_DT_CMPLX ) then
                  x%cmplx(i1,i2) = data%cmplx(1,1)
               end if
            else
               call PrintMessage( "msSet", "E",                         &
                                  "cannot setting one element in a sparse mfArray", &
                                  "when its indexes are out-of-range." )
               go to 99
            end if
         end if
      else ! matrix A keep the same shape
         if( x%data_type == MF_DT_EMPTY ) then
            ! this case should have been detected previously;
            ! here: x%data_type == MF_DT_EMPTY, but with 'shape' /= (0,0)
            write(STDERR,*) "(MUESLI msSet:) internal ERROR: x%data_type = 0"
            mf_message_displayed = .true.
            call muesli_trace( pause="yes" )
            stop
         else if( x%data_type == MF_DT_DBLE ) then
            if( data%data_type == MF_DT_DBLE ) then
               x%data_type = MF_DT_DBLE
               x%double(i1,i2) = data%double(1,1)
            else if( data%data_type == MF_DT_CMPLX ) then
               x%data_type = MF_DT_CMPLX
               allocate( x%cmplx(x%shape(1),x%shape(2)) )

               x%cmplx(:,:) = x%double(:,:)
               x%cmplx(i1,i2) = data%cmplx(1,1)
               deallocate( x%double )

               x%double => null()
            end if
         else if( x%data_type == MF_DT_CMPLX ) then
            x%data_type = MF_DT_CMPLX
            if( data%data_type == MF_DT_DBLE ) then
               x%cmplx(i1,i2) = data%double(1,1)
            else if( data%data_type == MF_DT_CMPLX ) then
               x%cmplx(i1,i2) = data%cmplx(1,1)
            end if
         end if
      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, data%units, status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical dimensions of the two mfArray's", &
                               "are not consistent!" )
            go to 99
         end if
      end if

 99   continue

      call msFreeArgs( data )
      call msAutoRelease( data )

#endif
   end subroutine msSet_array_element
!_______________________________________________________________________
!
   subroutine msSet_element_real8_in_vec( data, x, i )

      real(kind=MF_DOUBLE), intent(in) :: data
      type(mfArray) :: x
      integer, intent(in) :: i
      !------ API end ------

#ifdef _DEVLP
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         return
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray cannot be sparse!" )
         return
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         return
      end if

      if( i < 1 ) then
         call PrintMessage( "msSet", "E",                               &
                            "bad value for index i!" )
         return
      end if

      if( x%shape(1) == 1 ) then
         if( i > x%shape(2) ) then
            if( x%status_restricted ) then
               call PrintMessage( "msSet", "E",                         &
                                  "cannot reshape a restricted array" )
               return
            else
               if( x%data_type == MF_DT_DBLE ) then
                  call realloc_array( x%double, 1, i,                   &
                                      fill=mf_out_of_range_filling )
                  x%double(1,i) = data
               else if( x%data_type == MF_DT_CMPLX ) then
                  call realloc_array( x%cmplx, 1, i,                    &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                  x%cmplx(1,i) = data
               end if
               x%shape = [ 1, i ]
            end if
         else
            if( x%data_type == MF_DT_DBLE ) then
               x%double(1,i) = data
            else if( x%data_type == MF_DT_CMPLX ) then
               x%cmplx(1,i) = data
            end if
         end if
      else if( x%shape(2) == 1 ) then
         if( i > x%shape(1) ) then
            if( x%status_restricted ) then
               call PrintMessage( "msSet", "E",                         &
                                  "cannot reshape a restricted array" )
               return
            else
               if( x%data_type == MF_DT_DBLE ) then
                  call realloc_array( x%double, i, 1,                   &
                                      fill=mf_out_of_range_filling )
                  x%double(i,1) = data
               else if( x%data_type == MF_DT_CMPLX ) then
                  call realloc_array( x%cmplx, i, 1,                    &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                  x%cmplx(i,1) = data
               end if
               x%shape = [ i, 1 ]
            end if
         else
            if( x%data_type == MF_DT_DBLE ) then
               x%double(i,1) = data
            else if( x%data_type == MF_DT_CMPLX ) then
               x%cmplx(i,1) = data
            end if
         end if
      else
         if( x%data_type == MF_DT_EMPTY ) then
            x%data_type = MF_DT_DBLE
            x%shape = [ 1, i ]
            call realloc_array( x%double, 1, i,                         &
                                fill=mf_out_of_range_filling )
            x%double(1,i) = data
         else
            call PrintMessage( "msSet", "E",                            &
                               "x must be a vector!" )
            return
         end if
      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            return
         end if
      end if

#endif
   end subroutine msSet_element_real8_in_vec
!_______________________________________________________________________
!
   subroutine msSet_element_cmplx_in_vec( data, x, i )

      complex(kind=MF_DOUBLE), intent(in) :: data
      type(mfArray) :: x
      integer, intent(in) :: i
      !------ API end ------

#ifdef _DEVLP
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         return
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray cannot be sparse!" )
         return
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         return
      end if

      if( i < 1 ) then
         call PrintMessage( "msSet", "E",                               &
                            "bad value for index i!" )
         return
      end if

      if( x%shape(1) == 1 ) then
         if( i > x%shape(2) ) then
            if( x%status_restricted ) then
               call PrintMessage( "msSet", "E",                         &
                                  "cannot reshape a restricted array" )
               return
            else
               if( x%data_type == MF_DT_DBLE ) then
                  call realloc_array( x%double, x%cmplx, 1, i,          &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
               else if( x%data_type == MF_DT_CMPLX ) then
                  call realloc_array( x%cmplx, 1, i,                    &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
               end if
               x%data_type = MF_DT_CMPLX
               x%shape = [ 1, i ]
               x%cmplx(1,i) = data
            end if
         else
            if( x%data_type == MF_DT_DBLE ) then
               allocate( x%cmplx(1,x%shape(2)) )

               x%cmplx(:,:) = x%double(:,:)
               deallocate( x%double )

               x%double => null()
            end if
            x%data_type = MF_DT_CMPLX
            x%cmplx(1,i) = data
         end if
      else if( x%shape(2) == 1 ) then
         if( i > x%shape(1) ) then
            if( x%status_restricted ) then
               call PrintMessage( "msSet", "E",                         &
                                  "cannot reshape a restricted array" )
               return
            else
               if( x%data_type == MF_DT_DBLE ) then
                  call realloc_array( x%double, x%cmplx, i, 1,          &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
               else if( x%data_type == MF_DT_CMPLX ) then
                  call realloc_array( x%cmplx, i, 1,                    &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
               end if
               x%data_type = MF_DT_CMPLX
               x%shape = [ i, 1 ]
               x%cmplx(i,1) = data
            end if
         else
            if( x%data_type == MF_DT_DBLE ) then
               allocate( x%cmplx(x%shape(1),1) )

               x%cmplx(:,:) = x%double(:,:)
               deallocate( x%double )

               x%double => null()
            end if
            x%data_type = MF_DT_CMPLX
            x%cmplx(i,1) = data
         end if
      else
         if( x%data_type == MF_DT_EMPTY ) then
            x%data_type = MF_DT_CMPLX
            x%shape = [ 1, i ]
            call realloc_array( x%cmplx, 1, i,                          &
                                fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
            x%cmplx(1,i) = data
         else
            call PrintMessage( "msSet", "E",                            &
                               "x must be a vector!" )
            return
         end if
      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            return
         end if
      end if

#endif
   end subroutine msSet_element_cmplx_in_vec
!_______________________________________________________________________
!
   subroutine msSet_array_element_in_vec( data, x, i )

      type(mfArray) :: data
      type(mfArray) :: x
      integer, intent(in) :: i
      !------ API end ------

#ifdef _DEVLP
      type(mfArray) :: tmp
      integer :: ii, k, n2, status

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      call msInitArgs( data )

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         go to 99
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be sparse!" )
         go to 99
      end if

      if( mfIsSparse(data) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'data' cannot be sparse!" )
         go to 99
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( data%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting logical item in an mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( i < 1 ) then
         call PrintMessage( "msSet", "E",                               &
                            "bad value for index i" )
         go to 99
      end if

      if( .not. mfIsEmpty(data) ) then
         if( data%shape(1) /= 1 .or. data%shape(2) /= 1 ) then
            call PrintMessage( "msSet", "E",                            &
                               "bad shape for 'data',",                 &
                               "which must be scalar or empty" )
            go to 99
         end if
      end if

      if( x%shape(1) == 1 ) then ! row vector
         if( mfIsEmpty(data) ) then
            if( i > x%shape(2) ) then
               call PrintMessage( "msSet", "E",                         &
                                  "deleting : index out of range!" )
               go to 99
            end if
            if( x%status_restricted ) then
               call PrintMessage( "msSet", "E",                         &
                                  "cannot reshape a restricted array" )
               go to 99
            end if
            ! suppressing one element in the vector
            ! new size is:
            n2 = x%shape(2) - 1
            if( n2 == 0 ) then
               x = MF_EMPTY
               go to 99
            end if
            tmp = x
            x%shape = [ 1, n2 ]
            if( x%data_type == MF_DT_DBLE .or. x%data_type == MF_DT_BOOL ) then
               deallocate( x%double )

               allocate( x%double(1,n2) )

               ! affectation
               ii = 0
               do k = 1, tmp%shape(2)
                  if( k == i ) cycle
                  ii = ii + 1
                  x%double(1,ii) = tmp%double(1,k)
               end do
            else if( x%data_type == MF_DT_CMPLX ) then
               deallocate( x%cmplx )

               allocate( x%cmplx(1,n2) )

               ! affectation
               ii = 0
               do k = 1, tmp%shape(2)
                  if( k == i ) cycle
                  ii = ii + 1
                  x%cmplx(1,ii) = tmp%cmplx(1,k)
               end do
            end if
            call msSilentRelease(tmp)
         else ! data is not empty
            if( i > x%shape(2) ) then
               if( x%status_restricted ) then
                  call PrintMessage( "msSet", "E",                      &
                                     "cannot reshape a restricted array" )
                  go to 99
               else
                  if( x%data_type == MF_DT_DBLE ) then
                     if( data%data_type == MF_DT_DBLE ) then
                        call realloc_array( x%double, 1, i,             &
                                            fill=mf_out_of_range_filling )
                        x%double(1,i) = data%double(1,1)
                     else if( data%data_type == MF_DT_CMPLX ) then
                        call realloc_array( x%double, x%cmplx, 1, i,    &
                                            fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                        x%data_type = MF_DT_CMPLX
                        x%cmplx(1,i) = data%cmplx(1,1)
                     end if
                  else if( x%data_type == MF_DT_CMPLX ) then
                        call realloc_array( x%cmplx, 1, i,              &
                                            fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                     x%cmplx(1,i) = data%cmplx(1,1)
                  end if
                  x%shape = [ 1, i ]
               end if
            else
               if( x%data_type == MF_DT_DBLE ) then
                  if( data%data_type == MF_DT_DBLE ) then
                     x%double(1,i) = data%double(1,1)
                  else if( data%data_type == MF_DT_CMPLX ) then
                     allocate( x%cmplx(1,size(x%double,2)) )

                     x%cmplx(:,:) = x%double(:,:)
                     deallocate( x%double )

                     x%double => null()
                     x%data_type = MF_DT_CMPLX
                     x%cmplx(1,i) = data%cmplx(1,1)
                  end if
               else if( x%data_type == MF_DT_CMPLX ) then
                  x%cmplx(1,i) = data%cmplx(1,1)
               end if
            end if
         end if
      else if( x%shape(2) == 1 ) then ! column vector
         if( mfIsEmpty(data) ) then
            if( i > x%shape(1) ) then
               call PrintMessage( "msSet", "E",                         &
                                  "deleting : index out of range!" )
               go to 99
            end if
            if( x%status_restricted ) then
               call PrintMessage( "msSet", "E",                         &
                                  "cannot reshape a restricted array" )
               go to 99
            end if
            ! suppressing one element in the vector
            ! new size is:
            n2 = x%shape(1) - 1
            if( n2 == 0 ) then
               x = MF_EMPTY
               go to 99
            end if
            tmp = x
            x%shape = [ n2, 1 ]
            if( x%data_type == MF_DT_DBLE .or. x%data_type == MF_DT_BOOL ) then
               deallocate( x%double )

               allocate( x%double(n2,1) )

               ! affectation
               ii = 0
               do k = 1, tmp%shape(1)
                  if( k == i ) cycle
                  ii = ii + 1
                  x%double(ii,1) = tmp%double(k,1)
               end do
            else if( x%data_type == MF_DT_CMPLX ) then
               deallocate( x%cmplx )

               allocate( x%cmplx(n2,1) )

               ! affectation
               ii = 0
               do k = 1, tmp%shape(1)
                  if( k == i ) cycle
                  ii = ii + 1
                  x%cmplx(ii,1) = tmp%cmplx(k,1)
               end do
            end if
            call msSilentRelease(tmp)
         else ! data is not empty
            if( i > x%shape(1) ) then
               if( x%status_restricted ) then
                  call PrintMessage( "msSet", "E",                      &
                                     "cannot reshape a restricted array" )
                  go to 99
               else
                  if( x%data_type == MF_DT_DBLE ) then
                     if( data%data_type == MF_DT_DBLE ) then
                        call realloc_array( x%double, i, 1,             &
                                            fill=mf_out_of_range_filling )
                        x%double(i,1) = data%double(1,1)
                     else if( data%data_type == MF_DT_CMPLX ) then
                        call realloc_array( x%double, x%cmplx, i, 1,    &
                                            fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                        x%data_type = MF_DT_CMPLX
                        x%cmplx(i,1) = data%cmplx(1,1)
                     end if
                  else if( x%data_type == MF_DT_CMPLX ) then
                        call realloc_array( x%cmplx, i, 1,              &
                                            fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                     x%cmplx(i,1) = data%cmplx(1,1)
                  end if
                  x%shape = [ i, 1 ]
               end if
            else
               if( x%data_type == MF_DT_DBLE ) then
                  if( data%data_type == MF_DT_DBLE ) then
                     x%double(i,1) = data%double(1,1)
                  else if( data%data_type == MF_DT_CMPLX ) then
                     allocate( x%cmplx(size(x%double,1),1) )

                     x%cmplx(:,:) = x%double(:,:)
                     deallocate( x%double )

                     x%double => null()
                     x%data_type = MF_DT_CMPLX
                     x%cmplx(i,1) = data%cmplx(1,1)
                  end if
               else if( x%data_type == MF_DT_CMPLX ) then
                  x%cmplx(i,1) = data%cmplx(1,1)
               end if
            end if
         end if
      else
         if( x%data_type == MF_DT_EMPTY ) then
            if( mfIsEmpty(data) ) then
               call PrintMessage( "msSet", "E",                         &
                                  "x must be non-empty!",               &
                                  "(cannot remove an element from an empty vector)" )
               return
            else
               if( data%data_type == MF_DT_DBLE ) then
                  x%data_type = MF_DT_DBLE
                  x%shape = [ 1, i ]
                  call realloc_array( x%double, 1, i,                   &
                                      fill=mf_out_of_range_filling )
                  x%double(1,i) = data
               else if( data%data_type == MF_DT_CMPLX ) then
                  x%data_type = MF_DT_CMPLX
                  x%shape = [ 1, i ]
                  call realloc_array( x%cmplx, 1, i,                   &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                  x%cmplx(1,i) = data
               end if
            end if
         else
            call PrintMessage( "msSet", "E",                            &
                               "x must be a vector!" )
            return
         end if
      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, data%units, status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical dimensions of the two mfArray's", &
                               "are not consistent!" )
            go to 99
         end if
      end if

 99   continue

      call msFreeArgs( data )
      call msAutoRelease( data )

#endif
   end subroutine msSet_array_element_in_vec
!_______________________________________________________________________
!
   subroutine msSet_spread_real8_in_vec_section( data, x, i )

      real(kind=MF_DOUBLE), intent(in) :: data
      type(mfArray) :: x
      integer, intent(in) :: i(:)
      !------ API end ------

#ifdef _DEVLP
      ! spreading scalar data in vector section
      !
      ! if x is empty, returns a row vector

      integer :: n, dim_out
      integer :: status
      real(kind=MF_DOUBLE), pointer :: vec_real(:)
      complex(kind=MF_DOUBLE), pointer :: vec_cmplx(:)

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         return
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be sparse!" )
         return
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         return
      end if

      if( minval(i) < 1 ) then
         call PrintMessage( "msSet", "E",                               &
                            "bad value for min of i" )
         return
      end if

      if( x%shape(1) == 1 .or. x%data_type == MF_DT_EMPTY ) then ! row vector
         if( maxval(i) > x%shape(2) ) then
            if( x%status_restricted ) then
               call PrintMessage( "msSet", "E",                         &
                                  "cannot reshape a restricted array" )
               return
            else
               n = maxval(i)
               x%shape = [ 1, n ]
               if( x%data_type == MF_DT_EMPTY ) then
                  call realloc_array( x%double, 1, n,                   &
                                      fill=mf_out_of_range_filling )
                  x%data_type = MF_DT_DBLE
                  x%double(1,i) = data
               else if( x%data_type == MF_DT_DBLE ) then
                  call realloc_array( x%double, 1, n,                   &
                                      fill=mf_out_of_range_filling )
                  x%data_type = MF_DT_DBLE
                  x%double(1,i) = data
               else if( x%data_type == MF_DT_CMPLX ) then
                  call realloc_array( x%cmplx, 1, n,                    &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                  x%data_type = MF_DT_CMPLX
                  x%cmplx(1,i) = data
               end if
            end if
         else
            if( x%data_type == MF_DT_EMPTY ) then
               ! this case should have been detected previously;
               ! here: x%data_type == MF_DT_EMPTY, but with 'shape' /= (0,0)
               write(STDERR,*) "(MUESLI msSet:) internal ERROR: x%data_type = 0"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            else if( x%data_type == MF_DT_DBLE ) then
               x%double(1,i) = data
            else if( x%data_type == MF_DT_CMPLX ) then
               x%cmplx(1,i) = data
            end if
         end if
      else if( x%shape(2) == 1 ) then ! col vector
         if( maxval(i) > x%shape(1) ) then
            if( x%status_restricted ) then
               call PrintMessage( "msSet", "E",                         &
                                  "cannot reshape a restricted array" )
               return
            else
               n = maxval(i)
               x%shape = [ n, 1 ]
               if( x%data_type == MF_DT_DBLE ) then
                  call realloc_array( x%double, n, 1,                   &
                                      fill=mf_out_of_range_filling )
                  x%data_type = MF_DT_DBLE
                  x%double(i,1) = data
               else if( x%data_type == MF_DT_CMPLX ) then
                  call realloc_array( x%cmplx, n, 1,                    &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                  x%data_type = MF_DT_CMPLX
                  x%cmplx(i,1) = data
               end if
            end if
         else
            if( x%data_type == MF_DT_DBLE ) then
               x%double(i,1) = data
            else if( x%data_type == MF_DT_CMPLX ) then
               x%cmplx(i,1) = data
            end if
         end if
      else ! 2D array
         ! note: i(:) is already allocated et contains indices of a%double
         if( x%data_type == MF_DT_DBLE ) then
            dim_out = size(x%double)
            if( maxval(i) > dim_out ) then
               call PrintMessage( "msSet", "E",                         &
                                  "out-of-range indices",               &
                                  "(hint: use (i,j) indices if you want to extend the array)" )
               return
            end if
            vec_real => rank_2_to_1_real8( x%double, dim_out )
            vec_real(i) = data
            vec_real => null()
         else if( x%data_type == MF_DT_CMPLX ) then
            dim_out = size(x%cmplx)
            if( maxval(i) > dim_out ) then
               call PrintMessage( "msSet", "E",                         &
                                  "out-of-range indices",               &
                                  "(hint: use (i,j) indices if you want to extend the array)" )
               return
            end if
            vec_cmplx => rank_2_to_1_cmplx( x%cmplx, dim_out )
            vec_cmplx(i) = data
         end if
      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            return
         end if
      end if

#endif
   end subroutine msSet_spread_real8_in_vec_section
!_______________________________________________________________________
!
   subroutine msSet_spread_cmplx_in_vec_section( data, x, i )

      complex(kind=MF_DOUBLE), intent(in) :: data
      type(mfArray) :: x
      integer, intent(in) :: i(:)
      !------ API end ------

#ifdef _DEVLP
      ! spreading scalar data in vector section
      !
      ! if x is empty, returns a row vector

      integer :: n, dim_out
      integer :: status
      complex(kind=MF_DOUBLE), pointer :: vec_cmplx(:)

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         return
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be sparse!" )
         return
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         return
      end if

      if( minval(i) < 1 ) then
         call PrintMessage( "msSet", "E",                               &
                            "bad value for min of i" )
         return
      end if

      if( x%shape(1) == 1 .or. x%data_type == MF_DT_EMPTY ) then ! row vector
         if( maxval(i) > x%shape(2) ) then
            if( x%status_restricted ) then
               call PrintMessage( "msSet", "E",                         &
                                  "cannot reshape a restricted array" )
               return
            else
               n = maxval(i)
               x%shape = [ 1, n ]
               if( x%data_type == MF_DT_EMPTY ) then
                  call realloc_array( x%cmplx, 1, n,                    &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
               else if( x%data_type == MF_DT_DBLE ) then
                  call realloc_array( x%double, x%cmplx, 1, n,          &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
               else if( x%data_type == MF_DT_CMPLX ) then
                  call realloc_array( x%cmplx, 1, n,                    &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
               end if
               x%data_type = MF_DT_CMPLX
               x%cmplx(1,i) = data
            end if
         else
            if( x%data_type == MF_DT_EMPTY ) then
               ! this case should have been detected previously;
               ! here: x%data_type == MF_DT_EMPTY, but with 'shape' /= (0,0)
               write(STDERR,*) "(MUESLI msSet:) internal ERROR: x%data_type = 0"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            else if( x%data_type == MF_DT_DBLE ) then
               x%data_type = MF_DT_CMPLX
               allocate( x%cmplx(1,x%shape(2)) )

               x%cmplx(:,:) = x%double(:,:)
               deallocate( x%double )

               x%double => null()
               x%cmplx(1,i) = data
            else if( x%data_type == MF_DT_CMPLX ) then
               x%cmplx(1,i) = data
            end if
         end if
      else if( x%shape(2) == 1 ) then ! col vector
         if( maxval(i) > x%shape(1) ) then
            if( x%status_restricted ) then
               call PrintMessage( "msSet", "E",                         &
                                  "cannot reshape a restricted array" )
               return
            else
               n = maxval(i)
               x%shape = [ n, 1 ]
               if( x%data_type == MF_DT_DBLE ) then
                  call realloc_array( x%double, x%cmplx, n, 1,          &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
               else if( x%data_type == MF_DT_CMPLX ) then
                  call realloc_array( x%cmplx, n, 1,                    &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
               end if
               x%data_type = MF_DT_CMPLX
               x%cmplx(i,1) = data
            end if
         else
            if( x%data_type == MF_DT_DBLE ) then
               x%data_type = MF_DT_CMPLX
               allocate( x%cmplx(x%shape(1),1) )

               x%cmplx(:,:) = x%double(:,:)
               deallocate( x%double )

               x%double => null()
               x%cmplx(i,1) = data
            else if( x%data_type == MF_DT_CMPLX ) then
               x%cmplx(i,1) = data
            end if
         end if
      else ! 2D array
         ! note: i(:) is already allocated et contains indices of a%double
         if( x%data_type == MF_DT_DBLE ) then
            dim_out = size(x%double)
            if( maxval(i) > dim_out ) then
               call PrintMessage( "msSet", "E",                         &
                                  "out-of-range indices",               &
                                  "(hint: use (i,j) indices if you want to extend the array)" )
               return
            end if
            x%data_type = MF_DT_CMPLX
            allocate( x%cmplx(x%shape(1),x%shape(2)) )
            x%cmplx(:,:) = x%double(:,:)
            deallocate( x%double )
            vec_cmplx => rank_2_to_1_cmplx( x%cmplx, dim_out )
            vec_cmplx(i) = data
            vec_cmplx => null()
         else if( x%data_type == MF_DT_CMPLX ) then
            dim_out = size(x%cmplx)
            if( maxval(i) > dim_out ) then
               call PrintMessage( "msSet", "E",                         &
                                  "out-of-range indices",               &
                                  "(hint: use (i,j) indices if you want to extend the array)" )
               return
            end if
            vec_cmplx => rank_2_to_1_cmplx( x%cmplx, dim_out )
            vec_cmplx(i) = data
            vec_cmplx => null()
         end if
      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            return
         end if
      end if

#endif
   end subroutine msSet_spread_cmplx_in_vec_section
!_______________________________________________________________________
!
   subroutine msSet_spread_real8_in_vec_sect2( data, x, a )

      real(kind=MF_DOUBLE), intent(in) :: data
      type(mfArray) :: x
      type(mfArray) :: a
      !------ API end ------

#ifdef _DEVLP
      ! spreading scalar data in vector section
      !
      ! if x is empty, returns a row vector, in any case

      ! extended to the case where 'a' is an EndIndex (which is
      ! either the MF_END parameter itself, or an expression
      ! involving integers and MF_END, like 'MF_END-1').

      integer :: n, dim_out
      integer :: status
      integer, allocatable :: i(:)
      real(kind=MF_DOUBLE), pointer :: vec_real(:)
      complex(kind=MF_DOUBLE), pointer :: vec_cmplx(:)

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      call msInitArgs( a )

      if( A%data_type == MF_DT_EMPTY .and. all( A%shape == 0 ) ) then
         call PrintMessage( "msSet", "I",                               &
                            "mfArray didn't change because index array is empty." )
         go to 99
      end if

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         go to 99
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be sparse!" )
         go to 99
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( a%shape(1) /= 1 .and. a%shape(2) /= 1 .and.                   &
          .not. isEndIndex(a) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray indexes 'a' must be of rank one!" )
         go to 99
      end if

      if( isEndIndex(a) ) then

         allocate( i(1) )

         if( x%shape(1) == 1 .or. x%data_type == MF_DT_EMPTY ) then ! row vector
            n = x%shape(2)
         else if( x%shape(2) == 1 ) then ! col vector
            n = x%shape(1)
         end if
         i(1) = n + a%crc
         if( i(1) < 1 .or. n < i(1) ) then
            call PrintMessage( "msSet", "E",                            &
                               "End-index 'a' is out of range!" )
            go to 99
         end if

      else ! usual case

         if( .not. mfIsReal(a) ) then
            call PrintMessage( "msSet", "E",                            &
                               "mfArray 'a' must be real for containing indexes!" )
            go to 99
         end if

         if( minval(a%double) < 1 ) then
            call PrintMessage( "msSet", "E",                            &
                               "bad value for min of 'a'" )
            go to 99
         end if

         allocate( i(size(a%double)) )

         i = a
         n = maxval(i)

      end if

      if( x%shape(1) == 1 .or. x%data_type == MF_DT_EMPTY ) then ! row vector
         if( maxval(i) > x%shape(2) ) then
            if( x%status_restricted ) then
               call PrintMessage( "msSet", "E",                         &
                                  "cannot reshape a restricted array" )
               go to 99
            else
               n = maxval(i)
               x%shape = [ 1, n ]
               if( x%data_type == MF_DT_EMPTY ) then
                  call realloc_array( x%double, 1, n,                   &
                                      fill=mf_out_of_range_filling )
                  x%data_type = MF_DT_DBLE
                  x%double(1,i) = data
               else if( x%data_type == MF_DT_DBLE ) then
                  call realloc_array( x%double, 1, n,                   &
                                      fill=mf_out_of_range_filling )
                  x%data_type = MF_DT_DBLE
                  x%double(1,i) = data
               else if( x%data_type == MF_DT_CMPLX ) then
                  call realloc_array( x%cmplx, 1, n,                    &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                  x%data_type = MF_DT_CMPLX
                  x%cmplx(1,i) = data
               end if
            end if
         else
            if( x%data_type == MF_DT_EMPTY ) then
               ! this case should have been detected previously;
               ! here: x%data_type == MF_DT_EMPTY, but with 'shape' /= (0,0)
               write(STDERR,*) "(MUESLI msSet:) internal ERROR: x%data_type = 0"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            else if( x%data_type == MF_DT_DBLE ) then
               x%double(1,i) = data
            else if( x%data_type == MF_DT_CMPLX ) then
               x%cmplx(1,i) = data
            end if
         end if
      else if( x%shape(2) == 1 ) then ! col vector
         if( maxval(i) > x%shape(1) ) then
            if( x%status_restricted ) then
               call PrintMessage( "msSet", "E",                         &
                                  "cannot reshape a restricted array" )
               go to 99
            else
               n = maxval(i)
               x%shape = [ n, 1 ]
               if( x%data_type == MF_DT_DBLE ) then
                  call realloc_array( x%double, n, 1,                   &
                                      fill=mf_out_of_range_filling )
                  x%data_type = MF_DT_DBLE
                  x%double(i,1) = data
               else if( x%data_type == MF_DT_CMPLX ) then
                  call realloc_array( x%cmplx, n, 1,                    &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                  x%data_type = MF_DT_CMPLX
                  x%cmplx(i,1) = data
               end if
            end if
         else
            if( x%data_type == MF_DT_DBLE ) then
               x%double(i,1) = data
            else if( x%data_type == MF_DT_CMPLX ) then
               x%cmplx(i,1) = data
            end if
         end if
      else ! 2D array
         ! note: i(:) is already allocated et contains indices of a%double
         if( x%data_type == MF_DT_DBLE ) then
            dim_out = size(x%double)
            if( n > dim_out ) then
               call PrintMessage( "msSet", "E",                         &
                                  "out-of-range indices",               &
                                  "(hint: use (i,j) indices if you want to extend the array)" )
               go to 99
            end if
            vec_real => rank_2_to_1_real8( x%double, dim_out )
            vec_real(i) = data
            vec_real => null()
         else if( x%data_type == MF_DT_CMPLX ) then
            dim_out = size(x%cmplx)
            if( n > dim_out ) then
               call PrintMessage( "msSet", "E",                         &
                                  "out-of-range indices",               &
                                  "(hint: use (i,j) indices if you want to extend the array)" )
               go to 99
            end if
            vec_cmplx => rank_2_to_1_cmplx( x%cmplx, dim_out )
            vec_cmplx(i) = data
         end if
      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            go to 99
         end if
      end if

 99   continue

      call msFreeArgs( a )
      call msAutoRelease( a )

#endif
   end subroutine msSet_spread_real8_in_vec_sect2
!_______________________________________________________________________
!
   subroutine msSet_spread_cmplx_in_vec_sect2( data, x, a )

      complex(kind=MF_DOUBLE), intent(in) :: data
      type(mfArray) :: x
      type(mfArray) :: a
      !------ API end ------

#ifdef _DEVLP
      ! spreading scalar data in vector section
      !
      ! if x is empty, returns a row vector, in any case

      ! extended to the case where 'a' is an EndIndex (which is
      ! either the MF_END parameter itself, or an expression
      ! involving integers and MF_END, like 'MF_END-1').

      integer :: n, dim_out
      integer :: status
      integer, allocatable :: i(:)
      complex(kind=MF_DOUBLE), pointer :: vec_cmplx(:)

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      call msInitArgs( a )

      if( A%data_type == MF_DT_EMPTY .and. all( A%shape == 0 ) ) then
         call PrintMessage( "msSet", "I",                               &
                            "mfArray didn't change because index array is empty." )
         go to 99
      end if

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         go to 99
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be sparse!" )
         go to 99
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( a%shape(1) /= 1 .and. a%shape(2) /= 1 .and.                   &
          .not. isEndIndex(a) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray indexes 'a' must be of rank one!" )
         go to 99
      end if

      if( isEndIndex(a) ) then

         allocate( i(1) )

         if( x%shape(1) == 1 .or. x%data_type == MF_DT_EMPTY ) then ! row vector
            n = x%shape(2)
         else if( x%shape(2) == 1 ) then ! col vector
            n = x%shape(1)
         end if
         i(1) = n + a%crc
         if( i(1) < 1 .or.  n < i(1) ) then
            call PrintMessage( "msSet", "E",                            &
                               "End-index 'a' is out of range!" )
            go to 99
         end if

      else ! usual case

         if( .not. mfIsReal(a) ) then
            call PrintMessage( "msSet", "E",                            &
                               "mfArray 'a' must be real for containing indexes!" )
            go to 99
         end if

         if( minval(a%double) < 1 ) then
            call PrintMessage( "msSet", "E",                            &
                               "bad value for min of a" )
            go to 99
         end if

         allocate( i(size(a%double)) )

         i = a
         n = maxval(i)

      end if

      if( x%shape(1) == 1 .or. x%data_type == MF_DT_EMPTY ) then ! row vector
         if( maxval(i) > x%shape(2) ) then
            if( x%status_restricted ) then
               call PrintMessage( "msSet", "E",                         &
                                  "cannot reshape a restricted array" )
               go to 99
            else
               n = maxval(i)
               x%shape = [ 1, n ]
               if( x%data_type == MF_DT_EMPTY ) then
                  call realloc_array( x%cmplx, 1, n,                    &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
               else if( x%data_type == MF_DT_DBLE ) then
                  call realloc_array( x%double, x%cmplx, 1, n,          &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
               else if( x%data_type == MF_DT_CMPLX ) then
                  call realloc_array( x%cmplx, 1, n,                    &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
               end if
               x%data_type = MF_DT_CMPLX
               x%cmplx(1,i) = data
            end if
         else
            if( x%data_type == MF_DT_EMPTY ) then
               ! this case should have been detected previously;
               ! here: x%data_type == MF_DT_EMPTY, but with 'shape' /= (0,0)
               write(STDERR,*) "(MUESLI msSet:) internal ERROR: x%data_type = 0"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               stop
            else if( x%data_type == MF_DT_DBLE ) then
               x%data_type = MF_DT_CMPLX
               allocate( x%cmplx(1,x%shape(2)) )

               x%cmplx(:,:) = x%double(:,:)
               deallocate( x%double )

               x%double => null()
               x%cmplx(1,i) = data
            else if( x%data_type == MF_DT_CMPLX ) then
               x%cmplx(1,i) = data
            end if
         end if
      else if( x%shape(2) == 1 ) then ! col vector
         if( maxval(i) > x%shape(1) ) then
            if( x%status_restricted ) then
               call PrintMessage( "msSet", "E",                         &
                                  "cannot reshape a restricted array" )
               go to 99
            else
               n = maxval(i)
               x%shape = [ n, 1 ]
               if( x%data_type == MF_DT_DBLE ) then
                  call realloc_array( x%double, x%cmplx, n, 1,          &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
               else if( x%data_type == MF_DT_CMPLX ) then
                  call realloc_array( x%cmplx, n, 1,                    &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
               end if
               x%data_type = MF_DT_CMPLX
               x%cmplx(i,1) = data
            end if
         else
            if( x%data_type == MF_DT_DBLE ) then
               x%data_type = MF_DT_CMPLX
               allocate( x%cmplx(x%shape(1),1) )

               x%cmplx(:,:) = x%double(:,:)
               deallocate( x%double )

               x%double => null()
               x%cmplx(i,1) = data
            else if( x%data_type == MF_DT_CMPLX ) then
               x%cmplx(i,1) = data
            end if
         end if
      else ! 2D array
         ! note: i(:) is already allocated et contains indices of a%double
         if( x%data_type == MF_DT_DBLE ) then
            dim_out = size(x%double)
            if( n > dim_out ) then
               call PrintMessage( "msSet", "E",                         &
                                  "out-of-range indices",               &
                                  "(hint: use (i,j) indices if you want to extend the array)" )
               go to 99
            end if
            x%data_type = MF_DT_CMPLX
            allocate( x%cmplx(x%shape(1),x%shape(2)) )
            x%cmplx(:,:) = x%double(:,:)
            deallocate( x%double )
            vec_cmplx => rank_2_to_1_cmplx( x%cmplx, dim_out )
            vec_cmplx(i) = data
         else if( x%data_type == MF_DT_CMPLX ) then
            dim_out = size(x%cmplx)
            if( n > dim_out ) then
               call PrintMessage( "msSet", "E",                         &
                                  "out-of-range indices",               &
                                  "(hint: use (i,j) indices if you want to extend the array)" )
               go to 99
            end if
            vec_cmplx => rank_2_to_1_cmplx( x%cmplx, dim_out )
            vec_cmplx(i) = data
         end if
      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            go to 99
         end if
      end if

 99   continue

      call msFreeArgs( a )
      call msAutoRelease( a )

#endif
   end subroutine msSet_spread_cmplx_in_vec_sect2
!_______________________________________________________________________
!
   subroutine msSet_spread_real8_in_vec_vseq( data, x, seq )

      real(kind=MF_DOUBLE), intent(in) :: data
      type(mfArray) :: x
      type(seq_def) :: seq
      !------ API end ------

#ifdef _DEVLP
      ! spreading scalar data in vector section, described by a
      ! vector sequence
      !
      ! if x is empty, returns a row vector

      integer, pointer :: i(:) => null()
      integer :: n, nrow, ncol
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         return
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be sparse!" )
         return
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         return
      end if

      nrow = x%shape(1)
      ncol = x%shape(2)

      if( x%data_type == MF_DT_EMPTY ) then ! empty vector
         if( seq%start_1 <= 0 .or. seq%end_1 <= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "cannot use an end-index with an empty mfArray" )
            return
         end if
         call build_int_seq( i, seq, "msSet" )
         if( minval(i) < 1 ) then
            call PrintMessage( "msSet", "E",                            &
                               "bad value for min of i" )
            go to 99
         end if
         n = maxval(i)
         x%shape = [ 1, n ]
         allocate( x%double(1,n) )

         x%data_type = MF_DT_DBLE
         x%double(1,:) = mf_out_of_range_filling
         x%double(1,i) = data
      else if( nrow == 1 ) then ! row vector
         if( seq%start_1_EndIndex ) then
            seq%start_1 = ncol + seq%start_1
         end if
         if( seq%end_1_EndIndex ) then
            seq%end_1 = ncol + seq%end_1
         end if
         if( seq%start_2_EndIndex ) then
            seq%start_2 = ncol + seq%start_2
         end if
         if( seq%end_2_EndIndex ) then
            seq%end_2 = ncol + seq%end_2
         end if
         if( seq%but_EndIndex ) then
            seq%but = ncol + seq%but
         end if
         call build_int_seq( i, seq, "msSet" )
         if( minval(i) < 1 ) then
            call PrintMessage( "msSet", "E",                            &
                               "bad value for min of i" )
            go to 99
         end if
         if( maxval(i) > ncol ) then
            if( x%status_restricted ) then
               call PrintMessage( "msSet", "E",                         &
                                  "cannot reshape a restricted array" )
               go to 99
            else
               n = maxval(i)
               x%shape = [ 1, n ]
               if( x%data_type == MF_DT_DBLE ) then
                  call realloc_array( x%double, 1, n,                   &
                                      fill=mf_out_of_range_filling )
                  x%data_type = MF_DT_DBLE
                  x%double(1,i) = data
               else if( x%data_type == MF_DT_CMPLX ) then
                  call realloc_array( x%cmplx, 1, n,                    &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                  x%data_type = MF_DT_CMPLX
                  x%cmplx(1,i) = data
               end if
            end if
         else
            if( x%data_type == MF_DT_DBLE ) then
               x%double(1,i) = data
            else if( x%data_type == MF_DT_CMPLX ) then
               x%cmplx(1,i) = data
            end if
         end if
      else if( ncol == 1 ) then ! col vector
         if( seq%start_1_EndIndex ) then
            seq%start_1 = nrow + seq%start_1
         end if
         if( seq%end_1_EndIndex ) then
            seq%end_1 = nrow + seq%end_1
         end if
         if( seq%start_2_EndIndex ) then
            seq%start_2 = nrow + seq%start_2
         end if
         if( seq%end_2_EndIndex ) then
            seq%end_2 = nrow + seq%end_2
         end if
         if( seq%but_EndIndex ) then
            seq%but = nrow + seq%but
         end if
         call build_int_seq( i, seq, "msSet" )
         if( minval(i) < 1 ) then
            call PrintMessage( "msSet", "E",                            &
                               "bad value for min of i" )
            go to 99
         end if
         if( maxval(i) > x%shape(1) ) then
            if( x%status_restricted ) then
               call PrintMessage( "msSet", "E",                         &
                                  "cannot reshape a restricted array" )
               go to 99
            else
               n = maxval(i)
               x%shape = [ n, 1 ]
               if( x%data_type == MF_DT_DBLE ) then
                  call realloc_array( x%double, n, 1,                   &
                                      fill=mf_out_of_range_filling )
                  x%data_type = MF_DT_DBLE
                  x%double(i,1) = data
               else if( x%data_type == MF_DT_CMPLX ) then
                  call realloc_array( x%cmplx, n, 1,                    &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                  x%data_type = MF_DT_CMPLX
                  x%cmplx(i,1) = data
               end if
            end if
         else
            if( x%data_type == MF_DT_DBLE ) then
               x%double(i,1) = data
            else if( x%data_type == MF_DT_CMPLX ) then
               x%cmplx(i,1) = data
            end if
         end if
      else
         call PrintMessage( "msSet", "E",                               &
                            "x must be a vector (eventually empty)!" )
         return
      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            go to 99
         end if
      end if

 99   continue

      if( associated(i) ) then
#ifndef _TRACE_MEM_ALLOC
         deallocate( i )
#else
         call mf_deallocate( array=i,                                   &
                             file="Set.inc", line="???",                &
                             symb="i", unit="msSet_spread_real8_in_vec_vseq" )
#endif
      end if

#endif
   end subroutine msSet_spread_real8_in_vec_vseq
!_______________________________________________________________________
!
   subroutine msSet_array_in_vec_vseq( data, x, seq )

      type(mfArray) :: data
      type(mfArray) :: x
      type(seq_def) :: seq
      !------ API end ------

#ifdef _DEVLP
      ! copy mfArray data in a vector section, described by a
      ! vector sequence
      !
      ! if x is empty, returns a row vector or a column vector,
      ! according the shape of data

      integer, pointer :: i(:) => null()
      integer :: n, nrow, ncol
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      call msInitArgs( data )

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         go to 99
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be sparse!" )
         go to 99
      end if

      if( mfIsSparse(data) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'data' cannot be sparse!" )
         go to 99
      end if

      if( mfIsEmpty(data) ) then
         call PrintMessage( "msSet", "E",                               &
                            "to suppress data, use MF_COLON!" )
         go to 99
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( data%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting logical item in an mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      nrow = x%shape(1)
      ncol = x%shape(2)

      if( nrow == 1 ) then ! row vector
         ! creating the integer sequence
         if( seq%start_1_EndIndex ) then
            seq%start_1 = ncol + seq%start_1
         end if
         if( seq%end_1_EndIndex ) then
            seq%end_1 = ncol + seq%end_1
         end if
         if( seq%start_2_EndIndex ) then
            seq%start_2 = ncol + seq%start_2
         end if
         if( seq%end_2_EndIndex ) then
            seq%end_2 = ncol + seq%end_2
         end if
         if( seq%but_EndIndex ) then
            seq%but = ncol + seq%but
         end if
         call build_int_seq( i, seq, "msSet" )
         if( minval(i) < 1 ) then
            call PrintMessage( "msSet", "E",                            &
                               "bad value for min of i" )
            go to 99
         end if
         ! data must be also a row vector with appropriate size
         if( data%shape(1) /= 1 .or. data%shape(2) /= size(i) ) then
            call PrintMessage( "msSet", "E",                            &
                               "bad value for shape/size of sequence w.r.t. those of 'data'" )
            go to 99
         end if
         if( maxval(i) > ncol ) then
            if( x%status_restricted ) then
               call PrintMessage( "msSet", "E",                         &
                                  "cannot reshape a restricted array" )
               go to 99
            else
               n = maxval(i)
               x%shape = [ 1, n ]
               if( x%data_type == MF_DT_DBLE ) then
                  if( data%data_type == MF_DT_DBLE ) then
                     call realloc_array( x%double, 1, n,                &
                                         fill=mf_out_of_range_filling )
                     x%double(1,i) = data%double(1,:)
                  else if( data%data_type == MF_DT_CMPLX ) then
                     call realloc_array( x%double, x%cmplx, 1, n,       &
                                         fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                     x%data_type = MF_DT_CMPLX
                     x%cmplx(1,i) = data%cmplx(1,:)
                  end if
               else if( x%data_type == MF_DT_CMPLX ) then
                  call realloc_array( x%cmplx, 1, n,                    &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                  if( data%data_type == MF_DT_DBLE ) then
                     x%cmplx(1,i) = data%double(1,:)
                  else if( data%data_type == MF_DT_CMPLX ) then
                     x%cmplx(1,i) = data%cmplx(1,:)
                  end if
               end if
            end if
         else
            if( x%data_type == MF_DT_DBLE ) then
               if( data%data_type == MF_DT_DBLE ) then
                  x%double(1,i) = data%double(1,:)
               else if( data%data_type == MF_DT_CMPLX ) then
                  x%data_type = MF_DT_CMPLX
                  allocate( x%cmplx(nrow,ncol) )

                  x%cmplx(:,:) = x%double(:,:)
                  x%cmplx(1,i) = data%cmplx(1,:)
                  deallocate( x%double )

                  x%double => null()
               end if
            else if( x%data_type == MF_DT_CMPLX ) then
               if( data%data_type == MF_DT_DBLE ) then
                  x%cmplx(1,i) = data%double(1,:)
               else if( data%data_type == MF_DT_CMPLX ) then
                  x%cmplx(1,i) = data%cmplx(1,:)
               end if
            end if
         end if
      else if( ncol == 1 ) then ! col vector
         ! creating the integer sequence
         if( seq%start_1_EndIndex ) then
            seq%start_1 = nrow + seq%start_1
         end if
         if( seq%end_1_EndIndex ) then
            seq%end_1 = nrow + seq%end_1
         end if
         if( seq%start_2_EndIndex ) then
            seq%start_2 = nrow + seq%start_2
         end if
         if( seq%end_2_EndIndex ) then
            seq%end_2 = nrow + seq%end_2
         end if
         if( seq%but_EndIndex ) then
            seq%but = nrow + seq%but
         end if
         call build_int_seq( i, seq, "msSet" )
         if( minval(i) < 1 ) then
            call PrintMessage( "msSet", "E",                            &
                               "bad value for min of i" )
            go to 99
         end if
         ! data must be also a col vector with appropriate size
         if( data%shape(1) /= size(i) .or. data%shape(2) /= 1 ) then
            call PrintMessage( "msSet", "E",                            &
                               "bad value for size of sequence w.r.t. those of 'data'" )
            go to 99
         end if
         if( maxval(i) > nrow ) then
            if( x%status_restricted ) then
               call PrintMessage( "msSet", "E",                         &
                                  "cannot reshape a restricted array" )
               go to 99
            else
               n = maxval(i)
               x%shape = [ n, 1 ]
               if( x%data_type == MF_DT_DBLE ) then
                  if( data%data_type == MF_DT_DBLE ) then
                     call realloc_array( x%double, n, 1,                &
                                         fill=mf_out_of_range_filling )
                     x%double(i,1) = data%double(:,1)
                  else if( data%data_type == MF_DT_CMPLX ) then
                     call realloc_array( x%cmplx, n, 1,                 &
                                         fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                     x%data_type = MF_DT_CMPLX
                     x%cmplx(i,1) = data%cmplx(:,1)
                  end if
               else if( x%data_type == MF_DT_CMPLX ) then
                  call realloc_array( x%cmplx, n, 1,                    &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                  x%data_type = MF_DT_CMPLX
                  x%cmplx(i,1) = data%cmplx(:,1)
               end if
            end if
         else
            if( x%data_type == MF_DT_DBLE ) then
               if( data%data_type == MF_DT_DBLE ) then
                  x%double(i,1) = data%double(:,1)
               else if( data%data_type == MF_DT_CMPLX ) then
                  x%data_type = MF_DT_CMPLX
                  allocate( x%cmplx(nrow,ncol) )

                  x%cmplx(:,:) = x%double(:,:)
                  x%cmplx(i,1) = data%cmplx(:,1)
                  deallocate( x%double )

                  x%double => null()
               end if
            else if( x%data_type == MF_DT_CMPLX ) then
               if( data%data_type == MF_DT_DBLE ) then
                  x%cmplx(i,1) = data%double(:,1)
               else if( data%data_type == MF_DT_CMPLX ) then
                  x%cmplx(i,1) = data%cmplx(:,1)
               end if
            end if
         end if
      else
         if( x%data_type == MF_DT_EMPTY ) then
            if( mfIsEmpty(data) ) then
               call PrintMessage( "msSet", "E",                         &
                                  "x must be non-empty!",              &
                                  "(cannot remove elements from an empty vector)" )
               return
            else
               ! creating the integer sequence
               if( seq%start_1_EndIndex .or. seq%end_1_EndIndex .or.    &
                  seq%start_2_EndIndex .or. seq%end_2_EndIndex .or.     &
                  seq%but_EndIndex ) then
                  seq%but = ncol + seq%but
                  call PrintMessage( "msSet", "E",                      &
                                     "cannot use MF_END with an empty vector!" )
                  return
               end if
               call build_int_seq( i, seq, "msSet" )
               n = maxval(i)
               if( data%data_type == MF_DT_DBLE ) then
                  x%data_type = MF_DT_DBLE
                  if( data%shape(1) == 1 ) then ! data is a row vector
                     x%shape = [ 1, n ]
                     call realloc_array( x%double, 1, n,                &
                                         fill=mf_out_of_range_filling )
                     x%double(1,i) = data%double(1,:)
                  else ! data is a column vector
                     x%shape = [ n, 1 ]
                     call realloc_array( x%double, n, 1,                &
                                         fill=mf_out_of_range_filling )
                     x%double(i,1) = data%double(:,1)
                  end if
               else if( data%data_type == MF_DT_CMPLX ) then
                  x%data_type = MF_DT_CMPLX
                  if( data%shape(1) == 1 ) then ! data is a row vector
                     x%shape = [ 1, n ]
                     call realloc_array( x%cmplx, 1, n,                 &
                                         fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                     x%cmplx(1,i) = data%cmplx(1,:)
                  else ! data is a column vector
                     x%shape = [ n, 1 ]
                     call realloc_array( x%cmplx, n, 1,                 &
                                         fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                     x%cmplx(i,1) = data%cmplx(:, 1)
                  end if
               end if
            end if
         else
            call PrintMessage( "msSet", "E",                            &
                               "x must be a vector!" )
            return
         end if
      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            go to 99
         end if
      end if

 99   continue

      call msFreeArgs( data )
      call msAutoRelease( data )

      if( associated(i) ) then
#ifndef _TRACE_MEM_ALLOC
         deallocate( i )
#else
         call mf_deallocate( array=i,                                   &
                             file="Set.inc", line="???",                &
                             symb="i", unit="msSet_array_in_vec_vseq" )
#endif
      end if

#endif
   end subroutine msSet_array_in_vec_vseq
!_______________________________________________________________________
!
   subroutine msSet_array_in_vec_section( data, x, i )

      type(mfArray) :: data
      type(mfArray) :: x
      integer, intent(in) :: i(:)
      !------ API end ------

#ifdef _DEVLP
      ! if x is empty, returns a row vector or a column vector,
      ! according the shape of data

      integer :: n, dim_out
      integer :: status
      real(kind=MF_DOUBLE), pointer :: vec_real(:)
      complex(kind=MF_DOUBLE), pointer :: vec_cmplx(:)

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      call msInitArgs( data )

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         go to 99
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be sparse!" )
         go to 99
      end if

      if( mfIsSparse(data) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'data' cannot be sparse!" )
         go to 99
      end if

      if( mfIsEmpty(data) ) then
         call PrintMessage( "msSet", "E",                               &
                            "to suppress data, use MF_COLON!" )
         go to 99
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( data%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting logical item in an mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( minval(i) < 1 ) then
         call PrintMessage( "msSet", "E",                               &
                            "bad value for min of i" )
         go to 99
      end if

      if( x%shape(1) == 1 ) then ! row vector
         ! data must be also a row vector with appropriate size
         if( data%shape(1) /= 1 .or. data%shape(2) /= size(i) ) then
            call PrintMessage( "msSet", "E",                            &
                               "bad value for size of 'i' w.r.t. those of 'data'" )
            go to 99
         end if
         if( maxval(i) > x%shape(2) ) then
            if( x%status_restricted ) then
               call PrintMessage( "msSet", "E",                         &
                                  "cannot reshape a restricted array" )
               go to 99
            else
               n = maxval(i)
               x%shape = [ 1, n ]
               if( x%data_type == MF_DT_DBLE ) then
                  if( data%data_type == MF_DT_DBLE ) then
                     call realloc_array( x%double, 1, n,                &
                                         fill=mf_out_of_range_filling )
                     x%double(1,i) = data%double(1,:)
                  else if( data%data_type == MF_DT_CMPLX ) then
                     call realloc_array( x%double, x%cmplx, 1, n,       &
                                         fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                     x%data_type = MF_DT_CMPLX
                     x%cmplx(1,i) = data%cmplx(1,:)
                  end if
               else if( x%data_type == MF_DT_CMPLX ) then
                  call realloc_array( x%cmplx, 1, n,                    &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                  if( data%data_type == MF_DT_DBLE ) then
                     x%cmplx(1,i) = data%double(1,:)
                  else if( data%data_type == MF_DT_CMPLX ) then
                     x%cmplx(1,i) = data%cmplx(1,:)
                  end if
               end if
            end if
         else
            if( x%data_type == MF_DT_DBLE ) then
               if( data%data_type == MF_DT_DBLE ) then
                  x%double(1,i) = data%double(1,:)
               else if( data%data_type == MF_DT_CMPLX ) then
                  x%data_type = MF_DT_CMPLX
                  allocate( x%cmplx(x%shape(1),x%shape(2)) )

                  x%cmplx(:,:) = x%double(:,:)
                  x%cmplx(1,i) = data%cmplx(1,:)
                  deallocate( x%double )

                  x%double => null()
               end if
            else if( x%data_type == MF_DT_CMPLX ) then
               if( data%data_type == MF_DT_DBLE ) then
                  x%cmplx(1,i) = data%double(1,:)
               else if( data%data_type == MF_DT_CMPLX ) then
                  x%cmplx(1,i) = data%cmplx(1,:)
               end if
            end if
         end if
      else if( x%shape(2) == 1 ) then ! col vector
         ! data must be also a col vector with appropriate size
         if( data%shape(1) /= size(i) .or. data%shape(2) /= 1 ) then
            call PrintMessage( "msSet", "E",                            &
                               "bad value for size of 'i' w.r.t. those of 'data'" )
            go to 99
         end if
         if( maxval(i) > x%shape(1) ) then
            if( x%status_restricted ) then
               call PrintMessage( "msSet", "E",                         &
                                  "cannot reshape a restricted array" )
               go to 99
            else
               n = maxval(i)
               x%shape = [ n, 1 ]
               if( x%data_type == MF_DT_DBLE ) then
                  if( data%data_type == MF_DT_DBLE ) then
                     call realloc_array( x%double, n, 1,                &
                                         fill=mf_out_of_range_filling )
                     x%double(i,1) = data%double(:,1)
                  else if( data%data_type == MF_DT_CMPLX ) then
                     call realloc_array( x%cmplx, n, 1,                 &
                                         fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                     x%data_type = MF_DT_CMPLX
                     x%cmplx(i,1) = data%cmplx(:,1)
                  end if
               else if( x%data_type == MF_DT_CMPLX ) then
                  call realloc_array( x%cmplx, n, 1,                    &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                  x%data_type = MF_DT_CMPLX
                  x%cmplx(i,1) = data%cmplx(:,1)
               end if
            end if
         else
            if( x%data_type == MF_DT_DBLE ) then
               if( data%data_type == MF_DT_DBLE ) then
                  x%double(i,1) = data%double(:,1)
               else if( data%data_type == MF_DT_CMPLX ) then
                  x%data_type = MF_DT_CMPLX
                  allocate( x%cmplx(x%shape(1),x%shape(2)) )

                  x%cmplx(:,:) = x%double(:,:)
                  x%cmplx(i,1) = data%cmplx(:,1)
                  deallocate( x%double )

                  x%double => null()
               end if
            else if( x%data_type == MF_DT_CMPLX ) then
               if( data%data_type == MF_DT_DBLE ) then
                  x%cmplx(i,1) = data%double(:,1)
               else if( data%data_type == MF_DT_CMPLX ) then
                  x%cmplx(i,1) = data%cmplx(:,1)
               end if
            end if
         end if
      else ! 2D array
         n = maxval(i)
         if( x%data_type == MF_DT_EMPTY ) then
            if( mfIsEmpty(data) ) then
               call PrintMessage( "msSet", "E",                         &
                                  "x must be non-empty!",               &
                                  "(cannot remove elements from an empty vector)" )
               return
            else
               if( data%data_type == MF_DT_DBLE ) then
                  x%data_type = MF_DT_DBLE
                  if( data%shape(1) == 1 ) then ! data is a row vector
                     x%shape = [ 1, n ]
                     call realloc_array( x%double, 1, n,                &
                                         fill=mf_out_of_range_filling )
                     x%double(1,i) = data%double(1,:)
                  else ! data is a column vector
                     x%shape = [ n, 1 ]
                     call realloc_array( x%double, n, 1,                &
                                         fill=mf_out_of_range_filling )
                     x%double(i,1) = data%double(:,1)
                  end if
               else if( data%data_type == MF_DT_CMPLX ) then
                  x%data_type = MF_DT_CMPLX
                  if( data%shape(1) == 1 ) then ! data is a row vector
                     x%shape = [ 1, n ]
                     call realloc_array( x%cmplx, 1, n,                 &
                                         fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                     x%cmplx(1,i) = data%cmplx(1,:)
                  else ! data is a column vector
                     x%shape = [ n, 1 ]
                     call realloc_array( x%cmplx, n, 1,                 &
                                         fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                     x%cmplx(i,1) = data%cmplx(:, 1)
                  end if
               end if
            end if
         else if( x%data_type == MF_DT_DBLE ) then
            if( any( data%shape /= [1,1] ) ) then
               call PrintMessage( "msSet", "E",                         &
                                  "when using a long-column-index 'data' must be a scalar." )
               go to 99
            end if
            dim_out = size(x%double)
            if( n > dim_out ) then
               call PrintMessage( "msSet", "E",                         &
                                  "out-of-range indices",               &
                                  "(hint: use (i,j) indices if you want to extend the array)" )
               go to 99
            end if
            if( data%data_type == MF_DT_DBLE ) then
               vec_real => rank_2_to_1_real8( x%double, dim_out )
               vec_real(i) = data%double(1,1)
               vec_real => null()
            else if( data%data_type == MF_DT_CMPLX ) then
               x%data_type = MF_DT_CMPLX
               allocate( x%cmplx(x%shape(1),x%shape(2)) )
               x%cmplx(:,:) = x%double(:,:)
               deallocate( x%double )
               x%double => null()
               vec_cmplx => rank_2_to_1_cmplx( x%cmplx, dim_out )
               vec_cmplx(i) = data%cmplx(1,1)
               vec_cmplx => null()
            end if
         else if( x%data_type == MF_DT_CMPLX ) then
            if( any( data%shape /= [1,1] ) ) then
               call PrintMessage( "msSet", "E",                         &
                                  "when using a long-column-index 'data' must be a scalar." )
               go to 99
            end if
            dim_out = size(x%cmplx)
            if( n > dim_out ) then
               call PrintMessage( "msSet", "E",                         &
                                  "out-of-range indices",               &
                                  "(hint: use (i,j) indices if you want to extend the array)" )
               go to 99
            end if
            vec_cmplx => rank_2_to_1_cmplx( x%cmplx, dim_out )
            if( data%data_type == MF_DT_DBLE ) then
               vec_cmplx(i) = data%double(1,1)
            else if( data%data_type == MF_DT_CMPLX ) then
               vec_cmplx(i) = data%cmplx(1,1)
            end if
         end if
      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            go to 99
         end if
      end if

 99   continue

      call msFreeArgs( data )
      call msAutoRelease( data )

#endif
   end subroutine msSet_array_in_vec_section
!_______________________________________________________________________
!
   subroutine msSet_array_in_vec_sect2( data, x, a )

      type(mfArray) :: data
      type(mfArray) :: x
      type(mfArray) :: a
      !------ API end ------

#ifdef _DEVLP
      ! if x is empty, returns a row vector, in any case

      ! extended to the case where 'a' is an EndIndex (which is
      ! either the MF_END parameter itself, or an expression
      ! involving integers and MF_END, like 'MF_END-1').

      integer :: n, k, kk, dim_out
      integer :: status
      integer, allocatable :: i(:)
      type(mfArray) :: tmp
      real(kind=MF_DOUBLE), pointer :: vec_real(:)
      complex(kind=MF_DOUBLE), pointer :: vec_cmplx(:)

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      call msInitArgs( data, a )

      if( A%data_type == MF_DT_EMPTY .and. all( A%shape == 0 ) ) then
         call PrintMessage( "msSet", "I",                               &
                            "mfArray didn't change because index array is empty." )
         go to 99
      end if

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         go to 99
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be sparse!" )
         go to 99
      end if

      if( mfIsSparse(data) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'data' cannot be sparse!" )
         go to 99
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( data%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting logical item in an mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( a%shape(1) /= 1 .and. a%shape(2) /= 1 .and.                   &
          .not. isEndIndex(a) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray indexes 'a' must be of rank one!" )
         go to 99
      end if

      if( isEndIndex(a) ) then

         if( x%data_type == MF_DT_EMPTY ) then
            call PrintMessage( "msSet", "E",                            &
                               "you cannot use MF_END when 'x' is empty!" )
            go to 99
         end if
         allocate( i(1) )

         if( x%shape(1) == 1 ) then ! row vector
            n = x%shape(2)
         else if( x%shape(2) == 1 ) then ! col vector
            n = x%shape(1)
         end if
         i(1) = n + a%crc
         if( i(1) < 1 .or. n < i(1) ) then
            call PrintMessage( "msSet", "E",                            &
                               "End-index 'a' is out of range!" )
            go to 99
         end if

      else ! usual case

         if( .not. mfIsReal(a) ) then
            call PrintMessage( "msSet", "E",                            &
                               "mfArray 'a' must be real for containing indexes!" )
            go to 99
         end if

         if( minval(a%double) < 1 ) then
            call PrintMessage( "msSet", "E",                            &
                               "bad value for min of i" )
            go to 99
         end if

         allocate( i(size(a%double)) )

         i = a
         n = maxval(i)

      end if

      if( x%data_type == MF_DT_EMPTY ) then ! creating a row vector
         x%shape = [ 1, n ]
         ! data must be a scalar or a vector
! the scalar case for 'data' can be treated as a vector by GNU-gfortran
! and FSF-g95, but not by INTEL-ifort (even in debug mode: so it is not
! a bug ? !)
         if( mfIsScalar(data) ) then ! data is a scalar
            if( data%data_type == MF_DT_DBLE ) then
               allocate( x%double(x%shape(1),x%shape(2)) )

               x%data_type = MF_DT_DBLE
               x%double(1,i) = data%double(1,1)
            else if( data%data_type == MF_DT_CMPLX ) then
               allocate( x%cmplx(x%shape(1),x%shape(2)) )

               x%data_type = MF_DT_CMPLX
               x%cmplx(1,i) = data%cmplx(1,1)
            end if
         else if( data%shape(1) == 1 ) then ! data is a row vector
            if( data%data_type == MF_DT_DBLE ) then
               allocate( x%double(x%shape(1),x%shape(2)) )

               x%data_type = MF_DT_DBLE
               x%double(1,i) = data%double(1,:)
            else if( data%data_type == MF_DT_CMPLX ) then
               allocate( x%cmplx(x%shape(1),x%shape(2)) )

               x%data_type = MF_DT_CMPLX
               x%cmplx(1,i) = data%cmplx(1,:)
            end if
         else if( data%shape(2) == 1 ) then ! data is a col vector
            if( data%data_type == MF_DT_DBLE ) then
               allocate( x%double(x%shape(1),x%shape(2)) )

               x%data_type = MF_DT_DBLE
               x%double(1,i) = data%double(:,1)
            else if( data%data_type == MF_DT_CMPLX ) then
               allocate( x%cmplx(x%shape(1),x%shape(2)) )

               x%data_type = MF_DT_CMPLX
               x%cmplx(1,i) = data%cmplx(:,1)
            end if
         else
            call PrintMessage( "msSet", "E",                            &
                               "'data' must be a vector" )
            go to 99
         end if
      else if( x%shape(1) == 1 ) then ! row vector
         ! data may be empty, or a scalar, or a row vector with
         ! appropriate size
         if( mfIsEmpty(data) ) then
            ! data is empty -> we suppress some parts
            if( minval(i) < 1 .or. x%shape(2) < maxval(i) ) then
               call PrintMessage( "msSet", "E",                         &
                                  "deleting : index out of range!" )
               go to 99
            end if
            if( x%status_restricted ) then
               call PrintMessage( "msSet", "E",                         &
                                  "cannot reshape a restricted array" )
               go to 99
            end if
            ! we suppress cols refered by the vector i(:)
            ! (even if they are multiple defined!)
            tmp = x
            ! computing new size of x
            n = 0
            do k = 1, tmp%shape(2)
               if( index_in_vector( k, i ) ) cycle
               n = n + 1
            end do
            if( n == 0 ) then
               x = MF_EMPTY
               go to 99
            end if
            x%shape = [ 1, n ]
            if( x%data_type == MF_DT_DBLE .or. x%data_type == MF_DT_BOOL ) then
               deallocate( x%double )

               allocate( x%double(1,n) )

               ! affectation
               kk = 0
               do k = 1, tmp%shape(2)
                  if( index_in_vector( k, i ) ) cycle
                  kk = kk + 1
                  x%double(:,kk) = tmp%double(:,k)
               end do
            else if( x%data_type == MF_DT_CMPLX ) then
               deallocate( x%cmplx )

               allocate( x%cmplx(1,n) )

               ! affectation
               kk = 0
               do k = 1, tmp%shape(2)
                  if( index_in_vector( k, i ) ) cycle
                  kk = kk + 1
                  x%cmplx(:,kk) = tmp%cmplx(:,k)
               end do
            end if
         else if( mfIsScalar(data) ) then
            ! we impose that indexes 'i' match the col indexes of 'x'
            if( maxval(i) <= x%shape(2) ) then
               if( x%data_type == MF_DT_DBLE ) then
                  if( data%data_type == MF_DT_DBLE ) then
                     x%double(1,i) = data%double(1,1)
                  else if( data%data_type == MF_DT_CMPLX ) then
                     x%data_type = MF_DT_CMPLX
                     allocate( x%cmplx(x%shape(1),x%shape(2)) )

                     x%cmplx(:,:) = x%double(:,:)
                     x%cmplx(1,i) = data%cmplx(1,1)
                     deallocate( x%double )

                     x%double => null()
                  end if
               else if( x%data_type == MF_DT_CMPLX ) then
                  if( data%data_type == MF_DT_DBLE ) then
                     x%cmplx(1,i) = data%double(1,1)
                  else if( data%data_type == MF_DT_CMPLX ) then
                     x%cmplx(1,i) = data%cmplx(1,1)
                  end if
               end if
            else
               call PrintMessage( "msSet", "E",                         &
                                  "bad value for size of 'i' w.r.t. those of 'data'" )
               go to 99
            end if
         else if( data%shape(1) == 1 .or. data%shape(2) == size(i) ) then
            if( maxval(i) > x%shape(2) ) then
               ! indexes 'i' are out of range w.r.t. the columns of 'x'
               if( x%status_restricted ) then
                  call PrintMessage( "msSet", "E",                      &
                                     "cannot reshape a restricted array" )
                  go to 99
               else
                  x%shape = [ 1, n ]
                  if( x%data_type == MF_DT_DBLE ) then
                     if( data%data_type == MF_DT_DBLE ) then
                        call realloc_array( x%double, 1, n,             &
                                            fill=mf_out_of_range_filling )
                        x%double(1,i) = data%double(1,:)
                     else if( data%data_type == MF_DT_CMPLX ) then
                        call realloc_array( x%double, x%cmplx, 1, n,    &
                                            fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                        x%data_type = MF_DT_CMPLX
                        x%cmplx(1,i) = data%cmplx(1,:)
                     end if
                  else if( x%data_type == MF_DT_CMPLX ) then
                     call realloc_array( x%cmplx, 1, n,                 &
                                         fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                     if( data%data_type == MF_DT_DBLE ) then
                        x%cmplx(1,i) = data%double(1,:)
                     else if( data%data_type == MF_DT_CMPLX ) then
                        x%cmplx(1,i) = data%cmplx(1,:)
                     end if
                  end if
               end if
            else ! indexes 'i' match the columns of 'x'
               if( x%data_type == MF_DT_DBLE ) then
                  if( data%data_type == MF_DT_DBLE ) then
                     x%double(1,i) = data%double(1,:)
                  else if( data%data_type == MF_DT_CMPLX ) then
                     x%data_type = MF_DT_CMPLX
                     allocate( x%cmplx(x%shape(1),x%shape(2)) )

                     x%cmplx(:,:) = x%double(:,:)
                     x%cmplx(1,i) = data%cmplx(1,:)
                     deallocate( x%double )

                     x%double => null()
                  end if
               else if( x%data_type == MF_DT_CMPLX ) then
                  if( data%data_type == MF_DT_DBLE ) then
                     x%cmplx(1,i) = data%double(1,:)
                  else if( data%data_type == MF_DT_CMPLX ) then
                     x%cmplx(1,i) = data%cmplx(1,:)
                  end if
               end if
            end if
         else
            call PrintMessage( "msSet", "E",                            &
                               "bad value for size of 'i' w.r.t. those of 'data'" )
            go to 99
         end if
      else if( x%shape(2) == 1 ) then ! col vector
         ! data may be empty, or a scalar, or a col vector with
         ! appropriate size
         if( mfIsEmpty(data) ) then
            ! data is empty -> we suppress some parts
            if( minval(i) < 1 .or. x%shape(1) < maxval(i) ) then
               call PrintMessage( "msSet", "E",                         &
                                  "deleting : index out of range!" )
               go to 99
            end if
            if( x%status_restricted ) then
               call PrintMessage( "msSet", "E",                         &
                                  "cannot reshape a restricted array" )
               go to 99
            end if
            ! we suppress rows refered by the vector i(:)
            ! (even if they are multiple defined!)
            tmp = x
            ! computing new size of x
            n = 0
            do k = 1, tmp%shape(1)
               if( index_in_vector( k, i ) ) cycle
               n = n + 1
            end do
            if( n == 0 ) then
               x = MF_EMPTY
               go to 99
            end if
            x%shape = [ n, 1 ]
            if( x%data_type == MF_DT_DBLE .or. x%data_type == MF_DT_BOOL ) then
               deallocate( x%double )

               allocate( x%double(n,1) )

               ! affectation
               kk = 0
               do k = 1, tmp%shape(1)
                  if( index_in_vector( k, i ) ) cycle
                  kk = kk + 1
                  x%double(kk,:) = tmp%double(k,:)
               end do
            else if( x%data_type == MF_DT_CMPLX ) then
               deallocate( x%cmplx )

               allocate( x%cmplx(n,1) )

               ! affectation
               kk = 0
               do k = 1, tmp%shape(1)
                  if( index_in_vector( k, i ) ) cycle
                  kk = kk + 1
                  x%cmplx(kk,:) = tmp%cmplx(k,:)
               end do
            end if
         else if( mfIsScalar(data) ) then
            ! we impose that indexes 'i' match the row indexes of 'x'
            if( maxval(i) <= x%shape(1) ) then
               if( x%data_type == MF_DT_DBLE ) then
                  if( data%data_type == MF_DT_DBLE ) then
                     x%double(i,1) = data%double(1,1)
                  else if( data%data_type == MF_DT_CMPLX ) then
                     x%data_type = MF_DT_CMPLX
                     allocate( x%cmplx(x%shape(1),x%shape(2)) )

                     x%cmplx(:,:) = x%double(:,:)
                     x%cmplx(i,1) = data%cmplx(1,1)
                     deallocate( x%double )

                     x%double => null()
                  end if
               else if( x%data_type == MF_DT_CMPLX ) then
                  if( data%data_type == MF_DT_DBLE ) then
                     x%cmplx(i,1) = data%double(1,1)
                  else if( data%data_type == MF_DT_CMPLX ) then
                     x%cmplx(i,1) = data%cmplx(1,1)
                  end if
               end if
            else
               call PrintMessage( "msSet", "E",                         &
                                  "bad value for size of 'i' w.r.t. those of 'data'" )
               go to 99
            end if
         else if( data%shape(1) == size(i) .and. data%shape(2) == 1) then
            if( maxval(i) > x%shape(1) ) then
               ! indexes 'i' are out of range w.r.t. the rows of 'x'
               if( x%status_restricted ) then
                  call PrintMessage( "msSet", "E",                      &
                                     "cannot reshape a restricted array" )
                  go to 99
               else
                  x%shape = [ n, 1 ]
                  if( x%data_type == MF_DT_DBLE ) then
                     if( data%data_type == MF_DT_DBLE ) then
                        call realloc_array( x%double, n, 1,             &
                                            fill=mf_out_of_range_filling )
                        x%double(i,1) = data%double(:,1)
                     else if( data%data_type == MF_DT_CMPLX ) then
                        call realloc_array( x%cmplx, n, 1,              &
                                            fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                        x%data_type = MF_DT_CMPLX
                        x%cmplx(i,1) = data%cmplx(:,1)
                     end if
                  else if( x%data_type == MF_DT_CMPLX ) then
                     call realloc_array( x%cmplx, n, 1,                 &
                                         fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                     x%data_type = MF_DT_CMPLX
                     x%cmplx(i,1) = data%cmplx(:,1)
                  end if
               end if
            else ! indexes 'i' match the rows of 'x'
               if( x%data_type == MF_DT_DBLE ) then
                  if( data%data_type == MF_DT_DBLE ) then
                     x%double(i,1) = data%double(:,1)
                  else if( data%data_type == MF_DT_CMPLX ) then
                     x%data_type = MF_DT_CMPLX
                     allocate( x%cmplx(x%shape(1),x%shape(2)) )

                     x%cmplx(:,:) = x%double(:,:)
                     x%cmplx(i,1) = data%cmplx(:,1)
                     deallocate( x%double )

                     x%double => null()
                  end if
               else if( x%data_type == MF_DT_CMPLX ) then
                  if( data%data_type == MF_DT_DBLE ) then
                     x%cmplx(i,1) = data%double(:,1)
                  else if( data%data_type == MF_DT_CMPLX ) then
                     x%cmplx(i,1) = data%cmplx(:,1)
                  end if
               end if
            end if
         else
            call PrintMessage( "msSet", "E",                            &
                               "bad value for size of 'i' w.r.t. those of 'data'" )
            go to 99
         end if
      else ! 2D array
         if( any( data%shape /= [1,1] ) ) then
            call PrintMessage( "msSet", "E",                            &
                               "when using a long-column-index 'data' must be a scalar." )
            go to 99
         end if
         ! note: i(:) is already allocated et contains indices of a%double

         if( x%data_type == MF_DT_EMPTY ) then
            ! this case should have been detected previously;
            ! here: x%data_type == MF_DT_EMPTY, but with 'shape' /= (0,0)
            write(STDERR,*) "(MUESLI msSet:) internal ERROR: x%data_type = 0"
            mf_message_displayed = .true.
            call muesli_trace( pause="yes" )
            stop
         else if( x%data_type == MF_DT_DBLE ) then
            dim_out = size(x%double)
            if( n > dim_out ) then
               call PrintMessage( "msSet", "E",                         &
                                  "out-of-range indices",               &
                                  "(hint: use (i,j) indices if you want to extend the array)" )
               go to 99
            end if
            if( data%data_type == MF_DT_DBLE ) then
               vec_real => rank_2_to_1_real8( x%double, dim_out )
               vec_real(i) = data%double(1,1)
               vec_real => null()
            else if( data%data_type == MF_DT_CMPLX ) then
               x%data_type = MF_DT_CMPLX
               allocate( x%cmplx(x%shape(1),x%shape(2)) )
               x%cmplx(:,:) = x%double(:,:)
               deallocate( x%double )
               x%double => null()
               vec_cmplx => rank_2_to_1_cmplx( x%cmplx, dim_out )
               vec_cmplx(i) = data%cmplx(1,1)
               vec_cmplx => null()
            end if
         else if( x%data_type == MF_DT_CMPLX ) then
            dim_out = size(x%cmplx)
            if( n > dim_out ) then
               call PrintMessage( "msSet", "E",                         &
                                  "out-of-range indices",               &
                                  "(hint: use (i,j) indices if you want to extend the array)" )
               go to 99
            end if
            vec_cmplx => rank_2_to_1_cmplx( x%cmplx, dim_out )
            if( data%data_type == MF_DT_DBLE ) then
               vec_cmplx(i) = data%double(1,1)
            else if( data%data_type == MF_DT_CMPLX ) then
               vec_cmplx(i) = data%cmplx(1,1)
            end if
         end if

      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            go to 99
         end if
      end if

 99   continue

      call msSilentRelease( tmp )

      call msFreeArgs( data, a )
      call msAutoRelease( data, a )

#endif
   end subroutine msSet_array_in_vec_sect2
!_______________________________________________________________________
!
   subroutine msSet_array_section_vec_vec( data, x, i1, i2 )

      type(mfArray) :: data
      type(mfArray) :: x
      integer, intent(in) :: i1(:), i2(:)
      !------ API end ------

#ifdef _DEVLP
      integer :: n1, n2
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      call msInitArgs( data )

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         go to 99
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be sparse!" )
         go to 99
      end if

      if( mfIsSparse(data) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'data' cannot be sparse!" )
         go to 99
      end if

      if( mfIsEmpty(data) ) then
         call PrintMessage( "msSet", "E",                               &
                            "to suppress data, use MF_COLON!" )
         go to 99
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( data%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting logical item in an mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( size(i1) /= data%shape(1) .or. size(i2) /= data%shape(2) ) then
         call PrintMessage( "msSet", "E",                               &
                            "bad value for size of i1 or i2" )
         go to 99
      end if

      if( minval(i1) < 1 .or. minval(i2) < 1 ) then
         call PrintMessage( "msSet", "E",                               &
                            "bad value for min of i1 or i2" )
         go to 99
      end if

      if( maxval(i1) > x%shape(1) .or. maxval(i2) > x%shape(2) ) then
         if( x%status_restricted ) then
            call PrintMessage( "msSet", "E",                            &
                               "cannot reshape a restricted array" )
            go to 99
         else
            n1 = max( maxval(i1), x%shape(1) )
            n2 = max( maxval(i2), x%shape(2) )
            x%shape = [ n1, n2 ]
            if( x%data_type == MF_DT_EMPTY ) then
               if( data%data_type == MF_DT_DBLE ) then
                  call realloc_array( x%double, n1, n2,                 &
                                      fill=mf_out_of_range_filling )
                  x%data_type = MF_DT_DBLE
                  x%double(i1,i2) = data%double(:,:)
               else if( data%data_type == MF_DT_CMPLX ) then
                  call realloc_array( x%cmplx, n1, n2,                  &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                  x%data_type = MF_DT_CMPLX
                  x%cmplx(i1,i2) = data%cmplx(:,:)
               end if
            else if( x%data_type == MF_DT_DBLE ) then
               if( data%data_type == MF_DT_DBLE ) then
                  call realloc_array( x%double, n1, n2,                 &
                                      fill=mf_out_of_range_filling )
                  x%data_type = MF_DT_DBLE
                  x%double(i1,i2) = data%double(:,:)
               else if( data%data_type == MF_DT_CMPLX ) then
                  call realloc_array( x%double, x%cmplx, n1, n2,        &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                  x%data_type = MF_DT_CMPLX
                  x%cmplx(i1,i2) = data%cmplx(:,:)
               end if
            else if( x%data_type == MF_DT_CMPLX ) then
               call realloc_array( x%cmplx, n1, n2,                     &
                                   fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
               x%data_type = MF_DT_CMPLX
               if( data%data_type == MF_DT_DBLE ) then
                  x%cmplx(i1,i2) = data%double(:,:)
               else if( data%data_type == MF_DT_CMPLX ) then
                  x%cmplx(i1,i2) = data%cmplx(:,:)
               end if
            end if
         end if
      else
         if( x%data_type == MF_DT_EMPTY ) then
            ! this case should have been detected previously;
            ! here: x%data_type == MF_DT_EMPTY, but with 'shape' /= (0,0)
            write(STDERR,*) "(MUESLI msSet:) internal ERROR: x%data_type = 0"
            mf_message_displayed = .true.
            call muesli_trace( pause="yes" )
            stop
         else if( x%data_type == MF_DT_DBLE ) then
            if( data%data_type == MF_DT_DBLE ) then
               x%data_type = MF_DT_DBLE
               x%double(i1,i2) = data%double(:,:)
            else if( data%data_type == MF_DT_CMPLX ) then
               x%data_type = MF_DT_CMPLX
               allocate( x%cmplx(x%shape(1),x%shape(2)) )

               x%cmplx(:,:) = x%double(:,:)
               x%cmplx(i1,i2) = data%cmplx(:,:)
               deallocate( x%double )

               x%double => null()
            end if
         else if( x%data_type == MF_DT_CMPLX ) then
            x%data_type = MF_DT_CMPLX
            if( data%data_type == MF_DT_DBLE ) then
               x%cmplx(i1,i2) = data%double(:,:)
            else if( data%data_type == MF_DT_CMPLX ) then
               x%cmplx(i1,i2) = data%cmplx(:,:)
            end if
         end if
      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, data%units, status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical dimensions of the two mfArray's", &
                               "are not consistent!" )
            go to 99
         end if
      end if

 99   continue

      call msFreeArgs( data )
      call msAutoRelease( data )

#endif
   end subroutine msSet_array_section_vec_vec
!_______________________________________________________________________
!
   subroutine msSet_arr_sect_vseq_vseq( data, x, seq1, seq2 )

      type(mfArray) :: data
      type(mfArray) :: x
      type(seq_def) :: seq1, seq2
      !------ API end ------

#ifdef _DEVLP
      integer :: n1, n2
      integer :: status
      integer, pointer :: i1(:) => null(), i2(:) => null()
      logical :: spread_data

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      call msInitArgs( data )

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         go to 99
      end if

      if( mfIsEmpty(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be empty!" )
         go to 99
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be sparse!" )
         go to 99
      end if

      if( mfIsSparse(data) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'data' cannot be sparse!" )
         go to 99
      end if

      if( mfIsEmpty(data) ) then
         call PrintMessage( "msSet", "E",                               &
                            "to suppress data, use MF_COLON!" )
         go to 99
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( data%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting logical item in an mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      n1 = x%shape(1)
      if( seq1%start_1_EndIndex ) then
         seq1%start_1 = n1 + seq1%start_1
      end if
      if( seq1%end_1_EndIndex ) then
         seq1%end_1 = n1 + seq1%end_1
      end if
      if( seq1%start_2_EndIndex ) then
         seq1%start_2 = n1 + seq1%start_2
      end if
      if( seq1%end_2_EndIndex ) then
         seq1%end_2 = n1 + seq1%end_2
      end if
      if( seq1%but_EndIndex ) then
         seq1%but = n1 + seq1%but
      end if
      call build_int_seq( i1, seq1, "msSet" )

      n2 = x%shape(2)
      if( seq2%start_1_EndIndex ) then
         seq2%start_1 = n2 + seq2%start_1
      end if
      if( seq2%end_1_EndIndex ) then
         seq2%end_1 = n2 + seq2%end_1
      end if
      if( seq2%start_2_EndIndex ) then
         seq2%start_2 = n2 + seq2%start_2
      end if
      if( seq2%end_2_EndIndex ) then
         seq2%end_2 = n2 + seq2%end_2
      end if
      if( seq2%but_EndIndex ) then
         seq2%but = n2 + seq2%but
      end if
      call build_int_seq( i2, seq2, "msSet" )

      spread_data = .false.
      if( size(data) == 1 .and.                                         &
          ( size(i1) > 1 .or. size(i2) > 1 ) ) then
         spread_data = .true.
      else if( size(i1) /= data%shape(1) .or. size(i2) /= data%shape(2) ) then
         call PrintMessage( "msSet", "E",                               &
                            "bad value for size of 'seq1' or 'seq2'" )
         go to 99
      end if

      if( minval(i1) < 1 .or. minval(i2) < 1 ) then
         call PrintMessage( "msSet", "E",                               &
                            "bad value for min of 'seq1' or 'seq2'" )
         go to 99
      end if

      if( maxval(i1) > x%shape(1) .or. maxval(i2) > x%shape(2) ) then
         if( x%status_restricted ) then
            call PrintMessage( "msSet", "E",                            &
                               "cannot reshape a restricted array" )
            go to 99
         else
            n1 = max( maxval(i1), x%shape(1) )
            n2 = max( maxval(i2), x%shape(2) )
            x%shape = [ n1, n2 ]
            if( x%data_type == MF_DT_EMPTY ) then
               if( data%data_type == MF_DT_DBLE ) then
                  call realloc_array( x%double, n1, n2,                 &
                                      fill=mf_out_of_range_filling )
                  x%data_type = MF_DT_DBLE
                  if( spread_data ) then
                     x%double(i1,i2) = data%double(1,1)
                  else
                     x%double(i1,i2) = data%double(:,:)
                  end if
               else if( data%data_type == MF_DT_CMPLX ) then
                  call realloc_array( x%cmplx, n1, n2,                  &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                  x%data_type = MF_DT_CMPLX
                  if( spread_data ) then
                     x%cmplx(i1,i2) = data%cmplx(1,1)
                  else
                     x%cmplx(i1,i2) = data%cmplx(:,:)
                  end if
               end if
            else if( x%data_type == MF_DT_DBLE ) then
               if( data%data_type == MF_DT_DBLE ) then
                  call realloc_array( x%double, n1, n2,                 &
                                      fill=mf_out_of_range_filling )
                  x%data_type = MF_DT_DBLE
                  if( spread_data ) then
                     x%double(i1,i2) = data%double(1,1)
                  else
                     x%double(i1,i2) = data%double(:,:)
                  end if
               else if( data%data_type == MF_DT_CMPLX ) then
                  call realloc_array( x%double, x%cmplx, n1, n2,        &
                                      fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                  x%data_type = MF_DT_CMPLX
                  if( spread_data ) then
                     x%cmplx(i1,i2) = data%cmplx(1,1)
                  else
                     x%cmplx(i1,i2) = data%cmplx(:,:)
                  end if
               end if
            else if( x%data_type == MF_DT_CMPLX ) then
               call realloc_array( x%cmplx, n1, n2,                     &
                                   fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
               x%data_type = MF_DT_CMPLX
               if( data%data_type == MF_DT_DBLE ) then
                  if( spread_data ) then
                     x%cmplx(i1,i2) = data%double(1,1)
                  else
                     x%cmplx(i1,i2) = data%double(:,:)
                  end if
               else if( data%data_type == MF_DT_CMPLX ) then
                  if( spread_data ) then
                     x%cmplx(i1,i2) = data%cmplx(1,1)
                  else
                     x%cmplx(i1,i2) = data%cmplx(:,:)
                  end if
               end if
            end if
         end if
      else
         if( x%data_type == MF_DT_EMPTY ) then
            ! this case should have been detected previously;
            ! here: x%data_type == MF_DT_EMPTY, but with 'shape' /= (0,0)
            write(STDERR,*) "(MUESLI msSet:) internal ERROR: x%data_type = 0"
            mf_message_displayed = .true.
            call muesli_trace( pause="yes" )
            stop
         else if( x%data_type == MF_DT_DBLE ) then
            if( data%data_type == MF_DT_DBLE ) then
               x%data_type = MF_DT_DBLE
               if( spread_data ) then
                  x%double(i1,i2) = data%double(1,1)
               else
                  x%double(i1,i2) = data%double(:,:)
               end if
            else if( data%data_type == MF_DT_CMPLX ) then
               x%data_type = MF_DT_CMPLX
               allocate( x%cmplx(x%shape(1),x%shape(2)) )

               x%cmplx(:,:) = x%double(:,:)
               if( spread_data ) then
                  x%cmplx(i1,i2) = data%cmplx(1,1)
               else
                  x%cmplx(i1,i2) = data%cmplx(:,:)
               end if
               deallocate( x%double )

               x%double => null()
            end if
         else if( x%data_type == MF_DT_CMPLX ) then
            x%data_type = MF_DT_CMPLX
            if( data%data_type == MF_DT_DBLE ) then
               if( spread_data ) then
                  x%cmplx(i1,i2) = data%double(1,1)
               else
                  x%cmplx(i1,i2) = data%double(:,:)
               end if
            else if( data%data_type == MF_DT_CMPLX ) then
               if( spread_data ) then
                  x%cmplx(i1,i2) = data%cmplx(1,1)
               else
                  x%cmplx(i1,i2) = data%cmplx(:,:)
               end if
            end if
         end if
      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, data%units, status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical dimensions of the two mfArray's", &
                               "are not consistent!" )
            go to 99
         end if
      end if

 99   continue

      if( associated(i1) ) then
#ifndef _TRACE_MEM_ALLOC
         deallocate( i1 )
#else
         call mf_deallocate( array=i1,                                  &
                             file="Set.inc", line="???",                &
                             symb="i1", unit="msSet_arr_sect_vseq_vseq" )
#endif
      end if

      if( associated(i2) ) then
#ifndef _TRACE_MEM_ALLOC
         deallocate( i2 )
#else
         call mf_deallocate( array=i2,                                  &
                             file="Set.inc", line="???",                &
                             symb="i2", unit="msSet_arr_sect_vseq_vseq" )
#endif
      end if

      call msFreeArgs( data )
      call msAutoRelease( data )

#endif
   end subroutine msSet_arr_sect_vseq_vseq
!_______________________________________________________________________
!
   subroutine msSet_array_section_array_array( data, x, a1, a2 )

      type(mfArray) :: data
      type(mfArray) :: x
      type(mfArray) :: a1, a2
      !------ API end ------

#ifdef _DEVLP
      ! take into account only DENSE mfArray x

      ! extended to the case where 'a1' or 'a2' contains an EndIndex
      ! (which is either the MF_END parameter itself, or an expression
      ! involving integers and MF_END, like 'MF_END-1').

      integer :: n1, n2, i, ii
      integer :: status
      integer, allocatable :: i1(:), i2(:)
      type(mfArray) :: tmp

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      call msInitArgs( data, a1, a2 )

      if( A1%data_type == MF_DT_EMPTY .and. all( A1%shape == 0 ) ) then
         call PrintMessage( "msSet", "I",                               &
                            "mfArray didn't change because 1st index array is empty." )
         go to 99
      end if

      if( A2%data_type == MF_DT_EMPTY .and. all( A2%shape == 0 ) ) then
         call PrintMessage( "msSet", "I",                               &
                            "mfArray didn't change because 2nd index array is empty." )
         go to 99
      end if

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         go to 99
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be sparse!" )
         go to 99
      end if

      if( mfIsSparse(data) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'data' cannot be sparse!" )
         go to 99
      end if

      if( mfIsEmpty(data) ) then
         if( .not. mfIsEqual(a1,MF_COLON) .and.                         &
             .not. mfIsEqual(a2,MF_COLON) ) then
            call PrintMessage( "msSet", "E",                            &
                               "to suppress data, one index at least must be", &
                               "equal to MF_COLON!" )
            go to 99
         end if
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( data%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting logical item in an mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( isEndIndex(a1) ) then

         allocate( i1(1) )

         n1 = x%shape(1)
         i1(1) = n1 + a1%crc
         if( i1(1) < 1 .or. n1 < i1(1) ) then
            call PrintMessage( "msSet", "E",                            &
                               "End-index 'a1' is out of range!" )
            go to 99
         end if

         if( data%shape(1) /= 1 .and. .not. mfIsEmpty(data) ) then
            call PrintMessage( "msSet", "E",                            &
                               "non conforming first dimension for 'data' and 'x'!" )
            go to 99
         end if

      else if( mfIsEqual(a1,MF_COLON) ) then

         n1 = x%shape(1)
         allocate( i1(n1) )
         i1 = [( i, i = 1, n1 )]

         if( data%shape(1) /= 1 .and. .not. mfIsEmpty(data) ) then
            if( data%shape(1) /= n1 ) then
               call PrintMessage( "msSet", "E",                         &
                                  "when using MF_COLON, non conforming first dimension", &
                                  "for 'data' and 'x'!" )
               go to 99
            end if
         end if

      else

         if( a1%shape(1) /= 1 .and. a1%shape(2) /= 1 ) then
            call PrintMessage( "msSet", "E",                            &
                               "mfArray indexes 'a1' must be of rank one!" )
            go to 99
         end if

         if( size(a1) /= data%shape(1) ) then
            call PrintMessage( "msSet", "E",                            &
                               "bad value for size of a1" )
            go to 99
         end if

         if( minval(a1%double) < 1 ) then
            call PrintMessage( "msSet", "E",                            &
                               "bad value for min of a1" )
            go to 99
         end if

         allocate( i1(size(a1%double)) )

         i1 = reshape( int(a1%double), [size(a1%double)] )

      end if

      if( isEndIndex(a2) ) then

         allocate( i2(1) )

         n2 = x%shape(2)
         i2(1) = n2 + a2%crc
         if( i2(1) < 1 .or. n2 < i2(1) ) then
            call PrintMessage( "msSet", "E",                            &
                               "End-index 'a2' is out of range!" )
            go to 99
         end if

         if( data%shape(2) /= 1 .and. .not. mfIsEmpty(data) ) then
            call PrintMessage( "msSet", "E",                            &
                               "non conforming first dimension for 'data' and 'x'!" )
            go to 99
         end if

      else if( mfIsEqual(a2,MF_COLON) ) then

         n2 = x%shape(2)
         allocate( i2(n2) )
         i2 = [( i, i = 1, n2 )]

         if( data%shape(2) /= 1 .and. .not. mfIsEmpty(data) ) then
            if( data%shape(2) /= n2 ) then
               call PrintMessage( "msSet", "E",                         &
                                  "when using MF_COLON, non conforming second dimension", &
                                  "for 'data' and 'x'!" )
               go to 99
            end if
         end if

      else

         if( a2%shape(1) /= 1 .and. a2%shape(2) /= 1 ) then
            call PrintMessage( "msSet", "E",                            &
                               "mfArray indexes 'a2' must be of rank one!" )
            go to 99
         end if

         if( size(a2) /= data%shape(2) ) then
            call PrintMessage( "msSet", "E",                            &
                               "bad value for size of a2" )
            go to 99
         end if

         if( minval(a2%double) < 1 ) then
            call PrintMessage( "msSet", "E",                            &
                               "bad value for min of a2" )
            go to 99
         end if

         allocate( i2(size(a2%double)) )

         i2 = reshape( int(a2%double), [size(a2%double)] )

      end if

      if( data%data_type == MF_DT_EMPTY ) then
         if( x%data_type == MF_DT_EMPTY ) then
            ! nothing to do: x is already empty
            go to 99
         end if
         ! Here, undoubtedly, a1 or a2 is equal to MF_COLON
         if( mfIsEqual(a1,MF_COLON) ) then
            ! removing some columns of x
            if( minval(i2) < 1 .or. x%shape(2) < maxval(i2) ) then
               call PrintMessage( "msSet", "E",                         &
                                  "deleting : index out of range!" )
               go to 99
            end if
            ! column indices are contained in a2
            tmp = x
            ! computing new size of x
            n2 = 0
            do i = 1, tmp%shape(2)
               if( index_in_vector( i, i2 ) ) cycle
               n2 = n2 + 1
            end do
            if( n2 == 0 ) then
               x = MF_EMPTY
               go to 99
            end if
            x%shape = [ tmp%shape(1), n2 ]
            if( x%data_type == MF_DT_DBLE .or. x%data_type == MF_DT_BOOL ) then
               deallocate( x%double )
               allocate( x%double(tmp%shape(1),n2) )
               ii = 0
               do i = 1, tmp%shape(2)
                  if( index_in_vector( i, i2 ) ) cycle
                  ii = ii + 1
                  x%double(:,ii) = tmp%double(:,i)
               end do
            else if( x%data_type == MF_DT_CMPLX ) then
               deallocate( x%cmplx )
               allocate( x%cmplx(tmp%shape(1),n2) )
               ii = 0
               do i = 1, tmp%shape(2)
                  if( index_in_vector( i, i2 ) ) cycle
                  ii = ii + 1
                  x%cmplx(:,ii) = tmp%cmplx(:,i)
               end do
            end if
         else ! a2 = MF_COLON
            ! removing some lines of x
            if( minval(i1) < 1 .or. x%shape(1) < maxval(i1) ) then
               call PrintMessage( "msSet", "E",                         &
                                  "deleting : index out of range!" )
               go to 99
            end if
            ! column indices are contained in a1
            tmp = x
            ! computing new size of x
            n1 = 0
            do i = 1, tmp%shape(1)
               if( index_in_vector( i, i1 ) ) cycle
               n1 = n1 + 1
            end do
            if( n1 == 0 ) then
               x = MF_EMPTY
               go to 99
            end if
            x%shape = [ n1, tmp%shape(2) ]
            if( x%data_type == MF_DT_DBLE .or. x%data_type == MF_DT_BOOL ) then
               deallocate( x%double )
               allocate( x%double(n1,tmp%shape(2)) )
               ii = 0
               do i = 1, tmp%shape(1)
                  if( index_in_vector( i, i1 ) ) cycle
                  ii = ii + 1
                  x%double(ii,:) = tmp%double(i,:)
               end do
            else if( x%data_type == MF_DT_CMPLX ) then
               deallocate( x%cmplx )
               allocate( x%cmplx(n1,tmp%shape(2)) )
               ii = 0
               do i = 1, tmp%shape(1)
                  if( index_in_vector( i, i1 ) ) cycle
                  ii = ii + 1
                  x%cmplx(ii,:) = tmp%cmplx(i,:)
               end do
            end if
         end if
      else
         if( maxval(i1) > x%shape(1) .or. maxval(i2) > x%shape(2) ) then
            if( x%status_restricted ) then
               call PrintMessage( "msSet", "E",                         &
                                  "cannot reshape a restricted array" )
               go to 99
            else
               n1 = max( maxval(i1), x%shape(1) )
               n2 = max( maxval(i2), x%shape(2) )
               x%shape = [ n1, n2 ]
               if( x%data_type == MF_DT_EMPTY ) then
                  if( data%data_type == MF_DT_DBLE ) then
                     call realloc_array( x%double, n1, n2,              &
                                       fill=mf_out_of_range_filling )
                     x%data_type = MF_DT_DBLE
                     x%double(i1,i2) = data%double(:,:)
                  else if( data%data_type == MF_DT_CMPLX ) then
                     call realloc_array( x%cmplx, n1, n2,               &
                                       fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                     x%data_type = MF_DT_CMPLX
                     x%cmplx(i1,i2) = data%cmplx(:,:)
                  end if
               else if( x%data_type == MF_DT_DBLE ) then
                  if( data%data_type == MF_DT_DBLE ) then
                     call realloc_array( x%double, n1, n2,              &
                                       fill=mf_out_of_range_filling )
                     x%data_type = MF_DT_DBLE
                     x%double(i1,i2) = data%double(:,:)
                  else if( data%data_type == MF_DT_CMPLX ) then
                     call realloc_array( x%double, x%cmplx, n1, n2,     &
                                       fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                     x%data_type = MF_DT_CMPLX
                     x%cmplx(i1,i2) = data%cmplx(:,:)
                  end if
               else if( x%data_type == MF_DT_CMPLX ) then
                  call realloc_array( x%cmplx, n1, n2,                  &
                                    fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                  x%data_type = MF_DT_CMPLX
                  if( data%data_type == MF_DT_DBLE ) then
                     x%cmplx(i1,i2) = data%double(:,:)
                  else if( data%data_type == MF_DT_CMPLX ) then
                     x%cmplx(i1,i2) = data%cmplx(:,:)
                  end if
               end if
            end if
         else
            if( x%data_type == MF_DT_EMPTY ) then
               ! this case should have been detected previously;
               ! here: x%data_type == MF_DT_EMPTY, but with 'shape' /= (0,0)
               write(STDERR,*) "(MUESLI msSet:) internal ERROR: x%data_type = 0"
               mf_message_displayed = .true.
               call muesli_trace( pause="yes" )
               pause "for debugging purpose only"
               stop
            else if( x%data_type == MF_DT_DBLE ) then
               if( data%data_type == MF_DT_DBLE ) then
                  x%data_type = MF_DT_DBLE
! Bug work-around for GCC: if data is a scalar, data%double(:,:) is not
! considered as a scalar and there is memory problem, giving wrong result.
! The memory problem is detected only by 'valgrind', but should detected
! at run-time by GCC.
! Bug occurs for GCC versions from 8.5 to 12.1 (reported to bugzilla, on
! 2022-11-15)
#if defined _GNU_GFC
                  if( all( shape(data%double) == [1,1] ) ) then
                     x%double(i1,i2) = data%double(1,1)
                  else
                     x%double(i1,i2) = data%double(:,:)
                  end if
#else
                  x%double(i1,i2) = data%double(:,:)
#endif
               else if( data%data_type == MF_DT_CMPLX ) then
                  x%data_type = MF_DT_CMPLX
                  allocate( x%cmplx(x%shape(1),x%shape(2)) )

                  x%cmplx(:,:) = x%double(:,:)
#if defined _GNU_GFC
                  if( all( shape(data%cmplx) == [1,1] ) ) then
                     x%cmplx(i1,i2) = data%cmplx(1,1)
                  else
                     x%cmplx(i1,i2) = data%cmplx(:,:)
                  end if
#else
                  x%cmplx(i1,i2) = data%cmplx(:,:)
#endif
                  deallocate( x%double )

                  x%double => null()
               end if
            else if( x%data_type == MF_DT_CMPLX ) then
               x%data_type = MF_DT_CMPLX
               if( data%data_type == MF_DT_DBLE ) then
#if defined _GNU_GFC
                  if( all( shape(data%double) == [1,1] ) ) then
                     x%cmplx(i1,i2) = data%double(1,1)
                  else
                     x%cmplx(i1,i2) = data%double(:,:)
                  end if
#else
                  x%cmplx(i1,i2) = data%double(:,:)
#endif
               else if( data%data_type == MF_DT_CMPLX ) then
#if defined _GNU_GFC
                  if( all( shape(data%cmplx) == [1,1] ) ) then
                     x%cmplx(i1,i2) = data%cmplx(1,1)
                  else
                     x%cmplx(i1,i2) = data%cmplx(:,:)
                  end if
#else
                  x%cmplx(i1,i2) = data%cmplx(:,:)
#endif
               end if
            end if
         end if
      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, data%units, status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical dimensions of the two mfArray's", &
                               "are not consistent!" )
            go to 99
         end if
      end if

 99   continue

      call msFreeArgs( data, a1, a2 )
      call msAutoRelease( data, a1, a2 )

      call msRelease( tmp )

#endif
   end subroutine msSet_array_section_array_array
!_______________________________________________________________________
!
   subroutine msSet_spread_real8_in_section( data, x, i1, i2 )

      real(kind=MF_DOUBLE), intent(in) :: data
      type(mfArray) :: x
      integer, intent(in) :: i1(:), i2(:)
      !------ API end ------

#ifdef _DEVLP
      ! spreading scalar data in array section

      integer :: n1, n2
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         return
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be sparse!" )
         return
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         return
      end if

      if( minval(i1) < 1 .or. minval(i2) < 1 ) then
         call PrintMessage( "msSet", "E",                               &
                            "bad value for min of i1 or i2" )
         return
      end if

      if( maxval(i1) > x%shape(1) .or. maxval(i2) > x%shape(2) ) then
         if( x%status_restricted ) then
            call PrintMessage( "msSet", "E",                            &
                               "cannot reshape a restricted array" )
            return
         else
            n1 = max( maxval(i1), x%shape(1) )
            n2 = max( maxval(i2), x%shape(2) )
            x%shape = [ n1, n2 ]
            if( x%data_type == MF_DT_EMPTY ) then
               call realloc_array( x%double, n1, n2,                    &
                                   fill=mf_out_of_range_filling )
               x%data_type = MF_DT_DBLE
               x%double(i1,i2) = data
            else if( x%data_type == MF_DT_DBLE ) then
               call realloc_array( x%double, n1, n2,                    &
                                   fill=mf_out_of_range_filling )
               x%data_type = MF_DT_DBLE
               x%double(i1,i2) = data
            else if( x%data_type == MF_DT_CMPLX ) then
               call realloc_array( x%cmplx, n1, n2,                     &
                                   fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
               x%data_type = MF_DT_CMPLX
               x%cmplx(i1,i2) = data
            end if
         end if
      else
         if( x%data_type == MF_DT_EMPTY ) then
            ! this case should have been detected previously;
            ! here: x%data_type == MF_DT_EMPTY, but with 'shape' /= (0,0)
            write(STDERR,*) "(MUESLI msSet:) internal ERROR: x%data_type = 0"
            mf_message_displayed = .true.
            call muesli_trace( pause="yes" )
            stop
         else if( x%data_type == MF_DT_DBLE ) then
            x%double(i1,i2) = data
         else if( x%data_type == MF_DT_CMPLX ) then
            x%cmplx(i1,i2) = data
         end if
      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            return
         end if
      end if

#endif
   end subroutine msSet_spread_real8_in_section
!_______________________________________________________________________
!
   subroutine msSet_spread_cmplx_in_section( data, x, i1, i2 )

      complex(kind=MF_DOUBLE), intent(in) :: data
      type(mfArray) :: x
      integer, intent(in) :: i1(:), i2(:)
      !------ API end ------

#ifdef _DEVLP
      ! spreading scalar data in array section

      integer :: n1, n2
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",              &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         return
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be sparse!" )
         return
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         return
      end if

      if( minval(i1) < 1 .or. minval(i2) < 1 ) then
         call PrintMessage( "msSet", "E",                               &
                            "bad value for min of i1 or i2" )
         return
      end if

      if( maxval(i1) > x%shape(1) .or. maxval(i2) > x%shape(2) ) then
         if( x%status_restricted ) then
            call PrintMessage( "msSet", "E",                            &
                               "cannot reshape a restricted array" )
            return
         else
            n1 = max( maxval(i1), x%shape(1) )
            n2 = max( maxval(i2), x%shape(2) )
            x%shape = [ n1, n2 ]
            if( x%data_type == MF_DT_EMPTY ) then
               call realloc_array( x%cmplx, n1, n2,                     &
                                   fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
            else if( x%data_type == MF_DT_DBLE ) then
               call realloc_array( x%double, x%cmplx, n1, n2,           &
                                   fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
            else if( x%data_type == MF_DT_CMPLX ) then
               call realloc_array( x%cmplx, n1, n2,                     &
                                   fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
            end if
            x%data_type = MF_DT_CMPLX
            x%cmplx(i1,i2) = data
         end if
      else
         if( x%data_type == MF_DT_EMPTY ) then
            ! this case should have been detected previously;
            ! here: x%data_type == MF_DT_EMPTY, but with 'shape' /= (0,0)
            write(STDERR,*) "(MUESLI msSet:) internal ERROR: x%data_type = 0"
            mf_message_displayed = .true.
            call muesli_trace( pause="yes" )
            stop
         else if( x%data_type == MF_DT_DBLE ) then
            x%data_type = MF_DT_CMPLX
            allocate( x%cmplx(x%shape(1),x%shape(2)) )

            x%cmplx(:,:) = x%double(:,:)
            deallocate( x%double )

            x%double => null()
         end if
         x%cmplx(i1,i2) = data
      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            return
         end if
      end if

#endif
   end subroutine msSet_spread_cmplx_in_section
!_______________________________________________________________________
!
   subroutine msSet_spread_real8_in_colon_vec( data, x, a1, i2 )

      real(kind=MF_DOUBLE), intent(in) :: data
      type(mfArray) :: x, a1
      integer, intent(in) :: i2(:)
      !------ API end ------

#ifdef _DEVLP
      ! spreading scalar data in array section

      ! extended to the case where 'a1' is an EndIndex (which is
      ! either the MF_END parameter itself, or an expression
      ! involving integers and MF_END, like 'MF_END-1').

      integer, allocatable :: i1(:)
      integer :: i, n1, n2
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      call msInitArgs( a1 )

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         go to 99
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be sparse!" )
         go to 99
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( .not. mfIsEqual(a1,MF_COLON) .and. .not. isEndIndex(a1) ) then
         call PrintMessage( "msSet", "E",                               &
                            "a1 must be equal to MF_COLON ':' or must be", &
                            "an end-index!" )
         go to 99
      end if

      if( isEndIndex(a1) ) then

         allocate( i1(1) )

         n1 = x%shape(1)
         i1(1) = n1 + a1%crc
         if( i1(1) < 1 .or. n1 < i1(1) ) then
            call PrintMessage( "msSet", "E",                            &
                               "End-index 'a1' is out of range!" )
            go to 99
         end if

      else ! MF_COLON

         allocate( i1(x%shape(1)) )

         i1 = [ (i, i = 1, x%shape(1)) ]

      end if

      if( minval(i2) < 1 ) then
         call PrintMessage( "msSet", "E",                               &
                            "bad value for minval of i2!" )
         go to 99
      end if

      if( maxval(i2) > x%shape(2) ) then
         if( x%status_restricted ) then
            call PrintMessage( "msSet", "E",                            &
                               "cannot reshape a restricted array" )
            go to 99
         else
            n1 = max( maxval(i1), x%shape(1) )
            n2 = max( maxval(i2), x%shape(2) )
            x%shape = [ n1, n2 ]
            if( x%data_type == MF_DT_EMPTY ) then
               call realloc_array( x%double, n1, n2,                    &
                                   fill=mf_out_of_range_filling )
               x%data_type = MF_DT_DBLE
               x%double(i1,i2) = data
            else if( x%data_type == MF_DT_DBLE ) then
               call realloc_array( x%double, n1, n2,                    &
                                   fill=mf_out_of_range_filling )
               x%data_type = MF_DT_DBLE
               x%double(i1,i2) = data
            else if( x%data_type == MF_DT_CMPLX ) then
               call realloc_array( x%cmplx, n1, n2,                     &
                                   fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
               x%data_type = MF_DT_CMPLX
               x%cmplx(i1,i2) = data
            end if
         end if
      else
         if( x%data_type == MF_DT_EMPTY ) then
            ! this case should have been detected previously;
            ! here: x%data_type == MF_DT_EMPTY, but with 'shape' /= (0,0)
            write(STDERR,*) "(MUESLI msSet:) internal ERROR: x%data_type = 0"
            mf_message_displayed = .true.
            call muesli_trace( pause="yes" )
            stop
         else if( x%data_type == MF_DT_DBLE ) then
            x%double(i1,i2) = data
         else if( x%data_type == MF_DT_CMPLX ) then
            x%cmplx(i1,i2) = data
         end if
      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            go to 99
         end if
      end if

 99   continue

      call msFreeArgs( a1 )
      call msAutoRelease( a1 )

#endif
   end subroutine msSet_spread_real8_in_colon_vec
!_______________________________________________________________________
!
   subroutine msSet_spread_cmplx_in_colon_vec( data, x, a1, i2 )

      complex(kind=MF_DOUBLE), intent(in) :: data
      type(mfArray) :: x, a1
      integer, intent(in) :: i2(:)
      !------ API end ------

#ifdef _DEVLP
      ! spreading scalar data in array section

      ! extended to the case where 'a1' is an EndIndex (which is
      ! either the MF_END parameter itself, or an expression
      ! involving integers and MF_END, like 'MF_END-1').

      integer, allocatable :: i1(:)
      integer :: i, n1, n2
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      call msInitArgs( a1 )

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         go to 99
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be sparse!" )
         go to 99
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( .not. mfIsEqual(a1,MF_COLON) .and. .not. isEndIndex(a1) ) then
         call PrintMessage( "msSet", "E",                               &
                            "a1 must be equal to MF_COLON ':' or must be", &
                            "an end-index!" )
         go to 99
      end if

      if( isEndIndex(a1) ) then

         allocate( i1(1) )

         n1 = x%shape(1)
         i1(1) = n1 + a1%crc
         if( i1(1) < 1 .or. n1 < i1(1) ) then
            call PrintMessage( "msSet", "E",                            &
                               "End-index 'a1' is out of range!" )
            go to 99
         end if

      else ! MF_COLON

         allocate( i1(x%shape(1)) )

         i1 = [ (i, i = 1, x%shape(1)) ]

      end if

      if( minval(i2) < 1 ) then
         call PrintMessage( "msSet", "E",                               &
                            "bad value for minval of i2!" )
         go to 99
      end if

      if( maxval(i2) > x%shape(2) ) then
         if( x%status_restricted ) then
            call PrintMessage( "msSet", "E",                            &
                               "cannot reshape a restricted array" )
            go to 99
         else
            n1 = max( maxval(i1), x%shape(1) )
            n2 = max( maxval(i2), x%shape(2) )
            x%shape = [ n1, n2 ]
            if( x%data_type == MF_DT_EMPTY ) then
               call realloc_array( x%cmplx, n1, n2,                     &
                                   fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
            else if( x%data_type == MF_DT_DBLE ) then
               call realloc_array( x%double, x%cmplx, n1, n2,           &
                                   fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
            else if( x%data_type == MF_DT_CMPLX ) then
               call realloc_array( x%cmplx, n1, n2,                     &
                                   fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
            end if
            x%data_type = MF_DT_CMPLX
            x%cmplx(i1,i2) = data
         end if
      else
         if( x%data_type == MF_DT_EMPTY ) then
            ! this case should have been detected previously;
            ! here: x%data_type == MF_DT_EMPTY, but with 'shape' /= (0,0)
            write(STDERR,*) "(MUESLI msSet:) internal ERROR: x%data_type = 0"
            mf_message_displayed = .true.
            call muesli_trace( pause="yes" )
            stop
         else if( x%data_type == MF_DT_DBLE ) then
            x%data_type = MF_DT_CMPLX
            allocate( x%cmplx(x%shape(1),x%shape(2)) )

            x%cmplx(:,:) = x%double(:,:)
            deallocate( x%double )

            x%double => null()
         end if
         x%cmplx(i1,i2) = data
      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            go to 99
         end if
      end if

 99   continue

      call msFreeArgs( a1 )
      call msAutoRelease( a1 )

#endif
   end subroutine msSet_spread_cmplx_in_colon_vec
!_______________________________________________________________________
!
   subroutine msSet_spread_real8_in_colon_int( data, x, a1, i2 )

      real(kind=MF_DOUBLE), intent(in) :: data
      type(mfArray) :: x, a1
      integer, intent(in) :: i2
      !------ API end ------

#ifdef _DEVLP
      ! spreading scalar data in array section

      ! extended to the case where 'a1' is an EndIndex (which is
      ! either the MF_END parameter itself, or an expression
      ! involving integers and MF_END, like 'MF_END-1').

      integer, allocatable :: i1(:)
      integer :: i, n1, n2
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      call msInitArgs( a1 )

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         go to 99
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be sparse!" )
         go to 99
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( .not. mfIsEqual(a1,MF_COLON) .and. .not. isEndIndex(a1) ) then
         call PrintMessage( "msSet", "E",                               &
                            "a1 must be equal to MF_COLON ':' or must be", &
                            "an end-index!" )
         go to 99
      end if

      if( isEndIndex(a1) ) then

         allocate( i1(1) )

         n1 = x%shape(1)
         i1(1) = n1 + a1%crc
         if( i1(1) < 1 .or. n1 < i1(1) ) then
            call PrintMessage( "msSet", "E",                            &
                               "End-index 'a1' is out of range!" )
            go to 99
         end if

      else ! MF_COLON

         allocate( i1(x%shape(1)) )

         i1 = [ (i, i = 1, x%shape(1)) ]

      end if

      if( i2 < 1 ) then
         call PrintMessage( "msSet", "E",                               &
                            "bad value for i2!" )
         go to 99
      end if

      if( i2 > x%shape(2) ) then
         if( x%status_restricted ) then
            call PrintMessage( "msSet", "E",                            &
                               "cannot reshape a restricted array" )
            go to 99
         else
            n1 = max( maxval(i1), x%shape(1) )
            n2 = max( i2, x%shape(2) )
            x%shape = [ n1, n2 ]
            if( x%data_type == MF_DT_EMPTY ) then
               call realloc_array( x%double, n1, n2,                    &
                                   fill=mf_out_of_range_filling )
               x%data_type = MF_DT_DBLE
               x%double(i1,i2) = data
            else if( x%data_type == MF_DT_DBLE ) then
               call realloc_array( x%double, n1, n2,                    &
                                   fill=mf_out_of_range_filling )
               x%data_type = MF_DT_DBLE
               x%double(i1,i2) = data
            else if( x%data_type == MF_DT_CMPLX ) then
               call realloc_array( x%cmplx, n1, n2,                     &
                                   fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
               x%data_type = MF_DT_CMPLX
               x%cmplx(i1,i2) = data
            end if
         end if
      else
         if( x%data_type == MF_DT_EMPTY ) then
            ! this case should have been detected previously;
            ! here: x%data_type == MF_DT_EMPTY, but with 'shape' /= (0,0)
            write(STDERR,*) "(MUESLI msSet:) internal ERROR: x%data_type = 0"
            mf_message_displayed = .true.
            call muesli_trace( pause="yes" )
            stop
         else if( x%data_type == MF_DT_DBLE ) then
            x%double(i1,i2) = data
         else if( x%data_type == MF_DT_CMPLX ) then
            x%cmplx(i1,i2) = data
         end if
      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            go to 99
         end if
      end if

 99   continue

      call msFreeArgs( a1 )
      call msAutoRelease( a1 )

#endif
   end subroutine msSet_spread_real8_in_colon_int
!_______________________________________________________________________
!
   subroutine msSet_spread_cmplx_in_colon_int( data, x, a1, i2 )

      complex(kind=MF_DOUBLE), intent(in) :: data
      type(mfArray) :: x, a1
      integer, intent(in) :: i2
      !------ API end ------

#ifdef _DEVLP
      ! spreading scalar data in array section

      ! extended to the case where 'a1' is an EndIndex (which is
      ! either the MF_END parameter itself, or an expression
      ! involving integers and MF_END, like 'MF_END-1').

      integer, allocatable :: i1(:)
      integer :: i, n1, n2
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      call msInitArgs( a1 )

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         go to 99
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be sparse!" )
         go to 99
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( .not. mfIsEqual(a1,MF_COLON) .and. .not. isEndIndex(a1) ) then
         call PrintMessage( "msSet", "E",                               &
                            "a1 must be equal to MF_COLON ':' or must be", &
                            "an end-index!" )
         go to 99
      end if

      if( isEndIndex(a1) ) then

         allocate( i1(1) )

         n1 = x%shape(1)
         i1(1) = n1 + a1%crc
         if( i1(1) < 1 .or. n1 < i1(1) ) then
            call PrintMessage( "msSet", "E",                            &
                               "End-index 'a1' is out of range!" )
            go to 99
         end if

      else ! MF_COLON

         allocate( i1(x%shape(1)) )

         i1 = [ (i, i = 1, x%shape(1)) ]

      end if

      if( i2 < 1 ) then
         call PrintMessage( "msSet", "E",                               &
                            "bad value for i2!" )
         go to 99
      end if

      if( i2 > x%shape(2) ) then
         if( x%status_restricted ) then
            call PrintMessage( "msSet", "E",                            &
                               "cannot reshape a restricted array" )
            go to 99
         else
            n1 = max( maxval(i1), x%shape(1) )
            n2 = max( i2, x%shape(2) )
            x%shape = [ n1, n2 ]
            if( x%data_type == MF_DT_EMPTY ) then
               call realloc_array( x%cmplx, n1, n2,                     &
                                   fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
            else if( x%data_type == MF_DT_DBLE ) then
               call realloc_array( x%double, x%cmplx, n1, n2,           &
                                   fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
            else if( x%data_type == MF_DT_CMPLX ) then
               call realloc_array( x%cmplx, n1, n2,                     &
                                   fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
            end if
            x%data_type = MF_DT_CMPLX
            x%cmplx(i1,i2) = data
         end if
      else
         if( x%data_type == MF_DT_EMPTY ) then
            ! this case should have been detected previously;
            ! here: x%data_type == MF_DT_EMPTY, but with 'shape' /= (0,0)
            write(STDERR,*) "(MUESLI msSet:) internal ERROR: x%data_type = 0"
            mf_message_displayed = .true.
            call muesli_trace( pause="yes" )
            stop
         else if( x%data_type == MF_DT_DBLE ) then
            x%data_type = MF_DT_CMPLX
            allocate( x%cmplx(x%shape(1),x%shape(2)) )

            x%cmplx(:,:) = x%double(:,:)
            deallocate( x%double )

            x%double => null()
         end if
         x%cmplx(i1,i2) = data
      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            go to 99
         end if
      end if

 99   continue

      call msFreeArgs( a1 )
      call msAutoRelease( a1 )

#endif
   end subroutine msSet_spread_cmplx_in_colon_int
!_______________________________________________________________________
!
   subroutine msSet_spread_real8_in_vec_colon( data, x, i1, a2 )

      real(kind=MF_DOUBLE), intent(in) :: data
      type(mfArray) :: x
      integer, intent(in) :: i1(:)
      type(mfArray) :: a2
      !------ API end ------

#ifdef _DEVLP
      ! spreading scalar data in array section

      ! extended to the case where 'a2' is an EndIndex (which is
      ! either the MF_END parameter itself, or an expression
      ! involving integers and MF_END, like 'MF_END-1').

      integer, allocatable :: i2(:)
      integer :: i, n1, n2
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      call msInitArgs( a2 )

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         go to 99
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be sparse!" )
         go to 99
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( .not. mfIsEqual(a2,MF_COLON) .and. .not. isEndIndex(a2) ) then
         call PrintMessage( "msSet", "E",                               &
                            "a2 must be equal to MF_COLON ':' or must be", &
                            "an end-index!" )
         go to 99
      end if

      if( isEndIndex(a2) ) then

         allocate( i2(1) )

         n2 = x%shape(2)
         i2(1) = n2 + a2%crc
         if( i2(1) < 1 .or. n2 < i2(1) ) then
            call PrintMessage( "msSet", "E",                            &
                               "End-index 'a2' is out of range!" )
            go to 99
         end if

      else ! MF_COLON

         allocate( i2(x%shape(2)) )

         i2 = [ (i, i = 1, x%shape(2)) ]

      end if

      if( minval(i1) < 1 ) then
         call PrintMessage( "msSet", "E",                               &
                            "bad value for minval of i1!" )
         go to 99
      end if

      if( maxval(i1) > x%shape(1) ) then
         if( x%status_restricted ) then
            call PrintMessage( "msSet", "E",                            &
                               "cannot reshape a restricted array" )
            go to 99
         else
            n1 = max( maxval(i1), x%shape(1) )
            n2 = max( maxval(i2), x%shape(2) )
            x%shape = [ n1, n2 ]
            if( x%data_type == MF_DT_EMPTY ) then
               call realloc_array( x%double, n1, n2,                    &
                                   fill=mf_out_of_range_filling )
               x%data_type = MF_DT_DBLE
               x%double(i1,i2) = data
            else if( x%data_type == MF_DT_DBLE ) then
               call realloc_array( x%double, n1, n2,                    &
                                   fill=mf_out_of_range_filling )
               x%data_type = MF_DT_DBLE
               x%double(i1,i2) = data
            else if( x%data_type == MF_DT_CMPLX ) then
               call realloc_array( x%cmplx, n1, n2,                     &
                                   fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
               x%data_type = MF_DT_CMPLX
               x%cmplx(i1,i2) = data
            end if
         end if
      else
         if( x%data_type == MF_DT_EMPTY ) then
            ! this case should have been detected previously;
            ! here: x%data_type == MF_DT_EMPTY, but with 'shape' /= (0,0)
            write(STDERR,*) "(MUESLI msSet:) internal ERROR: x%data_type = 0"
            mf_message_displayed = .true.
            call muesli_trace( pause="yes" )
            stop
         else if( x%data_type == MF_DT_DBLE ) then
            x%double(i1,i2) = data
         else if( x%data_type == MF_DT_CMPLX ) then
            x%cmplx(i1,i2) = data
         end if
      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            go to 99
         end if
      end if

 99   continue

      call msFreeArgs( a2 )
      call msAutoRelease( a2 )

#endif
   end subroutine msSet_spread_real8_in_vec_colon
!_______________________________________________________________________
!
   subroutine msSet_spread_cmplx_in_vec_colon( data, x, i1, a2 )

      complex(kind=MF_DOUBLE), intent(in) :: data
      type(mfArray) :: x
      integer, intent(in) :: i1(:)
      type(mfArray) :: a2
      !------ API end ------

#ifdef _DEVLP
      ! spreading scalar data in array section

      ! extended to the case where 'a2' is an EndIndex (which is
      ! either the MF_END parameter itself, or an expression
      ! involving integers and MF_END, like 'MF_END-1').

      integer, allocatable :: i2(:)
      integer :: i, n1, n2
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      call msInitArgs( a2 )

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         go to 99
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be sparse!" )
         go to 99
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( .not. mfIsEqual(a2,MF_COLON) .and. .not. isEndIndex(a2) ) then
         call PrintMessage( "msSet", "E",                               &
                            "a2 must be equal to MF_COLON ':' or must be", &
                            "an end-index!" )
         go to 99
      end if

      if( isEndIndex(a2) ) then

         allocate( i2(1) )

         n2 = x%shape(2)
         i2(1) = n2 + a2%crc
         if( i2(1) < 1 .or. n2 < i2(1) ) then
            call PrintMessage( "msSet", "E",                            &
                               "End-index 'a2' is out of range!" )
            go to 99
         end if

      else ! MF_COLON

         allocate( i2(x%shape(2)) )

         i2 = [ (i, i = 1, x%shape(2)) ]

      end if

      if( minval(i1) < 1 ) then
         call PrintMessage( "msSet", "E",                               &
                            "bad value for minval of i1!" )
         go to 99
      end if

      if( maxval(i1) > x%shape(1) ) then
         if( x%status_restricted ) then
            call PrintMessage( "msSet", "E",                            &
                               "cannot reshape a restricted array" )
            go to 99
         else
            n1 = max( maxval(i1), x%shape(1) )
            n2 = max( maxval(i2), x%shape(2) )
            x%shape = [ n1, n2 ]
            if( x%data_type == MF_DT_EMPTY ) then
               call realloc_array( x%cmplx, n1, n2,                     &
                                   fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
            else if( x%data_type == MF_DT_DBLE ) then
               call realloc_array( x%double, x%cmplx, n1, n2,           &
                                   fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
            else if( x%data_type == MF_DT_CMPLX ) then
               call realloc_array( x%cmplx, n1, n2,                     &
                                   fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
            end if
            x%data_type = MF_DT_CMPLX
            x%cmplx(i1,i2) = data
         end if
      else
         if( x%data_type == MF_DT_EMPTY ) then
            ! this case should have been detected previously;
            ! here: x%data_type == MF_DT_EMPTY, but with 'shape' /= (0,0)
            write(STDERR,*) "(MUESLI msSet:) internal ERROR: x%data_type = 0"
            mf_message_displayed = .true.
            call muesli_trace( pause="yes" )
            stop
         else if( x%data_type == MF_DT_DBLE ) then
            x%data_type = MF_DT_CMPLX
            allocate( x%cmplx(x%shape(1),x%shape(2)) )

            x%cmplx(:,:) = x%double(:,:)
            deallocate( x%double )

            x%double => null()
         end if
         x%cmplx(i1,i2) = data
      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            go to 99
         end if
      end if

 99   continue

      call msFreeArgs( a2 )
      call msAutoRelease( a2 )

#endif
   end subroutine msSet_spread_cmplx_in_vec_colon
!_______________________________________________________________________
!
   subroutine msSet_spread_real8_in_int_colon( data, x, i1, a2 )

      real(kind=MF_DOUBLE), intent(in) :: data
      type(mfArray) :: x
      integer, intent(in) :: i1
      type(mfArray) :: a2
      !------ API end ------

#ifdef _DEVLP
      ! spreading scalar data in array section

      ! extended to the case where 'a2' is an EndIndex (which is
      ! either the MF_END parameter itself, or an expression
      ! involving integers and MF_END, like 'MF_END-1').

      integer, allocatable :: i2(:)
      integer :: i, n1, n2
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      call msInitArgs( a2 )

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         go to 99
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be sparse!" )
         go to 99
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( .not. mfIsEqual(a2,MF_COLON) .and. .not. isEndIndex(a2) ) then
         call PrintMessage( "msSet", "E",                               &
                            "a2 must be equal to MF_COLON ':' or must be", &
                            "an end-index!" )
         go to 99
      end if

      if( isEndIndex(a2) ) then

         allocate( i2(1) )

         n2 = x%shape(2)
         i2(1) = n2 + a2%crc
         if( i2(1) < 1 .or. n2 < i2(1) ) then
            call PrintMessage( "msSet", "E",                            &
                               "End-index 'a2' is out of range!" )
            go to 99
         end if

      else ! MF_COLON

         allocate( i2(x%shape(2)) )

         i2 = [ (i, i = 1, x%shape(2)) ]

      end if

      if( i1 < 1 ) then
         call PrintMessage( "msSet", "E",                               &
                            "bad value for i1!" )
         go to 99
      end if

      if( i1 > x%shape(1) ) then
         if( x%status_restricted ) then
            call PrintMessage( "msSet", "E",                            &
                               "cannot reshape a restricted array" )
            go to 99
         else
            n1 = max( i1, x%shape(1) )
            n2 = max( maxval(i2), x%shape(2) )
            x%shape = [ n1, n2 ]
            if( x%data_type == MF_DT_EMPTY ) then
               call realloc_array( x%double, n1, n2,                    &
                                   fill=mf_out_of_range_filling )
               x%data_type = MF_DT_DBLE
               x%double(i1,i2) = data
            else if( x%data_type == MF_DT_DBLE ) then
               call realloc_array( x%double, n1, n2,                    &
                                   fill=mf_out_of_range_filling )
               x%data_type = MF_DT_DBLE
               x%double(i1,i2) = data
            else if( x%data_type == MF_DT_CMPLX ) then
               call realloc_array( x%cmplx, n1, n2,                     &
                                   fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
               x%data_type = MF_DT_CMPLX
               x%cmplx(i1,i2) = data
            end if
         end if
      else
         if( x%data_type == MF_DT_EMPTY ) then
            ! this case should have been detected previously;
            ! here: x%data_type == MF_DT_EMPTY, but with 'shape' /= (0,0)
            write(STDERR,*) "(MUESLI msSet:) internal ERROR: x%data_type = 0"
            mf_message_displayed = .true.
            call muesli_trace( pause="yes" )
            stop
         else if( x%data_type == MF_DT_DBLE ) then
            x%double(i1,i2) = data
         else if( x%data_type == MF_DT_CMPLX ) then
            x%cmplx(i1,i2) = data
         end if
      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            go to 99
         end if
      end if

 99   continue

      call msFreeArgs( a2 )
      call msAutoRelease( a2 )

#endif
   end subroutine msSet_spread_real8_in_int_colon
!_______________________________________________________________________
!
   subroutine msSet_spread_cmplx_in_int_colon( data, x, i1, a2 )

      complex(kind=MF_DOUBLE), intent(in) :: data
      type(mfArray) :: x
      integer, intent(in) :: i1
      type(mfArray) :: a2
      !------ API end ------

#ifdef _DEVLP
      ! spreading scalar data in array section

      ! extended to the case where 'a2' is an EndIndex (which is
      ! either the MF_END parameter itself, or an expression
      ! involving integers and MF_END, like 'MF_END-1').

      integer, allocatable :: i2(:)
      integer :: i, n1, n2
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      call msInitArgs( a2 )

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         go to 99
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be sparse!" )
         go to 99
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( .not. mfIsEqual(a2,MF_COLON) .and. .not. isEndIndex(a2) ) then
         call PrintMessage( "msSet", "E",                               &
                            "a2 must be equal to MF_COLON ':' or must be", &
                            "an end-index!" )
         go to 99
      end if

      if( isEndIndex(a2) ) then

         allocate( i2(1) )

         n2 = x%shape(2)
         i2(1) = n2 + a2%crc
         if( i2(1) < 1 .or. n2 < i2(1) ) then
            call PrintMessage( "msSet", "E",                            &
                               "End-index 'a2' is out of range!" )
            go to 99
         end if

      else ! MF_COLON

         allocate( i2(x%shape(2)) )

         i2 = [ (i, i = 1, x%shape(2)) ]

      end if

      if( i1 < 1 ) then
         call PrintMessage( "msSet", "E",                               &
                            "bad value for i1!" )
         go to 99
      end if

      if( i1 > x%shape(1) ) then
         if( x%status_restricted ) then
            call PrintMessage( "msSet", "E",                            &
                               "cannot reshape a restricted array" )
            go to 99
         else
            n1 = max( i1, x%shape(1) )
            n2 = max( maxval(i2), x%shape(2) )
            x%shape = [ n1, n2 ]
            if( x%data_type == MF_DT_EMPTY ) then
               call realloc_array( x%cmplx, n1, n2,                     &
                                   fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
            else if( x%data_type == MF_DT_DBLE ) then
               call realloc_array( x%double, x%cmplx, n1, n2,           &
                                   fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
            else if( x%data_type == MF_DT_CMPLX ) then
               call realloc_array( x%cmplx, n1, n2,                     &
                                   fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
            end if
            x%data_type = MF_DT_CMPLX
            x%cmplx(i1,i2) = data
         end if
      else
         if( x%data_type == MF_DT_EMPTY ) then
            ! this case should have been detected previously;
            ! here: x%data_type == MF_DT_EMPTY, but with 'shape' /= (0,0)
            write(STDERR,*) "(MUESLI msSet:) internal ERROR: x%data_type = 0"
            mf_message_displayed = .true.
            call muesli_trace( pause="yes" )
            stop
         else if( x%data_type == MF_DT_DBLE ) then
            x%data_type = MF_DT_CMPLX
            allocate( x%cmplx(x%shape(1),x%shape(2)) )

            x%cmplx(:,:) = x%double(:,:)
            deallocate( x%double )

            x%double => null()
         end if
         x%cmplx(i1,i2) = data
      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            go to 99
         end if
      end if

 99   continue

      call msFreeArgs( a2 )
      call msAutoRelease( a2 )

#endif
   end subroutine msSet_spread_cmplx_in_int_colon
!_______________________________________________________________________
!
   subroutine msSet_array_section_colon_vec( data, x, a1, i2 )

      type(mfArray) :: data, x, a1
      integer, intent(in) :: i2(:)
      !------ API end ------

#ifdef _DEVLP
      ! restricted to the case where 'a1' is MF_COLON

      ! Warning: this routine may modify a sparse mfArray x,
      !          but one whole column at a time.

      ! extended to the case where 'a1' contains an EndIndex (which is
      ! either the MF_END parameter itself, or an expression
      ! involving integers and MF_END, like 'MF_END-1').

      integer :: i, ii, n1, n2
      integer :: jcol, nzc, nzv, inc, nnz, ncopy
      real(kind=MF_DOUBLE), allocatable :: v(:)
      complex(kind=MF_DOUBLE), allocatable :: zv(:)
      integer, allocatable :: iv(:)

      type(mfArray) :: tmp
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      call msInitArgs( data, a1 )

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         go to 99
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( data%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting logical item in an mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( isEndIndex(a1) ) then

         if( mfIsEmpty(data) ) then
            call PrintMessage( "msSet", "E",                            &
                               "'data' cannot be empty!" )
            go to 99
         end if

         n1 = x%shape(1)
         i = n1 + a1%crc
         if( i < 1 .or. n1 < i ) then
            call PrintMessage( "mfGet", "E",                            &
                               "row index is out of range!" )
            go to 99
         end if
         call msSet_array_section_vec_vec(data,x,[i],i2)
         go to 99

      else if( mfIsEqual(a1,MF_COLON) ) then

         if( .not. mfIsEmpty(data) ) then
            if( data%shape(1) /= x%shape(1) .or. data%shape(2) /= size(i2) ) then
               call PrintMessage( "msSet", "E",                         &
                                  "bad size for 'data'!" )
               go to 99
            end if
         end if

         if( minval(i2) < 1 ) then
            call PrintMessage( "msSet", "E",                            &
                               "bad value for min of i2!" )
            go to 99
         end if

         if( .not. mfIsEmpty(data) ) then
            if( maxval(i2) > x%shape(2) ) then

               ! an extension is not possible for SPARSE mfArrays
               if( mfIsSparse(x) ) then
                  call PrintMessage( "msSet", "E",                      &
                                     "mfArray 'x' cannot be sparse!" )
                  go to 99
               end if

               if( x%status_restricted ) then
                  call PrintMessage( "msSet", "E",                      &
                                     "cannot reshape a restricted array!" )
                  go to 99
               else

                  ! array extension
                  n1 = x%shape(1)
                  n2 = maxval(i2)
                  x%shape = [ n1, n2 ]
                  if( x%data_type == MF_DT_EMPTY ) then
                     if( data%data_type == MF_DT_DBLE ) then
                        call realloc_array( x%double, n1, n2,           &
                                            fill=mf_out_of_range_filling )
                        x%data_type = MF_DT_DBLE
                        x%double(:,i2) = data%double(:,:)
                     else if( data%data_type == MF_DT_CMPLX ) then
                        call realloc_array( x%cmplx, n1, n2,            &
                                            fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                        x%data_type = MF_DT_CMPLX
                        x%cmplx(:,i2) = data%cmplx(:,:)
                     end if
                  else if( x%data_type == MF_DT_DBLE ) then
                     if( data%data_type == MF_DT_DBLE ) then
                        call realloc_array( x%double, n1, n2,           &
                                            fill=mf_out_of_range_filling )
                        x%data_type = MF_DT_DBLE
                        x%double(:,i2) = data%double(:,:)
                     else if( data%data_type == MF_DT_CMPLX ) then
                        call realloc_array( x%double, x%cmplx, n1, n2,  &
                                            fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                        x%data_type = MF_DT_CMPLX
                        x%cmplx(:,i2) = data%cmplx(:,:)
                     end if
                  else if( x%data_type == MF_DT_CMPLX ) then
                     call realloc_array( x%cmplx, n1, n2,               &
                                         fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                     x%data_type = MF_DT_CMPLX
                     if( data%data_type == MF_DT_DBLE ) then
                        x%cmplx(:,i2) = data%double(:,:)
                     else if( data%data_type == MF_DT_CMPLX ) then
                        x%cmplx(:,i2) = data%cmplx(:,:)
                     end if
                  end if

               end if

            else ! matrix x keep the same shape

               if( x%data_type == MF_DT_EMPTY ) then
                  ! this case should have been detected previously;
                  ! here: x%data_type == MF_DT_EMPTY, but with 'shape' /= (0,0)
                  write(STDERR,*) "(MUESLI msSet:) internal ERROR: x%data_type = 0"
                  mf_message_displayed = .true.
                  call muesli_trace( pause="yes" )
                  stop
               else if( x%data_type == MF_DT_DBLE ) then
                  if( data%data_type == MF_DT_DBLE ) then
                     x%data_type = MF_DT_DBLE
                     x%double(:,i2) = data%double(:,:)
                  else if( data%data_type == MF_DT_CMPLX ) then
                     x%data_type = MF_DT_CMPLX
                     allocate( x%cmplx(x%shape(1),x%shape(2)) )

                     x%cmplx(:,:) = x%double(:,:)
                     x%cmplx(:,i2) = data%cmplx(:,:)
                     deallocate( x%double )

                     x%double => null()
                  else
                     call PrintMessage( "msSet", "E",                   &
                                        "when 'x' is dense, 'data' cannot be sparse!" )
                     go to 99
                  end if
               else if( x%data_type == MF_DT_CMPLX ) then
                  x%data_type = MF_DT_CMPLX
                  if( data%data_type == MF_DT_DBLE ) then
                     x%cmplx(:,i2) = data%double(:,:)
                  else if( data%data_type == MF_DT_CMPLX ) then
                     x%cmplx(:,i2) = data%cmplx(:,:)
                  else
                     call PrintMessage( "msSet", "E",                   &
                                        "when 'x' is dense, 'data' cannot be sparse!" )
                     go to 99
                  end if
               else if( x%data_type == MF_DT_SP_DBLE ) then

                  ! limite : on change une seule colonne  la fois
                  if( size(i2) /= 1 ) then
                     call PrintMessage( "msSet", "E",                   &
                                        "for a sparse matrix, you can change only", &
                                        "one column at a time!" )
                     go to 99
                  end if
                  jcol = i2(1)

                  nzc = x%j(jcol+1) - x%j(jcol)
                  if( data%data_type == MF_DT_DBLE ) then
                     nzv = count( data%double(:,1) /= 0.0d0 )
                     inc = nzv - nzc
                     if( inc > 0 ) then
                        ncopy = x%j(x%shape(2)+1)-1
                        nnz = ncopy + inc
                        if( size(x%i) < nnz ) then
                           call realloc_array( x%i, nnz, ncopy )
                           call realloc_array( x%a, nnz, ncopy )
                        end if
                     end if
                     allocate( v(nzv), iv(nzv) )
                     ii = 0
                     do i = 1, x%shape(1)
                        if( data%double(i,1) /= 0.0d0 ) then
                           ii = ii + 1
                           v(ii) = data%double(i,1)
                           iv(ii) = i
                        end if
                     end do
                     ! data should be a column vector
                     call chgcol( x%shape(2), x%a, x%i, x%j, jcol, v, iv )
                  else if( data%data_type == MF_DT_CMPLX ) then
                     x%data_type = MF_DT_SP_CMPLX
                     ! first convert the real sparse matrix in complex
                     nzv = count( data%cmplx(:,1) /= (0.0d0,0.0d0) )
                     inc = nzv - nzc
                     ncopy = x%j(x%shape(2)+1)-1
                     nnz = ncopy + inc
                     if( inc > 0 .and. size(x%i) < nnz ) then
                        call realloc_array( x%i, nnz, ncopy )
                        call realloc_array( x%a, x%z, nnz, ncopy )
                     else
                        call realloc_array( x%a, x%z, size(x%a), ncopy )
                     end if
                     allocate( zv(nzv), iv(nzv) )
                     ii = 0
                     do i = 1, x%shape(1)
                        if( data%cmplx(i,1) /= (0.0d0,0.0d0) ) then
                           ii = ii + 1
                           zv(ii) = data%cmplx(i,1)
                           iv(ii) = i
                        end if
                     end do
                     ! data should be a column vector
                     call chgcol_cmplx( x%shape(2), x%z, x%i, x%j, jcol, &
                                        zv, iv )
                  else if( data%data_type == MF_DT_SP_DBLE ) then
                     nzv = data%j(data%shape(2)+1)-1
                     inc = nzv - nzc
                     if( inc > 0 ) then
                        ncopy = x%j(x%shape(2)+1)-1
                        nnz = ncopy + inc
                        if( size(x%i) < nnz ) then
                           call realloc_array( x%i, nnz, ncopy )
                           call realloc_array( x%a, nnz, ncopy )
                        end if
                     end if
                     ! data should be a sparse column vector
                     call chgcol( x%shape(2), x%a, x%i, x%j, jcol,      &
                                  data%a, data%i, nzv )
                  else if( data%data_type == MF_DT_SP_CMPLX ) then
                     x%data_type = MF_DT_SP_CMPLX
                     ! first convert the real sparse matrix in complex
                     nzv = data%j(data%shape(2)+1)-1
                     inc = nzv - nzc
                     ncopy = x%j(x%shape(2)+1)-1
                     nnz = ncopy + inc
                     if( inc > 0 .and. size(x%i) < nnz ) then
                        call realloc_array( x%i, nnz, ncopy )
                        call realloc_array( x%a, x%z, nnz, ncopy )
                     else
                        call realloc_array( x%a, x%z, size(x%a), ncopy )
                     end if
                     ! data should be a column vector
                     call chgcol_cmplx( x%shape(2), x%z, x%i, x%j, jcol, &
                                        data%z, data%i, nzv )
                  end if

               else if( x%data_type == MF_DT_SP_CMPLX ) then

                  ! limite : on change une seule colonne  la fois
                  if( size(i2) /= 1 ) then
                     call PrintMessage( "msSet", "E",                   &
                                        "for a sparse matrix, you can change only", &
                                        "one column at a time!" )
                     go to 99
                  end if
                  jcol = i2(1)

                  nzc = x%j(jcol+1) - x%j(jcol)
                  if( data%data_type == MF_DT_DBLE ) then
                     nzv = count( data%double(:,1) /= 0.0d0 )
                     inc = nzv - nzc
                     if( inc > 0 ) then
                        ncopy = x%j(x%shape(2)+1)-1
                        nnz = ncopy + inc
                        if( size(x%i) < nnz ) then
                           call realloc_array( x%i, nnz, ncopy )
                           call realloc_array( x%z, nnz, ncopy )
                        end if
                     end if
                     allocate( zv(nzv), iv(nzv) )
                     ii = 0
                     do i = 1, x%shape(1)
                        if( data%double(i,1) /= 0.0d0 ) then
                           ii = ii + 1
                           zv(ii) = data%double(i,1)
                           iv(ii) = i
                        end if
                     end do
                     ! data should be a column vector
                     call chgcol_cmplx( x%shape(2), x%z, x%i, x%j, jcol, &
                                        zv, iv )
                  else if( data%data_type == MF_DT_CMPLX ) then
                     nzv = count( data%cmplx(:,1) /= (0.0d0,0.0d0) )
                     inc = nzv - nzc
                     if( inc > 0 ) then
                        ncopy = x%j(x%shape(2)+1)-1
                        nnz = ncopy + inc
                        if( size(x%i) < nnz ) then
                           call realloc_array( x%i, nnz, ncopy )
                           call realloc_array( x%z, nnz, ncopy )
                        end if
                     end if
                     allocate( zv(nzv), iv(nzv) )
                     ii = 0
                     do i = 1, x%shape(1)
                        if( data%cmplx(i,1) /= (0.0d0,0.0d0) ) then
                           ii = ii + 1
                           zv(ii) = data%cmplx(i,1)
                           iv(ii) = i
                        end if
                     end do
                     ! data should be a column vector
                     call chgcol_cmplx( x%shape(2), x%z, x%i, x%j, jcol, &
                                        zv, iv )
                  else if( data%data_type == MF_DT_SP_DBLE ) then
                     nzv = data%j(data%shape(2)+1)-1
                     inc = nzv - nzc
                     if( inc > 0 ) then
                        ncopy = x%j(x%shape(2)+1)-1
                        nnz = ncopy + inc
                        if( size(x%i) < nnz ) then
                           call realloc_array( x%i, nnz, ncopy )
                           call realloc_array( x%z, nnz, ncopy )
                        end if
                     end if
                     ! data should be a sparse column vector
                     call chgcol_cmplx_r8( x%shape(2), x%z, x%i, x%j, jcol, &
                                           data%a, data%i, nzv )
                  else if( data%data_type == MF_DT_SP_CMPLX ) then
                     ! first convert the real sparse matrix in complex
                     nzv = data%j(data%shape(2)+1)-1
                     inc = nzv - nzc
                     ncopy = x%j(x%shape(2)+1)-1
                     nnz = ncopy + inc
                     if( inc > 0 ) then
                        call realloc_array( x%i, nnz, ncopy )
                        call realloc_array( x%z, nnz, ncopy )
                     end if
                     ! data should be a column vector
                     call chgcol_cmplx( x%shape(2), x%z, x%i, x%j, jcol, &
                                        data%z, data%i, nzv )
                  end if

               end if

            end if

         else ! data is empty -> we suppress some parts

            if( mfIsSparse(x) ) then
               call PrintMessage( "msSet", "E",                         &
                                  "mfArray cannot be sparse!" )
               go to 99
            end if

            if( minval(i2) < 1 .or. x%shape(2) < maxval(i2) ) then
               call PrintMessage( "msSet", "E",                         &
                                  "deleting : index out of range!" )
               go to 99
            end if
            if( x%status_restricted ) then
               call PrintMessage( "msSet", "E",                         &
                                  "cannot reshape a restricted array" )
               go to 99
            end if
            ! we suppress columns referred by the vector i2
            ! (even if they are multiple defined!)
            tmp = x
            ! computing new size of x
            n2 = 0
            do i = 1, tmp%shape(2)
               if( index_in_vector( i, i2 ) ) cycle
               n2 = n2 + 1
            end do
            if( n2 == 0 ) then
               x = MF_EMPTY
               go to 99
            end if
            x%shape = [ tmp%shape(1), n2 ]
            if( x%data_type == MF_DT_DBLE .or. x%data_type == MF_DT_BOOL ) then
               deallocate( x%double )

               allocate( x%double(tmp%shape(1),n2) )

               ! affectation
               ii = 0
               do i = 1, tmp%shape(2)
                  if( index_in_vector( i, i2 ) ) cycle
                  ii = ii + 1
                  x%double(:,ii) = tmp%double(:,i)
               end do
            else if( x%data_type == MF_DT_CMPLX ) then
               deallocate( x%cmplx )

               allocate( x%cmplx(tmp%shape(1),n2) )

               ! affectation
               ii = 0
               do i = 1, tmp%shape(2)
                  if( index_in_vector( i, i2 ) ) cycle
                  ii = ii + 1
                  x%cmplx(:,ii) = tmp%cmplx(:,i)
               end do
            end if
         end if

         call reset_prop(x%prop)

         if( mf_phys_units ) then
            ! verifying the physical dimension
            call verif_adim( x%units, data%units, status )
            if( status /= 0 ) then
               call PrintMessage( "msSet", "E",                         &
                                  "the physical dimensions of the two mfArray's", &
                                  "are not consistent!" )
               go to 99
            end if
         end if

      else
         call PrintMessage( "msSet", "E",                               &
                            "a1 must be equal to MF_COLON ':' or must be", &
                            "an end-index!" )
         go to 99
      end if

 99   continue

      call msSilentRelease(tmp)

      call msFreeArgs( data, a1 )
      call msAutoRelease( data, a1 )

#endif
   end subroutine msSet_array_section_colon_vec
!_______________________________________________________________________
!
   subroutine msSet_array_section_vec_colon( data, x, i1, a2 )

      type(mfArray) :: data, x
      integer, intent(in) :: i1(:)
      type(mfArray) :: a2
      !------ API end ------

#ifdef _DEVLP
      ! restricted to the case where 'a2' is MF_COLON

      ! Info: this routine is shorter than
      !      'msSet_array_section_colon_vec', because it doesn't
      !       take into account sparse matrices.

      ! extended to the case where 'a2' contains an EndIndex (which is
      ! either the MF_END parameter itself, or an expression
      ! involving integers and MF_END, like 'MF_END-1').

      integer :: i, ii, n1, n2

      type(mfArray) :: tmp
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      call msInitArgs( data, a2 )

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         go to 99
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( data%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting logical item in an mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be sparse!" )
         go to 99
      end if

      if( mfIsSparse(data) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'data' cannot be sparse!" )
         go to 99
      end if

      if( isEndIndex(a2) ) then

         if( mfIsEmpty(data) ) then
            call PrintMessage( "msSet", "E",                            &
                               "'data' cannot be empty!" )
            go to 99
         end if

         n2 = x%shape(2)
         i = n2 + a2%crc
         if( i < 1 .or. n2 < i ) then
            call PrintMessage( "mfGet", "E",                            &
                               "row index is out of range!" )
            go to 99
         end if
         call msSet_array_section_vec_vec(data,x,i1,[i])
         go to 99

      else if( mfIsEqual(a2,MF_COLON) ) then

         if( .not. mfIsEmpty(data) ) then
            if( data%shape(1) /= size(i1) .or. data%shape(2) /= x%shape(2) ) then
               call PrintMessage( "msSet", "E",                         &
                                  "bad size for 'data'!" )
               go to 99
            end if
         end if

         if( minval(i1) < 1 ) then
            call PrintMessage( "msSet", "E",                            &
                               "bad value for min of i1!" )
            go to 99
         end if

         if( .not. mfIsEmpty(data) ) then
            if( maxval(i1) > x%shape(1) ) then

               if( x%status_restricted ) then
                  call PrintMessage( "msSet", "E",                      &
                                     "cannot reshape a restricted array!" )
                  go to 99
               else

                  ! array extension
                  n1 = maxval(i1)
                  n2 = x%shape(2)
                  x%shape = [ n1, n2 ]
                  if( x%data_type == MF_DT_EMPTY ) then
                     if( data%data_type == MF_DT_DBLE ) then
                        call realloc_array( x%double, n1, n2,           &
                                            fill=mf_out_of_range_filling )
                        x%data_type = MF_DT_DBLE
                        x%double(i1,:) = data%double(:,:)
                     else if( data%data_type == MF_DT_CMPLX ) then
                        call realloc_array( x%cmplx, n1, n2,            &
                                            fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                        x%data_type = MF_DT_CMPLX
                        x%cmplx(i1,:) = data%cmplx(:,:)
                     end if
                  else if( x%data_type == MF_DT_DBLE ) then
                     if( data%data_type == MF_DT_DBLE ) then
                        call realloc_array( x%double, n1, n2,           &
                                            fill=mf_out_of_range_filling )
                        x%data_type = MF_DT_DBLE
                        x%double(i1,:) = data%double(:,:)
                     else if( data%data_type == MF_DT_CMPLX ) then
                        call realloc_array( x%double, x%cmplx, n1, n2,  &
                                            fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                        x%data_type = MF_DT_CMPLX
                        x%cmplx(i1,:) = data%cmplx(:,:)
                     end if
                  else if( x%data_type == MF_DT_CMPLX ) then
                     call realloc_array( x%cmplx, n1, n2,               &
                                         fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                     x%data_type = MF_DT_CMPLX
                     if( data%data_type == MF_DT_DBLE ) then
                        x%cmplx(i1,:) = data%double(:,:)
                     else if( data%data_type == MF_DT_CMPLX ) then
                        x%cmplx(i1,:) = data%cmplx(:,:)
                     end if
                  end if

               end if

            else ! matrix x keep the same shape

               if( x%data_type == MF_DT_EMPTY ) then
                  ! this case should have been detected previously;
                  ! here: x%data_type == MF_DT_EMPTY, but with 'shape' /= (0,0)
                  write(STDERR,*) "(MUESLI msSet:) internal ERROR: x%data_type = 0"
                  mf_message_displayed = .true.
                  call muesli_trace( pause="yes" )
                  stop
               else if( x%data_type == MF_DT_DBLE ) then
                  if( data%data_type == MF_DT_DBLE ) then
                     x%data_type = MF_DT_DBLE
                     x%double(i1,:) = data%double(:,:)
                  else if( data%data_type == MF_DT_CMPLX ) then
                     x%data_type = MF_DT_CMPLX
                     allocate( x%cmplx(x%shape(1),x%shape(2)) )

                     x%cmplx(:,:) = x%double(:,:)
                     x%cmplx(i1,:) = data%cmplx(:,:)
                     deallocate( x%double )

                     x%double => null()
                  end if
               else if( x%data_type == MF_DT_CMPLX ) then
                  x%data_type = MF_DT_CMPLX
                  if( data%data_type == MF_DT_DBLE ) then
                     x%cmplx(i1,:) = data%double(:,:)
                  else if( data%data_type == MF_DT_CMPLX ) then
                     x%cmplx(i1,:) = data%cmplx(:,:)
                  end if
               end if
            end if

         else ! data is empty -> we suppress some parts

            if( minval(i1) < 1 .or. x%shape(1) < maxval(i1) ) then
               call PrintMessage( "msSet", "E",                         &
                                  "deleting : index out of range!" )
               go to 99
            end if
            if( x%status_restricted ) then
               call PrintMessage( "msSet", "E",                         &
                                  "cannot reshape a restricted array" )
               go to 99
            end if
            ! we suppress rows referred by the vector i1
            ! (even if they are multiple defined!)
            tmp = x
            ! computing new size of x
            n1 = 0
            do i = 1, tmp%shape(1)
               if( index_in_vector( i, i1 ) ) cycle
               n1 = n1 + 1
            end do
            if( n1 == 0 ) then
               x = MF_EMPTY
               go to 99
            end if
            x%shape = [ n1, tmp%shape(2) ]
            if( x%data_type == MF_DT_DBLE .or. x%data_type == MF_DT_BOOL ) then
               deallocate( x%double )

               allocate( x%double(n1,tmp%shape(2)) )

               ! affectation
               ii = 0
               do i = 1, tmp%shape(1)
                  if( index_in_vector( i, i1 ) ) cycle
                  ii = ii + 1
                  x%double(ii,:) = tmp%double(i,:)
               end do
            else if( x%data_type == MF_DT_CMPLX ) then
               deallocate( x%cmplx )

               allocate( x%cmplx(n1,tmp%shape(2)) )

               ! affectation
               ii = 0
               do i = 1, tmp%shape(1)
                  if( index_in_vector( i, i1 ) ) cycle
                  ii = ii + 1
                  x%cmplx(ii,:) = tmp%cmplx(i,:)
               end do
            end if
         end if

         call reset_prop(x%prop)

         if( mf_phys_units ) then
            ! verifying the physical dimension
            call verif_adim( x%units, data%units, status )
            if( status /= 0 ) then
               call PrintMessage( "msSet", "E",                         &
                                  "the physical dimensions of the two mfArray's", &
                                  "are not consistent!" )
               go to 99
            end if
         end if

      else
         call PrintMessage( "msSet", "E",                               &
                            "a2 must be equal to MF_COLON ':' or must be", &
                            "an end-index!" )
         go to 99
      end if

 99   continue

      call msSilentRelease(tmp)

      call msFreeArgs( data, a2 )
      call msAutoRelease( data, a2 )

#endif
   end subroutine msSet_array_section_vec_colon
!_______________________________________________________________________
!
   subroutine msSet_array_section_colon_vseq( data, x, a1, seq )

      type(mfArray) :: data, x, a1
      type(seq_def) :: seq
      !------ API end ------

#ifdef _DEVLP
      ! restricted to the case where 'a1' is MF_COLON

      ! Warning: this routine may modify a sparse mfArray x,
      !          but one whole column at a time.

      ! extended to the case where 'a1' contains an EndIndex (which is
      ! either the MF_END parameter itself, or an expression
      ! involving integers and MF_END, like 'MF_END-1').

      integer :: i, ii, n1, n2
      integer, pointer :: i2(:) => null()
      integer :: jcol, nzc, nzv, inc, nnz, ncopy
      real(kind=MF_DOUBLE), allocatable :: v(:)
      complex(kind=MF_DOUBLE), allocatable :: zv(:)
      integer, allocatable :: iv(:)

      type(mfArray) :: tmp
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      call msInitArgs( data, a1 )

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         go to 99
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( data%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting logical item in an mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      n2 = x%shape(2)
      if( seq%start_1_EndIndex ) then
         seq%start_1 = n2 + seq%start_1
      end if
      if( seq%end_1_EndIndex ) then
         seq%end_1 = n2 + seq%end_1
      end if
      if( seq%start_2_EndIndex ) then
         seq%start_2 = n2 + seq%start_2
      end if
      if( seq%end_2_EndIndex ) then
         seq%end_2 = n2 + seq%end_2
      end if
      if( seq%but_EndIndex ) then
         seq%but = n2 + seq%but
      end if
      call build_int_seq( i2, seq, "msSet" )

      if( isEndIndex(a1) ) then

         if( mfIsEmpty(data) ) then
            call PrintMessage( "msSet", "E",                            &
                               "'data' cannot be empty!" )
            go to 99
         end if

         n1 = x%shape(1)
         i = n1 + a1%crc
         if( i < 1 .or. n1 < i ) then
            call PrintMessage( "mfGet", "E",                            &
                               "row index is out of range!" )
            go to 99
         end if
         call msSet_array_section_vec_vec(data,x,[i],i2)
         go to 99

      else if( mfIsEqual(a1,MF_COLON) ) then

         if( .not. mfIsEmpty(data) ) then
            if( data%shape(1) /= x%shape(1) .or. data%shape(2) /= size(i2) ) then
               call PrintMessage( "msSet", "E",                         &
                                  "bad size for 'data'!" )
               go to 99
            end if
         end if

         if( minval(i2) < 1 ) then
            call PrintMessage( "msSet", "E",                            &
                               "bad value for min of i2!" )
            go to 99
         end if

         if( .not. mfIsEmpty(data) ) then
            if( maxval(i2) > x%shape(2) ) then

               ! an extension is not possible for SPARSE mfArrays
               if( mfIsSparse(x) ) then
                  call PrintMessage( "msSet", "E",                      &
                                     "mfArray 'x' cannot be sparse!" )
                  go to 99
               end if

               if( x%status_restricted ) then
                  call PrintMessage( "msSet", "E",                      &
                                     "cannot reshape a restricted array!" )
                  go to 99
               else

                  ! array extension
                  n1 = x%shape(1)
                  n2 = maxval(i2)
                  x%shape = [ n1, n2 ]
                  if( x%data_type == MF_DT_EMPTY ) then
                     if( data%data_type == MF_DT_DBLE ) then
                        call realloc_array( x%double, n1, n2,           &
                                            fill=mf_out_of_range_filling )
                        x%data_type = MF_DT_DBLE
                        x%double(:,i2) = data%double(:,:)
                     else if( data%data_type == MF_DT_CMPLX ) then
                        call realloc_array( x%cmplx, n1, n2,            &
                                            fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                        x%data_type = MF_DT_CMPLX
                        x%cmplx(:,i2) = data%cmplx(:,:)
                     end if
                  else if( x%data_type == MF_DT_DBLE ) then
                     if( data%data_type == MF_DT_DBLE ) then
                        call realloc_array( x%double, n1, n2,           &
                                            fill=mf_out_of_range_filling )
                        x%data_type = MF_DT_DBLE
                        x%double(:,i2) = data%double(:,:)
                     else if( data%data_type == MF_DT_CMPLX ) then
                        call realloc_array( x%double, x%cmplx, n1, n2,  &
                                            fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                        x%data_type = MF_DT_CMPLX
                        x%cmplx(:,i2) = data%cmplx(:,:)
                     end if
                  else if( x%data_type == MF_DT_CMPLX ) then
                     call realloc_array( x%cmplx, n1, n2,               &
                                         fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                     x%data_type = MF_DT_CMPLX
                     if( data%data_type == MF_DT_DBLE ) then
                        x%cmplx(:,i2) = data%double(:,:)
                     else if( data%data_type == MF_DT_CMPLX ) then
                        x%cmplx(:,i2) = data%cmplx(:,:)
                     end if
                  end if

               end if

            else ! matrix x keep the same shape

               if( x%data_type == MF_DT_EMPTY ) then
                  ! this case should have been detected previously;
                  ! here: x%data_type == MF_DT_EMPTY, but with 'shape' /= (0,0)
                  write(STDERR,*) "(MUESLI msSet:) internal ERROR: x%data_type = 0"
                  mf_message_displayed = .true.
                  call muesli_trace( pause="yes" )
                  stop
               else if( x%data_type == MF_DT_DBLE ) then
                  if( data%data_type == MF_DT_DBLE ) then
                     x%data_type = MF_DT_DBLE
                     x%double(:,i2) = data%double(:,:)
                  else if( data%data_type == MF_DT_CMPLX ) then
                     x%data_type = MF_DT_CMPLX
                     allocate( x%cmplx(x%shape(1),x%shape(2)) )

                     x%cmplx(:,:) = x%double(:,:)
                     x%cmplx(:,i2) = data%cmplx(:,:)
                     deallocate( x%double )

                     x%double => null()
                  else
                     call PrintMessage( "msSet", "E",                   &
                                        "when 'x' is dense, 'data' cannot be sparse!" )
                     go to 99
                  end if
               else if( x%data_type == MF_DT_CMPLX ) then
                  x%data_type = MF_DT_CMPLX
                  if( data%data_type == MF_DT_DBLE ) then
                     x%cmplx(:,i2) = data%double(:,:)
                  else if( data%data_type == MF_DT_CMPLX ) then
                     x%cmplx(:,i2) = data%cmplx(:,:)
                  else
                     call PrintMessage( "msSet", "E",                   &
                                        "when 'x' is dense, 'data' cannot be sparse!" )
                     go to 99
                  end if
               else if( x%data_type == MF_DT_SP_DBLE ) then

                  ! limite : on change une seule colonne  la fois
                  if( size(i2) /= 1 ) then
                     call PrintMessage( "msSet", "E",                   &
                                        "for a sparse matrix, you can change only", &
                                        "one column at a time!" )
                     go to 99
                  end if
                  jcol = i2(1)

                  nzc = x%j(jcol+1) - x%j(jcol)
                  if( data%data_type == MF_DT_DBLE ) then
                     nzv = count( data%double(:,1) /= 0.0d0 )
                     inc = nzv - nzc
                     if( inc > 0 ) then
                        ncopy = x%j(x%shape(2)+1)-1
                        nnz = ncopy + inc
                        if( size(x%i) < nnz ) then
                           call realloc_array( x%i, nnz, ncopy )
                           call realloc_array( x%a, nnz, ncopy )
                        end if
                     end if
                     allocate( v(nzv), iv(nzv) )
                     ii = 0
                     do i = 1, x%shape(1)
                        if( data%double(i,1) /= 0.0d0 ) then
                           ii = ii + 1
                           v(ii) = data%double(i,1)
                           iv(ii) = i
                        end if
                     end do
                     ! data should be a column vector
                     call chgcol( x%shape(2), x%a, x%i, x%j, jcol, v, iv )
                  else if( data%data_type == MF_DT_CMPLX ) then
                     x%data_type = MF_DT_SP_CMPLX
                     ! first convert the real sparse matrix in complex
                     nzv = count( data%cmplx(:,1) /= (0.0d0,0.0d0) )
                     inc = nzv - nzc
                     ncopy = x%j(x%shape(2)+1)-1
                     nnz = ncopy + inc
                     if( inc > 0 .and. size(x%i) < nnz ) then
                        call realloc_array( x%i, nnz, ncopy )
                        call realloc_array( x%a, x%z, nnz, ncopy )
                     else
                        call realloc_array( x%a, x%z, size(x%a), ncopy )
                     end if
                     allocate( zv(nzv), iv(nzv) )
                     ii = 0
                     do i = 1, x%shape(1)
                        if( data%cmplx(i,1) /= (0.0d0,0.0d0) ) then
                           ii = ii + 1
                           zv(ii) = data%cmplx(i,1)
                           iv(ii) = i
                        end if
                     end do
                     ! data should be a column vector
                     call chgcol_cmplx( x%shape(2), x%z, x%i, x%j, jcol, &
                                        zv, iv )
                  else if( data%data_type == MF_DT_SP_DBLE ) then
                     nzv = data%j(data%shape(2)+1)-1
                     inc = nzv - nzc
                     if( inc > 0 ) then
                        ncopy = x%j(x%shape(2)+1)-1
                        nnz = ncopy + inc
                        if( size(x%i) < nnz ) then
                           call realloc_array( x%i, nnz, ncopy )
                           call realloc_array( x%a, nnz, ncopy )
                        end if
                     end if
                     ! data should be a sparse column vector
                     call chgcol( x%shape(2), x%a, x%i, x%j, jcol,      &
                                  data%a, data%i, nzv )
                  else if( data%data_type == MF_DT_SP_CMPLX ) then
                     x%data_type = MF_DT_SP_CMPLX
                     ! first convert the real sparse matrix in complex
                     nzv = data%j(data%shape(2)+1)-1
                     inc = nzv - nzc
                     ncopy = x%j(x%shape(2)+1)-1
                     nnz = ncopy + inc
                     if( inc > 0 .and. size(x%i) < nnz ) then
                        call realloc_array( x%i, nnz, ncopy )
                        call realloc_array( x%a, x%z, nnz, ncopy )
                     else
                        call realloc_array( x%a, x%z, size(x%a), ncopy )
                     end if
                     ! data should be a column vector
                     call chgcol_cmplx( x%shape(2), x%z, x%i, x%j, jcol, &
                                        data%z, data%i, nzv )
                  end if

               else if( x%data_type == MF_DT_SP_CMPLX ) then

                  ! limite : on change une seule colonne  la fois
                  if( size(i2) /= 1 ) then
                     call PrintMessage( "msSet", "E",                   &
                                        "for a sparse matrix, you can change only", &
                                        "one column at a time!" )
                     go to 99
                  end if
                  jcol = i2(1)

                  nzc = x%j(jcol+1) - x%j(jcol)
                  if( data%data_type == MF_DT_DBLE ) then
                     nzv = count( data%double(:,1) /= 0.0d0 )
                     inc = nzv - nzc
                     if( inc > 0 ) then
                        ncopy = x%j(x%shape(2)+1)-1
                        nnz = ncopy + inc
                        if( size(x%i) < nnz ) then
                           call realloc_array( x%i, nnz, ncopy )
                           call realloc_array( x%z, nnz, ncopy )
                        end if
                     end if
                     allocate( zv(nzv), iv(nzv) )
                     ii = 0
                     do i = 1, x%shape(1)
                        if( data%double(i,1) /= 0.0d0 ) then
                           ii = ii + 1
                           zv(ii) = data%double(i,1)
                           iv(ii) = i
                        end if
                     end do
                     ! data should be a column vector
                     call chgcol_cmplx( x%shape(2), x%z, x%i, x%j, jcol, &
                                        zv, iv )
                  else if( data%data_type == MF_DT_CMPLX ) then
                     nzv = count( data%cmplx(:,1) /= (0.0d0,0.0d0) )
                     inc = nzv - nzc
                     if( inc > 0 ) then
                        ncopy = x%j(x%shape(2)+1)-1
                        nnz = ncopy + inc
                        if( size(x%i) < nnz ) then
                           call realloc_array( x%i, nnz, ncopy )
                           call realloc_array( x%z, nnz, ncopy )
                        end if
                     end if
                     allocate( zv(nzv), iv(nzv) )
                     ii = 0
                     do i = 1, x%shape(1)
                        if( data%cmplx(i,1) /= (0.0d0,0.0d0) ) then
                           ii = ii + 1
                           zv(ii) = data%cmplx(i,1)
                           iv(ii) = i
                        end if
                     end do
                     ! data should be a column vector
                     call chgcol_cmplx( x%shape(2), x%z, x%i, x%j, jcol, &
                                        zv, iv )
                  else if( data%data_type == MF_DT_SP_DBLE ) then
                     nzv = data%j(data%shape(2)+1)-1
                     inc = nzv - nzc
                     if( inc > 0 ) then
                        ncopy = x%j(x%shape(2)+1)-1
                        nnz = ncopy + inc
                        if( size(x%i) < nnz ) then
                           call realloc_array( x%i, nnz, ncopy )
                           call realloc_array( x%z, nnz, ncopy )
                        end if
                     end if
                     ! data should be a sparse column vector
                     call chgcol_cmplx_r8( x%shape(2), x%z, x%i, x%j, jcol, &
                                           data%a, data%i, nzv )
                  else if( data%data_type == MF_DT_SP_CMPLX ) then
                     ! first convert the real sparse matrix in complex
                     nzv = data%j(data%shape(2)+1)-1
                     inc = nzv - nzc
                     ncopy = x%j(x%shape(2)+1)-1
                     nnz = ncopy + inc
                     if( inc > 0 ) then
                        call realloc_array( x%i, nnz, ncopy )
                        call realloc_array( x%z, nnz, ncopy )
                     end if
                     ! data should be a column vector
                     call chgcol_cmplx( x%shape(2), x%z, x%i, x%j, jcol, &
                                        data%z, data%i, nzv )
                  end if

               end if

            end if

         else ! data is empty -> we suppress some parts

            if( mfIsSparse(x) ) then
               call PrintMessage( "msSet", "E",                         &
                                  "mfArray cannot be sparse!" )
               go to 99
            end if

            if( minval(i2) < 1 .or. x%shape(2) < maxval(i2) ) then
               call PrintMessage( "msSet", "E",                         &
                                  "deleting : index out of range!" )
               go to 99
            end if
            if( x%status_restricted ) then
               call PrintMessage( "msSet", "E",                         &
                                  "cannot reshape a restricted array" )
               go to 99
            end if
            ! we suppress columns referred by the vector i2
            ! (even if they are multiple defined!)
            tmp = x
            ! computing new size of x
            n2 = 0
            do i = 1, tmp%shape(2)
               if( index_in_vector( i, i2 ) ) cycle
               n2 = n2 + 1
            end do
            if( n2 == 0 ) then
               x = MF_EMPTY
               go to 99
            end if
            x%shape = [ tmp%shape(1), n2 ]
            if( x%data_type == MF_DT_DBLE .or. x%data_type == MF_DT_BOOL ) then
               deallocate( x%double )

               allocate( x%double(tmp%shape(1),n2) )

               ! affectation
               ii = 0
               do i = 1, tmp%shape(2)
                  if( index_in_vector( i, i2 ) ) cycle
                  ii = ii + 1
                  x%double(:,ii) = tmp%double(:,i)
               end do
            else if( x%data_type == MF_DT_CMPLX ) then
               deallocate( x%cmplx )

               allocate( x%cmplx(tmp%shape(1),n2) )

               ! affectation
               ii = 0
               do i = 1, tmp%shape(2)
                  if( index_in_vector( i, i2 ) ) cycle
                  ii = ii + 1
                  x%cmplx(:,ii) = tmp%cmplx(:,i)
               end do
            end if
         end if

         call reset_prop(x%prop)

         if( mf_phys_units ) then
            ! verifying the physical dimension
            call verif_adim( x%units, data%units, status )
            if( status /= 0 ) then
               call PrintMessage( "msSet", "E",                         &
                                  "the physical dimensions of the two mfArray's", &
                                  "are not consistent!" )
               go to 99
            end if
         end if

      else
         call PrintMessage( "msSet", "E",                               &
                            "a1 must be equal to MF_COLON ':' or must be", &
                            "an end-index!" )
         go to 99
      end if

 99   continue

      if( associated(i2) ) then
#ifndef _TRACE_MEM_ALLOC
         deallocate( i2 )
#else
         call mf_deallocate( array=i2,                                  &
                             file="Set.inc", line="???",                &
                             symb="i2", unit="msSet_array_section_colon_vseq" )
#endif
      end if

      call msSilentRelease(tmp)

      call msFreeArgs( data, a1 )
      call msAutoRelease( data, a1 )

#endif
   end subroutine msSet_array_section_colon_vseq
!_______________________________________________________________________
!
   subroutine msSet_array_section_vseq_colon( data, x, seq, a2 )

      type(mfArray) :: data, x
      type(seq_def) :: seq
      type(mfArray) :: a2
      !------ API end ------

#ifdef _DEVLP
      ! restricted to the case where 'a2' is MF_COLON

      ! Info: this routine is shorter than
      !      'msSet_array_section_colon_vseq', because it doesn't
      !       take into account sparse matrices.

      ! extended to the case where 'a2' contains an EndIndex (which is
      ! either the MF_END parameter itself, or an expression
      ! involving integers and MF_END, like 'MF_END-1').

      integer :: i, ii, n1, n2
      integer, pointer :: i1(:) => null()

      type(mfArray) :: tmp
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      call msInitArgs( data, a2 )

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         go to 99
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( data%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting logical item in an mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be sparse!" )
         go to 99
      end if

      if( mfIsSparse(data) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'data' cannot be sparse!" )
         go to 99
      end if

      n1 = x%shape(1)
      if( seq%start_1_EndIndex ) then
         seq%start_1 = n1 + seq%start_1
      end if
      if( seq%end_1_EndIndex ) then
         seq%end_1 = n1 + seq%end_1
      end if
      if( seq%start_2_EndIndex ) then
         seq%start_2 = n1 + seq%start_2
      end if
      if( seq%end_2_EndIndex ) then
         seq%end_2 = n1 + seq%end_2
      end if
      if( seq%but_EndIndex ) then
         seq%but = n1 + seq%but
      end if
      call build_int_seq( i1, seq, "msSet" )

      if( isEndIndex(a2) ) then

         if( mfIsEmpty(data) ) then
            call PrintMessage( "msSet", "E",                            &
                               "'data' cannot be empty!" )
            go to 99
         end if

         n2 = x%shape(2)
         i = n2 + a2%crc
         if( i < 1 .or. n2 < i ) then
            call PrintMessage( "mfGet", "E",                            &
                               "row index is out of range!" )
            go to 99
         end if
         call msSet_array_section_vec_vec(data,x,i1,[i])
         go to 99

      else if( mfIsEqual(a2,MF_COLON) ) then

         if( .not. mfIsEmpty(data) ) then
            if( data%shape(1) /= size(i1) .or. data%shape(2) /= x%shape(2) ) then
               call PrintMessage( "msSet", "E",                         &
                                  "bad size for 'data'!" )
               go to 99
            end if
         end if

         if( minval(i1) < 1 ) then
            call PrintMessage( "msSet", "E",                            &
                               "bad value for min of i1!" )
            go to 99
         end if

         if( .not. mfIsEmpty(data) ) then
            if( maxval(i1) > x%shape(1) ) then

               if( x%status_restricted ) then
                  call PrintMessage( "msSet", "E",                      &
                                     "cannot reshape a restricted array!" )
                  go to 99
               else

                  ! array extension
                  n1 = maxval(i1)
                  n2 = x%shape(2)
                  x%shape = [ n1, n2 ]
                  if( x%data_type == MF_DT_EMPTY ) then
                     if( data%data_type == MF_DT_DBLE ) then
                        call realloc_array( x%double, n1, n2,           &
                                            fill=mf_out_of_range_filling )
                        x%data_type = MF_DT_DBLE
                        x%double(i1,:) = data%double(:,:)
                     else if( data%data_type == MF_DT_CMPLX ) then
                        call realloc_array( x%cmplx, n1, n2,            &
                                            fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                        x%data_type = MF_DT_CMPLX
                        x%cmplx(i1,:) = data%cmplx(:,:)
                     end if
                  else if( x%data_type == MF_DT_DBLE ) then
                     if( data%data_type == MF_DT_DBLE ) then
                        call realloc_array( x%double, n1, n2,           &
                                            fill=mf_out_of_range_filling )
                        x%data_type = MF_DT_DBLE
                        x%double(i1,:) = data%double(:,:)
                     else if( data%data_type == MF_DT_CMPLX ) then
                        call realloc_array( x%double, x%cmplx, n1, n2,  &
                                            fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                        x%data_type = MF_DT_CMPLX
                        x%cmplx(i1,:) = data%cmplx(:,:)
                     end if
                  else if( x%data_type == MF_DT_CMPLX ) then
                     call realloc_array( x%cmplx, n1, n2,               &
                                         fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                     x%data_type = MF_DT_CMPLX
                     if( data%data_type == MF_DT_DBLE ) then
                        x%cmplx(i1,:) = data%double(:,:)
                     else if( data%data_type == MF_DT_CMPLX ) then
                        x%cmplx(i1,:) = data%cmplx(:,:)
                     end if
                  end if

               end if

            else ! matrix x keep the same shape

               if( x%data_type == MF_DT_EMPTY ) then
                  ! this case should have been detected previously;
                  ! here: x%data_type == MF_DT_EMPTY, but with 'shape' /= (0,0)
                  write(STDERR,*) "(MUESLI msSet:) internal ERROR: x%data_type = 0"
                  mf_message_displayed = .true.
                  call muesli_trace( pause="yes" )
                  stop
               else if( x%data_type == MF_DT_DBLE ) then
                  if( data%data_type == MF_DT_DBLE ) then
                     x%data_type = MF_DT_DBLE
                     x%double(i1,:) = data%double(:,:)
                  else if( data%data_type == MF_DT_CMPLX ) then
                     x%data_type = MF_DT_CMPLX
                     allocate( x%cmplx(x%shape(1),x%shape(2)) )

                     x%cmplx(:,:) = x%double(:,:)
                     x%cmplx(i1,:) = data%cmplx(:,:)
                     deallocate( x%double )

                     x%double => null()
                  end if
               else if( x%data_type == MF_DT_CMPLX ) then
                  x%data_type = MF_DT_CMPLX
                  if( data%data_type == MF_DT_DBLE ) then
                     x%cmplx(i1,:) = data%double(:,:)
                  else if( data%data_type == MF_DT_CMPLX ) then
                     x%cmplx(i1,:) = data%cmplx(:,:)
                  end if
               end if
            end if

         else ! data is empty -> we suppress some parts

            if( minval(i1) < 1 .or. x%shape(1) < maxval(i1) ) then
               call PrintMessage( "msSet", "E",                         &
                                  "deleting : index out of range!" )
               go to 99
            end if
            if( x%status_restricted ) then
               call PrintMessage( "msSet", "E",                         &
                                  "cannot reshape a restricted array" )
               go to 99
            end if
            ! we suppress rows referred by the vector i1
            ! (even if they are multiple defined!)
            tmp = x
            ! computing new size of x
            n1 = 0
            do i = 1, tmp%shape(1)
               if( index_in_vector( i, i1 ) ) cycle
               n1 = n1 + 1
            end do
            if( n1 == 0 ) then
               x = MF_EMPTY
               go to 99
            end if
            x%shape = [ n1, tmp%shape(2) ]
            if( x%data_type == MF_DT_DBLE .or. x%data_type == MF_DT_BOOL ) then
               deallocate( x%double )

               allocate( x%double(n1,tmp%shape(2)) )

               ! affectation
               ii = 0
               do i = 1, tmp%shape(1)
                  if( index_in_vector( i, i1 ) ) cycle
                  ii = ii + 1
                  x%double(ii,:) = tmp%double(i,:)
               end do
            else if( x%data_type == MF_DT_CMPLX ) then
               deallocate( x%cmplx )

               allocate( x%cmplx(n1,tmp%shape(2)) )

               ! affectation
               ii = 0
               do i = 1, tmp%shape(1)
                  if( index_in_vector( i, i1 ) ) cycle
                  ii = ii + 1
                  x%cmplx(ii,:) = tmp%cmplx(i,:)
               end do
            end if
         end if

         call reset_prop(x%prop)

         if( mf_phys_units ) then
            ! verifying the physical dimension
            call verif_adim( x%units, data%units, status )
            if( status /= 0 ) then
               call PrintMessage( "msSet", "E",                         &
                                  "the physical dimensions of the two mfArray's", &
                                  "are not consistent!" )
               go to 99
            end if
         end if

      else
         call PrintMessage( "msSet", "E",                               &
                            "a2 must be equal to MF_COLON ':' or must be", &
                            "an end-index!" )
         go to 99
      end if

 99   continue

      if( associated(i1) ) then
#ifndef _TRACE_MEM_ALLOC
         deallocate( i1 )
#else
         call mf_deallocate( array=i1,                                  &
                             file="Set.inc", line="???",                &
                             symb="i1", unit="msSet_array_section_vseq_colon" )
#endif
      end if

      call msSilentRelease(tmp)

      call msFreeArgs( data, a2 )
      call msAutoRelease( data, a2 )

#endif
   end subroutine msSet_array_section_vseq_colon
!_______________________________________________________________________
!
   subroutine msSet_array_section_colon_int( data, x, a1, i2 )

      type(mfArray) :: data, x, a1
      integer, intent(in) :: i2
      !------ API end ------

#ifdef _DEVLP
      ! restricted to the case where 'a1' is MF_COLON

      ! extended to the case where 'a1' contains an EndIndex (which is
      ! either the MF_END parameter itself, or an expression
      ! involving integers and MF_END, like 'MF_END-1').

      integer :: i, ii, n1, n2
      integer :: jcol, nzc, nzv, inc, nnz, ncopy
      real(kind=MF_DOUBLE), allocatable :: v(:)
      complex(kind=MF_DOUBLE), allocatable :: zv(:)
      integer, allocatable :: iv(:)

      type(mfArray) :: tmp
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      call msInitArgs( data, a1 )

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         go to 99
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( data%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting logical item in an mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( isEndIndex(a1) ) then

         if( mfIsEmpty(data) ) then
            call PrintMessage( "msSet", "E",                            &
                               "'data' cannot be empty!" )
            go to 99
         end if

         n1 = x%shape(1)
         i = n1 + a1%crc
         if( i < 1 .or. n1 < i ) then
            call PrintMessage( "mfGet", "E",                            &
                               "row index is out of range!" )
            go to 99
         end if
         call msSet_array_element(data,x,i,i2)
         go to 99

      else if( mfIsEqual(a1,MF_COLON) ) then

         if( .not. mfIsEmpty(data) ) then
            if( data%shape(1) /= x%shape(1) .or. data%shape(2) /= 1 ) then
               call PrintMessage( "msSet", "E",                         &
                                  "bad size for 'data'!",               &
                                  "(it must contain only one column)" )
               go to 99
            end if
         end if

         if( i2 < 1 ) then
            call PrintMessage( "msSet", "E",                            &
                               "bad value for i2!" )
            go to 99
         end if

         if( .not. mfIsEmpty(data) ) then
            if( i2 > x%shape(2) ) then

               ! an extension is not possible for SPARSE mfArrays
               if( mfIsSparse(x) ) then
                  call PrintMessage( "msSet", "E",                      &
                                     "mfArray 'x' cannot be sparse!" )
                  go to 99
               end if

               if( x%status_restricted ) then
                  call PrintMessage( "msSet", "E",                      &
                                     "cannot reshape a restricted array!" )
                  go to 99
               else

                  ! array extension
                  n1 = x%shape(1)
                  n2 = i2
                  x%shape = [ n1, n2 ]
                  if( x%data_type == MF_DT_EMPTY ) then
                     if( data%data_type == MF_DT_DBLE ) then
                        call realloc_array( x%double, n1, n2,           &
                                            fill=mf_out_of_range_filling )
                        x%data_type = MF_DT_DBLE
                        x%double(:,i2) = data%double(:,1)
                     else if( data%data_type == MF_DT_CMPLX ) then
                        call realloc_array( x%cmplx, n1, n2,            &
                                            fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                        x%data_type = MF_DT_CMPLX
                        x%cmplx(:,i2) = data%cmplx(:,1)
                     end if
                  else if( x%data_type == MF_DT_DBLE ) then
                     if( data%data_type == MF_DT_DBLE ) then
                        call realloc_array( x%double, n1, n2,           &
                                            fill=mf_out_of_range_filling )
                        x%data_type = MF_DT_DBLE
                        x%double(:,i2) = data%double(:,1)
                     else if( data%data_type == MF_DT_CMPLX ) then
                        call realloc_array( x%double, x%cmplx, n1, n2,  &
                                            fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                        x%data_type = MF_DT_CMPLX
                        x%cmplx(:,i2) = data%cmplx(:,1)
                     end if
                  else if( x%data_type == MF_DT_CMPLX ) then
                     call realloc_array( x%cmplx, n1, n2,               &
                                         fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                     x%data_type = MF_DT_CMPLX
                     if( data%data_type == MF_DT_DBLE ) then
                        x%cmplx(:,i2) = data%double(:,1)
                     else if( data%data_type == MF_DT_CMPLX ) then
                        x%cmplx(:,i2) = data%cmplx(:,1)
                     end if
                  end if

               end if

            else ! matrix x keep the same shape

               if( x%data_type == MF_DT_EMPTY ) then
                  ! this case should have been detected previously;
                  ! here: x%data_type == MF_DT_EMPTY, but with 'shape' /= (0,0)
                  write(STDERR,*) "(MUESLI msSet:) internal ERROR: x%data_type = 0"
                  mf_message_displayed = .true.
                  call muesli_trace( pause="yes" )
                  stop
               else if( x%data_type == MF_DT_DBLE ) then
                  if( data%data_type == MF_DT_DBLE ) then
                     x%data_type = MF_DT_DBLE
                     x%double(:,i2) = data%double(:,1)
                  else if( data%data_type == MF_DT_CMPLX ) then
                     x%data_type = MF_DT_CMPLX
                     allocate( x%cmplx(x%shape(1),x%shape(2)) )

                     x%cmplx(:,:) = x%double(:,:)
                     x%cmplx(:,i2) = data%cmplx(:,1)
                     deallocate( x%double )

                     x%double => null()
                  else
                     call PrintMessage( "msSet", "E",                   &
                                        "when 'x' is dense, 'data' cannot be sparse!" )
                     go to 99
                  end if
               else if( x%data_type == MF_DT_CMPLX ) then
                  x%data_type = MF_DT_CMPLX
                  if( data%data_type == MF_DT_DBLE ) then
                     x%cmplx(:,i2) = data%double(:,1)
                  else if( data%data_type == MF_DT_CMPLX ) then
                     x%cmplx(:,i2) = data%cmplx(:,1)
                  else
                     call PrintMessage( "msSet", "E",                   &
                                        "when 'x' is dense, 'data' cannot be sparse!" )
                     go to 99
                  end if
               else if( x%data_type == MF_DT_SP_DBLE ) then

                  jcol = i2

                  nzc = x%j(jcol+1) - x%j(jcol)
                  if( data%data_type == MF_DT_DBLE ) then
                     nzv = count( data%double(:,1) /= 0.0d0 )
                     inc = nzv - nzc
                     if( inc > 0 ) then
                        ncopy = x%j(x%shape(2)+1)-1
                        nnz = ncopy + inc
                        if( size(x%i) < nnz ) then
                           call realloc_array( x%i, nnz, ncopy )
                           call realloc_array( x%a, nnz, ncopy )
                        end if
                     end if
                     allocate( v(nzv), iv(nzv) )
                     ii = 0
                     do i = 1, x%shape(1)
                        if( data%double(i,1) /= 0.0d0 ) then
                           ii = ii + 1
                           v(ii) = data%double(i,1)
                           iv(ii) = i
                        end if
                     end do
                     ! data should be a column vector
                     call chgcol( x%shape(2), x%a, x%i, x%j, jcol, v, iv )
                  else if( data%data_type == MF_DT_CMPLX ) then
                     x%data_type = MF_DT_SP_CMPLX
                     ! first convert the real sparse matrix in complex
                     nzv = count( data%cmplx(:,1) /= (0.0d0,0.0d0) )
                     inc = nzv - nzc
                     ncopy = x%j(x%shape(2)+1)-1
                     nnz = ncopy + inc
                     if( inc > 0 .and. size(x%i) < nnz ) then
                        call realloc_array( x%i, nnz, ncopy )
                        call realloc_array( x%a, x%z, nnz, ncopy )
                     else
                        call realloc_array( x%a, x%z, size(x%a), ncopy )
                     end if
                     allocate( zv(nzv), iv(nzv) )
                     ii = 0
                     do i = 1, x%shape(1)
                        if( data%cmplx(i,1) /= (0.0d0,0.0d0) ) then
                           ii = ii + 1
                           zv(ii) = data%cmplx(i,1)
                           iv(ii) = i
                        end if
                     end do
                     ! data should be a column vector
                     call chgcol_cmplx( x%shape(2), x%z, x%i, x%j, jcol, &
                                        zv, iv )
                  else if( data%data_type == MF_DT_SP_DBLE ) then
                     nzv = data%j(data%shape(2)+1)-1
                     inc = nzv - nzc
                     if( inc > 0 ) then
                        ncopy = x%j(x%shape(2)+1)-1
                        nnz = ncopy + inc
                        if( size(x%i) < nnz ) then
                           call realloc_array( x%i, nnz, ncopy )
                           call realloc_array( x%a, nnz, ncopy )
                        end if
                     end if
                     ! data should be a sparse column vector
                     call chgcol( x%shape(2), x%a, x%i, x%j, jcol,      &
                                  data%a, data%i, nzv )
                  else if( data%data_type == MF_DT_SP_CMPLX ) then
                     x%data_type = MF_DT_SP_CMPLX
                     ! first convert the real sparse matrix in complex
                     nzv = data%j(data%shape(2)+1)-1
                     inc = nzv - nzc
                     ncopy = x%j(x%shape(2)+1)-1
                     nnz = ncopy + inc
                     if( inc > 0 .and. size(x%i) < nnz ) then
                        call realloc_array( x%i, nnz, ncopy )
                        call realloc_array( x%a, x%z, nnz, ncopy )
                     else
                        call realloc_array( x%a, x%z, size(x%a), ncopy )
                     end if
                     ! data should be a column vector
                     call chgcol_cmplx( x%shape(2), x%z, x%i, x%j, jcol, &
                                        data%z, data%i, nzv )
                  end if

               else if( x%data_type == MF_DT_SP_CMPLX ) then

                  jcol = i2

                  nzc = x%j(jcol+1) - x%j(jcol)
                  if( data%data_type == MF_DT_DBLE ) then
                     nzv = count( data%double(:,1) /= 0.0d0 )
                     inc = nzv - nzc
                     if( inc > 0 ) then
                        ncopy = x%j(x%shape(2)+1)-1
                        nnz = ncopy + inc
                        if( size(x%i) < nnz ) then
                           call realloc_array( x%i, nnz, ncopy )
                           call realloc_array( x%z, nnz, ncopy )
                        end if
                     end if
                     allocate( zv(nzv), iv(nzv) )
                     ii = 0
                     do i = 1, x%shape(1)
                        if( data%double(i,1) /= 0.0d0 ) then
                           ii = ii + 1
                           zv(ii) = data%double(i,1)
                           iv(ii) = i
                        end if
                     end do
                     ! data should be a column vector
                     call chgcol_cmplx( x%shape(2), x%z, x%i, x%j, jcol, &
                                        zv, iv )
                  else if( data%data_type == MF_DT_CMPLX ) then
                     nzv = count( data%cmplx(:,1) /= (0.0d0,0.0d0) )
                     inc = nzv - nzc
                     if( inc > 0 ) then
                        ncopy = x%j(x%shape(2)+1)-1
                        nnz = ncopy + inc
                        if( size(x%i) < nnz ) then
                           call realloc_array( x%i, nnz, ncopy )
                           call realloc_array( x%z, nnz, ncopy )
                        end if
                     end if
                     allocate( zv(nzv), iv(nzv) )
                     ii = 0
                     do i = 1, x%shape(1)
                        if( data%cmplx(i,1) /= (0.0d0,0.0d0) ) then
                           ii = ii + 1
                           zv(ii) = data%cmplx(i,1)
                           iv(ii) = i
                        end if
                     end do
                     ! data should be a column vector
                     call chgcol_cmplx( x%shape(2), x%z, x%i, x%j, jcol, &
                                        zv, iv )
                  else if( data%data_type == MF_DT_SP_DBLE ) then
                     nzv = data%j(data%shape(2)+1)-1
                     inc = nzv - nzc
                     if( inc > 0 ) then
                        ncopy = x%j(x%shape(2)+1)-1
                        nnz = ncopy + inc
                        if( size(x%i) < nnz ) then
                           call realloc_array( x%i, nnz, ncopy )
                           call realloc_array( x%z, nnz, ncopy )
                        end if
                     end if
                     ! data should be a sparse column vector
                     call chgcol_cmplx_r8( x%shape(2), x%z, x%i, x%j, jcol, &
                                           data%a, data%i, nzv )
                  else if( data%data_type == MF_DT_SP_CMPLX ) then
                     ! first convert the real sparse matrix in complex
                     nzv = data%j(data%shape(2)+1)-1
                     inc = nzv - nzc
                     ncopy = x%j(x%shape(2)+1)-1
                     nnz = ncopy + inc
                     if( inc > 0 ) then
                        call realloc_array( x%i, nnz, ncopy )
                        call realloc_array( x%z, nnz, ncopy )
                     end if
                     ! data should be a column vector
                     call chgcol_cmplx( x%shape(2), x%z, x%i, x%j, jcol, &
                                        data%z, data%i, nzv )
                  end if

               end if

            end if

         else ! data is empty -> we suppress some parts

            if( mfIsSparse(x) ) then
               call PrintMessage( "msSet", "E",                         &
                                  "mfArray cannot be sparse!" )
               go to 99
            end if

            if( i2 < 1 .or. x%shape(2) < i2 ) then
               call PrintMessage( "msSet", "E",                         &
                                  "deleting : index out of range!" )
               go to 99
            end if
            if( x%status_restricted ) then
               call PrintMessage( "msSet", "E",                         &
                                  "cannot reshape a restricted array" )
               go to 99
            end if
            ! we suppress the column i2;
            tmp = x
            ! computing new size of x
            n2 = x%shape(2) - 1
            if( n2 == 0 ) then
               x = MF_EMPTY
               go to 99
            end if
            x%shape = [ tmp%shape(1), n2 ]
            if( x%data_type == MF_DT_DBLE .or. x%data_type == MF_DT_BOOL ) then
               deallocate( x%double )
               allocate( x%double(tmp%shape(1),n2) )
               ! affectation
               ii = 0
               do i = 1, tmp%shape(2)
                  if( i == i2 ) cycle
                  ii = ii + 1
                  x%double(:,ii) = tmp%double(:,i)
               end do
            else if( x%data_type == MF_DT_CMPLX ) then
               deallocate( x%cmplx )
               allocate( x%cmplx(tmp%shape(1),n2) )
               ! affectation
               ii = 0
               do i = 1, tmp%shape(2)
                  if( i == i2 ) cycle
                  ii = ii + 1
                  x%cmplx(:,ii) = tmp%cmplx(:,i)
               end do
            end if
         end if

         call reset_prop(x%prop)

         if( mf_phys_units ) then
            ! verifying the physical dimension
            call verif_adim( x%units, data%units, status )
            if( status /= 0 ) then
               call PrintMessage( "msSet", "E",                         &
                                  "the physical dimensions of the two mfArray's", &
                                  "are not consistent!" )
               go to 99
            end if
         end if

      else
         call PrintMessage( "msSet", "E",                               &
                            "a1 must be equal to MF_COLON ':' or must be", &
                            "an end-index!" )
         go to 99
      end if

 99   continue

      call msSilentRelease(tmp)

      call msFreeArgs( data, a1 )
      call msAutoRelease( data, a1 )

#endif
   end subroutine msSet_array_section_colon_int
!_______________________________________________________________________
!
   subroutine msSet_array_section_int_colon( data, x, i1, a2 )

      type(mfArray) :: data, x
      integer, intent(in) :: i1
      type(mfArray) :: a2
      !------ API end ------

#ifdef _DEVLP
      ! restricted to the case where 'a2' is MF_COLON

      ! Info: this routine is shorter than
      !      'msSet_array_section_colon_int', because it doesn't
      !       take into account sparse matrices.

      ! extended to the case where 'a2' contains an EndIndex (which is
      ! either the MF_END parameter itself, or an expression
      ! involving integers and MF_END, like 'MF_END-1').

      integer :: i, ii, n1, n2

      type(mfArray) :: tmp
      integer :: status
      logical :: must_spread

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      call msInitArgs( data, a2 )

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         go to 99
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( data%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting logical item in an mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be sparse!" )
         go to 99
      end if

      if( mfIsSparse(data) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'data' cannot be sparse!" )
         go to 99
      end if

      if( isEndIndex(a2) ) then

         if( mfIsEmpty(data) ) then
            call PrintMessage( "msSet", "E",                            &
                               "'data' cannot be empty!" )
            go to 99
         end if

         n2 = x%shape(2)
         i = n2 + a2%crc
         if( i < 1 .or. n2 < i ) then
            call PrintMessage( "mfGet", "E",                            &
                               "row index is out of range!" )
            go to 99
         end if
         call msSet_array_element(data,x,i1,i)
         go to 99

      else if( mfIsEqual(a2,MF_COLON) ) then

         if( .not. mfIsEmpty(data) ) then
            if( data%shape(1) /= 1 ) then
               call PrintMessage( "msSet", "E",                         &
                                  "bad size for 'data'!",               &
                                  "(it must contain only one row)" )
               go to 99
            end if
            if( data%shape(2) /= 1 .and. data%shape(2) /= x%shape(2) ) then
               call PrintMessage( "msSet", "E",                         &
                                  "bad size for 'data'!",               &
                                  "(the row has a bad number of elements)" )
               go to 99
            end if
         end if

         if( data%shape(1) == 1 .and. data%shape(2) == 1 ) then
            must_spread = .true.
         else
            must_spread = .false.
         end if

         if( i1 < 1 ) then
            call PrintMessage( "msSet", "E",                            &
                               "bad value for i1!" )
            go to 99
         end if

         if( .not. mfIsEmpty(data) ) then
            if( i1 > x%shape(1) ) then

               if( x%status_restricted ) then
                  call PrintMessage( "msSet", "E",                      &
                                     "cannot reshape a restricted array!" )
                  go to 99
               else

                  ! array extension
                  n1 = i1
                  n2 = x%shape(2)
                  x%shape = [ n1, n2 ]
                  if( x%data_type == MF_DT_EMPTY ) then
                     if( data%data_type == MF_DT_DBLE ) then
                        call realloc_array( x%double, n1, n2,           &
                                            fill=mf_out_of_range_filling )
                        x%data_type = MF_DT_DBLE
                        if( must_spread ) then
                           x%double(i1,:) = data%double(1,1)
                        else
                           x%double(i1,:) = data%double(1,:)
                        end if
                     else if( data%data_type == MF_DT_CMPLX ) then
                        call realloc_array( x%cmplx, n1, n2,            &
                                            fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                        x%data_type = MF_DT_CMPLX
                        if( must_spread ) then
                           x%cmplx(i1,:) = data%cmplx(1,1)
                        else
                           x%cmplx(i1,:) = data%cmplx(1,:)
                        end if
                     end if
                  else if( x%data_type == MF_DT_DBLE ) then
                     if( data%data_type == MF_DT_DBLE ) then
                        call realloc_array( x%double, n1, n2,           &
                                            fill=mf_out_of_range_filling )
                        x%data_type = MF_DT_DBLE
                        if( must_spread ) then
                           x%double(i1,:) = data%double(1,1)
                        else
                           x%double(i1,:) = data%double(1,:)
                        end if
                     else if( data%data_type == MF_DT_CMPLX ) then
                        call realloc_array( x%double, x%cmplx, n1, n2,  &
                                            fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                        x%data_type = MF_DT_CMPLX
                        if( must_spread ) then
                           x%cmplx(i1,:) = data%cmplx(1,1)
                        else
                           x%cmplx(i1,:) = data%cmplx(1,:)
                        end if
                     end if
                  else if( x%data_type == MF_DT_CMPLX ) then
                     call realloc_array( x%cmplx, n1, n2,               &
                                         fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
                     x%data_type = MF_DT_CMPLX
                     if( data%data_type == MF_DT_DBLE ) then
                        if( must_spread ) then
                           x%cmplx(i1,:) = data%double(1,1)
                        else
                           x%cmplx(i1,:) = data%double(1,:)
                        end if
                     else if( data%data_type == MF_DT_CMPLX ) then
                        if( must_spread ) then
                           x%cmplx(i1,:) = data%cmplx(1,1)
                        else
                           x%cmplx(i1,:) = data%cmplx(1,:)
                        end if
                     end if
                  end if

               end if

            else ! matrix x keep the same shape

               if( x%data_type == MF_DT_EMPTY ) then
                  ! this case should have been detected previously;
                  ! here: x%data_type == MF_DT_EMPTY, but with 'shape' /= (0,0)
                  write(STDERR,*) "(MUESLI msSet:) internal ERROR: x%data_type = 0"
                  mf_message_displayed = .true.
                  call muesli_trace( pause="yes" )
                  stop
               else if( x%data_type == MF_DT_DBLE ) then
                  if( data%data_type == MF_DT_DBLE ) then
                     x%data_type = MF_DT_DBLE
                     if( must_spread ) then
                        x%double(i1,:) = data%double(1,1)
                     else
                        x%double(i1,:) = data%double(1,:)
                     end if
                  else if( data%data_type == MF_DT_CMPLX ) then
                     x%data_type = MF_DT_CMPLX
                     allocate( x%cmplx(x%shape(1),x%shape(2)) )

                     x%cmplx(:,:) = x%double(:,:)
                     if( must_spread ) then
                        x%cmplx(i1,:) = data%cmplx(1,1)
                     else
                        x%cmplx(i1,:) = data%cmplx(1,:)
                     end if
                     deallocate( x%double )

                     x%double => null()
                  end if
               else if( x%data_type == MF_DT_CMPLX ) then
                  x%data_type = MF_DT_CMPLX
                  if( data%data_type == MF_DT_DBLE ) then
                     if( must_spread ) then
                        x%cmplx(i1,:) = data%double(1,1)
                     else
                        x%cmplx(i1,:) = data%double(1,:)
                     end if
                  else if( data%data_type == MF_DT_CMPLX ) then
                     if( must_spread ) then
                        x%cmplx(i1,:) = data%cmplx(1,1)
                     else
                        x%cmplx(i1,:) = data%cmplx(1,:)
                     end if
                  end if
               end if
            end if

         else ! data is empty -> we suppress some parts

            if( i1 < 1 .or. x%shape(1) < i1 ) then
               call PrintMessage( "msSet", "E",                         &
                                  "deleting : index out of range!" )
               go to 99
            end if
            if( x%status_restricted ) then
               call PrintMessage( "msSet", "E",                         &
                                  "cannot reshape a restricted array" )
               go to 99
            end if
            ! we suppress the row i1
            tmp = x
            ! computing new size of x
            n1 = x%shape(1) - 1
            if( n1 == 0 ) then
               x = MF_EMPTY
               go to 99
            end if
            x%shape = [ n1, tmp%shape(2) ]
            if( x%data_type == MF_DT_DBLE .or. x%data_type == MF_DT_BOOL ) then
               deallocate( x%double )

               allocate( x%double(n1,tmp%shape(2)) )

               ! affectation
               ii = 0
               do i = 1, tmp%shape(1)
                  if( i == i1 ) cycle
                  ii = ii + 1
                  x%double(ii,:) = tmp%double(i,:)
               end do
            else if( x%data_type == MF_DT_CMPLX ) then
               deallocate( x%cmplx )

               allocate( x%cmplx(n1,tmp%shape(2)) )

               ! affectation
               ii = 0
               do i = 1, tmp%shape(1)
                  if( i == i1 ) cycle
                  ii = ii + 1
                  x%cmplx(ii,:) = tmp%cmplx(i,:)
               end do
            end if
         end if

         call reset_prop(x%prop)

         if( mf_phys_units ) then
            ! verifying the physical dimension
            call verif_adim( x%units, data%units, status )
            if( status /= 0 ) then
               call PrintMessage( "msSet", "E",                         &
                                  "the physical dimensions of the two mfArray's", &
                                  "are not consistent!" )
               go to 99
            end if
         end if

      else
         call PrintMessage( "msSet", "E",                               &
                            "a2 must be equal to MF_COLON ':' or must be", &
                            "an end-index!" )
         go to 99
      end if

 99   continue

      call msSilentRelease(tmp)

      call msFreeArgs( data, a2 )
      call msAutoRelease( data, a2 )

#endif
   end subroutine msSet_array_section_int_colon
!_______________________________________________________________________
!
   subroutine msSet_sprd_r8_vseq_vseq( data, x, seq1, seq2 )

      real(kind=MF_DOUBLE), intent(in) :: data
      type(mfArray) :: x
      type(seq_def) :: seq1, seq2
      !------ API end ------

#ifdef _DEVLP
      ! spreading scalar data (real*8) in array section, described
      ! by two integers vector sequences

      integer, pointer :: i1(:) => null(), i2(:) => null()
      integer :: n1, n2
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         return
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be sparse!" )
         return
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         return
      end if

      n1 = x%shape(1)
      if( seq1%start_1_EndIndex ) then
         seq1%start_1 = n1 + seq1%start_1
      end if
      if( seq1%end_1_EndIndex ) then
         seq1%end_1 = n1 + seq1%end_1
      end if
      if( seq1%start_2_EndIndex ) then
         seq1%start_2 = n1 + seq1%start_2
      end if
      if( seq1%end_2_EndIndex ) then
         seq1%end_2 = n1 + seq1%end_2
      end if
      if( seq1%but_EndIndex ) then
         seq1%but = n1 + seq1%but
      end if
      call build_int_seq( i1, seq1, "msSet" )

      n2 = x%shape(2)
      if( seq2%start_1_EndIndex ) then
         seq2%start_1 = n2 + seq2%start_1
      end if
      if( seq2%end_1_EndIndex ) then
         seq2%end_1 = n2 + seq2%end_1
      end if
      if( seq2%start_2_EndIndex ) then
         seq2%start_2 = n2 + seq2%start_2
      end if
      if( seq2%end_2_EndIndex ) then
         seq2%end_2 = n2 + seq2%end_2
      end if
      if( seq2%but_EndIndex ) then
         seq2%but = n2 + seq2%but
      end if
      call build_int_seq( i2, seq2, "msSet" )

      if( minval(i1) < 1 .or. minval(i2) < 1 ) then
         call PrintMessage( "msSet", "E",                               &
                            "bad value for min of i1 or i2" )
         go to 99
      end if

      if( maxval(i1) > x%shape(1) .or. maxval(i2) > x%shape(2) ) then
         if( x%status_restricted ) then
            call PrintMessage( "msSet", "E",                            &
                               "cannot reshape a restricted array" )
            go to 99
         else
            n1 = max( maxval(i1), x%shape(1) )
            n2 = max( maxval(i2), x%shape(2) )
            x%shape = [ n1, n2 ]
            if( x%data_type == MF_DT_EMPTY ) then
               call realloc_array( x%double, n1, n2,                    &
                                   fill=mf_out_of_range_filling )
               x%data_type = MF_DT_DBLE
               x%double(i1,i2) = data
            else if( x%data_type == MF_DT_DBLE ) then
               call realloc_array( x%double, n1, n2,                    &
                                   fill=mf_out_of_range_filling )
               x%data_type = MF_DT_DBLE
               x%double(i1,i2) = data
            else if( x%data_type == MF_DT_CMPLX ) then
               call realloc_array( x%cmplx, n1, n2,                     &
                                   fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
               x%data_type = MF_DT_CMPLX
               x%cmplx(i1,i2) = data
            end if
         end if
      else
         if( x%data_type == MF_DT_EMPTY ) then
            ! this case should have been detected previously;
            ! here: x%data_type == MF_DT_EMPTY, but with 'shape' /= (0,0)
            write(STDERR,*) "(MUESLI msSet:) internal ERROR: x%data_type = 0"
            mf_message_displayed = .true.
            call muesli_trace( pause="yes" )
            stop
         else if( x%data_type == MF_DT_DBLE ) then
            x%double(i1,i2) = data
         else if( x%data_type == MF_DT_CMPLX ) then
            x%cmplx(i1,i2) = data
         end if
      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            go to 99
         end if
      end if

 99   continue

      if( associated(i1) ) then
#ifndef _TRACE_MEM_ALLOC
         deallocate( i1 )
#else
         call mf_deallocate( array=i1,                                  &
                             file="Set.inc", line="???",                &
                             symb="i1", unit="msSet_sprd_r8_in_vseq_vseq" )
#endif
      end if

      if( associated(i2) ) then
#ifndef _TRACE_MEM_ALLOC
         deallocate( i2 )
#else
         call mf_deallocate( array=i2,                                  &
                             file="Set.inc", line="???",                &
                             symb="i2", unit="msSet_sprd_r8_in_vseq_vseq" )
#endif
      end if

#endif
   end subroutine msSet_sprd_r8_vseq_vseq
!_______________________________________________________________________
!
   subroutine msSet_sprd_r8_int_vseq( data, x, i1, seq2 )

      real(kind=MF_DOUBLE), intent(in) :: data
      type(mfArray) :: x
      integer, intent(in) :: i1
      type(seq_def) :: seq2
      !------ API end ------

#ifdef _DEVLP
      ! spreading scalar data (real*8) in array section, described
      ! by two integers vector sequences

      integer, pointer :: i2(:) => null()
      integer :: n1, n2
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         return
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be sparse!" )
         return
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         return
      end if

      n2 = x%shape(2)
      if( seq2%start_1_EndIndex ) then
         seq2%start_1 = n2 + seq2%start_1
      end if
      if( seq2%end_1_EndIndex ) then
         seq2%end_1 = n2 + seq2%end_1
      end if
      if( seq2%start_2_EndIndex ) then
         seq2%start_2 = n2 + seq2%start_2
      end if
      if( seq2%end_2_EndIndex ) then
         seq2%end_2 = n2 + seq2%end_2
      end if
      if( seq2%but_EndIndex ) then
         seq2%but = n2 + seq2%but
      end if
      call build_int_seq( i2, seq2, "msSet" )

      if( i1 < 1 .or. minval(i2) < 1 ) then
         call PrintMessage( "msSet", "E",                               &
                            "bad value for min of i1 or i2" )
         go to 99
      end if

      if( i1 > x%shape(1) .or. maxval(i2) > x%shape(2) ) then
         if( x%status_restricted ) then
            call PrintMessage( "msSet", "E",                            &
                               "cannot reshape a restricted array" )
            go to 99
         else
            n1 = max( i1, x%shape(1) )
            n2 = max( maxval(i2), x%shape(2) )
            x%shape = [ n1, n2 ]
            if( x%data_type == MF_DT_EMPTY ) then
               call realloc_array( x%double, n1, n2,                    &
                                   fill=mf_out_of_range_filling )
               x%data_type = MF_DT_DBLE
               x%double(i1,i2) = data
            else if( x%data_type == MF_DT_DBLE ) then
               call realloc_array( x%double, n1, n2,                    &
                                   fill=mf_out_of_range_filling )
               x%data_type = MF_DT_DBLE
               x%double(i1,i2) = data
            else if( x%data_type == MF_DT_CMPLX ) then
               call realloc_array( x%cmplx, n1, n2,                     &
                                   fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
               x%data_type = MF_DT_CMPLX
               x%cmplx(i1,i2) = data
            end if
         end if
      else
         if( x%data_type == MF_DT_EMPTY ) then
            ! this case should have been detected previously;
            ! here: x%data_type == MF_DT_EMPTY, but with 'shape' /= (0,0)
            write(STDERR,*) "(MUESLI msSet:) internal ERROR: x%data_type = 0"
            mf_message_displayed = .true.
            call muesli_trace( pause="yes" )
            stop
         else if( x%data_type == MF_DT_DBLE ) then
            x%double(i1,i2) = data
         else if( x%data_type == MF_DT_CMPLX ) then
            x%cmplx(i1,i2) = data
         end if
      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            go to 99
         end if
      end if

 99   continue

      if( associated(i2) ) then
#ifndef _TRACE_MEM_ALLOC
         deallocate( i2 )
#else
         call mf_deallocate( array=i2,                                  &
                             file="Set.inc", line="???",                &
                             symb="i2", unit="msSet_sprd_r8_in_int_vseq" )
#endif
      end if

#endif
   end subroutine msSet_sprd_r8_int_vseq
!_______________________________________________________________________
!
   subroutine msSet_sprd_r8_vseq_int( data, x, seq1, i2 )

      real(kind=MF_DOUBLE), intent(in) :: data
      type(mfArray) :: x
      type(seq_def) :: seq1
      integer, intent(in) :: i2
      !------ API end ------

#ifdef _DEVLP
      ! spreading scalar data (real*8) in array section, described
      ! by two integers vector sequences

      integer, pointer :: i1(:) => null()
      integer :: n1, n2
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         return
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be sparse!" )
         return
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         return
      end if

      n1 = x%shape(1)
      if( seq1%start_1_EndIndex ) then
         seq1%start_1 = n1 + seq1%start_1
      end if
      if( seq1%end_1_EndIndex ) then
         seq1%end_1 = n1 + seq1%end_1
      end if
      if( seq1%start_2_EndIndex ) then
         seq1%start_2 = n1 + seq1%start_2
      end if
      if( seq1%end_2_EndIndex ) then
         seq1%end_2 = n1 + seq1%end_2
      end if
      if( seq1%but_EndIndex ) then
         seq1%but = n1 + seq1%but
      end if
      call build_int_seq( i1, seq1, "msSet" )

      if( minval(i1) < 1 .or. i2 < 1 ) then
         call PrintMessage( "msSet", "E",                               &
                            "bad value for min of i1 or i2" )
         go to 99
      end if

      if( maxval(i1) > x%shape(1) .or. i2 > x%shape(2) ) then
         if( x%status_restricted ) then
            call PrintMessage( "msSet", "E",                            &
                               "cannot reshape a restricted array" )
            go to 99
         else
            n1 = max( maxval(i1), x%shape(1) )
            n2 = max( i2, x%shape(2) )
            x%shape = [ n1, n2 ]
            if( x%data_type == MF_DT_EMPTY ) then
               call realloc_array( x%double, n1, n2,                    &
                                   fill=mf_out_of_range_filling )
               x%data_type = MF_DT_DBLE
               x%double(i1,i2) = data
            else if( x%data_type == MF_DT_DBLE ) then
               call realloc_array( x%double, n1, n2,                    &
                                   fill=mf_out_of_range_filling )
               x%data_type = MF_DT_DBLE
               x%double(i1,i2) = data
            else if( x%data_type == MF_DT_CMPLX ) then
               call realloc_array( x%cmplx, n1, n2,                     &
                                   fill=cmplx(mf_out_of_range_filling,mf_out_of_range_filling,kind=MF_DOUBLE) )
               x%data_type = MF_DT_CMPLX
               x%cmplx(i1,i2) = data
            end if
         end if
      else
         if( x%data_type == MF_DT_EMPTY ) then
            ! this case should have been detected previously;
            ! here: x%data_type == MF_DT_EMPTY, but with 'shape' /= (0,0)
            write(STDERR,*) "(MUESLI msSet:) internal ERROR: x%data_type = 0"
            mf_message_displayed = .true.
            call muesli_trace( pause="yes" )
            stop
         else if( x%data_type == MF_DT_DBLE ) then
            x%double(i1,i2) = data
         else if( x%data_type == MF_DT_CMPLX ) then
            x%cmplx(i1,i2) = data
         end if
      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            go to 99
         end if
      end if

 99   continue

      if( associated(i1) ) then
#ifndef _TRACE_MEM_ALLOC
         deallocate( i1 )
#else
         call mf_deallocate( array=i1,                                  &
                             file="Set.inc", line="???",                &
                             symb="i1", unit="msSet_sprd_r8_in_vseq_int" )
#endif
      end if

#endif
   end subroutine msSet_sprd_r8_vseq_int
!_______________________________________________________________________
!
   subroutine msSet_r8_array_array( data, x, a1, a2 )

      real(kind=MF_DOUBLE), intent(in) :: data
      type(mfArray) :: x
      type(mfArray) :: a1, a2
      !------ API end ------

#ifdef _DEVLP
      ! take into account only the following case:
      !
      !   * scalar real*8        data
      !   * DENSE, REAL mfArray  x
      !   * EndIndex             a1, a2

      integer :: n1, n2, i1, i2
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      call msInitArgs( a1, a2 )

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         go to 99
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be sparse!" )
         go to 99
      end if

      if( mfIsEmpty(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be empty!" )
         go to 99
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( x%data_type == MF_DT_CMPLX ) then
         call PrintMessage( "msSet", "E",                               &
                            "please use complex data in a complex mfArray!" )
         go to 99
      end if

      if( isEndIndex(a1) ) then

         n1 = x%shape(1)
         i1 = n1 + a1%crc
         if( i1 < 1 .or. n1 < i1 ) then
            call PrintMessage( "msSet", "E",                            &
                               "End-index 'a1' is out of range!" )
            go to 99
         end if

      else

         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'a1' must be an End-index!" )
         go to 99

      end if

      if( isEndIndex(a2) ) then

         n2 = x%shape(2)
         i2 = n2 + a2%crc
         if( i2 < 1 .or. n2 < i2 ) then
            call PrintMessage( "msSet", "E",                            &
                               "End-index 'a2' is out of range!" )
            go to 99
         end if

      else

         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'a2' must be an End-index!" )
         go to 99

      end if

      if( x%data_type == MF_DT_DBLE ) then
         x%double(i1,i2) = data
      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            go to 99
         end if
      end if

 99   continue

      call msFreeArgs( a1, a2 )
      call msAutoRelease( a1, a2 )

#endif
   end subroutine msSet_r8_array_array
!_______________________________________________________________________
!
   subroutine msSet_cmplx_array_array( data, x, a1, a2 )

      complex(kind=MF_DOUBLE), intent(in) :: data
      type(mfArray) :: x
      type(mfArray) :: a1, a2
      !------ API end ------

#ifdef _DEVLP
      ! take into account only the following case:
      !
      !   * scalar complex*8     data
      !   * DENSE, REAL mfArray  x
      !   * EndIndex             a1, a2

      integer :: n1, n2, i1, i2
      integer :: status

   !------ end of declarations -- execution starts hereafter  ------

      if( x%parameter ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot change mfArray 'x'!",               &
                            "it is a protected array (pseudo-parameter)." )
         return
      end if

      call msInitArgs( a1, a2 )

      if( x%status_temporary ) then
         call PrintMessage( "msSet", "E",                               &
                            "it makes no sense to work in a tempo!",    &
                            "(moreover, the tempo will not be freed)" )
         go to 99
      end if

      if( mfIsSparse(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be sparse!" )
         go to 99
      end if

      if( mfIsEmpty(x) ) then
         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'x' cannot be empty!" )
         go to 99
      end if

      if( x%data_type == MF_DT_BOOL ) then
         call PrintMessage( "msSet", "E",                               &
                            "cannot setting item in a logical mfArray!", &
                            "(not yet available)" )
         go to 99
      end if

      if( x%data_type == MF_DT_DBLE ) then
         call PrintMessage( "msSet", "E",                               &
                            "please use real data in a real mfArray!" )
         go to 99
      end if

      if( isEndIndex(a1) ) then

         n1 = x%shape(1)
         i1 = n1 + a1%crc
         if( i1 < 1 .or. n1 < i1 ) then
            call PrintMessage( "msSet", "E",                            &
                               "End-index 'a1' is out of range!" )
            go to 99
         end if

      else

         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'a1' must be an End-index!" )
         go to 99

      end if

      if( isEndIndex(a2) ) then

         n2 = x%shape(2)
         i2 = n2 + a2%crc
         if( i2 < 1 .or. n2 < i2 ) then
            call PrintMessage( "msSet", "E",                            &
                               "End-index 'a2' is out of range!" )
            go to 99
         end if

      else

         call PrintMessage( "msSet", "E",                               &
                            "mfArray 'a2' must be an End-index!" )
         go to 99

      end if

      if( x%data_type == MF_DT_CMPLX ) then
         x%cmplx(i1,i2) = data
      end if

      call reset_prop(x%prop)

      if( mf_phys_units ) then
         ! verifying the physical dimension
         call verif_adim( x%units, status=status )
         if( status /= 0 ) then
            call PrintMessage( "msSet", "E",                            &
                               "the physical unit of the mfArray",      &
                               "must be dimensionless!" )
            go to 99
         end if
      end if

 99   continue

      call msFreeArgs( a1, a2 )
      call msAutoRelease( a1, a2 )

#endif
   end subroutine msSet_cmplx_array_array
