! f90 include file

!_______________________________________________________________________
!
   subroutine msDisplay_mf_Real_List_vec( x, string )

      type(mf_Real_List), intent(in)           :: x(:)
      character(len=*),   intent(in), optional :: string
      !------ API end ------

#ifdef _DEVLP
      character(len=10), parameter :: fmt = "(G0.5)"

      integer :: m, n, ncol_shell
      character(len=1024) :: line
      character(len=20) :: str_tmp
      integer :: i, j, l, len_number

   !------ end of declarations -- execution starts hereafter  ------

      if( present(string) ) then
         write(STDOUT,"()")
         write(STDOUT,*) trim(string), " ="
      end if
      write(STDOUT,"()")

      ncol_shell = mfGetTermWidth()

      m = size(x)

      do i = 1, m

         write(str_tmp,"(2X,I0,':')") i
         len_number = len_trim(str_tmp)
         line = trim(str_tmp)
         l = len_number

         if( allocated(x(i)%list) ) then
            n = size(x(i)%list)
         else
            n = 0
         end if

         if( n == 0 ) then
            write(str_tmp,"(A)") "  <EMPTY>"
            line = trim(line) // trim(str_tmp)
            write(STDOUT,"(A)") trim(line)
            write(STDOUT,"()")
            cycle
         end if

         j = 1
         do
            ! filling 'line' up to its end
            write(str_tmp,fmt) x(i)%list(j)
            len_number = len_trim(str_tmp)
            if( l+len_number+2+4 > ncol_shell ) then
               line(ncol_shell-3:ncol_shell) = " ..."
               write(STDOUT,"(A)") trim(line)
               line = ""
               l = 4
            end if
            line = line(1:l) // "  " // trim(str_tmp)
            l = l + len_number + 2
            j = j + 1
            if( j > n ) exit
         end do
         ! flush the remain of the numbers
         write(STDOUT,"(A)") trim(line)
         write(STDOUT,"()")

      end do

#endif
   end subroutine msDisplay_mf_Real_List_vec
