! f90 include file

!_______________________________________________________________________
!
   subroutine msDisplay_mf_Real_List( x, string )

      type(mf_Real_List), intent(in)           :: x
      character(len=*),   intent(in), optional :: string
      !------ API end ------

#ifdef _DEVLP
      character(len=10), parameter :: fmt = "(G0.5)"

      integer :: n, ncol_shell
      character(len=1024) :: line
      character(len=20) :: str_tmp
      integer :: j, l, len_number

   !------ end of declarations -- execution starts hereafter  ------

      if( present(string) ) then
         write(STDOUT,"()")
         write(STDOUT,*) trim(string), " ="
      end if
      write(STDOUT,"()")

      if( allocated(x%list) ) then
         n = size(x%list)
      else
         n = 0
      end if

      if( n == 0 ) then
         write(STDOUT,*)  " <EMPTY>"
         go to 99
      end if

      ncol_shell = mfGetTermWidth()
      line = ""
      l = 0
      j = 1
      do
         ! filling 'line' up to its end
         write(str_tmp,fmt) x%list(j)
         len_number = len_trim(str_tmp)
         if( l+len_number+2+4 > ncol_shell ) then
            line(ncol_shell-3:ncol_shell) = " ..."
            write(STDOUT,"(A)") trim(line)
            line = ""
            l = 0
         end if
         line = trim(line) // "  " // trim(str_tmp)
         l = l + len_number + 2
         j = j + 1
         if( j > n ) exit
      end do
      ! flush the remain of the numbers
      write(STDOUT,"(A)") trim(line)

 99   continue

      write(STDOUT,"()")

#endif
   end subroutine msDisplay_mf_Real_List
